/*
 * Decompiled with CFR 0.152.
 */
package beansoft.jsp;

public class PageControl {
    private int pageCount;
    private boolean hasPrevPage;
    private int recordCount;
    private boolean hasNextPage;
    private int maxPage;
    private int currentPage;

    private void calculate() {
        if (this.getPageCount() == 0) {
            this.setPageCount(1);
        }
        this.maxPage = (int)Math.ceil(1.0 * (double)this.getRecordCount() / (double)this.getPageCount());
        if (this.maxPage == 0) {
            this.maxPage = 1;
        }
        if (this.currentPage > this.maxPage) {
            this.currentPage = this.maxPage;
        }
        this.hasNextPage = this.currentPage < this.maxPage;
        this.hasPrevPage = this.currentPage > 1;
    }

    public int getMaxPage() {
        this.calculate();
        return this.maxPage;
    }

    private void setMaxPage(int maxPage) {
        this.maxPage = maxPage;
    }

    public boolean hasPrevPage() {
        this.calculate();
        return this.hasPrevPage;
    }

    public boolean hasNextPage() {
        this.calculate();
        return this.hasNextPage;
    }

    public static void main(String[] args) {
        PageControl pc = new PageControl();
        pc.setCurrentPage(0);
        pc.setPageCount(5);
        pc.setRecordCount(7);
        System.out.println("\u5f53\u524d\u9875 " + pc.getCurrentPage());
        System.out.println("\u6709\u4e0a\u4e00\u9875 " + pc.hasPrevPage());
        System.out.println("\u6709\u4e0b\u4e00\u9875 " + pc.hasNextPage());
        System.out.println("\u6700\u5927\u9875\u9762\u6570 " + pc.getMaxPage());
    }

    public int getCurrentPage() {
        return this.currentPage;
    }

    public void setCurrentPage(int currentPage) {
        if (currentPage <= 0) {
            currentPage = 1;
        }
        this.currentPage = currentPage;
    }

    public int getRecordCount() {
        return this.recordCount;
    }

    public void setRecordCount(int property1) {
        this.recordCount = property1;
    }

    public int getPageCount() {
        return this.pageCount;
    }

    public void setPageCount(int pageCount) {
        this.pageCount = pageCount;
    }
}

