/*
	Copyright (c) 2004-2006, The Dojo Foundation
	All Rights Reserved.

	Licensed under the Academic Free License version 2.1 or above OR the
	modified BSD license. For more information on Dojo licensing, see:

		http://dojotoolkit.org/community/licensing.shtml
*/

/*
	This is a compiled version of Dojo, built for deployment and not for
	development. To get an editable version, please visit:

		http://dojotoolkit.org

	for documentation and information on getting the source.
*/

if(typeof dojo=="undefined"){
var dj_global=this;
var dj_currentContext=this;
function dj_undef(_1,_2){
return (typeof (_2||dj_currentContext)[_1]=="undefined");
}
if(dj_undef("djConfig",this)){
var djConfig={};
}
if(dj_undef("dojo",this)){
var dojo={};
}
dojo.global=function(){
return dj_currentContext;
};
dojo.locale=djConfig.locale;
dojo.version={major:0,minor:0,patch:0,flag:"dev",revision:Number("$Rev: 7460 $".match(/[0-9]+/)[0]),toString:function(){
with(dojo.version){
return major+"."+minor+"."+patch+flag+" ("+revision+")";
}
}};
dojo.getObject=function(_3,_4,_5,_6){
var _7,_8;
if(typeof _3!="string"){
return undefined;
}
_7=_5;
if(!_7){
_7=dojo.global();
}
var _9=_3.split("."),i=0,_b,_c,_d;
do{
_b=_7;
_d=_9[i];
_c=_7[_9[i]];
if((_4)&&(!_c)){
_c=_7[_9[i]]={};
}
_7=_c;
i++;
}while(i<_9.length&&_7);
_8=_7;
_7=_b;
return (_6)?{obj:_7,prop:_d}:_8;
};
dojo.exists=function(_e,_f){
if(typeof _f=="string"){
dojo.deprecated("dojo.exists(obj, name)","use dojo.exists(name, obj, /*optional*/create)","0.6");
var tmp=_e;
_e=_f;
_f=tmp;
}
return (!!dojo.getObject(_e,false,_f));
};
dojo.evalProp=function(_11,_12,_13){
dojo.deprecated("dojo.evalProp","just use hash syntax. Sheesh.","0.6");
return _12[_11]||(_13?(_12[_11]={}):undefined);
};
dojo.parseObjPath=function(_14,_15,_16){
dojo.deprecated("dojo.parseObjPath","use dojo.getObject(path, create, context, true)","0.6");
return dojo.getObject(_14,_16,_15,true);
};
dojo.evalObjPath=function(_17,_18){
dojo.deprecated("dojo.evalObjPath","use dojo.getObject(path, create)","0.6");
return dojo.getObject(_17,_18);
};
dojo.errorToString=function(_19){
return (_19["message"]||_19["description"]||_19);
};
dojo.raise=function(_1a,_1b){
if(_1b){
_1a=_1a+": "+dojo.errorToString(_1b);
}else{
_1a=dojo.errorToString(_1a);
}
try{
if(djConfig.isDebug){
dojo.hostenv.println("FATAL exception raised: "+_1a);
}
}
catch(e){
}
throw _1b||Error(_1a);
};
dojo.debug=function(){
};
dojo.debugShallow=function(obj){
};
dojo.profile={start:function(){
},end:function(){
},stop:function(){
},dump:function(){
}};
function dj_eval(_1d){
return dj_global.eval?dj_global.eval(_1d):eval(_1d);
}
dojo.unimplemented=function(_1e,_1f){
var _20="'"+_1e+"' not implemented";
if(_1f!=null){
_20+=" "+_1f;
}
dojo.raise(_20);
};
dojo.deprecated=function(_21,_22,_23){
var _24="DEPRECATED: "+_21;
if(_22){
_24+=" "+_22;
}
if(_23){
_24+=" -- will be removed in version: "+_23;
}
dojo.debug(_24);
};
dojo.render=(function(){
function vscaffold(_25,_26){
var tmp={capable:false,support:{builtin:false,plugin:false},prefixes:_25};
for(var i=0;i<_26.length;i++){
tmp[_26[i]]=false;
}
return tmp;
}
return {name:"",ver:dojo.version,os:{win:false,linux:false,osx:false},html:vscaffold(["html"],["ie","opera","khtml","safari","moz"]),svg:vscaffold(["svg"],["corel","adobe","batik"]),vml:vscaffold(["vml"],["ie"]),swf:vscaffold(["Swf","Flash","Mm"],["mm"]),swt:vscaffold(["Swt"],["ibm"])};
})();
dojo.hostenv=(function(){
var _29={isDebug:false,allowQueryConfig:false,baseScriptUri:"",baseRelativePath:"",libraryScriptUri:"",iePreventClobber:false,ieClobberMinimal:true,preventBackButtonFix:true,delayMozLoadingFix:false,searchIds:[],parseWidgets:true};
if(typeof djConfig=="undefined"){
djConfig=_29;
}else{
for(var _2a in _29){
if(typeof djConfig[_2a]=="undefined"){
djConfig[_2a]=_29[_2a];
}
}
}
return {name_:"(unset)",version_:"(unset)",getName:function(){
return this.name_;
},getVersion:function(){
return this.version_;
},getText:function(uri){
dojo.unimplemented("getText","uri="+uri);
}};
})();
dojo.hostenv.getBaseScriptUri=function(){
if(djConfig.baseScriptUri.length){
return djConfig.baseScriptUri;
}
var uri=new String(djConfig.libraryScriptUri||djConfig.baseRelativePath);
if(!uri){
dojo.raise("Nothing returned by getLibraryScriptUri(): "+uri);
}
djConfig.baseScriptUri=djConfig.baseRelativePath;
return djConfig.baseScriptUri;
};
(function(){
var _2d={pkgFileName:"__package__",loading_modules_:{},loaded_modules_:{},addedToLoadingCount:[],removedFromLoadingCount:[],inFlightCount:0,modulePrefixes_:{dojo:{name:"dojo",value:"src"}},registerModulePath:function(_2e,_2f){
this.modulePrefixes_[_2e]={name:_2e,value:_2f};
},moduleHasPrefix:function(_30){
var mp=this.modulePrefixes_;
return Boolean(mp[_30]&&mp[_30].value);
},getModulePrefix:function(_32){
if(this.moduleHasPrefix(_32)){
return this.modulePrefixes_[_32].value;
}
return _32;
},getTextStack:[],loadUriStack:[],loadedUris:[],post_load_:false,modulesLoadedListeners:[],unloadListeners:[],loadNotifying:false};
for(var _33 in _2d){
dojo.hostenv[_33]=_2d[_33];
}
})();
dojo.hostenv.loadPath=function(_34,_35,cb){
var uri;
if(_34.charAt(0)=="/"||_34.match(/^\w+:/)){
uri=_34;
}else{
uri=this.getBaseScriptUri()+_34;
}
if(djConfig.cacheBust&&dojo.render.html.capable){
uri+="?"+String(djConfig.cacheBust).replace(/\W+/g,"");
}
try{
return !_35?this.loadUri(uri,cb):this.loadUriAndCheck(uri,_35,cb);
}
catch(e){
dojo.debug(e);
return false;
}
};
dojo.hostenv.loadUri=function(uri,cb){
if(this.loadedUris[uri]){
return true;
}
var _3a=this.getText(uri,null,true);
if(!_3a){
return false;
}
this.loadedUris[uri]=true;
if(cb){
_3a="("+_3a+")";
}
var _3b=dj_eval(_3a);
if(cb){
cb(_3b);
}
return true;
};
dojo.hostenv.loadUriAndCheck=function(uri,_3d,cb){
var ok=true;
try{
ok=this.loadUri(uri,cb);
}
catch(e){
dojo.debug("failed loading ",uri," with error: ",e);
}
return Boolean(ok&&this.findModule(_3d,false));
};
dojo.loaded=function(){
};
dojo.unloaded=function(){
};
dojo.hostenv.loaded=function(){
this.loadNotifying=true;
this.post_load_=true;
var mll=this.modulesLoadedListeners;
for(var x=0;x<mll.length;x++){
mll[x]();
}
this.modulesLoadedListeners=[];
this.loadNotifying=false;
dojo.loaded();
};
dojo.hostenv.unloaded=function(){
var mll=this.unloadListeners;
while(mll.length){
(mll.pop())();
}
dojo.unloaded();
};
dojo.addOnLoad=function(obj,_44){
var dh=dojo.hostenv;
if(arguments.length==1){
dh.modulesLoadedListeners.push(obj);
}else{
if(arguments.length>1){
dh.modulesLoadedListeners.push(function(){
obj[_44]();
});
}
}
if(dh.post_load_&&dh.inFlightCount==0&&!dh.loadNotifying){
dh.callLoaded();
}
};
dojo.addOnUnload=function(obj,_47){
var dh=dojo.hostenv;
if(arguments.length==1){
dh.unloadListeners.push(obj);
}else{
if(arguments.length>1){
dh.unloadListeners.push(function(){
obj[_47]();
});
}
}
};
dojo.hostenv.modulesLoaded=function(){
if(this.post_load_){
return;
}
if(this.loadUriStack.length==0&&this.getTextStack.length==0){
if(this.inFlightCount>0){
dojo.debug("files still in flight!");
return;
}
dojo.hostenv.callLoaded();
}
};
dojo.hostenv.callLoaded=function(){
if(typeof setTimeout=="object"||(djConfig["useXDomain"]&&dojo.render.html.opera)){
setTimeout("dojo.hostenv.loaded();",0);
}else{
dojo.hostenv.loaded();
}
};
dojo.hostenv.getModuleSymbols=function(_49){
var _4a=_49.split(".");
for(var i=_4a.length;i>0;i--){
var _4c=_4a.slice(0,i).join(".");
if((i==1)&&!this.moduleHasPrefix(_4c)){
_4a[0]="../"+_4a[0];
}else{
var _4d=this.getModulePrefix(_4c);
if(_4d!=_4c){
_4a.splice(0,i,_4d);
break;
}
}
}
return _4a;
};
dojo.hostenv._global_omit_module_check=false;
dojo.hostenv.loadModule=function(_4e,_4f,_50){
if(!_4e){
return;
}
_50=this._global_omit_module_check||_50;
var _51=this.findModule(_4e,false);
if(_51){
return _51;
}
if(dj_undef(_4e,this.loading_modules_)){
this.addedToLoadingCount.push(_4e);
}
this.loading_modules_[_4e]=1;
var _52=_4e.replace(/\./g,"/")+".js";
var _53=_4e.split(".");
var _54=this.getModuleSymbols(_4e);
var _55=((_54[0].charAt(0)!="/")&&!_54[0].match(/^\w+:/));
var _56=_54[_54.length-1];
var ok;
if(_56=="*"){
_4e=_53.slice(0,-1).join(".");
while(_54.length){
_54.pop();
_54.push(this.pkgFileName);
_52=_54.join("/")+".js";
if(_55&&_52.charAt(0)=="/"){
_52=_52.slice(1);
}
ok=this.loadPath(_52,!_50?_4e:null);
if(ok){
break;
}
_54.pop();
}
}else{
_52=_54.join("/")+".js";
_4e=_53.join(".");
var _58=!_50?_4e:null;
ok=this.loadPath(_52,_58);
if(!ok&&!_4f){
_54.pop();
while(_54.length){
_52=_54.join("/")+".js";
ok=this.loadPath(_52,_58);
if(ok){
break;
}
_54.pop();
_52=_54.join("/")+"/"+this.pkgFileName+".js";
if(_55&&_52.charAt(0)=="/"){
_52=_52.slice(1);
}
ok=this.loadPath(_52,_58);
if(ok){
break;
}
}
}
if(!ok&&!_50){
dojo.raise("Could not load '"+_4e+"'; last tried '"+_52+"'");
}
}
if(!_50&&!this["isXDomain"]){
_51=this.findModule(_4e,false);
if(!_51){
dojo.raise("symbol '"+_4e+"' is not defined after loading '"+_52+"'");
}
}
return _51;
};
dojo.hostenv.startPackage=function(_59){
var _5a=String(_59);
var _5b=_5a;
var _5c=_59.split(/\./);
if(_5c[_5c.length-1]=="*"){
_5c.pop();
_5b=_5c.join(".");
}
var _5d=dojo.getObject(_5b,true);
this.loaded_modules_[_5a]=_5d;
this.loaded_modules_[_5b]=_5d;
return _5d;
};
dojo.hostenv.findModule=function(_5e,_5f){
var lmn=String(_5e);
if(this.loaded_modules_[lmn]){
return this.loaded_modules_[lmn];
}
if(_5f){
dojo.raise("no loaded module named '"+_5e+"'");
}
return null;
};
dojo.kwCompoundRequire=function(_61){
var _62=_61["common"]||[];
var _63=_62.concat(_61[dojo.hostenv.name_]||_61["default"]||[]);
for(var x=0;x<_63.length;x++){
var _65=_63[x];
if(_65.constructor==Array){
dojo.hostenv.loadModule.apply(dojo.hostenv,_65);
}else{
dojo.hostenv.loadModule(_65);
}
}
};
dojo.require=function(_66){
dojo.hostenv.loadModule.apply(dojo.hostenv,arguments);
};
dojo.requireIf=function(_67,_68){
var _69=arguments[0];
if((_69===true)||(_69=="common")||(_69&&dojo.render[_69].capable)){
var _6a=[];
for(var i=1;i<arguments.length;i++){
_6a.push(arguments[i]);
}
dojo.require.apply(dojo,_6a);
}
};
dojo.requireAfterIf=dojo.requireIf;
dojo.provide=function(_6c){
return dojo.hostenv.startPackage.apply(dojo.hostenv,arguments);
};
dojo.registerModulePath=function(_6d,_6e){
return dojo.hostenv.registerModulePath(_6d,_6e);
};
if(djConfig["modulePaths"]){
for(var param in djConfig["modulePaths"]){
dojo.registerModulePath(param,djConfig["modulePaths"][param]);
}
}
dojo.requireLocalization=function(_6f,_70,_71,_72){
dojo.require("dojo.i18n.loader");
dojo.i18n._requireLocalization.apply(dojo.hostenv,arguments);
};
}
if(typeof window!="undefined"){
(function(){
if(djConfig.allowQueryConfig){
var _73=document.location.toString();
var _74=_73.split("?",2);
if(_74.length>1){
var _75=_74[1];
var _76=_75.split("&");
for(var x in _76){
var sp=_76[x].split("=");
if((sp[0].length>9)&&(sp[0].substr(0,9)=="djConfig.")){
var opt=sp[0].substr(9);
try{
djConfig[opt]=eval(sp[1]);
}
catch(e){
djConfig[opt]=sp[1];
}
}
}
}
}
if(((djConfig["baseScriptUri"]=="")||(djConfig["baseRelativePath"]==""))&&(document&&document.getElementsByTagName)){
var _7a=document.getElementsByTagName("script");
var _7b=/(__package__|dojo|bootstrap1)\.js([\?\.]|$)/i;
for(var i=0;i<_7a.length;i++){
var src=_7a[i].getAttribute("src");
if(!src){
continue;
}
var m=src.match(_7b);
if(m){
var _7f=src.substring(0,m.index);
if(src.indexOf("bootstrap1")>-1){
_7f+="../";
}
if(!this["djConfig"]){
djConfig={};
}
if(djConfig["baseScriptUri"]==""){
djConfig["baseScriptUri"]=_7f;
}
if(djConfig["baseRelativePath"]==""){
djConfig["baseRelativePath"]=_7f;
}
break;
}
}
}
var dr=dojo.render;
var drh=dojo.render.html;
var drs=dojo.render.svg;
var dua=(drh.UA=navigator.userAgent);
var dav=(drh.AV=navigator.appVersion);
var t=true;
var f=false;
drh.capable=t;
drh.support.builtin=t;
dr.ver=parseFloat(drh.AV);
dr.os.mac=dav.indexOf("Macintosh")>=0;
dr.os.win=dav.indexOf("Windows")>=0;
dr.os.linux=dav.indexOf("X11")>=0;
drh.opera=dua.indexOf("Opera")>=0;
drh.khtml=(dav.indexOf("Konqueror")>=0)||(dav.indexOf("Safari")>=0);
drh.safari=dav.indexOf("Safari")>=0;
var _87=dua.indexOf("Gecko");
drh.mozilla=drh.moz=(_87>=0)&&(!drh.khtml);
if(drh.mozilla){
drh.geckoVersion=dua.substring(_87+6,_87+14);
}
drh.ie=(document.all)&&(!drh.opera);
drh.ie50=drh.ie&&dav.indexOf("MSIE 5.0")>=0;
drh.ie55=drh.ie&&dav.indexOf("MSIE 5.5")>=0;
drh.ie60=drh.ie&&dav.indexOf("MSIE 6.0")>=0;
drh.ie70=drh.ie&&dav.indexOf("MSIE 7.0")>=0;
var cm=document["compatMode"];
drh.quirks=(cm=="BackCompat")||(cm=="QuirksMode")||drh.ie55||drh.ie50;
dojo.locale=dojo.locale||(drh.ie?navigator.userLanguage:navigator.language).toLowerCase();
dr.vml.capable=drh.ie;
drs.capable=f;
drs.support.plugin=f;
drs.support.builtin=f;
var _89=window["document"];
var tdi=_89["implementation"];
if((tdi)&&(tdi["hasFeature"])&&(tdi.hasFeature("org.w3c.dom.svg","1.0"))){
drs.capable=t;
drs.support.builtin=t;
drs.support.plugin=f;
}
if(drh.safari){
var tmp=dua.split("AppleWebKit/")[1];
var ver=parseFloat(tmp.split(" ")[0]);
if(ver>=420){
drs.capable=t;
drs.support.builtin=t;
drs.support.plugin=f;
}
}else{
}
})();
dojo.hostenv.startPackage("dojo.hostenv");
dojo.render.name=dojo.hostenv.name_="browser";
dojo.hostenv.searchIds=[];
dojo.hostenv._XMLHTTP_PROGIDS=["Msxml2.XMLHTTP","Microsoft.XMLHTTP","Msxml2.XMLHTTP.4.0"];
dojo.hostenv.getXmlhttpObject=function(){
var _8d=null;
var _8e=null;
try{
_8d=new XMLHttpRequest();
}
catch(e){
}
if(!_8d){
for(var i=0;i<3;++i){
var _90=dojo.hostenv._XMLHTTP_PROGIDS[i];
try{
_8d=new ActiveXObject(_90);
}
catch(e){
_8e=e;
}
if(_8d){
dojo.hostenv._XMLHTTP_PROGIDS=[_90];
break;
}
}
}
if(!_8d){
return dojo.raise("XMLHTTP not available",_8e);
}
return _8d;
};
dojo.hostenv._blockAsync=false;
dojo.hostenv.getText=function(uri,_92,_93){
if(!_92){
this._blockAsync=true;
}
var _94=this.getXmlhttpObject();
function isDocumentOk(_95){
var _96=_95["status"];
return Boolean((!_96)||((200<=_96)&&(300>_96))||(_96==304));
}
if(_92){
var _97=this,_98=null,gbl=dojo.global();
var xhr=dojo.getObject("dojo.io.XMLHTTPTransport");
_94.onreadystatechange=function(){
if(_98){
gbl.clearTimeout(_98);
_98=null;
}
if(_97._blockAsync||(xhr&&xhr._blockAsync)){
_98=gbl.setTimeout(function(){
_94.onreadystatechange.apply(this);
},10);
}else{
if(4==_94.readyState){
if(isDocumentOk(_94)){
_92(_94.responseText);
}
}
}
};
}
_94.open("GET",uri,_92?true:false);
try{
_94.send(null);
if(_92){
return null;
}
if(!isDocumentOk(_94)){
var err=Error("Unable to load "+uri+" status:"+_94.status);
err.status=_94.status;
err.responseText=_94.responseText;
throw err;
}
}
catch(e){
this._blockAsync=false;
if((_93)&&(!_92)){
return null;
}else{
throw e;
}
}
this._blockAsync=false;
return _94.responseText;
};
dojo.hostenv.defaultDebugContainerId="dojoDebug";
dojo.hostenv._println_buffer=[];
dojo.hostenv._println_safe=false;
dojo.hostenv.println=function(_9c){
if(!dojo.hostenv._println_safe){
dojo.hostenv._println_buffer.push(_9c);
}else{
try{
var _9d=document.getElementById(djConfig.debugContainerId?djConfig.debugContainerId:dojo.hostenv.defaultDebugContainerId);
if(!_9d){
_9d=dojo.body();
}
var div=document.createElement("div");
div.appendChild(document.createTextNode(_9c));
_9d.appendChild(div);
}
catch(e){
try{
document.write("<div>"+_9c+"</div>");
}
catch(e2){
window.status=_9c;
}
}
}
};
dojo.addOnLoad(function(){
dojo.hostenv._println_safe=true;
while(dojo.hostenv._println_buffer.length>0){
dojo.hostenv.println(dojo.hostenv._println_buffer.shift());
}
});
function dj_addNodeEvtHdlr(_9f,_a0,fp){
var _a2=_9f["on"+_a0]||function(){
};
_9f["on"+_a0]=function(){
fp.apply(_9f,arguments);
_a2.apply(_9f,arguments);
};
return true;
}
dojo.hostenv._djInitFired=false;
function dj_load_init(e){
dojo.hostenv._djInitFired=true;
var _a4=(e&&e.type)?e.type.toLowerCase():"load";
if(arguments.callee.initialized||(_a4!="domcontentloaded"&&_a4!="load")){
return;
}
arguments.callee.initialized=true;
if(typeof (_timer)!="undefined"){
clearInterval(_timer);
delete _timer;
}
var _a5=function(){
if(dojo.render.html.ie){
dojo.hostenv.makeWidgets();
}
};
if(dojo.hostenv.inFlightCount==0){
_a5();
dojo.hostenv.modulesLoaded();
}else{
dojo.hostenv.modulesLoadedListeners.unshift(_a5);
}
}
if(document.addEventListener){
if(dojo.render.html.opera||(dojo.render.html.moz&&(djConfig["enableMozDomContentLoaded"]===true))){
document.addEventListener("DOMContentLoaded",dj_load_init,null);
}
window.addEventListener("load",dj_load_init,null);
}
if(dojo.render.html.ie&&dojo.render.os.win){
document.write("<scr"+"ipt defer src=\"//:\" "+"onreadystatechange=\"if(this.readyState=='complete'){dj_load_init();}\">"+"</scr"+"ipt>");
}
if(/(WebKit|khtml)/i.test(navigator.userAgent)){
var _timer=setInterval(function(){
if(/loaded|complete/.test(document.readyState)){
dj_load_init();
}
},10);
}
if(dojo.render.html.ie){
dj_addNodeEvtHdlr(window,"beforeunload",function(){
dojo.hostenv._unloading=true;
window.setTimeout(function(){
dojo.hostenv._unloading=false;
},0);
});
}
dj_addNodeEvtHdlr(window,"unload",function(){
if((!dojo.render.html.ie)||(dojo.render.html.ie&&dojo.hostenv._unloading)){
dojo.hostenv.unloaded();
}
});
dojo.hostenv.makeWidgets=function(){
var _a6=[];
if(djConfig.searchIds&&djConfig.searchIds.length>0){
_a6=_a6.concat(djConfig.searchIds);
}
if(dojo.hostenv.searchIds&&dojo.hostenv.searchIds.length>0){
_a6=_a6.concat(dojo.hostenv.searchIds);
}
if((djConfig.parseWidgets)||(_a6.length>0)){
if(dojo.getObject("dojo.widget.Parse")){
var _a7=new dojo.xml.Parse();
if(_a6.length>0){
for(var x=0;x<_a6.length;x++){
var _a9=document.getElementById(_a6[x]);
if(!_a9){
continue;
}
var _aa=_a7.parseElement(_a9,null,true);
dojo.widget.getParser().createComponents(_aa);
}
}else{
if(djConfig.parseWidgets){
var _aa=_a7.parseElement(dojo.body(),null,true);
dojo.widget.getParser().createComponents(_aa);
}
}
}
}
};
dojo.addOnLoad(function(){
if(!dojo.render.html.ie){
dojo.hostenv.makeWidgets();
}
});
try{
if(dojo.render.html.ie){
document.namespaces.add("v","urn:schemas-microsoft-com:vml");
document.createStyleSheet().addRule("v\\:*","behavior:url(#default#VML)");
}
}
catch(e){
}
dojo.hostenv.writeIncludes=function(){
};
if(!dj_undef("document",this)){
dj_currentDocument=this.document;
}
dojo.doc=function(){
return dj_currentDocument;
};
dojo.body=function(){
return dojo.doc().body||dojo.doc().getElementsByTagName("body")[0];
};
dojo.byId=function(id,doc){
if((id)&&((typeof id=="string")||(id instanceof String))){
if(!doc){
doc=dj_currentDocument;
}
var ele=doc.getElementById(id);
if(ele&&(ele.id!=id)&&doc.all){
ele=null;
eles=doc.all[id];
if(eles){
if(eles.length){
for(var i=0;i<eles.length;i++){
if(eles[i].id==id){
ele=eles[i];
break;
}
}
}else{
ele=eles;
}
}
}
return ele;
}
return id;
};
dojo.setContext=function(_af,_b0){
dj_currentContext=_af;
dj_currentDocument=_b0;
};
dojo._fireCallback=function(_b1,_b2,_b3){
if((_b2)&&((typeof _b1=="string")||(_b1 instanceof String))){
_b1=_b2[_b1];
}
return (_b2?_b1.apply(_b2,_b3||[]):_b1());
};
dojo.withGlobal=function(_b4,_b5,_b6,_b7){
var _b8;
var _b9=dj_currentContext;
var _ba=dj_currentDocument;
try{
dojo.setContext(_b4,_b4.document);
_b8=dojo._fireCallback(_b5,_b6,_b7);
}
finally{
dojo.setContext(_b9,_ba);
}
return _b8;
};
dojo.withDoc=function(_bb,_bc,_bd,_be){
var _bf;
var _c0=dj_currentDocument;
try{
dj_currentDocument=_bb;
_bf=dojo._fireCallback(_bc,_bd,_be);
}
finally{
dj_currentDocument=_c0;
}
return _bf;
};
}
dojo.requireIf((djConfig["isDebug"]||djConfig["debugAtAllCosts"]),"dojo.debug");
dojo.requireIf(djConfig["debugAtAllCosts"]&&!window.widget&&!djConfig["useXDomain"],"dojo.browser_debug");
dojo.requireIf(djConfig["debugAtAllCosts"]&&!window.widget&&djConfig["useXDomain"],"dojo.browser_debug_xd");
if(!this["dojo"]){
alert("\"dojo/__package__.js\" is now located at \"dojo/dojo.js\". Please update your includes accordingly");
}
dojo.provide("dojo.lang.common");
dojo.lang.inherits=function(_c1,_c2){
if(!dojo.lang.isFunction(_c2)){
dojo.raise("dojo.inherits: superclass argument ["+_c2+"] must be a function (subclass: ["+_c1+"']");
}
_c1.prototype=new _c2();
_c1.prototype.constructor=_c1;
_c1.superclass=_c2.prototype;
_c1["super"]=_c2.prototype;
};
dojo.lang._mixin=function(obj,_c4){
var _c5={};
for(var x in _c4){
if((typeof _c5[x]=="undefined")||(_c5[x]!=_c4[x])){
obj[x]=_c4[x];
}
}
if(dojo.render.html.ie&&(typeof (_c4["toString"])=="function")&&(_c4["toString"]!=obj["toString"])&&(_c4["toString"]!=_c5["toString"])){
obj.toString=_c4.toString;
}
return obj;
};
dojo.lang.mixin=function(obj,_c8){
for(var i=1,l=arguments.length;i<l;i++){
dojo.lang._mixin(obj,arguments[i]);
}
return obj;
};
dojo.lang.extend=function(_cb,_cc){
for(var i=1,l=arguments.length;i<l;i++){
dojo.lang._mixin(_cb.prototype,arguments[i]);
}
return _cb;
};
dojo.lang._delegate=function(obj,_d0){
function TMP(){
}
TMP.prototype=obj;
var tmp=new TMP();
if(_d0){
dojo.lang.mixin(tmp,_d0);
}
return tmp;
};
dojo.inherits=dojo.lang.inherits;
dojo.mixin=dojo.lang.mixin;
dojo.extend=dojo.lang.extend;
dojo.lang.find=function(_d2,_d3,_d4,_d5){
var _d6=dojo.lang.isString(_d2);
if(_d6){
_d2=_d2.split("");
}
if(_d5){
var _d7=-1;
var i=_d2.length-1;
var end=-1;
}else{
var _d7=1;
var i=0;
var end=_d2.length;
}
if(_d4){
while(i!=end){
if(_d2[i]===_d3){
return i;
}
i+=_d7;
}
}else{
while(i!=end){
if(_d2[i]==_d3){
return i;
}
i+=_d7;
}
}
return -1;
};
dojo.lang.indexOf=dojo.lang.find;
dojo.lang.findLast=function(_da,_db,_dc){
return dojo.lang.find(_da,_db,_dc,true);
};
dojo.lang.lastIndexOf=dojo.lang.findLast;
dojo.lang.inArray=function(_dd,_de){
return dojo.lang.find(_dd,_de)>-1;
};
dojo.lang.isObject=function(it){
if(typeof it=="undefined"){
return false;
}
return (typeof it=="object"||it===null||dojo.lang.isArray(it)||dojo.lang.isFunction(it));
};
dojo.lang.isArray=function(it){
return (it&&it instanceof Array||typeof it=="array");
};
dojo.lang.isArrayLike=function(it){
if((!it)||(dojo.lang.isUndefined(it))){
return false;
}
if(dojo.lang.isString(it)){
return false;
}
if(dojo.lang.isFunction(it)){
return false;
}
if(dojo.lang.isArray(it)){
return true;
}
if((it.tagName)&&(it.tagName.toLowerCase()=="form")){
return false;
}
if(dojo.lang.isNumber(it.length)&&isFinite(it.length)){
return true;
}
return false;
};
dojo.lang.isFunction=function(it){
return (it instanceof Function||typeof it=="function");
};
(function(){
if((dojo.render.html.capable)&&(dojo.render.html["safari"])){
dojo.lang.isFunction=function(it){
if((typeof (it)=="function")&&(it=="[object NodeList]")){
return false;
}
return (it instanceof Function||typeof it=="function");
};
}
})();
dojo.lang.isString=function(it){
return (typeof it=="string"||it instanceof String);
};
dojo.lang.isAlien=function(it){
if(!it){
return false;
}
return !dojo.lang.isFunction(it)&&/\{\s*\[native code\]\s*\}/.test(String(it));
};
dojo.lang.isBoolean=function(it){
return (it instanceof Boolean||typeof it=="boolean");
};
dojo.lang.isNumber=function(it){
return (it instanceof Number||typeof it=="number");
};
dojo.lang.isUndefined=function(it){
return ((typeof (it)=="undefined")&&(it==undefined));
};
dojo.provide("dojo.dom");
dojo.dom.ELEMENT_NODE=1;
dojo.dom.ATTRIBUTE_NODE=2;
dojo.dom.TEXT_NODE=3;
dojo.dom.CDATA_SECTION_NODE=4;
dojo.dom.ENTITY_REFERENCE_NODE=5;
dojo.dom.ENTITY_NODE=6;
dojo.dom.PROCESSING_INSTRUCTION_NODE=7;
dojo.dom.COMMENT_NODE=8;
dojo.dom.DOCUMENT_NODE=9;
dojo.dom.DOCUMENT_TYPE_NODE=10;
dojo.dom.DOCUMENT_FRAGMENT_NODE=11;
dojo.dom.NOTATION_NODE=12;
dojo.dom.dojoml="http://www.dojotoolkit.org/2004/dojoml";
dojo.dom.xmlns={svg:"http://www.w3.org/2000/svg",smil:"http://www.w3.org/2001/SMIL20/",mml:"http://www.w3.org/1998/Math/MathML",cml:"http://www.xml-cml.org",xlink:"http://www.w3.org/1999/xlink",xhtml:"http://www.w3.org/1999/xhtml",xul:"http://www.mozilla.org/keymaster/gatekeeper/there.is.only.xul",xbl:"http://www.mozilla.org/xbl",fo:"http://www.w3.org/1999/XSL/Format",xsl:"http://www.w3.org/1999/XSL/Transform",xslt:"http://www.w3.org/1999/XSL/Transform",xi:"http://www.w3.org/2001/XInclude",xforms:"http://www.w3.org/2002/01/xforms",saxon:"http://icl.com/saxon",xalan:"http://xml.apache.org/xslt",xsd:"http://www.w3.org/2001/XMLSchema",dt:"http://www.w3.org/2001/XMLSchema-datatypes",xsi:"http://www.w3.org/2001/XMLSchema-instance",rdf:"http://www.w3.org/1999/02/22-rdf-syntax-ns#",rdfs:"http://www.w3.org/2000/01/rdf-schema#",dc:"http://purl.org/dc/elements/1.1/",dcq:"http://purl.org/dc/qualifiers/1.0","soap-env":"http://schemas.xmlsoap.org/soap/envelope/",wsdl:"http://schemas.xmlsoap.org/wsdl/",AdobeExtensions:"http://ns.adobe.com/AdobeSVGViewerExtensions/3.0/"};
dojo.dom.isNode=function(wh){
if(typeof Element=="function"){
try{
return wh instanceof Element;
}
catch(e){
}
}else{
return wh&&!isNaN(wh.nodeType);
}
};
dojo.dom.getUniqueId=function(){
var _ea=dojo.doc();
do{
var id="dj_unique_"+(++arguments.callee._idIncrement);
}while(_ea.getElementById(id));
return id;
};
dojo.dom.getUniqueId._idIncrement=0;
dojo.dom.firstElement=dojo.dom.getFirstChildElement=function(_ec,_ed){
var _ee=_ec.firstChild;
while(_ee&&_ee.nodeType!=dojo.dom.ELEMENT_NODE){
_ee=_ee.nextSibling;
}
if(_ed&&_ee&&_ee.tagName&&_ee.tagName.toLowerCase()!=_ed.toLowerCase()){
_ee=dojo.dom.nextElement(_ee,_ed);
}
return _ee;
};
dojo.dom.lastElement=dojo.dom.getLastChildElement=function(_ef,_f0){
var _f1=_ef.lastChild;
while(_f1&&_f1.nodeType!=dojo.dom.ELEMENT_NODE){
_f1=_f1.previousSibling;
}
if(_f0&&_f1&&_f1.tagName&&_f1.tagName.toLowerCase()!=_f0.toLowerCase()){
_f1=dojo.dom.prevElement(_f1,_f0);
}
return _f1;
};
dojo.dom.nextElement=dojo.dom.getNextSiblingElement=function(_f2,_f3){
if(!_f2){
return null;
}
do{
_f2=_f2.nextSibling;
}while(_f2&&_f2.nodeType!=dojo.dom.ELEMENT_NODE);
if(_f2&&_f3&&_f3.toLowerCase()!=_f2.tagName.toLowerCase()){
return dojo.dom.nextElement(_f2,_f3);
}
return _f2;
};
dojo.dom.prevElement=dojo.dom.getPreviousSiblingElement=function(_f4,_f5){
if(!_f4){
return null;
}
if(_f5){
_f5=_f5.toLowerCase();
}
do{
_f4=_f4.previousSibling;
}while(_f4&&_f4.nodeType!=dojo.dom.ELEMENT_NODE);
if(_f4&&_f5&&_f5.toLowerCase()!=_f4.tagName.toLowerCase()){
return dojo.dom.prevElement(_f4,_f5);
}
return _f4;
};
dojo.dom.moveChildren=function(_f6,_f7,_f8){
var _f9=0;
if(_f8){
while(_f6.hasChildNodes()&&_f6.firstChild.nodeType==dojo.dom.TEXT_NODE){
_f6.removeChild(_f6.firstChild);
}
while(_f6.hasChildNodes()&&_f6.lastChild.nodeType==dojo.dom.TEXT_NODE){
_f6.removeChild(_f6.lastChild);
}
}
while(_f6.hasChildNodes()){
_f7.appendChild(_f6.firstChild);
_f9++;
}
return _f9;
};
dojo.dom.copyChildren=function(_fa,_fb,_fc){
var _fd=_fa.cloneNode(true);
return this.moveChildren(_fd,_fb,_fc);
};
dojo.dom.replaceChildren=function(_fe,_ff){
var _100=[];
if(dojo.render.html.ie){
for(var i=0;i<_fe.childNodes.length;i++){
_100.push(_fe.childNodes[i]);
}
}
dojo.dom.removeChildren(_fe);
_fe.appendChild(_ff);
for(var i=0;i<_100.length;i++){
dojo.dom.destroyNode(_100[i]);
}
};
dojo.dom.removeChildren=function(node){
var _103=node.childNodes.length;
while(node.hasChildNodes()){
dojo.dom.removeNode(node.firstChild);
}
return _103;
};
dojo.dom.replaceNode=function(node,_105){
return node.parentNode.replaceChild(_105,node);
};
dojo.dom.destroyNode=function(node){
if(node.parentNode){
node=dojo.dom.removeNode(node);
}
if(node.nodeType!=3){
if(dojo.exists("dojo.event.browser.clean")){
dojo.event.browser.clean(node);
}
if(dojo.render.html.ie){
node.outerHTML="";
}
}
};
dojo.dom.removeNode=function(node){
if(node&&node.parentNode){
return node.parentNode.removeChild(node);
}
};
dojo.dom.getAncestors=function(node,_109,_10a){
var _10b=[];
var _10c=(_109&&(_109 instanceof Function||typeof _109=="function"));
while(node){
if(!_10c||_109(node)){
_10b.push(node);
}
if(_10a&&_10b.length>0){
return _10b[0];
}
node=node.parentNode;
}
if(_10a){
return null;
}
return _10b;
};
dojo.dom.getAncestorsByTag=function(node,tag,_10f){
tag=tag.toLowerCase();
return dojo.dom.getAncestors(node,function(el){
return ((el.tagName)&&(el.tagName.toLowerCase()==tag));
},_10f);
};
dojo.dom.getFirstAncestorByTag=function(node,tag){
return dojo.dom.getAncestorsByTag(node,tag,true);
};
dojo.dom.isDescendantOf=function(node,_114,_115){
if(_115&&node){
node=node.parentNode;
}
while(node){
if(node==_114){
return true;
}
node=node.parentNode;
}
return false;
};
dojo.dom.innerXML=function(node){
if(node.innerXML){
return node.innerXML;
}else{
if(node.xml){
return node.xml;
}else{
if(typeof XMLSerializer!="undefined"){
return (new XMLSerializer()).serializeToString(node);
}
}
}
};
dojo.dom.createDocument=function(){
var doc=null;
var _118=dojo.doc();
if(!dj_undef("ActiveXObject")){
var _119=["MSXML2","Microsoft","MSXML","MSXML3"];
for(var i=0;i<_119.length;i++){
try{
doc=new ActiveXObject(_119[i]+".XMLDOM");
}
catch(e){
}
if(doc){
break;
}
}
}else{
if((_118.implementation)&&(_118.implementation.createDocument)){
doc=_118.implementation.createDocument("","",null);
}
}
return doc;
};
dojo.dom.createDocumentFromText=function(str,_11c){
if(!_11c){
_11c="text/xml";
}
if(!dj_undef("DOMParser")){
var _11d=new DOMParser();
return _11d.parseFromString(str,_11c);
}else{
if(!dj_undef("ActiveXObject")){
var _11e=dojo.dom.createDocument();
if(_11e){
_11e.async=false;
_11e.loadXML(str);
return _11e;
}else{
dojo.debug("toXml didn't work?");
}
}else{
var _11f=dojo.doc();
if(_11f.createElement){
var tmp=_11f.createElement("xml");
tmp.innerHTML=str;
if(_11f.implementation&&_11f.implementation.createDocument){
var _121=_11f.implementation.createDocument("foo","",null);
for(var i=0;i<tmp.childNodes.length;i++){
_121.importNode(tmp.childNodes.item(i),true);
}
return _121;
}
return ((tmp.document)&&(tmp.document.firstChild?tmp.document.firstChild:tmp));
}
}
}
return null;
};
dojo.dom.prependChild=function(node,_124){
if(_124.firstChild){
_124.insertBefore(node,_124.firstChild);
}else{
_124.appendChild(node);
}
return true;
};
dojo.dom.insertBefore=function(node,ref,_127){
if((_127!=true)&&(node===ref||node.nextSibling===ref)){
return false;
}
var _128=ref.parentNode;
_128.insertBefore(node,ref);
return true;
};
dojo.dom.insertAfter=function(node,ref,_12b){
var pn=ref.parentNode;
if(ref==pn.lastChild){
if((_12b!=true)&&(node===ref)){
return false;
}
pn.appendChild(node);
}else{
return this.insertBefore(node,ref.nextSibling,_12b);
}
return true;
};
dojo.dom.insertAtPosition=function(node,ref,_12f){
if((!node)||(!ref)||(!_12f)){
return false;
}
switch(_12f.toLowerCase()){
case "before":
return dojo.dom.insertBefore(node,ref);
case "after":
return dojo.dom.insertAfter(node,ref);
case "first":
if(ref.firstChild){
return dojo.dom.insertBefore(node,ref.firstChild);
}else{
ref.appendChild(node);
return true;
}
break;
default:
ref.appendChild(node);
return true;
}
};
dojo.dom.insertAtIndex=function(node,_131,_132){
var _133=_131.childNodes;
if(!_133.length||_133.length==_132){
_131.appendChild(node);
return true;
}
if(_132==0){
return dojo.dom.prependChild(node,_131);
}
return dojo.dom.insertAfter(node,_133[_132-1]);
};
dojo.dom.textContent=function(node,text){
if(arguments.length>1){
var _136=dojo.doc();
dojo.dom.replaceChildren(node,_136.createTextNode(text));
return text;
}else{
if(node["textContent"]!=undefined){
return node.textContent;
}
var _137="";
if(node==null){
return _137;
}
var i=0,n;
while(n=node.childNodes[i++]){
switch(n.nodeType){
case 1:
case 5:
_137+=dojo.dom.textContent(n);
break;
case 3:
case 2:
case 4:
_137+=n.nodeValue;
break;
default:
break;
}
}
return _137;
}
};
dojo.dom.hasParent=function(node){
return Boolean(node&&node.parentNode&&dojo.dom.isNode(node.parentNode));
};
dojo.dom.isTag=function(node){
if(node&&node.tagName){
for(var i=1;i<arguments.length;i++){
if(node.tagName==String(arguments[i])){
return String(arguments[i]);
}
}
}
return "";
};
dojo.dom.setAttributeNS=function(elem,_13e,_13f,_140){
if(elem==null||((elem==undefined)&&(typeof elem=="undefined"))){
dojo.raise("No element given to dojo.dom.setAttributeNS");
}
if(!((elem.setAttributeNS==undefined)&&(typeof elem.setAttributeNS=="undefined"))){
elem.setAttributeNS(_13e,_13f,_140);
}else{
var _141=elem.ownerDocument;
var _142=_141.createNode(2,_13f,_13e);
_142.nodeValue=_140;
elem.setAttributeNode(_142);
}
};
dojo.provide("dojo.html.common");
dojo.lang.mixin(dojo.html,dojo.dom);
dojo.html.getEventTarget=function(evt){
if(!evt){
evt=dojo.global().event||{};
}
var t=(evt.srcElement?evt.srcElement:(evt.target?evt.target:null));
while((t)&&(t.nodeType!=1)){
t=t.parentNode;
}
return t;
};
dojo.html.getViewport=function(){
var _145=dojo.global();
var _146=dojo.doc();
var w=0;
var h=0;
if(dojo.render.html.mozilla){
w=_146.documentElement.clientWidth;
h=_145.innerHeight;
}else{
if(!dojo.render.html.opera&&_145.innerWidth){
w=_145.innerWidth;
h=_145.innerHeight;
}else{
if(!dojo.render.html.opera&&dojo.exists("documentElement.clientWidth",_146)){
var w2=_146.documentElement.clientWidth;
if(!w||w2&&w2<w){
w=w2;
}
h=_146.documentElement.clientHeight;
}else{
if(dojo.body().clientWidth){
w=dojo.body().clientWidth;
h=dojo.body().clientHeight;
}
}
}
}
return {width:w,height:h};
};
dojo.html.getScroll=function(){
var _14a=dojo.global();
var _14b=dojo.doc();
var top=_14a.pageYOffset||_14b.documentElement.scrollTop||dojo.body().scrollTop||0;
var left=_14a.pageXOffset||_14b.documentElement.scrollLeft||dojo.body().scrollLeft||0;
return {top:top,left:left,offset:{x:left,y:top}};
};
dojo.html.getParentByType=function(node,type){
var _150=dojo.doc();
var _151=dojo.byId(node);
type=type.toLowerCase();
while((_151)&&(_151.nodeName.toLowerCase()!=type)){
if(_151==(_150["body"]||_150["documentElement"])){
return null;
}
_151=_151.parentNode;
}
return _151;
};
dojo.html.getAttribute=function(node,attr){
node=dojo.byId(node);
if((!node)||(!node.getAttribute)){
return null;
}
var ta=typeof attr=="string"?attr:new String(attr);
var v=node.getAttribute(ta.toUpperCase());
if((v)&&(typeof v=="string")&&(v!="")){
return v;
}
if(v&&v.value){
return v.value;
}
if((node.getAttributeNode)&&(node.getAttributeNode(ta))){
return (node.getAttributeNode(ta)).value;
}else{
if(node.getAttribute(ta)){
return node.getAttribute(ta);
}else{
if(node.getAttribute(ta.toLowerCase())){
return node.getAttribute(ta.toLowerCase());
}
}
}
return null;
};
dojo.html.hasAttribute=function(node,attr){
return dojo.html.getAttribute(dojo.byId(node),attr)?true:false;
};
dojo.html.getCursorPosition=function(e){
e=e||dojo.global().event;
var _159={x:0,y:0};
if(e.pageX||e.pageY){
_159.x=e.pageX;
_159.y=e.pageY;
}else{
var de=dojo.doc().documentElement;
var db=dojo.body();
_159.x=e.clientX+((de||db)["scrollLeft"])-((de||db)["clientLeft"]);
_159.y=e.clientY+((de||db)["scrollTop"])-((de||db)["clientTop"]);
}
return _159;
};
dojo.html.isTag=function(node){
node=dojo.byId(node);
if(node&&node.tagName){
for(var i=1;i<arguments.length;i++){
if(node.tagName.toLowerCase()==String(arguments[i]).toLowerCase()){
return String(arguments[i]).toLowerCase();
}
}
}
return "";
};
if(dojo.render.html.ie&&!dojo.render.html.ie70){
if(window.location.href.substr(0,6).toLowerCase()!="https:"){
(function(){
var _15e=dojo.doc().createElement("script");
_15e.src="javascript:'dojo.html.createExternalElement=function(doc, tag){ return doc.createElement(tag); }'";
dojo.doc().getElementsByTagName("head")[0].appendChild(_15e);
})();
}
}else{
dojo.html.createExternalElement=function(doc,tag){
return doc.createElement(tag);
};
}
dojo.provide("dojo.uri.Uri");
dojo.uri=new function(){
this.dojoUri=function(uri){
return new dojo.uri.Uri(dojo.hostenv.getBaseScriptUri(),uri);
};
this.moduleUri=function(_162,uri){
var loc=dojo.hostenv.getModuleSymbols(_162).join("/");
if(!loc){
return null;
}
if(loc.lastIndexOf("/")!=loc.length-1){
loc+="/";
}
var _165=loc.indexOf(":");
var _166=loc.indexOf("/");
if(loc.charAt(0)!="/"&&(_165==-1||_165>_166)){
loc=dojo.hostenv.getBaseScriptUri()+loc;
}
return new dojo.uri.Uri(loc,uri);
};
this.Uri=function(){
var uri=arguments[0];
for(var i=1;i<arguments.length;i++){
if(!arguments[i]){
continue;
}
var _169=new dojo.uri.Uri(arguments[i].toString());
var _16a=new dojo.uri.Uri(uri.toString());
if((_169.path=="")&&(_169.scheme==null)&&(_169.authority==null)&&(_169.query==null)){
if(_169.fragment!=null){
_16a.fragment=_169.fragment;
}
_169=_16a;
}else{
if(_169.scheme==null){
_169.scheme=_16a.scheme;
if(_169.authority==null){
_169.authority=_16a.authority;
if(_169.path.charAt(0)!="/"){
var path=_16a.path.substring(0,_16a.path.lastIndexOf("/")+1)+_169.path;
var segs=path.split("/");
for(var j=0;j<segs.length;j++){
if(segs[j]=="."){
if(j==segs.length-1){
segs[j]="";
}else{
segs.splice(j,1);
j--;
}
}else{
if(j>0&&!(j==1&&segs[0]=="")&&segs[j]==".."&&segs[j-1]!=".."){
if(j==segs.length-1){
segs.splice(j,1);
segs[j-1]="";
}else{
segs.splice(j-1,2);
j-=2;
}
}
}
}
_169.path=segs.join("/");
}
}
}
}
uri="";
if(_169.scheme!=null){
uri+=_169.scheme+":";
}
if(_169.authority!=null){
uri+="//"+_169.authority;
}
uri+=_169.path;
if(_169.query!=null){
uri+="?"+_169.query;
}
if(_169.fragment!=null){
uri+="#"+_169.fragment;
}
}
this.uri=uri.toString();
var _16e="^(([^:/?#]+):)?(//([^/?#]*))?([^?#]*)(\\?([^#]*))?(#(.*))?$";
var r=this.uri.match(new RegExp(_16e));
this.scheme=r[2]||(r[1]?"":null);
this.authority=r[4]||(r[3]?"":null);
this.path=r[5];
this.query=r[7]||(r[6]?"":null);
this.fragment=r[9]||(r[8]?"":null);
if(this.authority!=null){
_16e="^((([^:]+:)?([^@]+))@)?([^:]*)(:([0-9]+))?$";
r=this.authority.match(new RegExp(_16e));
this.user=r[3]||null;
this.password=r[4]||null;
this.host=r[5];
this.port=r[7]||null;
}
this.toString=function(){
return this.uri;
};
};
};
dojo.provide("dojo.html.style");
dojo.html.getClass=function(node){
node=dojo.byId(node);
if(!node){
return "";
}
var cs="";
if(node.className){
cs=node.className;
}else{
if(dojo.html.hasAttribute(node,"class")){
cs=dojo.html.getAttribute(node,"class");
}
}
return cs.replace(/^\s+|\s+$/g,"");
};
dojo.html.getClasses=function(node){
var c=dojo.html.getClass(node);
return (c=="")?[]:c.split(/\s+/g);
};
dojo.html.hasClass=function(node,_175){
return (new RegExp("(^|\\s+)"+_175+"(\\s+|$)")).test(dojo.html.getClass(node));
};
dojo.html.prependClass=function(node,_177){
_177+=" "+dojo.html.getClass(node);
return dojo.html.setClass(node,_177);
};
dojo.html.addClass=function(node,_179){
if(dojo.html.hasClass(node,_179)){
return false;
}
_179=(dojo.html.getClass(node)+" "+_179).replace(/^\s+|\s+$/g,"");
return dojo.html.setClass(node,_179);
};
dojo.html.setClass=function(node,_17b){
node=dojo.byId(node);
var cs=new String(_17b);
try{
if(typeof node.className=="string"){
node.className=cs;
}else{
if(node.setAttribute){
node.setAttribute("class",_17b);
node.className=cs;
}else{
return false;
}
}
}
catch(e){
dojo.debug("dojo.html.setClass() failed",e);
}
return true;
};
dojo.html.removeClass=function(node,_17e,_17f){
try{
if(!_17f){
var _180=dojo.html.getClass(node).replace(new RegExp("(^|\\s+)"+_17e+"(\\s+|$)"),"$1$2");
}else{
var _180=dojo.html.getClass(node).replace(_17e,"");
}
dojo.html.setClass(node,_180);
}
catch(e){
dojo.debug("dojo.html.removeClass() failed",e);
}
return true;
};
dojo.html.replaceClass=function(node,_182,_183){
dojo.html.removeClass(node,_183);
dojo.html.addClass(node,_182);
};
dojo.html.classMatchType={ContainsAll:0,ContainsAny:1,IsOnly:2};
dojo.html.getElementsByClass=function(_184,_185,_186,_187,_188){
_188=false;
var _189=dojo.doc();
_185=dojo.byId(_185)||_189;
var _18a=_184.split(/\s+/g);
var _18b=[];
if(_187!=1&&_187!=2){
_187=0;
}
var _18c=new RegExp("(\\s|^)(("+_18a.join(")|(")+"))(\\s|$)");
var _18d=_18a.join(" ").length;
var _18e=[];
if(!_188&&_189.evaluate){
var _18f=".//"+(_186||"*")+"[contains(";
if(_187!=dojo.html.classMatchType.ContainsAny){
_18f+="concat(' ',@class,' '), ' "+_18a.join(" ') and contains(concat(' ',@class,' '), ' ")+" ')";
if(_187==2){
_18f+=" and string-length(@class)="+_18d+"]";
}else{
_18f+="]";
}
}else{
_18f+="concat(' ',@class,' '), ' "+_18a.join(" ') or contains(concat(' ',@class,' '), ' ")+" ')]";
}
var _190=_189.evaluate(_18f,_185,null,XPathResult.ANY_TYPE,null);
var _191=_190.iterateNext();
while(_191){
try{
_18e.push(_191);
_191=_190.iterateNext();
}
catch(e){
break;
}
}
return _18e;
}else{
if(!_186){
_186="*";
}
_18e=_185.getElementsByTagName(_186);
var node,i=0;
outer:
while(node=_18e[i++]){
var _194=dojo.html.getClasses(node);
if(_194.length==0){
continue outer;
}
var _195=0;
for(var j=0;j<_194.length;j++){
if(_18c.test(_194[j])){
if(_187==dojo.html.classMatchType.ContainsAny){
_18b.push(node);
continue outer;
}else{
_195++;
}
}else{
if(_187==dojo.html.classMatchType.IsOnly){
continue outer;
}
}
}
if(_195==_18a.length){
if((_187==dojo.html.classMatchType.IsOnly)&&(_195==_194.length)){
_18b.push(node);
}else{
if(_187==dojo.html.classMatchType.ContainsAll){
_18b.push(node);
}
}
}
}
return _18b;
}
};
dojo.html.getElementsByClassName=dojo.html.getElementsByClass;
dojo.html.toCamelCase=function(_197){
var arr=_197.split("-"),cc=arr[0];
for(var i=1;i<arr.length;i++){
cc+=arr[i].charAt(0).toUpperCase()+arr[i].substring(1);
}
return cc;
};
dojo.html.toSelectorCase=function(_19b){
return _19b.replace(/([A-Z])/g,"-$1").toLowerCase();
};
if(dojo.render.html.ie){
dojo.html.getComputedStyle=function(node,_19d,_19e){
node=dojo.byId(node);
if(!node||!node.currentStyle){
return _19e;
}
return node.currentStyle[dojo.html.toCamelCase(_19d)];
};
dojo.html.getComputedStyles=function(node){
return node.currentStyle;
};
}else{
dojo.html.getComputedStyle=function(node,_1a1,_1a2){
node=dojo.byId(node);
if(!node||!node.style){
return _1a2;
}
var s=node.ownerDocument.defaultView.getComputedStyle(node,null);
return (s&&s[dojo.html.toCamelCase(_1a1)])||"";
};
dojo.html.getComputedStyles=function(node){
return node.ownerDocument.defaultView.getComputedStyle(node,null);
};
}
dojo.html.getStyleProperty=function(node,_1a6){
node=dojo.byId(node);
return (node&&node.style?node.style[dojo.html.toCamelCase(_1a6)]:undefined);
};
dojo.html.getStyle=function(node,_1a8){
var _1a9=dojo.html.getStyleProperty(node,_1a8);
return (_1a9?_1a9:dojo.html.getComputedStyle(node,_1a8));
};
dojo.html.setStyle=function(node,_1ab,_1ac){
node=dojo.byId(node);
if(node&&node.style){
var _1ad=dojo.html.toCamelCase(_1ab);
node.style[_1ad]=_1ac;
}
};
dojo.html.setStyleText=function(_1ae,text){
try{
_1ae.style.cssText=text;
}
catch(e){
_1ae.setAttribute("style",text);
}
};
dojo.html.copyStyle=function(_1b0,_1b1){
if(!_1b1.style.cssText){
_1b0.setAttribute("style",_1b1.getAttribute("style"));
}else{
_1b0.style.cssText=_1b1.style.cssText;
}
dojo.html.addClass(_1b0,dojo.html.getClass(_1b1));
};
dojo.html.getUnitValue=function(node,_1b3,_1b4){
var s=dojo.html.getComputedStyle(node,_1b3);
if((!s)||((s=="auto")&&(_1b4))){
return {value:0,units:"px"};
}
var _1b6=s.match(/(\-?[\d.]+)([a-z%]*)/i);
if(!_1b6){
return dojo.html.getUnitValue.bad;
}
return {value:Number(_1b6[1]),units:_1b6[2].toLowerCase()};
};
dojo.html.getUnitValue.bad={value:NaN,units:""};
if(dojo.render.html.ie){
dojo.html.toPixelValue=function(_1b7,_1b8){
if(!_1b8){
return 0;
}
if(_1b8.slice(-2)=="px"){
return parseFloat(_1b8);
}
var _1b9=0;
with(_1b7){
var _1ba=style.left;
var _1bb=runtimeStyle.left;
runtimeStyle.left=currentStyle.left;
try{
style.left=_1b8||0;
_1b9=style.pixelLeft;
style.left=_1ba;
runtimeStyle.left=_1bb;
}
catch(e){
}
}
return _1b9;
};
}else{
dojo.html.toPixelValue=function(_1bc,_1bd){
return (_1bd&&(_1bd.slice(-2)=="px")?parseFloat(_1bd):0);
};
}
dojo.html.getPixelValue=function(node,_1bf,_1c0){
return dojo.html.toPixelValue(node,dojo.html.getComputedStyle(node,_1bf));
};
dojo.html.setPositivePixelValue=function(node,_1c2,_1c3){
if(isNaN(_1c3)){
return false;
}
node.style[_1c2]=Math.max(0,_1c3)+"px";
return true;
};
dojo.html.styleSheet=null;
dojo.html.insertCssRule=function(_1c4,_1c5,_1c6){
if(!dojo.html.styleSheet){
if(document.createStyleSheet){
dojo.html.styleSheet=document.createStyleSheet();
}else{
if(document.styleSheets[0]){
dojo.html.styleSheet=document.styleSheets[0];
}else{
return null;
}
}
}
var ss=dojo.html.styleSheet;
if(arguments.length<3){
if(ss.cssRules){
_1c6=ss.cssRules.length;
}else{
if(ss.rules){
_1c6=ss.rules.length;
}else{
return null;
}
}
}
if(ss.insertRule){
var rule=_1c4+" { "+_1c5+" }";
return ss.insertRule(rule,_1c6);
}else{
if(ss.addRule){
return ss.addRule(_1c4,_1c5,_1c6);
}else{
return null;
}
}
};
dojo.html.removeCssRule=function(_1c9){
var ss=dojo.html.styleSheet;
if(!ss){
dojo.debug("no stylesheet defined for removing rules");
return false;
}
if(dojo.render.html.ie){
if(!_1c9){
_1c9=ss.rules.length;
ss.removeRule(_1c9);
}
}else{
if(document.styleSheets[0]){
if(!_1c9){
_1c9=ss.cssRules.length;
}
ss.deleteRule(_1c9);
}
}
return true;
};
dojo.html._insertedCssFiles=[];
dojo.html.insertCssFile=function(URI,doc,_1cd,_1ce){
if(!URI){
return;
}
if(!doc){
doc=document;
}
var _1cf=dojo.hostenv.getText(URI,false,_1ce);
if(_1cf===null){
return;
}
_1cf=dojo.html.fixPathsInCssText(_1cf,URI);
if(_1cd){
var idx=-1,node,ent=dojo.html._insertedCssFiles;
for(var i=0;i<ent.length;i++){
if((ent[i].doc==doc)&&(ent[i].cssText==_1cf)){
idx=i;
node=ent[i].nodeRef;
break;
}
}
if(node){
var _1d4=doc.getElementsByTagName("style");
for(var i=0;i<_1d4.length;i++){
if(_1d4[i]==node){
return;
}
}
dojo.html._insertedCssFiles.shift(idx,1);
}
}
var _1d5=dojo.html.insertCssText(_1cf,doc);
dojo.html._insertedCssFiles.push({"doc":doc,"cssText":_1cf,"nodeRef":_1d5});
if(_1d5&&djConfig.isDebug){
_1d5.setAttribute("dbgHref",URI);
}
return _1d5;
};
dojo.html.insertCssText=function(_1d6,doc,URI){
if(!_1d6){
return;
}
if(!doc){
doc=document;
}
if(URI){
_1d6=dojo.html.fixPathsInCssText(_1d6,URI);
}
var _1d9=doc.createElement("style");
_1d9.setAttribute("type","text/css");
var head=doc.getElementsByTagName("head")[0];
if(!head){
dojo.debug("No head tag in document, aborting styles");
return;
}else{
head.appendChild(_1d9);
}
if(_1d9.styleSheet){
var _1db=function(){
try{
_1d9.styleSheet.cssText=_1d6;
}
catch(e){
dojo.debug(e);
}
};
if(_1d9.styleSheet.disabled){
setTimeout(_1db,10);
}else{
_1db();
}
}else{
var _1dc=doc.createTextNode(_1d6);
_1d9.appendChild(_1dc);
}
return _1d9;
};
dojo.html.fixPathsInCssText=function(_1dd,URI){
if(!_1dd||!URI){
return;
}
var _1df,str="",url="",_1e2="[\\t\\s\\w\\(\\)\\/\\.\\\\'\"-:#=&?~]+";
var _1e3=new RegExp("url\\(\\s*("+_1e2+")\\s*\\)");
var _1e4=/(file|https?|ftps?):\/\//;
regexTrim=new RegExp("^[\\s]*(['\"]?)("+_1e2+")\\1[\\s]*?$");
if(dojo.render.html.ie55||dojo.render.html.ie60){
var _1e5=new RegExp("AlphaImageLoader\\((.*)src=['\"]("+_1e2+")['\"]");
while(_1df=_1e5.exec(_1dd)){
url=_1df[2].replace(regexTrim,"$2");
if(!_1e4.exec(url)){
url=(new dojo.uri.Uri(URI,url).toString());
}
str+=_1dd.substring(0,_1df.index)+"AlphaImageLoader("+_1df[1]+"src='"+url+"'";
_1dd=_1dd.substr(_1df.index+_1df[0].length);
}
_1dd=str+_1dd;
str="";
}
while(_1df=_1e3.exec(_1dd)){
url=_1df[1].replace(regexTrim,"$2");
if(!_1e4.exec(url)){
url=(new dojo.uri.Uri(URI,url).toString());
}
str+=_1dd.substring(0,_1df.index)+"url("+url+")";
_1dd=_1dd.substr(_1df.index+_1df[0].length);
}
return str+_1dd;
};
dojo.html.setActiveStyleSheet=function(_1e6){
var i=0,a,els=dojo.doc().getElementsByTagName("link");
while(a=els[i++]){
if(a.getAttribute("rel").indexOf("style")!=-1&&a.getAttribute("title")){
a.disabled=true;
if(a.getAttribute("title")==_1e6){
a.disabled=false;
}
}
}
};
dojo.html.getActiveStyleSheet=function(){
var i=0,a,els=dojo.doc().getElementsByTagName("link");
while(a=els[i++]){
if((a.getAttribute("rel").indexOf("style")!=-1)&&(a.getAttribute("title"))&&(!a.disabled)){
return a.getAttribute("title");
}
}
return null;
};
dojo.html.getPreferredStyleSheet=function(){
var i=0,a,els=dojo.doc().getElementsByTagName("link");
while(a=els[i++]){
if((a.getAttribute("rel").indexOf("style")!=-1)&&(a.getAttribute("rel").indexOf("alt")==-1)&&(a.getAttribute("title"))){
return a.getAttribute("title");
}
}
return null;
};
dojo.html.applyBrowserClass=function(node){
var drh=dojo.render.html;
var _1f2={dj_ie:drh.ie,dj_ie55:drh.ie55,dj_ie6:drh.ie60,dj_ie7:drh.ie70,dj_iequirks:drh.ie&&drh.quirks,dj_opera:drh.opera,dj_opera8:drh.opera&&(Math.floor(dojo.render.version)==8),dj_opera9:drh.opera&&(Math.floor(dojo.render.version)==9),dj_khtml:drh.khtml,dj_safari:drh.safari,dj_gecko:drh.mozilla};
for(var p in _1f2){
if(_1f2[p]){
dojo.html.addClass(node,p);
}
}
};
dojo.kwCompoundRequire({common:["dojo.html.common","dojo.html.style"]});
dojo.provide("dojo.html.*");
dojo.provide("dojo.html.display");
dojo.html._toggle=function(node,_1f5,_1f6){
node=dojo.byId(node);
_1f6(node,!_1f5(node));
return _1f5(node);
};
dojo.html.show=function(node){
node=dojo.byId(node);
if(dojo.html.getStyleProperty(node,"display")=="none"){
var _1f8=dojo.html.getAttribute("djDisplayCache");
dojo.html.setStyle(node,"display",(_1f8||""));
node.removeAttribute("djDisplayCache");
}
};
dojo.html.hide=function(node){
node=dojo.byId(node);
var _1fa=dojo.html.getAttribute("djDisplayCache");
if(_1fa==null){
var d=dojo.html.getStyleProperty(node,"display");
if(d!="none"){
node.setAttribute("djDisplayCache",d);
}
}
dojo.html.setStyle(node,"display","none");
};
dojo.html.setShowing=function(node,_1fd){
dojo.html[(_1fd?"show":"hide")](node);
};
dojo.html.isShowing=function(node){
return (dojo.html.getStyleProperty(node,"display")!="none");
};
dojo.html.toggleShowing=function(node){
return dojo.html._toggle(node,dojo.html.isShowing,dojo.html.setShowing);
};
dojo.html.displayMap={tr:"",td:"",th:"",img:"inline",span:"inline",input:"inline",button:"inline"};
dojo.html.suggestDisplayByTagName=function(node){
node=dojo.byId(node);
if(node&&node.tagName){
var tag=node.tagName.toLowerCase();
return (tag in dojo.html.displayMap?dojo.html.displayMap[tag]:"block");
}
};
dojo.html.setDisplay=function(node,_203){
dojo.html.setStyle(node,"display",((_203 instanceof String||typeof _203=="string")?_203:(_203?dojo.html.suggestDisplayByTagName(node):"none")));
};
dojo.html.isDisplayed=function(node){
return (dojo.html.getComputedStyle(node,"display")!="none");
};
dojo.html.toggleDisplay=function(node){
return dojo.html._toggle(node,dojo.html.isDisplayed,dojo.html.setDisplay);
};
dojo.html.setVisibility=function(node,_207){
dojo.html.setStyle(node,"visibility",((_207 instanceof String||typeof _207=="string")?_207:(_207?"visible":"hidden")));
};
dojo.html.isVisible=function(node){
return (dojo.html.getComputedStyle(node,"visibility")!="hidden");
};
dojo.html.toggleVisibility=function(node){
return dojo.html._toggle(node,dojo.html.isVisible,dojo.html.setVisibility);
};
dojo.html.setOpacity=function(node,_20b,_20c){
node=dojo.byId(node);
var h=dojo.render.html;
if(!_20c){
if(_20b>=1){
if(h.ie){
dojo.html.clearOpacity(node);
return;
}else{
_20b=0.999999;
}
}else{
if(_20b<0){
_20b=0;
}
}
}
if(h.ie){
if(node.nodeName.toLowerCase()=="tr"){
var tds=node.getElementsByTagName("td");
for(var x=0;x<tds.length;x++){
tds[x].style.filter="Alpha(Opacity="+_20b*100+")";
}
}
node.style.filter="Alpha(Opacity="+_20b*100+")";
}else{
if(h.moz){
node.style.opacity=_20b;
node.style.MozOpacity=_20b;
}else{
if(h.safari){
node.style.opacity=_20b;
node.style.KhtmlOpacity=_20b;
}else{
node.style.opacity=_20b;
}
}
}
};
dojo.html.clearOpacity=function(node){
node=dojo.byId(node);
var ns=node.style;
var h=dojo.render.html;
if(h.ie){
try{
if(node.filters&&node.filters.alpha){
ns.filter="";
}
}
catch(e){
}
}else{
if(h.moz){
ns.opacity=1;
ns.MozOpacity=1;
}else{
if(h.safari){
ns.opacity=1;
ns.KhtmlOpacity=1;
}else{
ns.opacity=1;
}
}
}
};
dojo.html.getOpacity=function(node){
node=dojo.byId(node);
var h=dojo.render.html;
if(h.ie){
var opac=(node.filters&&node.filters.alpha&&typeof node.filters.alpha.opacity=="number"?node.filters.alpha.opacity:100)/100;
}else{
var opac=node.style.opacity||node.style.MozOpacity||node.style.KhtmlOpacity||1;
}
return opac>=0.999999?1:Number(opac);
};
dojo.provide("dojo.html.layout");
dojo.html.sumAncestorProperties=function(node,prop){
node=dojo.byId(node);
if(!node){
return 0;
}
var _218=0;
while(node){
if(dojo.html.getComputedStyle(node,"position")=="fixed"){
return 0;
}
var val=node[prop];
if(val){
_218+=val-0;
if(node==dojo.body()){
break;
}
}
node=node.parentNode;
}
return _218;
};
dojo.html.setStyleAttributes=function(node,_21b){
node=dojo.byId(node);
var _21c=_21b.replace(/(;)?\s*$/,"").split(";");
for(var i=0;i<_21c.length;i++){
var _21e=_21c[i].split(":");
var name=_21e[0].replace(/\s*$/,"").replace(/^\s*/,"").toLowerCase();
var _220=_21e[1].replace(/\s*$/,"").replace(/^\s*/,"");
switch(name){
case "opacity":
dojo.html.setOpacity(node,_220);
break;
case "content-height":
dojo.html.setContentBox(node,{height:_220});
break;
case "content-width":
dojo.html.setContentBox(node,{width:_220});
break;
case "outer-height":
dojo.html.setMarginBox(node,{height:_220});
break;
case "outer-width":
dojo.html.setMarginBox(node,{width:_220});
break;
default:
node.style[dojo.html.toCamelCase(name)]=_220;
}
}
};
dojo.html.boxSizing={MARGIN_BOX:"margin-box",BORDER_BOX:"border-box",PADDING_BOX:"padding-box",CONTENT_BOX:"content-box"};
dojo.html.getAbsolutePosition=dojo.html.abs=function(node,_222,_223){
node=dojo.byId(node);
var _224=dojo.doc();
var ret={x:0,y:0};
var bs=dojo.html.boxSizing;
if(!_223){
_223=bs.CONTENT_BOX;
}
var _227=2;
var _228;
switch(_223){
case bs.MARGIN_BOX:
_228=3;
break;
case bs.BORDER_BOX:
_228=2;
break;
case bs.PADDING_BOX:
default:
_228=1;
break;
case bs.CONTENT_BOX:
_228=0;
break;
}
var h=dojo.render.html;
var db=_224["body"]||_224["documentElement"];
if(h.ie){
with(node.getBoundingClientRect()){
ret.x=left-2;
ret.y=top-2;
}
}else{
if(_224["getBoxObjectFor"]){
_227=1;
try{
var bo=_224.getBoxObjectFor(node);
ret.x=bo.x-dojo.html.sumAncestorProperties(node,"scrollLeft");
ret.y=bo.y-dojo.html.sumAncestorProperties(node,"scrollTop");
}
catch(e){
}
}else{
if(node["offsetParent"]){
var _22c;
if((h.safari)&&(node.style.getPropertyValue("position")=="absolute")&&(node.parentNode==db)){
_22c=db;
}else{
_22c=db.parentNode;
}
if(node.parentNode!=db){
var nd=node;
if(dojo.render.html.opera){
nd=db;
}
ret.x-=dojo.html.sumAncestorProperties(nd,"scrollLeft");
ret.y-=dojo.html.sumAncestorProperties(nd,"scrollTop");
}
var _22e=node;
do{
var n=_22e["offsetLeft"];
if(!h.opera||n>0){
ret.x+=isNaN(n)?0:n;
}
var m=_22e["offsetTop"];
ret.y+=isNaN(m)?0:m;
_22e=_22e.offsetParent;
}while((_22e!=_22c)&&(_22e!=null));
}else{
if(node["x"]&&node["y"]){
ret.x+=isNaN(node.x)?0:node.x;
ret.y+=isNaN(node.y)?0:node.y;
}
}
}
}
if(_222){
var _231=dojo.html.getScroll();
ret.y+=_231.top;
ret.x+=_231.left;
}
var _232=[dojo.html.getPaddingExtent,dojo.html.getBorderExtent,dojo.html.getMarginExtent];
if(_227>_228){
for(var i=_228;i<_227;++i){
ret.y+=_232[i](node,"top");
ret.x+=_232[i](node,"left");
}
}else{
if(_227<_228){
for(var i=_228;i>_227;--i){
ret.y-=_232[i-1](node,"top");
ret.x-=_232[i-1](node,"left");
}
}
}
ret.top=ret.y;
ret.left=ret.x;
return ret;
};
dojo.html.isPositionAbsolute=function(node){
return (dojo.html.getComputedStyle(node,"position")=="absolute");
};
dojo.html._getComponentPixelValues=function(node,_236,_237,_238){
var _239=["top","bottom","left","right"];
var obj={};
for(var i in _239){
side=_239[i];
obj[side]=_237(node,_236+side,_238);
}
obj.width=obj.left+obj.right;
obj.height=obj.top+obj.bottom;
return obj;
};
dojo.html.getMargin=function(node){
return dojo.html._getComponentPixelValues(node,"margin-",dojo.html.getPixelValue,dojo.html.isPositionAbsolute(node));
};
dojo.html.getBorder=function(node){
return dojo.html._getComponentPixelValues(node,"",dojo.html.getBorderExtent);
};
dojo.html.getBorderExtent=function(node,side){
return (dojo.html.getStyle(node,"border-"+side+"-style")=="none"?0:dojo.html.getPixelValue(node,"border-"+side+"-width"));
};
dojo.html.getMarginExtent=function(node,side){
return dojo.html.getPixelValue(node,"margin-"+side,dojo.html.isPositionAbsolute(node));
};
dojo.html.getPaddingExtent=function(node,side){
return dojo.html.getPixelValue(node,"padding-"+side,true);
};
dojo.html.getPadding=function(node){
return dojo.html._getComponentPixelValues(node,"padding-",dojo.html.getPixelValue,true);
};
dojo.html.getPadBorder=function(node){
var pad=dojo.html.getPadding(node);
var _247=dojo.html.getBorder(node);
return {width:pad.width+_247.width,height:pad.height+_247.height};
};
dojo.html.getBoxSizing=function(node){
var h=dojo.render.html;
var bs=dojo.html.boxSizing;
if(((h.ie)||(h.opera))&&node.nodeName.toLowerCase()!="img"){
var cm=document["compatMode"];
if((cm=="BackCompat")||(cm=="QuirksMode")){
return bs.BORDER_BOX;
}else{
return bs.CONTENT_BOX;
}
}else{
if(arguments.length==0){
node=document.documentElement;
}
var _24c;
if(!h.ie){
_24c=dojo.html.getStyle(node,"-moz-box-sizing");
if(!_24c){
_24c=dojo.html.getStyle(node,"box-sizing");
}
}
return (_24c?_24c:bs.CONTENT_BOX);
}
};
dojo.html.isBorderBox=function(node){
return (dojo.html.getBoxSizing(node)==dojo.html.boxSizing.BORDER_BOX);
};
dojo.html.getBorderBox=function(node){
node=dojo.byId(node);
return {width:node.offsetWidth,height:node.offsetHeight};
};
dojo.html.getPaddingBox=function(node){
var box=dojo.html.getBorderBox(node);
var _251=dojo.html.getBorder(node);
return {width:box.width-_251.width,height:box.height-_251.height};
};
dojo.html.getContentBox=function(node){
node=dojo.byId(node);
var _253=dojo.html.getPadBorder(node);
return {width:node.offsetWidth-_253.width,height:node.offsetHeight-_253.height};
};
dojo.html.setContentBox=function(node,args){
node=dojo.byId(node);
var _256=0;
var _257=0;
var isbb=dojo.html.isBorderBox(node);
var _259=(isbb?dojo.html.getPadBorder(node):{width:0,height:0});
var ret={};
if(typeof args.width!="undefined"){
_256=args.width+_259.width;
ret.width=dojo.html.setPositivePixelValue(node,"width",_256);
}
if(typeof args.height!="undefined"){
_257=args.height+_259.height;
ret.height=dojo.html.setPositivePixelValue(node,"height",_257);
}
return ret;
};
dojo.html.getMarginBox=function(node){
var _25c=dojo.html.getBorderBox(node);
var _25d=dojo.html.getMargin(node);
return {width:_25c.width+_25d.width,height:_25c.height+_25d.height};
};
dojo.html.setMarginBox=function(node,args){
node=dojo.byId(node);
var _260=0;
var _261=0;
var isbb=dojo.html.isBorderBox(node);
var _263=(!isbb?dojo.html.getPadBorder(node):{width:0,height:0});
var _264=dojo.html.getMargin(node);
var ret={};
if(typeof args.width!="undefined"){
_260=args.width-_263.width;
_260-=_264.width;
ret.width=dojo.html.setPositivePixelValue(node,"width",_260);
}
if(typeof args.height!="undefined"){
_261=args.height-_263.height;
_261-=_264.height;
ret.height=dojo.html.setPositivePixelValue(node,"height",_261);
}
return ret;
};
dojo.html.getElementBox=function(node,type){
var bs=dojo.html.boxSizing;
switch(type){
case bs.MARGIN_BOX:
return dojo.html.getMarginBox(node);
case bs.BORDER_BOX:
return dojo.html.getBorderBox(node);
case bs.PADDING_BOX:
return dojo.html.getPaddingBox(node);
case bs.CONTENT_BOX:
default:
return dojo.html.getContentBox(node);
}
};
dojo.html.toCoordinateObject=dojo.html.toCoordinateArray=function(_269,_26a,_26b){
if(!_269.nodeType&&!(_269 instanceof String||typeof _269=="string")&&("width" in _269||"height" in _269||"left" in _269||"x" in _269||"top" in _269||"y" in _269)){
var ret={left:_269.left||_269.x||0,top:_269.top||_269.y||0,width:_269.width||0,height:_269.height||0};
}else{
var node=dojo.byId(_269);
var pos=dojo.html.abs(node,_26a,_26b);
var _26f=dojo.html.getMarginBox(node);
var ret={left:pos.left,top:pos.top,width:_26f.width,height:_26f.height};
}
ret.x=ret.left;
ret.y=ret.top;
return ret;
};
dojo.html.setMarginBoxWidth=dojo.html.setOuterWidth=function(node,_271){
return dojo.html._callDeprecated("setMarginBoxWidth","setMarginBox",arguments,"width");
};
dojo.html.setMarginBoxHeight=dojo.html.setOuterHeight=function(){
return dojo.html._callDeprecated("setMarginBoxHeight","setMarginBox",arguments,"height");
};
dojo.html.getMarginBoxWidth=dojo.html.getOuterWidth=function(){
return dojo.html._callDeprecated("getMarginBoxWidth","getMarginBox",arguments,null,"width");
};
dojo.html.getMarginBoxHeight=dojo.html.getOuterHeight=function(){
return dojo.html._callDeprecated("getMarginBoxHeight","getMarginBox",arguments,null,"height");
};
dojo.html.getTotalOffset=function(node,type,_274){
return dojo.html._callDeprecated("getTotalOffset","getAbsolutePosition",arguments,null,type);
};
dojo.html.getAbsoluteX=function(node,_276){
return dojo.html._callDeprecated("getAbsoluteX","getAbsolutePosition",arguments,null,"x");
};
dojo.html.getAbsoluteY=function(node,_278){
return dojo.html._callDeprecated("getAbsoluteY","getAbsolutePosition",arguments,null,"y");
};
dojo.html.totalOffsetLeft=function(node,_27a){
return dojo.html._callDeprecated("totalOffsetLeft","getAbsolutePosition",arguments,null,"left");
};
dojo.html.totalOffsetTop=function(node,_27c){
return dojo.html._callDeprecated("totalOffsetTop","getAbsolutePosition",arguments,null,"top");
};
dojo.html.getMarginWidth=function(node){
return dojo.html._callDeprecated("getMarginWidth","getMargin",arguments,null,"width");
};
dojo.html.getMarginHeight=function(node){
return dojo.html._callDeprecated("getMarginHeight","getMargin",arguments,null,"height");
};
dojo.html.getBorderWidth=function(node){
return dojo.html._callDeprecated("getBorderWidth","getBorder",arguments,null,"width");
};
dojo.html.getBorderHeight=function(node){
return dojo.html._callDeprecated("getBorderHeight","getBorder",arguments,null,"height");
};
dojo.html.getPaddingWidth=function(node){
return dojo.html._callDeprecated("getPaddingWidth","getPadding",arguments,null,"width");
};
dojo.html.getPaddingHeight=function(node){
return dojo.html._callDeprecated("getPaddingHeight","getPadding",arguments,null,"height");
};
dojo.html.getPadBorderWidth=function(node){
return dojo.html._callDeprecated("getPadBorderWidth","getPadBorder",arguments,null,"width");
};
dojo.html.getPadBorderHeight=function(node){
return dojo.html._callDeprecated("getPadBorderHeight","getPadBorder",arguments,null,"height");
};
dojo.html.getBorderBoxWidth=dojo.html.getInnerWidth=function(){
return dojo.html._callDeprecated("getBorderBoxWidth","getBorderBox",arguments,null,"width");
};
dojo.html.getBorderBoxHeight=dojo.html.getInnerHeight=function(){
return dojo.html._callDeprecated("getBorderBoxHeight","getBorderBox",arguments,null,"height");
};
dojo.html.getContentBoxWidth=dojo.html.getContentWidth=function(){
return dojo.html._callDeprecated("getContentBoxWidth","getContentBox",arguments,null,"width");
};
dojo.html.getContentBoxHeight=dojo.html.getContentHeight=function(){
return dojo.html._callDeprecated("getContentBoxHeight","getContentBox",arguments,null,"height");
};
dojo.html.setContentBoxWidth=dojo.html.setContentWidth=function(node,_286){
return dojo.html._callDeprecated("setContentBoxWidth","setContentBox",arguments,"width");
};
dojo.html.setContentBoxHeight=dojo.html.setContentHeight=function(node,_288){
return dojo.html._callDeprecated("setContentBoxHeight","setContentBox",arguments,"height");
};
dojo.provide("dojo.html.util");
dojo.html.getElementWindow=function(_289){
return dojo.html.getDocumentWindow(_289.ownerDocument);
};
dojo.html.getDocumentWindow=function(doc){
if(dojo.render.html.safari&&!doc._parentWindow){
var fix=function(win){
win.document._parentWindow=win;
for(var i=0;i<win.frames.length;i++){
fix(win.frames[i]);
}
};
fix(window.top);
}
if(dojo.render.html.ie&&window!==document.parentWindow&&!doc._parentWindow){
doc.parentWindow.execScript("document._parentWindow = window;","Javascript");
var win=doc._parentWindow;
doc._parentWindow=null;
return win;
}
return doc._parentWindow||doc.parentWindow||doc.defaultView;
};
dojo.html.getAbsolutePositionExt=function(node,_290,_291,_292){
var _293=dojo.html.getElementWindow(node);
var ret=dojo.withGlobal(_293,"getAbsolutePosition",dojo.html,arguments);
var win=dojo.html.getElementWindow(node);
if(_292!=win&&win.frameElement){
var ext=dojo.html.getAbsolutePositionExt(win.frameElement,_290,_291,_292);
ret.x+=ext.x;
ret.y+=ext.y;
}
ret.top=ret.y;
ret.left=ret.x;
return ret;
};
dojo.html.gravity=function(node,e){
node=dojo.byId(node);
var _299=dojo.html.getCursorPosition(e);
with(dojo.html){
var _29a=getAbsolutePosition(node,true);
var bb=getBorderBox(node);
var _29c=_29a.x+(bb.width/2);
var _29d=_29a.y+(bb.height/2);
}
with(dojo.html.gravity){
return ((_299.x<_29c?WEST:EAST)|(_299.y<_29d?NORTH:SOUTH));
}
};
dojo.html.gravity.NORTH=1;
dojo.html.gravity.SOUTH=1<<1;
dojo.html.gravity.EAST=1<<2;
dojo.html.gravity.WEST=1<<3;
dojo.html.overElement=function(_29e,e){
_29e=dojo.byId(_29e);
var _2a0=dojo.html.getCursorPosition(e);
var bb=dojo.html.getBorderBox(_29e);
var _2a2=dojo.html.getAbsolutePosition(_29e,true,dojo.html.boxSizing.BORDER_BOX);
var top=_2a2.y;
var _2a4=top+bb.height;
var left=_2a2.x;
var _2a6=left+bb.width;
return (_2a0.x>=left&&_2a0.x<=_2a6&&_2a0.y>=top&&_2a0.y<=_2a4);
};
dojo.html.renderedTextContent=function(node){
node=dojo.byId(node);
var _2a8="";
if(node==null){
return _2a8;
}
for(var i=0;i<node.childNodes.length;i++){
switch(node.childNodes[i].nodeType){
case 1:
case 5:
var _2aa="unknown";
try{
_2aa=dojo.html.getStyle(node.childNodes[i],"display");
}
catch(E){
}
switch(_2aa){
case "block":
case "list-item":
case "run-in":
case "table":
case "table-row-group":
case "table-header-group":
case "table-footer-group":
case "table-row":
case "table-column-group":
case "table-column":
case "table-cell":
case "table-caption":
_2a8+="\n";
_2a8+=dojo.html.renderedTextContent(node.childNodes[i]);
_2a8+="\n";
break;
case "none":
break;
default:
if(node.childNodes[i].tagName&&node.childNodes[i].tagName.toLowerCase()=="br"){
_2a8+="\n";
}else{
_2a8+=dojo.html.renderedTextContent(node.childNodes[i]);
}
break;
}
break;
case 3:
case 2:
case 4:
var text=node.childNodes[i].nodeValue;
var _2ac="unknown";
try{
_2ac=dojo.html.getStyle(node,"text-transform");
}
catch(E){
}
switch(_2ac){
case "capitalize":
var _2ad=text.split(" ");
for(var i=0;i<_2ad.length;i++){
_2ad[i]=_2ad[i].charAt(0).toUpperCase()+_2ad[i].substring(1);
}
text=_2ad.join(" ");
break;
case "uppercase":
text=text.toUpperCase();
break;
case "lowercase":
text=text.toLowerCase();
break;
default:
break;
}
switch(_2ac){
case "nowrap":
break;
case "pre-wrap":
break;
case "pre-line":
break;
case "pre":
break;
default:
text=text.replace(/\s+/," ");
if(/\s$/.test(_2a8)){
text.replace(/^\s/,"");
}
break;
}
_2a8+=text;
break;
default:
break;
}
}
return _2a8;
};
dojo.html.createNodesFromText=function(txt,trim){
if(trim){
txt=txt.replace(/^\s+|\s+$/g,"");
}
var tn=dojo.doc().createElement("div");
tn.style.visibility="hidden";
dojo.body().appendChild(tn);
var _2b1="none";
if((/^<t[dh][\s\r\n>]/i).test(txt.replace(/^\s+/))){
txt="<table><tbody><tr>"+txt+"</tr></tbody></table>";
_2b1="cell";
}else{
if((/^<tr[\s\r\n>]/i).test(txt.replace(/^\s+/))){
txt="<table><tbody>"+txt+"</tbody></table>";
_2b1="row";
}else{
if((/^<(thead|tbody|tfoot)[\s\r\n>]/i).test(txt.replace(/^\s+/))){
txt="<table>"+txt+"</table>";
_2b1="section";
}
}
}
tn.innerHTML=txt;
if(tn["normalize"]){
tn.normalize();
}
var _2b2=null;
switch(_2b1){
case "cell":
_2b2=tn.getElementsByTagName("tr")[0];
break;
case "row":
_2b2=tn.getElementsByTagName("tbody")[0];
break;
case "section":
_2b2=tn.getElementsByTagName("table")[0];
break;
default:
_2b2=tn;
break;
}
var _2b3=[];
for(var x=0;x<_2b2.childNodes.length;x++){
_2b3.push(_2b2.childNodes[x].cloneNode(true));
}
tn.style.display="none";
dojo.html.destroyNode(tn);
return _2b3;
};
dojo.html.placeOnScreen=function(node,_2b6,_2b7,_2b8,_2b9,_2ba,_2bb){
if(_2b6 instanceof Array||typeof _2b6=="array"){
_2bb=_2ba;
_2ba=_2b9;
_2b9=_2b8;
_2b8=_2b7;
_2b7=_2b6[1];
_2b6=_2b6[0];
}
if(_2ba instanceof String||typeof _2ba=="string"){
_2ba=_2ba.split(",");
}
if(!isNaN(_2b8)){
_2b8=[Number(_2b8),Number(_2b8)];
}else{
if(!(_2b8 instanceof Array||typeof _2b8=="array")){
_2b8=[0,0];
}
}
var _2bc=dojo.html.getScroll().offset;
var view=dojo.html.getViewport();
node=dojo.byId(node);
var _2be=node.style.display;
node.style.display="";
var bb=dojo.html.getBorderBox(node);
var w=bb.width;
var h=bb.height;
node.style.display=_2be;
if(!(_2ba instanceof Array||typeof _2ba=="array")){
_2ba=["TL"];
}
var _2c2,_2c3,_2c4=Infinity,_2c5;
for(var _2c6=0;_2c6<_2ba.length;++_2c6){
var _2c7=_2ba[_2c6];
var _2c8=true;
var tryX=_2b6-(_2c7.charAt(1)=="L"?0:w)+_2b8[0]*(_2c7.charAt(1)=="L"?1:-1);
var tryY=_2b7-(_2c7.charAt(0)=="T"?0:h)+_2b8[1]*(_2c7.charAt(0)=="T"?1:-1);
if(_2b9){
tryX-=_2bc.x;
tryY-=_2bc.y;
}
if(tryX<0){
tryX=0;
_2c8=false;
}
if(tryY<0){
tryY=0;
_2c8=false;
}
var x=tryX+w;
if(x>view.width){
x=view.width-w;
_2c8=false;
}else{
x=tryX;
}
x=Math.max(_2b8[0],x)+_2bc.x;
var y=tryY+h;
if(y>view.height){
y=view.height-h;
_2c8=false;
}else{
y=tryY;
}
y=Math.max(_2b8[1],y)+_2bc.y;
if(_2c8){
_2c2=x;
_2c3=y;
_2c4=0;
_2c5=_2c7;
break;
}else{
var dist=Math.pow(x-tryX-_2bc.x,2)+Math.pow(y-tryY-_2bc.y,2);
if(_2c4>dist){
_2c4=dist;
_2c2=x;
_2c3=y;
_2c5=_2c7;
}
}
}
if(!_2bb){
node.style.left=_2c2+"px";
node.style.top=_2c3+"px";
}
return {left:_2c2,top:_2c3,x:_2c2,y:_2c3,dist:_2c4,corner:_2c5};
};
dojo.html.placeOnScreenAroundElement=function(node,_2cf,_2d0,_2d1,_2d2,_2d3){
var best,_2d5=Infinity;
_2cf=dojo.byId(_2cf);
var _2d6=_2cf.style.display;
_2cf.style.display="";
var mb=dojo.html.getElementBox(_2cf,_2d1);
var _2d8=mb.width;
var _2d9=mb.height;
var _2da=dojo.html.getAbsolutePosition(_2cf,true,_2d1);
_2cf.style.display=_2d6;
for(var _2db in _2d2){
var pos,_2dd,_2de;
var _2df=_2d2[_2db];
_2dd=_2da.x+(_2db.charAt(1)=="L"?0:_2d8);
_2de=_2da.y+(_2db.charAt(0)=="T"?0:_2d9);
pos=dojo.html.placeOnScreen(node,_2dd,_2de,_2d0,true,_2df,true);
if(pos.dist==0){
best=pos;
break;
}else{
if(_2d5>pos.dist){
_2d5=pos.dist;
best=pos;
}
}
}
if(!_2d3){
node.style.left=best.left+"px";
node.style.top=best.top+"px";
}
return best;
};
dojo.html.scrollIntoView=function(node){
if(!node){
return;
}
if(dojo.render.html.ie){
if(dojo.html.getBorderBox(node.parentNode).height<=node.parentNode.scrollHeight){
node.scrollIntoView(false);
}
}else{
if(dojo.render.html.mozilla){
node.scrollIntoView(false);
}else{
var _2e1=node.parentNode;
var _2e2=_2e1.scrollTop+dojo.html.getBorderBox(_2e1).height;
var _2e3=node.offsetTop+dojo.html.getMarginBox(node).height;
if(_2e2<_2e3){
_2e1.scrollTop+=(_2e3-_2e2);
}else{
if(_2e1.scrollTop>node.offsetTop){
_2e1.scrollTop-=(_2e1.scrollTop-node.offsetTop);
}
}
}
}
};
dojo.html.isLeftToRight=function(node){
for(;node;node=node.parentNode){
if(node.dir){
return node.dir=="ltr";
}
}
return true;
};
dojo.provide("dojo.lang.array");
dojo.lang.mixin(dojo.lang,{has:function(obj,name){
try{
return typeof obj[name]!="undefined";
}
catch(e){
return false;
}
},isEmpty:function(obj){
if(dojo.lang.isArrayLike(obj)||dojo.lang.isString(obj)){
return obj.length===0;
}else{
if(dojo.lang.isObject(obj)){
var tmp={};
for(var x in obj){
if(obj[x]&&(!tmp[x])){
return false;
}
}
return true;
}
}
},map:function(arr,obj,_2ec){
var _2ed=dojo.lang.isString(arr);
if(_2ed){
arr=arr.split("");
}
if(dojo.lang.isFunction(obj)&&(!_2ec)){
_2ec=obj;
obj=dj_global;
}else{
if(dojo.lang.isFunction(obj)&&_2ec){
var _2ee=obj;
obj=_2ec;
_2ec=_2ee;
}
}
if(Array.map){
var _2ef=Array.map(arr,_2ec,obj);
}else{
var _2ef=[];
for(var i=0;i<arr.length;++i){
_2ef.push(_2ec.call(obj,arr[i]));
}
}
if(_2ed){
return _2ef.join("");
}else{
return _2ef;
}
},reduce:function(arr,_2f2,_2f3,_2f4){
var _2f5=_2f3;
if(arguments.length==2){
_2f5=arr[0];
arr=arr.slice(1);
}
var ob=_2f4||dj_global;
dojo.lang.map(arr,function(val){
_2f5=_2f2.call(ob,_2f5,val);
});
return _2f5;
},forEach:function(_2f8,_2f9,_2fa){
if(dojo.lang.isString(_2f8)){
_2f8=_2f8.split("");
}
if(Array.forEach){
Array.forEach(_2f8,_2f9,_2fa);
}else{
if(!_2fa){
_2fa=dj_global;
}
for(var i=0,l=_2f8.length;i<l;i++){
_2f9.call(_2fa,_2f8[i],i,_2f8);
}
}
},_everyOrSome:function(_2fd,arr,_2ff,_300){
if(dojo.lang.isString(arr)){
arr=arr.split("");
}
if(Array.every){
return Array[_2fd?"every":"some"](arr,_2ff,_300);
}else{
if(!_300){
_300=dj_global;
}
for(var i=0,l=arr.length;i<l;i++){
var _303=_2ff.call(_300,arr[i],i,arr);
if(_2fd&&!_303){
return false;
}else{
if((!_2fd)&&(_303)){
return true;
}
}
}
return Boolean(_2fd);
}
},every:function(arr,_305,_306){
return this._everyOrSome(true,arr,_305,_306);
},some:function(arr,_308,_309){
return this._everyOrSome(false,arr,_308,_309);
},filter:function(arr,_30b,_30c){
var _30d=dojo.lang.isString(arr);
if(_30d){
arr=arr.split("");
}
var _30e;
if(Array.filter){
_30e=Array.filter(arr,_30b,_30c);
}else{
if(!_30c){
if(arguments.length>=3){
dojo.raise("thisObject doesn't exist!");
}
_30c=dj_global;
}
_30e=[];
for(var i=0;i<arr.length;i++){
if(_30b.call(_30c,arr[i],i,arr)){
_30e.push(arr[i]);
}
}
}
if(_30d){
return _30e.join("");
}else{
return _30e;
}
},unnest:function(){
var out=[];
for(var i=0;i<arguments.length;i++){
if(dojo.lang.isArrayLike(arguments[i])){
var add=dojo.lang.unnest.apply(this,arguments[i]);
out=out.concat(add);
}else{
out.push(arguments[i]);
}
}
return out;
},toArray:function(_313,_314){
var _315=[];
for(var i=_314||0;i<_313.length;i++){
_315.push(_313[i]);
}
return _315;
}});
dojo.provide("dojo.gfx.color");
dojo.gfx.color.Color=function(r,g,b,a){
if(dojo.lang.isArray(r)){
this.r=r[0];
this.g=r[1];
this.b=r[2];
this.a=r[3]||1;
}else{
if(dojo.lang.isString(r)){
var rgb=dojo.gfx.color.extractRGB(r);
this.r=rgb[0];
this.g=rgb[1];
this.b=rgb[2];
this.a=g||1;
}else{
if(r instanceof dojo.gfx.color.Color){
this.r=r.r;
this.b=r.b;
this.g=r.g;
this.a=r.a;
}else{
this.r=r;
this.g=g;
this.b=b;
this.a=a;
}
}
}
};
dojo.gfx.color.Color.fromArray=function(arr){
return new dojo.gfx.color.Color(arr[0],arr[1],arr[2],arr[3]);
};
dojo.extend(dojo.gfx.color.Color,{toRgb:function(_31d){
if(_31d){
return this.toRgba();
}else{
return [this.r,this.g,this.b];
}
},toRgba:function(){
return [this.r,this.g,this.b,this.a];
},toHex:function(){
return dojo.gfx.color.rgb2hex(this.toRgb());
},toCss:function(){
return "rgb("+this.toRgb().join()+")";
},toString:function(){
return this.toHex();
},blend:function(_31e,_31f){
var rgb=null;
if(dojo.lang.isArray(_31e)){
rgb=_31e;
}else{
if(_31e instanceof dojo.gfx.color.Color){
rgb=_31e.toRgb();
}else{
rgb=new dojo.gfx.color.Color(_31e).toRgb();
}
}
return dojo.gfx.color.blend(this.toRgb(),rgb,_31f);
}});
dojo.gfx.color.named={white:[255,255,255],black:[0,0,0],red:[255,0,0],green:[0,255,0],lime:[0,255,0],blue:[0,0,255],navy:[0,0,128],gray:[128,128,128],silver:[192,192,192]};
dojo.gfx.color.blend=function(a,b,_323){
if(typeof a=="string"){
return dojo.gfx.color.blendHex(a,b,_323);
}
if(!_323){
_323=0;
}
_323=Math.min(Math.max(-1,_323),1);
_323=((_323+1)/2);
var c=[];
for(var x=0;x<3;x++){
c[x]=parseInt(b[x]+((a[x]-b[x])*_323));
}
return c;
};
dojo.gfx.color.blendHex=function(a,b,_328){
return dojo.gfx.color.rgb2hex(dojo.gfx.color.blend(dojo.gfx.color.hex2rgb(a),dojo.gfx.color.hex2rgb(b),_328));
};
dojo.gfx.color.extractRGB=function(_329){
_329=_329.toLowerCase();
if(_329.indexOf("rgb")==0){
var _32a=_329.match(/rgba*\((\d+), *(\d+), *(\d+)/i);
var ret=_32a.splice(1,3);
return ret;
}else{
var _32c=dojo.gfx.color.hex2rgb(_329);
if(_32c){
return _32c;
}else{
return dojo.gfx.color.named[_329]||[255,255,255];
}
}
};
dojo.gfx.color.hex2rgb=function(hex){
var _32e="0123456789ABCDEF";
var rgb=new Array(3);
if(hex.indexOf("#")==0){
hex=hex.substring(1);
}
hex=hex.toUpperCase();
if(hex.replace(new RegExp("["+_32e+"]","g"),"")!=""){
return null;
}
if(hex.length==3){
rgb[0]=hex.charAt(0)+hex.charAt(0);
rgb[1]=hex.charAt(1)+hex.charAt(1);
rgb[2]=hex.charAt(2)+hex.charAt(2);
}else{
rgb[0]=hex.substring(0,2);
rgb[1]=hex.substring(2,4);
rgb[2]=hex.substring(4);
}
for(var i=0;i<rgb.length;i++){
rgb[i]=_32e.indexOf(rgb[i].charAt(0))*16+_32e.indexOf(rgb[i].charAt(1));
}
return rgb;
};
dojo.gfx.color.rgb2hex=function(r,g,b){
if(dojo.lang.isArray(r)){
g=r[1]||0;
b=r[2]||0;
r=r[0]||0;
}
var ret=dojo.lang.map([r,g,b],function(x){
x=new Number(x);
var s=x.toString(16);
while(s.length<2){
s="0"+s;
}
return s;
});
ret.unshift("#");
return ret.join("");
};
dojo.provide("dojo.lang.func");
dojo.lang.hitch=function(_337,_338){
var args=[];
for(var x=2;x<arguments.length;x++){
args.push(arguments[x]);
}
var fcn=(dojo.lang.isString(_338)?_337[_338]:_338)||function(){
};
return function(){
var ta=args.concat([]);
for(var x=0;x<arguments.length;x++){
ta.push(arguments[x]);
}
return fcn.apply(_337,ta);
};
};
dojo.lang.anonCtr=0;
dojo.lang.anon={};
dojo.lang.nameAnonFunc=function(_33e,_33f,_340){
var isIE=(dojo.render.html.capable&&dojo.render.html["ie"]);
var jpn="$joinpoint";
var nso=(_33f||dojo.lang.anon);
if(isIE){
var cn=_33e["__dojoNameCache"];
if(cn&&nso[cn]===_33e){
return _33e["__dojoNameCache"];
}else{
if(cn){
var _345=cn.indexOf(jpn);
if(_345!=-1){
return cn.substring(0,_345);
}
}
}
}
if((_340)||((dj_global["djConfig"])&&(djConfig["slowAnonFuncLookups"]==true))){
for(var x in nso){
try{
if(nso[x]===_33e){
if(isIE){
_33e["__dojoNameCache"]=x;
var _345=x.indexOf(jpn);
if(_345!=-1){
x=x.substring(0,_345);
}
}
return x;
}
}
catch(e){
}
}
}
var ret="__"+dojo.lang.anonCtr++;
while(typeof nso[ret]!="undefined"){
ret="__"+dojo.lang.anonCtr++;
}
nso[ret]=_33e;
return ret;
};
dojo.lang.forward=function(_348){
return function(){
return this[_348].apply(this,arguments);
};
};
dojo.lang.curry=function(_349,func){
var _34b=[];
_349=_349||dj_global;
if(dojo.lang.isString(func)){
func=_349[func];
}
for(var x=2;x<arguments.length;x++){
_34b.push(arguments[x]);
}
var _34d=(func["__preJoinArity"]||func.length)-_34b.length;
function gather(_34e,_34f,_350){
var _351=_350;
var _352=_34f.slice(0);
for(var x=0;x<_34e.length;x++){
_352.push(_34e[x]);
}
_350=_350-_34e.length;
if(_350<=0){
var res=func.apply(_349,_352);
_350=_351;
return res;
}else{
return function(){
return gather(arguments,_352,_350);
};
}
}
return gather([],_34b,_34d);
};
dojo.lang.curryArguments=function(_355,func,args,_358){
var _359=[];
var x=_358||0;
for(x=_358;x<args.length;x++){
_359.push(args[x]);
}
return dojo.lang.curry.apply(dojo.lang,[_355,func].concat(_359));
};
dojo.lang.tryThese=function(){
for(var x=0;x<arguments.length;x++){
try{
if(typeof arguments[x]=="function"){
var ret=(arguments[x]());
if(ret){
return ret;
}
}
}
catch(e){
dojo.debug(e);
}
}
};
dojo.lang.delayThese=function(farr,cb,_35f,_360){
if(!farr.length){
if(typeof _360=="function"){
_360();
}
return;
}
if((typeof _35f=="undefined")&&(typeof cb=="number")){
_35f=cb;
cb=function(){
};
}else{
if(!cb){
cb=function(){
};
if(!_35f){
_35f=0;
}
}
}
setTimeout(function(){
(farr.shift())();
cb();
dojo.lang.delayThese(farr,cb,_35f,_360);
},_35f);
};
dojo.provide("dojo.lfx.Animation");
dojo.lfx.Line=function(_361,end){
this.start=_361;
this.end=end;
if(dojo.lang.isArray(_361)){
var diff=[];
dojo.lang.forEach(this.start,function(s,i){
diff[i]=this.end[i]-s;
},this);
this.getValue=function(n){
var res=[];
dojo.lang.forEach(this.start,function(s,i){
res[i]=(diff[i]*n)+s;
},this);
return res;
};
}else{
var diff=end-_361;
this.getValue=function(n){
return (diff*n)+this.start;
};
}
};
if((dojo.render.html.khtml)&&(!dojo.render.html.safari)){
dojo.lfx.easeDefault=function(n){
return (parseFloat("0.5")+((Math.sin((n+parseFloat("1.5"))*Math.PI))/2));
};
}else{
dojo.lfx.easeDefault=function(n){
return (0.5+((Math.sin((n+1.5)*Math.PI))/2));
};
}
dojo.lfx.easeIn=function(n){
return Math.pow(n,3);
};
dojo.lfx.easeOut=function(n){
return (1-Math.pow(1-n,3));
};
dojo.lfx.easeInOut=function(n){
return ((3*Math.pow(n,2))-(2*Math.pow(n,3)));
};
dojo.lfx.IAnimation=function(){
};
dojo.lang.extend(dojo.lfx.IAnimation,{curve:null,duration:1000,easing:null,repeatCount:0,rate:10,handler:null,beforeBegin:null,onBegin:null,onAnimate:null,onEnd:null,onPlay:null,onPause:null,onStop:null,play:null,pause:null,stop:null,connect:function(evt,_371,_372){
if(!_372){
_372=_371;
_371=this;
}
_372=dojo.lang.hitch(_371,_372);
var _373=this[evt]||function(){
};
this[evt]=function(){
var ret=_373.apply(this,arguments);
_372.apply(this,arguments);
return ret;
};
return this;
},fire:function(evt,args){
if(this[evt]){
this[evt].apply(this,(args||[]));
}
return this;
},repeat:function(_377){
this.repeatCount=_377;
return this;
},_active:false,_paused:false});
dojo.lfx.Animation=function(_378,_379,_37a,_37b,_37c,rate){
dojo.lfx.IAnimation.call(this);
if(dojo.lang.isNumber(_378)||(!_378&&_379.getValue)){
rate=_37c;
_37c=_37b;
_37b=_37a;
_37a=_379;
_379=_378;
_378=null;
}else{
if(_378.getValue||dojo.lang.isArray(_378)){
rate=_37b;
_37c=_37a;
_37b=_379;
_37a=_378;
_379=null;
_378=null;
}
}
if(dojo.lang.isArray(_37a)){
this.curve=new dojo.lfx.Line(_37a[0],_37a[1]);
}else{
this.curve=_37a;
}
if(_379!=null&&_379>0){
this.duration=_379;
}
if(_37c){
this.repeatCount=_37c;
}
if(rate){
this.rate=rate;
}
if(_378){
dojo.lang.forEach(["handler","beforeBegin","onBegin","onEnd","onPlay","onStop","onAnimate"],function(item){
if(_378[item]){
this.connect(item,_378[item]);
}
},this);
}
if(_37b&&dojo.lang.isFunction(_37b)){
this.easing=_37b;
}
};
dojo.inherits(dojo.lfx.Animation,dojo.lfx.IAnimation);
dojo.lang.extend(dojo.lfx.Animation,{_startTime:null,_endTime:null,_timer:null,_percent:0,_startRepeatCount:0,play:function(_37f,_380){
if(_380){
clearTimeout(this._timer);
this._active=false;
this._paused=false;
this._percent=0;
}else{
if(this._active&&!this._paused){
return this;
}
}
this.fire("handler",["beforeBegin"]);
this.fire("beforeBegin");
if(_37f>0){
setTimeout(dojo.lang.hitch(this,function(){
this.play(null,_380);
}),_37f);
return this;
}
this._startTime=new Date().valueOf();
if(this._paused){
this._startTime-=(this.duration*this._percent/100);
}
this._endTime=this._startTime+this.duration;
this._active=true;
this._paused=false;
var step=this._percent/100;
var _382=this.curve.getValue(step);
if(this._percent==0){
if(!this._startRepeatCount){
this._startRepeatCount=this.repeatCount;
}
this.fire("handler",["begin",_382]);
this.fire("onBegin",[_382]);
}
this.fire("handler",["play",_382]);
this.fire("onPlay",[_382]);
this._cycle();
return this;
},pause:function(){
clearTimeout(this._timer);
if(!this._active){
return this;
}
this._paused=true;
var _383=this.curve.getValue(this._percent/100);
this.fire("handler",["pause",_383]);
this.fire("onPause",[_383]);
return this;
},gotoPercent:function(pct,_385){
clearTimeout(this._timer);
this._active=true;
this._paused=true;
this._percent=pct;
if(_385){
this.play();
}
return this;
},stop:function(_386){
clearTimeout(this._timer);
var step=this._percent/100;
if(_386){
step=1;
}
var _388=this.curve.getValue(step);
this.fire("handler",["stop",_388]);
this.fire("onStop",[_388]);
this._active=false;
this._paused=false;
return this;
},status:function(){
if(this._active){
return this._paused?"paused":"playing";
}else{
return "stopped";
}
return this;
},_cycle:function(){
clearTimeout(this._timer);
if(this._active){
var curr=new Date().valueOf();
var step=(curr-this._startTime)/(this._endTime-this._startTime);
if(step>=1){
step=1;
this._percent=100;
}else{
this._percent=step*100;
}
if((this.easing)&&(dojo.lang.isFunction(this.easing))){
step=this.easing(step);
}
var _38b=this.curve.getValue(step);
this.fire("handler",["animate",_38b]);
this.fire("onAnimate",[_38b]);
if(step<1){
this._timer=setTimeout(dojo.lang.hitch(this,"_cycle"),this.rate);
}else{
this._active=false;
this.fire("handler",["end"]);
this.fire("onEnd");
if(this.repeatCount>0){
this.repeatCount--;
this.play(null,true);
}else{
if(this.repeatCount==-1){
this.play(null,true);
}else{
if(this._startRepeatCount){
this.repeatCount=this._startRepeatCount;
this._startRepeatCount=0;
}
}
}
}
}
return this;
}});
dojo.lfx.Combine=function(_38c){
dojo.lfx.IAnimation.call(this);
this._anims=[];
this._animsEnded=0;
var _38d=arguments;
if(_38d.length==1&&(dojo.lang.isArray(_38d[0])||dojo.lang.isArrayLike(_38d[0]))){
_38d=_38d[0];
}
dojo.lang.forEach(_38d,function(anim){
this._anims.push(anim);
anim.connect("onEnd",dojo.lang.hitch(this,"_onAnimsEnded"));
},this);
};
dojo.inherits(dojo.lfx.Combine,dojo.lfx.IAnimation);
dojo.lang.extend(dojo.lfx.Combine,{_animsEnded:0,play:function(_38f,_390){
if(!this._anims.length){
return this;
}
this.fire("beforeBegin");
if(_38f>0){
setTimeout(dojo.lang.hitch(this,function(){
this.play(null,_390);
}),_38f);
return this;
}
if(_390||this._anims[0].percent==0){
this.fire("onBegin");
}
this.fire("onPlay");
this._animsCall("play",null,_390);
return this;
},pause:function(){
this.fire("onPause");
this._animsCall("pause");
return this;
},stop:function(_391){
this.fire("onStop");
this._animsCall("stop",_391);
return this;
},_onAnimsEnded:function(){
this._animsEnded++;
if(this._animsEnded>=this._anims.length){
this.fire("onEnd");
}
return this;
},_animsCall:function(_392){
var args=[];
if(arguments.length>1){
for(var i=1;i<arguments.length;i++){
args.push(arguments[i]);
}
}
var _395=this;
dojo.lang.forEach(this._anims,function(anim){
anim[_392](args);
},_395);
return this;
}});
dojo.lfx.Chain=function(_397){
dojo.lfx.IAnimation.call(this);
this._anims=[];
this._currAnim=-1;
var _398=arguments;
if(_398.length==1&&(dojo.lang.isArray(_398[0])||dojo.lang.isArrayLike(_398[0]))){
_398=_398[0];
}
var _399=this;
dojo.lang.forEach(_398,function(anim,i,_39c){
this._anims.push(anim);
if(i<_39c.length-1){
anim.connect("onEnd",dojo.lang.hitch(this,"_playNext"));
}else{
anim.connect("onEnd",dojo.lang.hitch(this,function(){
this.fire("onEnd");
}));
}
},this);
};
dojo.inherits(dojo.lfx.Chain,dojo.lfx.IAnimation);
dojo.lang.extend(dojo.lfx.Chain,{_currAnim:-1,play:function(_39d,_39e){
if(!this._anims.length){
return this;
}
if(_39e||!this._anims[this._currAnim]){
this._currAnim=0;
}
var _39f=this._anims[this._currAnim];
this.fire("beforeBegin");
if(_39d>0){
setTimeout(dojo.lang.hitch(this,function(){
this.play(null,_39e);
}),_39d);
return this;
}
if(_39f){
if(this._currAnim==0){
this.fire("handler",["begin",this._currAnim]);
this.fire("onBegin",[this._currAnim]);
}
this.fire("onPlay",[this._currAnim]);
_39f.play(null,_39e);
}
return this;
},pause:function(){
if(this._anims[this._currAnim]){
this._anims[this._currAnim].pause();
this.fire("onPause",[this._currAnim]);
}
return this;
},playPause:function(){
if(this._anims.length==0){
return this;
}
if(this._currAnim==-1){
this._currAnim=0;
}
var _3a0=this._anims[this._currAnim];
if(_3a0){
if(!_3a0._active||_3a0._paused){
this.play();
}else{
this.pause();
}
}
return this;
},stop:function(){
var _3a1=this._anims[this._currAnim];
if(_3a1){
_3a1.stop();
this.fire("onStop",[this._currAnim]);
}
return _3a1;
},_playNext:function(){
if(this._currAnim==-1||this._anims.length==0){
return this;
}
this._currAnim++;
if(this._anims[this._currAnim]){
this._anims[this._currAnim].play(null,true);
}
return this;
}});
dojo.lfx.combine=function(_3a2){
var _3a3=arguments;
if(dojo.lang.isArray(arguments[0])){
_3a3=arguments[0];
}
if(_3a3.length==1){
return _3a3[0];
}
return new dojo.lfx.Combine(_3a3);
};
dojo.lfx.chain=function(_3a4){
var _3a5=arguments;
if(dojo.lang.isArray(arguments[0])){
_3a5=arguments[0];
}
if(_3a5.length==1){
return _3a5[0];
}
return new dojo.lfx.Chain(_3a5);
};
dojo.provide("dojo.html.color");
dojo.html.getBackgroundColor=function(node){
node=dojo.byId(node);
var _3a7;
do{
_3a7=dojo.html.getStyle(node,"background-color");
if(_3a7.toLowerCase()=="rgba(0, 0, 0, 0)"){
_3a7="transparent";
}
if(node==document.getElementsByTagName("body")[0]){
node=null;
break;
}
node=node.parentNode;
}while(node&&dojo.lang.inArray(["transparent",""],_3a7));
if(_3a7=="transparent"){
_3a7=[255,255,255,0];
}else{
_3a7=dojo.gfx.color.extractRGB(_3a7);
}
return _3a7;
};
dojo.provide("dojo.lfx.html");
dojo.lfx.html._byId=function(_3a8){
if(!_3a8){
return [];
}
if(dojo.lang.isArrayLike(_3a8)){
if(!_3a8.alreadyChecked){
var n=[];
dojo.lang.forEach(_3a8,function(node){
n.push(dojo.byId(node));
});
n.alreadyChecked=true;
return n;
}else{
return _3a8;
}
}else{
var n=[];
n.push(dojo.byId(_3a8));
n.alreadyChecked=true;
return n;
}
};
dojo.lfx.html.propertyAnimation=function(_3ab,_3ac,_3ad,_3ae,_3af){
_3ab=dojo.lfx.html._byId(_3ab);
var _3b0={"propertyMap":_3ac,"nodes":_3ab,"duration":_3ad,"easing":_3ae||dojo.lfx.easeDefault};
var _3b1=function(args){
if(args.nodes.length==1){
var pm=args.propertyMap;
if(!dojo.lang.isArray(args.propertyMap)){
var parr=[];
for(var _3b5 in pm){
pm[_3b5].property=_3b5;
parr.push(pm[_3b5]);
}
pm=args.propertyMap=parr;
}
dojo.lang.forEach(pm,function(prop){
if(dj_undef("start",prop)){
if(prop.property!="opacity"){
prop.start=parseInt(dojo.html.getComputedStyle(args.nodes[0],prop.property));
}else{
prop.start=dojo.html.getOpacity(args.nodes[0]);
}
}
});
}
};
var _3b7=function(_3b8){
var _3b9=[];
dojo.lang.forEach(_3b8,function(c){
_3b9.push(Math.round(c));
});
return _3b9;
};
var _3bb=function(n,_3bd){
n=dojo.byId(n);
if(!n||!n.style){
return;
}
for(var s in _3bd){
try{
if(s=="opacity"){
dojo.html.setOpacity(n,_3bd[s]);
}else{
n.style[s]=_3bd[s];
}
}
catch(e){
dojo.debug(e);
}
}
};
var _3bf=function(_3c0){
this._properties=_3c0;
this.diffs=new Array(_3c0.length);
dojo.lang.forEach(_3c0,function(prop,i){
if(dojo.lang.isFunction(prop.start)){
prop.start=prop.start(prop,i);
}
if(dojo.lang.isFunction(prop.end)){
prop.end=prop.end(prop,i);
}
if(dojo.lang.isArray(prop.start)){
this.diffs[i]=null;
}else{
if(prop.start instanceof dojo.gfx.color.Color){
prop.startRgb=prop.start.toRgb();
prop.endRgb=prop.end.toRgb();
}else{
this.diffs[i]=prop.end-prop.start;
}
}
},this);
this.getValue=function(n){
var ret={};
dojo.lang.forEach(this._properties,function(prop,i){
var _3c7=null;
if(dojo.lang.isArray(prop.start)){
}else{
if(prop.start instanceof dojo.gfx.color.Color){
_3c7=(prop.units||"rgb")+"(";
for(var j=0;j<prop.startRgb.length;j++){
_3c7+=Math.round(((prop.endRgb[j]-prop.startRgb[j])*n)+prop.startRgb[j])+(j<prop.startRgb.length-1?",":"");
}
_3c7+=")";
}else{
_3c7=((this.diffs[i])*n)+prop.start+(prop.property!="opacity"?prop.units||"px":"");
}
}
ret[dojo.html.toCamelCase(prop.property)]=_3c7;
},this);
return ret;
};
};
var anim=new dojo.lfx.Animation({beforeBegin:function(){
_3b1(_3b0);
anim.curve=new _3bf(_3b0.propertyMap);
},onAnimate:function(_3ca){
dojo.lang.forEach(_3b0.nodes,function(node){
_3bb(node,_3ca);
});
}},_3b0.duration,null,_3b0.easing);
if(_3af){
for(var x in _3af){
if(dojo.lang.isFunction(_3af[x])){
anim.connect(x,anim,_3af[x]);
}
}
}
return anim;
};
dojo.lfx.html._makeFadeable=function(_3cd){
var _3ce=function(node){
if(dojo.render.html.ie){
if((node.style.zoom.length==0)&&(dojo.html.getStyle(node,"zoom")=="normal")){
node.style.zoom="1";
}
if((node.style.width.length==0)&&(dojo.html.getStyle(node,"width")=="auto")){
node.style.width="auto";
}
}
};
if(dojo.lang.isArrayLike(_3cd)){
dojo.lang.forEach(_3cd,_3ce);
}else{
_3ce(_3cd);
}
};
dojo.lfx.html.fade=function(_3d0,_3d1,_3d2,_3d3,_3d4){
_3d0=dojo.lfx.html._byId(_3d0);
var _3d5={property:"opacity"};
if(!dj_undef("start",_3d1)){
_3d5.start=_3d1.start;
}else{
_3d5.start=function(){
return dojo.html.getOpacity(_3d0[0]);
};
}
if(!dj_undef("end",_3d1)){
_3d5.end=_3d1.end;
}else{
dojo.raise("dojo.lfx.html.fade needs an end value");
}
var anim=dojo.lfx.propertyAnimation(_3d0,[_3d5],_3d2,_3d3);
anim.connect("beforeBegin",function(){
dojo.lfx.html._makeFadeable(_3d0);
});
if(_3d4){
anim.connect("onEnd",function(){
_3d4(_3d0,anim);
});
}
return anim;
};
dojo.lfx.html.fadeIn=function(_3d7,_3d8,_3d9,_3da){
return dojo.lfx.html.fade(_3d7,{end:1},_3d8,_3d9,_3da);
};
dojo.lfx.html.fadeOut=function(_3db,_3dc,_3dd,_3de){
return dojo.lfx.html.fade(_3db,{end:0},_3dc,_3dd,_3de);
};
dojo.lfx.html.fadeShow=function(_3df,_3e0,_3e1,_3e2){
_3df=dojo.lfx.html._byId(_3df);
dojo.lang.forEach(_3df,function(node){
dojo.html.setOpacity(node,0);
});
var anim=dojo.lfx.html.fadeIn(_3df,_3e0,_3e1,_3e2);
anim.connect("beforeBegin",function(){
if(dojo.lang.isArrayLike(_3df)){
dojo.lang.forEach(_3df,dojo.html.show);
}else{
dojo.html.show(_3df);
}
});
return anim;
};
dojo.lfx.html.fadeHide=function(_3e5,_3e6,_3e7,_3e8){
var anim=dojo.lfx.html.fadeOut(_3e5,_3e6,_3e7,function(){
if(dojo.lang.isArrayLike(_3e5)){
dojo.lang.forEach(_3e5,dojo.html.hide);
}else{
dojo.html.hide(_3e5);
}
if(_3e8){
_3e8(_3e5,anim);
}
});
return anim;
};
dojo.lfx.html.wipeIn=function(_3ea,_3eb,_3ec,_3ed){
_3ea=dojo.lfx.html._byId(_3ea);
var _3ee=[];
dojo.lang.forEach(_3ea,function(node){
var _3f0={};
with(node.style){
visibility="hidden";
display="";
}
var _3f1=dojo.html.getBorderBox(node).height;
with(node.style){
visibility="";
display="none";
}
var anim=dojo.lfx.propertyAnimation(node,{"height":{start:1,end:function(){
return _3f1;
}}},_3eb,_3ec);
anim.connect("beforeBegin",function(){
_3f0.overflow=node.style.overflow;
_3f0.height=node.style.height;
with(node.style){
overflow="hidden";
height="1px";
}
dojo.html.show(node);
});
anim.connect("onEnd",function(){
with(node.style){
overflow=_3f0.overflow;
height=_3f0.height;
}
if(_3ed){
_3ed(node,anim);
}
});
_3ee.push(anim);
});
return dojo.lfx.combine(_3ee);
};
dojo.lfx.html.wipeOut=function(_3f3,_3f4,_3f5,_3f6){
_3f3=dojo.lfx.html._byId(_3f3);
var _3f7=[];
dojo.lang.forEach(_3f3,function(node){
var _3f9={};
var anim=dojo.lfx.propertyAnimation(node,{"height":{start:function(){
return dojo.html.getContentBox(node).height;
},end:1}},_3f4,_3f5,{"beforeBegin":function(){
_3f9.overflow=node.style.overflow;
_3f9.height=node.style.height;
with(node.style){
overflow="hidden";
}
dojo.html.show(node);
},"onEnd":function(){
dojo.html.hide(node);
with(node.style){
overflow=_3f9.overflow;
height=_3f9.height;
}
if(_3f6){
_3f6(node,anim);
}
}});
_3f7.push(anim);
});
return dojo.lfx.combine(_3f7);
};
dojo.lfx.html.slideTo=function(_3fb,_3fc,_3fd,_3fe,_3ff){
_3fb=dojo.lfx.html._byId(_3fb);
var _400=[];
var _401=dojo.html.getComputedStyle;
dojo.lang.forEach(_3fb,function(node){
var top=null;
var left=null;
var init=(function(){
var _406=node;
return function(){
var pos=_401(_406,"position");
top=(pos=="absolute"?node.offsetTop:parseInt(_401(node,"top"))||0);
left=(pos=="absolute"?node.offsetLeft:parseInt(_401(node,"left"))||0);
if(!dojo.lang.inArray(["absolute","relative"],pos)){
var ret=dojo.html.abs(_406,true);
dojo.html.setStyleAttributes(_406,"position:absolute;top:"+ret.y+"px;left:"+ret.x+"px;");
top=ret.y;
left=ret.x;
}
};
})();
init();
var anim=dojo.lfx.propertyAnimation(node,{"top":{start:top,end:(_3fc.top||0)},"left":{start:left,end:(_3fc.left||0)}},_3fd,_3fe,{"beforeBegin":init});
if(_3ff){
anim.connect("onEnd",function(){
_3ff(_3fb,anim);
});
}
_400.push(anim);
});
return dojo.lfx.combine(_400);
};
dojo.lfx.html.slideBy=function(_40a,_40b,_40c,_40d,_40e){
_40a=dojo.lfx.html._byId(_40a);
var _40f=[];
var _410=dojo.html.getComputedStyle;
dojo.lang.forEach(_40a,function(node){
var top=null;
var left=null;
var init=(function(){
var _415=node;
return function(){
var pos=_410(_415,"position");
top=(pos=="absolute"?node.offsetTop:parseInt(_410(node,"top"))||0);
left=(pos=="absolute"?node.offsetLeft:parseInt(_410(node,"left"))||0);
if(!dojo.lang.inArray(["absolute","relative"],pos)){
var ret=dojo.html.abs(_415,true);
dojo.html.setStyleAttributes(_415,"position:absolute;top:"+ret.y+"px;left:"+ret.x+"px;");
top=ret.y;
left=ret.x;
}
};
})();
init();
var anim=dojo.lfx.propertyAnimation(node,{"top":{start:top,end:top+(_40b.top||0)},"left":{start:left,end:left+(_40b.left||0)}},_40c,_40d).connect("beforeBegin",init);
if(_40e){
anim.connect("onEnd",function(){
_40e(_40a,anim);
});
}
_40f.push(anim);
});
return dojo.lfx.combine(_40f);
};
dojo.lfx.html.explode=function(_419,_41a,_41b,_41c,_41d){
var h=dojo.html;
_419=dojo.byId(_419);
_41a=dojo.byId(_41a);
var _41f=h.toCoordinateObject(_419,true);
var _420=document.createElement("div");
h.copyStyle(_420,_41a);
if(_41a.explodeClassName){
_420.className=_41a.explodeClassName;
}
with(_420.style){
position="absolute";
display="none";
var _421=h.getStyle(_419,"background-color");
backgroundColor=_421?_421.toLowerCase():"transparent";
backgroundColor=(backgroundColor=="transparent")?"rgb(221, 221, 221)":backgroundColor;
}
dojo.body().appendChild(_420);
with(_41a.style){
visibility="hidden";
display="block";
}
var _422=h.toCoordinateObject(_41a,true);
with(_41a.style){
display="none";
visibility="visible";
}
var _423={opacity:{start:0.5,end:1}};
dojo.lang.forEach(["height","width","top","left"],function(type){
_423[type]={start:_41f[type],end:_422[type]};
});
var anim=new dojo.lfx.propertyAnimation(_420,_423,_41b,_41c,{"beforeBegin":function(){
h.setDisplay(_420,"block");
},"onEnd":function(){
h.setDisplay(_41a,"block");
_420.parentNode.removeChild(_420);
}});
if(_41d){
anim.connect("onEnd",function(){
_41d(_41a,anim);
});
}
return anim;
};
dojo.lfx.html.implode=function(_426,end,_428,_429,_42a){
var h=dojo.html;
_426=dojo.byId(_426);
end=dojo.byId(end);
var _42c=dojo.html.toCoordinateObject(_426,true);
var _42d=dojo.html.toCoordinateObject(end,true);
var _42e=document.createElement("div");
dojo.html.copyStyle(_42e,_426);
if(_426.explodeClassName){
_42e.className=_426.explodeClassName;
}
dojo.html.setOpacity(_42e,0.3);
with(_42e.style){
position="absolute";
display="none";
backgroundColor=h.getStyle(_426,"background-color").toLowerCase();
}
dojo.body().appendChild(_42e);
var _42f={opacity:{start:1,end:0.5}};
dojo.lang.forEach(["height","width","top","left"],function(type){
_42f[type]={start:_42c[type],end:_42d[type]};
});
var anim=new dojo.lfx.propertyAnimation(_42e,_42f,_428,_429,{"beforeBegin":function(){
dojo.html.hide(_426);
dojo.html.show(_42e);
},"onEnd":function(){
_42e.parentNode.removeChild(_42e);
}});
if(_42a){
anim.connect("onEnd",function(){
_42a(_426,anim);
});
}
return anim;
};
dojo.lfx.html.highlight=function(_432,_433,_434,_435,_436){
_432=dojo.lfx.html._byId(_432);
var _437=[];
dojo.lang.forEach(_432,function(node){
var _439=dojo.html.getBackgroundColor(node);
var bg=dojo.html.getStyle(node,"background-color").toLowerCase();
var _43b=dojo.html.getStyle(node,"background-image");
var _43c=(bg=="transparent"||bg=="rgba(0, 0, 0, 0)");
while(_439.length>3){
_439.pop();
}
var rgb=new dojo.gfx.color.Color(_433);
var _43e=new dojo.gfx.color.Color(_439);
var anim=dojo.lfx.propertyAnimation(node,{"background-color":{start:rgb,end:_43e}},_434,_435,{"beforeBegin":function(){
if(_43b){
node.style.backgroundImage="none";
}
node.style.backgroundColor="rgb("+rgb.toRgb().join(",")+")";
},"onEnd":function(){
if(_43b){
node.style.backgroundImage=_43b;
}
if(_43c){
node.style.backgroundColor="transparent";
}
if(_436){
_436(node,anim);
}
}});
_437.push(anim);
});
return dojo.lfx.combine(_437);
};
dojo.lfx.html.unhighlight=function(_440,_441,_442,_443,_444){
_440=dojo.lfx.html._byId(_440);
var _445=[];
dojo.lang.forEach(_440,function(node){
var _447=new dojo.gfx.color.Color(dojo.html.getBackgroundColor(node));
var rgb=new dojo.gfx.color.Color(_441);
var _449=dojo.html.getStyle(node,"background-image");
var anim=dojo.lfx.propertyAnimation(node,{"background-color":{start:_447,end:rgb}},_442,_443,{"beforeBegin":function(){
if(_449){
node.style.backgroundImage="none";
}
node.style.backgroundColor="rgb("+_447.toRgb().join(",")+")";
},"onEnd":function(){
if(_444){
_444(node,anim);
}
}});
_445.push(anim);
});
return dojo.lfx.combine(_445);
};
dojo.lang.mixin(dojo.lfx,dojo.lfx.html);
dojo.kwCompoundRequire({browser:["dojo.lfx.html"],dashboard:["dojo.lfx.html"]});
dojo.provide("dojo.lfx.*");
dojo.provide("dojo.lang.extras");
dojo.lang.setTimeout=function(func,_44c){
var _44d=window,_44e=2;
if(!dojo.lang.isFunction(func)){
_44d=func;
func=_44c;
_44c=arguments[2];
_44e++;
}
if(dojo.lang.isString(func)){
func=_44d[func];
}
var args=[];
for(var i=_44e;i<arguments.length;i++){
args.push(arguments[i]);
}
return dojo.global().setTimeout(function(){
func.apply(_44d,args);
},_44c);
};
dojo.lang.clearTimeout=function(_451){
dojo.global().clearTimeout(_451);
};
dojo.lang.getNameInObj=function(ns,item){
if(!ns){
ns=dj_global;
}
for(var x in ns){
if(ns[x]===item){
return new String(x);
}
}
return null;
};
dojo.lang.shallowCopy=function(obj,deep){
var i,ret;
if(obj===null){
return null;
}
if(dojo.lang.isObject(obj)){
ret=new obj.constructor();
for(i in obj){
if(dojo.lang.isUndefined(ret[i])){
ret[i]=deep?dojo.lang.shallowCopy(obj[i],deep):obj[i];
}
}
}else{
if(dojo.lang.isArray(obj)){
ret=[];
for(i=0;i<obj.length;i++){
ret[i]=deep?dojo.lang.shallowCopy(obj[i],deep):obj[i];
}
}else{
ret=obj;
}
}
return ret;
};
dojo.lang.firstValued=function(){
for(var i=0;i<arguments.length;i++){
if(typeof arguments[i]!="undefined"){
return arguments[i];
}
}
return undefined;
};
dojo.lang.getObjPathValue=function(_45a,_45b,_45c){
dojo.deprecated("dojo.lang.getObjPathValue","use dojo.getObject","0.6");
with(dojo.parseObjPath(_45a,_45b,_45c)){
return dojo.evalProp(prop,obj,_45c);
}
};
dojo.lang.setObjPathValue=function(_45d,_45e,_45f,_460){
dojo.deprecated("dojo.lang.setObjPathValue","use dojo.parseObjPath and the '=' operator","0.6");
if(arguments.length<4){
_460=true;
}
with(dojo.parseObjPath(_45d,_45f,_460)){
if(obj&&(_460||(prop in obj))){
obj[prop]=_45e;
}
}
};
dojo.provide("dojo.event.common");
dojo.event=new function(){
this._canTimeout=dojo.lang.isFunction(dj_global["setTimeout"])||dojo.lang.isAlien(dj_global["setTimeout"]);
function interpolateArgs(args,_462){
var dl=dojo.lang;
var ao={srcObj:dj_global,srcFunc:null,adviceObj:dj_global,adviceFunc:null,aroundObj:null,aroundFunc:null,adviceType:(args.length>2)?args[0]:"after",precedence:"last",once:false,delay:null,rate:0,adviceMsg:false,maxCalls:-1};
switch(args.length){
case 0:
return;
case 1:
return;
case 2:
ao.srcFunc=args[0];
ao.adviceFunc=args[1];
break;
case 3:
if((dl.isObject(args[0]))&&(dl.isString(args[1]))&&(dl.isString(args[2]))){
ao.adviceType="after";
ao.srcObj=args[0];
ao.srcFunc=args[1];
ao.adviceFunc=args[2];
}else{
if((dl.isString(args[1]))&&(dl.isString(args[2]))){
ao.srcFunc=args[1];
ao.adviceFunc=args[2];
}else{
if((dl.isObject(args[0]))&&(dl.isString(args[1]))&&(dl.isFunction(args[2]))){
ao.adviceType="after";
ao.srcObj=args[0];
ao.srcFunc=args[1];
var _465=dl.nameAnonFunc(args[2],ao.adviceObj,_462);
ao.adviceFunc=_465;
}else{
if((dl.isFunction(args[0]))&&(dl.isObject(args[1]))&&(dl.isString(args[2]))){
ao.adviceType="after";
ao.srcObj=dj_global;
var _465=dl.nameAnonFunc(args[0],ao.srcObj,_462);
ao.srcFunc=_465;
ao.adviceObj=args[1];
ao.adviceFunc=args[2];
}
}
}
}
break;
case 4:
if((dl.isObject(args[0]))&&(dl.isObject(args[2]))){
ao.adviceType="after";
ao.srcObj=args[0];
ao.srcFunc=args[1];
ao.adviceObj=args[2];
ao.adviceFunc=args[3];
}else{
if((dl.isString(args[0]))&&(dl.isString(args[1]))&&(dl.isObject(args[2]))){
ao.adviceType=args[0];
ao.srcObj=dj_global;
ao.srcFunc=args[1];
ao.adviceObj=args[2];
ao.adviceFunc=args[3];
}else{
if((dl.isString(args[0]))&&(dl.isFunction(args[1]))&&(dl.isObject(args[2]))){
ao.adviceType=args[0];
ao.srcObj=dj_global;
var _465=dl.nameAnonFunc(args[1],dj_global,_462);
ao.srcFunc=_465;
ao.adviceObj=args[2];
ao.adviceFunc=args[3];
}else{
if((dl.isString(args[0]))&&(dl.isObject(args[1]))&&(dl.isString(args[2]))&&(dl.isFunction(args[3]))){
ao.srcObj=args[1];
ao.srcFunc=args[2];
var _465=dl.nameAnonFunc(args[3],dj_global,_462);
ao.adviceObj=dj_global;
ao.adviceFunc=_465;
}else{
if(dl.isObject(args[1])){
ao.srcObj=args[1];
ao.srcFunc=args[2];
ao.adviceObj=dj_global;
ao.adviceFunc=args[3];
}else{
if(dl.isObject(args[2])){
ao.srcObj=dj_global;
ao.srcFunc=args[1];
ao.adviceObj=args[2];
ao.adviceFunc=args[3];
}else{
ao.srcObj=ao.adviceObj=ao.aroundObj=dj_global;
ao.srcFunc=args[1];
ao.adviceFunc=args[2];
ao.aroundFunc=args[3];
}
}
}
}
}
}
break;
case 6:
ao.srcObj=args[1];
ao.srcFunc=args[2];
ao.adviceObj=args[3];
ao.adviceFunc=args[4];
ao.aroundFunc=args[5];
ao.aroundObj=dj_global;
break;
default:
ao.srcObj=args[1];
ao.srcFunc=args[2];
ao.adviceObj=args[3];
ao.adviceFunc=args[4];
ao.aroundObj=args[5];
ao.aroundFunc=args[6];
ao.once=args[7];
ao.delay=args[8];
ao.rate=args[9];
ao.adviceMsg=args[10];
ao.maxCalls=(!isNaN(parseInt(args[11])))?args[11]:-1;
break;
}
if(dl.isFunction(ao.aroundFunc)){
var _465=dl.nameAnonFunc(ao.aroundFunc,ao.aroundObj,_462);
ao.aroundFunc=_465;
}
if(dl.isFunction(ao.srcFunc)){
ao.srcFunc=dl.getNameInObj(ao.srcObj,ao.srcFunc);
}
if(dl.isFunction(ao.adviceFunc)){
ao.adviceFunc=dl.getNameInObj(ao.adviceObj,ao.adviceFunc);
}
if((ao.aroundObj)&&(dl.isFunction(ao.aroundFunc))){
ao.aroundFunc=dl.getNameInObj(ao.aroundObj,ao.aroundFunc);
}
if(!ao.srcObj){
dojo.raise("bad srcObj for srcFunc: "+ao.srcFunc);
}
if(!ao.adviceObj){
dojo.raise("bad adviceObj for adviceFunc: "+ao.adviceFunc);
}
if(!ao.adviceFunc){
dojo.debug("bad adviceFunc for srcFunc: "+ao.srcFunc);
dojo.debugShallow(ao);
}
return ao;
}
this.connect=function(){
if(arguments.length==1){
var ao=arguments[0];
}else{
var ao=interpolateArgs(arguments,true);
}
if(dojo.lang.isString(ao.srcFunc)&&(ao.srcFunc.toLowerCase()=="onkey")){
if(dojo.render.html.ie){
ao.srcFunc="onkeydown";
this.connect(ao);
}
ao.srcFunc="onkeypress";
}
if(dojo.lang.isArray(ao.srcObj)&&ao.srcObj!=""){
var _467={};
for(var x in ao){
_467[x]=ao[x];
}
var mjps=[];
dojo.lang.forEach(ao.srcObj,function(src){
if((dojo.render.html.capable)&&(dojo.lang.isString(src))){
src=dojo.byId(src);
}
_467.srcObj=src;
mjps.push(dojo.event.connect.call(dojo.event,_467));
});
return mjps;
}
var mjp=dojo.event.MethodJoinPoint.getForMethod(ao.srcObj,ao.srcFunc);
if(ao.adviceFunc){
var mjp2=dojo.event.MethodJoinPoint.getForMethod(ao.adviceObj,ao.adviceFunc);
}
mjp.kwAddAdvice(ao);
return mjp;
};
this.log=function(a1,a2){
var _46f;
if((arguments.length==1)&&(typeof a1=="object")){
_46f=a1;
}else{
_46f={srcObj:a1,srcFunc:a2};
}
_46f.adviceFunc=function(){
var _470=[];
for(var x=0;x<arguments.length;x++){
_470.push(arguments[x]);
}
dojo.debug("("+_46f.srcObj+")."+_46f.srcFunc,":",_470.join(", "));
};
this.kwConnect(_46f);
};
this.connectBefore=function(){
var args=["before"];
for(var i=0;i<arguments.length;i++){
args.push(arguments[i]);
}
return this.connect.apply(this,args);
};
this.connectAround=function(){
var args=["around"];
for(var i=0;i<arguments.length;i++){
args.push(arguments[i]);
}
return this.connect.apply(this,args);
};
this.connectOnce=function(){
var ao=interpolateArgs(arguments,true);
ao.once=true;
return this.connect(ao);
};
this.connectRunOnce=function(){
var ao=interpolateArgs(arguments,true);
ao.maxCalls=1;
return this.connect(ao);
};
this._kwConnectImpl=function(_478,_479){
var fn=(_479)?"disconnect":"connect";
if(typeof _478["srcFunc"]=="function"){
_478.srcObj=_478["srcObj"]||dj_global;
var _47b=dojo.lang.nameAnonFunc(_478.srcFunc,_478.srcObj,true);
_478.srcFunc=_47b;
}
if(typeof _478["adviceFunc"]=="function"){
_478.adviceObj=_478["adviceObj"]||dj_global;
var _47b=dojo.lang.nameAnonFunc(_478.adviceFunc,_478.adviceObj,true);
_478.adviceFunc=_47b;
}
_478.srcObj=_478["srcObj"]||dj_global;
_478.adviceObj=_478["adviceObj"]||_478["targetObj"]||dj_global;
_478.adviceFunc=_478["adviceFunc"]||_478["targetFunc"];
return dojo.event[fn](_478);
};
this.kwConnect=function(_47c){
return this._kwConnectImpl(_47c,false);
};
this.disconnect=function(){
if(arguments.length==1){
var ao=arguments[0];
}else{
var ao=interpolateArgs(arguments,true);
}
if(!ao.adviceFunc){
return;
}
if(dojo.lang.isString(ao.srcFunc)&&(ao.srcFunc.toLowerCase()=="onkey")){
if(dojo.render.html.ie){
ao.srcFunc="onkeydown";
this.disconnect(ao);
}
ao.srcFunc="onkeypress";
}
if(!ao.srcObj[ao.srcFunc]){
return null;
}
var mjp=dojo.event.MethodJoinPoint.getForMethod(ao.srcObj,ao.srcFunc,true);
mjp.removeAdvice(ao.adviceObj,ao.adviceFunc,ao.adviceType,ao.once);
return mjp;
};
this.kwDisconnect=function(_47f){
return this._kwConnectImpl(_47f,true);
};
};
dojo.event.MethodInvocation=function(_480,obj,args){
this.jp_=_480;
this.object=obj;
this.args=[];
for(var x=0;x<args.length;x++){
this.args[x]=args[x];
}
this.around_index=-1;
};
dojo.event.MethodInvocation.prototype.proceed=function(){
this.around_index++;
if(this.around_index>=this.jp_.around.length){
return this.jp_.object[this.jp_.methodname].apply(this.jp_.object,this.args);
}else{
var ti=this.jp_.around[this.around_index];
var mobj=ti[0]||dj_global;
var meth=ti[1];
return mobj[meth].call(mobj,this);
}
};
dojo.event.MethodJoinPoint=function(obj,_488){
this.object=obj||dj_global;
this.methodname=_488;
this.methodfunc=this.object[_488];
};
dojo.event.MethodJoinPoint.getForMethod=function(obj,_48a){
if(!obj){
obj=dj_global;
}
var ofn=obj[_48a];
if(!ofn){
ofn=obj[_48a]=function(){
};
if(!obj[_48a]){
dojo.raise("Cannot set do-nothing method on that object "+_48a);
}
}else{
if((typeof ofn!="function")&&(!dojo.lang.isFunction(ofn))&&(!dojo.lang.isAlien(ofn))){
return null;
}
}
var _48c=_48a+"$joinpoint";
var _48d=_48a+"$joinpoint$method";
var _48e=obj[_48c];
if(!_48e){
var _48f=false;
if(dojo.event["browser"]){
if((obj["attachEvent"])||(obj["nodeType"])||(obj["addEventListener"])){
_48f=true;
dojo.event.browser.addClobberNodeAttrs(obj,[_48c,_48d,_48a]);
}
}
var _490=ofn.length;
obj[_48d]=ofn;
_48e=obj[_48c]=new dojo.event.MethodJoinPoint(obj,_48d);
if(!_48f){
obj[_48a]=function(){
return _48e.run.apply(_48e,arguments);
};
}else{
obj[_48a]=function(){
var args=[];
if(!arguments.length){
var evt=null;
try{
if(obj.ownerDocument){
evt=obj.ownerDocument.parentWindow.event;
}else{
if(obj.documentElement){
evt=obj.documentElement.ownerDocument.parentWindow.event;
}else{
if(obj.event){
evt=obj.event;
}else{
evt=window.event;
}
}
}
}
catch(e){
evt=window.event;
}
if(evt){
args.push(dojo.event.browser.fixEvent(evt,this));
}
}else{
for(var x=0;x<arguments.length;x++){
if((x==0)&&(dojo.event.browser.isEvent(arguments[x]))){
args.push(dojo.event.browser.fixEvent(arguments[x],this));
}else{
args.push(arguments[x]);
}
}
}
return _48e.run.apply(_48e,args);
};
}
obj[_48a].__preJoinArity=_490;
}
return _48e;
};
dojo.lang.extend(dojo.event.MethodJoinPoint,{squelch:false,unintercept:function(){
this.object[this.methodname]=this.methodfunc;
this.before=[];
this.after=[];
this.around=[];
},disconnect:dojo.lang.forward("unintercept"),run:function(){
var obj=this.object||dj_global;
var args=arguments;
var _496=[];
for(var x=0;x<args.length;x++){
_496[x]=args[x];
}
var _498=function(marr){
if(!marr){
dojo.debug("Null argument to unrollAdvice()");
return;
}
var _49a=marr[0]||dj_global;
var _49b=marr[1];
if(!_49a[_49b]){
dojo.raise("function \""+_49b+"\" does not exist on \""+_49a+"\"");
}
var _49c=marr[2]||dj_global;
var _49d=marr[3];
var msg=marr[6];
var _49f=marr[7];
if(_49f>-1){
if(_49f==0){
return;
}
marr[7]--;
}
var _4a0;
var to={args:[],jp_:this,object:obj,proceed:function(){
return _49a[_49b].apply(_49a,to.args);
}};
to.args=_496;
var _4a2=parseInt(marr[4]);
var _4a3=((!isNaN(_4a2))&&(marr[4]!==null)&&(typeof marr[4]!="undefined"));
if(marr[5]){
var rate=parseInt(marr[5]);
var cur=new Date();
var _4a6=false;
if((marr["last"])&&((cur-marr.last)<=rate)){
if(dojo.event._canTimeout){
if(marr["delayTimer"]){
clearTimeout(marr.delayTimer);
}
var tod=parseInt(rate*2);
var mcpy=dojo.lang.shallowCopy(marr);
marr.delayTimer=setTimeout(function(){
mcpy[5]=0;
_498(mcpy);
},tod);
}
return;
}else{
marr.last=cur;
}
}
if(_49d){
_49c[_49d].call(_49c,to);
}else{
if((_4a3)&&((dojo.render.html)||(dojo.render.svg))){
dj_global["setTimeout"](function(){
if(msg){
_49a[_49b].call(_49a,to);
}else{
_49a[_49b].apply(_49a,args);
}
},_4a2);
}else{
if(msg){
_49a[_49b].call(_49a,to);
}else{
_49a[_49b].apply(_49a,args);
}
}
}
};
var _4a9=function(){
if(this.squelch){
try{
return _498.apply(this,arguments);
}
catch(e){
dojo.debug(e);
}
}else{
return _498.apply(this,arguments);
}
};
if((this["before"])&&(this.before.length>0)){
dojo.lang.forEach(this.before.concat(new Array()),_4a9);
}
var _4aa;
try{
if((this["around"])&&(this.around.length>0)){
var mi=new dojo.event.MethodInvocation(this,obj,args);
_4aa=mi.proceed();
}else{
if(this.methodfunc){
_4aa=this.object[this.methodname].apply(this.object,args);
}
}
}
catch(e){
if(!this.squelch){
dojo.debug(e,"when calling",this.methodname,"on",this.object,"with arguments",args);
dojo.raise(e);
}
}
if((this["after"])&&(this.after.length>0)){
dojo.lang.forEach(this.after.concat(new Array()),_4a9);
}
return (this.methodfunc)?_4aa:null;
},getArr:function(kind){
var type="after";
if((typeof kind=="string")&&(kind.indexOf("before")!=-1)){
type="before";
}else{
if(kind=="around"){
type="around";
}
}
if(!this[type]){
this[type]=[];
}
return this[type];
},kwAddAdvice:function(args){
this.addAdvice(args["adviceObj"],args["adviceFunc"],args["aroundObj"],args["aroundFunc"],args["adviceType"],args["precedence"],args["once"],args["delay"],args["rate"],args["adviceMsg"],args["maxCalls"]);
},addAdvice:function(_4af,_4b0,_4b1,_4b2,_4b3,_4b4,once,_4b6,rate,_4b8,_4b9){
var arr=this.getArr(_4b3);
if(!arr){
dojo.raise("bad this: "+this);
}
var ao=[_4af,_4b0,_4b1,_4b2,_4b6,rate,_4b8,_4b9];
if(once){
if(this.hasAdvice(_4af,_4b0,_4b3,arr)>=0){
return;
}
}
if(_4b4=="first"){
arr.unshift(ao);
}else{
arr.push(ao);
}
},hasAdvice:function(_4bc,_4bd,_4be,arr){
if(!arr){
arr=this.getArr(_4be);
}
var ind=-1;
for(var x=0;x<arr.length;x++){
var aao=(typeof _4bd=="object")?(new String(_4bd)).toString():_4bd;
var a1o=(typeof arr[x][1]=="object")?(new String(arr[x][1])).toString():arr[x][1];
if((arr[x][0]==_4bc)&&(a1o==aao)){
ind=x;
}
}
return ind;
},removeAdvice:function(_4c4,_4c5,_4c6,once){
var arr=this.getArr(_4c6);
var ind=this.hasAdvice(_4c4,_4c5,_4c6,arr);
if(ind==-1){
return false;
}
while(ind!=-1){
arr.splice(ind,1);
if(once){
break;
}
ind=this.hasAdvice(_4c4,_4c5,_4c6,arr);
}
return true;
}});
dojo.provide("dojo.event.topic");
dojo.event.topic=new function(){
this.topics={};
this.getTopic=function(_4ca){
if(!this.topics[_4ca]){
this.topics[_4ca]=new this.TopicImpl(_4ca);
}
return this.topics[_4ca];
};
this.registerPublisher=function(_4cb,obj,_4cd){
var _4cb=this.getTopic(_4cb);
_4cb.registerPublisher(obj,_4cd);
};
this.subscribe=function(_4ce,obj,_4d0){
var _4ce=this.getTopic(_4ce);
_4ce.subscribe(obj,_4d0);
};
this.unsubscribe=function(_4d1,obj,_4d3){
var _4d1=this.getTopic(_4d1);
_4d1.unsubscribe(obj,_4d3);
};
this.destroy=function(_4d4){
this.getTopic(_4d4).destroy();
delete this.topics[_4d4];
};
this.publishApply=function(_4d5,args){
var _4d5=this.getTopic(_4d5);
_4d5.sendMessage.apply(_4d5,args);
};
this.publish=function(_4d7,_4d8){
var _4d7=this.getTopic(_4d7);
var args=[];
for(var x=1;x<arguments.length;x++){
args.push(arguments[x]);
}
_4d7.sendMessage.apply(_4d7,args);
};
};
dojo.event.topic.TopicImpl=function(_4db){
this.topicName=_4db;
this.subscribe=function(_4dc,_4dd){
var tf=_4dd||_4dc;
var to=(!_4dd)?dj_global:_4dc;
return dojo.event.kwConnect({srcObj:this,srcFunc:"sendMessage",adviceObj:to,adviceFunc:tf});
};
this.unsubscribe=function(_4e0,_4e1){
var tf=(!_4e1)?_4e0:_4e1;
var to=(!_4e1)?null:_4e0;
return dojo.event.kwDisconnect({srcObj:this,srcFunc:"sendMessage",adviceObj:to,adviceFunc:tf});
};
this._getJoinPoint=function(){
return dojo.event.MethodJoinPoint.getForMethod(this,"sendMessage");
};
this.setSquelch=function(_4e4){
this._getJoinPoint().squelch=_4e4;
};
this.destroy=function(){
this._getJoinPoint().disconnect();
};
this.registerPublisher=function(_4e5,_4e6){
dojo.event.connect(_4e5,_4e6,this,"sendMessage");
};
this.sendMessage=function(_4e7){
};
};
dojo.provide("dojo.event.browser");
dojo._ie_clobber=new function(){
this.clobberNodes=[];
function nukeProp(node,prop){
try{
node[prop]=null;
}
catch(e){
}
try{
delete node[prop];
}
catch(e){
}
try{
node.removeAttribute(prop);
}
catch(e){
}
}
this.clobber=function(_4ea){
var na;
var tna;
if(_4ea){
tna=_4ea.all||_4ea.getElementsByTagName("*");
na=[_4ea];
for(var x=0;x<tna.length;x++){
if(tna[x]["__doClobber__"]){
na.push(tna[x]);
}
}
}else{
try{
window.onload=null;
}
catch(e){
}
na=(this.clobberNodes.length)?this.clobberNodes:document.all;
}
tna=null;
var _4ee={};
for(var i=na.length-1;i>=0;i=i-1){
var el=na[i];
try{
if(el&&el["__clobberAttrs__"]){
for(var j=0;j<el.__clobberAttrs__.length;j++){
nukeProp(el,el.__clobberAttrs__[j]);
}
nukeProp(el,"__clobberAttrs__");
nukeProp(el,"__doClobber__");
}
}
catch(e){
}
}
na=null;
};
};
if(dojo.render.html.ie){
dojo.addOnUnload(function(){
dojo._ie_clobber.clobber();
try{
if((dojo["widget"])&&(dojo.widget["manager"])){
dojo.widget.manager.destroyAll();
}
}
catch(e){
}
if(dojo.widget){
for(var name in dojo.widget._templateCache){
if(dojo.widget._templateCache[name].node){
dojo.dom.destroyNode(dojo.widget._templateCache[name].node);
dojo.widget._templateCache[name].node=null;
delete dojo.widget._templateCache[name].node;
}
}
}
try{
window.onload=null;
}
catch(e){
}
try{
window.onunload=null;
}
catch(e){
}
dojo._ie_clobber.clobberNodes=[];
});
}
dojo.event.browser=new function(){
var _4f3=0;
this.normalizedEventName=function(_4f4){
switch(_4f4){
case "CheckboxStateChange":
case "DOMAttrModified":
case "DOMMenuItemActive":
case "DOMMenuItemInactive":
case "DOMMouseScroll":
case "DOMNodeInserted":
case "DOMNodeRemoved":
case "RadioStateChange":
return _4f4;
break;
default:
var lcn=_4f4.toLowerCase();
return (lcn.indexOf("on")==0)?lcn.substr(2):lcn;
break;
}
};
this.clean=function(node){
if(dojo.render.html.ie){
dojo._ie_clobber.clobber(node);
}
};
this.addClobberNode=function(node){
if(!dojo.render.html.ie){
return;
}
if(!node["__doClobber__"]){
node.__doClobber__=true;
dojo._ie_clobber.clobberNodes.push(node);
node.__clobberAttrs__=[];
}
};
this.addClobberNodeAttrs=function(node,_4f9){
if(!dojo.render.html.ie){
return;
}
this.addClobberNode(node);
for(var x=0;x<_4f9.length;x++){
node.__clobberAttrs__.push(_4f9[x]);
}
};
this.removeListener=function(node,_4fc,fp,_4fe){
if(!_4fe){
var _4fe=false;
}
_4fc=dojo.event.browser.normalizedEventName(_4fc);
if(_4fc=="key"){
if(dojo.render.html.ie){
this.removeListener(node,"onkeydown",fp,_4fe);
}
_4fc="keypress";
}
if(node.removeEventListener){
node.removeEventListener(_4fc,fp,_4fe);
}
};
this.addListener=function(node,_500,fp,_502,_503){
if(!node){
return;
}
if(!_502){
var _502=false;
}
_500=dojo.event.browser.normalizedEventName(_500);
if(_500=="key"){
if(dojo.render.html.ie){
this.addListener(node,"onkeydown",fp,_502,_503);
}
_500="keypress";
}
if(!_503){
var _504=function(evt){
if(!evt){
evt=window.event;
}
var ret=fp(dojo.event.browser.fixEvent(evt,this));
if(_502){
dojo.event.browser.stopEvent(evt);
}
return ret;
};
}else{
_504=fp;
}
if(node.addEventListener){
node.addEventListener(_500,_504,_502);
return _504;
}else{
_500="on"+_500;
if(typeof node[_500]=="function"){
var _507=node[_500];
node[_500]=function(e){
_507(e);
return _504(e);
};
}else{
node[_500]=_504;
}
if(dojo.render.html.ie){
this.addClobberNodeAttrs(node,[_500]);
}
return _504;
}
};
this.isEvent=function(obj){
return (typeof obj!="undefined")&&(obj)&&(typeof Event!="undefined")&&(obj.eventPhase);
};
this.currentEvent=null;
this.callListener=function(_50a,_50b){
if(typeof _50a!="function"){
dojo.raise("listener not a function: "+_50a);
}
dojo.event.browser.currentEvent.currentTarget=_50b;
return _50a.call(_50b,dojo.event.browser.currentEvent);
};
this._stopPropagation=function(){
dojo.event.browser.currentEvent.cancelBubble=true;
};
this._preventDefault=function(){
dojo.event.browser.currentEvent.returnValue=false;
};
this.keys={KEY_BACKSPACE:8,KEY_TAB:9,KEY_CLEAR:12,KEY_ENTER:13,KEY_SHIFT:16,KEY_CTRL:17,KEY_ALT:18,KEY_PAUSE:19,KEY_CAPS_LOCK:20,KEY_ESCAPE:27,KEY_SPACE:32,KEY_PAGE_UP:33,KEY_PAGE_DOWN:34,KEY_END:35,KEY_HOME:36,KEY_LEFT_ARROW:37,KEY_UP_ARROW:38,KEY_RIGHT_ARROW:39,KEY_DOWN_ARROW:40,KEY_INSERT:45,KEY_DELETE:46,KEY_HELP:47,KEY_LEFT_WINDOW:91,KEY_RIGHT_WINDOW:92,KEY_SELECT:93,KEY_NUMPAD_0:96,KEY_NUMPAD_1:97,KEY_NUMPAD_2:98,KEY_NUMPAD_3:99,KEY_NUMPAD_4:100,KEY_NUMPAD_5:101,KEY_NUMPAD_6:102,KEY_NUMPAD_7:103,KEY_NUMPAD_8:104,KEY_NUMPAD_9:105,KEY_NUMPAD_MULTIPLY:106,KEY_NUMPAD_PLUS:107,KEY_NUMPAD_ENTER:108,KEY_NUMPAD_MINUS:109,KEY_NUMPAD_PERIOD:110,KEY_NUMPAD_DIVIDE:111,KEY_F1:112,KEY_F2:113,KEY_F3:114,KEY_F4:115,KEY_F5:116,KEY_F6:117,KEY_F7:118,KEY_F8:119,KEY_F9:120,KEY_F10:121,KEY_F11:122,KEY_F12:123,KEY_F13:124,KEY_F14:125,KEY_F15:126,KEY_NUM_LOCK:144,KEY_SCROLL_LOCK:145};
this.revKeys=[];
for(var key in this.keys){
this.revKeys[this.keys[key]]=key;
}
this.fixEvent=function(evt,_50e){
if(!evt){
if(window["event"]){
evt=window.event;
}
}
if((evt["type"])&&(evt["type"].indexOf("key")==0)){
evt.keys=this.revKeys;
for(var key in this.keys){
evt[key]=this.keys[key];
}
if(evt["type"]=="keydown"&&dojo.render.html.ie){
switch(evt.keyCode){
case evt.KEY_SHIFT:
case evt.KEY_CTRL:
case evt.KEY_ALT:
case evt.KEY_CAPS_LOCK:
case evt.KEY_LEFT_WINDOW:
case evt.KEY_RIGHT_WINDOW:
case evt.KEY_SELECT:
case evt.KEY_NUM_LOCK:
case evt.KEY_SCROLL_LOCK:
case evt.KEY_NUMPAD_0:
case evt.KEY_NUMPAD_1:
case evt.KEY_NUMPAD_2:
case evt.KEY_NUMPAD_3:
case evt.KEY_NUMPAD_4:
case evt.KEY_NUMPAD_5:
case evt.KEY_NUMPAD_6:
case evt.KEY_NUMPAD_7:
case evt.KEY_NUMPAD_8:
case evt.KEY_NUMPAD_9:
case evt.KEY_NUMPAD_PERIOD:
break;
case evt.KEY_NUMPAD_MULTIPLY:
case evt.KEY_NUMPAD_PLUS:
case evt.KEY_NUMPAD_ENTER:
case evt.KEY_NUMPAD_MINUS:
case evt.KEY_NUMPAD_DIVIDE:
break;
case evt.KEY_PAUSE:
case evt.KEY_TAB:
case evt.KEY_BACKSPACE:
case evt.KEY_ENTER:
case evt.KEY_ESCAPE:
case evt.KEY_PAGE_UP:
case evt.KEY_PAGE_DOWN:
case evt.KEY_END:
case evt.KEY_HOME:
case evt.KEY_LEFT_ARROW:
case evt.KEY_UP_ARROW:
case evt.KEY_RIGHT_ARROW:
case evt.KEY_DOWN_ARROW:
case evt.KEY_INSERT:
case evt.KEY_DELETE:
case evt.KEY_F1:
case evt.KEY_F2:
case evt.KEY_F3:
case evt.KEY_F4:
case evt.KEY_F5:
case evt.KEY_F6:
case evt.KEY_F7:
case evt.KEY_F8:
case evt.KEY_F9:
case evt.KEY_F10:
case evt.KEY_F11:
case evt.KEY_F12:
case evt.KEY_F12:
case evt.KEY_F13:
case evt.KEY_F14:
case evt.KEY_F15:
case evt.KEY_CLEAR:
case evt.KEY_HELP:
evt.key=evt.keyCode;
break;
default:
if(evt.ctrlKey||evt.altKey){
var _510=evt.keyCode;
if(_510>=65&&_510<=90&&evt.shiftKey==false){
_510+=32;
}
if(_510>=1&&_510<=26&&evt.ctrlKey){
_510+=96;
}
evt.key=String.fromCharCode(_510);
}
}
}else{
if(evt["type"]=="keypress"){
if(dojo.render.html.opera){
if(evt.which==0){
evt.key=evt.keyCode;
}else{
if(evt.which>0){
switch(evt.which){
case evt.KEY_SHIFT:
case evt.KEY_CTRL:
case evt.KEY_ALT:
case evt.KEY_CAPS_LOCK:
case evt.KEY_NUM_LOCK:
case evt.KEY_SCROLL_LOCK:
break;
case evt.KEY_PAUSE:
case evt.KEY_TAB:
case evt.KEY_BACKSPACE:
case evt.KEY_ENTER:
case evt.KEY_ESCAPE:
evt.key=evt.which;
break;
default:
var _510=evt.which;
if((evt.ctrlKey||evt.altKey||evt.metaKey)&&(evt.which>=65&&evt.which<=90&&evt.shiftKey==false)){
_510+=32;
}
evt.key=String.fromCharCode(_510);
}
}
}
}else{
if(dojo.render.html.ie){
if(!evt.ctrlKey&&!evt.altKey&&evt.keyCode>=evt.KEY_SPACE){
evt.key=String.fromCharCode(evt.keyCode);
}
}else{
if(dojo.render.html.safari){
switch(evt.keyCode){
case 25:
evt.key=evt.KEY_TAB;
evt.shift=true;
break;
case 63232:
evt.key=evt.KEY_UP_ARROW;
break;
case 63233:
evt.key=evt.KEY_DOWN_ARROW;
break;
case 63234:
evt.key=evt.KEY_LEFT_ARROW;
break;
case 63235:
evt.key=evt.KEY_RIGHT_ARROW;
break;
case 63236:
evt.key=evt.KEY_F1;
break;
case 63237:
evt.key=evt.KEY_F2;
break;
case 63238:
evt.key=evt.KEY_F3;
break;
case 63239:
evt.key=evt.KEY_F4;
break;
case 63240:
evt.key=evt.KEY_F5;
break;
case 63241:
evt.key=evt.KEY_F6;
break;
case 63242:
evt.key=evt.KEY_F7;
break;
case 63243:
evt.key=evt.KEY_F8;
break;
case 63244:
evt.key=evt.KEY_F9;
break;
case 63245:
evt.key=evt.KEY_F10;
break;
case 63246:
evt.key=evt.KEY_F11;
break;
case 63247:
evt.key=evt.KEY_F12;
break;
case 63250:
evt.key=evt.KEY_PAUSE;
break;
case 63272:
evt.key=evt.KEY_DELETE;
break;
case 63273:
evt.key=evt.KEY_HOME;
break;
case 63275:
evt.key=evt.KEY_END;
break;
case 63276:
evt.key=evt.KEY_PAGE_UP;
break;
case 63277:
evt.key=evt.KEY_PAGE_DOWN;
break;
case 63302:
evt.key=evt.KEY_INSERT;
break;
case 63248:
case 63249:
case 63289:
break;
default:
evt.key=evt.charCode>=evt.KEY_SPACE?String.fromCharCode(evt.charCode):evt.keyCode;
}
}else{
evt.key=evt.charCode>0?String.fromCharCode(evt.charCode):evt.keyCode;
}
}
}
}
}
}
if(dojo.render.html.ie){
if(!evt.target){
evt.target=evt.srcElement;
}
if(!evt.currentTarget){
evt.currentTarget=(_50e?_50e:evt.srcElement);
}
if(!evt.layerX){
evt.layerX=evt.offsetX;
}
if(!evt.layerY){
evt.layerY=evt.offsetY;
}
var doc=(evt.srcElement&&evt.srcElement.ownerDocument)?evt.srcElement.ownerDocument:document;
var _512=((dojo.render.html.ie55)||(doc["compatMode"]=="BackCompat"))?doc.body:doc.documentElement;
if(!evt.pageX){
evt.pageX=evt.clientX+(_512.scrollLeft||0);
}
if(!evt.pageY){
evt.pageY=evt.clientY+(_512.scrollTop||0);
}
if(evt.type=="mouseover"){
evt.relatedTarget=evt.fromElement;
}
if(evt.type=="mouseout"){
evt.relatedTarget=evt.toElement;
}
this.currentEvent=evt;
evt.callListener=this.callListener;
evt.stopPropagation=this._stopPropagation;
evt.preventDefault=this._preventDefault;
}
return evt;
};
this.stopEvent=function(evt){
if(window.event){
evt.cancelBubble=true;
evt.returnValue=false;
}else{
evt.preventDefault();
evt.stopPropagation();
}
};
};
dojo.kwCompoundRequire({common:["dojo.event.common","dojo.event.topic"],browser:["dojo.event.browser"],dashboard:["dojo.event.browser"]});
dojo.provide("dojo.event.*");
dojo.provide("dojo.lang.declare");
dojo.lang.declare=function(_514,_515,init,_517){
if((dojo.lang.isFunction(_517))||((!_517)&&(!dojo.lang.isFunction(init)))){
if(dojo.lang.isFunction(_517)){
dojo.deprecated("dojo.lang.declare("+_514+"...):","use class, superclass, initializer, properties argument order","0.6");
}
var temp=_517;
_517=init;
init=temp;
}
if(_517&&_517.initializer){
dojo.deprecated("dojo.lang.declare("+_514+"...):","specify initializer as third argument, not as an element in properties","0.6");
}
var _519=[];
if(dojo.lang.isArray(_515)){
_519=_515;
_515=_519.shift();
}
if(!init){
init=dojo.getObject(_514,false);
if((init)&&(!dojo.lang.isFunction(init))){
init=null;
}
}
var ctor=dojo.lang.declare._makeConstructor();
var scp=(_515?_515.prototype:null);
if(scp){
scp.prototyping=true;
ctor.prototype=new _515();
scp.prototyping=false;
}
ctor.superclass=scp;
ctor.mixins=_519;
for(var i=0,l=_519.length;i<l;i++){
dojo.lang.extend(ctor,_519[i].prototype);
}
ctor.prototype.initializer=null;
ctor.prototype.declaredClass=_514;
if(dojo.lang.isArray(_517)){
dojo.lang.extend.apply(dojo.lang,[ctor].concat(_517));
}else{
dojo.lang.extend(ctor,(_517)||{});
}
dojo.lang.extend(ctor,dojo.lang.declare._common);
ctor.prototype.constructor=ctor;
ctor.prototype.initializer=(ctor.prototype.initializer)||(init)||(function(){
});
var _51e=dojo.getObject(_514,true,null,true);
_51e.obj[_51e.prop]=ctor;
return ctor;
};
dojo.lang.declare._makeConstructor=function(){
return function(){
var self=this._getPropContext();
var s=self.constructor.superclass;
if((s)&&(s.constructor)){
if(s.constructor==arguments.callee){
this._inherited("constructor",arguments);
}else{
this._contextMethod(s,"constructor",arguments);
}
}
var ms=(self.constructor.mixins)||([]);
for(var i=0,m;(m=ms[i]);i++){
(((m.prototype)&&(m.prototype.initializer))||(m)).apply(this,arguments);
}
if((!this.prototyping)&&(self.initializer)){
self.initializer.apply(this,arguments);
}
};
};
dojo.lang.declare._common={_getPropContext:function(){
return (this.___proto||this);
},_contextMethod:function(_524,_525,args){
var _527,_528=this.___proto;
this.___proto=_524;
try{
_527=_524[_525].apply(this,(args||[]));
}
catch(e){
throw e;
}
finally{
this.___proto=_528;
}
return _527;
},_inherited:function(prop,args){
var p=this._getPropContext();
do{
if((!p.constructor)||(!p.constructor.superclass)){
return;
}
p=p.constructor.superclass;
}while(!(prop in p));
return (dojo.lang.isFunction(p[prop])?this._contextMethod(p,prop,args):p[prop]);
}};
dojo.declare=dojo.lang.declare;
dojo.provide("dojo.logging.Logger");
dojo.provide("dojo.logging.LogFilter");
dojo.provide("dojo.logging.Record");
dojo.provide("dojo.log");
dojo.logging.Record=function(_52c,_52d){
this.level=_52c;
this.message="";
this.msgArgs=[];
this.time=new Date();
if(dojo.lang.isArray(_52d)){
if(_52d.length>0&&dojo.lang.isString(_52d[0])){
this.message=_52d.shift();
}
this.msgArgs=_52d;
}else{
this.message=_52d;
}
};
dojo.logging.LogFilter=function(_52e){
this.passChain=_52e||"";
this.filter=function(_52f){
return true;
};
};
dojo.logging.Logger=function(){
this.cutOffLevel=0;
this.propagate=true;
this.parent=null;
this.data=[];
this.filters=[];
this.handlers=[];
};
dojo.extend(dojo.logging.Logger,{_argsToArr:function(args){
var ret=[];
for(var x=0;x<args.length;x++){
ret.push(args[x]);
}
return ret;
},setLevel:function(lvl){
this.cutOffLevel=parseInt(lvl);
},isEnabledFor:function(lvl){
return parseInt(lvl)>=this.cutOffLevel;
},getEffectiveLevel:function(){
if((this.cutOffLevel==0)&&(this.parent)){
return this.parent.getEffectiveLevel();
}
return this.cutOffLevel;
},addFilter:function(flt){
this.filters.push(flt);
return this.filters.length-1;
},removeFilterByIndex:function(_536){
if(this.filters[_536]){
delete this.filters[_536];
return true;
}
return false;
},removeFilter:function(_537){
for(var x=0;x<this.filters.length;x++){
if(this.filters[x]===_537){
delete this.filters[x];
return true;
}
}
return false;
},removeAllFilters:function(){
this.filters=[];
},filter:function(rec){
for(var x=0;x<this.filters.length;x++){
if((this.filters[x]["filter"])&&(!this.filters[x].filter(rec))||(rec.level<this.cutOffLevel)){
return false;
}
}
return true;
},addHandler:function(hdlr){
this.handlers.push(hdlr);
return this.handlers.length-1;
},handle:function(rec){
if((!this.filter(rec))||(rec.level<this.cutOffLevel)){
return false;
}
for(var x=0;x<this.handlers.length;x++){
if(this.handlers[x]["handle"]){
this.handlers[x].handle(rec);
}
}
return true;
},log:function(lvl,msg){
if((this.propagate)&&(this.parent)&&(this.parent.rec.level>=this.cutOffLevel)){
this.parent.log(lvl,msg);
return false;
}
this.handle(new dojo.logging.Record(lvl,msg));
return true;
},debug:function(msg){
return this.logType("DEBUG",this._argsToArr(arguments));
},info:function(msg){
return this.logType("INFO",this._argsToArr(arguments));
},warning:function(msg){
return this.logType("WARNING",this._argsToArr(arguments));
},error:function(msg){
return this.logType("ERROR",this._argsToArr(arguments));
},critical:function(msg){
return this.logType("CRITICAL",this._argsToArr(arguments));
},exception:function(msg,e,_547){
if(e){
var _548=[e.name,(e.description||e.message)];
if(e.fileName){
_548.push(e.fileName);
_548.push("line "+e.lineNumber);
}
msg+=" "+_548.join(" : ");
}
this.logType("ERROR",msg);
if(!_547){
throw e;
}
},logType:function(type,args){
return this.log.apply(this,[dojo.logging.log.getLevel(type),args]);
},warn:function(){
this.warning.apply(this,arguments);
},err:function(){
this.error.apply(this,arguments);
},crit:function(){
this.critical.apply(this,arguments);
}});
dojo.logging.LogHandler=function(_54b){
this.cutOffLevel=(_54b)?_54b:0;
this.formatter=null;
this.data=[];
this.filters=[];
};
dojo.lang.extend(dojo.logging.LogHandler,{setFormatter:function(_54c){
dojo.unimplemented("setFormatter");
},flush:function(){
},close:function(){
},handleError:function(){
dojo.deprecated("dojo.logging.LogHandler.handleError","use handle()","0.6");
},handle:function(_54d){
if((this.filter(_54d))&&(_54d.level>=this.cutOffLevel)){
this.emit(_54d);
}
},emit:function(_54e){
dojo.unimplemented("emit");
}});
void (function(){
var _54f=["setLevel","addFilter","removeFilterByIndex","removeFilter","removeAllFilters","filter"];
var tgt=dojo.logging.LogHandler.prototype;
var src=dojo.logging.Logger.prototype;
for(var x=0;x<_54f.length;x++){
tgt[_54f[x]]=src[_54f[x]];
}
})();
dojo.logging.log=new dojo.logging.Logger();
dojo.logging.log.levels=[{"name":"DEBUG","level":1},{"name":"INFO","level":2},{"name":"WARNING","level":3},{"name":"ERROR","level":4},{"name":"CRITICAL","level":5}];
dojo.logging.log.loggers={};
dojo.logging.log.getLogger=function(name){
if(!this.loggers[name]){
this.loggers[name]=new dojo.logging.Logger();
this.loggers[name].parent=this;
}
return this.loggers[name];
};
dojo.logging.log.getLevelName=function(lvl){
for(var x=0;x<this.levels.length;x++){
if(this.levels[x].level==lvl){
return this.levels[x].name;
}
}
return null;
};
dojo.logging.log.getLevel=function(name){
for(var x=0;x<this.levels.length;x++){
if(this.levels[x].name.toUpperCase()==name.toUpperCase()){
return this.levels[x].level;
}
}
return null;
};
dojo.declare("dojo.logging.MemoryLogHandler",dojo.logging.LogHandler,function(_558,_559,_55a,_55b){
dojo.logging.LogHandler.call(this,_558);
this.numRecords=(typeof djConfig["loggingNumRecords"]!="undefined")?djConfig["loggingNumRecords"]:((_559)?_559:-1);
this.postType=(typeof djConfig["loggingPostType"]!="undefined")?djConfig["loggingPostType"]:(_55a||-1);
this.postInterval=(typeof djConfig["loggingPostInterval"]!="undefined")?djConfig["loggingPostInterval"]:(_55a||-1);
},{emit:function(_55c){
if(!djConfig.isDebug){
return;
}
var _55d=String(dojo.log.getLevelName(_55c.level)+": "+_55c.time.toLocaleTimeString())+": "+_55c.message;
if(!dj_undef("println",dojo.hostenv)){
dojo.hostenv.println(_55d,_55c.msgArgs);
}
this.data.push(_55c);
if(this.numRecords!=-1){
while(this.data.length>this.numRecords){
this.data.shift();
}
}
}});
dojo.logging.logQueueHandler=new dojo.logging.MemoryLogHandler(0,50,0,10000);
dojo.logging.log.addHandler(dojo.logging.logQueueHandler);
dojo.log=dojo.logging.log;
dojo.kwCompoundRequire({common:[["dojo.logging.Logger",false,false]],rhino:["dojo.logging.RhinoLogger"]});
dojo.provide("dojo.logging.*");
dojo.provide("dojo.string.common");
dojo.string.trim=function(str,wh){
if(!str.replace){
return str;
}
if(!str.length){
return str;
}
var re=(wh>0)?(/^\s+/):(wh<0)?(/\s+$/):(/^\s+|\s+$/g);
return str.replace(re,"");
};
dojo.string.trimStart=function(str){
return dojo.string.trim(str,1);
};
dojo.string.trimEnd=function(str){
return dojo.string.trim(str,-1);
};
dojo.string.repeat=function(str,_564,_565){
var out="";
for(var i=0;i<_564;i++){
out+=str;
if(_565&&i<_564-1){
out+=_565;
}
}
return out;
};
dojo.string.pad=function(str,len,c,dir){
var out=String(str);
if(!c){
c="0";
}
if(!dir){
dir=1;
}
while(out.length<len){
if(dir>0){
out=c+out;
}else{
out+=c;
}
}
return out;
};
dojo.string.padLeft=function(str,len,c){
return dojo.string.pad(str,len,c,1);
};
dojo.string.padRight=function(str,len,c){
return dojo.string.pad(str,len,c,-1);
};
dojo.provide("dojo.string");
dojo.provide("dojo.io.common");
dojo.io.transports=[];
dojo.io.hdlrFuncNames=["load","error","timeout"];
dojo.io.Request=function(url,_574,_575,_576){
if((arguments.length==1)&&(arguments[0].constructor==Object)){
this.fromKwArgs(arguments[0]);
}else{
this.url=url;
if(_574){
this.mimetype=_574;
}
if(_575){
this.transport=_575;
}
if(arguments.length>=4){
this.changeUrl=_576;
}
}
};
dojo.lang.extend(dojo.io.Request,{url:"",mimetype:"text/plain",method:"GET",content:undefined,transport:undefined,changeUrl:undefined,formNode:undefined,sync:false,bindSuccess:false,useCache:false,preventCache:false,jsonFilter:function(_577){
if((this.mimetype=="text/json-comment-filtered")||(this.mimetype=="application/json-comment-filtered")){
var _578=_577.indexOf("/*");
var _579=_577.lastIndexOf("*/");
if((_578==-1)||(_579==-1)){
dojo.debug("your JSON wasn't comment filtered!");
return "";
}
return _577.substring(_578+2,_579);
}
dojo.debug("please consider using a mimetype of text/json-comment-filtered to avoid potential security issues with JSON endpoints");
return _577;
},load:function(type,data,_57c,_57d){
},error:function(type,_57f,_580,_581){
},timeout:function(type,_583,_584,_585){
},handle:function(type,data,_588,_589){
},timeoutSeconds:0,abort:function(){
},fromKwArgs:function(_58a){
if(_58a["url"]){
_58a.url=_58a.url.toString();
}
if(_58a["formNode"]){
_58a.formNode=dojo.byId(_58a.formNode);
}
if(!_58a["method"]&&_58a["formNode"]&&_58a["formNode"].method){
_58a.method=_58a["formNode"].method;
}
if(!_58a["handle"]&&_58a["handler"]){
_58a.handle=_58a.handler;
}
if(!_58a["load"]&&_58a["loaded"]){
_58a.load=_58a.loaded;
}
if(!_58a["changeUrl"]&&_58a["changeURL"]){
_58a.changeUrl=_58a.changeURL;
}
_58a.encoding=dojo.lang.firstValued(_58a["encoding"],djConfig["bindEncoding"],"");
_58a.sendTransport=dojo.lang.firstValued(_58a["sendTransport"],djConfig["ioSendTransport"],false);
var _58b=dojo.lang.isFunction;
for(var x=0;x<dojo.io.hdlrFuncNames.length;x++){
var fn=dojo.io.hdlrFuncNames[x];
if(_58a[fn]&&_58b(_58a[fn])){
continue;
}
if(_58a["handle"]&&_58b(_58a["handle"])){
_58a[fn]=_58a.handle;
}
}
dojo.lang.mixin(this,_58a);
}});
dojo.io.Error=function(msg,type,num){
this.message=msg;
this.type=type||"unknown";
this.number=num||0;
};
dojo.io.transports.addTransport=function(name){
this.push(name);
this[name]=dojo.io[name];
};
dojo.io.bind=function(_592){
if(!(_592 instanceof dojo.io.Request)){
try{
_592=new dojo.io.Request(_592);
}
catch(e){
dojo.debug(e);
}
}
var _593="";
if(_592["transport"]){
_593=_592["transport"];
if(!this[_593]){
dojo.io.sendBindError(_592,"No dojo.io.bind() transport with name '"+_592["transport"]+"'.");
return _592;
}
if(!this[_593].canHandle(_592)){
dojo.io.sendBindError(_592,"dojo.io.bind() transport with name '"+_592["transport"]+"' cannot handle this type of request.");
return _592;
}
}else{
for(var x=0;x<dojo.io.transports.length;x++){
var tmp=dojo.io.transports[x];
if((this[tmp])&&(this[tmp].canHandle(_592))){
_593=tmp;
break;
}
}
if(_593==""){
dojo.io.sendBindError(_592,"None of the loaded transports for dojo.io.bind()"+" can handle the request.");
return _592;
}
}
this[_593].bind(_592);
_592.bindSuccess=true;
return _592;
};
dojo.io.sendBindError=function(_596,_597){
if((typeof _596.error=="function"||typeof _596.handle=="function")&&(typeof setTimeout=="function"||typeof setTimeout=="object")){
var _598=new dojo.io.Error(_597);
setTimeout(function(){
_596[(typeof _596.error=="function")?"error":"handle"]("error",_598,null,_596);
},50);
}else{
dojo.raise(_597);
}
};
dojo.io.queueBind=function(_599){
if(!(_599 instanceof dojo.io.Request)){
try{
_599=new dojo.io.Request(_599);
}
catch(e){
dojo.debug(e);
}
}
var _59a=_599.load;
_599.load=function(){
dojo.io._queueBindInFlight=false;
var ret=_59a.apply(this,arguments);
dojo.io._dispatchNextQueueBind();
return ret;
};
var _59c=_599.error;
_599.error=function(){
dojo.io._queueBindInFlight=false;
var ret=_59c.apply(this,arguments);
dojo.io._dispatchNextQueueBind();
return ret;
};
dojo.io._bindQueue.push(_599);
dojo.io._dispatchNextQueueBind();
return _599;
};
dojo.io._dispatchNextQueueBind=function(){
if(!dojo.io._queueBindInFlight){
dojo.io._queueBindInFlight=true;
if(dojo.io._bindQueue.length>0){
dojo.io.bind(dojo.io._bindQueue.shift());
}else{
dojo.io._queueBindInFlight=false;
}
}
};
dojo.io._bindQueue=[];
dojo.io._queueBindInFlight=false;
dojo.io.argsFromMap=function(map,_59f,last){
var enc=/utf/i.test(_59f||"")?encodeURIComponent:dojo.string.encodeAscii;
var _5a2=[];
var _5a3=new Object();
for(var name in map){
var _5a5=function(elt){
var val=enc(name)+"="+enc(elt);
_5a2[(last==name)?"push":"unshift"](val);
};
if(!_5a3[name]){
var _5a8=map[name];
if(dojo.lang.isArray(_5a8)){
dojo.lang.forEach(_5a8,_5a5);
}else{
_5a5(_5a8);
}
}
}
return _5a2.join("&");
};
dojo.io.setIFrameSrc=function(_5a9,src,_5ab){
try{
var r=dojo.render.html;
if(!_5ab){
if(r.safari){
_5a9.location=src;
}else{
frames[_5a9.name].location=src;
}
}else{
var idoc;
if(r.ie){
idoc=_5a9.contentWindow.document;
}else{
if(r.safari){
idoc=_5a9.document;
}else{
idoc=_5a9.contentWindow;
}
}
if(!idoc){
_5a9.location=src;
return;
}else{
idoc.location.replace(src);
}
}
}
catch(e){
dojo.debug(e);
dojo.debug("setIFrameSrc: "+e);
}
};
dojo.provide("dojo.string.extras");
dojo.string.substitute=function(_5ae,map,_5b0,_5b1){
return _5ae.replace(/\$\{([^\s\:\}]+)(?:\:(\S+))?\}/g,function(_5b2,key,_5b4){
var _5b5=dojo.getObject(key,false,map).toString();
if(_5b4){
_5b5=dojo.getObject(_5b4,false,_5b1)(_5b5);
}
if(_5b0){
_5b5=_5b0(_5b5);
}
return _5b5;
});
};
dojo.string.capitalize=function(str){
if(!dojo.lang.isString(str)){
return "";
}
return str.replace(/[^\s]+/g,function(word){
return word.substring(0,1).toUpperCase()+word.substring(1);
});
};
dojo.string.isBlank=function(str){
if(!dojo.lang.isString(str)){
return true;
}
return (dojo.string.trim(str).length==0);
};
dojo.string.encodeAscii=function(str){
if(!dojo.lang.isString(str)){
return str;
}
var ret="";
var _5bb=escape(str);
var _5bc,re=/%u([0-9A-F]{4})/i;
while((_5bc=_5bb.match(re))){
var num=Number("0x"+_5bc[1]);
var _5bf=escape("&#"+num+";");
ret+=_5bb.substring(0,_5bc.index)+_5bf;
_5bb=_5bb.substring(_5bc.index+_5bc[0].length);
}
ret+=_5bb.replace(/\+/g,"%2B");
return ret;
};
dojo.string.escape=function(type,str){
var args=dojo.lang.toArray(arguments,1);
switch(type.toLowerCase()){
case "xml":
case "html":
case "xhtml":
return dojo.string.escapeXml.apply(this,args);
case "sql":
return dojo.string.escapeSql.apply(this,args);
case "regexp":
case "regex":
return dojo.string.escapeRegExp.apply(this,args);
case "javascript":
case "jscript":
case "js":
return dojo.string.escapeJavaScript.apply(this,args);
case "ascii":
return dojo.string.encodeAscii.apply(this,args);
default:
return str;
}
};
dojo.string.escapeXml=function(str,_5c4){
str=str.replace(/&/gm,"&amp;").replace(/</gm,"&lt;").replace(/>/gm,"&gt;").replace(/"/gm,"&quot;");
if(!_5c4){
str=str.replace(/'/gm,"&#39;");
}
return str;
};
dojo.string.escapeSql=function(str){
return str.replace(/'/gm,"''");
};
dojo.string.escapeRegExp=function(str,_5c7){
return str.replace(/([\.$?*!=:|{}\(\)\[\]\\\/^])/g,function(ch){
if(_5c7&&_5c7.indexOf(ch)!=-1){
return ch;
}
return "\\"+ch;
});
};
dojo.string.escapeJavaScript=function(str){
return str.replace(/(["'\f\b\n\t\r])/gm,"\\$1");
};
dojo.string.escapeString=function(str){
return ("\""+str.replace(/(["\\])/g,"\\$1")+"\"").replace(/[\f]/g,"\\f").replace(/[\b]/g,"\\b").replace(/[\n]/g,"\\n").replace(/[\t]/g,"\\t").replace(/[\r]/g,"\\r");
};
dojo.string.summary=function(str,len){
if(!len||str.length<=len){
return str;
}
return str.substring(0,len).replace(/\.+$/,"")+"...";
};
dojo.string.endsWith=function(str,end,_5cf){
if(_5cf){
str=str.toLowerCase();
end=end.toLowerCase();
}
if((str.length-end.length)<0){
return false;
}
return str.lastIndexOf(end)==str.length-end.length;
};
dojo.string.endsWithAny=function(str){
for(var i=1;i<arguments.length;i++){
if(dojo.string.endsWith(str,arguments[i])){
return true;
}
}
return false;
};
dojo.string.startsWith=function(str,_5d3,_5d4){
if(_5d4){
str=str.toLowerCase();
_5d3=_5d3.toLowerCase();
}
return str.indexOf(_5d3)==0;
};
dojo.string.startsWithAny=function(str){
for(var i=1;i<arguments.length;i++){
if(dojo.string.startsWith(str,arguments[i])){
return true;
}
}
return false;
};
dojo.string.has=function(str){
for(var i=1;i<arguments.length;i++){
if(str.indexOf(arguments[i])>-1){
return true;
}
}
return false;
};
dojo.string.normalizeNewlines=function(text,_5da){
if(_5da=="\n"){
text=text.replace(/\r\n/g,"\n");
text=text.replace(/\r/g,"\n");
}else{
if(_5da=="\r"){
text=text.replace(/\r\n/g,"\r");
text=text.replace(/\n/g,"\r");
}else{
text=text.replace(/([^\r])\n/g,"$1\r\n").replace(/\r([^\n])/g,"\r\n$1");
}
}
return text;
};
dojo.string.splitEscaped=function(str,_5dc){
var _5dd=[];
for(var i=0,_5df=0;i<str.length;i++){
if(str.charAt(i)=="\\"){
i++;
continue;
}
if(str.charAt(i)==_5dc){
_5dd.push(str.substring(_5df,i));
_5df=i+1;
}
}
_5dd.push(str.substr(_5df));
return _5dd;
};
dojo.provide("dojo.undo.browser");
try{
if((!djConfig["preventBackButtonFix"])&&(!dojo.hostenv.post_load_)){
document.write("<iframe style='border: 0px; width: 1px; height: 1px; position: absolute; bottom: 0px; right: 0px; visibility: visible;' name='djhistory' id='djhistory' src='"+(djConfig["dojoIframeHistoryUrl"]||dojo.hostenv.getBaseScriptUri()+"iframe_history.html")+"'></iframe>");
}
}
catch(e){
}
if(dojo.render.html.opera){
dojo.debug("Opera is not supported with dojo.undo.browser, so back/forward detection will not work.");
}
dojo.undo.browser={initialHref:(!dj_undef("window"))?window.location.href:"",initialHash:(!dj_undef("window"))?window.location.hash:"",moveForward:false,historyStack:[],forwardStack:[],historyIframe:null,bookmarkAnchor:null,locationTimer:null,setInitialState:function(args){
this.initialState=this._createState(this.initialHref,args,this.initialHash);
},addToHistory:function(args){
this.forwardStack=[];
var hash=null;
var url=null;
if(!this.historyIframe){
if(djConfig["useXDomain"]&&!djConfig["dojoIframeHistoryUrl"]){
dojo.debug("dojo.undo.browser: When using cross-domain Dojo builds,"+" please save iframe_history.html to your domain and set djConfig.dojoIframeHistoryUrl"+" to the path on your domain to iframe_history.html");
}
this.historyIframe=window.frames["djhistory"];
}
if(!this.bookmarkAnchor){
this.bookmarkAnchor=document.createElement("a");
dojo.body().appendChild(this.bookmarkAnchor);
this.bookmarkAnchor.style.display="none";
}
if(args["changeUrl"]){
hash="#"+((args["changeUrl"]!==true)?args["changeUrl"]:(new Date()).getTime());
if(this.historyStack.length==0&&this.initialState.urlHash==hash){
this.initialState=this._createState(url,args,hash);
return;
}else{
if(this.historyStack.length>0&&this.historyStack[this.historyStack.length-1].urlHash==hash){
this.historyStack[this.historyStack.length-1]=this._createState(url,args,hash);
return;
}
}
this.changingUrl=true;
setTimeout("window.location.href = '"+hash+"'; dojo.undo.browser.changingUrl = false;",1);
this.bookmarkAnchor.href=hash;
if(dojo.render.html.ie){
url=this._loadIframeHistory();
var _5e4=args["back"]||args["backButton"]||args["handle"];
var tcb=function(_5e6){
if(window.location.hash!=""){
setTimeout("window.location.href = '"+hash+"';",1);
}
_5e4.apply(this,[_5e6]);
};
if(args["back"]){
args.back=tcb;
}else{
if(args["backButton"]){
args.backButton=tcb;
}else{
if(args["handle"]){
args.handle=tcb;
}
}
}
var _5e7=args["forward"]||args["forwardButton"]||args["handle"];
var tfw=function(_5e9){
if(window.location.hash!=""){
window.location.href=hash;
}
if(_5e7){
_5e7.apply(this,[_5e9]);
}
};
if(args["forward"]){
args.forward=tfw;
}else{
if(args["forwardButton"]){
args.forwardButton=tfw;
}else{
if(args["handle"]){
args.handle=tfw;
}
}
}
}else{
if(dojo.render.html.moz){
if(!this.locationTimer){
this.locationTimer=setInterval("dojo.undo.browser.checkLocation();",200);
}
}
}
}else{
url=this._loadIframeHistory();
}
this.historyStack.push(this._createState(url,args,hash));
},checkLocation:function(){
if(!this.changingUrl){
var hsl=this.historyStack.length;
if((window.location.hash==this.initialHash||window.location.href==this.initialHref)&&(hsl==1)){
this.handleBackButton();
return;
}
if(this.forwardStack.length>0){
if(this.forwardStack[this.forwardStack.length-1].urlHash==window.location.hash){
this.handleForwardButton();
return;
}
}
if((hsl>=2)&&(this.historyStack[hsl-2])){
if(this.historyStack[hsl-2].urlHash==window.location.hash){
this.handleBackButton();
return;
}
}
}
},iframeLoaded:function(evt,_5ec){
if(!dojo.render.html.opera){
var _5ed=this._getUrlQuery(_5ec.href);
if(_5ed==null){
if(this.historyStack.length==1){
this.handleBackButton();
}
return;
}
if(this.moveForward){
this.moveForward=false;
return;
}
if(this.historyStack.length>=2&&_5ed==this._getUrlQuery(this.historyStack[this.historyStack.length-2].url)){
this.handleBackButton();
}else{
if(this.forwardStack.length>0&&_5ed==this._getUrlQuery(this.forwardStack[this.forwardStack.length-1].url)){
this.handleForwardButton();
}
}
}
},handleBackButton:function(){
var _5ee=this.historyStack.pop();
if(!_5ee){
return;
}
var last=this.historyStack[this.historyStack.length-1];
if(!last&&this.historyStack.length==0){
last=this.initialState;
}
if(last){
if(last.kwArgs["back"]){
last.kwArgs["back"]();
}else{
if(last.kwArgs["backButton"]){
last.kwArgs["backButton"]();
}else{
if(last.kwArgs["handle"]){
last.kwArgs.handle("back");
}
}
}
}
this.forwardStack.push(_5ee);
},handleForwardButton:function(){
var last=this.forwardStack.pop();
if(!last){
return;
}
if(last.kwArgs["forward"]){
last.kwArgs.forward();
}else{
if(last.kwArgs["forwardButton"]){
last.kwArgs.forwardButton();
}else{
if(last.kwArgs["handle"]){
last.kwArgs.handle("forward");
}
}
}
this.historyStack.push(last);
},_createState:function(url,args,hash){
return {"url":url,"kwArgs":args,"urlHash":hash};
},_getUrlQuery:function(url){
var _5f5=url.split("?");
if(_5f5.length<2){
return null;
}else{
return _5f5[1];
}
},_loadIframeHistory:function(){
var url=(djConfig["dojoIframeHistoryUrl"]||dojo.hostenv.getBaseScriptUri()+"iframe_history.html")+"?"+(new Date()).getTime();
this.moveForward=true;
dojo.io.setIFrameSrc(this.historyIframe,url,false);
return url;
}};
dojo.provide("dojo.io.BrowserIO");
if(!dj_undef("window")){
dojo.io.checkChildrenForFile=function(node){
var _5f8=false;
var _5f9=node.getElementsByTagName("input");
dojo.lang.forEach(_5f9,function(_5fa){
if(_5f8){
return;
}
if(_5fa.getAttribute("type")=="file"){
_5f8=true;
}
});
return _5f8;
};
dojo.io.formHasFile=function(_5fb){
return dojo.io.checkChildrenForFile(_5fb);
};
dojo.io.updateNode=function(node,_5fd){
node=dojo.byId(node);
var args=_5fd;
if(dojo.lang.isString(_5fd)){
args={url:_5fd};
}
args.mimetype="text/html";
args.load=function(t,d,e){
while(node.firstChild){
dojo.dom.destroyNode(node.firstChild);
}
node.innerHTML=d;
};
dojo.io.bind(args);
};
dojo.io.formFilter=function(node){
var type=(node.type||"").toLowerCase();
return !node.disabled&&node.name&&!dojo.lang.inArray(["file","submit","image","reset","button"],type);
};
dojo.io.encodeForm=function(_604,_605,_606){
if((!_604)||(!_604.tagName)||(!_604.tagName.toLowerCase()=="form")){
dojo.raise("Attempted to encode a non-form element.");
}
if(!_606){
_606=dojo.io.formFilter;
}
var enc=/utf/i.test(_605||"")?encodeURIComponent:dojo.string.encodeAscii;
var _608=[];
for(var i=0;i<_604.elements.length;i++){
var elm=_604.elements[i];
if(!elm||elm.tagName.toLowerCase()=="fieldset"||!_606(elm)){
continue;
}
var name=enc(elm.name);
var type=elm.type.toLowerCase();
if(type=="select-multiple"){
for(var j=0;j<elm.options.length;j++){
if(elm.options[j].selected){
_608.push(name+"="+enc(elm.options[j].value));
}
}
}else{
if(dojo.lang.inArray(["radio","checkbox"],type)){
if(elm.checked){
_608.push(name+"="+enc(elm.value));
}
}else{
_608.push(name+"="+enc(elm.value));
}
}
}
var _60e=_604.getElementsByTagName("input");
for(var i=0;i<_60e.length;i++){
var _60f=_60e[i];
if(_60f.type.toLowerCase()=="image"&&_60f.form==_604&&_606(_60f)){
var name=enc(_60f.name);
_608.push(name+"="+enc(_60f.value));
_608.push(name+".x=0");
_608.push(name+".y=0");
}
}
return _608.join("&")+"&";
};
dojo.io.FormBind=function(args){
this.bindArgs={};
if(args&&args.formNode){
this.init(args);
}else{
if(args){
this.init({formNode:args});
}
}
};
dojo.lang.extend(dojo.io.FormBind,{form:null,bindArgs:null,clickedButton:null,init:function(args){
var form=dojo.byId(args.formNode);
if(!form||!form.tagName||form.tagName.toLowerCase()!="form"){
throw new Error("FormBind: Couldn't apply, invalid form");
}else{
if(this.form==form){
return;
}else{
if(this.form){
throw new Error("FormBind: Already applied to a form");
}
}
}
dojo.lang.mixin(this.bindArgs,args);
this.form=form;
this.connect(form,"onsubmit","submit");
for(var i=0;i<form.elements.length;i++){
var node=form.elements[i];
if(node&&node.type&&dojo.lang.inArray(["submit","button"],node.type.toLowerCase())){
this.connect(node,"onclick","click");
}
}
var _615=form.getElementsByTagName("input");
for(var i=0;i<_615.length;i++){
var _616=_615[i];
if(_616.type.toLowerCase()=="image"&&_616.form==form){
this.connect(_616,"onclick","click");
}
}
},onSubmit:function(form){
return true;
},submit:function(e){
e.preventDefault();
if(this.onSubmit(this.form)){
dojo.io.bind(dojo.lang.mixin(this.bindArgs,{formFilter:dojo.lang.hitch(this,"formFilter")}));
}
},click:function(e){
var node=e.currentTarget;
if(node.disabled){
return;
}
this.clickedButton=node;
},formFilter:function(node){
var type=(node.type||"").toLowerCase();
var _61d=false;
if(node.disabled||!node.name){
_61d=false;
}else{
if(dojo.lang.inArray(["submit","button","image"],type)){
if(!this.clickedButton){
this.clickedButton=node;
}
_61d=node==this.clickedButton;
}else{
_61d=!dojo.lang.inArray(["file","submit","reset","button"],type);
}
}
return _61d;
},connect:function(_61e,_61f,_620){
if(dojo.getObject("dojo.event.connect")){
dojo.event.connect(_61e,_61f,this,_620);
}else{
var fcn=dojo.lang.hitch(this,_620);
_61e[_61f]=function(e){
if(!e){
e=window.event;
}
if(!e.currentTarget){
e.currentTarget=e.srcElement;
}
if(!e.preventDefault){
e.preventDefault=function(){
window.event.returnValue=false;
};
}
fcn(e);
};
}
}});
dojo.io.XMLHTTPTransport=new function(){
var _623=this;
var _624={};
this.useCache=false;
this.preventCache=false;
function getCacheKey(url,_626,_627){
return url+"|"+_626+"|"+_627.toLowerCase();
}
function addToCache(url,_629,_62a,http){
_624[getCacheKey(url,_629,_62a)]=http;
}
function getFromCache(url,_62d,_62e){
return _624[getCacheKey(url,_62d,_62e)];
}
this.clearCache=function(){
_624={};
};
function doLoad(_62f,http,url,_632,_633){
if(((http.status>=200)&&(http.status<300))||(http.status==304)||(http.status==1223)||(location.protocol=="file:"&&(http.status==0||http.status==undefined))||(location.protocol=="chrome:"&&(http.status==0||http.status==undefined))){
var ret;
if(_62f.method.toLowerCase()=="head"){
var _635=http.getAllResponseHeaders();
ret={};
ret.toString=function(){
return _635;
};
var _636=_635.split(/[\r\n]+/g);
for(var i=0;i<_636.length;i++){
var pair=_636[i].match(/^([^:]+)\s*:\s*(.+)$/i);
if(pair){
ret[pair[1]]=pair[2];
}
}
}else{
if(_62f.mimetype=="text/javascript"){
try{
ret=dj_eval(http.responseText);
}
catch(e){
dojo.debug(e);
dojo.debug(http.responseText);
ret=null;
}
}else{
if(_62f.mimetype.substr(0,9)=="text/json"||_62f.mimetype.substr(0,16)=="application/json"){
try{
ret=dj_eval("("+_62f.jsonFilter(http.responseText)+")");
}
catch(e){
dojo.debug(e);
dojo.debug(http.responseText);
ret=false;
}
}else{
if((_62f.mimetype=="application/xml")||(_62f.mimetype=="text/xml")){
ret=http.responseXML;
if(!ret||typeof ret=="string"||!http.getResponseHeader("Content-Type")){
ret=dojo.dom.createDocumentFromText(http.responseText);
}
}else{
ret=http.responseText;
}
}
}
}
if(_633){
addToCache(url,_632,_62f.method,http);
}
_62f[(typeof _62f.load=="function")?"load":"handle"]("load",ret,http,_62f);
}else{
var _639=new dojo.io.Error("XMLHttpTransport Error: "+http.status+" "+http.statusText);
_62f[(typeof _62f.error=="function")?"error":"handle"]("error",_639,http,_62f);
}
}
function setHeaders(http,_63b){
if(_63b["headers"]){
for(var _63c in _63b["headers"]){
if(_63c.toLowerCase()=="content-type"&&!_63b["contentType"]){
_63b["contentType"]=_63b["headers"][_63c];
}else{
http.setRequestHeader(_63c,_63b["headers"][_63c]);
}
}
}
}
this.inFlight=[];
this.inFlightTimer=null;
this.startWatchingInFlight=function(){
if(!this.inFlightTimer){
this.inFlightTimer=setTimeout("dojo.io.XMLHTTPTransport.watchInFlight();",10);
}
};
this.watchInFlight=function(){
var now=null;
if(!dojo.hostenv._blockAsync&&!_623._blockAsync){
for(var x=this.inFlight.length-1;x>=0;x--){
try{
var tif=this.inFlight[x];
if(!tif||tif.http._aborted||!tif.http.readyState){
this.inFlight.splice(x,1);
continue;
}
if(4==tif.http.readyState){
this.inFlight.splice(x,1);
doLoad(tif.req,tif.http,tif.url,tif.query,tif.useCache);
}else{
if(tif.startTime){
if(!now){
now=(new Date()).getTime();
}
if(tif.startTime+(tif.req.timeoutSeconds*1000)<now){
if(typeof tif.http.abort=="function"){
tif.http.abort();
}
this.inFlight.splice(x,1);
tif.req[(typeof tif.req.timeout=="function")?"timeout":"handle"]("timeout",null,tif.http,tif.req);
}
}
}
}
catch(e){
try{
var _640=new dojo.io.Error("XMLHttpTransport.watchInFlight Error: "+e);
tif.req[(typeof tif.req.error=="function")?"error":"handle"]("error",_640,tif.http,tif.req);
}
catch(e2){
dojo.debug("XMLHttpTransport error callback failed: "+e2);
}
}
}
}
clearTimeout(this.inFlightTimer);
if(this.inFlight.length==0){
this.inFlightTimer=null;
return;
}
this.inFlightTimer=setTimeout("dojo.io.XMLHTTPTransport.watchInFlight();",10);
};
var _641=dojo.hostenv.getXmlhttpObject()?true:false;
this.canHandle=function(_642){
var mlc=_642["mimetype"].toLowerCase()||"";
return _641&&((dojo.lang.inArray(["text/plain","text/html","application/xml","text/xml","text/javascript"],mlc))||(mlc.substr(0,9)=="text/json"||mlc.substr(0,16)=="application/json"))&&!(_642["formNode"]&&dojo.io.formHasFile(_642["formNode"]));
};
this.multipartBoundary="45309FFF-BD65-4d50-99C9-36986896A96F";
this.bind=function(_644){
var url=_644.url;
var _646="";
if(_644["formNode"]){
var ta=_644.formNode.getAttribute("action");
if(typeof (ta)!="string"){
ta=_644.formNode.attributes.action.value;
}
if((ta)&&(!_644["url"])){
url=ta;
}
var tp=_644.formNode.getAttribute("method");
if((tp)&&(!_644["method"])){
_644.method=tp;
}
_646+=dojo.io.encodeForm(_644.formNode,_644.encoding,_644["formFilter"]);
}
if(url.indexOf("#")>-1){
dojo.debug("Warning: dojo.io.bind: stripping hash values from url:",url);
url=url.split("#")[0];
}
if(_644["file"]){
_644.method="post";
}
if(!_644["method"]){
_644.method="get";
}
if(_644.method.toLowerCase()=="get"){
_644.multipart=false;
}else{
if(_644["file"]){
_644.multipart=true;
}else{
if(!_644["multipart"]){
_644.multipart=false;
}
}
}
if(_644["backButton"]||_644["back"]||_644["changeUrl"]){
dojo.undo.browser.addToHistory(_644);
}
var _649=_644["content"]||{};
if(_644.sendTransport){
_649["dojo.transport"]="xmlhttp";
}
do{
if(_644.postContent){
_646=_644.postContent;
break;
}
if(_649){
_646+=dojo.io.argsFromMap(_649,_644.encoding);
}
if(_644.method.toLowerCase()=="get"||!_644.multipart){
break;
}
var t=[];
if(_646.length){
var q=_646.split("&");
for(var i=0;i<q.length;++i){
if(q[i].length){
var p=q[i].split("=");
t.push("--"+this.multipartBoundary,"Content-Disposition: form-data; name=\""+p[0]+"\"","",p[1]);
}
}
}
if(_644.file){
if(dojo.lang.isArray(_644.file)){
for(var i=0;i<_644.file.length;++i){
var o=_644.file[i];
t.push("--"+this.multipartBoundary,"Content-Disposition: form-data; name=\""+o.name+"\"; filename=\""+("fileName" in o?o.fileName:o.name)+"\"","Content-Type: "+("contentType" in o?o.contentType:"application/octet-stream"),"",o.content);
}
}else{
var o=_644.file;
t.push("--"+this.multipartBoundary,"Content-Disposition: form-data; name=\""+o.name+"\"; filename=\""+("fileName" in o?o.fileName:o.name)+"\"","Content-Type: "+("contentType" in o?o.contentType:"application/octet-stream"),"",o.content);
}
}
if(t.length){
t.push("--"+this.multipartBoundary+"--","");
_646=t.join("\r\n");
}
}while(false);
var _64f=_644["sync"]?false:true;
var _650=_644["preventCache"]||(this.preventCache==true&&_644["preventCache"]!=false);
var _651=_644["useCache"]==true||(this.useCache==true&&_644["useCache"]!=false);
if(!_650&&_651){
var _652=getFromCache(url,_646,_644.method);
if(_652){
doLoad(_644,_652,url,_646,false);
return;
}
}
var http=dojo.hostenv.getXmlhttpObject(_644);
var _654=false;
if(_64f){
var _655=this.inFlight.push({"req":_644,"http":http,"url":url,"query":_646,"useCache":_651,"startTime":_644.timeoutSeconds?(new Date()).getTime():0});
this.startWatchingInFlight();
}else{
_623._blockAsync=true;
}
if(_644.method.toLowerCase()=="post"){
if(!_644.user){
http.open("POST",url,_64f);
}else{
http.open("POST",url,_64f,_644.user,_644.password);
}
setHeaders(http,_644);
http.setRequestHeader("Content-Type",_644.multipart?("multipart/form-data; boundary="+this.multipartBoundary):(_644.contentType||"application/x-www-form-urlencoded"));
try{
http.send(_646);
}
catch(e){
if(typeof http.abort=="function"){
http.abort();
}
doLoad(_644,{status:404},url,_646,_651);
}
}else{
var _656=url;
if(_646!=""){
_656+=(_656.indexOf("?")>-1?"&":"?")+_646;
}
if(_650){
_656+=(dojo.string.endsWithAny(_656,"?","&")?"":(_656.indexOf("?")>-1?"&":"?"))+"dojo.preventCache="+new Date().valueOf();
}
if(!_644.user){
http.open(_644.method.toUpperCase(),_656,_64f);
}else{
http.open(_644.method.toUpperCase(),_656,_64f,_644.user,_644.password);
}
setHeaders(http,_644);
try{
http.send(null);
}
catch(e){
if(typeof http.abort=="function"){
http.abort();
}
doLoad(_644,{status:404},url,_646,_651);
}
}
if(!_64f){
doLoad(_644,http,url,_646,_651);
_623._blockAsync=false;
}
_644.abort=function(){
try{
http._aborted=true;
}
catch(e){
}
return http.abort();
};
return;
};
dojo.io.transports.addTransport("XMLHTTPTransport");
};
}
dojo.provide("dojo.io.cookie");
dojo.io.cookie.setCookie=function(name,_658,days,path,_65b,_65c){
var _65d=-1;
if((typeof days=="number")&&(days>=0)){
var d=new Date();
d.setTime(d.getTime()+(days*24*60*60*1000));
_65d=d.toGMTString();
}
_658=escape(_658);
document.cookie=name+"="+_658+";"+(_65d!=-1?" expires="+_65d+";":"")+(path?"path="+path:"")+(_65b?"; domain="+_65b:"")+(_65c?"; secure":"");
};
dojo.io.cookie.set=dojo.io.cookie.setCookie;
dojo.io.cookie.getCookie=function(name){
var idx=document.cookie.lastIndexOf(name+"=");
if(idx==-1){
return null;
}
var _661=document.cookie.substring(idx+name.length+1);
var end=_661.indexOf(";");
if(end==-1){
end=_661.length;
}
_661=_661.substring(0,end);
_661=unescape(_661);
return _661;
};
dojo.io.cookie.get=dojo.io.cookie.getCookie;
dojo.io.cookie.deleteCookie=function(name){
dojo.io.cookie.setCookie(name,"-",0);
};
dojo.io.cookie.setObjectCookie=function(name,obj,days,path,_668,_669,_66a){
if(arguments.length==5){
_66a=_668;
_668=null;
_669=null;
}
var _66b=[],_66c,_66d="";
if(!_66a){
_66c=dojo.io.cookie.getObjectCookie(name);
}
if(days>=0){
if(!_66c){
_66c={};
}
for(var prop in obj){
if(obj[prop]==null){
delete _66c[prop];
}else{
if((typeof obj[prop]=="string")||(typeof obj[prop]=="number")){
_66c[prop]=obj[prop];
}
}
}
prop=null;
for(var prop in _66c){
_66b.push(escape(prop)+"="+escape(_66c[prop]));
}
_66d=_66b.join("&");
}
dojo.io.cookie.setCookie(name,_66d,days,path,_668,_669);
};
dojo.io.cookie.getObjectCookie=function(name){
var _670=null,_671=dojo.io.cookie.getCookie(name);
if(_671){
_670={};
var _672=_671.split("&");
for(var i=0;i<_672.length;i++){
var pair=_672[i].split("=");
var _675=pair[1];
if(isNaN(_675)){
_675=unescape(pair[1]);
}
_670[unescape(pair[0])]=_675;
}
}
return _670;
};
dojo.io.cookie.isSupported=function(){
if(typeof navigator.cookieEnabled!="boolean"){
dojo.io.cookie.setCookie("__TestingYourBrowserForCookieSupport__","CookiesAllowed",90,null);
var _676=dojo.io.cookie.getCookie("__TestingYourBrowserForCookieSupport__");
navigator.cookieEnabled=(_676=="CookiesAllowed");
if(navigator.cookieEnabled){
this.deleteCookie("__TestingYourBrowserForCookieSupport__");
}
}
return navigator.cookieEnabled;
};
if(!dojo.io.cookies){
dojo.io.cookies=dojo.io.cookie;
}
dojo.kwCompoundRequire({common:["dojo.io.common"],rhino:["dojo.io.RhinoIO"],browser:["dojo.io.BrowserIO","dojo.io.cookie"],dashboard:["dojo.io.BrowserIO","dojo.io.cookie"]});
dojo.provide("dojo.io.*");
dojo.kwCompoundRequire({common:[["dojo.uri.Uri",false,false]]});
dojo.provide("dojo.uri.*");
dojo.provide("dojo.io.IframeIO");
dojo.io.createIFrame=function(_677,_678,uri){
if(window[_677]){
return window[_677];
}
if(window.frames[_677]){
return window.frames[_677];
}
var r=dojo.render.html;
var _67b=null;
var turi=uri;
if(!turi){
if(djConfig["useXDomain"]&&!djConfig["dojoIframeHistoryUrl"]){
dojo.debug("dojo.io.createIFrame: When using cross-domain Dojo builds,"+" please save iframe_history.html to your domain and set djConfig.dojoIframeHistoryUrl"+" to the path on your domain to iframe_history.html");
}
turi=(djConfig["dojoIframeHistoryUrl"]||dojo.uri.moduleUri("dojo","../iframe_history.html"))+"#noInit=true";
}
var _67d=((r.ie)&&(dojo.render.os.win))?"<iframe name=\""+_677+"\" src=\""+turi+"\" onload=\""+_678+"\">":"iframe";
_67b=document.createElement(_67d);
with(_67b){
name=_677;
setAttribute("name",_677);
id=_677;
}
dojo.body().appendChild(_67b);
window[_677]=_67b;
with(_67b.style){
if(!r.safari){
position="absolute";
}
left=top="0px";
height=width="1px";
visibility="hidden";
}
if(!r.ie){
dojo.io.setIFrameSrc(_67b,turi,true);
_67b.onload=new Function(_678);
}
return _67b;
};
dojo.io.IframeTransport=new function(){
var _67e=this;
this.currentRequest=null;
this.requestQueue=[];
this.iframeName="dojoIoIframe";
this.fireNextRequest=function(){
try{
if((this.currentRequest)||(this.requestQueue.length==0)){
return;
}
var cr=this.currentRequest=this.requestQueue.shift();
cr._contentToClean=[];
var fn=cr["formNode"];
var _681=cr["content"]||{};
if(cr.sendTransport){
_681["dojo.transport"]="iframe";
}
if(fn){
if(_681){
for(var x in _681){
if(!fn[x]){
var tn;
if(dojo.render.html.ie){
tn=document.createElement("<input type='hidden' name='"+x+"' value='"+_681[x]+"'>");
fn.appendChild(tn);
}else{
tn=document.createElement("input");
fn.appendChild(tn);
tn.type="hidden";
tn.name=x;
tn.value=_681[x];
}
cr._contentToClean.push(x);
}else{
fn[x].value=_681[x];
}
}
}
if(cr["url"]){
cr._originalAction=fn.getAttribute("action");
fn.setAttribute("action",cr.url);
}
if(!fn.getAttribute("method")){
fn.setAttribute("method",(cr["method"])?cr["method"]:"post");
}
cr._originalTarget=fn.getAttribute("target");
fn.setAttribute("target",this.iframeName);
fn.target=this.iframeName;
fn.submit();
}else{
var _684=dojo.io.argsFromMap(this.currentRequest.content);
var _685=cr.url+(cr.url.indexOf("?")>-1?"&":"?")+_684;
dojo.io.setIFrameSrc(this.iframe,_685,true);
}
}
catch(e){
this.iframeOnload(e);
}
};
this.canHandle=function(_686){
return ((dojo.lang.inArray(["text/plain","text/html","text/javascript","text/json","application/json"],_686["mimetype"]))&&(dojo.lang.inArray(["post","get"],_686["method"].toLowerCase()))&&(!((_686["sync"])&&(_686["sync"]==true))));
};
this.bind=function(_687){
if(!this["iframe"]){
this.setUpIframe();
}
this.requestQueue.push(_687);
this.fireNextRequest();
return;
};
this.setUpIframe=function(){
this.iframe=dojo.io.createIFrame(this.iframeName,"dojo.io.IframeTransport.iframeOnload();");
};
this.iframeOnload=function(_688){
if(!_67e.currentRequest){
_67e.fireNextRequest();
return;
}
var req=_67e.currentRequest;
if(req.formNode){
var _68a=req._contentToClean;
for(var i=0;i<_68a.length;i++){
var key=_68a[i];
if(dojo.render.html.safari){
var _68d=req.formNode;
for(var j=0;j<_68d.childNodes.length;j++){
var _68f=_68d.childNodes[j];
if(_68f.name==key){
var _690=_68f.parentNode;
_690.removeChild(_68f);
break;
}
}
}else{
var _691=req.formNode[key];
req.formNode.removeChild(_691);
req.formNode[key]=null;
}
}
if(req["_originalAction"]){
req.formNode.setAttribute("action",req._originalAction);
}
if(req["_originalTarget"]){
req.formNode.setAttribute("target",req._originalTarget);
req.formNode.target=req._originalTarget;
}
}
var _692=function(_693){
var doc=_693.contentDocument||((_693.contentWindow)&&(_693.contentWindow.document))||((_693.name)&&(document.frames[_693.name])&&(document.frames[_693.name].document))||null;
return doc;
};
var _695;
var _696=false;
if(_688){
this._callError(req,"IframeTransport Request Error: "+_688);
}else{
var ifd=_692(_67e.iframe);
try{
var cmt=req.mimetype;
if((cmt=="text/javascript")||(cmt=="text/json")||(cmt=="application/json")){
var js=ifd.getElementsByTagName("textarea")[0].value;
if(cmt=="text/json"||cmt=="application/json"){
js="("+js+")";
}
_695=dj_eval(js);
}else{
if(cmt=="text/html"){
_695=ifd;
}else{
_695=ifd.getElementsByTagName("textarea")[0].value;
}
}
_696=true;
}
catch(e){
this._callError(req,"IframeTransport Error: "+e);
}
}
try{
if(_696&&dojo.lang.isFunction(req["load"])){
req.load("load",_695,req);
}
}
catch(e){
throw e;
}
finally{
_67e.currentRequest=null;
_67e.fireNextRequest();
}
};
this._callError=function(req,_69b){
var _69c=new dojo.io.Error(_69b);
if(dojo.lang.isFunction(req["error"])){
req.error("error",_69c,req);
}
};
dojo.io.transports.addTransport("IframeTransport");
};
dojo.provide("dojo.string.Builder");
dojo.string.Builder=function(str){
this.arrConcat=(dojo.render.html.capable&&dojo.render.html["ie"]);
var a=[];
var b="";
var _6a0=this.length=b.length;
if(this.arrConcat){
if(b.length>0){
a.push(b);
}
b="";
}
this.toString=this.valueOf=function(){
return (this.arrConcat)?a.join(""):b;
};
this.append=function(){
for(var x=0;x<arguments.length;x++){
var s=arguments[x];
if(dojo.lang.isArrayLike(s)){
this.append.apply(this,s);
}else{
if(this.arrConcat){
a.push(s);
}else{
b+=s;
}
_6a0+=s.length;
this.length=_6a0;
}
}
return this;
};
this.concat=function(){
return this.append.apply(this,arguments);
};
this.clear=function(){
a=[];
b="";
_6a0=this.length=0;
return this;
};
this.remove=function(f,l){
var s="";
if(this.arrConcat){
b=a.join("");
}
a=[];
if(f>0){
s=b.substring(0,(f-1));
}
b=s+b.substring(f+l);
_6a0=this.length=b.length;
if(this.arrConcat){
a.push(b);
b="";
}
return this;
};
this.replace=function(o,n){
if(this.arrConcat){
b=a.join("");
}
a=[];
b=b.replace(o,n);
_6a0=this.length=b.length;
if(this.arrConcat){
a.push(b);
b="";
}
return this;
};
this.insert=function(idx,s){
if(this.arrConcat){
b=a.join("");
}
a=[];
if(idx==0){
b=s+b;
}else{
var t=b.split("");
t.splice(idx,0,s);
b=t.join("");
}
_6a0=this.length=b.length;
if(this.arrConcat){
a.push(b);
b="";
}
return this;
};
this.append.apply(this,arguments);
};
dojo.kwCompoundRequire({common:["dojo.string","dojo.string.common","dojo.string.extras","dojo.string.Builder"]});
dojo.provide("dojo.string.*");
dojo.provide("dojo.AdapterRegistry");
dojo.AdapterRegistry=function(_6ab){
this.pairs=[];
this.returnWrappers=_6ab||false;
};
dojo.lang.extend(dojo.AdapterRegistry,{register:function(name,_6ad,wrap,_6af,_6b0){
var type=(_6b0)?"unshift":"push";
this.pairs[type]([name,_6ad,wrap,_6af]);
},match:function(){
for(var i=0;i<this.pairs.length;i++){
var pair=this.pairs[i];
if(pair[1].apply(this,arguments)){
if((pair[3])||(this.returnWrappers)){
return pair[2];
}else{
return pair[2].apply(this,arguments);
}
}
}
throw new Error("No match found");
},unregister:function(name){
for(var i=0;i<this.pairs.length;i++){
var pair=this.pairs[i];
if(pair[0]==name){
this.pairs.splice(i,1);
return true;
}
}
return false;
}});
dojo.provide("dojo.json");
dojo.json={jsonRegistry:new dojo.AdapterRegistry(),register:function(name,_6b8,wrap,_6ba){
dojo.json.jsonRegistry.register(name,_6b8,wrap,_6ba);
},evalJson:function(json){
try{
return eval("("+json+")");
}
catch(e){
dojo.debug(e);
return json;
}
},serialize:function(o){
var _6bd=typeof (o);
if(_6bd=="undefined"){
return "undefined";
}else{
if((_6bd=="number")||(_6bd=="boolean")){
return o+"";
}else{
if(o===null){
return "null";
}
}
}
if(_6bd=="string"){
return dojo.string.escapeString(o);
}
var me=arguments.callee;
var _6bf;
if(typeof (o.__json__)=="function"){
_6bf=o.__json__();
if(o!==_6bf){
return me(_6bf);
}
}
if(typeof (o.json)=="function"){
_6bf=o.json();
if(o!==_6bf){
return me(_6bf);
}
}
if(_6bd!="function"&&typeof (o.length)=="number"){
var res=[];
for(var i=0;i<o.length;i++){
var val=me(o[i]);
if(typeof (val)!="string"){
val="undefined";
}
res.push(val);
}
return "["+res.join(",")+"]";
}
try{
window.o=o;
_6bf=dojo.json.jsonRegistry.match(o);
return me(_6bf);
}
catch(e){
}
if(_6bd=="function"){
return null;
}
res=[];
for(var k in o){
var _6c4;
if(typeof (k)=="number"){
_6c4="\""+k+"\"";
}else{
if(typeof (k)=="string"){
_6c4=dojo.string.escapeString(k);
}else{
continue;
}
}
val=me(o[k]);
if(typeof (val)!="string"){
continue;
}
res.push(_6c4+":"+val);
}
return "{"+res.join(",")+"}";
}};
dojo.provide("dojo.Deferred");
dojo.Deferred=function(_6c5){
this.chain=[];
this.id=this._nextId();
this.fired=-1;
this.paused=0;
this.results=[null,null];
this.canceller=_6c5;
this.silentlyCancelled=false;
};
dojo.lang.extend(dojo.Deferred,{getFunctionFromArgs:function(){
var a=arguments;
if((a[0])&&(!a[1])){
if(dojo.lang.isFunction(a[0])){
return a[0];
}else{
if(dojo.lang.isString(a[0])){
return dj_global[a[0]];
}
}
}else{
if((a[0])&&(a[1])){
return dojo.lang.hitch(a[0],a[1]);
}
}
return null;
},makeCalled:function(){
var _6c7=new dojo.Deferred();
_6c7.callback();
return _6c7;
},repr:function(){
var _6c8;
if(this.fired==-1){
_6c8="unfired";
}else{
if(this.fired==0){
_6c8="success";
}else{
_6c8="error";
}
}
return "Deferred("+this.id+", "+_6c8+")";
},toString:dojo.lang.forward("repr"),_nextId:(function(){
var n=1;
return function(){
return n++;
};
})(),cancel:function(){
if(this.fired==-1){
if(this.canceller){
this.canceller(this);
}else{
this.silentlyCancelled=true;
}
if(this.fired==-1){
this.errback(new Error(this.repr()));
}
}else{
if((this.fired==0)&&(this.results[0] instanceof dojo.Deferred)){
this.results[0].cancel();
}
}
},_pause:function(){
this.paused++;
},_unpause:function(){
this.paused--;
if((this.paused==0)&&(this.fired>=0)){
this._fire();
}
},_continue:function(res){
this._resback(res);
this._unpause();
},_resback:function(res){
this.fired=((res instanceof Error)?1:0);
this.results[this.fired]=res;
this._fire();
},_check:function(){
if(this.fired!=-1){
if(!this.silentlyCancelled){
dojo.raise("already called!");
}
this.silentlyCancelled=false;
return;
}
},callback:function(res){
this._check();
this._resback(res);
},errback:function(res){
this._check();
if(!(res instanceof Error)){
res=new Error(res);
}
this._resback(res);
},addBoth:function(cb,cbfn){
var _6d0=this.getFunctionFromArgs(cb,cbfn);
if(arguments.length>2){
_6d0=dojo.lang.curryArguments(null,_6d0,arguments,2);
}
return this.addCallbacks(_6d0,_6d0);
},addCallback:function(cb,cbfn){
var _6d3=this.getFunctionFromArgs(cb,cbfn);
if(arguments.length>2){
_6d3=dojo.lang.curryArguments(null,_6d3,arguments,2);
}
return this.addCallbacks(_6d3,null);
},addErrback:function(cb,cbfn){
var _6d6=this.getFunctionFromArgs(cb,cbfn);
if(arguments.length>2){
_6d6=dojo.lang.curryArguments(null,_6d6,arguments,2);
}
return this.addCallbacks(null,_6d6);
return this.addCallbacks(null,cbfn);
},addCallbacks:function(cb,eb){
this.chain.push([cb,eb]);
if(this.fired>=0){
this._fire();
}
return this;
},_fire:function(){
var _6d9=this.chain;
var _6da=this.fired;
var res=this.results[_6da];
var self=this;
var cb=null;
while(_6d9.length>0&&this.paused==0){
var pair=_6d9.shift();
var f=pair[_6da];
if(f==null){
continue;
}
try{
res=f(res);
_6da=((res instanceof Error)?1:0);
if(res instanceof dojo.Deferred){
cb=function(res){
self._continue(res);
};
this._pause();
}
}
catch(err){
_6da=1;
res=err;
}
}
this.fired=_6da;
this.results[_6da]=res;
if((cb)&&(this.paused)){
res.addBoth(cb);
}
}});
dojo.provide("dojo.rpc.RpcService");
dojo.rpc.RpcService=function(url){
if(url){
this.connect(url);
}
};
dojo.lang.extend(dojo.rpc.RpcService,{strictArgChecks:true,serviceUrl:"",parseResults:function(obj){
return obj;
},errorCallback:function(_6e3){
return function(type,e){
_6e3.errback(new Error(e.message));
};
},resultCallback:function(_6e6){
var tf=dojo.lang.hitch(this,function(type,obj,e){
if(obj["error"]!=null){
var err=new Error(obj.error);
err.id=obj.id;
_6e6.errback(err);
}else{
var _6ec=this.parseResults(obj);
_6e6.callback(_6ec);
}
});
return tf;
},generateMethod:function(_6ed,_6ee,url){
return dojo.lang.hitch(this,function(){
var _6f0=new dojo.Deferred();
if((this.strictArgChecks)&&(_6ee!=null)&&(arguments.length!=_6ee.length)){
dojo.raise("Invalid number of parameters for remote method.");
}else{
this.bind(_6ed,arguments,_6f0,url);
}
return _6f0;
});
},processSmd:function(_6f1){
dojo.debug("RpcService: Processing returned SMD.");
if(_6f1.methods){
dojo.lang.forEach(_6f1.methods,function(m){
if(m&&m["name"]){
dojo.debug("RpcService: Creating Method: this.",m.name,"()");
this[m.name]=this.generateMethod(m.name,m.parameters,m["url"]||m["serviceUrl"]||m["serviceURL"]);
if(dojo.lang.isFunction(this[m.name])){
dojo.debug("RpcService: Successfully created",m.name,"()");
}else{
dojo.debug("RpcService: Failed to create",m.name,"()");
}
}
},this);
}
this.serviceUrl=_6f1.serviceUrl||_6f1.serviceURL;
dojo.debug("RpcService: Dojo RpcService is ready for use.");
},connect:function(_6f3){
dojo.debug("RpcService: Attempting to load SMD document from:",_6f3);
dojo.io.bind({url:_6f3,mimetype:"text/json",load:dojo.lang.hitch(this,function(type,_6f5,e){
return this.processSmd(_6f5);
}),sync:true});
}});
dojo.provide("dojo.rpc.JsonService");
dojo.rpc.JsonService=function(args){
if(args){
if(dojo.lang.isString(args)){
this.connect(args);
}else{
if(args["smdUrl"]){
this.connect(args.smdUrl);
}
if(args["smdStr"]){
this.processSmd(dj_eval("("+args.smdStr+")"));
}
if(args["smdObj"]){
this.processSmd(args.smdObj);
}
if(args["serviceUrl"]){
this.serviceUrl=args.serviceUrl;
}
if(typeof args["strictArgChecks"]!="undefined"){
this.strictArgChecks=args.strictArgChecks;
}
}
}
};
dojo.inherits(dojo.rpc.JsonService,dojo.rpc.RpcService);
dojo.extend(dojo.rpc.JsonService,{bustCache:false,contentType:"application/json-rpc",lastSubmissionId:0,callRemote:function(_6f8,_6f9){
var _6fa=new dojo.Deferred();
this.bind(_6f8,_6f9,_6fa);
return _6fa;
},bind:function(_6fb,_6fc,_6fd,url){
dojo.io.bind({url:url||this.serviceUrl,postContent:this.createRequest(_6fb,_6fc),method:"POST",contentType:this.contentType,mimetype:"text/json",load:this.resultCallback(_6fd),error:this.errorCallback(_6fd),preventCache:this.bustCache});
},createRequest:function(_6ff,_700){
var req={"params":_700,"method":_6ff,"id":++this.lastSubmissionId};
var data=dojo.json.serialize(req);
dojo.debug("JsonService: JSON-RPC Request: "+data);
return data;
},parseResults:function(obj){
if(!obj){
return;
}
if(obj["Result"]!=null){
return obj["Result"];
}else{
if(obj["result"]!=null){
return obj["result"];
}else{
if(obj["ResultSet"]){
return obj["ResultSet"];
}else{
return obj;
}
}
}
}});
dojo.kwCompoundRequire({common:[["dojo.rpc.JsonService",false,false]]});
dojo.provide("dojo.rpc.*");
dojo.provide("dojo.xml.Parse");
dojo.xml.Parse=function(){
var isIE=((dojo.render.html.capable)&&(dojo.render.html.ie));
function getTagName(node){
try{
return node.tagName.toLowerCase();
}
catch(e){
return "";
}
}
function getDojoTagName(node){
var _707=getTagName(node);
if(!_707){
return "";
}
if((dojo.widget)&&(dojo.widget.tags[_707])){
return _707;
}
var p=_707.indexOf(":");
if(p>=0){
return _707;
}
if(_707.substr(0,5)=="dojo:"){
return _707;
}
if(dojo.render.html.capable&&dojo.render.html.ie&&node.scopeName&&node.scopeName!="HTML"){
return node.scopeName.toLowerCase()+":"+_707;
}
if(_707.substr(0,4)=="dojo"){
return "dojo:"+_707.substring(4);
}
var djt=node.getAttribute("dojoType")||node.getAttribute("dojotype");
if(djt){
if(djt.indexOf(":")<0){
djt="dojo:"+djt;
}
return djt.toLowerCase();
}
djt=node.getAttributeNS&&node.getAttributeNS(dojo.dom.dojoml,"type");
if(djt){
return "dojo:"+djt.toLowerCase();
}
try{
djt=node.getAttribute("dojo:type");
}
catch(e){
}
if(djt){
return "dojo:"+djt.toLowerCase();
}
if((dj_global["djConfig"])&&(!djConfig["ignoreClassNames"])){
var _70a=node.className||node.getAttribute("class");
if((_70a)&&(_70a.indexOf)&&(_70a.indexOf("dojo-")!=-1)){
var _70b=_70a.split(" ");
for(var x=0,c=_70b.length;x<c;x++){
if(_70b[x].slice(0,5)=="dojo-"){
return "dojo:"+_70b[x].substr(5).toLowerCase();
}
}
}
}
return "";
}
this.parseElement=function(node,_70f,_710,_711){
var _712=getTagName(node);
if(isIE&&_712.indexOf("/")==0){
return null;
}
try{
var attr=node.getAttribute("parseWidgets");
if(attr&&attr.toLowerCase()=="false"){
return {};
}
}
catch(e){
}
var _714=true;
if(_710){
var _715=getDojoTagName(node);
_712=_715||_712;
_714=Boolean(_715);
}
var _716={};
_716[_712]=[];
var pos=_712.indexOf(":");
if(pos>0){
var ns=_712.substring(0,pos);
_716["ns"]=ns;
if((dojo.ns)&&(!dojo.ns.allow(ns))){
_714=false;
}
}
if(_714){
var _719=this.parseAttributes(node);
for(var attr in _719){
if((!_716[_712][attr])||(typeof _716[_712][attr]!="array")){
_716[_712][attr]=[];
}
_716[_712][attr].push(_719[attr]);
}
_716[_712].nodeRef=node;
_716.tagName=_712;
_716.index=_711||0;
}
var _71a=0;
for(var i=0;i<node.childNodes.length;i++){
var tcn=node.childNodes.item(i);
switch(tcn.nodeType){
case dojo.dom.ELEMENT_NODE:
var ctn=getDojoTagName(tcn)||getTagName(tcn);
if(!_716[ctn]){
_716[ctn]=[];
}
_716[ctn].push(this.parseElement(tcn,true,_710,_71a));
if((tcn.childNodes.length==1)&&(tcn.childNodes.item(0).nodeType==dojo.dom.TEXT_NODE)){
_716[ctn][_716[ctn].length-1].value=tcn.childNodes.item(0).nodeValue;
}
_71a++;
break;
case dojo.dom.TEXT_NODE:
if(node.childNodes.length==1){
_716[_712].push({value:node.childNodes.item(0).nodeValue});
}
break;
default:
break;
}
}
return _716;
};
this.parseAttributes=function(node){
var _71f={};
var atts=node.attributes;
var _721,i=0;
while((_721=atts[i++])){
if(isIE){
if(!_721){
continue;
}
if((typeof _721=="object")&&(typeof _721.nodeValue=="undefined")||(_721.nodeValue==null)||(_721.nodeValue=="")){
continue;
}
}
var nn=_721.nodeName.split(":");
nn=(nn.length==2)?nn[1]:_721.nodeName;
_71f[nn]={value:_721.nodeValue};
}
return _71f;
};
};
dojo.kwCompoundRequire({common:["dojo.dom"],browser:["dojo.html.*"],dashboard:["dojo.html.*"]});
dojo.provide("dojo.xml.*");
dojo.provide("dojo.undo.Manager");
dojo.undo.Manager=function(_724){
this.clear();
this._parent=_724;
};
dojo.extend(dojo.undo.Manager,{_parent:null,_undoStack:null,_redoStack:null,_currentManager:null,canUndo:false,canRedo:false,isUndoing:false,isRedoing:false,onUndo:function(_725,item){
},onRedo:function(_727,item){
},onUndoAny:function(_729,item){
},onRedoAny:function(_72b,item){
},_updateStatus:function(){
this.canUndo=this._undoStack.length>0;
this.canRedo=this._redoStack.length>0;
},clear:function(){
this._undoStack=[];
this._redoStack=[];
this._currentManager=this;
this.isUndoing=false;
this.isRedoing=false;
this._updateStatus();
},undo:function(){
if(!this.canUndo){
return false;
}
this.endAllTransactions();
this.isUndoing=true;
var top=this._undoStack.pop();
if(top instanceof dojo.undo.Manager){
top.undoAll();
}else{
top.undo();
}
if(top.redo){
this._redoStack.push(top);
}
this.isUndoing=false;
this._updateStatus();
this.onUndo(this,top);
if(!(top instanceof dojo.undo.Manager)){
this.getTop().onUndoAny(this,top);
}
return true;
},redo:function(){
if(!this.canRedo){
return false;
}
this.isRedoing=true;
var top=this._redoStack.pop();
if(top instanceof dojo.undo.Manager){
top.redoAll();
}else{
top.redo();
}
this._undoStack.push(top);
this.isRedoing=false;
this._updateStatus();
this.onRedo(this,top);
if(!(top instanceof dojo.undo.Manager)){
this.getTop().onRedoAny(this,top);
}
return true;
},undoAll:function(){
while(this._undoStack.length>0){
this.undo();
}
},redoAll:function(){
while(this._redoStack.length>0){
this.redo();
}
},push:function(undo,redo,_731){
if(!undo){
return;
}
if(this._currentManager==this){
this._undoStack.push({undo:undo,redo:redo,description:_731});
}else{
this._currentManager.push.apply(this._currentManager,arguments);
}
this._redoStack=[];
this._updateStatus();
},concat:function(_732){
if(!_732){
return;
}
if(this._currentManager==this){
for(var x=0;x<_732._undoStack.length;x++){
this._undoStack.push(_732._undoStack[x]);
}
if(_732._undoStack.length>0){
this._redoStack=[];
}
this._updateStatus();
}else{
this._currentManager.concat.apply(this._currentManager,arguments);
}
},beginTransaction:function(_734){
if(this._currentManager==this){
var mgr=new dojo.undo.Manager(this);
mgr.description=_734?_734:"";
this._undoStack.push(mgr);
this._currentManager=mgr;
return mgr;
}else{
this._currentManager=this._currentManager.beginTransaction.apply(this._currentManager,arguments);
}
},endTransaction:function(_736){
if(this._currentManager==this){
if(this._parent){
this._parent._currentManager=this._parent;
if(this._undoStack.length==0||_736){
var idx=dojo.lang.find(this._parent._undoStack,this);
if(idx>=0){
this._parent._undoStack.splice(idx,1);
if(_736){
for(var x=0;x<this._undoStack.length;x++){
this._parent._undoStack.splice(idx++,0,this._undoStack[x]);
}
this._updateStatus();
}
}
}
return this._parent;
}
}else{
this._currentManager=this._currentManager.endTransaction.apply(this._currentManager,arguments);
}
},endAllTransactions:function(){
while(this._currentManager!=this){
this.endTransaction();
}
},getTop:function(){
if(this._parent){
return this._parent.getTop();
}else{
return this;
}
}});
dojo.provide("dojo.undo.*");
dojo.provide("dojo.crypto");
dojo.crypto.cipherModes={ECB:0,CBC:1,PCBC:2,CFB:3,OFB:4,CTR:5};
dojo.crypto.outputTypes={Base64:0,Hex:1,String:2,Raw:3};
dojo.provide("dojo.crypto.MD5");
dojo.crypto.MD5=new function(){
var _739=8;
var mask=(1<<_739)-1;
function toWord(s){
var wa=[];
for(var i=0;i<s.length*_739;i+=_739){
wa[i>>5]|=(s.charCodeAt(i/_739)&mask)<<(i%32);
}
return wa;
}
function toString(wa){
var s=[];
for(var i=0;i<wa.length*32;i+=_739){
s.push(String.fromCharCode((wa[i>>5]>>>(i%32))&mask));
}
return s.join("");
}
function toHex(wa){
var h="0123456789abcdef";
var s=[];
for(var i=0;i<wa.length*4;i++){
s.push(h.charAt((wa[i>>2]>>((i%4)*8+4))&15)+h.charAt((wa[i>>2]>>((i%4)*8))&15));
}
return s.join("");
}
function toBase64(wa){
var p="=";
var tab="ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/";
var s=[];
for(var i=0;i<wa.length*4;i+=3){
var t=(((wa[i>>2]>>8*(i%4))&255)<<16)|(((wa[i+1>>2]>>8*((i+1)%4))&255)<<8)|((wa[i+2>>2]>>8*((i+2)%4))&255);
for(var j=0;j<4;j++){
if(i*8+j*6>wa.length*32){
s.push(p);
}else{
s.push(tab.charAt((t>>6*(3-j))&63));
}
}
}
return s.join("");
}
function add(x,y){
var l=(x&65535)+(y&65535);
var m=(x>>16)+(y>>16)+(l>>16);
return (m<<16)|(l&65535);
}
function R(n,c){
return (n<<c)|(n>>>(32-c));
}
function C(q,a,b,x,s,t){
return add(R(add(add(a,q),add(x,t)),s),b);
}
function FF(a,b,c,d,x,s,t){
return C((b&c)|((~b)&d),a,b,x,s,t);
}
function GG(a,b,c,d,x,s,t){
return C((b&d)|(c&(~d)),a,b,x,s,t);
}
function HH(a,b,c,d,x,s,t){
return C(b^c^d,a,b,x,s,t);
}
function II(a,b,c,d,x,s,t){
return C(c^(b|(~d)),a,b,x,s,t);
}
function core(x,len){
x[len>>5]|=128<<((len)%32);
x[(((len+64)>>>9)<<4)+14]=len;
var a=1732584193;
var b=-271733879;
var c=-1732584194;
var d=271733878;
for(var i=0;i<x.length;i+=16){
var olda=a;
var oldb=b;
var oldc=c;
var oldd=d;
a=FF(a,b,c,d,x[i+0],7,-680876936);
d=FF(d,a,b,c,x[i+1],12,-389564586);
c=FF(c,d,a,b,x[i+2],17,606105819);
b=FF(b,c,d,a,x[i+3],22,-1044525330);
a=FF(a,b,c,d,x[i+4],7,-176418897);
d=FF(d,a,b,c,x[i+5],12,1200080426);
c=FF(c,d,a,b,x[i+6],17,-1473231341);
b=FF(b,c,d,a,x[i+7],22,-45705983);
a=FF(a,b,c,d,x[i+8],7,1770035416);
d=FF(d,a,b,c,x[i+9],12,-1958414417);
c=FF(c,d,a,b,x[i+10],17,-42063);
b=FF(b,c,d,a,x[i+11],22,-1990404162);
a=FF(a,b,c,d,x[i+12],7,1804603682);
d=FF(d,a,b,c,x[i+13],12,-40341101);
c=FF(c,d,a,b,x[i+14],17,-1502002290);
b=FF(b,c,d,a,x[i+15],22,1236535329);
a=GG(a,b,c,d,x[i+1],5,-165796510);
d=GG(d,a,b,c,x[i+6],9,-1069501632);
c=GG(c,d,a,b,x[i+11],14,643717713);
b=GG(b,c,d,a,x[i+0],20,-373897302);
a=GG(a,b,c,d,x[i+5],5,-701558691);
d=GG(d,a,b,c,x[i+10],9,38016083);
c=GG(c,d,a,b,x[i+15],14,-660478335);
b=GG(b,c,d,a,x[i+4],20,-405537848);
a=GG(a,b,c,d,x[i+9],5,568446438);
d=GG(d,a,b,c,x[i+14],9,-1019803690);
c=GG(c,d,a,b,x[i+3],14,-187363961);
b=GG(b,c,d,a,x[i+8],20,1163531501);
a=GG(a,b,c,d,x[i+13],5,-1444681467);
d=GG(d,a,b,c,x[i+2],9,-51403784);
c=GG(c,d,a,b,x[i+7],14,1735328473);
b=GG(b,c,d,a,x[i+12],20,-1926607734);
a=HH(a,b,c,d,x[i+5],4,-378558);
d=HH(d,a,b,c,x[i+8],11,-2022574463);
c=HH(c,d,a,b,x[i+11],16,1839030562);
b=HH(b,c,d,a,x[i+14],23,-35309556);
a=HH(a,b,c,d,x[i+1],4,-1530992060);
d=HH(d,a,b,c,x[i+4],11,1272893353);
c=HH(c,d,a,b,x[i+7],16,-155497632);
b=HH(b,c,d,a,x[i+10],23,-1094730640);
a=HH(a,b,c,d,x[i+13],4,681279174);
d=HH(d,a,b,c,x[i+0],11,-358537222);
c=HH(c,d,a,b,x[i+3],16,-722521979);
b=HH(b,c,d,a,x[i+6],23,76029189);
a=HH(a,b,c,d,x[i+9],4,-640364487);
d=HH(d,a,b,c,x[i+12],11,-421815835);
c=HH(c,d,a,b,x[i+15],16,530742520);
b=HH(b,c,d,a,x[i+2],23,-995338651);
a=II(a,b,c,d,x[i+0],6,-198630844);
d=II(d,a,b,c,x[i+7],10,1126891415);
c=II(c,d,a,b,x[i+14],15,-1416354905);
b=II(b,c,d,a,x[i+5],21,-57434055);
a=II(a,b,c,d,x[i+12],6,1700485571);
d=II(d,a,b,c,x[i+3],10,-1894986606);
c=II(c,d,a,b,x[i+10],15,-1051523);
b=II(b,c,d,a,x[i+1],21,-2054922799);
a=II(a,b,c,d,x[i+8],6,1873313359);
d=II(d,a,b,c,x[i+15],10,-30611744);
c=II(c,d,a,b,x[i+6],15,-1560198380);
b=II(b,c,d,a,x[i+13],21,1309151649);
a=II(a,b,c,d,x[i+4],6,-145523070);
d=II(d,a,b,c,x[i+11],10,-1120210379);
c=II(c,d,a,b,x[i+2],15,718787259);
b=II(b,c,d,a,x[i+9],21,-343485551);
a=add(a,olda);
b=add(b,oldb);
c=add(c,oldc);
d=add(d,oldd);
}
return [a,b,c,d];
}
function hmac(data,key){
var wa=toWord(key);
if(wa.length>16){
wa=core(wa,key.length*_739);
}
var l=[],r=[];
for(var i=0;i<16;i++){
l[i]=wa[i]^909522486;
r[i]=wa[i]^1549556828;
}
var h=core(l.concat(toWord(data)),512+data.length*_739);
return core(r.concat(h),640);
}
this.compute=function(data,_787){
var out=_787||dojo.crypto.outputTypes.Base64;
switch(out){
case dojo.crypto.outputTypes.Hex:
return toHex(core(toWord(data),data.length*_739));
case dojo.crypto.outputTypes.String:
return toString(core(toWord(data),data.length*_739));
default:
return toBase64(core(toWord(data),data.length*_739));
}
};
this.getHMAC=function(data,key,_78b){
var out=_78b||dojo.crypto.outputTypes.Base64;
switch(out){
case dojo.crypto.outputTypes.Hex:
return toHex(hmac(data,key));
case dojo.crypto.outputTypes.String:
return toString(hmac(data,key));
default:
return toBase64(hmac(data,key));
}
};
}();
dojo.kwCompoundRequire({common:["dojo.crypto","dojo.crypto.MD5"]});
dojo.provide("dojo.crypto.*");
dojo.provide("dojo.collections.Collections");
dojo.collections.DictionaryEntry=function(k,v){
this.key=k;
this.value=v;
this.valueOf=function(){
return this.value;
};
this.toString=function(){
return String(this.value);
};
};
dojo.collections.Iterator=function(arr){
var a=arr;
var _791=0;
this.element=a[_791]||null;
this.atEnd=function(){
return (_791>=a.length);
};
this.get=function(){
if(this.atEnd()){
return null;
}
this.element=a[_791++];
return this.element;
};
this.map=function(fn,_793){
var s=_793||dj_global;
if(Array.map){
return Array.map(a,fn,s);
}else{
var arr=[];
for(var i=0;i<a.length;i++){
arr.push(fn.call(s,a[i]));
}
return arr;
}
};
this.reset=function(){
_791=0;
this.element=a[_791];
};
};
dojo.collections.DictionaryIterator=function(obj){
var a=[];
var _799={};
for(var p in obj){
if(!_799[p]){
a.push(obj[p]);
}
}
var _79b=0;
this.element=a[_79b]||null;
this.atEnd=function(){
return (_79b>=a.length);
};
this.get=function(){
if(this.atEnd()){
return null;
}
this.element=a[_79b++];
return this.element;
};
this.map=function(fn,_79d){
var s=_79d||dj_global;
if(Array.map){
return Array.map(a,fn,s);
}else{
var arr=[];
for(var i=0;i<a.length;i++){
arr.push(fn.call(s,a[i]));
}
return arr;
}
};
this.reset=function(){
_79b=0;
this.element=a[_79b];
};
};
dojo.provide("dojo.collections.ArrayList");
dojo.collections.ArrayList=function(arr){
var _7a2=[];
if(arr){
_7a2=_7a2.concat(arr);
}
this.count=_7a2.length;
this.add=function(obj){
_7a2.push(obj);
this.count=_7a2.length;
};
this.addRange=function(a){
if(a.getIterator){
var e=a.getIterator();
while(!e.atEnd()){
this.add(e.get());
}
this.count=_7a2.length;
}else{
for(var i=0;i<a.length;i++){
_7a2.push(a[i]);
}
this.count=_7a2.length;
}
};
this.clear=function(){
_7a2.splice(0,_7a2.length);
this.count=0;
};
this.clone=function(){
return new dojo.collections.ArrayList(_7a2);
};
this.contains=function(obj){
for(var i=0;i<_7a2.length;i++){
if(_7a2[i]==obj){
return true;
}
}
return false;
};
this.forEach=function(fn,_7aa){
var s=_7aa||dj_global;
if(Array.forEach){
Array.forEach(_7a2,fn,s);
}else{
for(var i=0;i<_7a2.length;i++){
fn.call(s,_7a2[i],i,_7a2);
}
}
};
this.getIterator=function(){
return new dojo.collections.Iterator(_7a2);
};
this.indexOf=function(obj){
for(var i=0;i<_7a2.length;i++){
if(_7a2[i]==obj){
return i;
}
}
return -1;
};
this.insert=function(i,obj){
_7a2.splice(i,0,obj);
this.count=_7a2.length;
};
this.item=function(i){
return _7a2[i];
};
this.remove=function(obj){
var i=this.indexOf(obj);
if(i>=0){
_7a2.splice(i,1);
}
this.count=_7a2.length;
};
this.removeAt=function(i){
_7a2.splice(i,1);
this.count=_7a2.length;
};
this.reverse=function(){
_7a2.reverse();
};
this.sort=function(fn){
if(fn){
_7a2.sort(fn);
}else{
_7a2.sort();
}
};
this.setByIndex=function(i,obj){
_7a2[i]=obj;
this.count=_7a2.length;
};
this.toArray=function(){
return [].concat(_7a2);
};
this.toString=function(_7b8){
return _7a2.join((_7b8||","));
};
};
dojo.provide("dojo.collections.Queue");
dojo.collections.Queue=function(arr){
var q=[];
if(arr){
q=q.concat(arr);
}
this.count=q.length;
this.clear=function(){
q=[];
this.count=q.length;
};
this.clone=function(){
return new dojo.collections.Queue(q);
};
this.contains=function(o){
for(var i=0;i<q.length;i++){
if(q[i]==o){
return true;
}
}
return false;
};
this.copyTo=function(arr,i){
arr.splice(i,0,q);
};
this.dequeue=function(){
var r=q.shift();
this.count=q.length;
return r;
};
this.enqueue=function(o){
this.count=q.push(o);
};
this.forEach=function(fn,_7c2){
var s=_7c2||dj_global;
if(Array.forEach){
Array.forEach(q,fn,s);
}else{
for(var i=0;i<q.length;i++){
fn.call(s,q[i],i,q);
}
}
};
this.getIterator=function(){
return new dojo.collections.Iterator(q);
};
this.peek=function(){
return q[0];
};
this.toArray=function(){
return [].concat(q);
};
};
dojo.provide("dojo.collections.Stack");
dojo.collections.Stack=function(arr){
var q=[];
if(arr){
q=q.concat(arr);
}
this.count=q.length;
this.clear=function(){
q=[];
this.count=q.length;
};
this.clone=function(){
return new dojo.collections.Stack(q);
};
this.contains=function(o){
for(var i=0;i<q.length;i++){
if(q[i]==o){
return true;
}
}
return false;
};
this.copyTo=function(arr,i){
arr.splice(i,0,q);
};
this.forEach=function(fn,_7cc){
var s=_7cc||dj_global;
if(Array.forEach){
Array.forEach(q,fn,s);
}else{
for(var i=0;i<q.length;i++){
fn.call(s,q[i],i,q);
}
}
};
this.getIterator=function(){
return new dojo.collections.Iterator(q);
};
this.peek=function(){
return q[(q.length-1)];
};
this.pop=function(){
var r=q.pop();
this.count=q.length;
return r;
};
this.push=function(o){
this.count=q.push(o);
};
this.toArray=function(){
return [].concat(q);
};
};
dojo.provide("dojo.dnd.DragAndDrop");
dojo.declare("dojo.dnd.DragSource",null,{type:"",onDragEnd:function(evt){
},onDragStart:function(evt){
},onSelected:function(evt){
},unregister:function(){
dojo.dnd.dragManager.unregisterDragSource(this);
},reregister:function(){
dojo.dnd.dragManager.registerDragSource(this);
}});
dojo.declare("dojo.dnd.DragObject",null,{type:"",register:function(){
var dm=dojo.dnd.dragManager;
if(dm["registerDragObject"]){
dm.registerDragObject(this);
}
},onDragStart:function(evt){
},onDragMove:function(evt){
},onDragOver:function(evt){
},onDragOut:function(evt){
},onDragEnd:function(evt){
},onDragLeave:dojo.lang.forward("onDragOut"),onDragEnter:dojo.lang.forward("onDragOver"),ondragout:dojo.lang.forward("onDragOut"),ondragover:dojo.lang.forward("onDragOver")});
dojo.declare("dojo.dnd.DropTarget",null,function(){
this.acceptedTypes=[];
},{acceptsType:function(type){
if(!dojo.lang.inArray(this.acceptedTypes,"*")){
if(!dojo.lang.inArray(this.acceptedTypes,type)){
return false;
}
}
return true;
},accepts:function(_7db){
if(!dojo.lang.inArray(this.acceptedTypes,"*")){
for(var i=0;i<_7db.length;i++){
if(!dojo.lang.inArray(this.acceptedTypes,_7db[i].type)){
return false;
}
}
}
return true;
},unregister:function(){
dojo.dnd.dragManager.unregisterDropTarget(this);
},onDragOver:function(evt){
},onDragOut:function(evt){
},onDragMove:function(evt){
},onDropStart:function(evt){
},onDrop:function(evt){
},onDropEnd:function(){
}});
dojo.dnd.DragEvent=function(){
this.dragSource=null;
this.dragObject=null;
this.target=null;
this.eventStatus="success";
};
dojo.declare("dojo.dnd.DragManager",null,{selectedSources:[],dragObjects:[],dragSources:[],registerDragSource:function(_7e2){
},dropTargets:[],registerDropTarget:function(_7e3){
},lastDragTarget:null,currentDragTarget:null,onKeyDown:function(){
},onMouseOut:function(){
},onMouseMove:function(){
},onMouseUp:function(){
}});
dojo.provide("dojo.dnd.HtmlDragManager");
dojo.declare("dojo.dnd.HtmlDragManager",dojo.dnd.DragManager,{disabled:false,nestedTargets:false,mouseDownTimer:null,dsCounter:0,dsPrefix:"dojoDragSource",dropTargetDimensions:[],currentDropTarget:null,previousDropTarget:null,_dragTriggered:false,selectedSources:[],dragObjects:[],dragSources:[],dropTargets:[],currentX:null,currentY:null,lastX:null,lastY:null,mouseDownX:null,mouseDownY:null,threshold:7,dropAcceptable:false,cancelEvent:function(e){
e.stopPropagation();
e.preventDefault();
},registerDragSource:function(ds){
if(ds["domNode"]){
var dp=this.dsPrefix;
var _7e7=dp+"Idx_"+(this.dsCounter++);
ds.dragSourceId=_7e7;
this.dragSources[_7e7]=ds;
ds.domNode.setAttribute(dp,_7e7);
if(dojo.render.html.ie){
dojo.event.browser.addListener(ds.domNode,"ondragstart",this.cancelEvent);
}
}
},unregisterDragSource:function(ds){
if(ds["domNode"]){
var dp=this.dsPrefix;
var _7ea=ds.dragSourceId;
delete ds.dragSourceId;
delete this.dragSources[_7ea];
ds.domNode.setAttribute(dp,null);
if(dojo.render.html.ie){
dojo.event.browser.removeListener(ds.domNode,"ondragstart",this.cancelEvent);
}
}
},registerDropTarget:function(dt){
this.dropTargets.push(dt);
},unregisterDropTarget:function(dt){
var _7ed=dojo.lang.find(this.dropTargets,dt,true);
if(_7ed>=0){
this.dropTargets.splice(_7ed,1);
}
},getDragSource:function(e){
var tn=e.target;
if(tn===dojo.body()){
return;
}
var ta=dojo.html.getAttribute(tn,this.dsPrefix);
while((!ta)&&(tn)){
tn=tn.parentNode;
if((!tn)||(tn===dojo.body())){
return;
}
ta=dojo.html.getAttribute(tn,this.dsPrefix);
}
return this.dragSources[ta];
},onKeyDown:function(e){
},onMouseDown:function(e){
if(this.disabled){
return;
}
if(dojo.render.html.ie){
if(e.button!=1){
return;
}
}else{
if(e.which!=1){
return;
}
}
var _7f3=e.target.nodeType==dojo.html.TEXT_NODE?e.target.parentNode:e.target;
if(dojo.html.isTag(_7f3,"button","textarea","input","select","option")){
return;
}
var ds=this.getDragSource(e);
if(!ds){
return;
}
if(!dojo.lang.inArray(this.selectedSources,ds)){
this.selectedSources.push(ds);
ds.onSelected();
}
this.mouseDownX=e.pageX;
this.mouseDownY=e.pageY;
e.preventDefault();
dojo.event.connect(document,"onmousemove",this,"onMouseMove");
},onMouseUp:function(e,_7f6){
if(this.selectedSources.length==0){
return;
}
this.mouseDownX=null;
this.mouseDownY=null;
this._dragTriggered=false;
e.dragSource=this.dragSource;
if((!e.shiftKey)&&(!e.ctrlKey)){
if(this.currentDropTarget){
this.currentDropTarget.onDropStart();
}
dojo.lang.forEach(this.dragObjects,function(_7f7){
var ret=null;
if(!_7f7){
return;
}
if(this.currentDropTarget){
e.dragObject=_7f7;
var ce=this.currentDropTarget.domNode.childNodes;
if(ce.length>0){
e.dropTarget=ce[0];
while(e.dropTarget==_7f7.domNode){
e.dropTarget=e.dropTarget.nextSibling;
}
}else{
e.dropTarget=this.currentDropTarget.domNode;
}
if(this.dropAcceptable){
ret=this.currentDropTarget.onDrop(e);
}else{
this.currentDropTarget.onDragOut(e);
}
}
e.dragStatus=this.dropAcceptable&&ret?"dropSuccess":"dropFailure";
dojo.lang.delayThese([function(){
try{
_7f7.dragSource.onDragEnd(e);
}
catch(err){
var _7fa={};
for(var i in e){
if(i=="type"){
_7fa.type="mouseup";
continue;
}
_7fa[i]=e[i];
}
_7f7.dragSource.onDragEnd(_7fa);
}
},function(){
_7f7.onDragEnd(e);
}]);
},this);
this.selectedSources=[];
this.dragObjects=[];
this.dragSource=null;
if(this.currentDropTarget){
this.currentDropTarget.onDropEnd();
}
}else{
}
dojo.event.disconnect(document,"onmousemove",this,"onMouseMove");
this.currentDropTarget=null;
},onScroll:function(){
for(var i=0;i<this.dragObjects.length;i++){
if(this.dragObjects[i].updateDragOffset){
this.dragObjects[i].updateDragOffset();
}
}
if(this.dragObjects.length){
this.cacheTargetLocations();
}
},_dragStartDistance:function(x,y){
if((!this.mouseDownX)||(!this.mouseDownX)){
return;
}
var dx=Math.abs(x-this.mouseDownX);
var dx2=dx*dx;
var dy=Math.abs(y-this.mouseDownY);
var dy2=dy*dy;
return parseInt(Math.sqrt(dx2+dy2),10);
},cacheTargetLocations:function(){
dojo.profile.start("cacheTargetLocations");
this.dropTargetDimensions=[];
dojo.lang.forEach(this.dropTargets,function(_803){
var tn=_803.domNode;
if(!tn||!_803.accepts([this.dragSource])){
return;
}
var abs=dojo.html.getAbsolutePosition(tn,true);
var bb=dojo.html.getBorderBox(tn);
this.dropTargetDimensions.push([[abs.x,abs.y],[abs.x+bb.width,abs.y+bb.height],_803]);
},this);
dojo.profile.end("cacheTargetLocations");
},onMouseMove:function(e){
if((dojo.render.html.ie)&&(e.button!=1)){
this.currentDropTarget=null;
this.onMouseUp(e,true);
return;
}
if((this.selectedSources.length)&&(!this.dragObjects.length)){
var dx;
var dy;
if(!this._dragTriggered){
this._dragTriggered=(this._dragStartDistance(e.pageX,e.pageY)>this.threshold);
if(!this._dragTriggered){
return;
}
dx=e.pageX-this.mouseDownX;
dy=e.pageY-this.mouseDownY;
}
this.dragSource=this.selectedSources[0];
dojo.lang.forEach(this.selectedSources,function(_80a){
if(!_80a){
return;
}
var tdo=_80a.onDragStart(e);
if(tdo){
tdo.onDragStart(e);
tdo.dragOffset.y+=dy;
tdo.dragOffset.x+=dx;
tdo.dragSource=_80a;
this.dragObjects.push(tdo);
}
},this);
this.previousDropTarget=null;
this.cacheTargetLocations();
}
dojo.lang.forEach(this.dragObjects,function(_80c){
if(_80c){
_80c.onDragMove(e);
}
});
if(this.currentDropTarget){
var c=dojo.html.toCoordinateObject(this.currentDropTarget.domNode,true);
var dtp=[[c.x,c.y],[c.x+c.width,c.y+c.height]];
}
if((!this.nestedTargets)&&(dtp)&&(this.isInsideBox(e,dtp))){
if(this.dropAcceptable){
this.currentDropTarget.onDragMove(e,this.dragObjects);
}
}else{
var _80f=this.findBestTarget(e);
if(_80f.target===null){
if(this.currentDropTarget){
this.currentDropTarget.onDragOut(e);
this.previousDropTarget=this.currentDropTarget;
this.currentDropTarget=null;
}
this.dropAcceptable=false;
return;
}
if(this.currentDropTarget!==_80f.target){
if(this.currentDropTarget){
this.previousDropTarget=this.currentDropTarget;
this.currentDropTarget.onDragOut(e);
}
this.currentDropTarget=_80f.target;
e.dragObjects=this.dragObjects;
this.dropAcceptable=this.currentDropTarget.onDragOver(e);
}else{
if(this.dropAcceptable){
this.currentDropTarget.onDragMove(e,this.dragObjects);
}
}
}
},findBestTarget:function(e){
var _811=this;
var _812=new Object();
_812.target=null;
_812.points=null;
dojo.lang.every(this.dropTargetDimensions,function(_813){
if(!_811.isInsideBox(e,_813)){
return true;
}
_812.target=_813[2];
_812.points=_813;
return Boolean(_811.nestedTargets);
});
return _812;
},isInsideBox:function(e,_815){
if((e.pageX>_815[0][0])&&(e.pageX<_815[1][0])&&(e.pageY>_815[0][1])&&(e.pageY<_815[1][1])){
return true;
}
return false;
},onMouseOver:function(e){
},onMouseOut:function(e){
}});
dojo.dnd.dragManager=new dojo.dnd.HtmlDragManager();
(function(){
var d=document;
var dm=dojo.dnd.dragManager;
dojo.event.connect(d,"onkeydown",dm,"onKeyDown");
dojo.event.connect(d,"onmouseover",dm,"onMouseOver");
dojo.event.connect(d,"onmouseout",dm,"onMouseOut");
dojo.event.connect(d,"onmousedown",dm,"onMouseDown");
dojo.event.connect(d,"onmouseup",dm,"onMouseUp");
dojo.event.connect(window,"onscroll",dm,"onScroll");
})();
dojo.provide("dojo.html.selection");
dojo.html.selectionType={NONE:0,TEXT:1,CONTROL:2};
dojo.html.clearSelection=function(){
var _81a=dojo.global();
var _81b=dojo.doc();
try{
if(_81a["getSelection"]){
if(dojo.render.html.safari){
_81a.getSelection().collapse();
}else{
_81a.getSelection().removeAllRanges();
}
}else{
if(_81b.selection){
if(_81b.selection.empty){
_81b.selection.empty();
}else{
if(_81b.selection.clear){
_81b.selection.clear();
}
}
}
}
return true;
}
catch(e){
dojo.debug(e);
return false;
}
};
dojo.html.disableSelection=function(_81c){
_81c=dojo.byId(_81c)||dojo.body();
var h=dojo.render.html;
if(h.mozilla){
_81c.style.MozUserSelect="none";
}else{
if(h.safari){
_81c.style.KhtmlUserSelect="none";
}else{
if(h.ie){
_81c.unselectable="on";
}else{
return false;
}
}
}
return true;
};
dojo.html.enableSelection=function(_81e){
_81e=dojo.byId(_81e)||dojo.body();
var h=dojo.render.html;
if(h.mozilla){
_81e.style.MozUserSelect="";
}else{
if(h.safari){
_81e.style.KhtmlUserSelect="";
}else{
if(h.ie){
_81e.unselectable="off";
}else{
return false;
}
}
}
return true;
};
dojo.html.selectInputText=function(_820){
var _821=dojo.global();
var _822=dojo.doc();
_820=dojo.byId(_820);
if(_822["selection"]&&dojo.body()["createTextRange"]){
var _823=_820.createTextRange();
_823.moveStart("character",0);
_823.moveEnd("character",_820.value.length);
_823.select();
}else{
if(_821["getSelection"]){
var _824=_821.getSelection();
_820.setSelectionRange(0,_820.value.length);
}
}
_820.focus();
};
dojo.lang.mixin(dojo.html.selection,{getType:function(){
if(dojo.doc()["selection"]){
return dojo.html.selectionType[dojo.doc().selection.type.toUpperCase()];
}else{
var _825=dojo.html.selectionType.TEXT;
var oSel;
try{
oSel=dojo.global().getSelection();
}
catch(e){
}
if(oSel&&oSel.rangeCount==1){
var _827=oSel.getRangeAt(0);
if(_827.startContainer==_827.endContainer&&(_827.endOffset-_827.startOffset)==1&&_827.startContainer.nodeType!=dojo.dom.TEXT_NODE){
_825=dojo.html.selectionType.CONTROL;
}
}
return _825;
}
},isCollapsed:function(){
var _828=dojo.global();
var _829=dojo.doc();
if(_829["selection"]){
return _829.selection.createRange().text=="";
}else{
if(_828["getSelection"]){
var _82a=_828.getSelection();
if(dojo.lang.isString(_82a)){
return _82a=="";
}else{
return _82a.isCollapsed||_82a.toString()=="";
}
}
}
},getSelectedElement:function(){
if(dojo.html.selection.getType()==dojo.html.selectionType.CONTROL){
if(dojo.doc()["selection"]){
var _82b=dojo.doc().selection.createRange();
if(_82b&&_82b.item){
return dojo.doc().selection.createRange().item(0);
}
}else{
var _82c=dojo.global().getSelection();
return _82c.anchorNode.childNodes[_82c.anchorOffset];
}
}
},getParentElement:function(){
if(dojo.html.selection.getType()==dojo.html.selectionType.CONTROL){
var p=dojo.html.selection.getSelectedElement();
if(p){
return p.parentNode;
}
}else{
if(dojo.doc()["selection"]){
return dojo.doc().selection.createRange().parentElement();
}else{
var _82e=dojo.global().getSelection();
if(_82e){
var node=_82e.anchorNode;
while(node&&node.nodeType!=dojo.dom.ELEMENT_NODE){
node=node.parentNode;
}
return node;
}
}
}
},getSelectedText:function(){
if(dojo.doc()["selection"]){
if(dojo.html.selection.getType()==dojo.html.selectionType.CONTROL){
return null;
}
return dojo.doc().selection.createRange().text;
}else{
var _830=dojo.global().getSelection();
if(_830){
return _830.toString();
}
}
},getSelectedHtml:function(){
if(dojo.doc()["selection"]){
if(dojo.html.selection.getType()==dojo.html.selectionType.CONTROL){
return null;
}
return dojo.doc().selection.createRange().htmlText;
}else{
var _831=dojo.global().getSelection();
if(_831&&_831.rangeCount){
var frag=_831.getRangeAt(0).cloneContents();
var div=document.createElement("div");
div.appendChild(frag);
return div.innerHTML;
}
return null;
}
},hasAncestorElement:function(_834){
return (dojo.html.selection.getAncestorElement.apply(this,arguments)!=null);
},getAncestorElement:function(_835){
var node=dojo.html.selection.getSelectedElement()||dojo.html.selection.getParentElement();
return dojo.html.selection.getParentOfType(node,arguments);
},getParentOfType:function(node,tags){
while(node){
if(dojo.html.selection.isTag(node,tags).length>0){
return node;
}
node=node.parentNode;
}
return null;
},isTag:function(node,tags){
if(node&&node.tagName){
for(var i=0;i<tags.length;i++){
if(node.tagName.toLowerCase()==String(tags[i]).toLowerCase()){
return String(tags[i]).toLowerCase();
}
}
}
return "";
},selectElement:function(_83c){
var _83d=dojo.global();
var _83e=dojo.doc();
_83c=dojo.byId(_83c);
if(_83e.selection&&dojo.body().createTextRange){
try{
var _83f=dojo.body().createControlRange();
_83f.addElement(_83c);
_83f.select();
}
catch(e){
dojo.html.selection.selectElementChildren(_83c);
}
}else{
if(_83d["getSelection"]){
var _840=_83d.getSelection();
if(_840["removeAllRanges"]){
var _83f=_83e.createRange();
_83f.selectNode(_83c);
_840.removeAllRanges();
_840.addRange(_83f);
}
}
}
},selectElementChildren:function(_841){
var _842=dojo.global();
var _843=dojo.doc();
_841=dojo.byId(_841);
if(_843.selection&&dojo.body().createTextRange){
var _844=_841.ownerDocument.body.createTextRange();
_844.moveToElementText(_841);
_844.select();
}else{
if(_842["getSelection"]){
var _845=_842.getSelection();
if(_845["setBaseAndExtent"]){
_845.setBaseAndExtent(_841,0,_841,_841.innerText.length-1);
}else{
if(_845["selectAllChildren"]){
_845.selectAllChildren(_841);
}
}
}
}
},getBookmark:function(){
var _846;
var _847=dojo.doc();
if(_847["selection"]){
var _848=_847.selection.createRange();
if(_847.selection.type.toUpperCase()=="CONTROL"){
if(_848.length){
_846=[];
var i=0;
while(i<_848.length){
_846.push(_848.item(i++));
}
}else{
_846=null;
}
}else{
_846=_848.getBookmark();
}
}else{
var _84a;
try{
_84a=dojo.global().getSelection();
}
catch(e){
}
if(_84a){
var _848=_84a.getRangeAt(0);
_846=_848.cloneRange();
}else{
dojo.debug("No idea how to store the current selection for this browser!");
}
}
return _846;
},moveToBookmark:function(_84b){
var _84c=dojo.doc();
if(_84c["selection"]){
if(dojo.lang.isArray(_84b)){
var _84d=_84c.body.createControlRange();
var i=0;
while(i<_84b.length){
_84d.addElement(_84b[i++]);
}
_84d.select();
}else{
var _84d=_84c.selection.createRange();
_84d.moveToBookmark(_84b);
_84d.select();
}
}else{
var _84f;
try{
_84f=dojo.global().getSelection();
}
catch(e){
}
if(_84f&&_84f["removeAllRanges"]){
_84f.removeAllRanges();
_84f.addRange(_84b);
}else{
dojo.debug("No idea how to restore selection for this browser!");
}
}
},collapse:function(_850){
if(dojo.global()["getSelection"]){
var _851=dojo.global().getSelection();
if(_851.removeAllRanges){
if(_850){
_851.collapseToStart();
}else{
_851.collapseToEnd();
}
}else{
dojo.global().getSelection().collapse(_850);
}
}else{
if(dojo.doc().selection){
var _852=dojo.doc().selection.createRange();
_852.collapse(_850);
_852.select();
}
}
},remove:function(){
if(dojo.doc().selection){
var _853=dojo.doc().selection;
if(_853.type.toUpperCase()!="NONE"){
_853.clear();
}
return _853;
}else{
var _853=dojo.global().getSelection();
_853.deleteFromDocument();
return _853;
}
}});
dojo.provide("dojo.html.iframe");
dojo.html.iframeContentWindow=function(_854){
var win=dojo.html.getDocumentWindow(dojo.html.iframeContentDocument(_854))||dojo.html.iframeContentDocument(_854)["__parent__"]||(_854.name&&document.frames[_854.name])||null;
return win;
};
dojo.html.iframeContentDocument=function(_856){
var doc=_856.contentDocument||((_856.contentWindow)&&(_856.contentWindow.document))||((_856.name)&&(document.frames[_856.name])&&(document.frames[_856.name].document))||null;
return doc;
};
dojo.html.BackgroundIframe=function(node){
if(dojo.render.html.ie55||dojo.render.html.ie60){
var html="<iframe src='javascript:false'"+" style='position: absolute; left: 0px; top: 0px; width: 100%; height: 100%;"+"z-index: -1; filter:Alpha(Opacity=\"0\");' "+">";
this.iframe=dojo.doc().createElement(html);
this.iframe.tabIndex=-1;
if(node){
node.appendChild(this.iframe);
this.domNode=node;
}else{
dojo.body().appendChild(this.iframe);
this.iframe.style.display="none";
}
}
};
dojo.lang.extend(dojo.html.BackgroundIframe,{iframe:null,onResized:function(){
if(this.iframe&&this.domNode&&this.domNode.parentNode){
var _85a=dojo.html.getMarginBox(this.domNode);
if(_85a.width==0||_85a.height==0){
dojo.lang.setTimeout(this,this.onResized,100);
return;
}
this.iframe.style.width=_85a.width+"px";
this.iframe.style.height=_85a.height+"px";
}
},size:function(node){
if(!this.iframe){
return;
}
var _85c=dojo.html.toCoordinateObject(node,true,dojo.html.boxSizing.BORDER_BOX);
with(this.iframe.style){
width=_85c.width+"px";
height=_85c.height+"px";
left=_85c.left+"px";
top=_85c.top+"px";
}
},setZIndex:function(node){
if(!this.iframe){
return;
}
if(dojo.dom.isNode(node)){
this.iframe.style.zIndex=dojo.html.getStyle(node,"z-index")-1;
}else{
if(!isNaN(node)){
this.iframe.style.zIndex=node;
}
}
},show:function(){
if(this.iframe){
this.iframe.style.display="block";
}
},hide:function(){
if(this.iframe){
this.iframe.style.display="none";
}
},remove:function(){
if(this.iframe){
dojo.html.removeNode(this.iframe,true);
delete this.iframe;
this.iframe=null;
}
}});
dojo.provide("dojo.dnd.HtmlDragAndDrop");
dojo.declare("dojo.dnd.HtmlDragSource",dojo.dnd.DragSource,function(node,type){
node=dojo.byId(node);
this.dragObjects=[];
this.constrainToContainer=false;
if(node){
this.domNode=node;
this.dragObject=node;
this.type=(type)||(this.domNode.nodeName.toLowerCase());
dojo.dnd.DragSource.prototype.reregister.call(this);
}
},{dragClass:"",onDragStart:function(){
var _860=new dojo.dnd.HtmlDragObject(this.dragObject,this.type);
if(this.dragClass){
_860.dragClass=this.dragClass;
}
if(this.constrainToContainer){
_860.constrainTo(this.constrainingContainer||this.domNode.parentNode);
}
return _860;
},setDragHandle:function(node){
node=dojo.byId(node);
dojo.dnd.dragManager.unregisterDragSource(this);
this.domNode=node;
dojo.dnd.dragManager.registerDragSource(this);
},setDragTarget:function(node){
this.dragObject=node;
},constrainTo:function(_863){
this.constrainToContainer=true;
if(_863){
this.constrainingContainer=_863;
}
},onSelected:function(){
for(var i=0;i<this.dragObjects.length;i++){
dojo.dnd.dragManager.selectedSources.push(new dojo.dnd.HtmlDragSource(this.dragObjects[i]));
}
},addDragObjects:function(el){
for(var i=0;i<arguments.length;i++){
this.dragObjects.push(dojo.byId(arguments[i]));
}
}});
dojo.declare("dojo.dnd.HtmlDragObject",dojo.dnd.DragObject,function(node,type){
this.domNode=dojo.byId(node);
this.type=type;
this.constrainToContainer=false;
this.dragSource=null;
dojo.dnd.DragObject.prototype.register.call(this);
},{dragClass:"",opacity:0.5,createIframe:true,disableX:false,disableY:false,createDragNode:function(){
var node=this.domNode.cloneNode(true);
if(this.dragClass){
dojo.html.addClass(node,this.dragClass);
}
if(this.opacity<1){
dojo.html.setOpacity(node,this.opacity);
}
var ltn=node.tagName.toLowerCase();
var isTr=(ltn=="tr");
if((isTr)||(ltn=="tbody")){
var doc=this.domNode.ownerDocument;
var _86d=doc.createElement("table");
if(isTr){
var _86e=doc.createElement("tbody");
_86d.appendChild(_86e);
_86e.appendChild(node);
}else{
_86d.appendChild(node);
}
var _86f=((isTr)?this.domNode:this.domNode.firstChild);
var _870=((isTr)?node:node.firstChild);
var _871=_86f.childNodes;
var _872=_870.childNodes;
for(var i=0;i<_871.length;i++){
if((_872[i])&&(_872[i].style)){
_872[i].style.width=dojo.html.getContentBox(_871[i]).width+"px";
}
}
node=_86d;
}
if((dojo.render.html.ie55||dojo.render.html.ie60)&&this.createIframe){
with(node.style){
top="0px";
left="0px";
}
var _874=document.createElement("div");
_874.appendChild(node);
this.bgIframe=new dojo.html.BackgroundIframe(_874);
_874.appendChild(this.bgIframe.iframe);
node=_874;
}
node.style.zIndex=999;
return node;
},onDragStart:function(e){
dojo.html.clearSelection();
this.scrollOffset=dojo.html.getScroll().offset;
this.dragStartPosition=dojo.html.getAbsolutePosition(this.domNode,true);
this.dragOffset={y:this.dragStartPosition.y-e.pageY,x:this.dragStartPosition.x-e.pageX};
this.dragClone=this.createDragNode();
this.containingBlockPosition=this.domNode.offsetParent?dojo.html.getAbsolutePosition(this.domNode.offsetParent,true):{x:0,y:0};
if(this.constrainToContainer){
this.constraints=this.getConstraints();
}
with(this.dragClone.style){
position="absolute";
top=this.dragOffset.y+e.pageY+"px";
left=this.dragOffset.x+e.pageX+"px";
}
dojo.body().appendChild(this.dragClone);
dojo.event.topic.publish("dragStart",{source:this});
},getConstraints:function(){
if(this.constrainingContainer.nodeName.toLowerCase()=="body"){
var _876=dojo.html.getViewport();
var _877=_876.width;
var _878=_876.height;
var _879=dojo.html.getScroll().offset;
var x=_879.x;
var y=_879.y;
}else{
var _87c=dojo.html.getContentBox(this.constrainingContainer);
_877=_87c.width;
_878=_87c.height;
x=this.containingBlockPosition.x+dojo.html.getPixelValue(this.constrainingContainer,"padding-left",true)+dojo.html.getBorderExtent(this.constrainingContainer,"left");
y=this.containingBlockPosition.y+dojo.html.getPixelValue(this.constrainingContainer,"padding-top",true)+dojo.html.getBorderExtent(this.constrainingContainer,"top");
}
var mb=dojo.html.getMarginBox(this.domNode);
return {minX:x,minY:y,maxX:x+_877-mb.width,maxY:y+_878-mb.height};
},updateDragOffset:function(){
var _87e=dojo.html.getScroll().offset;
if(_87e.y!=this.scrollOffset.y){
var diff=_87e.y-this.scrollOffset.y;
this.dragOffset.y+=diff;
this.scrollOffset.y=_87e.y;
}
if(_87e.x!=this.scrollOffset.x){
var diff=_87e.x-this.scrollOffset.x;
this.dragOffset.x+=diff;
this.scrollOffset.x=_87e.x;
}
},onDragMove:function(e){
this.updateDragOffset();
var x=this.dragOffset.x+e.pageX;
var y=this.dragOffset.y+e.pageY;
if(this.constrainToContainer){
if(x<this.constraints.minX){
x=this.constraints.minX;
}
if(y<this.constraints.minY){
y=this.constraints.minY;
}
if(x>this.constraints.maxX){
x=this.constraints.maxX;
}
if(y>this.constraints.maxY){
y=this.constraints.maxY;
}
}
this.setAbsolutePosition(x,y);
dojo.event.topic.publish("dragMove",{source:this});
},setAbsolutePosition:function(x,y){
if(!this.disableY){
this.dragClone.style.top=y+"px";
}
if(!this.disableX){
this.dragClone.style.left=x+"px";
}
},onDragEnd:function(e){
switch(e.dragStatus){
case "dropSuccess":
dojo.html.removeNode(this.dragClone);
this.dragClone=null;
break;
case "dropFailure":
var _886=dojo.html.getAbsolutePosition(this.dragClone,true);
var _887={left:this.dragStartPosition.x+1,top:this.dragStartPosition.y+1};
var anim=dojo.lfx.slideTo(this.dragClone,_887,300);
var _889=this;
dojo.event.connect(anim,"onEnd",function(e){
dojo.html.removeNode(_889.dragClone);
_889.dragClone=null;
});
anim.play();
break;
}
dojo.event.topic.publish("dragEnd",{source:this});
},constrainTo:function(_88b){
this.constrainToContainer=true;
if(_88b){
this.constrainingContainer=_88b;
}else{
this.constrainingContainer=this.domNode.parentNode;
}
}});
dojo.declare("dojo.dnd.HtmlDropTarget",dojo.dnd.DropTarget,function(node,_88d){
if(arguments.length==0){
return;
}
this.domNode=dojo.byId(node);
dojo.dnd.DropTarget.call(this);
if(_88d&&dojo.lang.isString(_88d)){
_88d=[_88d];
}
this.acceptedTypes=_88d||[];
dojo.dnd.dragManager.registerDropTarget(this);
},{vertical:false,onDragOver:function(e){
if(!this.accepts(e.dragObjects)){
return false;
}
this.childBoxes=[];
for(var i=0,_890;i<this.domNode.childNodes.length;i++){
_890=this.domNode.childNodes[i];
if(_890.nodeType!=dojo.html.ELEMENT_NODE){
continue;
}
var pos=dojo.html.getAbsolutePosition(_890,true);
var _892=dojo.html.getBorderBox(_890);
this.childBoxes.push({top:pos.y,bottom:pos.y+_892.height,left:pos.x,right:pos.x+_892.width,height:_892.height,width:_892.width,node:_890});
}
return true;
},_getNodeUnderMouse:function(e){
for(var i=0,_895;i<this.childBoxes.length;i++){
with(this.childBoxes[i]){
if(e.pageX>=left&&e.pageX<=right&&e.pageY>=top&&e.pageY<=bottom){
return i;
}
}
}
return -1;
},createDropIndicator:function(){
this.dropIndicator=document.createElement("div");
with(this.dropIndicator.style){
position="absolute";
zIndex=999;
if(this.vertical){
borderLeftWidth="1px";
borderLeftColor="black";
borderLeftStyle="solid";
height=dojo.html.getBorderBox(this.domNode).height+"px";
top=dojo.html.getAbsolutePosition(this.domNode,true).y+"px";
}else{
borderTopWidth="1px";
borderTopColor="black";
borderTopStyle="solid";
width=dojo.html.getBorderBox(this.domNode).width+"px";
left=dojo.html.getAbsolutePosition(this.domNode,true).x+"px";
}
}
},onDragMove:function(e,_897){
var i=this._getNodeUnderMouse(e);
if(!this.dropIndicator){
this.createDropIndicator();
}
var _899=this.vertical?dojo.html.gravity.WEST:dojo.html.gravity.NORTH;
var hide=false;
if(i<0){
if(this.childBoxes.length){
var _89b=(dojo.html.gravity(this.childBoxes[0].node,e)&_899);
if(_89b){
hide=true;
}
}else{
var _89b=true;
}
}else{
var _89c=this.childBoxes[i];
var _89b=(dojo.html.gravity(_89c.node,e)&_899);
if(_89c.node===_897[0].dragSource.domNode){
hide=true;
}else{
var _89d=_89b?(i>0?this.childBoxes[i-1]:_89c):(i<this.childBoxes.length-1?this.childBoxes[i+1]:_89c);
if(_89d.node===_897[0].dragSource.domNode){
hide=true;
}
}
}
if(hide){
this.dropIndicator.style.display="none";
return;
}else{
this.dropIndicator.style.display="";
}
this.placeIndicator(e,_897,i,_89b);
if(!dojo.html.hasParent(this.dropIndicator)){
dojo.body().appendChild(this.dropIndicator);
}
},placeIndicator:function(e,_89f,_8a0,_8a1){
var _8a2=this.vertical?"left":"top";
var _8a3;
if(_8a0<0){
if(this.childBoxes.length){
_8a3=_8a1?this.childBoxes[0]:this.childBoxes[this.childBoxes.length-1];
}else{
this.dropIndicator.style[_8a2]=dojo.html.getAbsolutePosition(this.domNode,true)[this.vertical?"x":"y"]+"px";
}
}else{
_8a3=this.childBoxes[_8a0];
}
if(_8a3){
this.dropIndicator.style[_8a2]=(_8a1?_8a3[_8a2]:_8a3[this.vertical?"right":"bottom"])+"px";
if(this.vertical){
this.dropIndicator.style.height=_8a3.height+"px";
this.dropIndicator.style.top=_8a3.top+"px";
}else{
this.dropIndicator.style.width=_8a3.width+"px";
this.dropIndicator.style.left=_8a3.left+"px";
}
}
},onDragOut:function(e){
if(this.dropIndicator){
dojo.html.removeNode(this.dropIndicator);
delete this.dropIndicator;
}
},onDrop:function(e){
this.onDragOut(e);
var i=this._getNodeUnderMouse(e);
var _8a7=this.vertical?dojo.html.gravity.WEST:dojo.html.gravity.NORTH;
if(i<0){
if(this.childBoxes.length){
if(dojo.html.gravity(this.childBoxes[0].node,e)&_8a7){
return this.insert(e,this.childBoxes[0].node,"before");
}else{
return this.insert(e,this.childBoxes[this.childBoxes.length-1].node,"after");
}
}
return this.insert(e,this.domNode,"append");
}
var _8a8=this.childBoxes[i];
if(dojo.html.gravity(_8a8.node,e)&_8a7){
return this.insert(e,_8a8.node,"before");
}else{
return this.insert(e,_8a8.node,"after");
}
},insert:function(e,_8aa,_8ab){
var node=e.dragObject.domNode;
if(_8ab=="before"){
return dojo.html.insertBefore(node,_8aa);
}else{
if(_8ab=="after"){
return dojo.html.insertAfter(node,_8aa);
}else{
if(_8ab=="append"){
_8aa.appendChild(node);
return true;
}
}
}
return false;
}});
dojo.kwCompoundRequire({common:["dojo.dnd.DragAndDrop"],browser:["dojo.dnd.HtmlDragAndDrop"],dashboard:["dojo.dnd.HtmlDragAndDrop"]});
dojo.provide("dojo.dnd.*");
dojo.provide("dojo.ns");
dojo.ns={namespaces:{},failed:{},loading:{},loaded:{},register:function(name,_8ae,_8af,_8b0){
if(!_8b0||!this.namespaces[name]){
this.namespaces[name]=new dojo.ns.Ns(name,_8ae,_8af);
}
},allow:function(name){
if(this.failed[name]){
return false;
}
if((djConfig.excludeNamespace)&&(dojo.lang.inArray(djConfig.excludeNamespace,name))){
return false;
}
return ((name==this.dojo)||(!djConfig.includeNamespace)||(dojo.lang.inArray(djConfig.includeNamespace,name)));
},get:function(name){
return this.namespaces[name];
},require:function(name){
var ns=this.namespaces[name];
if((ns)&&(this.loaded[name])){
return ns;
}
if(!this.allow(name)){
return false;
}
if(this.loading[name]){
dojo.debug("dojo.namespace.require: re-entrant request to load namespace \""+name+"\" must fail.");
return false;
}
var req=dojo.require;
this.loading[name]=true;
try{
if(name=="dojo"){
req("dojo.namespaces.dojo");
}else{
if(!dojo.hostenv.moduleHasPrefix(name)){
dojo.registerModulePath(name,"../"+name);
}
req([name,"manifest"].join("."),false,true);
}
if(!this.namespaces[name]){
this.failed[name]=true;
}
}
finally{
this.loading[name]=false;
}
return this.namespaces[name];
}};
dojo.ns.Ns=function(name,_8b7,_8b8){
this.name=name;
this.module=_8b7;
this.resolver=_8b8;
this._loaded=[];
this._failed=[];
};
dojo.ns.Ns.prototype.resolve=function(name,_8ba,_8bb){
if(!this.resolver||djConfig["skipAutoRequire"]){
return false;
}
var _8bc=this.resolver(name,_8ba);
if((_8bc)&&(!this._loaded[_8bc])&&(!this._failed[_8bc])){
var req=dojo.require;
req(_8bc,false,true);
if(dojo.hostenv.findModule(_8bc,false)){
this._loaded[_8bc]=true;
}else{
if(!_8bb){
dojo.raise("dojo.ns.Ns.resolve: module '"+_8bc+"' not found after loading via namespace '"+this.name+"'");
}
this._failed[_8bc]=true;
}
}
return Boolean(this._loaded[_8bc]);
};
dojo.registerNamespace=function(name,_8bf,_8c0){
dojo.ns.register.apply(dojo.ns,arguments);
};
dojo.registerNamespaceResolver=function(name,_8c2){
var n=dojo.ns.namespaces[name];
if(n){
n.resolver=_8c2;
}
};
dojo.registerNamespaceManifest=function(_8c4,path,name,_8c7,_8c8){
dojo.registerModulePath(name,path);
dojo.registerNamespace(name,_8c7,_8c8);
};
dojo.registerNamespace("dojo","dojo.widget");
dojo.provide("dojo.widget.Manager");
dojo.widget.manager=new function(){
this.widgets=[];
this.widgetIds=[];
this.topWidgets={};
var _8c9={};
var _8ca=[];
this.getUniqueId=function(_8cb){
var _8cc;
do{
_8cc=_8cb+"_"+(_8c9[_8cb]!=undefined?++_8c9[_8cb]:_8c9[_8cb]=0);
}while(this.getWidgetById(_8cc));
return _8cc;
};
this.add=function(_8cd){
this.widgets.push(_8cd);
if(!_8cd.extraArgs["id"]){
_8cd.extraArgs["id"]=_8cd.extraArgs["ID"];
}
if(_8cd.widgetId==""){
if(_8cd["id"]){
_8cd.widgetId=_8cd["id"];
}else{
if(_8cd.extraArgs["id"]){
_8cd.widgetId=_8cd.extraArgs["id"];
}else{
_8cd.widgetId=this.getUniqueId(_8cd.ns+"_"+_8cd.widgetType);
}
}
}
if(this.widgetIds[_8cd.widgetId]){
dojo.debug("widget ID collision on ID: "+_8cd.widgetId);
}
this.widgetIds[_8cd.widgetId]=_8cd;
};
this.destroyAll=function(){
for(var x=this.widgets.length-1;x>=0;x--){
try{
this.widgets[x].destroy(true);
delete this.widgets[x];
}
catch(e){
}
}
};
this.remove=function(_8cf){
if(dojo.lang.isNumber(_8cf)){
var tw=this.widgets[_8cf].widgetId;
delete this.topWidgets[tw];
delete this.widgetIds[tw];
this.widgets.splice(_8cf,1);
}else{
this.removeById(_8cf);
}
};
this.removeById=function(id){
if(!dojo.lang.isString(id)){
id=id["widgetId"];
if(!id){
dojo.debug("invalid widget or id passed to removeById");
return;
}
}
for(var i=0;i<this.widgets.length;i++){
if(this.widgets[i].widgetId==id){
this.remove(i);
break;
}
}
};
this.getWidgetById=function(id){
if(dojo.lang.isString(id)){
return this.widgetIds[id];
}
return id;
};
this.getWidgetsByType=function(type){
var lt=type.toLowerCase();
var _8d6=(type.indexOf(":")<0?function(x){
return x.widgetType.toLowerCase();
}:function(x){
return x.getNamespacedType();
});
var ret=[];
dojo.lang.forEach(this.widgets,function(x){
if(_8d6(x)==lt){
ret.push(x);
}
});
return ret;
};
this.getWidgetsByFilter=function(_8db,_8dc){
var ret=[];
dojo.lang.every(this.widgets,function(x){
if(_8db(x)){
ret.push(x);
if(_8dc){
return false;
}
}
return true;
});
return (_8dc?ret[0]:ret);
};
this.getAllWidgets=function(){
return this.widgets.concat();
};
this.getWidgetByNode=function(node){
var w=this.getAllWidgets();
node=dojo.byId(node);
for(var i=0;i<w.length;i++){
if(w[i].domNode==node){
return w[i];
}
}
return null;
};
this.byId=this.getWidgetById;
this.byType=this.getWidgetsByType;
this.byFilter=this.getWidgetsByFilter;
this.byNode=this.getWidgetByNode;
var _8e2={};
var _8e3=["dojo.widget"];
for(var i=0;i<_8e3.length;i++){
_8e3[_8e3[i]]=true;
}
this.registerWidgetPackage=function(_8e5){
if(!_8e3[_8e5]){
_8e3[_8e5]=true;
_8e3.push(_8e5);
}
};
this.getWidgetPackageList=function(){
return dojo.lang.map(_8e3,function(elt){
return (elt!==true?elt:undefined);
});
};
this.getImplementation=function(_8e7,_8e8,_8e9,ns){
var impl=this.getImplementationName(_8e7,ns);
if(impl){
var ret=_8e8?new impl(_8e8):new impl();
return ret;
}
};
function buildPrefixCache(){
for(var _8ed in dojo.render){
if(dojo.render[_8ed]["capable"]===true){
var _8ee=dojo.render[_8ed].prefixes;
for(var i=0;i<_8ee.length;i++){
_8ca.push(_8ee[i].toLowerCase());
}
}
}
}
var _8f0=function(_8f1,_8f2){
if(!_8f2){
return null;
}
for(var i=0,l=_8ca.length,_8f5;i<=l;i++){
_8f5=(i<l?_8f2[_8ca[i]]:_8f2);
if(!_8f5){
continue;
}
for(var name in _8f5){
if(name.toLowerCase()==_8f1){
return _8f5[name];
}
}
}
return null;
};
var _8f7=function(_8f8,_8f9){
var _8fa=dojo.getObject(_8f9,false);
return (_8fa?_8f0(_8f8,_8fa):null);
};
this.getImplementationName=function(_8fb,ns){
var _8fd=_8fb.toLowerCase();
ns=ns||"dojo";
var imps=_8e2[ns]||(_8e2[ns]={});
var impl=imps[_8fd];
if(impl){
return impl;
}
if(!_8ca.length){
buildPrefixCache();
}
var _900=dojo.ns.get(ns);
if(!_900){
dojo.ns.register(ns,ns+".widget");
_900=dojo.ns.get(ns);
}
if(_900){
_900.resolve(_8fb);
}
impl=_8f7(_8fd,_900.module);
if(impl){
return (imps[_8fd]=impl);
}
_900=dojo.ns.require(ns);
if((_900)&&(_900.resolver)){
_900.resolve(_8fb);
impl=_8f7(_8fd,_900.module);
if(impl){
return (imps[_8fd]=impl);
}
}
throw new Error("Could not locate widget implementation for \""+_8fb+"\" in \""+_900.module+"\" registered to namespace \""+_900.name+"\"");
};
this.resizing=false;
this.onWindowResized=function(){
if(this.resizing){
return;
}
try{
this.resizing=true;
for(var id in this.topWidgets){
var _902=this.topWidgets[id];
if(_902.checkSize){
_902.checkSize();
}
}
}
catch(e){
}
finally{
this.resizing=false;
}
};
if(typeof window!="undefined"){
dojo.addOnLoad(this,"onWindowResized");
dojo.event.connect(window,"onresize",this,"onWindowResized");
}
};
(function(){
var dw=dojo.widget;
var dwm=dw.manager;
var h=dojo.lang.curry(dojo.lang,"hitch",dwm);
var g=function(_907,_908){
dw[(_908||_907)]=h(_907);
};
g("add","addWidget");
g("destroyAll","destroyAllWidgets");
g("remove","removeWidget");
g("removeById","removeWidgetById");
g("getWidgetById");
g("getWidgetById","byId");
g("getWidgetsByType");
g("getWidgetsByFilter");
g("getWidgetsByType","byType");
g("getWidgetsByFilter","byFilter");
g("getWidgetByNode","byNode");
dw.all=function(n){
var _90a=dwm.getAllWidgets.apply(dwm,arguments);
if(arguments.length>0){
return _90a[n];
}
return _90a;
};
g("registerWidgetPackage");
g("getImplementation","getWidgetImplementation");
g("getImplementationName","getWidgetImplementationName");
dw.widgets=dwm.widgets;
dw.widgetIds=dwm.widgetIds;
dw.root=dwm.root;
})();
dojo.provide("dojo.a11y");
dojo.a11y={imgPath:dojo.uri.moduleUri("dojo.widget","templates/images"),doAccessibleCheck:true,accessible:null,checkAccessible:function(){
if(this.accessible===null){
this.accessible=false;
if(this.doAccessibleCheck==true){
this.accessible=this.testAccessible();
}
}
return this.accessible;
},testAccessible:function(){
this.accessible=false;
if(dojo.render.html.ie||dojo.render.html.mozilla){
var div=document.createElement("div");
div.style.backgroundImage="url(\""+this.imgPath+"/tab_close.gif\")";
dojo.body().appendChild(div);
var _90c=null;
if(window.getComputedStyle){
var _90d=getComputedStyle(div,"");
_90c=_90d.getPropertyValue("background-image");
}else{
_90c=div.currentStyle.backgroundImage;
}
var _90e=false;
if(_90c!=null&&(_90c=="none"||_90c=="url(invalid-url:)")){
this.accessible=true;
}
dojo.body().removeChild(div);
}
return this.accessible;
},setAccessible:function(_90f){
this.accessible=_90f;
},setCheckAccessible:function(_910){
this.doAccessibleCheck=_910;
},setAccessibleMode:function(){
if(this.accessible===null){
if(this.checkAccessible()){
dojo.render.html.prefixes.unshift("a11y");
}
}
return this.accessible;
}};
dojo.provide("dojo.widget.Widget");
dojo.declare("dojo.widget.Widget",null,function(){
this.children=[];
this.extraArgs={};
},{parent:null,isTopLevel:false,disabled:false,isContainer:false,widgetId:"",widgetType:"Widget",ns:"dojo",getNamespacedType:function(){
return (this.ns?this.ns+":"+this.widgetType:this.widgetType).toLowerCase();
},toString:function(){
return "[Widget "+this.getNamespacedType()+", "+(this.widgetId||"NO ID")+"]";
},repr:function(){
return this.toString();
},enable:function(){
this.disabled=false;
},disable:function(){
this.disabled=true;
},onResized:function(){
this.notifyChildrenOfResize();
},notifyChildrenOfResize:function(){
for(var i=0;i<this.children.length;i++){
var _912=this.children[i];
if(_912.onResized){
_912.onResized();
}
}
},create:function(args,_914,_915,ns){
if(ns){
this.ns=ns;
}
this.satisfyPropertySets(args,_914,_915);
this.mixInProperties(args,_914,_915);
this.postMixInProperties(args,_914,_915);
dojo.widget.manager.add(this);
this.buildRendering(args,_914,_915);
this.initialize(args,_914,_915);
this.postInitialize(args,_914,_915);
this.postCreate(args,_914,_915);
return this;
},destroy:function(_917){
if(this.parent){
this.parent.removeChild(this);
}
this.destroyChildren();
this.uninitialize();
this.destroyRendering(_917);
dojo.widget.manager.removeById(this.widgetId);
},destroyChildren:function(){
var _918;
var i=0;
while(this.children.length>i){
_918=this.children[i];
if(_918 instanceof dojo.widget.Widget){
this.removeChild(_918);
_918.destroy();
continue;
}
i++;
}
},getChildrenOfType:function(type,_91b){
var ret=[];
var _91d=dojo.lang.isFunction(type);
if(!_91d){
type=type.toLowerCase();
}
for(var x=0;x<this.children.length;x++){
if(_91d){
if(this.children[x] instanceof type){
ret.push(this.children[x]);
}
}else{
if(this.children[x].widgetType.toLowerCase()==type){
ret.push(this.children[x]);
}
}
if(_91b){
ret=ret.concat(this.children[x].getChildrenOfType(type,_91b));
}
}
return ret;
},getDescendants:function(){
var _91f=[];
var _920=[this];
var elem;
while((elem=_920.pop())){
_91f.push(elem);
if(elem.children){
dojo.lang.forEach(elem.children,function(elem){
_920.push(elem);
});
}
}
return _91f;
},isFirstChild:function(){
return this===this.parent.children[0];
},isLastChild:function(){
return this===this.parent.children[this.parent.children.length-1];
},satisfyPropertySets:function(args){
return args;
},mixInProperties:function(args,frag){
if((args["fastMixIn"])||(frag["fastMixIn"])){
for(var x in args){
this[x]=args[x];
}
return;
}
var _927;
var _928=dojo.widget.lcArgsCache[this.widgetType];
if(_928==null){
_928={};
for(var y in this){
_928[((new String(y)).toLowerCase())]=y;
}
dojo.widget.lcArgsCache[this.widgetType]=_928;
}
var _92a={};
for(var x in args){
if(!this[x]){
var y=_928[(new String(x)).toLowerCase()];
if(y){
args[y]=args[x];
x=y;
}
}
if(_92a[x]){
continue;
}
_92a[x]=true;
if((typeof this[x])!=(typeof _927)){
if(typeof args[x]!="string"){
this[x]=args[x];
}else{
if(dojo.lang.isString(this[x])){
this[x]=args[x];
}else{
if(dojo.lang.isNumber(this[x])){
this[x]=new Number(args[x]);
}else{
if(dojo.lang.isBoolean(this[x])){
this[x]=(args[x].toLowerCase()=="false")?false:true;
}else{
if(dojo.lang.isFunction(this[x])){
if(args[x].search(/[^\w\.]+/i)==-1){
this[x]=dojo.getObject(args[x],false);
}else{
var tn=dojo.lang.nameAnonFunc(new Function(args[x]),this);
dojo.event.kwConnect({srcObj:this,srcFunc:x,adviceObj:this,adviceFunc:tn});
}
}else{
if(dojo.lang.isArray(this[x])){
this[x]=args[x].split(";");
}else{
if(this[x] instanceof Date){
this[x]=new Date(Number(args[x]));
}else{
if(typeof this[x]=="object"){
if(this[x] instanceof dojo.uri.Uri){
this[x]=dojo.uri.dojoUri(args[x]);
}else{
var _92c=args[x].split(";");
for(var y=0;y<_92c.length;y++){
var si=_92c[y].indexOf(":");
if((si!=-1)&&(_92c[y].length>si)){
this[x][_92c[y].substr(0,si).replace(/^\s+|\s+$/g,"")]=_92c[y].substr(si+1);
}
}
}
}else{
this[x]=args[x];
}
}
}
}
}
}
}
}
}else{
this.extraArgs[x.toLowerCase()]=args[x];
}
}
},postMixInProperties:function(args,frag,_930){
},initialize:function(args,frag,_933){
return false;
},postInitialize:function(args,frag,_936){
return false;
},postCreate:function(args,frag,_939){
return false;
},uninitialize:function(){
return false;
},buildRendering:function(args,frag,_93c){
dojo.unimplemented("dojo.widget.Widget.buildRendering, on "+this.toString()+", ");
return false;
},destroyRendering:function(){
dojo.unimplemented("dojo.widget.Widget.destroyRendering");
return false;
},addedTo:function(_93d){
},addChild:function(_93e){
dojo.unimplemented("dojo.widget.Widget.addChild");
return false;
},removeChild:function(_93f){
for(var x=0;x<this.children.length;x++){
if(this.children[x]===_93f){
this.children.splice(x,1);
_93f.parent=null;
break;
}
}
return _93f;
},getPreviousSibling:function(){
var idx=this.getParentIndex();
if(idx<=0){
return null;
}
return this.parent.children[idx-1];
},getSiblings:function(){
return this.parent.children;
},getParentIndex:function(){
return dojo.lang.indexOf(this.parent.children,this,true);
},getNextSibling:function(){
var idx=this.getParentIndex();
if(idx==this.parent.children.length-1){
return null;
}
if(idx<0){
return null;
}
return this.parent.children[idx+1];
}});
dojo.widget.lcArgsCache={};
dojo.widget.tags={};
dojo.widget.tags["dojo:propertyset"]=function(_943,_944,_945){
var _946=_944.parseProperties(_943["dojo:propertyset"]);
};
dojo.widget.tags["dojo:connect"]=function(_947,_948,_949){
var _94a=_948.parseProperties(_947["dojo:connect"]);
};
dojo.widget.buildWidgetFromParseTree=function(type,frag,_94d,_94e,_94f,_950){
dojo.a11y.setAccessibleMode();
var _951=type.split(":");
_951=(_951.length==2)?_951[1]:type;
var _952=_950||_94d.parseProperties(frag[frag["ns"]+":"+_951]);
var _953=dojo.widget.manager.getImplementation(_951,null,null,frag["ns"]);
if(!_953){
throw new Error("cannot find \""+type+"\" widget");
}else{
if(!_953.create){
throw new Error("\""+type+"\" widget object has no \"create\" method and does not appear to implement *Widget");
}
}
_952["dojoinsertionindex"]=_94f;
var ret=_953.create(_952,frag,_94e,frag["ns"]);
return ret;
};
dojo.widget.defineWidget=function(_955,_956,_957,init,_959){
if(dojo.lang.isString(arguments[3])){
dojo.widget._defineWidget(arguments[0],arguments[3],arguments[1],arguments[4],arguments[2]);
}else{
var args=[arguments[0]],p=3;
if(dojo.lang.isString(arguments[1])){
args.push(arguments[1],arguments[2]);
}else{
args.push("",arguments[1]);
p=2;
}
if(dojo.lang.isFunction(arguments[p])){
args.push(arguments[p],arguments[p+1]);
}else{
args.push(null,arguments[p]);
}
dojo.widget._defineWidget.apply(this,args);
}
};
dojo.widget.defineWidget.renderers="html|svg|vml";
dojo.widget._defineWidget=function(_95c,_95d,_95e,init,_960){
var _961=_95c.split(".");
var type=_961.pop();
var regx="\\.("+(_95d?_95d+"|":"")+dojo.widget.defineWidget.renderers+")\\.";
var r=_95c.search(new RegExp(regx));
_961=(r<0?_961.join("."):_95c.substr(0,r));
dojo.widget.manager.registerWidgetPackage(_961);
var pos=_961.indexOf(".");
var _966=(pos>-1)?_961.substring(0,pos):_961;
_960=(_960)||{};
_960.widgetType=type;
if((!init)&&(_960["classConstructor"])){
init=_960.classConstructor;
delete _960.classConstructor;
}
dojo.declare(_95c,_95e,init,_960);
};
dojo.provide("dojo.widget.Parse");
dojo.widget.Parse=function(_967){
this.propertySetsList=[];
this.fragment=_967;
this.createComponents=function(frag,_969){
var _96a=[];
var _96b=false;
try{
if(frag&&frag.tagName&&(frag!=frag.nodeRef)){
var _96c=dojo.widget.tags;
var tna=String(frag.tagName).split(";");
for(var x=0;x<tna.length;x++){
var ltn=tna[x].replace(/^\s+|\s+$/g,"").toLowerCase();
frag.tagName=ltn;
var ret;
if(_96c[ltn]){
_96b=true;
ret=_96c[ltn](frag,this,_969,frag.index);
_96a.push(ret);
}else{
if(ltn.indexOf(":")==-1){
ltn="dojo:"+ltn;
}
ret=dojo.widget.buildWidgetFromParseTree(ltn,frag,this,_969,frag.index);
if(ret){
_96b=true;
_96a.push(ret);
}
}
}
}
}
catch(e){
dojo.debug("dojo.widget.Parse: error:",e);
}
if(!_96b){
_96a=_96a.concat(this.createSubComponents(frag,_969));
}
return _96a;
};
this.createSubComponents=function(_971,_972){
var frag,_974=[];
for(var item in _971){
frag=_971[item];
if(frag&&typeof frag=="object"&&(frag!=_971.nodeRef)&&(frag!=_971.tagName)&&(item.indexOf("$")==-1)){
_974=_974.concat(this.createComponents(frag,_972));
}
}
return _974;
};
this.parsePropertySets=function(_976){
return [];
};
this.parseProperties=function(_977){
var _978={};
for(var item in _977){
if((_977[item]==_977.tagName)||(_977[item]==_977.nodeRef)){
}else{
var frag=_977[item];
if(frag.tagName&&dojo.widget.tags[frag.tagName.toLowerCase()]){
}else{
if(frag[0]&&frag[0].value!=""&&frag[0].value!=null){
try{
if(item.toLowerCase()=="dataprovider"){
var _97b=this;
this.getDataProvider(_97b,frag[0].value);
_978.dataProvider=this.dataProvider;
}
_978[item]=frag[0].value;
var _97c=this.parseProperties(frag);
for(var _97d in _97c){
_978[_97d]=_97c[_97d];
}
}
catch(e){
dojo.debug(e);
}
}
}
switch(item.toLowerCase()){
case "checked":
case "disabled":
if(typeof _978[item]!="boolean"){
_978[item]=true;
}
break;
}
}
}
return _978;
};
this.getDataProvider=function(_97e,_97f){
dojo.io.bind({url:_97f,load:function(type,_981){
if(type=="load"){
_97e.dataProvider=_981;
}
},mimetype:"text/javascript",sync:true});
};
this.getPropertySetById=function(_982){
for(var x=0;x<this.propertySetsList.length;x++){
if(_982==this.propertySetsList[x]["id"][0].value){
return this.propertySetsList[x];
}
}
return "";
};
this.getPropertySetsByType=function(_984){
var _985=[];
for(var x=0;x<this.propertySetsList.length;x++){
var cpl=this.propertySetsList[x];
var cpcc=cpl.componentClass||cpl.componentType||null;
var _989=this.propertySetsList[x]["id"][0].value;
if(cpcc&&(_989==cpcc[0].value)){
_985.push(cpl);
}
}
return _985;
};
this.getPropertySets=function(_98a){
var ppl="dojo:propertyproviderlist";
var _98c=[];
var _98d=_98a.tagName;
if(_98a[ppl]){
var _98e=_98a[ppl].value.split(" ");
for(var _98f in _98e){
if((_98f.indexOf("..")==-1)&&(_98f.indexOf("://")==-1)){
var _990=this.getPropertySetById(_98f);
if(_990!=""){
_98c.push(_990);
}
}else{
}
}
}
return this.getPropertySetsByType(_98d).concat(_98c);
};
this.createComponentFromScript=function(_991,_992,_993,ns){
_993.fastMixIn=true;
var ltn=(ns||"dojo")+":"+_992.toLowerCase();
if(dojo.widget.tags[ltn]){
return [dojo.widget.tags[ltn](_993,this,null,null,_993)];
}
return [dojo.widget.buildWidgetFromParseTree(ltn,_993,this,null,null,_993)];
};
};
dojo.widget._parser_collection={"dojo":new dojo.widget.Parse()};
dojo.widget.getParser=function(name){
if(!name){
name="dojo";
}
if(!this._parser_collection[name]){
this._parser_collection[name]=new dojo.widget.Parse();
}
return this._parser_collection[name];
};
dojo.widget.createWidget=function(name,_998,_999,_99a){
var _99b=false;
var _99c=(typeof name=="string");
if(_99c){
var pos=name.indexOf(":");
var ns=(pos>-1)?name.substring(0,pos):"dojo";
if(pos>-1){
name=name.substring(pos+1);
}
var _99f=name.toLowerCase();
var _9a0=ns+":"+_99f;
_99b=(dojo.byId(name)&&!dojo.widget.tags[_9a0]);
}
if((arguments.length==1)&&(_99b||!_99c)){
var xp=new dojo.xml.Parse();
var tn=_99b?dojo.byId(name):name;
return dojo.widget.getParser().createComponents(xp.parseElement(tn,null,true))[0];
}
function fromScript(_9a3,name,_9a5,ns){
_9a5[_9a0]={dojotype:[{value:_99f}],nodeRef:_9a3,fastMixIn:true};
_9a5.ns=ns;
return dojo.widget.getParser().createComponentFromScript(_9a3,name,_9a5,ns);
}
_998=_998||{};
var _9a7=false;
var tn=null;
var h=dojo.render.html.capable;
if(h){
tn=document.createElement("span");
}
if(!_999){
_9a7=true;
_999=tn;
if(h){
dojo.body().appendChild(_999);
}
}else{
if(_99a){
dojo.dom.insertAtPosition(tn,_999,_99a);
}else{
tn=_999;
}
}
var _9a9=fromScript(tn,name.toLowerCase(),_998,ns);
if((!_9a9)||(!_9a9[0])||(typeof _9a9[0].widgetType=="undefined")){
throw new Error("createWidget: Creation of \""+name+"\" widget failed.");
}
try{
if(_9a7&&_9a9[0].domNode.parentNode){
_9a9[0].domNode.parentNode.removeChild(_9a9[0].domNode);
}
}
catch(e){
dojo.debug(e);
}
return _9a9[0];
};
dojo.provide("dojo.widget.DomWidget");
dojo.widget._cssFiles={};
dojo.widget._cssStrings={};
dojo.widget._templateCache={};
dojo.widget.defaultStrings={dojoRoot:dojo.hostenv.getBaseScriptUri(),dojoWidgetModuleUri:dojo.uri.moduleUri("dojo.widget"),baseScriptUri:dojo.hostenv.getBaseScriptUri()};
dojo.widget.fillFromTemplateCache=function(obj,_9ab,_9ac,_9ad){
var _9ae=_9ab||obj.templatePath;
var _9af=dojo.widget._templateCache;
if(!_9ae&&!obj["widgetType"]){
do{
var _9b0="__dummyTemplate__"+dojo.widget._templateCache.dummyCount++;
}while(_9af[_9b0]);
obj.widgetType=_9b0;
}
var wt=_9ae?_9ae.toString():obj.widgetType;
var ts=_9af[wt];
if(!ts){
_9af[wt]={"string":null,"node":null};
if(_9ad){
ts={};
}else{
ts=_9af[wt];
}
}
if((!obj.templateString)&&(!_9ad)){
obj.templateString=_9ac||ts["string"];
}
if(obj.templateString){
obj.templateString=this._sanitizeTemplateString(obj.templateString);
}
if((!obj.templateNode)&&(!_9ad)){
obj.templateNode=ts["node"];
}
if((!obj.templateNode)&&(!obj.templateString)&&(_9ae)){
var _9b3=this._sanitizeTemplateString(dojo.hostenv.getText(_9ae));
obj.templateString=_9b3;
if(!_9ad){
_9af[wt]["string"]=_9b3;
}
}
if((!ts["string"])&&(!_9ad)){
ts.string=obj.templateString;
}
};
dojo.widget._sanitizeTemplateString=function(_9b4){
if(_9b4){
_9b4=_9b4.replace(/^\s*<\?xml(\s)+version=[\'\"](\d)*.(\d)*[\'\"](\s)*\?>/im,"");
var _9b5=_9b4.match(/<body[^>]*>\s*([\s\S]+)\s*<\/body>/im);
if(_9b5){
_9b4=_9b5[1];
}
}else{
_9b4="";
}
return _9b4;
};
dojo.widget._templateCache.dummyCount=0;
dojo.widget.attachProperties=["dojoAttachPoint","id"];
dojo.widget.eventAttachProperty="dojoAttachEvent";
dojo.widget.onBuildProperty="dojoOnBuild";
dojo.widget.waiNames=["waiRole","waiState"];
dojo.widget.wai={waiRole:{name:"waiRole","namespace":"http://www.w3.org/TR/xhtml2",alias:"x2",prefix:"wairole:"},waiState:{name:"waiState","namespace":"http://www.w3.org/2005/07/aaa",alias:"aaa",prefix:""},setAttr:function(node,ns,attr,_9b9){
if(dojo.render.html.ie){
node.setAttribute(this[ns].alias+":"+attr,this[ns].prefix+_9b9);
}else{
node.setAttributeNS(this[ns]["namespace"],attr,this[ns].prefix+_9b9);
}
},getAttr:function(node,ns,attr){
if(dojo.render.html.ie){
return node.getAttribute(this[ns].alias+":"+attr);
}else{
return node.getAttributeNS(this[ns]["namespace"],attr);
}
},removeAttr:function(node,ns,attr){
var _9c0=true;
if(dojo.render.html.ie){
_9c0=node.removeAttribute(this[ns].alias+":"+attr);
}else{
node.removeAttributeNS(this[ns]["namespace"],attr);
}
return _9c0;
}};
dojo.widget.attachTemplateNodes=function(_9c1,_9c2,_9c3){
var _9c4=dojo.dom.ELEMENT_NODE;
function trim(str){
return str.replace(/^\s+|\s+$/g,"");
}
if(!_9c1){
_9c1=_9c2.domNode;
}
if(_9c1.nodeType!=_9c4){
return;
}
var _9c6=_9c1.all||_9c1.getElementsByTagName("*");
var _9c7=_9c2;
for(var x=-1;x<_9c6.length;x++){
var _9c9=(x==-1)?_9c1:_9c6[x];
var _9ca=[];
if(!_9c2.widgetsInTemplate||!_9c9.getAttribute("dojoType")){
for(var y=0;y<this.attachProperties.length;y++){
var _9cc=_9c9.getAttribute(this.attachProperties[y]);
if(_9cc){
_9ca=_9cc.split(";");
for(var z=0;z<_9ca.length;z++){
if(dojo.lang.isArray(_9c2[_9ca[z]])){
_9c2[_9ca[z]].push(_9c9);
}else{
_9c2[_9ca[z]]=_9c9;
}
}
break;
}
}
var _9ce=_9c9.getAttribute(this.eventAttachProperty);
if(_9ce){
var evts=_9ce.split(";");
for(var y=0;y<evts.length;y++){
if((!evts[y])||(!evts[y].length)){
continue;
}
var _9d0=null;
var tevt=trim(evts[y]);
if(evts[y].indexOf(":")>=0){
var _9d2=tevt.split(":");
tevt=trim(_9d2[0]);
_9d0=trim(_9d2[1]);
}
if(!_9d0){
_9d0=tevt;
}
var tf=function(){
var ntf=new String(_9d0);
return function(evt){
if(_9c7[ntf]){
_9c7[ntf](dojo.event.browser.fixEvent(evt,this));
}
};
}();
dojo.event.browser.addListener(_9c9,tevt,tf,false,true);
}
}
for(var y=0;y<_9c3.length;y++){
var _9d6=_9c9.getAttribute(_9c3[y]);
if((_9d6)&&(_9d6.length)){
var _9d0=null;
var _9d7=_9c3[y].substr(4);
_9d0=trim(_9d6);
var _9d8=[_9d0];
if(_9d0.indexOf(";")>=0){
_9d8=dojo.lang.map(_9d0.split(";"),trim);
}
for(var z=0;z<_9d8.length;z++){
if(!_9d8[z].length){
continue;
}
var tf=function(){
var ntf=new String(_9d8[z]);
return function(evt){
if(_9c7[ntf]){
_9c7[ntf](dojo.event.browser.fixEvent(evt,this));
}
};
}();
dojo.event.browser.addListener(_9c9,_9d7,tf,false,true);
}
}
}
}
var _9db=_9c9.getAttribute(this.templateProperty);
if(_9db){
_9c2[_9db]=_9c9;
}
dojo.lang.forEach(dojo.widget.waiNames,function(name){
var wai=dojo.widget.wai[name];
var val=_9c9.getAttribute(wai.name);
if(val){
if(val.indexOf("-")==-1){
dojo.widget.wai.setAttr(_9c9,wai.name,"role",val);
}else{
var _9df=val.split("-");
dojo.widget.wai.setAttr(_9c9,wai.name,_9df[0],_9df[1]);
}
}
},this);
var _9e0=_9c9.getAttribute(this.onBuildProperty);
if(_9e0){
eval("var node = baseNode; var widget = targetObj; "+_9e0);
}
}
};
dojo.widget.getDojoEventsFromStr=function(str){
var re=/(dojoOn([a-z]+)(\s?))=/gi;
var evts=str?str.match(re)||[]:[];
var ret=[];
var lem={};
for(var x=0;x<evts.length;x++){
if(evts[x].length<1){
continue;
}
var cm=evts[x].replace(/\s/,"");
cm=(cm.slice(0,cm.length-1));
if(!lem[cm]){
lem[cm]=true;
ret.push(cm);
}
}
return ret;
};
dojo.declare("dojo.widget.DomWidget",dojo.widget.Widget,function(){
if((arguments.length>0)&&(typeof arguments[0]=="object")){
this.create(arguments[0]);
}
},{templateNode:null,templateString:null,templateCssString:null,preventClobber:false,domNode:null,containerNode:null,widgetsInTemplate:false,addChild:function(_9e8,_9e9,pos,ref,_9ec){
if(typeof _9ec=="undefined"){
_9ec=this.children.length;
}
this.addWidgetAsDirectChild(_9e8,_9e9,pos,ref,_9ec);
this.registerChild(_9e8,_9ec);
return _9e8;
},addWidgetAsDirectChild:function(_9ed,_9ee,pos,ref,_9f1){
if((!this.containerNode)&&(!_9ee)){
this.containerNode=this.domNode;
}
var cn=(_9ee)?_9ee:this.containerNode;
if(!pos){
pos="after";
}
if(!ref){
if(!cn){
cn=dojo.body();
}
ref=cn.lastChild;
}
if(!_9f1){
_9f1=0;
}
_9ed.domNode.setAttribute("dojoinsertionindex",_9f1);
if(!ref){
cn.appendChild(_9ed.domNode);
}else{
if(pos=="insertAtIndex"){
dojo.dom.insertAtIndex(_9ed.domNode,ref.parentNode,_9f1);
}else{
if((pos=="after")&&(ref===cn.lastChild)){
cn.appendChild(_9ed.domNode);
}else{
dojo.dom.insertAtPosition(_9ed.domNode,ref,pos);
}
}
}
},registerChild:function(_9f3,_9f4){
_9f3.dojoInsertionIndex=_9f4;
var idx=-1;
for(var i=0;i<this.children.length;i++){
if(this.children[i].dojoInsertionIndex<=_9f4){
idx=i;
}
}
this.children.splice(idx+1,0,_9f3);
_9f3.parent=this;
_9f3.addedTo(this,idx+1);
delete dojo.widget.manager.topWidgets[_9f3.widgetId];
},removeChild:function(_9f7){
dojo.dom.removeNode(_9f7.domNode);
return dojo.widget.DomWidget.superclass.removeChild.call(this,_9f7);
},getFragNodeRef:function(frag){
if(!frag){
return null;
}
if(!frag[this.getNamespacedType()]){
dojo.raise("Error: no frag for widget type "+this.getNamespacedType()+", id "+this.widgetId+" (maybe a widget has set it's type incorrectly)");
}
return frag[this.getNamespacedType()]["nodeRef"];
},postInitialize:function(args,frag,_9fb){
var _9fc=this.getFragNodeRef(frag);
if(_9fb&&(_9fb.snarfChildDomOutput||!_9fc)){
_9fb.addWidgetAsDirectChild(this,"","insertAtIndex","",args["dojoinsertionindex"],_9fc);
}else{
if(_9fc){
if(this.domNode&&(this.domNode!==_9fc)){
this._sourceNodeRef=dojo.dom.replaceNode(_9fc,this.domNode);
}
}
}
if(_9fb){
_9fb.registerChild(this,args.dojoinsertionindex);
}else{
dojo.widget.manager.topWidgets[this.widgetId]=this;
}
if(this.widgetsInTemplate){
var _9fd=new dojo.xml.Parse();
var _9fe;
var _9ff=this.domNode.getElementsByTagName("*");
for(var i=0;i<_9ff.length;i++){
if(_9ff[i].getAttribute("dojoAttachPoint")=="subContainerWidget"){
_9fe=_9ff[i];
}
if(_9ff[i].getAttribute("dojoType")){
_9ff[i].setAttribute("isSubWidget",true);
}
}
if(this.isContainer&&!this.containerNode){
if(_9fe){
var src=this.getFragNodeRef(frag);
if(src){
dojo.dom.moveChildren(src,_9fe);
frag["dojoDontFollow"]=true;
}
}else{
dojo.debug("No subContainerWidget node can be found in template file for widget "+this);
}
}
var _a02=_9fd.parseElement(this.domNode,null,true);
dojo.widget.getParser().createSubComponents(_a02,this);
var _a03=[];
var _a04=[this];
var w;
while((w=_a04.pop())){
for(var i=0;i<w.children.length;i++){
var _a06=w.children[i];
if(_a06._processedSubWidgets||!_a06.extraArgs["issubwidget"]){
continue;
}
_a03.push(_a06);
if(_a06.isContainer){
_a04.push(_a06);
}
}
}
for(var i=0;i<_a03.length;i++){
var _a07=_a03[i];
if(_a07._processedSubWidgets){
dojo.debug("This should not happen: widget._processedSubWidgets is already true!");
return;
}
_a07._processedSubWidgets=true;
if(_a07.extraArgs["dojoattachevent"]){
var evts=_a07.extraArgs["dojoattachevent"].split(";");
for(var j=0;j<evts.length;j++){
var _a0a=null;
var tevt=dojo.string.trim(evts[j]);
if(tevt.indexOf(":")>=0){
var _a0c=tevt.split(":");
tevt=dojo.string.trim(_a0c[0]);
_a0a=dojo.string.trim(_a0c[1]);
}
if(!_a0a){
_a0a=tevt;
}
if(dojo.lang.isFunction(_a07[tevt])){
dojo.event.kwConnect({srcObj:_a07,srcFunc:tevt,targetObj:this,targetFunc:_a0a});
}else{
alert(tevt+" is not a function in widget "+_a07);
}
}
}
if(_a07.extraArgs["dojoattachpoint"]){
this[_a07.extraArgs["dojoattachpoint"]]=_a07;
}
}
}
if(this.isContainer&&!frag["dojoDontFollow"]){
dojo.widget.getParser().createSubComponents(frag,this);
}
},buildRendering:function(args,frag){
var ts=dojo.widget._templateCache[this.widgetType];
if(args["templatecsspath"]){
args["templateCssPath"]=args["templatecsspath"];
}
var _a10=args["templateCssPath"]||this.templateCssPath;
if(_a10&&!dojo.widget._cssFiles[_a10.toString()]){
if((!this.templateCssString)&&(_a10)){
this.templateCssString=dojo.hostenv.getText(_a10);
this.templateCssPath=null;
}
dojo.widget._cssFiles[_a10.toString()]=true;
}
if((this["templateCssString"])&&(!dojo.widget._cssStrings[this.templateCssString])){
dojo.html.insertCssText(this.templateCssString,null,_a10);
dojo.widget._cssStrings[this.templateCssString]=true;
}
if((!this.preventClobber)&&((this.templatePath)||(this.templateNode)||((this["templateString"])&&(this.templateString.length))||((typeof ts!="undefined")&&((ts["string"])||(ts["node"]))))){
this.buildFromTemplate(args,frag);
}else{
this.domNode=this.getFragNodeRef(frag);
}
this.fillInTemplate(args,frag);
},buildFromTemplate:function(args,frag){
var _a13=false;
if(args["templatepath"]){
args["templatePath"]=args["templatepath"];
}
dojo.widget.fillFromTemplateCache(this,args["templatePath"],null,_a13);
var ts=dojo.widget._templateCache[this.templatePath?this.templatePath.toString():this.widgetType];
if((ts)&&(!_a13)){
if(!this.templateString.length){
this.templateString=ts["string"];
}
if(!this.templateNode){
this.templateNode=ts["node"];
}
}
var _a15=false;
var node=null;
var tstr=this.templateString;
if((!this.templateNode)&&(this.templateString)){
_a15=this.templateString.match(/\$\{([^\}]+)\}/g);
if(_a15){
var hash=this.strings||{};
for(var key in dojo.widget.defaultStrings){
if(dojo.lang.isUndefined(hash[key])){
hash[key]=dojo.widget.defaultStrings[key];
}
}
for(var i=0;i<_a15.length;i++){
var key=_a15[i];
key=key.substring(2,key.length-1);
var kval=(key.substring(0,5)=="this.")?dojo.getObject(key.substring(5),false,this):hash[key];
var _a1c;
if((kval)||(dojo.lang.isString(kval))){
_a1c=new String((dojo.lang.isFunction(kval))?kval.call(this,key,this.templateString):kval);
while(_a1c.indexOf("\"")>-1){
_a1c=_a1c.replace("\"","&quot;");
}
tstr=tstr.replace(_a15[i],_a1c);
}
}
}else{
this.templateNode=this.createNodesFromText(this.templateString,true)[0];
if(!_a13){
ts.node=this.templateNode;
}
}
}
if((!this.templateNode)&&(!_a15)){
dojo.debug("DomWidget.buildFromTemplate: could not create template");
return false;
}else{
if(!_a15){
node=this.templateNode.cloneNode(true);
if(!node){
return false;
}
}else{
node=this.createNodesFromText(tstr,true)[0];
}
}
this.domNode=node;
this.attachTemplateNodes();
if(this.isContainer&&this.containerNode){
var src=this.getFragNodeRef(frag);
if(src){
dojo.dom.moveChildren(src,this.containerNode);
}
}
},attachTemplateNodes:function(_a1e,_a1f){
if(!_a1e){
_a1e=this.domNode;
}
if(!_a1f){
_a1f=this;
}
return dojo.widget.attachTemplateNodes(_a1e,_a1f,dojo.widget.getDojoEventsFromStr(this.templateString));
},fillInTemplate:function(){
},destroyRendering:function(){
try{
dojo.dom.destroyNode(this.domNode);
delete this.domNode;
}
catch(e){
}
if(this._sourceNodeRef){
try{
dojo.dom.destroyNode(this._sourceNodeRef);
}
catch(e){
}
}
},createNodesFromText:function(){
dojo.unimplemented("dojo.widget.DomWidget.createNodesFromText");
}});
dojo.provide("dojo.lfx.toggler");
dojo.lfx.toggler.plain=function(){
this.stop=function(){
};
this.show=function(node,_a21,_a22,_a23){
dojo.html.show(node);
if(dojo.lang.isFunction(_a23)){
_a23();
}
};
this.hide=function(node,_a25,_a26,_a27){
dojo.html.hide(node);
if(dojo.lang.isFunction(_a27)){
_a27();
}
};
};
dojo.lfx.toggler.common={stop:function(){
if(this.anim&&this.anim.status()!="stopped"){
this.anim.stop();
}
},_act:function(_a28,node,_a2a,_a2b,_a2c,_a2d){
this.stop();
this.anim=dojo.lfx[_a28](node,_a2a,_a2b,_a2c).play();
},show:function(node,_a2f,_a30,_a31,_a32){
this._act(this.show_action,node,_a2f,_a30,_a31,_a32);
},hide:function(node,_a34,_a35,_a36,_a37){
this._act(this.hide_action,node,_a34,_a35,_a36,_a37);
}};
dojo.lfx.toggler.fade=function(){
this.anim=null;
this.show_action="fadeShow";
this.hide_action="fadeHide";
};
dojo.extend(dojo.lfx.toggler.fade,dojo.lfx.toggler.common);
dojo.lfx.toggler.wipe=function(){
this.anim=null;
this.show_action="wipeIn";
this.hide_action="wipeOut";
};
dojo.extend(dojo.lfx.toggler.wipe,dojo.lfx.toggler.common);
dojo.lfx.toggler.explode=function(){
this.anim=null;
this.show_action="explode";
this.hide_action="implode";
this.show=function(node,_a39,_a3a,_a3b,_a3c){
this.stop();
this.anim=dojo.lfx.explode(_a3c||{x:0,y:0,width:0,height:0},node,_a39,_a3a,_a3b).play();
};
this.hide=function(node,_a3e,_a3f,_a40,_a41){
this.stop();
this.anim=dojo.lfx.implode(node,_a41||{x:0,y:0,width:0,height:0},_a3e,_a3f,_a40).play();
};
};
dojo.extend(dojo.lfx.toggler.explode,dojo.lfx.toggler.common);
dojo.provide("dojo.widget.HtmlWidget");
dojo.declare("dojo.widget.HtmlWidget",dojo.widget.DomWidget,{templateCssPath:null,templatePath:null,lang:"",toggle:"plain",toggleDuration:150,initialize:function(args,frag){
},postMixInProperties:function(args,frag){
if(this.lang===""){
this.lang=null;
}
this.toggleObj=new (dojo.lfx.toggler[this.toggle.toLowerCase()]||dojo.lfx.toggler.plain);
},createNodesFromText:function(txt,wrap){
return dojo.html.createNodesFromText(txt,wrap);
},destroyRendering:function(_a48){
try{
if(this.bgIframe){
this.bgIframe.remove();
delete this.bgIframe;
}
if(!_a48&&this.domNode){
dojo.event.browser.clean(this.domNode);
}
dojo.widget.HtmlWidget.superclass.destroyRendering.call(this);
}
catch(e){
}
},isShowing:function(){
return dojo.html.isShowing(this.domNode);
},toggleShowing:function(){
if(this.isShowing()){
this.hide();
}else{
this.show();
}
},show:function(){
if(this.isShowing()){
return;
}
this.animationInProgress=true;
this.toggleObj.show(this.domNode,this.toggleDuration,null,dojo.lang.hitch(this,this.onShow),this.explodeSrc);
},onShow:function(){
this.animationInProgress=false;
this.checkSize();
},hide:function(){
if(!this.isShowing()){
return;
}
this.animationInProgress=true;
this.toggleObj.hide(this.domNode,this.toggleDuration,null,dojo.lang.hitch(this,this.onHide),this.explodeSrc);
},onHide:function(){
this.animationInProgress=false;
},_isResized:function(w,h){
if(!this.isShowing()){
return false;
}
var wh=dojo.html.getMarginBox(this.domNode);
var _a4c=w||wh.width;
var _a4d=h||wh.height;
if(this.width==_a4c&&this.height==_a4d){
return false;
}
this.width=_a4c;
this.height=_a4d;
return true;
},checkSize:function(){
if(!this._isResized()){
return;
}
this.onResized();
},resizeTo:function(w,h){
dojo.html.setMarginBox(this.domNode,{width:w,height:h});
if(this.isShowing()){
this.onResized();
}
},resizeSoon:function(){
if(this.isShowing()){
dojo.lang.setTimeout(this,this.onResized,0);
}
},onResized:function(){
dojo.lang.forEach(this.children,function(_a50){
if(_a50.checkSize){
_a50.checkSize();
}
});
}});
dojo.kwCompoundRequire({common:["dojo.xml.Parse","dojo.widget.Widget","dojo.widget.Parse","dojo.widget.Manager"],browser:["dojo.widget.DomWidget","dojo.widget.HtmlWidget"],dashboard:["dojo.widget.DomWidget","dojo.widget.HtmlWidget"],svg:["dojo.widget.SvgWidget"],rhino:["dojo.widget.SwtWidget"]});
dojo.provide("dojo.widget.*");
dojo.provide("dojo.math");
dojo.math.degToRad=function(x){
return (x*Math.PI)/180;
};
dojo.math.radToDeg=function(x){
return (x*180)/Math.PI;
};
dojo.math.factorial=function(n){
if(n<1){
return 0;
}
var _a54=1;
for(var i=1;i<=n;i++){
_a54*=i;
}
return _a54;
};
dojo.math.permutations=function(n,k){
if(n==0||k==0){
return 1;
}
return (dojo.math.factorial(n)/dojo.math.factorial(n-k));
};
dojo.math.combinations=function(n,r){
if(n==0||r==0){
return 1;
}
return (dojo.math.factorial(n)/(dojo.math.factorial(n-r)*dojo.math.factorial(r)));
};
dojo.math.bernstein=function(t,n,i){
return (dojo.math.combinations(n,i)*Math.pow(t,i)*Math.pow(1-t,n-i));
};
dojo.math.gaussianRandom=function(){
var k=2;
do{
var i=2*Math.random()-1;
var j=2*Math.random()-1;
k=i*i+j*j;
}while(k>=1);
k=Math.sqrt((-2*Math.log(k))/k);
return i*k;
};
dojo.math.mean=function(){
var _a60=dojo.lang.isArray(arguments[0])?arguments[0]:arguments;
var mean=0;
for(var i=0;i<_a60.length;i++){
mean+=_a60[i];
}
return mean/_a60.length;
};
dojo.math.round=function(_a63,_a64){
if(!_a64){
var _a65=1;
}else{
var _a65=Math.pow(10,_a64);
}
return Math.round(_a63*_a65)/_a65;
};
dojo.math.sd=dojo.math.standardDeviation=function(){
var _a66=dojo.lang.isArray(arguments[0])?arguments[0]:arguments;
return Math.sqrt(dojo.math.variance(_a66));
};
dojo.math.variance=function(){
var _a67=dojo.lang.isArray(arguments[0])?arguments[0]:arguments;
var mean=0,_a69=0;
for(var i=0;i<_a67.length;i++){
mean+=_a67[i];
_a69+=Math.pow(_a67[i],2);
}
return (_a69/_a67.length)-Math.pow(mean/_a67.length,2);
};
dojo.math.range=function(a,b,step){
if(arguments.length<2){
b=a;
a=0;
}
if(arguments.length<3){
step=1;
}
var _a6e=[];
if(step>0){
for(var i=a;i<b;i+=step){
_a6e.push(i);
}
}else{
if(step<0){
for(var i=a;i>b;i+=step){
_a6e.push(i);
}
}else{
throw new Error("dojo.math.range: step must be non-zero");
}
}
return _a6e;
};
dojo.provide("dojo.math.curves");
dojo.math.curves={Line:function(_a70,end){
this.start=_a70;
this.end=end;
this.dimensions=_a70.length;
for(var i=0;i<_a70.length;i++){
_a70[i]=Number(_a70[i]);
}
for(var i=0;i<end.length;i++){
end[i]=Number(end[i]);
}
this.getValue=function(n){
var _a74=new Array(this.dimensions);
for(var i=0;i<this.dimensions;i++){
_a74[i]=((this.end[i]-this.start[i])*n)+this.start[i];
}
return _a74;
};
return this;
},Bezier:function(pnts){
this.getValue=function(step){
if(step>=1){
return this.p[this.p.length-1];
}
if(step<=0){
return this.p[0];
}
var _a78=new Array(this.p[0].length);
for(var k=0;j<this.p[0].length;k++){
_a78[k]=0;
}
for(var j=0;j<this.p[0].length;j++){
var C=0;
var D=0;
for(var i=0;i<this.p.length;i++){
C+=this.p[i][j]*this.p[this.p.length-1][0]*dojo.math.bernstein(step,this.p.length,i);
}
for(var l=0;l<this.p.length;l++){
D+=this.p[this.p.length-1][0]*dojo.math.bernstein(step,this.p.length,l);
}
_a78[j]=C/D;
}
return _a78;
};
this.p=pnts;
return this;
},CatmullRom:function(pnts,c){
this.getValue=function(step){
var _a82=step*(this.p.length-1);
var node=Math.floor(_a82);
var _a84=_a82-node;
var i0=node-1;
if(i0<0){
i0=0;
}
var i=node;
var i1=node+1;
if(i1>=this.p.length){
i1=this.p.length-1;
}
var i2=node+2;
if(i2>=this.p.length){
i2=this.p.length-1;
}
var u=_a84;
var u2=_a84*_a84;
var u3=_a84*_a84*_a84;
var _a8c=new Array(this.p[0].length);
for(var k=0;k<this.p[0].length;k++){
var x1=(-this.c*this.p[i0][k])+((2-this.c)*this.p[i][k])+((this.c-2)*this.p[i1][k])+(this.c*this.p[i2][k]);
var x2=(2*this.c*this.p[i0][k])+((this.c-3)*this.p[i][k])+((3-2*this.c)*this.p[i1][k])+(-this.c*this.p[i2][k]);
var x3=(-this.c*this.p[i0][k])+(this.c*this.p[i1][k]);
var x4=this.p[i][k];
_a8c[k]=x1*u3+x2*u2+x3*u+x4;
}
return _a8c;
};
if(!c){
this.c=0.7;
}else{
this.c=c;
}
this.p=pnts;
return this;
},Arc:function(_a92,end,ccw){
var _a95=dojo.math.points.midpoint(_a92,end);
var _a96=dojo.math.points.translate(dojo.math.points.invert(_a95),_a92);
var rad=Math.sqrt(Math.pow(_a96[0],2)+Math.pow(_a96[1],2));
var _a98=dojo.math.radToDeg(Math.atan(_a96[1]/_a96[0]));
if(_a96[0]<0){
_a98-=90;
}else{
_a98+=90;
}
dojo.math.curves.CenteredArc.call(this,_a95,rad,_a98,_a98+(ccw?-180:180));
},CenteredArc:function(_a99,_a9a,_a9b,end){
this.center=_a99;
this.radius=_a9a;
this.start=_a9b||0;
this.end=end;
this.getValue=function(n){
var _a9e=new Array(2);
var _a9f=dojo.math.degToRad(this.start+((this.end-this.start)*n));
_a9e[0]=this.center[0]+this.radius*Math.sin(_a9f);
_a9e[1]=this.center[1]-this.radius*Math.cos(_a9f);
return _a9e;
};
return this;
},Circle:function(_aa0,_aa1){
dojo.math.curves.CenteredArc.call(this,_aa0,_aa1,0,360);
return this;
},Path:function(){
var _aa2=[];
var _aa3=[];
var _aa4=[];
var _aa5=0;
this.add=function(_aa6,_aa7){
if(_aa7<0){
dojo.raise("dojo.math.curves.Path.add: weight cannot be less than 0");
}
_aa2.push(_aa6);
_aa3.push(_aa7);
_aa5+=_aa7;
computeRanges();
};
this.remove=function(_aa8){
for(var i=0;i<_aa2.length;i++){
if(_aa2[i]==_aa8){
_aa2.splice(i,1);
_aa5-=_aa3.splice(i,1)[0];
break;
}
}
computeRanges();
};
this.removeAll=function(){
_aa2=[];
_aa3=[];
_aa5=0;
};
this.getValue=function(n){
var _aab=false,_aac=0;
for(var i=0;i<_aa4.length;i++){
var r=_aa4[i];
if(n>=r[0]&&n<r[1]){
var subN=(n-r[0])/r[2];
_aac=_aa2[i].getValue(subN);
_aab=true;
break;
}
}
if(!_aab){
_aac=_aa2[_aa2.length-1].getValue(1);
}
for(var j=0;j<i;j++){
_aac=dojo.math.points.translate(_aac,_aa2[j].getValue(1));
}
return _aac;
};
function computeRanges(){
var _ab1=0;
for(var i=0;i<_aa3.length;i++){
var end=_ab1+_aa3[i]/_aa5;
var len=end-_ab1;
_aa4[i]=[_ab1,end,len];
_ab1=end;
}
}
return this;
}};
dojo.provide("dojo.math.points");
dojo.math.points={translate:function(a,b){
if(a.length!=b.length){
dojo.raise("dojo.math.translate: points not same size (a:["+a+"], b:["+b+"])");
}
var c=new Array(a.length);
for(var i=0;i<a.length;i++){
c[i]=a[i]+b[i];
}
return c;
},midpoint:function(a,b){
if(a.length!=b.length){
dojo.raise("dojo.math.midpoint: points not same size (a:["+a+"], b:["+b+"])");
}
var c=new Array(a.length);
for(var i=0;i<a.length;i++){
c[i]=(a[i]+b[i])/2;
}
return c;
},invert:function(a){
var b=new Array(a.length);
for(var i=0;i<a.length;i++){
b[i]=-a[i];
}
return b;
},distance:function(a,b){
return Math.sqrt(Math.pow(b[0]-a[0],2)+Math.pow(b[1]-a[1],2));
}};
dojo.kwCompoundRequire({common:[["dojo.math",false,false],["dojo.math.curves",false,false],["dojo.math.points",false,false]]});
dojo.provide("dojo.math.*");
dojo.provide("dojo.io.ScriptSrcIO");
dojo.io.ScriptSrcTransport=new function(){
this.preventCache=false;
this.maxUrlLength=1000;
this.inFlightTimer=null;
this.DsrStatusCodes={Continue:100,Ok:200,Error:500};
this.startWatchingInFlight=function(){
if(!this.inFlightTimer){
this.inFlightTimer=setInterval("dojo.io.ScriptSrcTransport.watchInFlight();",100);
}
};
this.watchInFlight=function(){
var _ac2=0;
var _ac3=0;
for(var _ac4 in this._state){
_ac2++;
var _ac5=this._state[_ac4];
if(_ac5.isDone){
_ac3++;
delete this._state[_ac4];
}else{
if(!_ac5.isFinishing){
var _ac6=_ac5.kwArgs;
try{
if(_ac5.checkString&&eval("typeof("+_ac5.checkString+") != 'undefined'")){
_ac5.isFinishing=true;
this._finish(_ac5,"load");
_ac3++;
delete this._state[_ac4];
}else{
if(_ac6.timeoutSeconds&&_ac6.timeout){
if(_ac5.startTime+(_ac6.timeoutSeconds*1000)<(new Date()).getTime()){
_ac5.isFinishing=true;
this._finish(_ac5,"timeout");
_ac3++;
delete this._state[_ac4];
}
}else{
if(!_ac6.timeoutSeconds){
_ac3++;
}
}
}
}
catch(e){
_ac5.isFinishing=true;
this._finish(_ac5,"error",{status:this.DsrStatusCodes.Error,response:e});
}
}
}
}
if(_ac3>=_ac2){
clearInterval(this.inFlightTimer);
this.inFlightTimer=null;
}
};
this.canHandle=function(_ac7){
return dojo.lang.inArray(["text/javascript","text/json","application/json"],(_ac7["mimetype"].toLowerCase()))&&(_ac7["method"].toLowerCase()=="get")&&!(_ac7["formNode"]&&dojo.io.formHasFile(_ac7["formNode"]))&&(!_ac7["sync"]||_ac7["sync"]==false)&&!_ac7["file"]&&!_ac7["multipart"];
};
this.removeScripts=function(){
var _ac8=document.getElementsByTagName("script");
for(var i=0;_ac8&&i<_ac8.length;i++){
var _aca=_ac8[i];
if(_aca.className=="ScriptSrcTransport"){
var _acb=_aca.parentNode;
_acb.removeChild(_aca);
i--;
}
}
};
this.bind=function(_acc){
var url=_acc.url;
var _ace="";
if(_acc["formNode"]){
var ta=_acc.formNode.getAttribute("action");
if((ta)&&(!_acc["url"])){
url=ta;
}
var tp=_acc.formNode.getAttribute("method");
if((tp)&&(!_acc["method"])){
_acc.method=tp;
}
_ace+=dojo.io.encodeForm(_acc.formNode,_acc.encoding,_acc["formFilter"]);
}
if(url.indexOf("#")>-1){
dojo.debug("Warning: dojo.io.bind: stripping hash values from url:",url);
url=url.split("#")[0];
}
var _ad1=url.split("?");
if(_ad1&&_ad1.length==2){
url=_ad1[0];
_ace+=(_ace?"&":"")+_ad1[1];
}
if(_acc["backButton"]||_acc["back"]||_acc["changeUrl"]){
dojo.undo.browser.addToHistory(_acc);
}
var id=_acc["apiId"]?_acc["apiId"]:"id"+this._counter++;
var _ad3=_acc["content"];
var _ad4=_acc.jsonParamName;
if(_acc.sendTransport||_ad4){
if(!_ad3){
_ad3={};
}
if(_acc.sendTransport){
_ad3["dojo.transport"]="scriptsrc";
}
if(_ad4){
_ad3[_ad4]="dojo.io.ScriptSrcTransport._state."+id+".jsonpCall";
}
}
if(_acc.postContent){
_ace=_acc.postContent;
}else{
if(_ad3){
_ace+=((_ace)?"&":"")+dojo.io.argsFromMap(_ad3,_acc.encoding,_ad4);
}
}
if(_acc["apiId"]){
_acc["useRequestId"]=true;
}
var _ad5={"id":id,"idParam":"_dsrid="+id,"url":url,"query":_ace,"kwArgs":_acc,"startTime":(new Date()).getTime(),"isFinishing":false};
if(!url){
this._finish(_ad5,"error",{status:this.DsrStatusCodes.Error,statusText:"url.none"});
return;
}
if(_ad3&&_ad3[_ad4]){
_ad5.jsonp=_ad3[_ad4];
_ad5.jsonpCall=function(data){
if(data["Error"]||data["error"]){
if(dojo["json"]&&dojo["json"]["serialize"]){
dojo.debug(dojo.json.serialize(data));
}
dojo.io.ScriptSrcTransport._finish(this,"error",data);
}else{
dojo.io.ScriptSrcTransport._finish(this,"load",data);
}
};
}
if(_acc["useRequestId"]||_acc["checkString"]||_ad5["jsonp"]){
this._state[id]=_ad5;
}
if(_acc["checkString"]){
_ad5.checkString=_acc["checkString"];
}
_ad5.constantParams=(_acc["constantParams"]==null?"":_acc["constantParams"]);
if(_acc["preventCache"]||(this.preventCache==true&&_acc["preventCache"]!=false)){
_ad5.nocacheParam="dojo.preventCache="+new Date().valueOf();
}else{
_ad5.nocacheParam="";
}
var _ad7=_ad5.url.length+_ad5.query.length+_ad5.constantParams.length+_ad5.nocacheParam.length+this._extraPaddingLength;
if(_acc["useRequestId"]){
_ad7+=_ad5.idParam.length;
}
if(!_acc["checkString"]&&_acc["useRequestId"]&&!_ad5["jsonp"]&&!_acc["forceSingleRequest"]&&_ad7>this.maxUrlLength){
if(url>this.maxUrlLength){
this._finish(_ad5,"error",{status:this.DsrStatusCodes.Error,statusText:"url.tooBig"});
return;
}else{
this._multiAttach(_ad5,1);
}
}else{
var _ad8=[_ad5.constantParams,_ad5.nocacheParam,_ad5.query];
if(_acc["useRequestId"]&&!_ad5["jsonp"]){
_ad8.unshift(_ad5.idParam);
}
var _ad9=this._buildUrl(_ad5.url,_ad8);
_ad5.finalUrl=_ad9;
this._attach(_ad5.id,_ad9);
}
this.startWatchingInFlight();
};
this._counter=1;
this._state={};
this._extraPaddingLength=16;
this._buildUrl=function(url,_adb){
var _adc=url;
var _add="?";
for(var i=0;i<_adb.length;i++){
if(_adb[i]){
_adc+=_add+_adb[i];
_add="&";
}
}
return _adc;
};
this._attach=function(id,url){
var _ae1=document.createElement("script");
_ae1.type="text/javascript";
_ae1.src=url;
_ae1.id=id;
_ae1.className="ScriptSrcTransport";
document.getElementsByTagName("head")[0].appendChild(_ae1);
};
this._multiAttach=function(_ae2,part){
if(_ae2.query==null){
this._finish(_ae2,"error",{status:this.DsrStatusCodes.Error,statusText:"query.null"});
return;
}
if(!_ae2.constantParams){
_ae2.constantParams="";
}
var _ae4=this.maxUrlLength-_ae2.idParam.length-_ae2.constantParams.length-_ae2.url.length-_ae2.nocacheParam.length-this._extraPaddingLength;
var _ae5=_ae2.query.length<_ae4;
var _ae6;
if(_ae5){
_ae6=_ae2.query;
_ae2.query=null;
}else{
var _ae7=_ae2.query.lastIndexOf("&",_ae4-1);
var _ae8=_ae2.query.lastIndexOf("=",_ae4-1);
if(_ae7>_ae8||_ae8==_ae4-1){
_ae6=_ae2.query.substring(0,_ae7);
_ae2.query=_ae2.query.substring(_ae7+1,_ae2.query.length);
}else{
_ae6=_ae2.query.substring(0,_ae4);
var _ae9=_ae6.substring((_ae7==-1?0:_ae7+1),_ae8);
_ae2.query=_ae9+"="+_ae2.query.substring(_ae4,_ae2.query.length);
}
}
var _aea=[_ae6,_ae2.idParam,_ae2.constantParams,_ae2.nocacheParam];
if(!_ae5){
_aea.push("_part="+part);
}
var url=this._buildUrl(_ae2.url,_aea);
this._attach(_ae2.id+"_"+part,url);
};
this._finish=function(_aec,_aed,_aee){
if(_aed!="partOk"&&!_aec.kwArgs[_aed]&&!_aec.kwArgs["handle"]){
if(_aed=="error"){
_aec.isDone=true;
throw _aee;
}
}else{
switch(_aed){
case "load":
var _aef=_aee?_aee.response:null;
if(!_aef){
_aef=_aee;
}
_aec.kwArgs[(typeof _aec.kwArgs.load=="function")?"load":"handle"]("load",_aef,_aee,_aec.kwArgs);
_aec.isDone=true;
break;
case "partOk":
var part=parseInt(_aee.response.part,10)+1;
if(_aee.response.constantParams){
_aec.constantParams=_aee.response.constantParams;
}
this._multiAttach(_aec,part);
_aec.isDone=false;
break;
case "error":
_aec.kwArgs[(typeof _aec.kwArgs.error=="function")?"error":"handle"]("error",_aee.response,_aee,_aec.kwArgs);
_aec.isDone=true;
break;
default:
_aec.kwArgs[(typeof _aec.kwArgs[_aed]=="function")?_aed:"handle"](_aed,_aee,_aee,_aec.kwArgs);
_aec.isDone=true;
}
}
};
dojo.io.transports.addTransport("ScriptSrcTransport");
};
if(typeof window!="undefined"){
window.onscriptload=function(_af1){
var _af2=null;
var _af3=dojo.io.ScriptSrcTransport;
if(_af3._state[_af1.id]){
_af2=_af3._state[_af1.id];
}else{
var _af4;
for(var _af5 in _af3._state){
_af4=_af3._state[_af5];
if(_af4.finalUrl&&_af4.finalUrl==_af1.id){
_af2=_af4;
break;
}
}
if(_af2==null){
var _af6=document.getElementsByTagName("script");
for(var i=0;_af6&&i<_af6.length;i++){
var _af8=_af6[i];
if(_af8.getAttribute("class")=="ScriptSrcTransport"&&_af8.src==_af1.id){
_af2=_af3._state[_af8.id];
break;
}
}
}
if(_af2==null){
throw "No matching state for onscriptload event.id: "+_af1.id;
}
}
var _af9="error";
switch(_af1.status){
case dojo.io.ScriptSrcTransport.DsrStatusCodes.Continue:
_af9="partOk";
break;
case dojo.io.ScriptSrcTransport.DsrStatusCodes.Ok:
_af9="load";
break;
}
_af3._finish(_af2,_af9,_af1);
};
}
dojo.provide("dojo.io.cometd");
cometd=new function(){
this.initialized=false;
this.connected=false;
this.connectionTypes=new dojo.AdapterRegistry(true);
this.version=0.1;
this.minimumVersion=0.1;
this.clientId=null;
this._isXD=false;
this.handshakeReturn=null;
this.currentTransport=null;
this.url=null;
this.lastMessage=null;
this.globalTopicChannels={};
this.backlog=[];
this.tunnelInit=function(_afa,_afb){
};
this.tunnelCollapse=function(){
dojo.debug("tunnel collapsed!");
};
this.init=function(_afc,root,_afe){
_afc=_afc||{};
_afc.version=this.version;
_afc.minimumVersion=this.minimumVersion;
_afc.channel="/meta/handshake";
this.url=root||djConfig["cometdRoot"];
if(!this.url){
dojo.debug("no cometd root specified in djConfig and no root passed");
return;
}
var _aff={url:this.url,method:"POST",mimetype:"text/json",load:dojo.lang.hitch(this,"finishInit"),content:{"message":dojo.json.serialize([_afc])}};
var _b00="^(([^:/?#]+):)?(//([^/?#]*))?([^?#]*)(\\?([^#]*))?(#(.*))?$";
var r=(""+window.location).match(new RegExp(_b00));
if(r[4]){
var tmp=r[4].split(":");
var _b03=tmp[0];
var _b04=tmp[1]||"80";
r=this.url.match(new RegExp(_b00));
if(r[4]){
tmp=r[4].split(":");
var _b05=tmp[0];
var _b06=tmp[1]||"80";
if((_b05!=_b03)||(_b06!=_b04)){
dojo.debug(_b03,_b05);
dojo.debug(_b04,_b06);
this._isXD=true;
_aff.transport="ScriptSrcTransport";
_aff.jsonParamName="jsonp";
_aff.method="GET";
}
}
}
if(_afe){
dojo.lang.mixin(_aff,_afe);
}
return dojo.io.bind(_aff);
};
this.finishInit=function(type,data,evt,_b0a){
data=data[0];
this.handshakeReturn=data;
if(data["authSuccessful"]==false){
dojo.debug("cometd authentication failed");
return;
}
if(data.version<this.minimumVersion){
dojo.debug("cometd protocol version mismatch. We wanted",this.minimumVersion,"but got",data.version);
return;
}
this.currentTransport=this.connectionTypes.match(data.supportedConnectionTypes,data.version,this._isXD);
this.currentTransport.version=data.version;
this.clientId=data.clientId;
this.tunnelInit=dojo.lang.hitch(this.currentTransport,"tunnelInit");
this.tunnelCollapse=dojo.lang.hitch(this.currentTransport,"tunnelCollapse");
this.initialized=true;
this.currentTransport.startup(data);
while(this.backlog.length!=0){
var cur=this.backlog.shift();
var fn=cur.shift();
this[fn].apply(this,cur);
}
};
this._getRandStr=function(){
return Math.random().toString().substring(2,10);
};
this.deliver=function(_b0d){
dojo.lang.forEach(_b0d,this._deliver,this);
};
this._deliver=function(_b0e){
if(!_b0e["channel"]){
dojo.debug("cometd error: no channel for message!");
return;
}
if(!this.currentTransport){
this.backlog.push(["deliver",_b0e]);
return;
}
this.lastMessage=_b0e;
if((_b0e.channel.length>5)&&(_b0e.channel.substr(0,5)=="/meta")){
switch(_b0e.channel){
case "/meta/subscribe":
if(!_b0e.successful){
dojo.debug("cometd subscription error for channel",_b0e.channel,":",_b0e.error);
return;
}
this.subscribed(_b0e.subscription,_b0e);
break;
case "/meta/unsubscribe":
if(!_b0e.successful){
dojo.debug("cometd unsubscription error for channel",_b0e.channel,":",_b0e.error);
return;
}
this.unsubscribed(_b0e.subscription,_b0e);
break;
}
}
this.currentTransport.deliver(_b0e);
if(_b0e.data){
var _b0f=(this.globalTopicChannels[_b0e.channel])?_b0e.channel:"/cometd"+_b0e.channel;
dojo.event.topic.publish(_b0f,_b0e);
}
};
this.disconnect=function(){
if(!this.currentTransport){
dojo.debug("no current transport to disconnect from");
return;
}
this.currentTransport.disconnect();
};
this.publish=function(_b10,data,_b12){
if(!this.currentTransport){
this.backlog.push(["publish",_b10,data,_b12]);
return;
}
var _b13={data:data,channel:_b10};
if(_b12){
dojo.lang.mixin(_b13,_b12);
}
return this.currentTransport.sendMessage(_b13);
};
this.subscribe=function(_b14,_b15,_b16,_b17){
if(!this.currentTransport){
this.backlog.push(["subscribe",_b14,_b15,_b16,_b17]);
return;
}
if(_b16){
var _b18=(_b15)?_b14:"/cometd"+_b14;
if(_b15){
this.globalTopicChannels[_b14]=true;
}
dojo.event.topic.subscribe(_b18,_b16,_b17);
}
return this.currentTransport.sendMessage({channel:"/meta/subscribe",subscription:_b14});
};
this.subscribed=function(_b19,_b1a){
dojo.debug(_b19);
dojo.debugShallow(_b1a);
};
this.unsubscribe=function(_b1b,_b1c,_b1d,_b1e){
if(!this.currentTransport){
this.backlog.push(["unsubscribe",_b1b,_b1c,_b1d,_b1e]);
return;
}
if(_b1d){
var _b1f=(_b1c)?_b1b:"/cometd"+_b1b;
dojo.event.topic.unsubscribe(_b1f,_b1d,_b1e);
}
return this.currentTransport.sendMessage({channel:"/meta/unsubscribe",subscription:_b1b});
};
this.unsubscribed=function(_b20,_b21){
dojo.debug(_b20);
dojo.debugShallow(_b21);
};
};
cometd.iframeTransport=new function(){
this.connected=false;
this.connectionId=null;
this.rcvNode=null;
this.rcvNodeName="";
this.phonyForm=null;
this.authToken=null;
this.lastTimestamp=null;
this.lastId=null;
this.backlog=[];
this.check=function(_b22,_b23,_b24){
return ((!_b24)&&(!dojo.render.html.safari)&&(dojo.lang.inArray(_b22,"iframe")));
};
this.tunnelInit=function(){
this.postToIframe({message:dojo.json.serialize([{channel:"/meta/connect",clientId:cometd.clientId,connectionType:"iframe"}])});
};
this.tunnelCollapse=function(){
if(this.connected){
this.connected=false;
this.postToIframe({message:dojo.json.serialize([{channel:"/meta/reconnect",clientId:cometd.clientId,connectionId:this.connectionId,timestamp:this.lastTimestamp,id:this.lastId}])});
}
};
this.deliver=function(_b25){
if(_b25["timestamp"]){
this.lastTimestamp=_b25.timestamp;
}
if(_b25["id"]){
this.lastId=_b25.id;
}
if((_b25.channel.length>5)&&(_b25.channel.substr(0,5)=="/meta")){
switch(_b25.channel){
case "/meta/connect":
if(!_b25.successful){
dojo.debug("cometd connection error:",_b25.error);
return;
}
this.connectionId=_b25.connectionId;
this.connected=true;
this.processBacklog();
break;
case "/meta/reconnect":
if(!_b25.successful){
dojo.debug("cometd reconnection error:",_b25.error);
return;
}
this.connected=true;
break;
case "/meta/subscribe":
if(!_b25.successful){
dojo.debug("cometd subscription error for channel",_b25.channel,":",_b25.error);
return;
}
dojo.debug(_b25.channel);
break;
}
}
};
this.widenDomain=function(_b26){
var cd=_b26||document.domain;
if(cd.indexOf(".")==-1){
return;
}
var dps=cd.split(".");
if(dps.length<=2){
return;
}
dps=dps.slice(dps.length-2);
document.domain=dps.join(".");
return document.domain;
};
this.postToIframe=function(_b29,url){
if(!this.phonyForm){
if(dojo.render.html.ie){
this.phonyForm=document.createElement("<form enctype='application/x-www-form-urlencoded' method='POST' style='display: none;'>");
dojo.body().appendChild(this.phonyForm);
}else{
this.phonyForm=document.createElement("form");
this.phonyForm.style.display="none";
dojo.body().appendChild(this.phonyForm);
this.phonyForm.enctype="application/x-www-form-urlencoded";
this.phonyForm.method="POST";
}
}
this.phonyForm.action=url||cometd.url;
this.phonyForm.target=this.rcvNodeName;
this.phonyForm.setAttribute("target",this.rcvNodeName);
while(this.phonyForm.firstChild){
this.phonyForm.removeChild(this.phonyForm.firstChild);
}
for(var x in _b29){
var tn;
if(dojo.render.html.ie){
tn=document.createElement("<input type='hidden' name='"+x+"' value='"+_b29[x]+"'>");
this.phonyForm.appendChild(tn);
}else{
tn=document.createElement("input");
this.phonyForm.appendChild(tn);
tn.type="hidden";
tn.name=x;
tn.value=_b29[x];
}
}
this.phonyForm.submit();
};
this.processBacklog=function(){
while(this.backlog.length>0){
this.sendMessage(this.backlog.shift(),true);
}
};
this.sendMessage=function(_b2d,_b2e){
if((_b2e)||(this.connected)){
_b2d.connectionId=this.connectionId;
_b2d.clientId=cometd.clientId;
var _b2f={url:cometd.url||djConfig["cometdRoot"],method:"POST",mimetype:"text/json",content:{message:dojo.json.serialize([_b2d])}};
return dojo.io.bind(_b2f);
}else{
this.backlog.push(_b2d);
}
};
this.startup=function(_b30){
dojo.debug("startup!");
dojo.debug(dojo.json.serialize(_b30));
if(this.connected){
return;
}
this.rcvNodeName="cometdRcv_"+cometd._getRandStr();
var _b31=cometd.url+"/?tunnelInit=iframe";
if(false&&dojo.render.html.ie){
this.rcvNode=new ActiveXObject("htmlfile");
this.rcvNode.open();
this.rcvNode.write("<html>");
this.rcvNode.write("<script>document.domain = '"+document.domain+"'");
this.rcvNode.write("</html>");
this.rcvNode.close();
var _b32=this.rcvNode.createElement("div");
this.rcvNode.appendChild(_b32);
this.rcvNode.parentWindow.dojo=dojo;
_b32.innerHTML="<iframe src='"+_b31+"'></iframe>";
}else{
this.rcvNode=dojo.io.createIFrame(this.rcvNodeName,"",_b31);
}
};
};
cometd.mimeReplaceTransport=new function(){
this.connected=false;
this.connectionId=null;
this.xhr=null;
this.authToken=null;
this.lastTimestamp=null;
this.lastId=null;
this.backlog=[];
this.check=function(_b33,_b34,_b35){
return ((!_b35)&&(dojo.render.html.mozilla)&&(dojo.lang.inArray(_b33,"mime-message-block")));
};
this.tunnelInit=function(){
if(this.connected){
return;
}
this.openTunnelWith({message:dojo.json.serialize([{channel:"/meta/connect",clientId:cometd.clientId,connectionType:"mime-message-block"}])});
this.connected=true;
};
this.tunnelCollapse=function(){
if(this.connected){
this.connected=false;
this.openTunnelWith({message:dojo.json.serialize([{channel:"/meta/reconnect",clientId:cometd.clientId,connectionId:this.connectionId,timestamp:this.lastTimestamp,id:this.lastId}])});
}
};
this.deliver=cometd.iframeTransport.deliver;
this.handleOnLoad=function(resp){
cometd.deliver(dojo.json.evalJson(this.xhr.responseText));
};
this.openTunnelWith=function(_b37,url){
this.xhr=dojo.hostenv.getXmlhttpObject();
this.xhr.multipart=true;
if(dojo.render.html.mozilla){
this.xhr.addEventListener("load",dojo.lang.hitch(this,"handleOnLoad"),false);
}else{
if(dojo.render.html.safari){
dojo.debug("Webkit is broken with multipart responses over XHR = (");
this.xhr.onreadystatechange=dojo.lang.hitch(this,"handleOnLoad");
}else{
this.xhr.onload=dojo.lang.hitch(this,"handleOnLoad");
}
}
this.xhr.open("POST",(url||cometd.url),true);
this.xhr.setRequestHeader("Content-Type","application/x-www-form-urlencoded");
dojo.debug(dojo.json.serialize(_b37));
this.xhr.send(dojo.io.argsFromMap(_b37,"utf8"));
};
this.processBacklog=function(){
while(this.backlog.length>0){
this.sendMessage(this.backlog.shift(),true);
}
};
this.sendMessage=function(_b39,_b3a){
if((_b3a)||(this.connected)){
_b39.connectionId=this.connectionId;
_b39.clientId=cometd.clientId;
var _b3b={url:cometd.url||djConfig["cometdRoot"],method:"POST",mimetype:"text/json",content:{message:dojo.json.serialize([_b39])}};
return dojo.io.bind(_b3b);
}else{
this.backlog.push(_b39);
}
};
this.startup=function(_b3c){
dojo.debugShallow(_b3c);
if(this.connected){
return;
}
this.tunnelInit();
};
};
cometd.longPollTransport=new function(){
this.connected=false;
this.connectionId=null;
this.authToken=null;
this.lastTimestamp=null;
this.lastId=null;
this.backlog=[];
this.check=function(_b3d,_b3e,_b3f){
return ((!_b3f)&&(dojo.lang.inArray(_b3d,"long-polling")));
};
this.tunnelInit=function(){
if(this.connected){
return;
}
this.openTunnelWith({message:dojo.json.serialize([{channel:"/meta/connect",clientId:cometd.clientId,connectionType:"long-polling"}])});
this.connected=true;
};
this.tunnelCollapse=function(){
if(!this.connected){
this.connected=false;
dojo.debug("clientId:",cometd.clientId);
this.openTunnelWith({message:dojo.json.serialize([{channel:"/meta/reconnect",connectionType:"long-polling",clientId:cometd.clientId,connectionId:this.connectionId,timestamp:this.lastTimestamp,id:this.lastId}])});
}
};
this.deliver=cometd.iframeTransport.deliver;
this.openTunnelWith=function(_b40,url){
dojo.io.bind({url:(url||cometd.url),method:"post",content:_b40,mimetype:"text/json",load:dojo.lang.hitch(this,function(type,data,evt,args){
cometd.deliver(data);
this.connected=false;
this.tunnelCollapse();
}),error:function(){
dojo.debug("tunnel opening failed");
}});
this.connected=true;
};
this.processBacklog=function(){
while(this.backlog.length>0){
this.sendMessage(this.backlog.shift(),true);
}
};
this.sendMessage=function(_b46,_b47){
if((_b47)||(this.connected)){
_b46.connectionId=this.connectionId;
_b46.clientId=cometd.clientId;
var _b48={url:cometd.url||djConfig["cometdRoot"],method:"post",mimetype:"text/json",content:{message:dojo.json.serialize([_b46])},load:dojo.lang.hitch(this,function(type,data,evt,args){
cometd.deliver(data);
})};
return dojo.io.bind(_b48);
}else{
this.backlog.push(_b46);
}
};
this.startup=function(_b4d){
if(this.connected){
return;
}
this.tunnelInit();
};
};
cometd.callbackPollTransport=new function(){
this.connected=false;
this.connectionId=null;
this.authToken=null;
this.lastTimestamp=null;
this.lastId=null;
this.backlog=[];
this.check=function(_b4e,_b4f,_b50){
return dojo.lang.inArray(_b4e,"callback-polling");
};
this.tunnelInit=function(){
if(this.connected){
return;
}
this.openTunnelWith({message:dojo.json.serialize([{channel:"/meta/connect",clientId:cometd.clientId,connectionType:"callback-polling"}])});
this.connected=true;
};
this.tunnelCollapse=function(){
if(!this.connected){
this.connected=false;
this.openTunnelWith({message:dojo.json.serialize([{channel:"/meta/reconnect",connectionType:"long-polling",clientId:cometd.clientId,connectionId:this.connectionId,timestamp:this.lastTimestamp,id:this.lastId}])});
}
};
this.deliver=cometd.iframeTransport.deliver;
this.openTunnelWith=function(_b51,url){
var req=dojo.io.bind({url:(url||cometd.url),content:_b51,mimetype:"text/json",transport:"ScriptSrcTransport",jsonParamName:"jsonp",load:dojo.lang.hitch(this,function(type,data,evt,args){
cometd.deliver(data);
this.connected=false;
this.tunnelCollapse();
}),error:function(){
dojo.debug("tunnel opening failed");
}});
this.connected=true;
};
this.processBacklog=function(){
while(this.backlog.length>0){
this.sendMessage(this.backlog.shift(),true);
}
};
this.sendMessage=function(_b58,_b59){
if((_b59)||(this.connected)){
_b58.connectionId=this.connectionId;
_b58.clientId=cometd.clientId;
var _b5a={url:cometd.url||djConfig["cometdRoot"],mimetype:"text/json",transport:"ScriptSrcTransport",jsonParamName:"jsonp",content:{message:dojo.json.serialize([_b58])},load:dojo.lang.hitch(this,function(type,data,evt,args){
cometd.deliver(data);
})};
return dojo.io.bind(_b5a);
}else{
this.backlog.push(_b58);
}
};
this.startup=function(_b5f){
if(this.connected){
return;
}
this.tunnelInit();
};
};
cometd.connectionTypes.register("mime-message-block",cometd.mimeReplaceTransport.check,cometd.mimeReplaceTransport);
cometd.connectionTypes.register("long-polling",cometd.longPollTransport.check,cometd.longPollTransport);
cometd.connectionTypes.register("callback-polling",cometd.callbackPollTransport.check,cometd.callbackPollTransport);
cometd.connectionTypes.register("iframe",cometd.iframeTransport.check,cometd.iframeTransport);
dojo.io.cometd=cometd;

