package org.mortbay.cometd.continuation;

import java.io.IOException;
import java.lang.reflect.Array;
import java.util.Map;
import java.util.Queue;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.mortbay.cometd.Bayeux;
import org.mortbay.cometd.Client;
import org.mortbay.cometd.AbstractCometdServlet;
import org.mortbay.cometd.Transport;
import org.mortbay.util.ajax.Continuation;
import org.mortbay.util.ajax.ContinuationSupport;
import org.mortbay.util.ajax.JSON;

public class ContinuationCometdServlet extends AbstractCometdServlet
{
    /* ------------------------------------------------------------ */
    protected Bayeux newBayeux()
    {
        return new ContinuationBayeux();
    }


    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException
    {
        // Look for an existing client and protect from context restarts
        Object clientObj=req.getAttribute(CLIENT_ATTR);
        ContinuationClient client=(clientObj instanceof Client)?(ContinuationClient)clientObj:null;
        Transport transport=null;

        // Have we seen this request before
        if (client!=null)
        {
            if (_bayeux.isLogDebug())
                _bayeux.logDebug("doPost: client seen before: "+client);
            
            // yes - extract saved properties
            transport=(Transport)req.getAttribute(TRANSPORT_ATTR);
            transport.setResponse(resp);
        }
        else
        {
            // variables to loop through batches and messages
            // May have multiple message parameters, each with an array of
            // messages - or just a message
            String[] batches=null;
            int batch_index=0;
            Object batch=null;
            int index=0;
            Map<String,Object> message=null;
            int message_count=0;

            batches=req.getParameterValues(MESSAGE_PARAM);

            /* aabeling: check jsonp parameter */
            String jsonpParam=req.getParameter("jsonp");
            if (jsonpParam!=null)
            {
                if (_bayeux.isLogDebug())
                    _bayeux.logDebug("doPost: jsonp="+jsonpParam);
            }

            // Loop to the first message - it may be handshake without a client
            while (batch_index<batches.length)
            {
                // Do we need to get another batch?
                if (batch==null)
                {
                    index=0;
                    batch=JSON.parse(batches[batch_index++],_bayeux.isJSONCommented());
                }

                if (batch==null)
                    continue;

                if (batch.getClass().isArray())
                {
                    message=(Map)Array.get(batch,index++);
                    if (index>=Array.getLength(batch))
                        batch=null;
                }
                else
                {
                    message=(Map)batch;
                    batch=null;
                }

                message_count++;

                /* aabeling: store jsonp parameter in message */
                if (jsonpParam!=null)
                {
                    message.put("jsonp",jsonpParam);
                }

                client=(ContinuationClient)_bayeux.getClient((String)message.get(Bayeux.CLIENT_FIELD));
                

                // If no client, this is a handshake
                if (client==null)
                {
                    // handshake!
                    transport=_bayeux.newTransport(client,message);
                    transport.setResponse(resp);
                    _bayeux.handle(null,transport,message);
                    message=null;
                }

                break;
            }

            // Handle all client messages
            if (client!=null)
            {
                // resolve transport
                transport=_bayeux.newTransport(client,message);
                transport.setResponse(resp);
                
                
                // continue handling messages with a known client and transport!
                try
                {
                    // Tell client to hold messages as a response is likely to
                    // be sent.
                    client.responsePending();

                    // handle any message left over from client loop above
                    if (message!=null)
                        _bayeux.handle(client,transport,message);
                    message=null;

                    // handle all other messages
                    while (batch_index<batches.length)
                    {
                        // Do we need to get another batch?
                        if (batch==null)
                        {
                            index=0;
                            batch=JSON.parse(batches[batch_index++],_bayeux.isJSONCommented());
                        }
                        if (batch==null)
                            continue;

                        // get the next message
                        if (batch.getClass().isArray())
                        {
                            message=(Map)Array.get(batch,index++);
                            if (index>=Array.getLength(batch))
                                batch=null;
                        }
                        else
                        {
                            message=(Map)batch;
                            batch=null;
                        }

                        // handle message
                        if (message!=null)
                            _bayeux.handle(client,transport,message);
                        message=null;
                    }

                }
                finally
                {
                    client.responded();
                }
            }
        }

        // Do we need to wait for messages or are we streaming?
        while (transport.isPolling())
        {
            if (_bayeux.isLogDebug())
                _bayeux.logDebug("doPost: transport is polling");
            long timeout=_timeout;
            
            Continuation continuation=ContinuationSupport.getContinuation(req,client);
            if (!continuation.isPending())
                client.access();
            
            // Get messages or wait
            Queue<Map<String,Object>> messages=null;
            synchronized (client)
            {
                messages=client.takeMessages();

                if ((messages==null||messages.size()==0)&&!continuation.isPending())
                {
                    // save state and suspend
                    ((ContinuationClient)client).setContinuation(continuation);
                    req.setAttribute(CLIENT_ATTR,client);
                    req.setAttribute(TRANSPORT_ATTR,transport);
                    if (_bayeux.isLogDebug())
                        _bayeux.logDebug("doPost: setting transport for request: "+transport);
                    continuation.suspend(timeout);
                    
                    messages=client.takeMessages();
                    
                }
                continuation.reset();
                ((ContinuationClient)client).setContinuation(null);

                if (messages==null) // timeout
                {
                    transport.setPolling(false);
                }
            }
            

            // Send the messages
            if (messages!=null)
                transport.send(messages);

            // Only a simple poll if the transport does not flush
            if (!transport.keepAlive())
                transport.setPolling(false);
        }

        // Send any left over messages.
        if (client!=null) 
        { 
            Queue<Map<String,Object>> messages = client.takeMessages(); 
            if (messages!=null) 
                transport.send(messages); 
        }
        transport.complete();

    }

}
