/*
 * Decompiled with CFR 0.152.
 */
package org.makumba.forms.tags;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.BodyContent;
import javax.servlet.jsp.tagext.BodyTag;
import javax.servlet.jsp.tagext.Tag;
import org.makumba.DataDefinition;
import org.makumba.LogicException;
import org.makumba.MakumbaSystem;
import org.makumba.ProgrammerError;
import org.makumba.analyser.PageCache;
import org.makumba.commons.MultipleKey;
import org.makumba.commons.RuntimeWrappedException;
import org.makumba.commons.StringUtils;
import org.makumba.commons.attributes.PageAttributes;
import org.makumba.commons.tags.GenericMakumbaTag;
import org.makumba.forms.responder.FormResponder;
import org.makumba.forms.responder.ResponderFactory;
import org.makumba.forms.responder.ResponderOperation;
import org.makumba.forms.tags.DeleteTag;
import org.makumba.providers.Configuration;
import org.makumba.providers.DataDefinitionProvider;
import org.makumba.providers.FormDataProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FormTagBase
extends GenericMakumbaTag
implements BodyTag {
    private static final long serialVersionUID = 1L;
    public static final String __MAKUMBA__FORM__COUNTER__ = "__makumba__form__counter__";
    private static final String[] validAnnotationParams = new String[]{"none", "before", "after", "both"};
    private static final String[] validClientSideValidationParams = new String[]{"true", "false", "live"};
    public String baseObject = null;
    String handler = null;
    String afterHandler = null;
    String formMethod = null;
    public String formAction = null;
    String formName = null;
    String formMessage = null;
    String annotation = null;
    String annotationSeparator;
    private String clientSideValidation = Configuration.getClientSideValidationDefault();
    protected String multipleSubmitErrorMsg = null;
    protected String field = null;
    protected String operation = null;
    protected String triggerEvent = null;
    protected String styleId = null;
    BodyContent bodyContent = null;
    FormResponder responder = null;
    protected DataDefinition type = null;
    String basePointer = null;
    Boolean reloadFormOnError = null;
    private Map<MultipleKey, String> responders;
    HashMap<String, String> lazyEvaluatedInputs = new HashMap();
    protected String formIdentifier = null;
    long starttime;
    protected FormDataProvider fdp;
    private ResponderFactory responderFactory = ResponderFactory.getInstance();
    protected DataDefinitionProvider ddp = DataDefinitionProvider.getInstance();

    public FormTagBase() {
        try {
            this.fdp = (FormDataProvider)Class.forName("org.makumba.list.ListFormDataProvider").newInstance();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
    }

    public void setBodyContent(BodyContent bc) {
        this.bodyContent = bc;
    }

    public void doInitBody() {
    }

    protected boolean allowEmptyBody() {
        return true;
    }

    public void setObject(String s) {
        this.baseObject = s;
    }

    @Override
    public void setStyleId(String s) {
        this.styleId = s;
    }

    @Override
    public void setType(String s) {
        this.type = this.ddp.getDataDefinition(s);
    }

    public void setField(String s) {
        this.field = s;
    }

    public void setOperation(String o) {
        this.operation = o;
    }

    public void setTriggerEvent(String e) {
        this.triggerEvent = e;
    }

    public void setAction(String s) {
        this.formAction = s;
    }

    public void setHandler(String s) {
        this.handler = s;
    }

    public void setAfterHandler(String s) {
        this.afterHandler = s;
    }

    public void setMethod(String s) {
        this.checkNoParent("method");
        this.formMethod = s;
    }

    public void setName(String s) {
        this.formName = s;
        this.extraFormattingParams.put("name", s);
    }

    public void setMessage(String s) {
        this.checkNoParent("message");
        this.formMessage = s;
    }

    public void setMultipart() {
        FormTagBase parent = this.findParentForm();
        if (parent != null) {
            parent.setMultipart();
        } else {
            if (this.formMethod == null || !this.formMethod.trim().equalsIgnoreCase("post")) {
                throw new ProgrammerError("Forms with file upload have to use method=\"post\"!");
            }
            this.responder.setMultipart(true);
        }
    }

    public void setTarget(String s) {
        this.checkNoParent("target");
        this.extraFormattingParams.put("target", s);
    }

    public void setOnReset(String s) {
        this.checkNoParent("onReset");
        this.extraFormattingParams.put("onReset", s);
    }

    public void setOnSubmit(String s) {
        this.checkNoParent("onSubmit");
        if (this.clientSideValidation != "PROPERTY_NOT_SET") {
            throw new ProgrammerError("Forms specifying a 'clientSideValidation' attribute cannot provide an 'onSubmit' attribute");
        }
        this.extraFormattingParams.put("onSubmit", s);
    }

    public void setClientSideValidation(String clientSideValidation) {
        this.checkValidAttributeValues("clientSideValidation", clientSideValidation, validClientSideValidationParams);
        if (this.extraFormattingParams.get("onSubmit") != null) {
            throw new ProgrammerError("Forms specifying a 'clientSideValidation' attribute cannot provide an 'onSubmit' attribute");
        }
        this.clientSideValidation = clientSideValidation;
    }

    public void setAnnotation(String s) {
        this.checkNoParent("annotation");
        this.checkValidAttributeValues("annotation", s, validAnnotationParams);
        this.annotation = s;
    }

    public void setAnnotationSeparator(String s) {
        this.checkNoParent("annotationSeparator");
        this.annotationSeparator = s;
    }

    public void setReloadFormOnError(String s) {
        this.checkNoParent("reloadFormOnError");
        this.reloadFormOnError = s != null && s.equals("false") ? Boolean.valueOf(false) : Boolean.valueOf(true);
    }

    public void setMultipleSubmitErrorMsg(String s) {
        this.checkNoParent("multipleSubmitErrorMsg");
        this.multipleSubmitErrorMsg = s;
    }

    String getOperation() {
        if (this.operation == null) {
            String classname = ((Object)((Object)this)).getClass().getName();
            if (classname.endsWith("FormTagBase")) {
                return "simple";
            }
            int n = classname.lastIndexOf("Tag");
            if (n != classname.length() - 3) {
                throw new RuntimeException("the tag class name was expected to end with 'Tag': " + classname);
            }
            classname = classname.substring(0, n);
            int m = classname.lastIndexOf(".");
            return classname.substring(m + 1).toLowerCase();
        }
        if (this.isAttribute(this.operation)) {
            try {
                this.operation = (String)PageAttributes.getAttributes(this.pageContext).getAttribute(this.operation.substring(1));
            }
            catch (LogicException le) {
                throw new RuntimeException("Error while trying to resolve operation of form", le);
            }
        }
        if (StringUtils.equalsAny(this.operation, "new", "edit")) {
            return this.operation;
        }
        throw new ProgrammerError("mak:form only support 'new' and 'edit' operations");
    }

    public boolean shouldComputeBasePointer() {
        return this.baseObject != null;
    }

    @Override
    public void setTagKey(PageCache pageCache) {
        Object[] keyComponents = new Object[]{this.baseObject, this.handler, this.afterHandler, this.fdp.getParentListKey(this), ((Object)((Object)this)).getClass()};
        this.tagKey = new MultipleKey(keyComponents);
    }

    @Override
    public void doStartAnalyze(PageCache pageCache) {
        if (this.findParentForm() == null) {
            pageCache.cache("org.makumba.nestedFormNames", this.getTagKey(), new HashMap());
        }
        if (this.reloadFormOnError == null) {
            this.reloadFormOnError = this.getOperation().equals("search") ? false : Configuration.getReloadFormOnErrorDefault();
        }
        if (org.apache.commons.lang.StringUtils.isNotBlank((String)this.formName)) {
            this.getNestedFormNames(pageCache).put(this.formName, this.getTagKey());
        }
        if (!this.shouldComputeBasePointer()) {
            return;
        }
        this.fdp.onFormStartAnalyze(this, pageCache, this.baseObject);
    }

    @Override
    public void doEndAnalyze(PageCache pageCache) {
        this.fdp.onFormEndAnalyze(this.getTagKey(), pageCache);
        if (this.formAction == null && this.findParentForm() == null && !this.getOperation().equals("search") && this.triggerEvent == null) {
            throw new ProgrammerError("Forms must have either action= defined, or an enclosed <mak:action>...</mak:action>, or be submitted via partial postback by defining an event='...' to be fired upon submission");
        }
        if (this.triggerEvent != null && this.formAction != null) {
            throw new ProgrammerError("Forms cannot define both an action and a triggerEvent, as triggerEvent leads to partial post-back.");
        }
        if (this.findParentForm() != null && this.formAction != null) {
            throw new ProgrammerError("Forms included in other forms cannot have action= defined, or an enclosed <mak:action>...</mak:action>");
        }
        if (StringUtils.equalsAny(this.clientSideValidation, "true", "live")) {
            pageCache.cacheSetValues("org.makumba.neededResources", MakumbaSystem.getClientsideValidationProvider().getNeededJavaScriptFileNames());
        }
        if (this.triggerEvent != null) {
            pageCache.cacheSetValues("org.makumba.neededResources", new String[]{"makumba-ajax.js"});
        }
        pageCache.cache("org.makumba.unresolvedInputs", this.tagKey, this.lazyEvaluatedInputs);
        if (!this.shouldComputeBasePointer()) {
            return;
        }
        pageCache.cache("org.makumba.basePointerTypes", this.tagKey, this.fdp.getTypeOnEndAnalyze(this.getTagKey(), pageCache).getPointedType().getName());
    }

    public FormTagBase findParentForm() {
        return (FormTagBase)FormTagBase.findAncestorWithClass((Tag)this, FormTagBase.class);
    }

    FormTagBase findRootForm() {
        FormTagBase parent = this.findParentForm();
        if (parent == null) {
            return this;
        }
        return parent.findRootForm();
    }

    void checkNoParent(String attrName) {
        if (this.findParentForm() != null) {
            throw new ProgrammerError("Forms included in other forms cannot have a '" + attrName + "' attribute");
        }
    }

    @Override
    public void initialiseState() {
        super.initialiseState();
        this.responder = this.responderFactory.createResponder();
        if (this.formName != null) {
            this.responder.setResultAttribute(this.formName);
        }
        if (this.handler != null) {
            this.responder.setHandler(this.handler);
        }
        if (this.afterHandler != null) {
            this.responder.setAfterHandler(this.afterHandler);
        }
        if (this.formAction != null) {
            this.responder.setAction(this.formAction);
        }
        if (this.formMethod != null) {
            this.responder.setMethod(this.formMethod);
        }
        if (this.formMessage != null) {
            this.responder.setMessage(this.formMessage);
        }
        if (this.triggerEvent != null) {
            this.responder.setTriggerEvent(this.triggerEvent);
        }
        this.responder.setFormName(this.formName);
        this.responder.setFormId(this.getFormIdentifier());
        if (this.reloadFormOnError == null) {
            this.reloadFormOnError = this.getOperation().equals("search") ? false : Configuration.getReloadFormOnErrorDefault();
        }
        this.responder.setReloadFormOnError(this.reloadFormOnError);
        String url = ((HttpServletRequest)this.pageContext.getRequest()).getRequestURI();
        String queryString = ((HttpServletRequest)this.pageContext.getRequest()).getQueryString();
        if (queryString != null) {
            url = url + "?" + queryString;
        }
        this.responder.setOriginatingPageName(url);
        if (org.apache.commons.lang.StringUtils.isBlank((String)this.annotation)) {
            this.annotation = Configuration.getDefaultFormAnnotation();
        }
        this.responder.setShowFormAnnotated(StringUtils.equalsAny(this.annotation, "before", "after", "both"));
        this.responder.setClientSideValidation(this.clientSideValidation);
        if (this.findParentForm() != null) {
            this.responder.setParentResponder(this.findParentForm().responder, this.findRootForm().responder);
        }
        if (this.findParentForm() == null) {
            this.responders = new HashMap<MultipleKey, String>();
        }
        switch (this.getResponderOperation(this.getOperation()).getOperationType()) {
            case NEW: {
                if (this.type != null) {
                    this.responder.setNewType(this.type);
                }
                if (this.multipleSubmitErrorMsg == null) break;
                this.responder.setMultipleSubmitErrorMsg(this.multipleSubmitErrorMsg);
                break;
            }
            case ADD: {
                if (this.multipleSubmitErrorMsg != null) {
                    this.responder.setMultipleSubmitErrorMsg(this.multipleSubmitErrorMsg);
                }
                if (this.field != null) {
                    this.responder.setAddField(this.field);
                }
                if ("add".equals(this.getOperation())) break;
                this.responder.setNewType(this.findParentForm().type);
            }
        }
    }

    @Override
    protected void doAnalyzedCleanup() {
        super.doAnalyzedCleanup();
        this.triggerEvent = null;
        this.operation = null;
        this.multipleSubmitErrorMsg = null;
        this.field = null;
        this.handler = null;
        this.formName = null;
        this.formMessage = null;
        this.formMethod = null;
        this.formAction = null;
        this.basePointer = null;
        this.baseObject = null;
        this.annotationSeparator = null;
        this.annotation = null;
        this.afterHandler = null;
        this.responder = null;
        this.type = null;
        this.bodyContent = null;
        this.responders = null;
    }

    @Override
    public int doAnalyzedStartTag(PageCache pageCache) throws JspException, LogicException {
        this.formIdentifier = null;
        this.updateFormId();
        this.getFormIdentifier();
        this.fdp.onFormStartTag(this.getTagKey(), pageCache, this.pageContext);
        this.responder.setOperation(this.getOperation(), this.getResponderOperation(this.getOperation()));
        this.responder.setExtraFormatting(this.extraFormatting);
        this.responder.setBasePointerType((String)pageCache.retrieve("org.makumba.basePointerTypes", this.tagKey));
        this.starttime = new Date().getTime();
        if (this.shouldComputeBasePointer()) {
            this.basePointer = this.fdp.computeBasePointer(this.getTagKey(), this.pageContext);
        }
        try {
            this.responder.setHttpRequest((HttpServletRequest)this.pageContext.getRequest());
        }
        catch (LogicException e) {
            throw new RuntimeWrappedException(e);
        }
        return 2;
    }

    @Override
    public int doAnalyzedEndTag(PageCache pageCache) throws JspException {
        this.fdp.onFormEndTag(this.getTagKey(), pageCache, this.pageContext);
        try {
            StringBuffer sb = new StringBuffer();
            if (!this.allowEmptyBody() && this.bodyContent == null) {
                throw new ProgrammerError("Tag " + FormTagBase.getRunningTag().name + " must have a non-empty body");
            }
            this.responder.writeFormPreamble(sb, this.basePointer, (HttpServletRequest)this.pageContext.getRequest());
            this.bodyContent.getEnclosingWriter().print(sb.toString());
            if (this instanceof DeleteTag && !((DeleteTag)this).getPreserveWhiteSpace()) {
                this.bodyContent.getEnclosingWriter().print(this.bodyContent.getString().trim());
            } else {
                this.bodyContent.writeOut((Writer)this.bodyContent.getEnclosingWriter());
            }
            boolean isClientSideValidation = StringUtils.equalsAny(this.clientSideValidation, "true", "live");
            if (!this.getOperation().equals("search") && !(this instanceof DeleteTag) && isClientSideValidation) {
                sb = new StringBuffer();
                this.responder.writeClientsideValidation(sb);
                this.bodyContent.getEnclosingWriter().print(sb.toString());
            }
            sb = new StringBuffer();
            this.responder.writeFormPostamble(sb, this.basePointer, (HttpServletRequest)this.pageContext.getRequest());
            if (this.triggerEvent != null) {
                sb.append("<script type=\"text/javascript\">").append("Event.observe('").append(this.getFormIdentifier()).append("', 'submit', function(event) {").append(this.getSubmitJavascriptCall("event", true)).append("});").append("</script>");
            }
            this.bodyContent.getEnclosingWriter().print(sb.toString());
            if (this.findParentForm() != null) {
                Logger.getLogger("org.makumba.taglib.performance").fine("form time: " + (new Date().getTime() - this.starttime));
            }
            MultipleKey[] sortedForms = (MultipleKey[])pageCache.retrieve("org.makumba.dependency", "org.makumba.dependency");
            FormTagBase rootForm = this.findRootForm();
            if (rootForm.responders == null) {
                this.findRootForm();
            }
            rootForm.responders.put(this.getTagKey(), this.responder.getResponderValue());
            this.responder.setLazyEvaluatedInputs((HashMap)pageCache.retrieve("org.makumba.unresolvedInputs", this.getTagKey()));
            if (this.findParentForm() == null) {
                ArrayList<String> responderOrder = new ArrayList<String>();
                for (MultipleKey element : sortedForms) {
                    if (this.responders.get(element) == null) continue;
                    responderOrder.add(this.responders.get(element));
                }
                this.responder.setResponderOrder(responderOrder);
            }
        }
        catch (IOException e) {
            throw new JspException(e.toString());
        }
        return 6;
    }

    protected String getSubmitJavascriptCall(String event, boolean ajax) {
        StringBuilder sb = new StringBuilder();
        sb.append("mak.submit('").append(this.getFormIdentifier()).append("', '").append(ajax ? "true" : "false").append("', ").append(event == null ? "null" : event).append(", ").append(this.annotation == null ? "null" : "'" + this.annotation + "'").append(", ").append(this.annotationSeparator == null ? "null" : "'" + this.annotationSeparator + "'").append(");");
        return sb.toString();
    }

    public String getDefaultExpr(String fieldName) {
        switch (this.getResponderOperation(this.getOperation()).getOperationType()) {
            case EDIT: {
                return this.baseObject + "." + fieldName;
            }
        }
        return null;
    }

    public DataDefinition getDataTypeAtAnalysis(PageCache pageCache) {
        switch (this.getResponderOperation(this.getOperation()).getOperationType()) {
            case NEW: {
                return this.type;
            }
            case EDIT: {
                return this.fdp.getBasePointerType(this, pageCache, this.baseObject);
            }
        }
        return null;
    }

    public ResponderOperation getResponderOperation(String operation) {
        if (operation.equals("simple")) {
            return ResponderOperation.simepleOp;
        }
        throw new RuntimeException("Houston, problem");
    }

    public HashMap<String, MultipleKey> getNestedFormNames(PageCache pageCache) {
        return (HashMap)pageCache.retrieve("org.makumba.nestedFormNames", this.findRootForm().getTagKey());
    }

    public String getFormIdentifier() {
        if (this.formIdentifier == null) {
            this.formIdentifier = this.styleId != null ? this.styleId + this.getFormSuffixIdentifier() : this.getFormSuffixIdentifier().toString();
        }
        return this.formIdentifier;
    }

    public Object getFormSuffixIdentifier() {
        Object count = this.pageContext.getAttribute(__MAKUMBA__FORM__COUNTER__);
        if (count == null) {
            return "_form1";
        }
        return "_form" + this.pageContext.getAttribute(__MAKUMBA__FORM__COUNTER__);
    }

    private Integer updateFormId() {
        Integer formCount = (Integer)this.pageContext.getAttribute(__MAKUMBA__FORM__COUNTER__);
        formCount = formCount == null ? Integer.valueOf(1) : Integer.valueOf(formCount + 1);
        this.pageContext.setAttribute(__MAKUMBA__FORM__COUNTER__, (Object)formCount);
        return formCount;
    }
}

