/*
 * Decompiled with CFR 0.152.
 */
package org.makumba.providers.datadefinition.mdd;

import antlr.collections.AST;
import java.util.HashMap;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.makumba.DataDefinition;
import org.makumba.DataDefinitionNotFoundError;
import org.makumba.MakumbaError;
import org.makumba.providers.datadefinition.mdd.ComparisonExpressionNode;
import org.makumba.providers.datadefinition.mdd.FieldNode;
import org.makumba.providers.datadefinition.mdd.FieldType;
import org.makumba.providers.datadefinition.mdd.FunctionNode;
import org.makumba.providers.datadefinition.mdd.MDDFactory;
import org.makumba.providers.datadefinition.mdd.MDDNode;
import org.makumba.providers.datadefinition.mdd.MDDPostProcessorBaseWalker;
import org.makumba.providers.datadefinition.mdd.MDDProvider;
import org.makumba.providers.datadefinition.mdd.TitleFieldNode;
import org.makumba.providers.datadefinition.mdd.ValidationRuleNode;
import org.makumba.providers.datadefinition.mdd.validation.ComparisonValidationRule;
import org.makumba.providers.datadefinition.mdd.validation.MultiUniquenessValidationRule;
import org.makumba.providers.query.mql.HqlParser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MDDPostProcessorWalker
extends MDDPostProcessorBaseWalker {
    private MDDFactory factory = null;
    private HashMap<String, FieldNode> typeShorthands;
    private static final Pattern ident = Pattern.compile("[a-zA-Z]\\w*");

    public MDDPostProcessorWalker(String typeName, MDDNode mdd, HashMap<String, FieldNode> typeShorthands, MDDFactory factory) {
        this.typeName = typeName;
        this.mdd = mdd;
        this.typeShorthands = typeShorthands;
        this.factory = factory;
    }

    @Override
    protected void processUnknownType(AST field) {
        FieldNode fieldNode = (FieldNode)((Object)field);
        FieldNode type = this.typeShorthands.get(fieldNode.unknownType);
        if (type == null) {
            this.factory.doThrow(this.typeName, "Unknown field type: " + fieldNode.unknownType, (AST)field);
        } else {
            fieldNode.makumbaType = type.makumbaType;
            if (fieldNode.makumbaType == FieldType.INTENUM || fieldNode.makumbaType == FieldType.SETINTENUM) {
                fieldNode.intEnumValues = type.intEnumValues;
                fieldNode.intEnumValuesDeprecated = type.intEnumValuesDeprecated;
            } else if (fieldNode.makumbaType == FieldType.CHARENUM || fieldNode.makumbaType == FieldType.SETCHARENUM) {
                fieldNode.charEnumValues = type.charEnumValues;
                fieldNode.charEnumValuesDeprecated = type.charEnumValuesDeprecated;
            }
            if (fieldNode.makumbaType == FieldType.SETCHARENUM || fieldNode.makumbaType == FieldType.SETINTENUM) {
                fieldNode.subfield = type.subfield;
            }
        }
        field = fieldNode;
    }

    @Override
    protected void checkTitleField(AST titleField) {
        TitleFieldNode title = (TitleFieldNode)titleField;
        switch (title.titleType) {
            case 46: {
                this.checkPathValid(titleField, title.getText(), title.mdd);
                break;
            }
            case 48: {
                if (title.functionArgs.size() > 0) {
                    this.factory.doThrow(this.typeName, "There's no support for function calls with arguments in the !title directive yet", titleField);
                    break;
                }
                if (this.mdd.functions.get(title.functionName) != null) break;
                this.factory.doThrow(this.typeName, "Function " + title.functionName + " not defined in type " + this.typeName, titleField);
                break;
            }
            default: {
                throw new MakumbaError("invalid title field type: " + title.titleType);
            }
        }
    }

    private String checkPathValid(AST ast, String t, MDDNode mddNode) {
        String type = "";
        if (t.indexOf(".") > -1) {
            while (t.indexOf(".") > -1) {
                FieldNode n;
                String field = t.substring(0, t.indexOf("."));
                String fieldInPointed = t = t.substring(t.indexOf(".") + 1);
                if (fieldInPointed.indexOf(".") > -1) {
                    fieldInPointed = fieldInPointed.substring(0, fieldInPointed.indexOf("."));
                }
                if ((n = mddNode.fields.get(field)) == null) {
                    this.factory.doThrow(this.typeName, "Field " + field + " does not exist in type " + this.mdd.getName(), ast);
                    continue;
                }
                if (n.makumbaType != FieldType.PTRREL && n.makumbaType != FieldType.PTR && n.makumbaType != FieldType.PTRONE) {
                    this.factory.doThrow(this.typeName, "Field " + field + " is not a pointer", ast);
                    continue;
                }
                try {
                    DataDefinition pointed = MDDProvider.getMDD(n.pointedType);
                    if (pointed.getFieldDefinition(fieldInPointed) == null) {
                        this.factory.doThrow(this.typeName, "Field " + fieldInPointed + " does not exist in type " + pointed.getName(), ast);
                        continue;
                    }
                    type = pointed.getFieldDefinition(fieldInPointed).getType();
                }
                catch (DataDefinitionNotFoundError d) {
                    this.factory.doThrow(this.typeName, "Could not find type " + n.pointedType, ast);
                }
            }
        } else {
            FieldNode field = mddNode.fields.get(t);
            if (field == null) {
                this.factory.doThrow(this.typeName, "Field " + t + " does not exist in type " + this.mdd.getName(), ast);
            } else {
                type = field.makumbaType.getTypeName();
            }
        }
        return type;
    }

    @Override
    protected void processValidationDefinitions(ValidationRuleNode v, AST v_in) {
        if (v instanceof MultiUniquenessValidationRule) {
            boolean keyOverSubfield = false;
            for (String path : v.arguments) {
                this.checkPathValid(v_in, path, v.mdd);
                keyOverSubfield = path.indexOf(".") > -1;
            }
            DataDefinition.MultipleUniqueKeyDefinition key = new DataDefinition.MultipleUniqueKeyDefinition(v.arguments.toArray(new String[0]), v.message);
            key.setKeyOverSubfield(keyOverSubfield);
            this.mdd.addMultiUniqueKey(key);
        } else if (v instanceof ComparisonValidationRule) {
            ComparisonExpressionNode ce = v.comparisonExpression;
            ComparisonExpressionNode.ComparisonType lhs_type = this.getPartType(ce, ce.getLhs_type(), ce.getLhs(), v.field);
            ComparisonExpressionNode.ComparisonType rhs_type = this.getPartType(ce, ce.getRhs_type(), ce.getRhs(), v.field);
            if (!rhs_type.equals((Object)rhs_type)) {
                this.factory.doThrow(this.typeName, "Invalid comparison expression: left-hand side type is " + lhs_type.name().toLowerCase() + ", right-hand side type is " + rhs_type.name().toLowerCase(), (AST)ce);
            }
            ce.setComparisonType(lhs_type);
            for (String arg : v.arguments) {
                if (ce.getLhs().equals(arg) || ce.getRhs().equals(arg)) continue;
                this.factory.doThrow(this.typeName, "Argument '" + arg + "' is not being used in the comparison expression", (AST)ce);
            }
            if (ce.getLhs_type() == 61 && !v.arguments.contains(ce.getLhs())) {
                this.factory.doThrow(this.typeName, "Field '" + ce.getLhs() + "' not an argument of the comparison expression", (AST)ce);
            }
            if (ce.getRhs_type() == 61 && !v.arguments.contains(ce.getRhs())) {
                this.factory.doThrow(this.typeName, "Field '" + ce.getRhs() + "' not an argument of the comparison expression", (AST)ce);
            }
        }
    }

    private ComparisonExpressionNode.ComparisonType getPartType(ComparisonExpressionNode ce, int type, String path, FieldNode parentField) {
        switch (type) {
            case 44: 
            case 45: {
                return ComparisonExpressionNode.ComparisonType.STRING;
            }
            case 42: 
            case 43: 
            case 77: {
                return ComparisonExpressionNode.ComparisonType.DATE;
            }
            case 31: 
            case 32: 
            case 33: {
                return ComparisonExpressionNode.ComparisonType.NUMBER;
            }
            case 61: {
                String fieldType = "";
                fieldType = parentField != null && parentField.subfield != null ? this.checkPathValid((AST)ce, path, parentField.subfield) : this.checkPathValid((AST)ce, path, this.mdd);
                FieldType ft = FieldType.valueOf(fieldType.toUpperCase());
                switch (ft) {
                    case CHAR: 
                    case TEXT: {
                        return ComparisonExpressionNode.ComparisonType.STRING;
                    }
                    case INT: 
                    case REAL: {
                        return ComparisonExpressionNode.ComparisonType.NUMBER;
                    }
                    case DATE: 
                    case DATECREATE: 
                    case DATEMODIFY: {
                        return ComparisonExpressionNode.ComparisonType.DATE;
                    }
                }
                return ComparisonExpressionNode.ComparisonType.INVALID;
            }
        }
        throw new RuntimeException("could not compute comparison part type of type " + ce.toString());
    }

    @Override
    protected void analyzeFunction(FunctionNode f) {
        this.preProcessFunction(f);
    }

    private void preProcessFunction(FunctionNode funct) {
        DataDefinition.QueryFragmentFunction f = funct.function;
        StringBuffer sb = new StringBuffer();
        String queryFragment = funct.queryFragment;
        Matcher m = ident.matcher(queryFragment);
        boolean found = false;
        while (m.find()) {
            String id = queryFragment.substring(m.start(), m.end());
            int after = -1;
            for (int index = m.end(); index < queryFragment.length(); ++index) {
                char c = queryFragment.charAt(index);
                if (c == ' ' || c == '\t') continue;
                after = c;
                break;
            }
            int before = -1;
            for (int index = m.start() - 1; index >= 0; --index) {
                char c = queryFragment.charAt(index);
                if (c == ' ' || c == '\t') continue;
                before = c;
                break;
            }
            if (before == 46 || id.equals("this") || funct.parameters.getFieldDefinition(id) != null || this.mdd.fields.get(id) == null && (after != 40 || this.mdd.functions.get(id) == null)) continue;
            m.appendReplacement(sb, "this." + id);
            found = true;
        }
        m.appendTail(sb);
        if (found) {
            Logger.getLogger("org.makumba.db.query.inline").fine(queryFragment + " -> " + sb.toString());
            boolean subquery = sb.toString().toUpperCase().startsWith("SELECT ");
            String query = "SELECT " + (subquery ? "(" : "") + sb.toString() + (subquery ? ")" : "") + " FROM " + this.typeName + " makumbaGeneratedAlias";
            HqlParser parser = null;
            try {
                parser = HqlParser.getInstance(query);
                parser.statement();
            }
            catch (Throwable t) {
                throw new RuntimeException("ok now this should not have happened.");
            }
            funct.function = new DataDefinition.QueryFragmentFunction(f.getName(), f.getSessionVariableName(), sb.toString(), f.getParameters(), f.getErrorMessage(), parser.getAST());
            this.mdd.functions.put(funct.function.getName(), funct.function);
        }
    }
}

