/*
 * Decompiled with CFR 0.152.
 */
package org.makumba.devel;

import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Date;
import java.util.logging.Logger;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.makumba.LogicNotFoundException;
import org.makumba.ProgrammerError;
import org.makumba.analyser.engine.JspParseData;
import org.makumba.analyser.engine.SourceSyntaxPoints;
import org.makumba.analyser.engine.SyntaxPoint;
import org.makumba.analyser.engine.TomcatJsp;
import org.makumba.controller.Logic;
import org.makumba.devel.DevelUtils;
import org.makumba.devel.ErrorControllerHandler;
import org.makumba.devel.JspxJspAnalyzer;
import org.makumba.devel.LineViewer;
import org.makumba.providers.Configuration;

public class jspViewer
extends LineViewer {
    boolean hasLogic;
    protected SyntaxPoint[] sourceSyntaxPoints;
    protected SourceSyntaxPoints syntaxPoints;
    private boolean hideComments = false;
    private boolean hideHTML = false;
    private boolean hideJSTLCore = false;
    private boolean hideJSTLFormat = false;
    private boolean hideMakumba = false;
    private boolean hideJava = false;

    private int extraLength() {
        return 1;
    }

    public jspViewer(HttpServletRequest req, boolean printLineNumbers) throws Exception {
        super(printLineNumbers, req);
        this.setSearchLevels(true, false, false, true);
        this.hideLineNumbers = this.request.getParameter("hideLines") == null || this.request.getParameter("hideLines").equals("true");
    }

    public jspViewer(HttpServletRequest req) throws Exception {
        super(true, req);
        this.setSearchLevels(true, false, false, true);
        this.hideComments = Boolean.valueOf(String.valueOf(req.getParameter("hideComments")));
        this.hideHTML = Boolean.valueOf(String.valueOf(req.getParameter("hideHTML")));
        this.hideJSTLCore = Boolean.valueOf(String.valueOf(req.getParameter("hideJSTLCore")));
        this.hideJSTLFormat = Boolean.valueOf(String.valueOf(req.getParameter("hideJSTLFormat")));
        this.hideMakumba = Boolean.valueOf(String.valueOf(req.getParameter("hideMakumba")));
        this.hideJava = Boolean.valueOf(String.valueOf(req.getParameter("hideJava")));
        ServletContext servletContext = this.request.getSession().getServletContext();
        String thisFile = TomcatJsp.getJspURI(req);
        thisFile = thisFile.substring(0, thisFile.length() - 1);
        this.contextPath = req.getContextPath();
        String _servletPath = req.getServletPath();
        this.virtualPath = _servletPath.substring(0, _servletPath.length() - this.extraLength());
        this.jspSourceViewExtension = _servletPath.substring(_servletPath.length() - this.extraLength());
        this.realPath = servletContext.getRealPath(this.virtualPath);
        _servletPath = _servletPath.substring(0, _servletPath.indexOf(".")) + ".jsp";
        this.logicPath = this.contextPath + Configuration.getLogicDiscoveryViewerLocation() + _servletPath;
        this.hasLogic = !(Logic.getLogic(_servletPath) instanceof LogicNotFoundException);
        this.jspClasspath = TomcatJsp.getContextCompiledJSPDir(servletContext);
        JspParseData jspParseData = new JspParseData(servletContext.getRealPath("/"), thisFile, JspxJspAnalyzer.getInstance());
        try {
            this.sourceSyntaxPoints = jspParseData.getSyntaxPointArray(null);
            if (jspParseData.isUsingHibernate()) {
                this.additionalCodeStyleClasses = "hibernatePage";
            }
            this.syntaxPoints = jspParseData.getSyntaxPoints();
        }
        catch (ProgrammerError e) {
            this.caughtError = e;
        }
        String compiledJSPFile = this.findCompiledJSPClassName(TomcatJsp.getFullCompiledJSPDir(servletContext), this.virtualPath);
        if (compiledJSPFile != null) {
            this.additionalHeaderInfo = "<a style=\"font-size:smaller;\" href=\"" + this.request.getContextPath() + Configuration.getJavaViewerLocation() + "/" + compiledJSPFile + "\">[Compiled Version]</a>";
        }
        this.reader = new FileReader(this.realPath);
    }

    public void intro(PrintWriter w) throws IOException {
        w.println("<td align=\"right\" style=\"color: darkblue; padding: 5px; padding-top: 10px\">");
        this.printFileRelations(w);
        w.println("&nbsp;&nbsp;&nbsp;");
        String executePath = this.contextPath + this.virtualPath;
        if (StringUtils.isNotEmpty((String)this.request.getQueryString())) {
            executePath = executePath + "?" + this.request.getQueryString();
        }
        w.println("<a href=\"" + executePath + "\">execute</a>&nbsp;&nbsp;&nbsp;");
        w.println("<span style=\"color:lightblue; background-color: darkblue; padding: 5px;\">source</span>&nbsp;&nbsp;&nbsp;");
        w.println("<a href=\"" + this.logicPath + "\">business logic" + (this.hasLogic ? "" : " (none)") + "</a>");
        String lg = ErrorControllerHandler.getLoginPage(this.request, this.virtualPath);
        if (lg != null) {
            w.println("&nbsp;&nbsp;&nbsp;<a href=\"" + this.contextPath + lg + "x\">login page</a>&nbsp;&nbsp;&nbsp;");
        }
        w.println("&nbsp;&nbsp;&nbsp;");
        DevelUtils.writeDevelUtilLinks(w, "", this.contextPath);
        w.println("</td>");
        w.println("</tr>");
        w.println("<tr>");
        w.println("<td align=\"right\" style=\" font-size: smaller;\">");
        w.println("<form method=\"get\" action>");
        w.println("Hide: <input type=\"checkbox\" name=\"hideComments\" value=\"true\"" + (this.hideComments ? " checked=\"checked\"" : "") + ">Comments  ");
        w.println("<input type=\"checkbox\" name=\"hideHTML\" value=\"true\"" + (this.hideHTML ? " checked=\"checked\"" : "") + ">HTML  ");
        w.println("<input type=\"checkbox\" name=\"hideJava\" value=\"true\"" + (this.hideJava ? " checked=\"checked\"" : "") + ">Java  ");
        w.println("<input type=\"checkbox\" name=\"hideJSTLCore\" value=\"true\"" + (this.hideJSTLCore ? " checked=\"checked\"" : "") + ">JSTL Core  ");
        w.println("<input type=\"checkbox\" name=\"hideJSTLFormat\" value=\"true\"" + (this.hideJSTLFormat ? " checked=\"checked\"" : "") + ">JSTL Format  ");
        w.println("<input type=\"checkbox\" name=\"hideMakumba\" value=\"true\"" + (this.hideMakumba ? " checked=\"checked\"" : "") + ">Makumba  ");
        w.println("<input type=\"submit\" value=\"apply\"> ");
        w.println("</form>");
        w.println("</td>");
    }

    public void parseText(PrintWriter writer) throws IOException {
        if (this.sourceSyntaxPoints == null) {
            super.parseText(writer);
            return;
        }
        Date begin = new Date();
        this.printPageBegin(writer);
        SyntaxPoint lastSyntaxPoint = null;
        boolean shallWrite = true;
        boolean lastShallWrite = false;
        int inTag = 0;
        StringBuffer currentText = new StringBuffer();
        for (int j = 0; this.sourceSyntaxPoints != null && j < this.sourceSyntaxPoints.length; ++j) {
            SyntaxPoint currentSyntaxPoint = this.sourceSyntaxPoints[j];
            String type = currentSyntaxPoint.getType();
            int currentLine = currentSyntaxPoint.getLine();
            String lineText = this.syntaxPoints.getLineText(currentLine);
            int currentLineLength = lineText.length();
            if (currentSyntaxPoint.getOriginalColumn(currentLineLength) > this.syntaxPoints.getLineText(currentLine).length() + 1) {
                Logger.getLogger("org.makumba.org.makumba.devel.sourceViewer").finest("skipped syntax Point due to wrong offset: " + (currentSyntaxPoint.isBegin() ? "begin " : "end ") + currentSyntaxPoint.getType() + " " + currentSyntaxPoint.getLine() + ":" + currentSyntaxPoint.getColumn() + ":; linelength is: " + this.syntaxPoints.getLineText(currentLine).length());
                continue;
            }
            if (type.equals("TextLine") && currentSyntaxPoint.isBegin()) {
                lastSyntaxPoint = currentSyntaxPoint;
                continue;
            }
            if (type.equals("TextLine") && !currentSyntaxPoint.isBegin()) {
                if (currentSyntaxPoint.getOriginalColumn(currentLineLength) > 1 && (!this.hideHTML || inTag > 0) && shallWrite) {
                    currentText.append(this.parseLine(this.htmlEscape(lineText.substring(lastSyntaxPoint.getOriginalColumn(currentLineLength) - 1, currentSyntaxPoint.getOriginalColumn(currentLineLength) - 1))));
                }
                if ((!currentText.toString().trim().equals("") || inTag < 1 && !this.hideHTML || inTag > 0 && shallWrite) && this.printLineNumbers) {
                    writer.print("\n");
                    if (!this.hideLineNumbers) {
                        writer.print("<a style=\"font-weight: normal; \" name=\"" + currentLine + "\" href=\"#" + currentLine + "\" class=\"lineNo\">" + currentLine + ":\t</a>");
                    }
                }
                writer.print(currentText.toString());
                currentText = new StringBuffer();
                lastSyntaxPoint = currentSyntaxPoint;
                continue;
            }
            if (!this.isTagToHighlight(type)) continue;
            if (currentSyntaxPoint.isBegin()) {
                if (++inTag > 1) {
                    lastShallWrite = shallWrite;
                    if (lastShallWrite) {
                        currentText.append(this.parseLine(this.htmlEscape(lineText.substring(lastSyntaxPoint.getOriginalColumn(currentLineLength) - 1, currentSyntaxPoint.getOriginalColumn(currentLineLength) - 1))));
                    }
                } else if (currentSyntaxPoint.getOriginalColumn(currentLineLength) > 1 && !this.hideHTML && shallWrite) {
                    currentText.append(this.parseLine(this.htmlEscape(lineText.substring(lastSyntaxPoint.getOriginalColumn(currentLineLength) - 1, currentSyntaxPoint.getOriginalColumn(currentLineLength) - 1))));
                }
                String tagType = lineText.substring(currentSyntaxPoint.getOriginalColumn(currentLineLength));
                if (type.equals("JspScriptlet")) {
                    if (this.hideJava) {
                        shallWrite = false;
                    } else {
                        currentText.append("<span class=\"jspScriptlet\">");
                    }
                } else if (type.equals("JspComment")) {
                    if (this.hideComments) {
                        shallWrite = false;
                    } else {
                        currentText.append("<span class=\".jspComment\">");
                    }
                } else if (type.equals("JSPSystemTag")) {
                    currentText.append("<span class=\".jspSystemTag\">");
                } else if (type.equals("ExpressionLanguage")) {
                    currentText.append("<span class=\".expressionLanguage\">");
                } else {
                    if ((tagType.startsWith("mak") || tagType.startsWith("/mak")) && this.hideMakumba || (tagType.startsWith("c") || tagType.startsWith("/c")) && this.hideJSTLCore || (tagType.startsWith("fmt") || tagType.startsWith("/fmt")) && this.hideJSTLFormat) {
                        shallWrite = false;
                    }
                    if (shallWrite) {
                        String tagClass = tagType;
                        if (tagClass.contains(":")) {
                            tagClass = tagClass.substring(0, tagType.indexOf(":")) + "Tag";
                        }
                        if (tagClass.startsWith("/")) {
                            tagClass = tagClass.substring(1);
                        }
                        currentText.append("<span class=\"" + tagClass + "\">");
                    }
                }
                lastSyntaxPoint = currentSyntaxPoint;
                continue;
            }
            if (shallWrite) {
                currentText.append(this.parseLine(this.htmlEscape(lineText.substring(lastSyntaxPoint.getOriginalColumn(currentLineLength) - 1, currentSyntaxPoint.getOriginalColumn(currentLineLength) - 1))));
                currentText.append("</span>");
            }
            shallWrite = inTag > 1 ? lastShallWrite : true;
            lastSyntaxPoint = currentSyntaxPoint;
            --inTag;
        }
        this.printPageEnd(writer);
        double time = new Date().getTime() - begin.getTime();
        Logger.getLogger("org.makumba.org.makumba.devel.sourceViewer").finer("Sourcecode viewer took :" + time / 1000.0 + " seconds");
    }

    private boolean isTagToHighlight(String type) {
        return type.equals("JspTagBegin") || type.equals("JspTagEnd") || type.equals("JspTagSimple") || type.equals("ExpressionLanguage") || this.isSystemtag(type);
    }

    private boolean isSystemtag(String type) {
        return type.equals("JspComment") || type.equals("JspScriptlet") || type.equals("JSPSystemTag");
    }

    protected void printPageBeginAdditional(PrintWriter writer) throws IOException {
        super.printPageBeginAdditional(writer);
    }
}

