/*
 * Decompiled with CFR 0.152.
 */
package org.makumba.forms.responder;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.logging.Logger;
import javax.servlet.FilterConfig;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang.ArrayUtils;
import org.makumba.CompositeValidationException;
import org.makumba.InvalidValueException;
import org.makumba.commons.ControllerHandler;
import org.makumba.commons.ServletObjects;
import org.makumba.commons.StringUtils;
import org.makumba.forms.responder.FormResponder;
import org.makumba.forms.responder.Responder;
import org.makumba.forms.responder.ResponderFactory;

public class ResponseControllerHandler
extends ControllerHandler {
    public static final String MAKUMBA_FORM_VALIDATION_ERRORS = "__makumba__formValidationErrors__";
    public static final String MAKUMBA_FORM_RELOAD = "__makumba__formReload__";
    public static final String MAKUMBA_FORM_ID = "__makumba__formId__";
    public static final String MAKUMBA_FORM_PARTIAL_POSTBACK_EVENT = "__makumba__formPartialPostbackEvent__";
    public static final String MAKUMBA_FORM_RELOAD_PARAMS = "__makumba__formReload__parameters__";
    private ResponderFactory factory = ResponderFactory.getInstance();
    final Logger logger = Logger.getLogger("org.makumba.controller");

    public boolean beforeFilter(ServletRequest req, ServletResponse resp, FilterConfig conf, ServletObjects httpServletObjects) throws Exception {
        boolean ajaxFormSubmission;
        Exception e = this.factory.getResponse((HttpServletRequest)req, (HttpServletResponse)resp);
        FormResponder responder = (FormResponder)this.factory.getFirstResponder(req);
        boolean bl = ajaxFormSubmission = responder != null && responder.triggerEvent != null;
        if (ajaxFormSubmission) {
            req.setAttribute(MAKUMBA_FORM_PARTIAL_POSTBACK_EVENT, (Object)responder.triggerEvent);
            req.setAttribute(MAKUMBA_FORM_ID, (Object)responder.formId);
        }
        if (e instanceof CompositeValidationException) {
            String message;
            CompositeValidationException v = (CompositeValidationException)e;
            req.setAttribute(MAKUMBA_FORM_VALIDATION_ERRORS, (Object)v);
            req.setAttribute(MAKUMBA_FORM_RELOAD, (Object)"true");
            this.logger.fine("Caught a CompositeValidationException, reloading form page: " + responder.getReloadFormOnError());
            HttpServletRequest httpServletRequest = (HttpServletRequest)req;
            String absoluteAction = httpServletRequest.getRequestURI();
            boolean shallReload = ResponseControllerHandler.shallReload(responder.getReloadFormOnError(), responder.getAction(), absoluteAction, responder.getOriginatingPageName(), responder.getTriggerEvent());
            this.logger.fine("Form submission failed, operation: " + responder.operation + ", reloadForm: " + responder.getReloadFormOnError() + ", will reload: " + shallReload);
            if (shallReload || ResponseControllerHandler.submittingToSamePage(responder.getOriginatingPageName(), absoluteAction) || ajaxFormSubmission) {
                this.logger.fine("CompositeValidationException: annotating form: " + responder.getShowFormAnnotated());
                if (responder.getShowFormAnnotated()) {
                    this.logger.finer("Processing CompositeValidationException for annotation:\n" + v.toString());
                    ArrayList<InvalidValueException> unassignedExceptions = this.factory.getUnassignedExceptions(v, (HttpServletRequest)req);
                    this.logger.finer("Exceptions not assigned:\n" + StringUtils.toString(unassignedExceptions));
                    message = "";
                    Iterator<InvalidValueException> i$ = unassignedExceptions.iterator();
                    while (i$.hasNext()) {
                        InvalidValueException invalidValueException;
                        InvalidValueException invEx = invalidValueException = i$.next();
                        message = message + invEx.getMessage() + "<br>";
                    }
                } else {
                    message = v.toString();
                }
            } else {
                message = v.toString();
            }
            req.setAttribute("makumba.response", (Object)message);
            req.setAttribute("makumba.responseFormatted", (Object)Responder.errorMessageFormatter(message));
            if (shallReload) {
                HttpSession session = httpServletRequest.getSession();
                String originatingPageName = responder.getOriginatingPageName();
                int k = originatingPageName.indexOf("?");
                if (k > -1) {
                    originatingPageName = originatingPageName.substring(0, k);
                }
                String suffix = "_" + originatingPageName;
                Object[] attributes = ResponderFactory.RESPONSE_ATTRIBUTE_NAMES;
                attributes = (String[])ArrayUtils.add((Object[])attributes, (Object)MAKUMBA_FORM_VALIDATION_ERRORS);
                for (Object attr : attributes = (String[])ArrayUtils.add((Object[])attributes, (Object)MAKUMBA_FORM_RELOAD)) {
                    session.setAttribute((String)attr + suffix, req.getAttribute((String)attr));
                    this.logger.fine("Setting '" + (String)attr + suffix + "' value: '" + req.getAttribute((String)attr) + "'.");
                }
                HashMap paramMap = new HashMap();
                paramMap.putAll(req.getParameterMap());
                paramMap.remove("__makumba__responder__");
                session.setAttribute(MAKUMBA_FORM_RELOAD_PARAMS + suffix, paramMap);
                this.logger.fine("Sending redirect from '" + httpServletRequest.getRequestURI() + "' to '" + responder.getOriginatingPageName() + "'.");
                ((HttpServletResponse)resp).sendRedirect(responder.getOriginatingPageName());
            }
        }
        return true;
    }

    private ServletResponse getFormReloadResponse(ServletResponse resp, final String root, Responder responder) {
        resp = new HttpServletResponseWrapper((HttpServletResponse)resp){

            public void sendRedirect(String s) throws IOException {
                if (root != null && ResponseControllerHandler.submittingToSamePage(root, s)) {
                    s = s.substring(root.length());
                }
                ((HttpServletResponse)this.getResponse()).sendRedirect(s);
            }
        };
        return resp;
    }

    private ServletRequest getFormReloadRequest(ServletRequest req, final Responder responder) {
        req = new HttpServletRequestWrapper((HttpServletRequest)req){

            public String getServletPath() {
                HttpServletRequest httpServletRequest = (HttpServletRequest)this.getRequest();
                String originatingPage = responder.getOriginatingPageName();
                String contextPath = httpServletRequest.getContextPath();
                if (ResponseControllerHandler.submittingToSamePage(contextPath, originatingPage)) {
                    originatingPage = originatingPage.substring(contextPath.length());
                }
                if (originatingPage.indexOf("?") > 0) {
                    originatingPage = originatingPage.substring(0, originatingPage.indexOf("?"));
                }
                return originatingPage;
            }

            public String getRequestURI() {
                String originatingPage = responder.getOriginatingPageName();
                return originatingPage;
            }
        };
        return req;
    }

    public static boolean shallReload(boolean reloadFormOnError, String action, String absoluteAction, String originatingPageName, String triggerEvent) {
        return reloadFormOnError && org.apache.commons.lang.StringUtils.isNotBlank((String)action) && !ResponseControllerHandler.submittingToSamePage(absoluteAction, originatingPageName) && org.apache.commons.lang.StringUtils.isBlank((String)triggerEvent);
    }

    private static boolean submittingToSamePage(String absoluteAction, String originatingPageName) {
        return originatingPageName.startsWith(absoluteAction);
    }

    public static void main(String[] args) throws IOException {
        System.out.println(StringUtils.getAbsolutePath("/test/forms-oql/abc.", "../action.jsp"));
        System.out.println(StringUtils.getAbsolutePath("/test/forms-oql/", "../action.jsp"));
        System.out.println(StringUtils.getAbsolutePath("/test/forms-oql/", "../forms-oql/action.jsp"));
        System.out.println(StringUtils.getAbsolutePath("/", "../forms-oql/action.jsp"));
        System.out.println(StringUtils.getAbsolutePath("", "../action.jsp"));
    }
}

