/*
 * Decompiled with CFR 0.152.
 */
package org.makumba.providers.query.hql;

import antlr.RecognitionException;
import antlr.SemanticException;
import antlr.collections.AST;
import java.util.Map;
import org.makumba.providers.query.hql.ExprTypeAST;
import org.makumba.providers.query.hql.ObjectType;

public class ObjectTypeAST
extends ExprTypeAST {
    private static final long serialVersionUID = 1L;
    private String objectType;

    public ObjectTypeAST(AST lhs, AST rhs, Map aliasTypes, ObjectType typeComputer) throws RecognitionException {
        super(-2);
        String type = null;
        if (lhs instanceof ObjectTypeAST) {
            type = ((ObjectTypeAST)lhs).getObjectType();
            if (type == null) {
                throw new SemanticException("unknown alias: " + lhs + " in property reference: " + "of " + rhs);
            }
        } else {
            type = (String)aliasTypes.get(lhs.getText());
            if (type == null) {
                throw new SemanticException("unknown alias: " + lhs.getText() + " in property reference: " + lhs.getText() + "." + rhs.getText());
            }
        }
        Object computedType = "";
        if (rhs == null) {
            computedType = typeComputer.determineType(type, null);
        } else {
            this.setDescription(rhs.getText());
            computedType = typeComputer.determineType(type, rhs.getText());
        }
        if (computedType instanceof String) {
            this.setObjectType(computedType.toString());
        } else {
            this.setExtraTypeInfo(computedType);
            this.setDataType(typeComputer.getTypeOf(computedType));
        }
    }

    public ObjectTypeAST(AST pointer, Map aliasTypes) throws SemanticException {
        String type = (String)aliasTypes.get(pointer.getText());
        if (type == null) {
            throw new SemanticException("unknown alias: " + pointer.getText());
        }
        this.setObjectType(type);
        this.setDescription(pointer.getText());
    }

    public String getObjectType() {
        return this.objectType;
    }

    void setObjectType(String objectType) {
        this.objectType = objectType;
    }
}

