/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.xhtmldoclet.pages;

import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.Doc;
import com.sun.javadoc.ProgramElementDoc;
import com.sun.tools.doclets.internal.toolkit.util.Util;
import java.io.IOException;
import java.util.Arrays;
import java.util.Set;
import java.util.TreeSet;
import net.sourceforge.xhtmldoclet.AbstractPageWriter;
import net.sourceforge.xhtmldoclet.AbstractXhtmlWriter;
import net.sourceforge.xhtmldoclet.Doclet;

public final class AllClasses
extends AbstractPageWriter {
    private static Set<ClassDoc> includedClasses;

    public static void generateAllClasses() {
        ClassDoc[] classes = AllClasses.CONF.root.classes();
        includedClasses = new TreeSet<ClassDoc>(Arrays.asList(classes));
        String filename = null;
        try {
            filename = "allclasses-frame" + AllClasses.CONF.ext;
            new AllClasses(filename, true);
            filename = "allclasses-noframe" + AllClasses.CONF.ext;
            new AllClasses(filename, false);
        }
        catch (IOException exc) {
            throw Doclet.exception(exc, filename);
        }
    }

    private AllClasses(String filename, boolean includeFrameTargets) throws IOException {
        super(filename);
        this.pageType = "ALL_CLASSES";
        this.windowTitle = "All Classes";
        this.printXhtmlHeader(null, false);
        this.println((AbstractXhtmlWriter)this.new AbstractXhtmlWriter.TagBuilder("h3").getOpenTextClose("All Classes"));
        AbstractXhtmlWriter.TagBuilder linkTag = (AbstractXhtmlWriter)this.new AbstractXhtmlWriter.TagBuilder("a").add("target", includeFrameTargets ? "classFrame" : null);
        for (ClassDoc cd : includedClasses) {
            if (!Util.isCoreClass((ClassDoc)cd)) continue;
            linkTag.add("href", this.hrefToDoc((Doc)cd));
            linkTag.add("class", this.visibilityModifier((ProgramElementDoc)cd) + this.classFlavor(cd, true));
            linkTag.add("title", this.classFlavor(cd, false) + " in " + cd.containingPackage().name());
            this.println(linkTag.getOpenTextClose(cd.name()) + this.empty("br"));
        }
        this.printXhtmlFooter();
        this.close();
    }
}

