/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.xhtmldoclet.pages;

import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.Doc;
import com.sun.javadoc.FieldDoc;
import com.sun.javadoc.MemberDoc;
import com.sun.javadoc.PackageDoc;
import com.sun.tools.doclets.internal.toolkit.Configuration;
import com.sun.tools.doclets.internal.toolkit.util.Util;
import com.sun.tools.doclets.internal.toolkit.util.VisibleMemberMap;
import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import net.sourceforge.xhtmldoclet.AbstractPageWriter;
import net.sourceforge.xhtmldoclet.AbstractXhtmlWriter;
import net.sourceforge.xhtmldoclet.Doclet;

public final class ConstantValues
extends AbstractPageWriter {
    private Map mapPackageToClasses;
    private Map mapClassToConstFields;
    private boolean shortPackageNames;
    private String parsedPackageName;
    private Set printedPackageIndices;
    private Set printedPackageAnchors;

    public static void generateConstantValues() {
        String filename = "constant-values" + ConstantValues.CONF.ext;
        try {
            new ConstantValues(filename);
        }
        catch (IOException exc) {
            throw Doclet.exception(exc, filename);
        }
    }

    private ConstantValues(String filename) throws IOException {
        super(filename);
        this.shortPackageNames = ConstantValues.CONF.constantListMaxPackageComponents > 0;
        this.printedPackageIndices = new HashSet();
        this.printedPackageAnchors = new HashSet();
        this.pageType = "CONSTANTS";
        this.mapPackagesWithConstFields();
        this.windowTitle = ConstantValues.CONF.windowtitle.length() > 0 ? ConstantValues.CONF.windowtitle : CONF.propertyText("Constants_Summary", new Object[0]);
        this.printXhtmlHeader();
        this.println(this.open("h1") + CONF.propertyText("Constants_By_Package", new Object[0]) + this.close("h1"));
        this.printPackageLinks();
        this.printConstantSummaries();
        this.printXhtmlFooter();
        this.close();
    }

    private void mapPackagesWithConstFields() {
        PackageDoc[] packages = ConstantValues.CONF.packages;
        TreeSet<ClassDoc> classesWithConstFields = new TreeSet<ClassDoc>();
        this.mapPackageToClasses = new TreeMap();
        this.mapClassToConstFields = new TreeMap();
        classesWithConstFields = new TreeSet();
        for (int p = 0; p < packages.length; ++p) {
            PackageDoc pkg = packages[p];
            ClassDoc[] classes = pkg.name().length() > 0 ? pkg.allClasses() : ConstantValues.CONF.classDocCatalog.allClasses("&lt;Unnamed&gt;");
            for (int c = 0; c < classes.length; ++c) {
                SortedSet constantFields;
                ClassDoc classDoc = classes[c];
                if (!classDoc.isIncluded() || (constantFields = this.visibleConstantFieldsInClass(classDoc)) == null || constantFields.size() <= 0) continue;
                classesWithConstFields.add(classDoc);
                this.mapClassToConstFields.put(classDoc, constantFields);
            }
            if (classesWithConstFields.size() <= 0) continue;
            this.mapPackageToClasses.put(pkg, classesWithConstFields);
            classesWithConstFields = new TreeSet();
        }
        classesWithConstFields = null;
    }

    private SortedSet visibleConstantFieldsInClass(ClassDoc classDoc) {
        VisibleMemberMap visibleMemberMapFields = new VisibleMemberMap(classDoc, 2, ConstantValues.CONF.nodeprecated);
        List fields = visibleMemberMapFields.getLeafClassMembers((Configuration)CONF);
        if (fields == null) {
            return null;
        }
        TreeSet<FieldDoc> constantFields = new TreeSet<FieldDoc>();
        for (FieldDoc field : fields) {
            if (field.constantValueExpression() == null) continue;
            constantFields.add(field);
        }
        return constantFields;
    }

    private void printPackageLinks() {
        this.println(this.open("ul"));
        String unnamedPackageLink = this.linkToLabelHref("&lt;Unnamed&gt;", "#unnamed_package");
        for (PackageDoc pkg : this.mapPackageToClasses.keySet()) {
            String pkgName = pkg.name();
            if (this.shortPackageNames) {
                this.parsedPackageName = this.parsePackageName(pkgName);
                if (this.printedPackageIndices.contains(this.parsedPackageName)) continue;
                if (pkgName.length() == 0) {
                    this.println(this.listItem(unnamedPackageLink));
                    continue;
                }
                this.println(this.listItem(this.linkToLabelHref(this.parsedPackageName + ".*", "#" + this.parsedPackageName)));
                this.printedPackageIndices.add(this.parsedPackageName);
                continue;
            }
            this.println(this.listItem(this.linkToLabelHref(pkgName, "#" + pkgName)));
        }
        this.println(this.close("ul") + "\n");
    }

    private void printConstantSummaries() {
        for (PackageDoc pkg : this.mapPackageToClasses.keySet()) {
            String pkgName = pkg.name();
            this.parsedPackageName = this.parsePackageName(pkgName);
            if (this.shortPackageNames && !this.printedPackageAnchors.contains(this.parsedPackageName)) {
                this.println((AbstractXhtmlWriter)this.new AbstractXhtmlWriter.TagBuilder("a").add("name", this.parsedPackageName).getEmpty());
                this.printedPackageAnchors.add(this.parsedPackageName);
            }
            this.println(this.openDivWithID(pkgName));
            this.println(this.open("h2") + this.linkToPackage(pkg) + this.close("h2"));
            for (ClassDoc cd : (Set)this.mapPackageToClasses.get(pkg)) {
                String classHref = this.hrefToDoc((Doc)cd);
                this.println(this.open("h3") + this.linkToLabelHrefTargetTitle(cd.name(), classHref, null, this.classFlavor(cd, false) + " in " + pkg) + this.close("h3"));
                Iterator fields = ((Set)this.mapClassToConstFields.get(cd)).iterator();
                this.println(this.open("table"));
                while (fields.hasNext()) {
                    FieldDoc field = (FieldDoc)fields.next();
                    this.println(this.open("tr"));
                    this.printTDWithClass(field.modifiers() + " " + this.linkToType((MemberDoc)field), "prefix");
                    this.printTDWithClass(this.linkToLabelHrefName(field.name(), classHref + "#" + field.name(), field.qualifiedName()), "name");
                    this.printTDWithClass(Util.escapeHtmlChars((String)field.constantValueExpression()), "value");
                    this.println(this.close("tr"));
                }
                this.println(this.close("table"));
            }
            this.println(this.close("div") + this.getComment(pkgName) + "\n");
        }
    }

    private String parsePackageName(String pkgName) {
        int index = -1;
        for (int j = 0; j < ConstantValues.CONF.constantListMaxPackageComponents; ++j) {
            index = pkgName.indexOf(".", index + 1);
        }
        if (index != -1) {
            pkgName = pkgName.substring(0, index);
        }
        return pkgName;
    }
}

