/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.xhtmldoclet.pages;

import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.Doc;
import com.sun.javadoc.ExecutableMemberDoc;
import com.sun.javadoc.Parameter;
import com.sun.javadoc.ProgramElementDoc;
import com.sun.tools.doclets.internal.toolkit.util.DeprecatedAPIListBuilder;
import java.io.IOException;
import java.util.List;
import java.util.Vector;
import net.sourceforge.xhtmldoclet.AbstractPageWriter;
import net.sourceforge.xhtmldoclet.AbstractXhtmlWriter;
import net.sourceforge.xhtmldoclet.Doclet;

public final class DeprecatedList
extends AbstractPageWriter {
    private DeprecatedAPIListBuilder deprecatedAPI;
    private static final String[] ANCHORS = new String[]{"Interfaces", "Classes", "Enums", "Exceptions", "Errors", "Annotation_Types", "Fields", "Methods", "Constructors", "Enum_Constants", "Annotation_Type_Members"};

    public static void generateDeprecatedList() {
        if (DeprecatedList.CONF.nodeprecatedlist) {
            return;
        }
        String filename = "deprecated-list" + DeprecatedList.CONF.ext;
        try {
            new DeprecatedList(filename);
        }
        catch (IOException exc) {
            throw Doclet.exception(exc, filename);
        }
    }

    private DeprecatedList(String filename) throws IOException {
        super(filename);
        this.pageType = "DEPRECATED";
        this.deprecatedAPI = new DeprecatedAPIListBuilder(DeprecatedList.CONF.root);
        this.windowTitle = DeprecatedList.CONF.windowtitle.length() > 0 ? DeprecatedList.CONF.windowtitle : CONF.propertyText("Deprecated_List", new Object[0]);
        this.printXhtmlHeader();
        this.println(this.open("h1") + CONF.propertyText("Deprecated_List", new Object[0]) + this.close("h1"));
        this.println(this.openDivWithID("Summaries"));
        String[] headingKeys = new String[]{"Deprecated_Interfaces", "Deprecated_Classes", "Deprecated_Enums", "Deprecated_Exceptions", "Deprecated_Errors", "Deprecated_Annotation_Types", "Deprecated_Fields", "Deprecated_Methods", "Deprecated_Constructors", "Deprecated_Enum_Constants", "Deprecated_Annotation_TypeMembers"};
        for (int type = 0; type < 11; ++type) {
            if (!this.deprecatedAPI.hasDocumentation(type)) continue;
            this.println((AbstractXhtmlWriter)this.new AbstractXhtmlWriter.TagBuilder("h2").add("id", ANCHORS[type]).getOpenTextClose(CONF.propertyText(headingKeys[type], new Object[0])));
            this.printDeprecatedAPI(this.deprecatedAPI.getList(type), headingKeys[type]);
        }
        this.println(this.close("div") + this.getComment("Summaries"));
        this.printXhtmlFooter();
        this.close();
    }

    private void printDeprecatedAPI(List deprMembers, String headingKey) {
        if (deprMembers.size() > 0) {
            this.println(this.open("dl"));
            for (int i = 0; i < deprMembers.size(); ++i) {
                ProgramElementDoc member = (ProgramElementDoc)deprMembers.get(i);
                this.print(this.open("dt"));
                String label = member instanceof ClassDoc ? member.containingPackage().toString() : member.containingClass().toString();
                label = label + "." + this.bold(member.name());
                if (member instanceof ExecutableMemberDoc) {
                    Vector<String> params = new Vector<String>();
                    for (Parameter param : ((ExecutableMemberDoc)member).parameters()) {
                        params.add(param.typeName());
                    }
                    label = label + "(" + this.getJoinedStrings(params, ", ") + ")";
                }
                this.println(this.linkToLabelHref(label, this.hrefToDoc((Doc)member)));
                this.println(this.close("dt"));
                this.print(this.open("dd"));
                if (member.tags("deprecated").length > 0 && member.tags("deprecated")[0].inlineTags().length > 0) {
                    this.print(this.getCommentTagsString((Doc)member, member.tags("deprecated")[0].inlineTags(), false, false));
                }
                this.println(this.close("dd"));
            }
            this.println(this.close("dl"));
        }
    }

    protected void navLinkDeprecated() {
        this.println(this.listItemCurrent(DEPRECATED));
    }

    protected void navWithinPage() {
        Vector<String> sections = new Vector<String>();
        for (int type = 0; type < 11; ++type) {
            if (!this.deprecatedAPI.hasDocumentation(type)) continue;
            sections.add(this.linkToLabelHref(CONF.propertyText(ANCHORS[type], new Object[0]), "#" + ANCHORS[type]));
        }
        this.print(this.open("td id=\"WithinPage\""));
        this.printUnorderedListWithLast(sections);
        this.println(this.close("td"));
    }
}

