/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.xhtmldoclet.writers;

import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.Doc;
import com.sun.javadoc.PackageDoc;
import com.sun.javadoc.ProgramElementDoc;
import com.sun.tools.doclets.internal.toolkit.PackageSummaryWriter;
import com.sun.tools.doclets.internal.toolkit.util.DirectoryManager;
import com.sun.tools.doclets.internal.toolkit.util.Util;
import java.io.IOException;
import java.util.Arrays;
import net.sourceforge.xhtmldoclet.Config;
import net.sourceforge.xhtmldoclet.writers.HtmlDocletWriter;
import net.sourceforge.xhtmldoclet.writers.LinkInfoImpl;

public class PackageWriterImpl
extends HtmlDocletWriter
implements PackageSummaryWriter {
    protected PackageDoc prev;
    protected PackageDoc next;
    protected PackageDoc packageDoc;
    private static final String OUTPUT_FILE_NAME = "package-summary.html";

    public PackageWriterImpl(Config configuration, PackageDoc packageDoc, PackageDoc prev, PackageDoc next) throws IOException {
        super(configuration, DirectoryManager.getDirectoryPath((PackageDoc)packageDoc), OUTPUT_FILE_NAME, DirectoryManager.getRelativePath((String)packageDoc.name()));
        this.prev = prev;
        this.next = next;
        this.packageDoc = packageDoc;
    }

    public String getOutputFileName() {
        return OUTPUT_FILE_NAME;
    }

    public void writeSummaryHeader() {
    }

    public void writeSummaryFooter() {
    }

    public void writeClassesSummary(ClassDoc[] classes, String label) {
        if (classes.length > 0) {
            Arrays.sort(classes);
            this.tableIndexSummary();
            boolean printedHeading = false;
            for (int i = 0; i < classes.length; ++i) {
                if (!printedHeading) {
                    this.printFirstRow(label);
                    printedHeading = true;
                }
                if (!Util.isCoreClass((ClassDoc)classes[i]) || !this.configuration.isGeneratedDoc((Doc)classes[i])) continue;
                this.trBgcolorStyle("white", "TableRowColor");
                this.summaryRow(15);
                this.bold();
                this.printLink(new LinkInfoImpl(9, classes[i], false));
                this.boldEnd();
                this.summaryRowEnd();
                this.summaryRow(0);
                if (Util.isDeprecated((ProgramElementDoc)classes[i])) {
                    this.boldText("doclet.Deprecated");
                    if (classes[i].tags("deprecated").length > 0) {
                        this.space();
                        this.printSummaryDeprecatedComment((Doc)classes[i], classes[i].tags("deprecated")[0]);
                    }
                } else {
                    this.printSummaryComment((Doc)classes[i]);
                }
                this.summaryRowEnd();
                this.trEnd();
            }
            this.tableEnd();
            this.println("&nbsp;");
            this.p();
        }
    }

    protected void printFirstRow(String label) {
        this.tableHeaderStart("#CCCCFF");
        this.bold(label);
        this.tableHeaderEnd();
    }

    public void writePackageDescription() {
        if (this.packageDoc.inlineTags().length > 0) {
            this.anchor("package_description");
            this.h2(this.configuration.getText("doclet.Package_Description", this.packageDoc.name()));
            this.p();
            this.printInlineComment((Doc)this.packageDoc);
            this.p();
        }
    }

    public void writePackageTags() {
        this.printTags((Doc)this.packageDoc);
    }

    public void writePackageHeader(String heading) {
        String pkgName = this.packageDoc.name();
        String[] metakeywords = new String[]{pkgName + " " + "package"};
        this.printHtmlHeader(pkgName, metakeywords, true);
        this.navLinks(true);
        this.hr();
        this.writeAnnotationInfo(this.packageDoc);
        this.h2(this.configuration.getText("doclet.Package") + " " + heading);
        if (this.packageDoc.inlineTags().length > 0 && !this.configuration.nocomment) {
            this.printSummaryComment((Doc)this.packageDoc);
            this.p();
            this.bold(this.configuration.getText("doclet.See"));
            this.br();
            this.printNbsps();
            this.printHyperLink("", "package_description", this.configuration.getText("doclet.Description"), true);
            this.p();
        }
    }

    public void writePackageFooter() {
        this.hr();
        this.navLinks(false);
        this.printBottom();
        this.printBodyHtmlEnd();
    }

    protected void navLinkClassUse() {
        this.navCellStart();
        this.printHyperLink("package-use.html", "", this.configuration.getText("doclet.navClassUse"), true, "NavBarFont1");
        this.navCellEnd();
    }

    protected void navLinkPrevious() {
        if (this.prev == null) {
            this.printText("doclet.Prev_Package");
        } else {
            String path = DirectoryManager.getRelativePath((String)this.packageDoc.name(), (String)this.prev.name());
            this.printHyperLink(path + OUTPUT_FILE_NAME, "", this.configuration.getText("doclet.Prev_Package"), true);
        }
    }

    protected void navLinkNext() {
        if (this.next == null) {
            this.printText("doclet.Next_Package");
        } else {
            String path = DirectoryManager.getRelativePath((String)this.packageDoc.name(), (String)this.next.name());
            this.printHyperLink(path + OUTPUT_FILE_NAME, "", this.configuration.getText("doclet.Next_Package"), true);
        }
    }

    protected void navLinkTree() {
        this.navCellStart();
        this.printHyperLink("package-tree.html", "", this.configuration.getText("doclet.Tree"), true, "NavBarFont1");
        this.navCellEnd();
    }

    protected void navLinkPackage() {
        this.navCellRevStart();
        this.fontStyle("NavBarFont1Rev");
        this.boldText("doclet.Package");
        this.fontEnd();
        this.navCellEnd();
    }
}

