/*
 * Decompiled with CFR 0.152.
 */
package com.ecyrd.jspwiki;

import com.ecyrd.jspwiki.TextUtil;
import com.ecyrd.jspwiki.WikiException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.servlet.ServletContext;

public final class PropertyReader {
    private static final String DEFAULT_JSPWIKI_PROPERTIES = "/ini/default_jspwiki.properties";
    public static final String PARAM_PROPERTYFILE = "jspwiki.propertyfile";
    public static final String PARAM_PROPERTYFILE_CASCADEPREFIX = "jspwiki.propertyfile.cascade.";
    public static final String DEFAULT_PROPERTYFILE = "/WEB-INF/jspwiki.properties";
    private static final String PARAM_VAR_DECLARATION = "var.";
    private static final String PARAM_VAR_IDENTIFIER = "$";
    private static final String[] DEFAULT_PROPERTIES = new String[]{"jspwiki.specialPage.Login", "Login.jsp", "jspwiki.specialPage.Logout", "Logout.jsp", "jspwiki.specialPage.CreateGroup", "NewGroup.jsp", "jspwiki.specialPage.CreateProfile", "Register.jsp", "jspwiki.specialPage.EditProfile", "UserPreferences.jsp", "jspwiki.specialPage.Preferences", "UserPreferences.jsp", "jspwiki.specialPage.Search", "Search.jsp", "jspwiki.specialPage.FindPage", "FindPage.jsp"};

    private PropertyReader() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties loadWebAppProps(ServletContext context) {
        String propertyFile = context.getInitParameter(PARAM_PROPERTYFILE);
        InputStream propertyStream = null;
        try {
            if (propertyFile == null) {
                context.log("No jspwiki.propertyfile defined for this context, using default from /WEB-INF/jspwiki.properties");
                propertyStream = context.getResourceAsStream(DEFAULT_PROPERTYFILE);
            } else {
                context.log("Reading properties from " + propertyFile + " instead of default.");
                propertyStream = new FileInputStream(new File(propertyFile));
            }
            if (propertyStream == null) {
                throw new WikiException("Property file cannot be found!" + propertyFile);
            }
            Properties props = PropertyReader.getDefaultProperties();
            props.load(propertyStream);
            context.log("Loading cascading properties...");
            PropertyReader.loadWebAppPropsCascade(context, props);
            PropertyReader.expandVars(props);
            Properties properties = props;
            return properties;
        }
        catch (Exception e) {
            context.log("JSPWiki: Unable to load and setup properties from jspwiki.properties. " + e.getMessage());
        }
        finally {
            try {
                if (propertyStream != null) {
                    propertyStream.close();
                }
            }
            catch (IOException e) {
                context.log("Unable to close property stream - something must be seriously wrong.");
            }
        }
        return null;
    }

    public static final Properties getDefaultProperties() {
        Properties props = new Properties(TextUtil.createProperties(DEFAULT_PROPERTIES));
        InputStream in = PropertyReader.class.getResourceAsStream(DEFAULT_JSPWIKI_PROPERTIES);
        if (in != null) {
            try {
                props.load(in);
            }
            catch (IOException e) {
                System.err.println("Unable to load default propertyfile '/ini/default_jspwiki.properties'" + e.getMessage());
            }
        }
        return props;
    }

    private static String getInitParameter(ServletContext context, String name) {
        String value = context.getInitParameter(name);
        return value != null ? value : System.getProperty(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void loadWebAppPropsCascade(ServletContext context, Properties defaultProperties) {
        if (PropertyReader.getInitParameter(context, "jspwiki.propertyfile.cascade.1") == null) {
            context.log(" No cascading properties defined for this context");
            return;
        }
        int depth = 0;
        boolean more = true;
        InputStream propertyStream = null;
        while (more) {
            String propertyFile = PropertyReader.getInitParameter(context, PARAM_PROPERTYFILE_CASCADEPREFIX + ++depth);
            if (propertyFile == null) {
                more = false;
                break;
            }
            try {
                context.log(" Reading additional properties from " + propertyFile + " and merge to cascade.");
                Properties additionalProps = new Properties();
                propertyStream = new FileInputStream(new File(propertyFile));
                additionalProps.load(propertyStream);
                defaultProperties.putAll((Map<?, ?>)additionalProps);
            }
            catch (Exception e) {
                context.log(" JSPWiki: Unable to load and setup properties from " + propertyFile + "." + e.getMessage());
            }
            finally {
                try {
                    if (propertyStream == null) continue;
                    propertyStream.close();
                }
                catch (IOException e) {
                    context.log(" Unable to close property stream - something must be seriously wrong.");
                }
            }
        }
    }

    public static void expandVars(Properties properties) {
        String propertyValue;
        String propertyName;
        HashMap<String, String> vars = new HashMap<String, String>();
        Enumeration<?> propertyList = properties.propertyNames();
        while (propertyList.hasMoreElements()) {
            propertyName = (String)propertyList.nextElement();
            propertyValue = properties.getProperty(propertyName);
            if (!propertyName.startsWith(PARAM_VAR_DECLARATION)) continue;
            String varName = propertyName.substring(4, propertyName.length()).trim();
            String varValue = propertyValue.trim();
            vars.put(varName, varValue);
        }
        propertyList = properties.propertyNames();
        while (propertyList.hasMoreElements()) {
            propertyName = (String)propertyList.nextElement();
            propertyValue = properties.getProperty(propertyName);
            if (propertyName.startsWith(PARAM_VAR_DECLARATION)) continue;
            for (Map.Entry entry : vars.entrySet()) {
                String varName = (String)entry.getKey();
                String varValue = (String)entry.getValue();
                propertyValue = TextUtil.replaceString(propertyValue, PARAM_VAR_IDENTIFIER + varName, varValue);
                properties.put(propertyName, propertyValue);
            }
        }
    }
}

