/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.syntax;

import gnu.regexp.RE;
import gnu.regexp.REMatch;
import java.util.Hashtable;
import javax.swing.text.Segment;
import org.gjt.sp.jedit.syntax.KeywordMap;
import org.gjt.sp.jedit.syntax.ParserRule;
import org.gjt.sp.jedit.syntax.ParserRuleSet;
import org.gjt.sp.jedit.syntax.SyntaxUtilities;
import org.gjt.sp.jedit.syntax.TokenHandler;
import org.gjt.sp.util.CharIndexedSegment;

public class TokenMarker {
    private Hashtable ruleSets;
    private ParserRuleSet mainRuleSet;
    private TokenHandler tokenHandler;
    private Segment line;
    private LineContext context;
    private KeywordMap keywords;
    private Segment pattern = new Segment();
    private int lastOffset;
    private int lineLength;
    private int pos;
    private boolean escaped;
    private int whitespaceEnd;
    private boolean seenWhitespaceEnd;

    public TokenMarker() {
        this.ruleSets = new Hashtable(64);
    }

    public void addRuleSet(ParserRuleSet rules) {
        this.ruleSets.put(rules.getSetName(), rules);
        if (rules.getSetName().equals("MAIN")) {
            this.mainRuleSet = rules;
        }
    }

    public ParserRuleSet getMainRuleSet() {
        return this.mainRuleSet;
    }

    public ParserRuleSet getRuleSet(String setName) {
        return (ParserRuleSet)this.ruleSets.get(setName);
    }

    public ParserRuleSet[] getRuleSets() {
        return this.ruleSets.values().toArray(new ParserRuleSet[this.ruleSets.size()]);
    }

    public LineContext markTokens(LineContext prevContext, TokenHandler tokenHandler, Segment line) {
        ParserRule rule;
        this.tokenHandler = tokenHandler;
        this.line = line;
        this.lastOffset = line.offset;
        this.lineLength = line.count + line.offset;
        this.context = new LineContext();
        if (prevContext == null) {
            this.context.rules = this.getMainRuleSet();
        } else {
            this.context.parent = prevContext.parent;
            this.context.inRule = prevContext.inRule;
            this.context.rules = prevContext.rules;
            this.context.spanEndSubst = prevContext.spanEndSubst;
        }
        this.keywords = this.context.rules.getKeywords();
        this.escaped = false;
        this.seenWhitespaceEnd = false;
        this.whitespaceEnd = line.offset;
        int terminateChar = this.context.rules.getTerminateChar();
        boolean terminated = false;
        this.pos = line.offset;
        while (this.pos < this.lineLength) {
            block18: {
                if (terminateChar >= 0 && this.pos - line.offset >= terminateChar && !terminated) {
                    terminated = true;
                    this.context = new LineContext(ParserRuleSet.getStandardRuleSet(this.context.rules.getDefault()), this.context);
                    this.keywords = this.context.rules.getKeywords();
                }
                if (this.context.parent != null && (rule = this.context.parent.inRule) != null && this.checkDelegateEnd(rule)) {
                    this.seenWhitespaceEnd = true;
                } else {
                    char ch = line.array[this.pos];
                    rule = this.context.rules.getRules(ch);
                    while (rule != null) {
                        if (this.handleRule(rule, false)) {
                            this.seenWhitespaceEnd = true;
                            break block18;
                        }
                        rule = rule.next;
                    }
                    if (Character.isWhitespace(ch)) {
                        if (!this.seenWhitespaceEnd) {
                            this.whitespaceEnd = this.pos + 1;
                        }
                        if (this.context.inRule != null) {
                            this.handleRule(this.context.inRule, true);
                        }
                        this.handleNoWordBreak();
                        this.markKeyword(false);
                        if (this.lastOffset != this.pos) {
                            tokenHandler.handleToken(line, this.context.rules.getDefault(), this.lastOffset - line.offset, this.pos - this.lastOffset, this.context);
                        }
                        tokenHandler.handleToken(line, this.context.rules.getDefault(), this.pos - line.offset, 1, this.context);
                        this.lastOffset = this.pos + 1;
                        this.escaped = false;
                    } else {
                        if (this.keywords != null || this.context.rules.getRuleCount() != 0) {
                            String noWordSep = this.context.rules.getNoWordSep();
                            if (!Character.isLetterOrDigit(ch) && noWordSep.indexOf(ch) == -1) {
                                if (this.context.inRule != null) {
                                    this.handleRule(this.context.inRule, true);
                                }
                                this.handleNoWordBreak();
                                this.markKeyword(true);
                                tokenHandler.handleToken(line, this.context.rules.getDefault(), this.lastOffset - line.offset, 1, this.context);
                                this.lastOffset = this.pos + 1;
                            }
                        }
                        this.seenWhitespaceEnd = true;
                        this.escaped = false;
                    }
                }
            }
            ++this.pos;
        }
        this.pos = this.lineLength;
        if (this.context.inRule != null) {
            this.handleRule(this.context.inRule, true);
        }
        this.handleNoWordBreak();
        this.markKeyword(true);
        while (this.context.parent != null) {
            rule = this.context.parent.inRule;
            if ((rule == null || (rule.action & 0x200) != 512) && !terminated) break;
            this.context = this.context.parent;
            this.keywords = this.context.rules.getKeywords();
            this.context.inRule = null;
        }
        tokenHandler.handleToken(line, (byte)127, this.pos - line.offset, 0, this.context);
        this.context = this.context.intern();
        tokenHandler.setLineContext(this.context);
        this.line = null;
        return this.context;
    }

    private boolean checkDelegateEnd(ParserRule rule) {
        ParserRule escape;
        if (rule.end == null) {
            return false;
        }
        LineContext tempContext = this.context;
        this.context = this.context.parent;
        this.keywords = this.context.rules.getKeywords();
        boolean tempEscaped = this.escaped;
        boolean b = this.handleRule(rule, true);
        this.context = tempContext;
        this.keywords = this.context.rules.getKeywords();
        if (b && !tempEscaped) {
            if (this.context.inRule != null) {
                this.handleRule(this.context.inRule, true);
            }
            this.markKeyword(true);
            this.context = (LineContext)this.context.parent.clone();
            this.tokenHandler.handleToken(this.line, (this.context.inRule.action & 0x100) == 256 ? this.context.rules.getDefault() : this.context.inRule.token, this.pos - this.line.offset, this.pattern.count, this.context);
            this.keywords = this.context.rules.getKeywords();
            this.context.inRule = null;
            this.lastOffset = this.pos + this.pattern.count;
            this.pos += this.pattern.count - 1;
            return true;
        }
        return (rule.action & 0x1000) == 0 && (escape = this.context.parent.rules.getEscapeRule()) != null && this.handleRule(escape, false);
    }

    private boolean handleRule(ParserRule checkRule, boolean end) {
        int posMatch;
        if (!end && Character.toUpperCase(checkRule.hashChar) != Character.toUpperCase(this.line.array[this.pos])) {
            return false;
        }
        int offset = (checkRule.action & 4) != 0 ? this.lastOffset : this.pos;
        int n = posMatch = end ? checkRule.endPosMatch : checkRule.startPosMatch;
        if ((posMatch & 2) == 2 ? offset != this.line.offset : ((posMatch & 4) == 4 ? offset != this.whitespaceEnd : (posMatch & 8) == 8 && offset != this.lastOffset)) {
            return false;
        }
        int matchedChars = 1;
        CharIndexedSegment charIndexed = null;
        REMatch match = null;
        if (!end || (checkRule.action & 8) == 0) {
            if ((checkRule.action & 0x2000) == 0 || end) {
                this.pattern.array = end ? (this.context.spanEndSubst != null ? this.context.spanEndSubst : checkRule.end) : checkRule.start;
                this.pattern.offset = 0;
                matchedChars = this.pattern.count = this.pattern.array.length;
                if (!SyntaxUtilities.regionMatches(this.context.rules.getIgnoreCase(), this.line, this.pos, this.pattern.array)) {
                    return false;
                }
            } else {
                int matchStart = this.pos - this.line.offset;
                charIndexed = new CharIndexedSegment(this.line, matchStart);
                match = checkRule.startRegexp.getMatch(charIndexed, 0, 64);
                if (match == null) {
                    return false;
                }
                if (match.getStartIndex() != 0) {
                    throw new InternalError("Can't happen");
                }
                matchedChars = match.getEndIndex();
                if (matchedChars == 0) {
                    matchedChars = 1;
                }
            }
        }
        if ((checkRule.action & 0x800) == 2048) {
            if (this.context.inRule != null) {
                this.handleRule(this.context.inRule, true);
            }
            this.escaped = !this.escaped;
            this.pos += this.pattern.count - 1;
        } else if (this.escaped) {
            this.escaped = false;
            this.pos += this.pattern.count - 1;
        } else if (!end) {
            if (this.context.inRule != null) {
                this.handleRule(this.context.inRule, true);
            }
            this.markKeyword((checkRule.action & 4) != 4);
            switch (checkRule.action & 0xFF) {
                case 0: {
                    this.context.spanEndSubst = null;
                    if ((checkRule.action & 0x2000) != 0) {
                        this.handleTokenWithSpaces(this.tokenHandler, checkRule.token, this.pos - this.line.offset, matchedChars, this.context);
                    } else {
                        this.tokenHandler.handleToken(this.line, checkRule.token, this.pos - this.line.offset, matchedChars, this.context);
                    }
                    if (checkRule.delegate == null) break;
                    this.context = new LineContext(checkRule.delegate, this.context.parent);
                    this.keywords = this.context.rules.getKeywords();
                    break;
                }
                case 2: 
                case 16: {
                    byte tokenType;
                    this.context.inRule = checkRule;
                    byte by = tokenType = (checkRule.action & 0x100) == 256 ? this.context.rules.getDefault() : checkRule.token;
                    if ((checkRule.action & 0x2000) != 0) {
                        this.handleTokenWithSpaces(this.tokenHandler, tokenType, this.pos - this.line.offset, matchedChars, this.context);
                    } else {
                        this.tokenHandler.handleToken(this.line, tokenType, this.pos - this.line.offset, matchedChars, this.context);
                    }
                    char[] spanEndSubst = null;
                    if (charIndexed != null && checkRule.end != null) {
                        spanEndSubst = this.substitute(match, checkRule.end);
                    }
                    this.context.spanEndSubst = spanEndSubst;
                    this.context = new LineContext(checkRule.delegate, this.context);
                    this.keywords = this.context.rules.getKeywords();
                    break;
                }
                case 8: {
                    this.tokenHandler.handleToken(this.line, (checkRule.action & 0x100) == 256 ? this.context.rules.getDefault() : checkRule.token, this.pos - this.line.offset, this.pattern.count, this.context);
                    this.context.spanEndSubst = null;
                    this.context.inRule = checkRule;
                    break;
                }
                case 4: {
                    this.context.spanEndSubst = null;
                    if ((checkRule.action & 0x100) == 256) {
                        if (this.pos != this.lastOffset) {
                            this.tokenHandler.handleToken(this.line, checkRule.token, this.lastOffset - this.line.offset, this.pos - this.lastOffset, this.context);
                        }
                        this.tokenHandler.handleToken(this.line, this.context.rules.getDefault(), this.pos - this.line.offset, this.pattern.count, this.context);
                        break;
                    }
                    this.tokenHandler.handleToken(this.line, checkRule.token, this.lastOffset - this.line.offset, this.pos - this.lastOffset + this.pattern.count, this.context);
                    break;
                }
                default: {
                    throw new InternalError("Unhandled major action");
                }
            }
            this.pos += matchedChars - 1;
            this.lastOffset = this.pos + 1;
        } else if ((this.context.inRule.action & 8) != 0) {
            if (this.pos != this.lastOffset) {
                this.tokenHandler.handleToken(this.line, this.context.inRule.token, this.lastOffset - this.line.offset, this.pos - this.lastOffset, this.context);
            }
            this.lastOffset = this.pos;
            this.context.inRule = null;
        }
        return true;
    }

    private void handleNoWordBreak() {
        ParserRule rule;
        if (this.context.parent != null && (rule = this.context.parent.inRule) != null && (this.context.parent.inRule.action & 0x400) != 0) {
            if (this.pos != this.lastOffset) {
                this.tokenHandler.handleToken(this.line, rule.token, this.lastOffset - this.line.offset, this.pos - this.lastOffset, this.context);
            }
            this.lastOffset = this.pos;
            this.context = this.context.parent;
            this.keywords = this.context.rules.getKeywords();
            this.context.inRule = null;
        }
    }

    private void handleTokenWithSpaces(TokenHandler tokenHandler, byte tokenType, int start, int len, LineContext context) {
        int last = start;
        int end = start + len;
        int i = start;
        while (i < end) {
            if (Character.isWhitespace(this.line.array[i + this.line.offset])) {
                if (last != i) {
                    tokenHandler.handleToken(this.line, tokenType, last, i - last, context);
                }
                tokenHandler.handleToken(this.line, tokenType, i, 1, context);
                last = i + 1;
            }
            ++i;
        }
        if (last != end) {
            tokenHandler.handleToken(this.line, tokenType, last, end - last, context);
        }
    }

    private void markKeyword(boolean addRemaining) {
        byte id;
        int len = this.pos - this.lastOffset;
        if (len == 0) {
            return;
        }
        if (this.context.rules.getHighlightDigits()) {
            boolean digit = false;
            boolean mixed = false;
            int i = this.lastOffset;
            while (i < this.pos) {
                char ch = this.line.array[i];
                if (Character.isDigit(ch)) {
                    digit = true;
                } else {
                    mixed = true;
                }
                ++i;
            }
            if (mixed) {
                RE digitRE = this.context.rules.getDigitRegexp();
                if (digit) {
                    if (digitRE == null) {
                        digit = false;
                    } else {
                        CharIndexedSegment seg = new CharIndexedSegment(this.line, false);
                        int oldCount = this.line.count;
                        int oldOffset = this.line.offset;
                        this.line.offset = this.lastOffset;
                        this.line.count = len;
                        if (!digitRE.isMatch(seg)) {
                            digit = false;
                        }
                        this.line.offset = oldOffset;
                        this.line.count = oldCount;
                    }
                }
            }
            if (digit) {
                this.tokenHandler.handleToken(this.line, (byte)5, this.lastOffset - this.line.offset, len, this.context);
                this.lastOffset = this.pos;
                return;
            }
        }
        if (this.keywords != null && (id = this.keywords.lookup(this.line, this.lastOffset, len)) != 0) {
            this.tokenHandler.handleToken(this.line, id, this.lastOffset - this.line.offset, len, this.context);
            this.lastOffset = this.pos;
            return;
        }
        if (addRemaining) {
            this.tokenHandler.handleToken(this.line, this.context.rules.getDefault(), this.lastOffset - this.line.offset, len, this.context);
            this.lastOffset = this.pos;
        }
    }

    private char[] substitute(REMatch match, char[] end) {
        StringBuffer buf = new StringBuffer();
        int i = 0;
        while (i < end.length) {
            char ch = end[i];
            if (ch == '$') {
                if (i == end.length - 1) {
                    buf.append(ch);
                } else {
                    char digit = end[i + 1];
                    if (!Character.isDigit(digit)) {
                        buf.append(ch);
                    } else {
                        buf.append(match.toString(digit - 48));
                        ++i;
                    }
                }
            } else {
                buf.append(ch);
            }
            ++i;
        }
        char[] returnValue = new char[buf.length()];
        buf.getChars(0, buf.length(), returnValue, 0);
        return returnValue;
    }

    public static class LineContext {
        private static Hashtable intern = new Hashtable();
        public LineContext parent;
        public ParserRule inRule;
        public ParserRuleSet rules;
        public char[] spanEndSubst;

        public LineContext(ParserRuleSet rs, LineContext lc) {
            this.rules = rs;
            this.parent = lc == null ? null : (LineContext)lc.clone();
        }

        public LineContext() {
        }

        public LineContext intern() {
            Object obj = intern.get(this);
            if (obj == null) {
                intern.put(this, this);
                return this;
            }
            return (LineContext)obj;
        }

        public int hashCode() {
            if (this.inRule != null) {
                return this.inRule.hashCode();
            }
            if (this.rules != null) {
                return this.rules.hashCode();
            }
            return 0;
        }

        public boolean equals(Object obj) {
            if (obj instanceof LineContext) {
                LineContext lc = (LineContext)obj;
                return lc.inRule == this.inRule && lc.rules == this.rules && LineContext.objectsEqual(this.parent, lc.parent) && this.charArraysEqual(this.spanEndSubst, lc.spanEndSubst);
            }
            return false;
        }

        public static boolean objectsEqual(Object o1, Object o2) {
            if (o1 == null) {
                return o2 == null;
            }
            if (o2 == null) {
                return false;
            }
            return o1.equals(o2);
        }

        public Object clone() {
            LineContext lc = new LineContext();
            lc.inRule = this.inRule;
            lc.rules = this.rules;
            lc.parent = this.parent == null ? null : (LineContext)this.parent.clone();
            lc.spanEndSubst = this.spanEndSubst;
            return lc;
        }

        private boolean charArraysEqual(char[] c1, char[] c2) {
            if (c1 == null) {
                return c2 == null;
            }
            if (c2 == null) {
                return c1 == null;
            }
            if (c1.length != c2.length) {
                return false;
            }
            int i = 0;
            while (i < c1.length) {
                if (c1[i] != c2[i]) {
                    return false;
                }
                ++i;
            }
            return true;
        }
    }
}

