package org.mortbay.cometd.demo;

import org.mortbay.cometd.Bayeux;
import org.mortbay.cometd.continuation.ContinuationCometdServlet;
import org.mortbay.jetty.Server;
import org.mortbay.jetty.nio.SelectChannelConnector;
import org.mortbay.jetty.servlet.Context;
import org.mortbay.jetty.servlet.ServletHolder;

/* ------------------------------------------------------------ */
/** Main class for cometd demo.
 * 
 * This is of use when running demo in a terracotta cluster
 * 
 * @author gregw
 *
 */
public class Main
{
    /* ------------------------------------------------------------ */
    /**
     * @param args
     */
    public static void main(String[] args) throws Exception
    {
        int port = args.length==0?8080:Integer.parseInt(args[0]);
        
        // Manually contruct context to avoid hassles with webapp classloaders for now.
        Server server = new Server();
        SelectChannelConnector connector=new SelectChannelConnector();
        connector.setPort(port);
        server.addConnector(connector);
        Context context = new Context(server,"/",Context.NO_SECURITY|Context.NO_SESSIONS);
        context.setResourceBase("./src/main/webapp");
        
        ContinuationCometdServlet cometd_servlet=new ContinuationCometdServlet();
        ServletHolder cometd_holder = new ServletHolder(cometd_servlet);
        cometd_holder.setInitParameter("filters","/WEB-INF/filters.json");
        cometd_holder.setInitParameter("timeout","30000");
        cometd_holder.setInitParameter("multi-timeout","1500");
        cometd_holder.setInitParameter("verbose","true");
        cometd_holder.setInitParameter("rpcSupport","true");
        cometd_holder.setInitParameter("logLevel","1");
        
        context.addServlet(cometd_holder, "/cometd/*");
        context.addServlet("org.mortbay.jetty.servlet.DefaultServlet", "/");
        
        server.start();
        Bayeux bayeux = cometd_servlet.getBayeux();
        BayeuxStartupListener listener = new BayeuxStartupListener();
        listener.initialize(bayeux);
        
        server.join();
    }

}
