/**
 * 
 */
package org.mortbay.cometd;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.Map;

import javax.servlet.http.HttpServletResponse;

import org.mortbay.util.ajax.JSON;

/* ------------------------------------------------------------ */
/**
 * @author aabeling
 * @author gregw
 * 
 */
public class JSONPTransport extends AbstractTransport
{
    int _responses=0;
    PrintWriter _out;
    String jsonp="jsonpcallback";
    boolean _commented;
    String _mimeType;

    public JSONPTransport()
    {
        setJSONCommented(false);
    }
    
    public JSONPTransport(boolean commented)
    {
        setJSONCommented(commented);
        _commented=commented;
    }

    public void send(Map<String, Object> reply) throws IOException
    {
        if (reply!=null)
        {
            if (_responses==0)
            {
                HttpServletResponse response=getResponse();
                response.setContentType(_mimeType);
                _out=response.getWriter();
                if (_commented)
                    _out.write("/*");
                _out.write(this.jsonp);
                _out.write("([");
            }
            else
            {
                _out.write(",\r\n");
            }

            String r=JSON.toString(reply);
            _responses++;
            _out.write(r);
        }
    }

    public void complete() throws IOException
    {
        HttpServletResponse response=getResponse();
        response.setStatus(200);

        if (_responses==0)
            response.setContentLength(0);
        else
        {
            if (_commented)
                _out.write("])*/\r\n");
            else
                _out.write("])\r\n");
            _out.flush();
        }

    }

    public boolean keepAlive() throws IOException
    {
        return false;
    }

    public String getJsonp()
    {
        return jsonp;
    }

    public void setJsonp(String jsonp)
    {
        this.jsonp=jsonp;
    }

    public String toString()
    {
        return "JSONPTransport[jsonp="+this.jsonp+"]";
    }

    /* ------------------------------------------------------------ */
    /**
     * @return the commented
     */
    public boolean isJSONCommented()
    {
        return _commented;
    }

    /* ------------------------------------------------------------ */
    /**
     * @param commented the commented to set
     */
    public void setJSONCommented(boolean commented)
    {
        _commented=commented;
        _mimeType=commented?"text/javascript-comment-filtered; charset=utf-8":"text/javascript; charset=utf-8";
    }
}