/*
 * Decompiled with CFR 0.152.
 */
package org.makumba.analyser;

import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedHashMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.PageContext;
import org.apache.commons.lang.StringUtils;
import org.makumba.CompositeValidationException;
import org.makumba.LogicException;
import org.makumba.MakumbaError;
import org.makumba.ProgrammerError;
import org.makumba.analyser.AnalysableElement;
import org.makumba.analyser.ElementData;
import org.makumba.analyser.PageCache;
import org.makumba.analyser.TagData;
import org.makumba.analyser.engine.JspParseData;
import org.makumba.commons.MakumbaJspAnalyzer;
import org.makumba.commons.MultipleKey;
import org.makumba.commons.RuntimeWrappedException;

public abstract class AnalysableTag
extends AnalysableElement {
    private static final long serialVersionUID = 1L;
    public static final String[] ATTRIBUTE_VALUES_TRUE_FALSE = new String[]{"true", "false"};
    public static final String TYPES = "org.makumba.types";
    private HashMap<String, String[]> attributeValues = new LinkedHashMap<String, String[]>();
    public TagData tagData;
    public MultipleKey tagKey;

    public ElementData getElementData() {
        return this.tagData;
    }

    public void setTagDataAtAnalysis(TagData tagData) {
        this.tagData = tagData;
    }

    public void addTagText(StringBuffer sb) {
        JspParseData.tagDataLine(this.tagData, sb);
    }

    public String getTagText() {
        StringBuffer sb = new StringBuffer();
        this.addTagText(sb);
        return sb.toString();
    }

    public PageContext getPageContext() {
        return this.pageContext;
    }

    public void setTagKey(PageCache pageCache) {
    }

    public void doStartAnalyze(PageCache pageCache) {
    }

    public void doEndAnalyze(PageCache pageCache) {
    }

    public String getPageTextInfo() {
        if (this.tagData == null) {
            return "";
        }
        try {
            return this.tagData.getSourceSyntaxPoints().getFile().getCanonicalPath() + ":" + this.tagData.getStartLine() + ":" + this.tagData.getStartColumn() + ":" + this.tagData.getEndLine() + ":" + this.tagData.getEndColumn();
        }
        catch (IOException e) {
            throw new MakumbaError(e.toString());
        }
    }

    public int doAnalyzedStartTag(PageCache pageCache) throws LogicException, JspException {
        return 0;
    }

    public int doAnalyzedEndTag(PageCache pageCache) throws LogicException, JspException {
        return 6;
    }

    protected boolean needPageCache() {
        return true;
    }

    public int doStartTag() throws JspException {
        int n;
        PageCache pageCache = null;
        if (this.pageContext.getAttribute("javax.servlet.jsp.jspException", 2) != null && !(this.pageContext.getAttribute("javax.servlet.jsp.jspException", 2) instanceof CompositeValidationException)) {
            this.getRequest().setAttribute("org.makumba.wasException", (Object)"yes");
        }
        if ("yes".equals(this.getRequest().getAttribute("org.makumba.wasException")) && !(this.pageContext.getAttribute("javax.servlet.jsp.jspException", 2) instanceof CompositeValidationException)) {
            return 5;
        }
        if (this.needPageCache()) {
            pageCache = AnalysableElement.getPageCache(this.pageContext, MakumbaJspAnalyzer.getInstance());
        }
        this.setTagKey(pageCache);
        if (pageCache != null) {
            this.tagData = (TagData)pageCache.retrieve("org.makumba.tagData", this.tagKey);
            AnalysableTag.setRunningElementData(this.tagData);
        }
        try {
            n = this.doAnalyzedStartTag(pageCache);
        }
        catch (LogicException e) {
            throw new RuntimeWrappedException(e);
        }
        if (this.tagData != null) {
            AnalysableTag.setRunningElementData(null);
            AnalysableTag.getThreadElementStack().push(this.tagData);
        }
        return n;
    }

    public int doEndTag() throws JspException {
        try {
            if ("yes".equals(this.getRequest().getAttribute("org.makumba.wasException"))) {
                int n = 5;
                return n;
            }
            PageCache pageCache = null;
            if (this.needPageCache()) {
                pageCache = AnalysableElement.getPageCache(this.pageContext, MakumbaJspAnalyzer.getInstance());
            }
            if (this.tagData != null) {
                AnalysableTag.setRunningElementData(this.tagData);
                AnalysableTag.getThreadElementStack().pop();
            }
            int n = this.doAnalyzedEndTag(pageCache);
            return n;
        }
        catch (LogicException e) {
            throw new RuntimeWrappedException(e);
        }
        finally {
            this.doAnalyzedCleanup();
            this.attributeValues.clear();
        }
    }

    protected void doAnalyzedCleanup() {
        AnalysableTag.setRunningElementData(null);
        this.tagKey = null;
        this.tagData = null;
    }

    public MultipleKey getTagKey() {
        return this.tagKey;
    }

    private HttpServletRequest getRequest() {
        return (HttpServletRequest)this.pageContext.getRequest();
    }

    public boolean allowsIdenticalKey() {
        return true;
    }

    public boolean canHaveBody() {
        return false;
    }

    protected void onlyInt(String s, String value) throws JspException {
        if ((value = value.trim()).startsWith("$")) {
            return;
        }
        if (!StringUtils.isNumeric((String)value)) {
            throw new ProgrammerError("The attribute '" + s + "' can only be an $attribute or an int");
        }
    }

    protected void registerPossibleAttributeValues() {
    }

    protected final void registerAttributeValues(String attributeName, String ... values) {
        this.attributeValues.put(attributeName, values);
    }

    public void checkAttributeValues() {
        this.registerPossibleAttributeValues();
        for (String attributeName : this.attributeValues.keySet()) {
            String value = this.tagData.attributes.get(attributeName);
            if (value == null || org.makumba.commons.StringUtils.equalsAny(value, this.attributeValues.get(attributeName))) continue;
            throw new ProgrammerError("Invalid value for attribute '" + attributeName + "': '" + value + "'. Allowed values are " + org.makumba.commons.StringUtils.toString(this.attributeValues.get(attributeName)));
        }
    }
}

