/*
 * Decompiled with CFR 0.152.
 */
package org.makumba.commons;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import java.util.List;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.SAXReader;
import org.dom4j.io.XMLWriter;
import org.makumba.MakumbaSystem;
import org.makumba.commons.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MakumbaTLDGenerator {
    private static final String TAGLIB_MAK = "taglib.tld";
    private static final String TAGLIB_HIBERNATE = "taglib-hibernate.tld";
    private static final String HIBERNATE_TLD_URI = "http://www.makumba.org/view-hql";
    private static final String TAGLIB_DOCUMENTED_XML = "taglib-documented.xml";

    public static void main(String[] args) {
        HashMap<String, Element> processedTags = new HashMap<String, Element>();
        SAXReader saxReader = new SAXReader();
        Document document = null;
        String sourcePath = new File(args[0]) + File.separator + TAGLIB_DOCUMENTED_XML;
        try {
            document = saxReader.read(sourcePath);
        }
        catch (DocumentException e) {
            e.printStackTrace();
        }
        String errorMsg = "Error processing '" + sourcePath + "': ";
        Element root = document.getRootElement();
        for (Element tag : root.elements()) {
            if (tag.getName().equals("description")) {
                tag.setText(tag.getText().replace("@version@", MakumbaSystem.getVersion()));
            }
            if (!tag.getName().equals("tag") && !tag.getName().equals("function")) continue;
            Element name = tag.element("name");
            String tagName = name.getText();
            for (Element tagContent : tag.elements()) {
                if (tagContent.getName().equals("attribute")) {
                    if (tagContent.attributeValue("name") != null || tagContent.attributeValue("specifiedIn") != null) {
                        Element newTag = MakumbaTLDGenerator.getReferencedAttributes(processedTags, errorMsg, tag, tagName, tagContent);
                        tagContent.setAttributes(newTag.attributes());
                        List elements = newTag.elements();
                        for (Element element : elements) {
                            tagContent.add((Element)element.clone());
                        }
                    } else {
                        for (Element attributeContent : tagContent.elements()) {
                            if (!StringUtils.equalsAny(attributeContent.getName(), "comments", "deprecated", "descriptionPage", "commentsPage")) continue;
                            attributeContent.getParent().remove(attributeContent);
                        }
                    }
                }
                if (StringUtils.equalsAny(tagContent.getName(), "see", "example")) {
                    tagContent.getParent().remove(tagContent);
                }
                if (!tagContent.getName().equals("descriptionPage")) continue;
                Element e = tagContent.getParent().addElement("description");
                e.setText("See " + tagContent.getText());
                tagContent.getParent().remove(tagContent);
            }
            processedTags.put(tagName, tag);
        }
        String tldPath = args[0] + File.separator + TAGLIB_MAK;
        System.out.println("Writing general Makumba TLD at path " + tldPath);
        try {
            XMLWriter output = new XMLWriter((Writer)new FileWriter(new File(tldPath)), new OutputFormat("", false));
            output.write(document);
            output.close();
        }
        catch (IOException e1) {
            System.out.println(e1.getMessage());
        }
        Document hibernateTLD = document;
        hibernateTLD.getRootElement().element("uri").setText(HIBERNATE_TLD_URI);
        String hibernateTldPath = args[0] + File.separator + TAGLIB_HIBERNATE;
        System.out.println("Writing hibernate Makumba TLD at path " + hibernateTldPath);
        try {
            XMLWriter output = new XMLWriter((Writer)new FileWriter(new File(hibernateTldPath)), new OutputFormat("", false));
            output.write(document);
            output.close();
        }
        catch (IOException e1) {
            System.out.println(e1.getMessage());
        }
    }

    public static Element getReferencedAttributes(HashMap<String, Element> processedTags, String errorMsg, Element tag, String tagName, Element tagContent) {
        Element element;
        String specifiedIn = tagContent.attributeValue("specifiedIn");
        String attribute = tagContent.attributeValue("name");
        Element copyFrom = processedTags.get(specifiedIn);
        if (copyFrom == null) {
            System.out.println(errorMsg + "tag '" + tagName + "' specifies an invalid source tag to copy attributes from: '" + specifiedIn + "'. Make sure that the source tag exists and is defined BEFORE the tag copying!");
            System.exit(-1);
        }
        if ((element = MakumbaTLDGenerator.getAttributeFromTag(copyFrom, attribute)) == null) {
            System.out.println(errorMsg + "tag '" + tagName + "' specifies an not-existing source attribute '" + attribute + "' to copy from tag '" + specifiedIn + "'!");
            System.exit(-1);
        }
        return element;
    }

    private static Element getAttributeFromTag(Element tag, String attribute) {
        for (Element tagContent : tag.elements()) {
            if (!tagContent.getName().equals("attribute") || tagContent.element("name") == null || !tagContent.element("name").getText().equals(attribute)) continue;
            return (Element)tagContent.clone();
        }
        return null;
    }
}

