/*
 * Decompiled with CFR 0.152.
 */
package org.makumba.commons.formatters;

import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import org.apache.commons.lang.ArrayUtils;
import org.makumba.ProgrammerError;
import org.makumba.commons.SingletonReleaser;
import org.makumba.commons.formatters.InvalidValueException;
import org.makumba.commons.formatters.RecordFormatter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FieldFormatter {
    static String[] params = new String[]{"default", "empty"};
    static String[][] paramValues = new String[][]{null, null};
    static Object dummy = new Object();
    Hashtable<String, Hashtable<String, Object>> validParams = new Hashtable(13);

    public String[] getAcceptedParams() {
        return params;
    }

    public String[][] getAcceptedValue() {
        return paramValues;
    }

    public static FieldFormatter getInstance() {
        return SingletonHolder.singleton;
    }

    protected FieldFormatter() {
        for (int i = 0; i < this.getAcceptedParams().length; ++i) {
            Hashtable<String, Object> h = new Hashtable<String, Object>(13);
            if (this.getAcceptedValue()[i] != null) {
                for (int j = 0; j < this.getAcceptedValue()[i].length; ++j) {
                    h.put(this.getAcceptedValue()[i][j], dummy);
                }
            }
            this.validParams.put(this.getAcceptedParams()[i], h);
        }
    }

    public String getExpr(RecordFormatter rf, int fieldIndex) {
        if (rf.expr[fieldIndex] != null) {
            return rf.expr[fieldIndex];
        }
        return rf.dd.getFieldDefinition(fieldIndex).getName();
    }

    public void initExpr(RecordFormatter rf, int fieldIndex, String s) {
        rf.expr[fieldIndex] = s;
    }

    public void checkParams(RecordFormatter rf, int fieldIndex, Dictionary<String, Object> formatParams) {
        Enumeration<String> e = formatParams.keys();
        while (e.hasMoreElements()) {
            String s = e.nextElement();
            if (s.startsWith("org.makumba")) continue;
            this.checkParam(rf, fieldIndex, s, ((String)formatParams.get(s)).toLowerCase());
        }
    }

    public void checkParam(RecordFormatter rf, int fieldIndex, String name, String val) {
        Hashtable<String, Object> h = this.validParams.get(name);
        if (h == null) {
            throw new ProgrammerError("Error for expression '" + rf.expr[fieldIndex] + "': invalid format parameter '" + name + "'. Allowed values are: " + ArrayUtils.toString(this.validParams.keySet()));
        }
        if (h.size() == 0) {
            return;
        }
        if (h.get(val) == null) {
            throw new ProgrammerError("Error for expression '" + rf.expr[fieldIndex] + "': invalid format parameter '" + name + "'. Allowed values are: " + ArrayUtils.toString(this.validParams.keySet()));
        }
    }

    public String format(RecordFormatter rf, int fieldIndex, Object o, Dictionary<String, Object> formatParams) {
        String formatted = o == null || o.equals(rf.dd.getFieldDefinition(fieldIndex).getNull()) ? this.formatNull(rf, fieldIndex, formatParams) : this.formatNotNull(rf, fieldIndex, o, formatParams);
        if ("".equals(formatted)) {
            return this.getEmptyValueFormat(rf, fieldIndex, formatParams);
        }
        return formatted;
    }

    public String formatNull(RecordFormatter rf, int fieldIndex, Dictionary<String, Object> formatParams) {
        return this.getDefaultValueFormat(rf, fieldIndex, formatParams);
    }

    public String formatNotNull(RecordFormatter rf, int fieldIndex, Object o, Dictionary<String, Object> formatParams) {
        return o.toString();
    }

    public int getIntParam(RecordFormatter rf, int fieldIndex, Dictionary<String, Object> formatParams, String name) {
        String s = (String)formatParams.get(name);
        if (s == null) {
            return -1;
        }
        try {
            return Integer.parseInt(s);
        }
        catch (NumberFormatException e) {
            throw new InvalidValueException(rf.expr[fieldIndex], "invalid integer for " + name + ": " + s);
        }
    }

    public String getIntParamString(RecordFormatter rf, int fieldIndex, Dictionary<String, Object> formatParams, String name) {
        int n = this.getIntParam(rf, fieldIndex, formatParams, name);
        if (n == -1) {
            return "";
        }
        return name + "=\"" + n + "\" ";
    }

    public String getDefaultValueFormat(RecordFormatter rf, int fieldIndex, Dictionary<String, Object> formatParams) {
        String s = (String)formatParams.get("default");
        return s == null ? "" : s;
    }

    public String getEmptyValueFormat(RecordFormatter rf, int fieldIndex, Dictionary<String, Object> formatParams) {
        String s = (String)formatParams.get("empty");
        return s == null ? "" : s;
    }

    public String resetValueFormat(RecordFormatter rf, int fieldIndex, String s, Dictionary<String, Object> formatParams) {
        if (s == null) {
            s = this.getDefaultValueFormat(rf, fieldIndex, formatParams);
        }
        if ("".equals(s)) {
            return this.getEmptyValueFormat(rf, fieldIndex, formatParams);
        }
        return s;
    }

    public boolean equals(String s1, String s2) {
        return s1 != null && s1.equals(s2);
    }

    private static final class SingletonHolder
    implements org.makumba.commons.SingletonHolder {
        static FieldFormatter singleton = new FieldFormatter();

        public void release() {
            singleton = null;
        }

        public SingletonHolder() {
            SingletonReleaser.register(this);
        }
    }
}

