/*
 * Decompiled with CFR 0.152.
 */
package org.makumba.devel;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.Vector;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import org.makumba.DataDefinition;
import org.makumba.DataDefinitionNotFoundError;
import org.makumba.DataDefinitionParseError;
import org.makumba.Pointer;
import org.makumba.Transaction;
import org.makumba.analyser.engine.JavaParseData;
import org.makumba.analyser.engine.JspParseData;
import org.makumba.analyser.engine.SourceSyntaxPoints;
import org.makumba.commons.ClassResource;
import org.makumba.commons.RuntimeWrappedException;
import org.makumba.controller.Logic;
import org.makumba.devel.CodeGenerator;
import org.makumba.devel.CodeGeneratorTemplate;
import org.makumba.devel.DevelUtils;
import org.makumba.devel.JavaSourceAnalyzer;
import org.makumba.devel.JspxJspAnalyzer;
import org.makumba.devel.jspViewer;
import org.makumba.providers.Configuration;
import org.makumba.providers.DataDefinitionProvider;
import org.makumba.providers.TransactionProvider;
import org.makumba.providers.datadefinition.makumba.RecordParser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GeneratedCodeViewer
extends jspViewer {
    private static final String CODE_TYPE_DELIM = "****************************************";
    private static String defaultTemplate;
    private static final String GENERATED_CODE_DIRECTORY = "generatedCode";
    private static Hashtable<String, String> selectableCodeTypes;
    private static ArrayList<String> selectableCodeTypesOrdered;
    private static String[] selectableQueryLanguages;
    private static Map<String, Map<String, String>> builtIn;
    private static Map<String, Map<String, String>> userDefined;
    private static Map<String, Map<String, String>> all;
    private URL classesDirectory;
    private DataDefinition dd = null;
    private File fileRoot;
    private File alternateFileRoot;
    private String logicDir;
    private String logicFileName;
    private String[] selectedCodeTypes = null;
    private String templateName;
    private String typeParam;
    private String queryLanguageParam;

    private static void initTemplates() {
        builtIn = Configuration.getInternalCodeGeneratorTemplates();
        userDefined = Configuration.getApplicationSpecificCodeGeneratorTemplates();
        all = new HashMap<String, Map<String, String>>();
        for (String key : userDefined.keySet()) {
            if (!builtIn.containsKey(key)) continue;
            builtIn.remove(key);
        }
        all.putAll(builtIn);
        all.putAll(userDefined);
        defaultTemplate = all.keySet().iterator().next();
        selectableCodeTypes = new Hashtable();
        selectableCodeTypes.put("New", "mak:newForm");
        selectableCodeTypes.put("Edit", "mak:editForm");
        selectableCodeTypes.put("List", "mak:list");
        selectableCodeTypes.put("Object", "mak:object");
        selectableCodeTypes.put("Delete", "mak:delete");
        selectableCodeTypes.put("Logic", "Java Business Logics");
        selectableCodeTypes.put("All", "all");
        selectableCodeTypesOrdered = new ArrayList<String>(Arrays.asList("All", "New", "Edit", "List", "Object", "Delete", "Logic"));
    }

    public GeneratedCodeViewer(HttpServletRequest req) throws Exception {
        super(req, true);
        URL u;
        this.setSearchLevels(false, false, false, true);
        this.contextPath = this.request.getContextPath();
        this.virtualPath = DevelUtils.getVirtualPath(req, Configuration.getCodeGeneratorLocation());
        if (this.virtualPath == null) {
            this.virtualPath = "/";
        }
        if ((u = RecordParser.findDataDefinitionOrDirectory(this.virtualPath, "mdd")) == null) {
            u = RecordParser.findDataDefinitionOrDirectory(this.virtualPath, "idd");
        }
        this.virtualPath = this.virtualPath.substring(1);
        this.readFromURL(u);
        this.generateCode();
    }

    public void generateCode() throws IOException {
        try {
            this.dd = DataDefinitionProvider.getInstance().getDataDefinition(this.virtualPath);
            this.typeParam = this.request.getParameter("type");
            if (this.typeParam == null) {
                this.typeParam = "New";
            }
            this.selectedCodeTypes = this.typeParam.equalsIgnoreCase("all") ? CodeGenerator.ALL_PROCESSABLE_TYPES : new String[]{CodeGenerator.nameToTypeMapping.get(this.typeParam)};
            if (this.selectedCodeTypes == null) {
                this.selectedCodeTypes = new String[]{"New"};
                this.typeParam = "New";
            }
            this.queryLanguageParam = this.request.getParameter("queryLanguage");
            if (this.queryLanguageParam == null) {
                this.queryLanguageParam = "OQL";
            }
            this.templateName = this.request.getParameter("template");
            if (this.templateName == null) {
                this.templateName = defaultTemplate;
            }
            CodeGeneratorTemplate template = new CodeGeneratorTemplate(all.get(this.templateName), this.queryLanguageParam);
            String action = CodeGenerator.getLabelNameFromDataDefinition(this.dd) + "View.jsp";
            StringBuffer allPages = new StringBuffer();
            SourceSyntaxPoints.PreprocessorClient jspParseData = null;
            String rootPath = this.request.getSession().getServletContext().getRealPath("/");
            String alternatePath = System.getProperty("makumba.project.path");
            if (alternatePath != null) {
                alternatePath = new File(alternatePath).getAbsolutePath() + File.separator;
                this.alternateFileRoot = new File(alternatePath + File.separator + GENERATED_CODE_DIRECTORY);
                this.alternateFileRoot.mkdirs();
            }
            this.fileRoot = new File(rootPath + File.separator + GENERATED_CODE_DIRECTORY);
            this.fileRoot.mkdirs();
            File allPagesFile = null;
            this.logicFileName = CodeGenerator.getLogicNameFromDataDefinition(this.dd) + ".java";
            this.classesDirectory = ClassResource.get("");
            CodeGenerator codeGenerator = new CodeGenerator();
            for (int i = 0; i < this.selectedCodeTypes.length; ++i) {
                File generatedCodeFile;
                String generatingType = CodeGenerator.nameToTypeMapping.get(this.selectedCodeTypes[i]);
                StringBuffer sb = new StringBuffer();
                File alternateCodeFile = null;
                if (generatingType == "Logic") {
                    String packageName = Logic.findPackageName("/");
                    this.logicDir = File.separator + GENERATED_CODE_DIRECTORY + File.separator + packageName.replace('.', File.separatorChar) + File.separator;
                    String logicPath = this.classesDirectory.getPath() + this.logicDir;
                    if (new File(logicPath).mkdirs()) {
                        Logger.getLogger("org.makumba.devel.codeGenerator").info("Created logic directory " + logicPath);
                    }
                    boolean hasSuperLogic = new File(logicPath + "Logic.java").exists();
                    codeGenerator.generateJavaBusinessLogicCode(this.dd, packageName, hasSuperLogic, this.selectedCodeTypes, sb);
                    generatedCodeFile = new File(this.fileRoot, this.logicFileName);
                    if (this.alternateFileRoot != null) {
                        alternateCodeFile = new File(this.alternateFileRoot, this.logicFileName);
                    }
                    allPages.append("\n ****************************************  " + selectableCodeTypes.get(generatingType) + "  " + CODE_TYPE_DELIM + "\n\n");
                    allPages.append(sb);
                    this.reader = new StringReader(sb.toString());
                    String fileName = GENERATED_CODE_DIRECTORY + File.separator + this.logicFileName;
                    jspParseData = JavaParseData.getParseData(rootPath, fileName, JavaSourceAnalyzer.getInstance());
                } else {
                    if (i > 0) {
                        allPages.append("\n\n\n");
                    }
                    allPages.append("\n ****************************************  " + selectableCodeTypes.get(generatingType) + "  " + CODE_TYPE_DELIM + "\n\n");
                    codeGenerator.generateCode(sb, generatingType, this.dd, action, template, this.queryLanguageParam);
                    allPages.append(sb);
                    String pageName = CodeGenerator.getFileNameFromObject(this.dd, generatingType);
                    String fileName = GENERATED_CODE_DIRECTORY + File.separator + pageName;
                    generatedCodeFile = new File(this.fileRoot, pageName);
                    if (this.alternateFileRoot != null) {
                        alternateCodeFile = new File(this.alternateFileRoot, pageName);
                    }
                    if (this.selectedCodeTypes.length == 1) {
                        this.reader = new StringReader(sb.toString());
                        jspParseData = JspParseData.getParseData(rootPath, fileName, JspxJspAnalyzer.getInstance());
                    }
                }
                FileWriter writer = new FileWriter(generatedCodeFile);
                writer.write(sb.toString());
                writer.flush();
                writer.close();
                if (this.alternateFileRoot == null) continue;
                System.out.println("Writing to alternate location " + alternateCodeFile.getAbsoluteFile());
                FileWriter alternateWriter = new FileWriter(alternateCodeFile);
                alternateWriter.write(sb.toString());
                alternateWriter.flush();
                alternateWriter.close();
            }
            if (this.selectedCodeTypes.length > 1) {
                String allPagesName = CodeGenerator.getFileNameFromObject(this.dd, this.typeParam);
                allPagesFile = new File(this.fileRoot, allPagesName);
                FileWriter writerAllPage = new FileWriter(allPagesFile);
                writerAllPage.write(allPages.toString());
                writerAllPage.flush();
                writerAllPage.close();
                this.reader = new StringReader(allPages.toString());
                jspParseData = new JspParseData(rootPath, GENERATED_CODE_DIRECTORY + File.separator + allPagesName, JspxJspAnalyzer.getInstance());
            }
            this.getParseData(jspParseData);
            if (allPagesFile != null) {
                allPagesFile.delete();
            }
        }
        catch (DataDefinitionNotFoundError e) {
            this.caughtError = e;
        }
        catch (DataDefinitionParseError e) {
            this.caughtError = e;
        }
    }

    @Override
    public void intro(PrintWriter w) {
        GeneratedCodeViewer.initTemplates();
        String browsePath = this.contextPath + Configuration.getMddViewerLocation() + this.virtualPath.replace('.', '/').substring(0, this.virtualPath.lastIndexOf(46) + 1);
        String mddViewerPath = this.contextPath + Configuration.getMddViewerLocation() + "/" + this.virtualPath;
        w.println("<td align=\"right\" valign=\"top\" style=\"padding: 5px; padding-top: 10px\" nowrap=\"nowrap\">");
        w.println("<a style=\"color: darkblue;\" href=\"" + mddViewerPath + "\">mdd</a>&nbsp;&nbsp;&nbsp;");
        w.println("<span style=\"color:lightblue; background-color: darkblue; padding: 5px;\">code generator</span>&nbsp;&nbsp;&nbsp;");
        w.println("<a style=\"color: darkblue;\"href=\"" + browsePath + "\">browse</a>&nbsp;&nbsp;&nbsp;");
        w.println("&nbsp;&nbsp;&nbsp;");
        DevelUtils.writeDevelUtilLinks(w, "mddViewer", this.contextPath);
        w.println("</td>");
    }

    @Override
    public void printPageBeginAdditional(PrintWriter w) throws IOException {
        if (this.dd != null) {
            int i;
            w.println("<form style=\"margin-top:1px; margin-bottom:0px; font-size:smaller;\">");
            w.println("<b>Code type:</b>");
            for (i = 0; i < selectableCodeTypesOrdered.size(); ++i) {
                String key = selectableCodeTypesOrdered.get(i);
                w.print("<input type=\"radio\" name=\"type\" value=\"" + key + "\"");
                if (key.equals(this.typeParam)) {
                    w.print("checked=\"checked\" ");
                }
                w.println(" />" + selectableCodeTypes.get(key));
            }
            w.println("<br />");
            w.println("<b>Query language:</b>");
            for (i = 0; i < selectableQueryLanguages.length; ++i) {
                w.print("<input type=\"radio\" name=\"queryLanguage\" value=\"" + selectableQueryLanguages[i] + "\"");
                if (selectableQueryLanguages[i].equals(this.queryLanguageParam)) {
                    w.print("checked=\"checked\" ");
                }
                w.println(" />" + selectableQueryLanguages[i]);
            }
            w.println("<br />");
            w.println("<b>Template:</b>");
            w.println("&nbsp;<i>Built-in</i>:");
            this.printTemplates(w, builtIn);
            w.println("&nbsp;&nbsp;<i>User-defined</i>:");
            this.printTemplates(w, userDefined);
            w.println("<input type=\"submit\" value=\"Generate!\" />");
            w.println("</form>");
            this.printGeneratedCodeLinks(w);
        }
    }

    private void getParseData(SourceSyntaxPoints.PreprocessorClient jspParseData) {
        if (jspParseData != null) {
            this.sourceSyntaxPoints = jspParseData.getSyntaxPointArray(null);
            this.syntaxPoints = jspParseData.getSyntaxPoints();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void printGeneratedCodeLinks(PrintWriter w) {
        TransactionProvider tp = TransactionProvider.getInstance();
        String cgiParams = "";
        w.println("<span style=\"font-size: smaller;\">");
        boolean addSeperator = false;
        boolean firstPage = true;
        for (String currentType : CodeGenerator.ALL_PROCESSABLE_TYPES) {
            if (currentType == "Edit" || currentType == "Object" || currentType == "Delete" && cgiParams.equals("")) {
                String labelName = CodeGenerator.getLabelNameFromDataDefinition(this.dd);
                Transaction db = tp.getConnectionTo(tp.getDefaultDataSourceName());
                try {
                    String queryOQL = "SELECT " + labelName + " AS " + labelName + " FROM " + this.dd.getName() + " " + labelName;
                    String queryHQL = "SELECT " + labelName + ".id AS " + labelName + " FROM " + this.dd.getName() + " " + labelName;
                    Vector<Dictionary<String, Object>> v = db.executeQuery(tp.getQueryLanguage().equals("OQL") ? queryOQL : queryHQL, null, 0, 1);
                    if (v.size() > 0) {
                        cgiParams = "?" + labelName + "=" + ((Pointer)v.firstElement().get(labelName)).toExternalForm();
                    }
                }
                catch (RuntimeWrappedException e) {
                    w.println("<br/> <span style=\"color: red\">" + e.getCause() + "</span>");
                }
                finally {
                    db.close();
                }
            }
            if (firstPage) {
                w.print("<b>Preview:</b>&nbsp;");
                firstPage = false;
            }
            String pageName = CodeGenerator.getFileNameFromObject(this.dd, currentType);
            String fileName = this.fileRoot.getPath() + File.separator + pageName;
            boolean fileExists = new File(fileName).exists();
            boolean selectedType = Arrays.asList(this.selectedCodeTypes).contains(currentType);
            if (!fileExists) continue;
            if (addSeperator) {
                w.println("&nbsp;|");
                addSeperator = false;
            }
            w.print("<a target=\"_blank\" ");
            if (!selectedType) {
                w.print("style=\"color: grey;\" ");
            }
            w.println("href=\"" + this.contextPath + "/" + GENERATED_CODE_DIRECTORY + File.separator + pageName + cgiParams + "\"><i>" + pageName + "</i></a>");
            addSeperator = true;
        }
        if (new File(this.classesDirectory.getPath() + this.logicDir + this.logicFileName).exists()) {
            w.println("|&nbsp;<a target=\"_blank\" href=\"" + this.contextPath + Configuration.getJavaViewerLocation() + this.logicDir + this.logicFileName + "\"><i>" + this.logicFileName + "</i></a>");
            w.println("</span>");
        }
    }

    private void printTemplates(PrintWriter w, Map<String, Map<String, String>> t) {
        ArrayList<String> templates = new ArrayList<String>(t.keySet());
        Collections.sort(templates);
        if (templates.size() > 0) {
            for (String key : templates) {
                w.print("<input type=\"radio\" name=\"template\" value=\"" + key + "\"");
                if (key.equals(this.templateName)) {
                    w.print("checked=\"checked\" ");
                }
                w.println(" />" + key);
            }
        } else {
            w.println("none available");
        }
    }

    static {
        selectableCodeTypes = new Hashtable();
        selectableCodeTypesOrdered = new ArrayList();
        selectableQueryLanguages = new String[]{"OQL", "HQL"};
        builtIn = Configuration.getInternalCodeGeneratorTemplates();
        userDefined = Configuration.getApplicationSpecificCodeGeneratorTemplates();
        all = new HashMap<String, Map<String, String>>();
        GeneratedCodeViewer.initTemplates();
    }
}

