/*
 * Decompiled with CFR 0.152.
 */
package org.makumba.list.tags;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.tagext.BodyContent;
import javax.servlet.jsp.tagext.BodyTag;
import javax.servlet.jsp.tagext.Tag;
import org.apache.commons.collections.map.MultiValueMap;
import org.apache.commons.lang.StringUtils;
import org.makumba.LogicException;
import org.makumba.ProgrammerError;
import org.makumba.analyser.PageCache;
import org.makumba.analyser.TagData;
import org.makumba.commons.MultipleKey;
import org.makumba.commons.json.JSONObject;
import org.makumba.commons.tags.GenericMakumbaTag;
import org.makumba.list.engine.valuecomputer.ValueComputer;
import org.makumba.list.tags.QueryTag;

public class SectionTag
extends GenericMakumbaTag
implements BodyTag {
    private static final long serialVersionUID = 1L;
    public static final String MAKUMBA_EVENT = "__mak_event__";
    private String name;
    private String showOn;
    private String hideOn;
    private String reloadOn;
    private String iterationExpr;
    private String[] events;
    private String[] eventAction = new String[]{"show", "hide", "reload"};
    private BodyContent bodyContent;
    private boolean isInvoked = false;
    private boolean isFirstSection = false;
    private boolean isLastSection = false;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getShowOn() {
        return this.showOn;
    }

    public void setShowOn(String show) {
        this.showOn = show;
    }

    public String getHideOn() {
        return this.hideOn;
    }

    public void setHideOn(String hide) {
        this.hideOn = hide;
    }

    public String getReloadOn() {
        return this.reloadOn;
    }

    public void setReloadOn(String reload) {
        this.reloadOn = reload;
    }

    public String getIterationExpr() {
        return this.iterationExpr;
    }

    public void setIterationExpr(String iterationExpression) {
        this.iterationExpr = iterationExpression;
    }

    public void doInitBody() throws JspException {
    }

    public void setBodyContent(BodyContent b) {
        this.bodyContent = b;
    }

    public boolean canHaveBody() {
        return true;
    }

    public void setTagKey(PageCache pageCache) {
        this.tagKey = this.getTagKey(pageCache);
    }

    private MultipleKey getTagKey(PageCache pageCache) {
        return new MultipleKey(this.getSectionID(null), this.iterationExpr);
    }

    public boolean allowsIdenticalKey() {
        return false;
    }

    protected void doAnalyzedCleanup() {
        super.doAnalyzedCleanup();
        this.isLastSection = false;
        this.isFirstSection = false;
        this.iterationExpr = null;
        this.hideOn = null;
        this.showOn = null;
        this.reloadOn = null;
        this.name = null;
        this.events = null;
        this.bodyContent = null;
    }

    private void initialize(PageCache pageCache) {
        Map<Object, Object> tags = pageCache.retrieveCache("org.makumba.tagData");
        Iterator<Object> tagDataIterator = tags.keySet().iterator();
        boolean firstTag = true;
        MultipleKey lastSection = null;
        while (tagDataIterator.hasNext()) {
            MultipleKey key = (MultipleKey)tagDataIterator.next();
            Object o = ((TagData)tags.get(key)).getTagObject();
            if (!(o instanceof SectionTag)) continue;
            if (key.equals(this.getTagKey(pageCache)) && firstTag) {
                this.isFirstSection = true;
            }
            lastSection = key;
            firstTag = false;
        }
        if (lastSection.equals(this.getTagKey(pageCache))) {
            this.isLastSection = true;
        }
    }

    private boolean matches(String event, String exprValue) {
        boolean matches = false;
        if (event != null) {
            boolean invokesIteration;
            boolean bl = invokesIteration = event.indexOf("---") > -1;
            if (this.reloadOn != null) {
                matches = invokesIteration ? (this.reloadOn + exprValue).equals(event) : (this.reloadOn + exprValue).startsWith(event);
            } else if (this.showOn != null) {
                matches = invokesIteration ? (this.showOn + exprValue).equals(event) : (this.showOn + exprValue).startsWith(event);
            }
        }
        return matches;
    }

    public void doStartAnalyze(PageCache pageCache) {
        this.events = new String[]{this.showOn, this.hideOn, this.reloadOn};
        if (this.showOn == null && this.hideOn == null && this.reloadOn == null) {
            throw new ProgrammerError("A mak:section must have at least a 'show', 'hide' or 'reload' attribute specified");
        }
        if (this.showOn != null && this.hideOn != null && this.showOn.equals(this.hideOn)) {
            throw new ProgrammerError("Cannot show and hide a section for the same event");
        }
        if (this.reloadOn != null && this.hideOn != null && this.reloadOn.equals(this.hideOn)) {
            throw new ProgrammerError("Cannot reload and hide a section for the same event");
        }
        if (this.showOn != null && this.reloadOn != null && this.showOn.equals(this.reloadOn)) {
            throw new ProgrammerError("Cannot show and reload a section for the same event");
        }
        pageCache.cacheSetValues("org.makumba.neededResources", new String[]{"makumba.css", "prototype.js", "scriptaculous.js", "makumba-ajax.js"});
        QueryTag parentList = this.getParentListTag();
        if (parentList != null && this.iterationExpr != null) {
            Object check = pageCache.retrieve("org.makumba.valueComputers", this.tagKey);
            if (check == null) {
                ValueComputer vc = ValueComputer.getValueComputerAtAnalysis(false, QueryTag.getParentListKey(this, pageCache), this.iterationExpr, pageCache);
                pageCache.cache("org.makumba.valueComputers", this.tagKey, vc);
            }
        } else if (parentList == null) {
            this.cacheSectionResolution(pageCache, "", false);
        }
    }

    public int doAnalyzedStartTag(PageCache pageCache) throws LogicException, JspException {
        this.initialize(pageCache);
        QueryTag parentList = this.getParentListTag();
        String exprValue = this.getIterationExpressionValue(pageCache, parentList);
        this.isInvoked = this.matches(this.getPageContext().getRequest().getParameter(MAKUMBA_EVENT), exprValue);
        this.events = new String[]{this.showOn, this.hideOn, this.reloadOn};
        if (exprValue.length() > 0) {
            this.cacheSectionResolution(pageCache, exprValue, parentList != null && this.iterationExpr != null);
        }
        JspWriter out = this.getPageContext().getOut();
        try {
            if (!this.isInvoked) {
                if (this.isLastSection) {
                    if (parentList != null && parentList.getCurrentIterationNumber() == parentList.getNumberOfIterations()) {
                        out.print(this.getSectionDataScript(pageCache));
                    } else if (parentList == null) {
                        out.print(this.getSectionDataScript(pageCache));
                    }
                }
                out.print("<div id=\"" + this.getSectionID(exprValue) + "\"" + (this.showOn != null ? " style=\"display:none;\"" : "") + ">");
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return 2;
    }

    public int doAnalyzedEndTag(PageCache pageCache) throws LogicException, JspException {
        JspWriter out = this.getPageContext().getOut();
        try {
            if (this.isInvoked) {
                QueryTag parentList = this.getParentListTag();
                String exprValue = this.getIterationExpressionValue(pageCache, parentList);
                String eventName = "";
                if (this.reloadOn != null) {
                    eventName = this.reloadOn;
                } else if (this.showOn != null) {
                    eventName = this.showOn;
                }
                LinkedHashMap<String, String> sectionData = (LinkedHashMap<String, String>)this.pageContext.getRequest().getAttribute("__mak_event__###" + eventName + exprValue);
                if (sectionData == null) {
                    sectionData = new LinkedHashMap<String, String>();
                    this.pageContext.getRequest().setAttribute("__mak_event__###" + eventName + exprValue, sectionData);
                }
                StringWriter sw = new StringWriter();
                this.bodyContent.writeOut((Writer)sw);
                sectionData.put(this.getSectionID(exprValue), sw.toString());
            } else {
                this.bodyContent.writeOut((Writer)this.bodyContent.getEnclosingWriter());
                out.print("</div>");
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return super.doAnalyzedEndTag(pageCache);
    }

    private void cacheSectionResolution(PageCache pageCache, String exprValue, boolean iterationIdentifiable) throws ProgrammerError {
        for (int i = 0; i < this.events.length; ++i) {
            if (this.events[i] == null) continue;
            if (this.events[i].indexOf("___") > -1) {
                throw new ProgrammerError("Invalid event name '" + this.events[i] + "', '___' is not allowed in event names");
            }
            if (this.events[i].indexOf("---") > -1) {
                throw new ProgrammerError("Invalid event name '" + this.events[i] + "', '---' is not allowed in event names");
            }
            pageCache.cacheMultiple("org.makumba.sectionsEventToId", this.events[i], this.getSectionID(exprValue));
            pageCache.cache("org.makumba.sectionsEventToType", this.getSectionID(exprValue) + "___" + this.events[i], this.eventAction[i]);
            if (!iterationIdentifiable || StringUtils.isEmpty((String)exprValue)) continue;
            pageCache.cacheMultiple("org.makumba.sectionsEventToId", this.events[i] + exprValue, this.getSectionID(exprValue));
            pageCache.cache("org.makumba.sectionsEventToType", this.getSectionID(exprValue) + "___" + this.events[i] + exprValue, this.eventAction[i]);
        }
    }

    private String getIterationExpressionValue(PageCache pageCache, QueryTag parentList) {
        String exprValue = "";
        if (parentList != null && this.iterationExpr != null) {
            try {
                exprValue = "---" + ((ValueComputer)pageCache.retrieve("org.makumba.valueComputers", this.tagKey)).getValue(this.getPageContext()).toString();
            }
            catch (LogicException le) {
                le.printStackTrace();
            }
        } else if (parentList != null && this.iterationExpr == null) {
            exprValue = "---" + parentList.getCurrentIterationNumber();
        }
        return exprValue;
    }

    private String getSectionID(String iterationIdentifier) {
        return this.name + iterationIdentifier;
    }

    private String getSectionDataScript(PageCache pageCache) {
        HttpServletRequest req = (HttpServletRequest)this.pageContext.getRequest();
        String pagePath = req.getContextPath() + req.getServletPath();
        StringBuilder sb = new StringBuilder();
        sb.append("<script type=\"text/javascript\">\n");
        String eventToId = this.getEventToId(pageCache);
        String idEventToType = this.getIdEventToType(pageCache);
        sb.append("var mak = new Mak();\n");
        sb.append("var _mak_event_to_id_ = " + eventToId + ";\n");
        sb.append("var _mak_idevent_to_type_ = " + idEventToType + ";\n");
        sb.append("var _mak_page_url_ = '" + pagePath + "';\n");
        sb.append("var _mak_page_params_ = " + this.getQueryParameters(req) + ";\n");
        sb.append("</script>\n");
        return sb.toString();
    }

    private String getQueryParameters(HttpServletRequest req) {
        if (req.getParameter("__makumba__responder__") != null) {
            return new JSONObject().toString();
        }
        return new JSONObject(req.getParameterMap()).toString();
    }

    private String getIdEventToType(PageCache pageCache) {
        Map<Object, Object> idevent_to_type = pageCache.retrieveCache("org.makumba.sectionsEventToType");
        return new JSONObject(idevent_to_type).toString();
    }

    private String getEventToId(PageCache pageCache) {
        MultiValueMap eventToId = pageCache.retrieveMultiCache("org.makumba.sectionsEventToId");
        return new JSONObject((Map)eventToId).toString();
    }

    private QueryTag getParentListTag() {
        return (QueryTag)SectionTag.findAncestorWithClass((Tag)this, QueryTag.class);
    }
}

