/*
 * Decompiled with CFR 0.152.
 */
package org.makumba.providers.datadefinition.mdd;

import java.io.File;
import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Vector;
import org.makumba.DataDefinition;
import org.makumba.FieldDefinition;
import org.makumba.InvalidValueException;
import org.makumba.NoSuchFieldException;
import org.makumba.ValidationDefinition;
import org.makumba.ValidationRule;
import org.makumba.providers.datadefinition.mdd.FieldDefinitionImpl;
import org.makumba.providers.datadefinition.mdd.FieldNode;
import org.makumba.providers.datadefinition.mdd.FieldType;
import org.makumba.providers.datadefinition.mdd.MDDNode;
import org.makumba.providers.datadefinition.mdd.ValidationRuleNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataDefinitionImpl
implements DataDefinition,
ValidationDefinition,
Serializable {
    private static final long serialVersionUID = 5973863780194787175L;
    public static final String ENUM_FIELD_NAME = "enum";
    protected String name;
    protected String ptrSubfield;
    protected String indexName = "";
    protected String titleField;
    protected String titleFieldExpr;
    protected TitleFieldType titleFieldType;
    protected URL origin;
    protected DataDefinition parent;
    protected String fieldNameInParent;
    protected boolean isFileSubfield = false;
    protected String setMemberFieldName;
    protected String setOwnerFieldName;
    protected LinkedHashMap<String, FieldDefinition> fields = new LinkedHashMap();
    protected LinkedHashMap<String, ValidationRule> validationRules = new LinkedHashMap();
    protected LinkedHashMap<Object, DataDefinition.MultipleUniqueKeyDefinition> multiFieldUniqueList = new LinkedHashMap();
    protected LinkedHashMap<String, DataDefinition.QueryFragmentFunction> functions = new LinkedHashMap();
    private transient MDDNode mddNode;
    private transient LinkedHashMap<String, FieldNode> postponedFields = new LinkedHashMap();

    public DataDefinitionImpl(String name) {
        this.name = name;
        this.origin = null;
    }

    public DataDefinitionImpl(String name, DataDefinitionImpl parent) {
        this.name = parent.getName();
        this.ptrSubfield = "->" + name;
        this.origin = parent.origin;
        this.parent = parent;
        this.fieldNameInParent = name;
        this.addStandardFields(name);
    }

    public DataDefinitionImpl(String fieldName, MDDNode mdd, DataDefinition parent) {
        this.fieldNameInParent = fieldName;
        this.parent = parent;
        this.mddNode = mdd;
    }

    public DataDefinitionImpl(MDDNode mdd) {
        this.mddNode = mdd;
    }

    protected void build() {
        this.name = this.parent != null ? this.parent.getName() : this.mddNode.getName();
        this.ptrSubfield = this.mddNode.ptrSubfield;
        this.origin = this.mddNode.origin;
        this.indexName = this.mddNode.indexName;
        this.isFileSubfield = this.mddNode.isFileSubfield;
        switch (this.mddNode.titleField.titleType) {
            case 46: {
                this.titleFieldType = TitleFieldType.FIELD;
                this.titleFieldExpr = this.mddNode.titleField.getText();
                break;
            }
            case 48: {
                this.titleFieldType = TitleFieldType.FUNCTION;
                this.titleFieldExpr = this.mddNode.titleField.functionName;
            }
        }
        this.multiFieldUniqueList = this.mddNode.multiFieldUniqueList;
        this.addStandardFields(this.getName());
        this.addFieldNodes(this.mddNode.fields, false);
        this.addValidationRules(this.mddNode.validationRules);
        this.addFunctions(this.mddNode.functions);
        this.evaluateTitle();
        this.addFieldNodes(this.postponedFields, true);
    }

    private void addValidationRules(LinkedHashMap<String, ValidationRule> validationRules) {
        for (ValidationRule v : validationRules.values()) {
            ValidationRuleNode n = (ValidationRuleNode)v;
            for (String field : v.getValidationRuleArguments()) {
                FieldDefinition fd = this.getFieldOrPointedFieldDefinition(field);
                if (fd == null) {
                    FieldDefinition subFd = this.getFieldDefinition(n.field.mdd.fieldNameInParent);
                    if (subFd == null && (subFd = this.getFieldDefinition(n.field.subfield.fieldNameInParent)) == null) {
                        throw new RuntimeException("could not retrieve field definition for validation rule " + v.getRuleName());
                    }
                    fd = subFd.getSubtable().getFieldDefinition(field);
                    if (fd == null) {
                        throw new RuntimeException("could not retrieve field definition for validation rule " + v.getRuleName());
                    }
                }
                fd.addValidationRule(v);
            }
        }
        this.validationRules = validationRules;
    }

    private void addFieldNodes(LinkedHashMap<String, FieldNode> fields, boolean secondPass) {
        block7: for (FieldNode f : fields.values()) {
            FieldDefinitionImpl field = new FieldDefinitionImpl(this, f);
            switch (f.makumbaType) {
                case FILE: {
                    FieldDefinitionImpl fileField = this.buildFileField(f);
                    this.addField(fileField);
                    continue block7;
                }
                case PTRONE: {
                    this.addField(field);
                    continue block7;
                }
                case SETCOMPLEX: {
                    field.subfield.setOwnerFieldName = this.addPointerToParent(field, this.getPointerName(this.getName(), field));
                    this.addField(field);
                    continue block7;
                }
                case SET: {
                    if (!secondPass && field.getPointedType() == this) {
                        this.postponedFields.put(f.name, f);
                        continue block7;
                    }
                    field.subfield.setOwnerFieldName = this.addPointerToParent(field, this.getPointerName(this.getName(), field));
                    field.subfield.setMemberFieldName = this.addPointerToForeign(field);
                    this.addField(field);
                    continue block7;
                }
                case SETINTENUM: 
                case SETCHARENUM: {
                    field.subfield.setOwnerFieldName = this.addPointerToParent(field, this.getPointerName(this.getName(), field));
                    this.addField(field);
                    String type = "";
                    if (field.type == FieldType.SETINTENUM) {
                        type = "intEnum";
                    }
                    if (field.type == FieldType.SETCHARENUM) {
                        type = "charEnum";
                    }
                    FieldDefinitionImpl enumField = new FieldDefinitionImpl(ENUM_FIELD_NAME, type);
                    enumField.charEnumValues = field.charEnumValues;
                    enumField.charEnumValuesDeprecated = field.charEnumValuesDeprecated;
                    enumField.intEnumValues = field.intEnumValues;
                    enumField.intEnumValuesDeprecated = field.intEnumValuesDeprecated;
                    enumField.mdd = field.subfield;
                    enumField.description = field.name;
                    field.subfield.addField(enumField);
                    field.subfield.setMemberFieldName = ENUM_FIELD_NAME;
                    field.subfield.titleFieldExpr = ENUM_FIELD_NAME;
                    field.subfield.titleField = ENUM_FIELD_NAME;
                    continue block7;
                }
            }
            this.addField(field);
        }
    }

    private String addPointerToParent(FieldDefinitionImpl subField, String parentName) {
        FieldDefinitionImpl ptr = new FieldDefinitionImpl(parentName, "ptrRel");
        subField.subfield.addField(ptr);
        ptr.mdd = subField.subfield;
        ptr.fixed = true;
        ptr.notNull = true;
        ptr.type = FieldType.PTRREL;
        ptr.pointed = this;
        ptr.pointedType = this.getName();
        ptr.description = "relational pointer";
        return parentName;
    }

    private String addPointerToForeign(FieldDefinitionImpl subField) {
        int s;
        String pointed = null;
        if (subField.getPointedType() == this) {
            pointed = this.getPointerName(subField.pointedType, subField);
        } else if (subField.getPointedType() != this) {
            pointed = subField.pointedType;
        }
        if (this.shortName(pointed).equals(this.shortName(this.name))) {
            pointed = pointed + "_";
            while (subField.getSubtable().getFieldDefinition(pointed) != null) {
                pointed = pointed + "_";
            }
        }
        if ((s = pointed.indexOf("->")) != -1) {
            pointed = pointed.substring(s + 2);
        }
        pointed = this.shortName(pointed);
        FieldDefinitionImpl ptr = new FieldDefinitionImpl(pointed, "ptrRel");
        subField.subfield.addField(ptr);
        subField.subfield.titleField = subField.getPointedType().getTitleFieldName();
        ptr.mdd = subField.subfield;
        ptr.fixed = true;
        ptr.notNull = true;
        ptr.type = FieldType.PTRREL;
        ptr.pointed = subField.getPointedType();
        ptr.pointedType = subField.pointedType;
        ptr.description = "relational pointer";
        return pointed;
    }

    private String shortName(String t) {
        return t.indexOf(".") > 0 ? t.substring(t.lastIndexOf(".") + 1) : t;
    }

    private String getPointerName(String typeName, FieldDefinitionImpl subField) {
        int s = typeName.indexOf("->");
        if (s != -1) {
            typeName = typeName.substring(s + 2);
        }
        typeName = this.shortName(typeName);
        while (subField.getSubtable().getFieldDefinition(typeName) != null) {
            typeName = typeName + "_";
        }
        return typeName;
    }

    private void addStandardFields(String name) {
        int j = (name = this.shortName(name)).lastIndexOf("->");
        if (j > -1) {
            name = name.substring(j + 2);
        }
        this.indexName = name;
        FieldDefinitionImpl fi = new FieldDefinitionImpl(this.indexName, this);
        fi.type = FieldType.PTRINDEX;
        fi.description = "Unique index";
        fi.fixed = true;
        fi.notNull = true;
        fi.unique = true;
        fi.pointedType = this.getName();
        fi.pointed = this;
        this.addField(fi);
        fi = new FieldDefinitionImpl("TS_modify", this);
        fi.type = FieldType.DATEMODIFY;
        fi.notNull = true;
        fi.description = "Last modification date";
        this.addField(fi);
        fi = new FieldDefinitionImpl("TS_create", this);
        fi.type = FieldType.DATECREATE;
        fi.description = "Creation date";
        fi.fixed = true;
        fi.notNull = true;
        this.addField(fi);
    }

    private FieldDefinitionImpl buildFileField(FieldNode f) {
        FieldDefinitionImpl fi = new FieldDefinitionImpl(f.name, "ptrOne");
        fi.mdd = this;
        DataDefinitionImpl dd = new DataDefinitionImpl(f.getName(), this);
        dd.isFileSubfield = true;
        dd.addField(new FieldDefinitionImpl("content", "binary", dd));
        dd.addField(new FieldDefinitionImpl("contentLength", "int", dd));
        dd.addField(new FieldDefinitionImpl("contentType", "char", dd));
        dd.addField(new FieldDefinitionImpl("originalName", "char", dd));
        dd.addField(new FieldDefinitionImpl("name", "char", dd));
        dd.addField(new FieldDefinitionImpl("imageWidth", "int", dd));
        dd.addField(new FieldDefinitionImpl("imageHeight", "int", dd));
        fi.subfield = dd;
        return fi;
    }

    public void addFunctions(HashMap<String, DataDefinition.QueryFragmentFunction> funcNames) {
        for (DataDefinition.QueryFragmentFunction f : funcNames.values()) {
            this.addFunction(f.getName(), f);
        }
    }

    private void evaluateTitle() {
        if (this.titleFieldExpr == null) {
            String ptrIndexName = (String)Arrays.asList(this.fields.keySet().toArray()).get(0);
            if (this.fields.containsKey("name")) {
                this.titleField = "name";
            } else if (this.fields.keySet().size() > 3) {
                this.titleField = this.getFirstNonPointerFieldName(3);
                if (this.titleField == null) {
                    this.titleField = this.fields.get(ptrIndexName).getName();
                }
            } else if (this.fields.keySet().size() == 3 && this.postponedFields.keySet().size() > 0) {
                this.titleField = (String)Arrays.asList(this.postponedFields.keySet().toArray()).get(0);
            } else {
                this.titleField = this.getFirstNonPointerFieldName(0);
                if (this.titleField == null) {
                    this.titleField = this.fields.get(ptrIndexName).getName();
                }
            }
        } else if (this.titleFieldType == TitleFieldType.FUNCTION) {
            DataDefinition.QueryFragmentFunction f = this.functions.get(this.titleFieldExpr);
            this.titleField = f.getName() + "()";
        } else {
            this.titleField = this.titleFieldExpr;
        }
    }

    private String getFirstNonPointerFieldName(int index) {
        boolean isPtrOrSet;
        String field = null;
        int initial = index;
        while (field == null && index < this.fields.size()) {
            FieldDefinition titleDef = (FieldDefinition)Arrays.asList(this.fields.values().toArray()).get(index);
            if (titleDef.isPointer() || titleDef.isSetType()) {
                ++index;
                continue;
            }
            field = titleDef.getName();
        }
        String initialName = (String)Arrays.asList(this.fields.keySet().toArray()).get(initial);
        boolean bl = isPtrOrSet = this.fields.get(initialName).isPointer() || this.fields.get(initialName).isSetType();
        if (field == null && !isPtrOrSet) {
            field = initialName;
        } else if (field == null && isPtrOrSet) {
            return null;
        }
        return field;
    }

    @Override
    public String getName() {
        return (this.parent != null ? this.parent.getName() : this.name) + (this.ptrSubfield == null ? "" : this.ptrSubfield);
    }

    @Override
    public String getTitleFieldName() {
        return this.titleField;
    }

    @Override
    public boolean isTemporary() {
        return this.origin == null;
    }

    @Override
    public long lastModified() {
        return new File(this.origin.getFile()).lastModified();
    }

    @Override
    public DataDefinition getDataDefinition() {
        return this;
    }

    @Override
    public void addField(FieldDefinition fd) {
        ((FieldDefinitionImpl)fd).mdd = this;
        this.fields.put(fd.getName(), fd);
    }

    @Override
    public FieldDefinition getFieldDefinition(String name) {
        return this.fields.get(name);
    }

    @Override
    public FieldDefinition getFieldDefinition(int n) {
        if (n < 0 || n >= this.fields.size()) {
            return null;
        }
        return (FieldDefinition)this.fields.values().toArray()[n];
    }

    @Override
    public Vector<String> getFieldNames() {
        return new Vector<String>(this.fields.keySet());
    }

    @Override
    public FieldDefinition getFieldOrPointedFieldDefinition(String nm) {
        if (this.getFieldDefinition(nm) != null) {
            return this.getFieldDefinition(nm);
        }
        String fieldName = nm;
        DataDefinition dd = this;
        int indexOf = -1;
        while ((indexOf = fieldName.indexOf(".")) != -1) {
            String subFieldName = fieldName.substring(0, indexOf);
            fieldName = fieldName.substring(indexOf + 1);
            FieldDefinition fieldDefinition = dd.getFieldDefinition(subFieldName);
            dd = fieldDefinition.getPointedType();
        }
        return dd.getFieldDefinition(fieldName);
    }

    @Override
    public DataDefinition.QueryFragmentFunction getFunctionOrPointedFunction(String nm) {
        if (this.getFunction(nm) != null) {
            return this.getFunction(nm);
        }
        String fieldName = nm;
        DataDefinition dd = this;
        int indexOf = -1;
        while ((indexOf = fieldName.indexOf(".")) != -1) {
            String subFieldName = fieldName.substring(0, indexOf);
            fieldName = fieldName.substring(indexOf + 1);
            FieldDefinition fieldDefinition = dd.getFieldDefinition(subFieldName);
            dd = fieldDefinition.getPointedType();
        }
        return dd.getFunction(fieldName);
    }

    @Override
    public String getIndexPointerFieldName() {
        return this.indexName;
    }

    @Override
    public ArrayList<FieldDefinition> getReferenceFields() {
        ArrayList<FieldDefinition> l = new ArrayList<FieldDefinition>();
        for (FieldDefinition fieldDefinition : this.fields.values()) {
            FieldDefinition fd = fieldDefinition;
            if (!fd.isPointer() && !fd.isExternalSet() && !fd.isComplexSet()) continue;
            l.add(fd);
        }
        return l;
    }

    @Override
    public ArrayList<FieldDefinition> getUniqueFields() {
        ArrayList<FieldDefinition> l = new ArrayList<FieldDefinition>();
        for (FieldDefinition fieldDefinition : this.fields.values()) {
            FieldDefinition fd = fieldDefinition;
            if (!fd.isUnique() || fd.isIndexPointerField()) continue;
            l.add(fd);
        }
        return l;
    }

    @Override
    public void addMultiUniqueKey(DataDefinition.MultipleUniqueKeyDefinition definition) {
        this.multiFieldUniqueList.put(definition.getFields(), definition);
    }

    @Override
    public boolean hasMultiUniqueKey(String[] fieldNames) {
        return this.multiFieldUniqueList.get(fieldNames) != null;
    }

    @Override
    public DataDefinition.MultipleUniqueKeyDefinition[] getMultiFieldUniqueKeys() {
        return this.multiFieldUniqueList.values().toArray(new DataDefinition.MultipleUniqueKeyDefinition[this.multiFieldUniqueList.values().size()]);
    }

    @Override
    public void checkFieldNames(Dictionary<String, Object> d) {
        Enumeration<String> e = d.keys();
        while (e.hasMoreElements()) {
            String s = e.nextElement();
            if (this.getFieldDefinition(s) != null) continue;
            throw new NoSuchFieldException(this, s);
        }
    }

    @Override
    public void checkUpdate(String fieldName, Dictionary<String, Object> d) {
        Object o = d.get(fieldName);
        if (o != null) {
            switch (this.getFieldDefinition(fieldName).getIntegerType()) {
                case 10: {
                    throw new InvalidValueException(this.getFieldDefinition(fieldName), "you cannot update a creation date");
                }
                case 11: {
                    throw new InvalidValueException(this.getFieldDefinition(fieldName), "you cannot update a modification date");
                }
                case 3: {
                    throw new InvalidValueException(this.getFieldDefinition(fieldName), "you cannot update an index pointer");
                }
            }
            this.getFieldDefinition(fieldName).checkUpdate(d);
        }
    }

    @Override
    public void addFunction(String name, DataDefinition.QueryFragmentFunction function) {
        this.functions.put(name, function);
    }

    @Override
    public Collection<DataDefinition.QueryFragmentFunction> getActorFunctions() {
        ArrayList<DataDefinition.QueryFragmentFunction> actorFunctions = new ArrayList<DataDefinition.QueryFragmentFunction>();
        for (DataDefinition.QueryFragmentFunction function : this.functions.values()) {
            if (!function.isActorFunction()) continue;
            actorFunctions.add(function);
        }
        return actorFunctions;
    }

    @Override
    public DataDefinition.QueryFragmentFunction getFunction(String name) {
        return this.functions.get(name);
    }

    @Override
    public Collection<DataDefinition.QueryFragmentFunction> getFunctions() {
        return this.functions.values();
    }

    @Override
    public Collection<DataDefinition.QueryFragmentFunction> getSessionFunctions() {
        ArrayList<DataDefinition.QueryFragmentFunction> sessionFunctions = new ArrayList<DataDefinition.QueryFragmentFunction>();
        for (DataDefinition.QueryFragmentFunction function : this.functions.values()) {
            if (!function.isSessionFunction()) continue;
            sessionFunctions.add(function);
        }
        return sessionFunctions;
    }

    @Override
    public FieldDefinition getParentField() {
        if (this.parent == null) {
            return null;
        }
        return this.parent.getFieldDefinition(this.fieldNameInParent);
    }

    @Override
    public String getSetMemberFieldName() {
        return this.setMemberFieldName;
    }

    @Override
    public String getSetOwnerFieldName() {
        return this.setOwnerFieldName;
    }

    @Override
    public ValidationDefinition getValidationDefinition() {
        return this;
    }

    @Override
    public void addRule(String fieldName, Collection<ValidationRule> rules) {
        this.getFieldDefinition(fieldName).addValidationRule(rules);
    }

    @Override
    public void addRule(String fieldName, ValidationRule rule) {
        this.getFieldDefinition(fieldName).addValidationRule(rule);
    }

    @Override
    public Collection<ValidationRule> getValidationRules(String fieldName) {
        return this.getFieldDefinition(fieldName).getValidationRules();
    }

    @Override
    public boolean hasValidationRules() {
        return this.validationRules.size() > 0;
    }

    @Override
    public ValidationRule getValidationRule(String ruleName) {
        return this.validationRules.get(ruleName);
    }

    @Override
    public String getCreationDateFieldName() {
        return "TS_create";
    }

    @Override
    public String getLastModificationDateFieldName() {
        return "TS_modify";
    }

    public String toString() {
        return this.getName();
    }

    public String toString1() {
        StringBuffer sb = new StringBuffer();
        sb.append("==== MDD " + this.name + "\n");
        sb.append("   == origin: " + this.origin + "\n");
        sb.append("   == indexName: " + this.indexName + "\n");
        sb.append("   == titleField: " + this.titleField + "\n");
        if (this.parent != null) {
            sb.append("   == parent: " + this.parent.getName() + "\n");
        }
        sb.append("   == parentFieldName: " + this.fieldNameInParent + "\n");
        sb.append("   == isFileSubfield: " + this.isFileSubfield + "\n");
        sb.append("\n   === Fields \n\n");
        for (FieldDefinition fieldDefinition : this.fields.values()) {
            sb.append(fieldDefinition.toString() + "\n");
        }
        sb.append("\n   === Validation rules \n\n");
        for (ValidationRule validationRule : this.validationRules.values()) {
            sb.append(validationRule.toString() + "\n");
        }
        sb.append("\n   === Multi-unique keys \n\n");
        for (DataDefinition.MultipleUniqueKeyDefinition multipleUniqueKeyDefinition : this.multiFieldUniqueList.values()) {
            sb.append(multipleUniqueKeyDefinition.toString() + "\n");
        }
        sb.append("\n   === Functions \n\n");
        for (DataDefinition.QueryFragmentFunction queryFragmentFunction : this.functions.values()) {
            sb.append(queryFragmentFunction.toString() + "\n");
        }
        return sb.toString();
    }

    public String getStructure() {
        StringBuffer sb = new StringBuffer();
        sb.append("getName() " + this.getName() + "\n");
        sb.append("getFieldNames()\n");
        for (String n : this.getFieldNames()) {
            sb.append(n + "\n");
        }
        sb.append("isTemporary() " + this.isTemporary() + "\n");
        sb.append("getTitleFieldName() " + this.getTitleFieldName() + "\n");
        sb.append("getIndexPointerFieldName() " + this.getIndexPointerFieldName() + "\n");
        sb.append("getParentField()\n");
        sb.append(this.getParentField() + "\n");
        sb.append("getSetMemberFieldName() " + this.getSetMemberFieldName() + "\n");
        sb.append("getSetOwnerFieldName() " + this.getSetOwnerFieldName() + "\n");
        sb.append("lastModified() " + this.lastModified() + "\n");
        sb.append("getFieldDefinition()\n");
        for (String n : this.getFieldNames()) {
            sb.append(((FieldDefinitionImpl)this.getFieldDefinition(n)).getStructure() + "\n");
        }
        sb.append("getReferenceFields()\n");
        for (FieldDefinition fi : this.getReferenceFields()) {
            sb.append(((FieldDefinitionImpl)fi).getStructure() + "\n");
        }
        return sb.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static enum TitleFieldType {
        FIELD,
        FUNCTION;

    }
}

