/*
 * Decompiled with CFR 0.152.
 */
package org.makumba;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.InetAddress;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Properties;
import java.util.logging.Logger;
import org.makumba.commons.ClassResource;

public class version {
    static String getVersion() {
        String vs = "$HeadURL: https://makumba.svn.sourceforge.net/svnroot/makumba/tags/makumba-0_8_2_7_1/makumba/classes/org/makumba/version.java $";
        String version2 = "1";
        if ((vs = vs.substring("$HeadURL: https://makumba.svn.sourceforge.net/svnroot/makumba/".length())).startsWith("tags")) {
            vs = vs.substring("tags/".length());
            version2 = (vs = vs.substring(0, vs.indexOf("/"))).substring(7);
            if (version2.indexOf(45) >= 0) {
                version2 = version2.substring(version2.indexOf(45) + 1);
            }
            if (version2.length() > 2) {
                version2 = version2.replace('_', '.');
            }
        } else {
            SimpleDateFormat df = new SimpleDateFormat("yyyyMMddHHmmss");
            Date buildDate = version.getBuildDate();
            version2 = buildDate != null ? "devel-" + df.format(version.getBuildDate()) : "devel-DATE-NOT-FOUND";
        }
        return version2;
    }

    @Deprecated
    static String getVersionDewey() {
        String vs = version.getVersion();
        return vs.substring(vs.indexOf(45) + 1, vs.length());
    }

    static final Date getBuildDate() {
        SimpleDateFormat df = new SimpleDateFormat("yyyyMMddHHmmss");
        Properties prop = new Properties();
        String filename = "org/makumba/versionBuildDate.properties";
        Date buildDate = null;
        try {
            prop.load(ClassResource.get(filename).openStream());
            buildDate = df.parse(prop.getProperty("buildDate"), new ParsePosition(0));
        }
        catch (Exception e) {
            Logger.getLogger("org.makumba.version").severe("There was a problem reading the Makumba 'versionBuildDate.properties'. If you deleted the working directory of your web application, please make sure you reload the web application!");
        }
        return buildDate;
    }

    public static void main(String[] args) {
        System.out.println("name=Makumba");
        System.out.println("version=" + version.getVersion());
        System.out.println("date=" + new Date());
        try {
            System.out.println("buildhost=" + InetAddress.getLocalHost().getHostName() + " (" + InetAddress.getLocalHost().getHostAddress() + ")");
        }
        catch (Exception e) {
            System.out.println("buildhost=unknown.host");
        }
        System.out.println("java.vendor=" + System.getProperty("java.vendor"));
        System.out.println("java.version=" + System.getProperty("java.version"));
    }

    public static String getGlobalSVNRevision() {
        Process p1;
        StringWriter out = new StringWriter();
        PrintWriter ps = new PrintWriter(out);
        try {
            p1 = Runtime.getRuntime().exec("svnversion -n " + new File(".").getAbsolutePath(), null, new File(".").getAbsoluteFile());
        }
        catch (IOException e) {
            if (e.getMessage().indexOf("2") > 0) {
                System.out.println("you need to have svn utils installed in order to retrieve the gloabl build version");
            }
            ps.println(e);
            return "";
        }
        final Process p = p1;
        final PrintWriter ps1 = ps;
        new Thread(new Runnable(){

            public void run() {
                version.flushTo(new BufferedReader(new InputStreamReader(p.getErrorStream()), 81960), ps1);
            }
        }).start();
        version.flushTo(new BufferedReader(new InputStreamReader(p.getInputStream()), 81960), ps);
        try {
            p.waitFor();
        }
        catch (InterruptedException e) {
            return "";
        }
        return ((Object)out).toString();
    }

    public static void flushTo(BufferedReader r, PrintWriter o) {
        try {
            String s;
            while ((s = r.readLine()) != null) {
                o.println(s);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

