/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.stripes.controller;

import java.beans.Introspector;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Set;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import net.sourceforge.stripes.config.BootstrapPropertyResolver;
import net.sourceforge.stripes.config.Configuration;
import net.sourceforge.stripes.config.RuntimeConfiguration;
import net.sourceforge.stripes.controller.FlashScope;
import net.sourceforge.stripes.controller.StripesRequestWrapper;
import net.sourceforge.stripes.exception.StripesRuntimeException;
import net.sourceforge.stripes.exception.StripesServletException;
import net.sourceforge.stripes.util.Log;

public class StripesFilter
implements Filter {
    public static final String CONFIG_CLASS = "Configuration.Class";
    private static final Log log = Log.getInstance(StripesFilter.class);
    private Configuration configuration;
    private ServletContext servletContext;
    private static final ThreadLocal<Configuration> configurationStash = new ThreadLocal();
    private static final Set<WeakReference<Configuration>> configurations = new HashSet<WeakReference<Configuration>>();
    private static final ThreadLocal<Boolean> initialInvocation = new ThreadLocal<Boolean>(){

        @Override
        protected Boolean initialValue() {
            return true;
        }
    };

    public void init(FilterConfig filterConfig) throws ServletException {
        BootstrapPropertyResolver bootstrap = new BootstrapPropertyResolver(filterConfig);
        Class<Configuration> clazz = bootstrap.getClassProperty(CONFIG_CLASS, Configuration.class);
        if (clazz == null) {
            clazz = RuntimeConfiguration.class;
        }
        try {
            this.configuration = clazz.newInstance();
        }
        catch (Exception e) {
            log.fatal(e, "Could not instantiate specified Configuration. Class name specified was ", "[", clazz.getName(), "].");
            throw new StripesServletException("Could not instantiate specified Configuration. Class name specified was [" + clazz.getName() + "].", e);
        }
        this.configuration.setBootstrapPropertyResolver(bootstrap);
        this.configuration.init();
        configurations.add(new WeakReference<Configuration>(this.configuration));
        this.servletContext = filterConfig.getServletContext();
        this.servletContext.setAttribute(StripesFilter.class.getName(), (Object)this);
        Package pkg = this.getClass().getPackage();
        log.info("Stripes Initialization Complete. Version: ", pkg.getSpecificationVersion(), ", Build: ", pkg.getImplementationVersion());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Configuration getConfiguration() {
        Configuration configuration = configurationStash.get();
        if (configuration == null) {
            Set<WeakReference<Configuration>> set = configurations;
            synchronized (set) {
                Iterator<WeakReference<Configuration>> iterator = configurations.iterator();
                while (iterator.hasNext()) {
                    WeakReference<Configuration> ref = iterator.next();
                    if (ref.get() != null) continue;
                    iterator.remove();
                }
                if (configurations.size() == 1) {
                    configuration = (Configuration)configurations.iterator().next().get();
                }
            }
        }
        if (configuration == null) {
            StripesRuntimeException sre = new StripesRuntimeException("Something is trying to access the current Stripes configuration but the current request was never routed through the StripesFilter! As a result the appropriate Configuration object cannot be located. Please take a look at the exact URL in your browser's address bar and ensure that any requests to that URL will be filtered through the StripesFilter according to the filter mappings in your web.xml.");
            log.error(sre, new Object[0]);
        }
        return configuration;
    }

    public Configuration getInstanceConfiguration() {
        return this.configuration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        Object httpRequest = (HttpServletRequest)servletRequest;
        HttpServletResponse httpResponse = (HttpServletResponse)servletResponse;
        boolean initial = initialInvocation.get();
        if (initial) {
            initialInvocation.set(false);
        }
        try {
            log.trace("Intercepting request to URL: ", httpRequest.getRequestURI());
            if (initial) {
                configurationStash.set(this.configuration);
                Locale locale = this.configuration.getLocalePicker().pickLocale((HttpServletRequest)httpRequest);
                log.debug("LocalePicker selected locale: ", locale);
                String encoding = this.configuration.getLocalePicker().pickCharacterEncoding((HttpServletRequest)httpRequest, locale);
                if (encoding != null) {
                    httpRequest.setCharacterEncoding(encoding);
                    log.debug("LocalePicker selected character encoding: ", encoding);
                } else {
                    log.debug("LocalePicker did not pick a character encoding, using default: ", httpRequest.getCharacterEncoding());
                }
                StripesRequestWrapper request = this.wrapRequest((HttpServletRequest)httpRequest);
                request.setLocale(locale);
                httpResponse.setLocale(locale);
                if (encoding != null) {
                    httpResponse.setCharacterEncoding(encoding);
                }
                httpRequest = request;
            } else {
                StripesRequestWrapper.findStripesWrapper((ServletRequest)httpRequest).pushUriParameters((HttpServletRequestWrapper)httpRequest);
            }
            this.flashInbound((HttpServletRequest)httpRequest);
            filterChain.doFilter((ServletRequest)httpRequest, servletResponse);
        }
        catch (Throwable t) {
            this.configuration.getExceptionHandler().handle(t, (HttpServletRequest)httpRequest, httpResponse);
        }
        finally {
            if (initial) {
                initialInvocation.set(true);
                this.flashOutbound((HttpServletRequest)httpRequest);
                configurationStash.remove();
            } else {
                StripesRequestWrapper.findStripesWrapper((ServletRequest)httpRequest).popUriParameters();
            }
        }
    }

    protected StripesRequestWrapper wrapRequest(HttpServletRequest servletRequest) throws StripesServletException {
        try {
            return StripesRequestWrapper.findStripesWrapper((ServletRequest)servletRequest);
        }
        catch (IllegalStateException e) {
            return new StripesRequestWrapper(servletRequest);
        }
    }

    protected void flashInbound(HttpServletRequest req) {
        FlashScope flash = FlashScope.getPrevious(req);
        if (flash != null) {
            flash.beginRequest(req);
        }
    }

    protected void flashOutbound(HttpServletRequest req) {
        FlashScope flash = FlashScope.getCurrent(req, false);
        if (flash != null) {
            flash.completeRequest();
        }
    }

    public void destroy() {
        this.servletContext.removeAttribute(StripesFilter.class.getName());
        Log.cleanup();
        Introspector.flushCaches();
    }
}

