/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.xhtmldoclet.pages;

import com.sun.javadoc.Doc;
import com.sun.javadoc.PackageDoc;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sourceforge.xhtmldoclet.AbstractPageWriter;
import net.sourceforge.xhtmldoclet.AbstractXhtmlWriter;
import net.sourceforge.xhtmldoclet.Doclet;

public final class OverviewSummary
extends AbstractPageWriter {
    private PackageDoc[] packages;
    private Map groupPackageMap;
    private List groupList;
    private final AbstractXhtmlWriter.TagBuilder th = (AbstractXhtmlWriter)this.new AbstractXhtmlWriter.TagBuilder("th");
    private final AbstractXhtmlWriter.TagBuilder td = (AbstractXhtmlWriter)this.new AbstractXhtmlWriter.TagBuilder("td");

    public static void generateOverviewSummary() {
        String filename = "overview-summary" + OverviewSummary.CONF.ext;
        try {
            new OverviewSummary(filename);
        }
        catch (IOException exc) {
            throw Doclet.exception(exc, filename);
        }
    }

    private OverviewSummary(String filename) throws IOException {
        super(filename);
        this.pageType = "OVERVIEW";
        this.packages = OverviewSummary.CONF.packages;
        this.groupPackageMap = this.packages != null ? OverviewSummary.CONF.group.groupPackages(this.packages) : new HashMap();
        this.groupList = OverviewSummary.CONF.group.getGroupList();
        this.windowTitle = CONF.propertyText("OverviewTitle", new Object[0]);
        String[] metakeywords = new String[]{this.windowTitle};
        if (OverviewSummary.CONF.doctitle.length() > 0) {
            metakeywords[0] = metakeywords[0] + ", " + OverviewSummary.CONF.doctitle;
        }
        String setFrameScript = "parent.packageFrame.location.href = 'allclasses-frame" + OverviewSummary.CONF.ext + "';";
        this.printXhtmlHeader(metakeywords, true, setFrameScript);
        this.println(this.open("h1") + CONF.propertyText("OverviewTitle", new Object[0]) + this.close("h1"));
        this.printOverviewHeader();
        if (OverviewSummary.CONF.packages != null && OverviewSummary.CONF.packages.length > 0) {
            Arrays.sort(OverviewSummary.CONF.packages);
            this.println(this.open("h2") + CONF.propertyText("summary.Package", new Object[0]) + this.close("h2"));
            this.println(this.open("table"));
            for (PackageDoc pkg : this.packages) {
                this.printIndexRow(pkg);
            }
            this.println(this.close("table"));
        }
        this.printOverview();
        this.printXhtmlFooter();
        this.close();
    }

    private void printOverviewHeader() {
        if (OverviewSummary.CONF.root.inlineTags().length > 0) {
            this.println(CONF.propertyText("doclet.See", new Object[0]));
            this.println(this.linkToLabelHref(CONF.propertyText("Description", new Object[0]), "#overview_description"));
        }
    }

    private void printIndexRow(PackageDoc pkg) {
        if (pkg != null && pkg.name().length() > 0) {
            this.println(this.open("tr"));
            this.print(this.th.getOpenTextClose(this.linkToLabelHref(pkg.name(), this.hrefToDoc((Doc)pkg) + "package-summary" + OverviewSummary.CONF.ext)));
            this.print(this.td.getOpenTextClose(this.getCommentSummary((Doc)pkg)));
            this.println(this.close("tr"));
        }
    }

    private void printOverview() {
        if (OverviewSummary.CONF.root.inlineTags().length > 0) {
            this.println(this.openDivWithID("overview_description"));
            this.println(this.close("div"));
        }
    }

    protected void navLinkOverview() {
        this.println(this.listItemCurrent(OVERVIEW));
    }
}

