/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.xhtmldoclet.pages;

import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.Doc;
import com.sun.javadoc.PackageDoc;
import com.sun.javadoc.ProgramElementDoc;
import com.sun.tools.doclets.internal.toolkit.Configuration;
import com.sun.tools.doclets.internal.toolkit.util.DirectoryManager;
import com.sun.tools.doclets.internal.toolkit.util.Util;
import java.io.IOException;
import java.util.Arrays;
import java.util.Vector;
import net.sourceforge.xhtmldoclet.AbstractPageWriter;
import net.sourceforge.xhtmldoclet.Config;
import net.sourceforge.xhtmldoclet.Doclet;

public final class PackageSummary
extends AbstractPageWriter {
    private String pkgName;
    private PackageDoc prev;
    private PackageDoc next;
    private ClassDoc[] classes;
    private ClassDoc[] interfaces;
    private ClassDoc[] enums;
    private ClassDoc[] exceptions;
    private ClassDoc[] errors;
    private ClassDoc[] annotationTypes;

    public static void generatePackageSummary(PackageDoc pkg, PackageDoc prev, PackageDoc next) {
        String path = DirectoryManager.getDirectoryPath((PackageDoc)pkg);
        String filename = "package-summary" + PackageSummary.CONF.ext;
        try {
            new PackageSummary(filename, path, pkg, prev, next);
            Util.copyDocFiles((Configuration)CONF, (String)Util.getPackageSourcePath((Configuration)CONF, (PackageDoc)pkg), (String)(DirectoryManager.getDirectoryPath((PackageDoc)pkg) + SLASH + "doc-files"), (boolean)true);
        }
        catch (IOException exc) {
            throw Doclet.exception(exc, filename);
        }
    }

    private PackageSummary(String filename, String pathToFile, PackageDoc pkg, PackageDoc prev, PackageDoc next) throws IOException {
        super(filename, pathToFile);
        this.pageType = "PACKAGE";
        this.pkgName = pkg.name();
        PackageSummary.CONF.currentPkg = pkg;
        this.prev = prev;
        this.next = next;
        this.interfaces = pkg.isIncluded() ? pkg.interfaces() : PackageSummary.CONF.classDocCatalog.interfaces(this.pkgName);
        this.classes = pkg.isIncluded() ? pkg.ordinaryClasses() : PackageSummary.CONF.classDocCatalog.ordinaryClasses(this.pkgName);
        this.enums = pkg.isIncluded() ? pkg.enums() : PackageSummary.CONF.classDocCatalog.enums(this.pkgName);
        this.exceptions = pkg.isIncluded() ? pkg.exceptions() : PackageSummary.CONF.classDocCatalog.exceptions(this.pkgName);
        this.errors = pkg.isIncluded() ? pkg.errors() : PackageSummary.CONF.classDocCatalog.errors(this.pkgName);
        this.annotationTypes = pkg.isIncluded() ? pkg.annotationTypes() : PackageSummary.CONF.classDocCatalog.annotationTypes(this.pkgName);
        this.windowTitle = pkg.name();
        String setFrameScript = "parent.packageFrame.location.href = 'package-frame" + PackageSummary.CONF.ext + "';";
        String[] metakeywords = new String[]{pkg.name() + " " + "package"};
        this.printXhtmlHeader(metakeywords, true, setFrameScript);
        this.printEntityCaption((Doc)pkg, CONF.propertyText("Package", new Object[0]));
        if (!PackageSummary.CONF.nocomment && pkg.inlineTags().length > 0) {
            this.println(this.openDivWithID("Overview"));
            this.print(this.open("p"));
            this.print(this.getCommentSummary((Doc)pkg));
            this.println(this.open("span") + " (" + this.linkToLabelHref("See full package description", "#Package-Description") + ")" + this.close("span"));
            this.print(this.close("p"));
            this.println(this.close("div") + this.getComment("Overview"));
        }
        this.println(this.openDivWithID("Summaries"));
        this.printGroupSummary(this.interfaces, Summary.INTERFACE);
        this.printGroupSummary(this.classes, Summary.CLASS);
        this.printGroupSummary(this.enums, Summary.ENUM);
        this.printGroupSummary(this.exceptions, Summary.EXCEPTION);
        this.printGroupSummary(this.errors, Summary.ERROR);
        this.printGroupSummary(this.annotationTypes, Summary.ANNOTATION_TYPE);
        this.println(this.close("div") + this.getComment("Summaries"));
        if (pkg.inlineTags().length > 0) {
            this.println(this.openDivWithID("Package-Description"));
            this.println(this.open("h2") + CONF.propertyText("Description", new Object[0]) + this.close("h2"));
            this.println(this.getCommentTagsString((Doc)pkg, pkg.inlineTags(), false, false));
            this.println("[TODO: Print extra package tags]");
            this.println(this.close("div") + this.getComment("Package-Description"));
        }
        this.printXhtmlFooter();
        this.close();
    }

    private void printGroupSummary(ClassDoc[] groupElements, Summary label) {
        if (groupElements != null && groupElements.length > 0) {
            Arrays.sort(groupElements);
            this.println(this.openDivWithID(Util.replaceText((String)label.headingTitle, (String)" ", (String)"-")));
            this.println(this.open("h2") + (Object)((Object)label) + this.close("h2"));
            this.println(this.open("table"));
            for (ClassDoc classDoc : groupElements) {
                if (!Util.isCoreClass((ClassDoc)classDoc) || !CONF.isGeneratedDoc((Doc)classDoc)) continue;
                if (Util.isDeprecated((ProgramElementDoc)classDoc)) {
                    this.println(this.open("tr class=\"deprecated\""));
                } else {
                    this.println(this.open("tr"));
                }
                this.println(this.open("th") + this.linkToLabelHref(classDoc.name() + this.typeParameters((Doc)classDoc), classDoc.name() + PackageSummary.CONF.ext) + this.close("th"));
                this.print(this.open("td"));
                if (Util.isDeprecated((ProgramElementDoc)classDoc)) {
                    this.print(this.bold(CONF.propertyText("Deprecated", new Object[0])) + ". ");
                }
                this.print(this.getCommentSummary((Doc)classDoc));
                this.println(this.close("td"));
                this.println(this.close("tr"));
            }
            this.println(this.close("table"));
            this.println(this.close("div"));
        }
    }

    protected void navLinkPackage() {
        this.println(this.listItemCurrent(PACKAGE));
    }

    protected void navLinkUse() {
        this.println(this.listItem(this.linkToLabelHrefTitle(USE, "package-use" + PackageSummary.CONF.ext, CONF.propertyText("navtitle.Use", this.pkgName))));
    }

    protected void navLinkTree() {
        this.println(this.listItem(this.linkToLabelHrefTitle(TREE, "package-tree" + PackageSummary.CONF.ext, CONF.propertyText("navtitle.Tree.package", this.pkgName))));
    }

    protected void navWithinPage() {
        this.print(this.open("td id=\"WithinPage\""));
        Vector<String> summaries = new Vector<String>();
        if (this.interfaces.length > 0) {
            summaries.add(this.linkToLabelHref(CONF.propertyText("Interfaces", new Object[0]), "#Interface-Summary"));
        }
        if (this.classes.length > 0) {
            summaries.add(this.linkToLabelHref(CONF.propertyText("Classes", new Object[0]), "#Class-Summary"));
        }
        if (this.enums.length > 0) {
            summaries.add(this.linkToLabelHref(CONF.propertyText("Enums", new Object[0]), "#Enum-Summary"));
        }
        if (this.exceptions.length > 0) {
            summaries.add(this.linkToLabelHref(CONF.propertyText("Exceptions", new Object[0]), "#Exception-Summary"));
        }
        if (this.errors.length > 0) {
            summaries.add(this.linkToLabelHref(CONF.propertyText("Errors", new Object[0]), "#Error-Summary"));
        }
        if (this.annotationTypes.length > 0) {
            summaries.add(this.linkToLabelHref(CONF.propertyText("AnnotationTypes", new Object[0]), "#Annotation-Type-Summary"));
        }
        this.printUnorderedListWithLast(summaries);
        this.println(this.close("td"));
    }

    protected void navPreviousNext() {
        this.println(this.openULWithID("PreviousNext"));
        this.println(this.listItem(this.linkToLabelHref(PREV_PKG, this.hrefToDoc((Doc)this.prev) + "package-summary" + PackageSummary.CONF.ext)) + this.listItemLast(this.linkToLabelHref(NEXT_PKG, this.hrefToDoc((Doc)this.next) + "package-summary" + PackageSummary.CONF.ext)));
        this.println(this.close("ul"));
    }

    static /* synthetic */ Config access$000() {
        return CONF;
    }

    static /* synthetic */ Config access$100() {
        return CONF;
    }

    static /* synthetic */ Config access$200() {
        return CONF;
    }

    static /* synthetic */ Config access$300() {
        return CONF;
    }

    static /* synthetic */ Config access$400() {
        return CONF;
    }

    static /* synthetic */ Config access$500() {
        return CONF;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Summary {
        INTERFACE(PackageSummary.access$000().propertyText("summary.Interface", new Object[0])),
        CLASS(PackageSummary.access$100().propertyText("summary.Class", new Object[0])),
        ENUM(PackageSummary.access$200().propertyText("summary.Enum", new Object[0])),
        EXCEPTION(PackageSummary.access$300().propertyText("summary.Exception", new Object[0])),
        ERROR(PackageSummary.access$400().propertyText("summary.Error", new Object[0])),
        ANNOTATION_TYPE(PackageSummary.access$500().propertyText("summary.Annotation_Types", new Object[0]));

        private String headingTitle;

        private Summary(String headingTitle) {
            this.headingTitle = headingTitle;
        }

        public String toString() {
            return this.headingTitle;
        }
    }
}

