/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.xhtmldoclet.pages;

import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.Doc;
import com.sun.javadoc.PackageDoc;
import com.sun.tools.doclets.internal.toolkit.util.DirectoryManager;
import com.sun.tools.doclets.internal.toolkit.util.Util;
import java.io.IOException;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.TreeSet;
import net.sourceforge.xhtmldoclet.AbstractPageWriter;
import net.sourceforge.xhtmldoclet.AbstractXhtmlWriter;
import net.sourceforge.xhtmldoclet.Doclet;

public final class PackageUse
extends AbstractPageWriter {
    private PackageDoc pkg;
    private PackageDoc prev;
    private PackageDoc next;
    private SortedMap<String, Set<ClassDoc>> usingPackageToUsedClasses = null;

    public static void generatePackageUse(PackageDoc pkg, PackageDoc prev, PackageDoc next) {
        String filename = "package-use" + PackageUse.CONF.ext;
        String pathToFile = DirectoryManager.getDirectoryPath((PackageDoc)pkg);
        try {
            new PackageUse(filename, pathToFile, pkg, prev, next);
        }
        catch (IOException exc) {
            throw Doclet.exception(exc, pathToFile + SLASH + filename);
        }
    }

    private PackageUse(String filename, String pathToFile, PackageDoc pkg, PackageDoc prev, PackageDoc next) throws IOException {
        super(filename, pathToFile);
        this.pageType = "PACKAGE_USE";
        PackageUse.CONF.currentPkg = pkg;
        this.pkg = pkg;
        this.prev = prev;
        this.next = next;
        this.windowTitle = pkg.name();
        this.printXhtmlHeader();
        this.printEntityCaption((Doc)pkg, "Usage of Package");
        this.createPackageToClassMapping();
        if (this.usingPackageToUsedClasses.isEmpty()) {
            this.println(CONF.propertyText("use.No_usage_of_0", pkg.name()));
        } else {
            this.println(this.openDivWithID("Summaries"));
            if (PackageUse.CONF.packages.length > 1) {
                this.println(this.open("h2") + CONF.propertyText("use.Packages_that_use_0", this.linkToLabelHref(pkg.name(), "package-summary" + PackageUse.CONF.ext)) + this.close("h2"));
                this.println(this.open("table"));
                for (String pkgName : this.usingPackageToUsedClasses.keySet()) {
                    PackageDoc cur = PackageUse.CONF.root.packageNamed(pkgName);
                    this.println(this.open("tr"));
                    this.printTH(this.linkToLabelHref(cur.name(), "#" + cur.name()));
                    this.printTD(this.getCommentSummary((Doc)cur));
                    this.println(this.close("tr"));
                }
                this.println(this.close("table"));
            }
            this.println(this.close("div") + this.getComment("Summaries"));
            this.println(this.openDivWithID("Details"));
            for (String packageName : this.usingPackageToUsedClasses.keySet()) {
                PackageDoc usingPackage = PackageUse.CONF.root.packageNamed(packageName);
                String label = CONF.propertyText("use.Classes_used_by_0", this.getPackageLink(usingPackage, Util.getPackageName((PackageDoc)usingPackage), false));
                this.println((AbstractXhtmlWriter)this.new AbstractXhtmlWriter.TagBuilder("h3").add("id", usingPackage.name()).getOpenTextClose(label));
                this.println(this.open("table"));
                for (ClassDoc cur : (Set)this.usingPackageToUsedClasses.get(packageName)) {
                    this.println(this.open("tr"));
                    this.printTH(this.linkToLabelHref(cur.name(), "class-use" + SLASH + cur.name() + PackageUse.CONF.ext + "#" + packageName));
                    this.printTD(this.getCommentSummary((Doc)cur));
                    this.println(this.close("tr"));
                }
                this.println(this.close("table"));
            }
            this.println(this.close("div") + this.getComment("Details"));
        }
        this.printXhtmlFooter();
        this.close();
    }

    private void createPackageToClassMapping() {
        this.usingPackageToUsedClasses = new TreeMap<String, Set<ClassDoc>>();
        for (ClassDoc usedClass : this.pkg.allClasses()) {
            Set usingClasses = (Set)PackageUse.CONF.classUseMapper.classToClass.get(usedClass.qualifiedName());
            if (usingClasses == null) continue;
            for (ClassDoc usingClass : usingClasses) {
                PackageDoc usingPackage = usingClass.containingPackage();
                TreeSet<ClassDoc> usedClasses = (TreeSet<ClassDoc>)this.usingPackageToUsedClasses.get(usingPackage.name());
                if (usedClasses == null) {
                    usedClasses = new TreeSet<ClassDoc>();
                    this.usingPackageToUsedClasses.put(usingPackage.name(), usedClasses);
                }
                usedClasses.add(usedClass);
            }
        }
    }

    protected void navLinkPackage() {
        this.println(this.listItem(this.linkToLabelHrefTitle(PACKAGE, "package-summary" + PackageUse.CONF.ext, CONF.propertyText("navtitle.Package", this.pkg.name()))));
    }

    protected void navLinkUse() {
        this.println(this.listItemCurrent(USE));
    }

    protected void navLinkTree() {
        this.println(this.listItem(this.linkToLabelHrefTitle(TREE, "package-tree" + PackageUse.CONF.ext, CONF.propertyText("navtitle.Tree.package", this.pkg.name()))));
    }

    protected void navPreviousNext() {
        this.println(this.openULWithID("PreviousNext"));
        this.println(this.listItem(this.linkToLabelHref(PREV_PKG, this.hrefToDoc((Doc)this.prev) + "package-use" + PackageUse.CONF.ext)) + this.listItemLast(this.linkToLabelHref(NEXT_PKG, this.hrefToDoc((Doc)this.next) + "package-use" + PackageUse.CONF.ext)));
        this.println(this.close("ul"));
    }
}

