/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.xhtmldoclet.writers;

import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.Doc;
import com.sun.javadoc.PackageDoc;
import com.sun.tools.doclets.internal.toolkit.Configuration;
import com.sun.tools.doclets.internal.toolkit.util.DirectoryManager;
import com.sun.tools.doclets.internal.toolkit.util.Util;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import net.sourceforge.xhtmldoclet.Config;
import net.sourceforge.xhtmldoclet.Doclet;
import net.sourceforge.xhtmldoclet.writers.HtmlDocletWriter;
import net.sourceforge.xhtmldoclet.writers.LinkInfoImpl;

public class PackageFrameWriter
extends HtmlDocletWriter {
    private PackageDoc packageDoc;
    private Set documentedClasses;
    public static final String OUTPUT_FILE_NAME = "package-frame.html";

    public PackageFrameWriter(Config configuration, PackageDoc packageDoc) throws IOException {
        super(configuration, DirectoryManager.getDirectoryPath((PackageDoc)packageDoc), OUTPUT_FILE_NAME, DirectoryManager.getRelativePath((PackageDoc)packageDoc));
        this.packageDoc = packageDoc;
        if (configuration.root.specifiedPackages().length == 0) {
            this.documentedClasses = new HashSet<ClassDoc>(Arrays.asList(configuration.root.classes()));
        }
    }

    public static void generate(Config configuration, PackageDoc packageDoc) {
        try {
            PackageFrameWriter packgen = new PackageFrameWriter(configuration, packageDoc);
            String pkgName = Util.getPackageName((PackageDoc)packageDoc);
            String[] metakeywords = new String[]{pkgName + " " + "package"};
            packgen.printHtmlHeader(pkgName, metakeywords, false);
            packgen.printPackageHeader(pkgName);
            packgen.generateClassListing();
            packgen.printBodyHtmlEnd();
            packgen.close();
        }
        catch (IOException exc) {
            throw Doclet.exception(exc, OUTPUT_FILE_NAME);
        }
    }

    protected void generateClassListing() {
        Configuration config = this.configuration();
        if (this.packageDoc.isIncluded()) {
            this.generateClassKindListing(this.packageDoc.interfaces(), this.configuration.getText("doclet.Interfaces"));
            this.generateClassKindListing(this.packageDoc.ordinaryClasses(), this.configuration.getText("doclet.Classes"));
            this.generateClassKindListing(this.packageDoc.enums(), this.configuration.getText("doclet.Enums"));
            this.generateClassKindListing(this.packageDoc.exceptions(), this.configuration.getText("doclet.Exceptions"));
            this.generateClassKindListing(this.packageDoc.errors(), this.configuration.getText("doclet.Errors"));
            this.generateClassKindListing((ClassDoc[])this.packageDoc.annotationTypes(), this.configuration.getText("doclet.AnnotationTypes"));
        } else {
            String name = Util.getPackageName((PackageDoc)this.packageDoc);
            this.generateClassKindListing(config.classDocCatalog.interfaces(name), this.configuration.getText("doclet.Interfaces"));
            this.generateClassKindListing(config.classDocCatalog.ordinaryClasses(name), this.configuration.getText("doclet.Classes"));
            this.generateClassKindListing(config.classDocCatalog.enums(name), this.configuration.getText("doclet.Enums"));
            this.generateClassKindListing(config.classDocCatalog.exceptions(name), this.configuration.getText("doclet.Exceptions"));
            this.generateClassKindListing(config.classDocCatalog.errors(name), this.configuration.getText("doclet.Errors"));
            this.generateClassKindListing(config.classDocCatalog.annotationTypes(name), this.configuration.getText("doclet.AnnotationTypes"));
        }
    }

    protected void generateClassKindListing(ClassDoc[] arr, String label) {
        if (arr.length > 0) {
            Arrays.sort(arr);
            this.printPackageTableHeader();
            this.fontSizeStyle("+1", "FrameHeadingFont");
            boolean printedHeader = false;
            for (int i = 0; i < arr.length; ++i) {
                if (this.documentedClasses != null && !this.documentedClasses.contains(arr[i]) || !Util.isCoreClass((ClassDoc)arr[i]) || !this.configuration.isGeneratedDoc((Doc)arr[i])) continue;
                if (!printedHeader) {
                    this.print(label);
                    this.fontEnd();
                    this.println("&nbsp;");
                    this.fontStyle("FrameItemFont");
                    printedHeader = true;
                }
                this.br();
                this.printLink(new LinkInfoImpl(13, arr[i], arr[i].isInterface() ? this.italicsText(arr[i].name()) : arr[i].name(), "classFrame"));
            }
            this.fontEnd();
            this.printPackageTableFooter();
            this.println();
        }
    }

    protected void printPackageHeader(String heading) {
        this.fontSizeStyle("+1", "FrameTitleFont");
        this.printTargetPackageLink(this.packageDoc, "classFrame", heading);
        this.fontEnd();
    }

    protected void printPackageTableHeader() {
        this.table();
        this.tr();
        this.tdNowrap();
    }

    protected void printPackageTableFooter() {
        this.tdEnd();
        this.trEnd();
        this.tableEnd();
    }
}

