/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.openpgp;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.openpgp.KeyRing;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPObjectFactory;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPPublicKeyRing;
import org.bouncycastle.openpgp.PGPSecretKey;
import org.bouncycastle.openpgp.PGPSecretKeyRing;
import org.bouncycastle.openpgp.PGPUtil;

public class BouncyCastleKeyRing
implements KeyRing {
    private final Map pgpSec = new HashMap();
    private char[] password;
    private final Map pgpPub = new HashMap();
    private static final long MASK = 0xFFFFFFFFL;

    public BouncyCastleKeyRing() {
    }

    public BouncyCastleKeyRing(InputStream secretKeyRingStream, InputStream publicKeyRingStream, char[] password) throws IOException, PGPException {
        this.addSecretKeyRing(secretKeyRingStream, password);
        this.addPublicKeyRing(publicKeyRingStream);
    }

    public void addPublicKeyRing(InputStream publicKeyRingStream) throws IOException, PGPException {
        Object obj;
        PGPObjectFactory pgpFact = new PGPObjectFactory(PGPUtil.getDecoderStream((InputStream)publicKeyRingStream));
        while ((obj = pgpFact.nextObject()) != null) {
            if (!(obj instanceof PGPPublicKeyRing)) {
                throw new PGPException(obj.getClass().getName() + " found where PGPPublicKeyRing expected");
            }
            PGPPublicKeyRing keyRing = (PGPPublicKeyRing)obj;
            Long key = new Long(keyRing.getPublicKey().getKeyID() & 0xFFFFFFFFL);
            this.pgpPub.put(key, keyRing.getPublicKey());
        }
    }

    public void addSecretKeyRing(InputStream secretKeyRingStream, char[] password) throws IOException, PGPException {
        Object obj;
        PGPObjectFactory pgpFact = new PGPObjectFactory(PGPUtil.getDecoderStream((InputStream)secretKeyRingStream));
        while ((obj = pgpFact.nextObject()) != null) {
            if (!(obj instanceof PGPSecretKeyRing)) {
                throw new PGPException(obj.getClass().getName() + " found where PGPSecretKeyRing expected");
            }
            PGPSecretKeyRing pgpSecret = (PGPSecretKeyRing)obj;
            Long key = new Long(pgpSecret.getSecretKey().getKeyID() & 0xFFFFFFFFL);
            this.pgpSec.put(key, pgpSecret.getSecretKey());
        }
        this.password = password;
    }

    public char[] getPassword() {
        return this.password;
    }

    public PGPSecretKey getSecretKey(String keyId) {
        return (PGPSecretKey)this.pgpSec.get(Long.valueOf(keyId, 16));
    }

    public PGPPublicKey getPublicKey(String keyId) {
        return (PGPPublicKey)this.pgpPub.get(Long.valueOf(keyId, 16));
    }

    public PGPSecretKey getSecretKey(long keyId) {
        return (PGPSecretKey)this.pgpSec.get(new Long(keyId & 0xFFFFFFFFL));
    }

    public PGPPublicKey getPublicKey(long keyId) {
        return (PGPPublicKey)this.pgpPub.get(new Long(keyId & 0xFFFFFFFFL));
    }
}

