/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.openpgp;

import java.io.IOException;
import java.io.InputStream;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.Security;
import java.security.SignatureException;
import org.apache.commons.openpgp.KeyRing;
import org.apache.commons.openpgp.OpenPgpException;
import org.apache.commons.openpgp.OpenPgpStreamingSignatureVerifier;
import org.apache.commons.openpgp.SignatureStatus;
import org.apache.commons.openpgp.UnknownKeyException;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.openpgp.PGPCompressedData;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPObjectFactory;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPSignature;
import org.bouncycastle.openpgp.PGPSignatureList;
import org.bouncycastle.openpgp.PGPUtil;

public class BouncyCastleOpenPgpStreamingSignatureVerifier
implements OpenPgpStreamingSignatureVerifier {
    private PGPSignature sig;

    public BouncyCastleOpenPgpStreamingSignatureVerifier(InputStream signature, KeyRing keyRing) throws OpenPgpException, IOException {
        this.init(signature, keyRing);
    }

    private void init(InputStream signature, KeyRing keyRing) throws OpenPgpException, IOException {
        Security.addProvider((Provider)new BouncyCastleProvider());
        try {
            PGPObjectFactory pgpFact;
            Object o;
            signature = PGPUtil.getDecoderStream((InputStream)signature);
            PGPPublicKey key = null;
            block3: while (key == null && signature.available() > 0 && (o = (pgpFact = new PGPObjectFactory(signature)).nextObject()) != null) {
                PGPSignatureList p3;
                if (o instanceof PGPCompressedData) {
                    PGPCompressedData c1 = (PGPCompressedData)o;
                    pgpFact = new PGPObjectFactory(c1.getDataStream());
                    p3 = (PGPSignatureList)pgpFact.nextObject();
                } else {
                    p3 = (PGPSignatureList)o;
                }
                for (int i = 0; i < p3.size(); ++i) {
                    this.sig = p3.get(i);
                    key = keyRing.getPublicKey(this.sig.getKeyID());
                    if (key != null) continue block3;
                }
            }
            if (key == null) {
                throw new UnknownKeyException("Unable to find key with key ID '" + Long.toHexString(this.sig.getKeyID()).toUpperCase() + "' in public key ring");
            }
            this.sig.initVerify(key, "BC");
        }
        catch (NoSuchProviderException e) {
            throw new OpenPgpException("Unable to find the correct provider for PGP - check that the Bouncy Castle provider is correctly installed", e);
        }
        catch (PGPException e) {
            throw new OpenPgpException("Error calculating detached signature", e);
        }
    }

    public void update(byte[] buf) throws OpenPgpException {
        this.update(buf, 0, buf.length);
    }

    public void update(byte[] buf, int offset, int length) throws OpenPgpException {
        try {
            this.sig.update(buf, offset, length);
        }
        catch (SignatureException e) {
            throw new OpenPgpException("Error calculating detached signature", e);
        }
    }

    public SignatureStatus finish() throws OpenPgpException, IOException {
        try {
            if (this.sig.verify()) {
                return SignatureStatus.VALID_UNTRUSTED;
            }
            return SignatureStatus.INVALID;
        }
        catch (PGPException e) {
            throw new OpenPgpException("Error calculating detached signature", e);
        }
        catch (SignatureException e) {
            throw new OpenPgpException("Error calculating detached signature", e);
        }
    }
}

