/*
 * Decompiled with CFR 0.152.
 */
package beansoft.util.logging;

import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;

public class Logger
implements Serializable {
    private final String name;
    private static Map loggerInstances = new TreeMap();
    private static final int NONE = 7;
    private static final int ALL = 1;
    private static final int FATAL = 6;
    private static final int ERROR = 5;
    private static final int WARN = 4;
    private static final int INFO = 3;
    private static final int DEBUG = 2;
    private static int logLevel = 7;
    static /* synthetic */ Class class$0;

    static {
        Properties props = new Properties();
        try {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("beansoft.util.logging.Logger");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            props.load(clazz.getResourceAsStream("log.properties"));
            String levelStr = props.getProperty("loglevel");
            if ("ALL".equalsIgnoreCase(levelStr)) {
                logLevel = 1;
            } else if ("ERROR".equalsIgnoreCase(levelStr)) {
                logLevel = 5;
            } else if ("WARN".equalsIgnoreCase(levelStr)) {
                logLevel = 4;
            } else if ("INFO".equalsIgnoreCase(levelStr)) {
                logLevel = 3;
            } else if ("DEBUG".equalsIgnoreCase(levelStr)) {
                logLevel = 2;
            } else if ("NONE".equalsIgnoreCase(levelStr)) {
                logLevel = 7;
            } else if ("FATAL".equalsIgnoreCase(levelStr)) {
                logLevel = 6;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected Logger(String name) {
        this.name = name;
    }

    private String formatCurrentDate() {
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
        return formatter.format(new Date());
    }

    public int getLogLevel() {
        return logLevel;
    }

    public String getName() {
        return this.name;
    }

    public boolean isDebugEnabled() {
        return this.getLogLevel() >= 2;
    }

    public void debug(Object message) {
        if (this.getLogLevel() <= 2) {
            System.out.println(String.valueOf(this.formatCurrentDate()) + " " + this.getName() + ":debug:" + message);
        }
    }

    public void debug(Object message, Throwable t) {
        if (this.getLogLevel() <= 2) {
            System.out.println(String.valueOf(this.formatCurrentDate()) + " " + this.getName() + ":" + "debug:" + message);
            t.printStackTrace();
        }
    }

    public boolean isInfoEnabled() {
        return this.getLogLevel() <= 3;
    }

    public void info(Object message) {
        if (this.getLogLevel() <= 3) {
            System.out.println(String.valueOf(this.formatCurrentDate()) + " " + this.getName() + ":" + "info:" + message);
        }
    }

    public void info(Object message, Throwable t) {
        if (this.getLogLevel() <= 3) {
            System.out.println(String.valueOf(this.formatCurrentDate()) + " " + this.getName() + ":" + "info:" + message);
            t.printStackTrace();
        }
    }

    public void warn(Object message) {
        if (this.getLogLevel() <= 4) {
            System.out.println(String.valueOf(this.formatCurrentDate()) + " " + this.getName() + ":" + "warn:" + message);
        }
    }

    public void warn(Object message, Throwable t) {
        if (this.getLogLevel() <= 4) {
            System.out.println(String.valueOf(this.formatCurrentDate()) + " " + this.getName() + ":" + "warn:" + message);
            t.printStackTrace();
        }
    }

    public void error(Object message) {
        if (this.getLogLevel() <= 5) {
            System.err.println(String.valueOf(this.formatCurrentDate()) + " " + this.getName() + ":" + "error:" + message);
        }
    }

    public void error(Object message, Throwable t) {
        if (this.getLogLevel() <= 5) {
            System.err.println(String.valueOf(this.formatCurrentDate()) + " " + this.getName() + ":" + "error:" + message);
            t.printStackTrace(System.err);
        }
    }

    public void fatal(Object message) {
        if (this.getLogLevel() <= 6) {
            System.err.println(String.valueOf(this.formatCurrentDate()) + " " + this.getName() + ":" + "fatal error:" + message);
        }
    }

    public void fatal(Object message, Throwable t) {
        if (this.getLogLevel() <= 6) {
            System.err.println(String.valueOf(this.formatCurrentDate()) + " " + this.getName() + ":" + "fatal error:" + message);
            t.printStackTrace(System.err);
        }
    }

    public static Logger getAnonymousLogger() {
        return Logger.getLogger("");
    }

    public static Logger getLogger(String name) {
        Logger instance = (Logger)loggerInstances.get(name);
        if (instance == null) {
            instance = new Logger(name);
            loggerInstances.put(name, instance);
        }
        return instance;
    }

    public static Logger getLogger(String name, String suffix) {
        return Logger.getLogger(String.valueOf(name) + "." + suffix);
    }

    public static Logger getLogger(Class clazz) {
        return Logger.getLogger(clazz.getName());
    }

    public static Logger getLogger(Class clazz, String suffix) {
        return Logger.getLogger(String.valueOf(clazz.getName()) + "." + suffix);
    }

    public String toString() {
        return String.valueOf(this.getClass().getName()) + "[" + this.getName() + "]";
    }

    public static void main(String[] args) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("beansoft.util.logging.Logger");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Logger.getLogger(clazz).fatal("fatal");
        Logger.getLogger("test").error("error");
        Logger.getLogger("test").debug("debug");
    }
}

