/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.openpgp;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.InvalidKeyException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.Signature;
import java.security.SignatureException;
import org.bouncycastle.bcpg.BCPGInputStream;
import org.bouncycastle.bcpg.BCPGOutputStream;
import org.bouncycastle.bcpg.OnePassSignaturePacket;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPSignature;
import org.bouncycastle.openpgp.PGPUtil;

public class PGPOnePassSignature {
    private OnePassSignaturePacket sigPack;
    private int signatureType;
    private Signature sig;
    private byte lastb;

    PGPOnePassSignature(BCPGInputStream bCPGInputStream) throws IOException, PGPException {
        this((OnePassSignaturePacket)bCPGInputStream.readPacket());
    }

    PGPOnePassSignature(OnePassSignaturePacket onePassSignaturePacket) throws PGPException {
        this.sigPack = onePassSignaturePacket;
        this.signatureType = onePassSignaturePacket.getSignatureType();
    }

    public void initVerify(PGPPublicKey pGPPublicKey, String string) throws NoSuchProviderException, PGPException {
        this.initVerify(pGPPublicKey, PGPUtil.getProvider(string));
    }

    public void initVerify(PGPPublicKey pGPPublicKey, Provider provider) throws PGPException {
        this.lastb = 0;
        try {
            this.sig = Signature.getInstance(PGPUtil.getSignatureName(this.sigPack.getKeyAlgorithm(), this.sigPack.getHashAlgorithm()), provider);
        }
        catch (Exception exception) {
            throw new PGPException("can't set up signature object.", exception);
        }
        try {
            this.sig.initVerify(pGPPublicKey.getKey(provider));
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new PGPException("invalid key.", invalidKeyException);
        }
    }

    public void update(byte by) throws SignatureException {
        if (this.signatureType == 1) {
            if (by == 13) {
                this.sig.update((byte)13);
                this.sig.update((byte)10);
            } else if (by == 10) {
                if (this.lastb != 13) {
                    this.sig.update((byte)13);
                    this.sig.update((byte)10);
                }
            } else {
                this.sig.update(by);
            }
            this.lastb = by;
        } else {
            this.sig.update(by);
        }
    }

    public void update(byte[] byArray) throws SignatureException {
        if (this.signatureType == 1) {
            for (int i = 0; i != byArray.length; ++i) {
                this.update(byArray[i]);
            }
        } else {
            this.sig.update(byArray);
        }
    }

    public void update(byte[] byArray, int n, int n2) throws SignatureException {
        if (this.signatureType == 1) {
            int n3 = n + n2;
            for (int i = n; i != n3; ++i) {
                this.update(byArray[i]);
            }
        } else {
            this.sig.update(byArray, n, n2);
        }
    }

    public boolean verify(PGPSignature pGPSignature) throws PGPException, SignatureException {
        this.sig.update(pGPSignature.getSignatureTrailer());
        return this.sig.verify(pGPSignature.getSignature());
    }

    public long getKeyID() {
        return this.sigPack.getKeyID();
    }

    public int getSignatureType() {
        return this.sigPack.getSignatureType();
    }

    public int getHashAlgorithm() {
        return this.sigPack.getHashAlgorithm();
    }

    public int getKeyAlgorithm() {
        return this.sigPack.getKeyAlgorithm();
    }

    public byte[] getEncoded() throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        this.encode(byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    public void encode(OutputStream outputStream) throws IOException {
        BCPGOutputStream bCPGOutputStream = outputStream instanceof BCPGOutputStream ? (BCPGOutputStream)outputStream : new BCPGOutputStream(outputStream);
        bCPGOutputStream.writePacket(this.sigPack);
    }
}

