package org.mortbay.cometd.demo;

import java.util.Map;

import javax.servlet.ServletContextAttributeEvent;
import javax.servlet.ServletContextAttributeListener;

import org.mortbay.cometd.Bayeux;
import org.mortbay.cometd.Channel;
import org.mortbay.cometd.ChannelId;
import org.mortbay.cometd.Client;
import org.mortbay.cometd.AbstractCometdServlet;
import org.mortbay.cometd.DataFilter;

public class BayeuxStartupListener implements ServletContextAttributeListener
{
    public void initialize(Bayeux bayeux)
    {
        synchronized(bayeux)
        {
            if (bayeux.getChannel("/rpc/echo")==null)
            {
                
                 new EchoRPC(bayeux,"/rpc/echo");

                Client monitor_client=new Client(bayeux,"monitor")
                {
                    protected void deliver(Client from, ChannelId to, Map<String, Object> message)
                    {
                        System.out.println("BayeuxStartupListener: "+from+"-->"+to+" "+message);
                    }
                };
                
                bayeux.getChannel("/meta/handshake",true).addSubscriber(monitor_client);
                bayeux.getChannel("/meta/connect",true).addSubscriber(monitor_client);
                bayeux.getChannel("/meta/subscribe",true).addSubscriber(monitor_client);
                bayeux.getChannel("/meta/unsubscribe",true).addSubscriber(monitor_client);
                
            }
        }

    }
    
    public void attributeAdded(ServletContextAttributeEvent scab)
    {
        if (scab.getName().equals(AbstractCometdServlet.ORG_MORTBAY_BAYEUX))
        {
            Bayeux bayeux=(Bayeux)scab.getValue();
            initialize(bayeux);
        }
    }

    public void attributeRemoved(ServletContextAttributeEvent scab)
    {

    }

    public void attributeReplaced(ServletContextAttributeEvent scab)
    {

    }

    
    private static class EchoRPC extends Client
    {
        Channel _channel;
        
        public EchoRPC(Bayeux bayeux,String channel)
        {
            super(bayeux,"echo");

            synchronized(this)
            {
                _channel = bayeux.getChannel(channel,true);
                _channel.addSubscriber(this);
            }
        }

        protected void deliver(Client from, ChannelId to, Map<String, Object> message)
        {
            synchronized(this)
            {
                String reply_channel_id=_channel.getId()+"/"+from.getId();
                ChannelId replyId=_bayeux.getChannelId(reply_channel_id);
                _bayeux.publish(replyId,this,message.get(Bayeux.DATA_FIELD),null);
            }
        }

        public void init(Object init)
        {
        }
        
    }
    
}
