/*
 * @(#)StringUtil.java	1.0 2003.11.2
 *
 * Copyright 2003 - 2006 BeanSoft Studio. All rights reserved.
 */

package beansoft.jsp;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.text.ParseException;
import java.util.Date;

import javax.servlet.ServletContext;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.PageContext;

import beansoft.util.OS;

/**
 * StringUtil, ַ, һЩַ߷.
 *
 * Dependencies: Servlet/JSP API.
 *
 * @author beansoft
 * @version 1.2 2006-07-31
 */
public class StringUtil {
	public static String escape(String src) {
		int i;
		char j;
		StringBuffer tmp = new StringBuffer();
		tmp.ensureCapacity(src.length() * 6);
		for (i = 0; i < src.length(); i++) {
			j = src.charAt(i);
			if (Character.isDigit(j) || Character.isLowerCase(j)
					|| Character.isUpperCase(j))
				tmp.append(j);
			else if (j < 256) {
				tmp.append("%");
				if (j < 16)
					tmp.append("0");
				tmp.append(Integer.toString(j, 16));
			} else {
				tmp.append("%u");
				tmp.append(Integer.toString(j, 16));
			}
		}
		return tmp.toString();
	}

	public static String unescape(String src) {
		StringBuffer tmp = new StringBuffer();
		tmp.ensureCapacity(src.length());
		int lastPos = 0, pos = 0;
		char ch;
		while (lastPos < src.length()) {
			pos = src.indexOf("%", lastPos);
			if (pos == lastPos) {
				if (src.charAt(pos + 1) == 'u') {
					ch = (char) Integer.parseInt(src
							.substring(pos + 2, pos + 6), 16);
					tmp.append(ch);
					lastPos = pos + 6;
				} else {
					ch = (char) Integer.parseInt(src
							.substring(pos + 1, pos + 3), 16);
					tmp.append(ch);
					lastPos = pos + 3;
				}
			} else {
				if (pos == -1) {
					tmp.append(src.substring(lastPos));
					lastPos = src.length();
				} else {
					tmp.append(src.substring(lastPos, pos));
					lastPos = pos;
				}
			}
		}
		return tmp.toString();
	}

	/**
	 * ȡ·еԴļļ·.
	 * NOTE:  Win32 ƽ̨²ͨ.
	 * @date 2005.10.16
	 * @param resourcePath Դ·
	 * @return ļ·
	 */
	public static String getRealFilePath(String resourcePath) {
		java.net.URL inputURL = StringUtil.class
							.getResource(resourcePath);

		String filePath = inputURL.getFile();

		// For windows platform, the filePath will like this:
		// /E:/Push/web/WEB-INF/classes/studio/beansoft/smtp/MailSender.ini
		// So must remove the first /

		if(OS.isWindows() && filePath.startsWith("/")) {
			filePath = filePath.substring(1);
		}

		return filePath;
	}


	/**
	 * ַתΪ int.
	 *
	 * @param input
	 *            ִ
	 * @date 2005-07-29
	 * @return 
	 */
	public static int parseInt(String input) {
		try {
			return Integer.parseInt(input);
		} catch (Exception e) {
			// TODO: handle exception
		}
		return 0;
	}

	/**
	 * ʽڵʱʱʽʾ. d HH:mm:ss
	 *
	 * @return - String ʽʱ
	 */
	public static String formatDateToDHMSString(java.util.Date date) {
		if (date == null) {
			return "";
		}

		java.text.SimpleDateFormat dateFormat = new java.text.SimpleDateFormat(
				"d HH:mm:ss");

		return dateFormat.format(date);

	}

	/**
	 * ʽڵʱʱʽʾ.
	 *
	 * @return - String ʽʱ
	 */
	public static String formatDateToHMSString(java.util.Date date) {
		if (date == null) {
			return "";
		}

		java.text.SimpleDateFormat dateFormat = new java.text.SimpleDateFormat(
				"HH:mm:ss");

		return dateFormat.format(date);

	}

	/**
	 * ʱʱʽַתΪ.
	 *
	 * @param input
	 * @return
	 */
	public static Date parseHMSStringToDate(String input) {
		java.text.SimpleDateFormat dateFormat = new java.text.SimpleDateFormat(
				"HH:mm:ss");

		try {
			return dateFormat.parse(input);
		} catch (ParseException e) {
			e.printStackTrace();
		}

		return null;
	}

	/**
	 * ʽڵ Mysql ݿڸʽַʾ.
	 *
	 * @return - String ʽʱ
	 */
	public static String formatDateToMysqlString(java.util.Date date) {
		if (date == null) {
			return "";
		}

		java.text.SimpleDateFormat dateFormat = new java.text.SimpleDateFormat(
				"yyyy-MM-dd HH:mm:ss");

		return dateFormat.format(date);

	}

	/**
	 *  Mysql ݿڸʽַתΪ.
	 *
	 * @param input
	 * @return
	 */
	public static Date parseStringToMysqlDate(String input) {
		java.text.SimpleDateFormat dateFormat = new java.text.SimpleDateFormat(
				"yyyy-MM-dd HH:mm:ss");

		try {
			return dateFormat.parse(input);
		} catch (ParseException e) {
			e.printStackTrace();
		}

		return null;
	}

	/**
	 * ʱַ, ɶʽ, Md HH:mm ʽ. 2004-09-22, LiuChangjiong
	 *
	 * @return - String ʽʱ
	 */
	public static String formatDateToMMddHHmm(java.util.Date date) {
		if (date == null) {
			return "";
		}

		java.text.SimpleDateFormat dateFormat = new java.text.SimpleDateFormat(
				"Md HH:mm");

		return dateFormat.format(date);
	}

	/**
	 * ʱַ, ɶʽ, yyMdHH:mm ʽ. 2004-10-04, LiuChangjiong
	 *
	 * @return - String ʽʱ
	 */
	public static String formatDateToyyMMddHHmm(java.util.Date date) {
		if (date == null) {
			return "";
		}

		java.text.SimpleDateFormat dateFormat = new java.text.SimpleDateFormat(
				"yyMdHH:mm");

		return dateFormat.format(date);
	}

	/**
	 *  HTTP  Referer, û, ͷĬҳֵ.
	 *
	 * ƶͿҳ: // Added at 2004-10-12 // ǰһҳĵַ _action.jsp ,
	 * Ϊ˱ӳ, ͷĬҳ
	 *
	 * 2006-08-02 Ӵ url  referer ж 
	 * 
	 * @param request -
	 *            HttpServletRequest 
	 * @param defaultPage -
	 *            String, Ĭҳ
	 * @return String - Referfer
	 */
	public static String getReferer(HttpServletRequest request,
			String defaultPage) {
		String referer = request.getHeader("Referer");// ǰһҳĵַ, ύ󷵻شҳ

		// ȡURLеreferer
		String refererParam = request.getParameter("referer");
		
		if(!isEmpty(refererParam)) {
			referer = refererParam;
		}
		
		// Added at 2004-10-12
		// ǰһҳĵַ _action.jsp , Ϊ˱ӳ, ͷĬҳ
		if (isEmpty(referer) || referer.indexOf("_action.jsp") != -1) {
			referer = defaultPage;
		}

		return referer;
	}

	/**
	 * һ 18 λ yyyyMMddHHmmss.SSS ʽַ.
	 *
	 * @param date
	 *            Date
	 * @return String
	 */
	public static String genTimeStampString(Date date) {
		java.text.SimpleDateFormat df = new java.text.SimpleDateFormat(
				"yyyyMMddHHmmss.SSS");
		return df.format(date);
	}

	/**
	 * Write the HTML base tag to support servlet forward calling relative path
	 * changed problems.
	 *
	 * Base is used to ensure that your document's relative links are associated
	 * with the proper document path. The href specifies the document's
	 * reference URL for associating relative URLs with the proper document
	 * path. This element may only be used within the HEAD tag. Example: <BASE
	 * HREF="http://www.sample.com/hello.htm">
	 *
	 * @param pageContext
	 *            the PageContext of the jsp page object
	 */
	public static void writeHtmlBase(PageContext pageContext) {
		HttpServletRequest request = (HttpServletRequest) pageContext
				.getRequest();
		StringBuffer buf = new StringBuffer("<base href=\"");
		buf.append(request.getScheme());
		buf.append("://");
		buf.append(request.getServerName());
		buf.append(":");
		buf.append(request.getServerPort());
		buf.append(request.getRequestURI());
		buf.append("\">");
		JspWriter out = pageContext.getOut();
		try {
			out.write(buf.toString());
		} catch (java.io.IOException e) {

		}
	}

	/**
	 * Get the base path of this request.
	 *
	 * @param request -
	 *            HttpServletRequest
	 * @return String - the base path, eg: http://www.abc.com:8000/someApp/
	 */
	public static String getBasePath(HttpServletRequest request) {
		String path = request.getContextPath();
		String basePath = request.getScheme() + "://" + request.getServerName()
				+ ":" + request.getServerPort() + path + "/";
		return basePath;
	}

	/**
	 * Get the current page's full path of this request. ȡǰҳ URL ·.
	 *
	 * @author BeanSoft
	 * @date 2005-08-01
	 * @param request -
	 *            HttpServletRequest
	 * @return String - the full url path, eg:
	 *         http://www.abc.com:8000/someApp/index.jsp?param=abc
	 */
	public static String getFullRequestURL(HttpServletRequest request) {
		StringBuffer url = request.getRequestURL();
		String qString = request.getQueryString();

		if (qString != null) {
			url.append('?');
			url.append(qString);
		}

		return url.toString();
	}

	/**
	 * Get the current page's full path of this request. ȡǰҳ URI ·.
	 *
	 * @author BeanSoft
	 * @date 2005-08-01
	 * @param request -
	 *            HttpServletRequest
	 * @return String - the full uri path, eg: /someApp/index.jsp?param=abc
	 */
	public static String getFullRequestURI(HttpServletRequest request) {
		StringBuffer url = new StringBuffer(request.getRequestURI());
		String qString = request.getQueryString();

		if (qString != null) {
			url.append('?');
			url.append(qString);
		}

		return url.toString();
	}

	// ------------------------------------ ַ
	// ----------------------------------------------

	/**
	 * ַ source е oldStr 滻Ϊ newStr, ԴСдзʽв
	 *
	 * @param source
	 *            Ҫ滻Դַ
	 * @param oldStr
	 *            Ҫ滻ַ
	 * @param newStr
	 *            滻Ϊַ
	 */
	public static String replace(String source, String oldStr, String newStr) {
		return replace(source, oldStr, newStr, true);
	}

	/**
	 * ַ source е oldStr 滻Ϊ newStr, matchCase ΪǷôСдв
	 *
	 * @param source
	 *            Ҫ滻Դַ
	 * @param oldStr
	 *            Ҫ滻ַ
	 * @param newStr
	 *            滻Ϊַ
	 * @param matchCase
	 *            ǷҪմСдзʽ
	 */
	public static String replace(String source, String oldStr, String newStr,
			boolean matchCase) {
		if (source == null) {
			return null;
		}
		// ȼַǷ, ھͲ滻
		if (source.toLowerCase().indexOf(oldStr.toLowerCase()) == -1) {
			return source;
		}
		int findStartPos = 0;
		int a = 0;
		while (a > -1) {
			int b = 0;
			String str1, str2, str3, str4, strA, strB;
			str1 = source;
			str2 = str1.toLowerCase();
			str3 = oldStr;
			str4 = str3.toLowerCase();
			if (matchCase) {
				strA = str1;
				strB = str3;
			} else {
				strA = str2;
				strB = str4;
			}
			a = strA.indexOf(strB, findStartPos);
			if (a > -1) {
				b = oldStr.length();
				findStartPos = a + b;
				StringBuffer bbuf = new StringBuffer(source);
				source = bbuf.replace(a, a + b, newStr) + "";
				// µĲҿʼλ滻ַĽβ
				findStartPos = findStartPos + newStr.length() - b;
			}
		}
		return source;
	}

	/**
	 * ַβĿո.
	 *
	 * @param input
	 *            String ַ
	 * @return ת
	 */
	public static String trimTailSpaces(String input) {
		if (isEmpty(input)) {
			return "";
		}

		String trimedString = input.trim();

		if (trimedString.length() == input.length()) {
			return input;
		}

		return input.substring(0, input.indexOf(trimedString)
				+ trimedString.length());
	}

	/**
	 * Change the null string value to "", if not null, then return it self, use
	 * this to avoid display a null string to "null".
	 *
	 * @param input
	 *            the string to clear
	 * @return the result
	 */
	public static String clearNull(String input) {
		return isEmpty(input) ? "" : input;
	}

	/**
	 * Return the limited length string of the input string (added at:April 10,
	 * 2004).
	 *
	 * @param input
	 *            String
	 * @param maxLength
	 *            int
	 * @return String processed result
	 */
	public static String limitStringLength(String input, int maxLength) {
		if (isEmpty(input))
			return "";

		if (input.length() <= maxLength) {
			return input;
		} else {
			return input.substring(0, maxLength - 3) + "...";
		}

	}

	/**
	 * ַתΪһ JavaScript  alert . eg: htmlAlert("What?"); returns
	 * &lt;SCRIPT language="JavaScript"&gt;alert("What?")&lt;/SCRIPT&gt;
	 *
	 * @param message
	 *            ҪʾϢ
	 * @return ת
	 */
	public static String scriptAlert(String message) {
		return "<SCRIPT language=\"JavaScript\">alert(\"" + message
				+ "\");</SCRIPT>";
	}

	/**
	 * ַתΪһ JavaScript  document.location ı. eg: htmlAlert("a.jsp");
	 * returns &lt;SCRIPT
	 * language="JavaScript"&gt;document.location="a.jsp";&lt;/SCRIPT&gt;
	 *
	 * @param url
	 *            Ҫʾ URL ַ
	 * @return ת
	 */
	public static String scriptRedirect(String url) {
		return "<SCRIPT language=\"JavaScript\">document.location=\"" + url
				+ "\";</SCRIPT>";
	}

	/**
	 * ؽű &lt;SCRIPT language="JavaScript"&gt;history.back();&lt;/SCRIPT&gt;
	 *
	 * @return ű
	 */
	public static String scriptHistoryBack() {
		return "<SCRIPT language=\"JavaScript\">history.back();</SCRIPT>";
	}

	/**
	 * ˳еΣ HTML , Ҫǽű, ĻԼű¼
	 *
	 * @param content
	 *            Ҫ˳ַ
	 * @return ˵Ľ
	 */
	public static String replaceHtmlCode(String content) {
		if (isEmpty(content)) {
			return "";
		}
		// Ҫ˳Ľű¼ؼ
		String[] eventKeywords = { "onmouseover", "onmouseout", "onmousedown",
				"onmouseup", "onmousemove", "onclick", "ondblclick",
				"onkeypress", "onkeydown", "onkeyup", "ondragstart",
				"onerrorupdate", "onhelp", "onreadystatechange", "onrowenter",
				"onrowexit", "onselectstart", "onload", "onunload",
				"onbeforeunload", "onblur", "onerror", "onfocus", "onresize",
				"onscroll", "oncontextmenu" };
		content = replace(content, "<script", "&ltscript", false);
		content = replace(content, "</script", "&lt/script", false);
		content = replace(content, "<marquee", "&ltmarquee", false);
		content = replace(content, "</marquee", "&lt/marquee", false);
		// FIXME ˻е BR Ĺܻԭʼ HTML  2006-07-30
//		content = replace(content, "\r\n", "<BR>");
		// ˳ű¼
		for (int i = 0; i < eventKeywords.length; i++) {
			content = replace(content, eventKeywords[i],
					"_" + eventKeywords[i], false); // һ"_", ʹ¼Ч
		}
		return content;
	}

	/**
	 * ˳ HTML  Ϊı.
	 */
	public static String replaceHtmlToText(String input) {
		if (isEmpty(input)) {
			return "";
		}
		return setBr(setTag(input));
	}

	/**
	 * ˳ HTML .
	 * Ϊ XML תַȻЧ, ˰ַ˳ĵȫַ.
	 * @author beansoft
	 * @param s ִ
	 * @return ˺ִ
	 */
	public static String setTag(String s) {
		int j = s.length();
		StringBuffer stringbuffer = new StringBuffer(j + 500);
		char ch;
		for (int i = 0; i < j; i++) {
			ch = s.charAt(i);
			if (ch == '<') {
				stringbuffer.append("&lt");
//				stringbuffer.append("");
			} else if (ch == '>') {
				stringbuffer.append("&gt");
//				stringbuffer.append("");
			} else if (ch == '&') {
				stringbuffer.append("&amp");
//				stringbuffer.append("");
			} else if (ch == '%') {
				stringbuffer.append("%%");
//				stringbuffer.append("");
			} else {
				stringbuffer.append(ch);
			}
		}

		return stringbuffer.toString();
	}

	/** ˳ BR  */
	public static String setBr(String s) {
		int j = s.length();
		StringBuffer stringbuffer = new StringBuffer(j + 500);
		for (int i = 0; i < j; i++) {

			if (s.charAt(i) == '\n' || s.charAt(i) == '\r') {
				continue;
			}
			stringbuffer.append(s.charAt(i));
		}

		return stringbuffer.toString();
	}

	/** ˳ո */
	public static String setNbsp(String s) {
		int j = s.length();
		StringBuffer stringbuffer = new StringBuffer(j + 500);
		for (int i = 0; i < j; i++) {
			if (s.charAt(i) == ' ') {
				stringbuffer.append("&nbsp;");
			} else {
				stringbuffer.append(s.charAt(i) + "");
			}
		}
		return stringbuffer.toString();
	}

	/**
	 * жַǷȫַ.
	 *
	 * @param input
	 *            ַ
	 * @return жϽ, true Ϊȫ, false Ϊзַ
	 */
	public static boolean isNumeric(String input) {
		if (isEmpty(input)) {
			return false;
		}

		for (int i = 0; i < input.length(); i++) {
			char charAt = input.charAt(i);

			if (!Character.isDigit(charAt)) {
				return false;
			}
		}
		return true;
	}

	/**
	 * תɱȡݵ( ISO8859 ת gb2312).
	 *
	 * @param input
	 *            ַ
	 * @return ת, д, 򷵻ԭֵ
	 */
	public static String toChi(String input) {
		try {
			byte[] bytes = input.getBytes("ISO8859-1");
			return new String(bytes, "GBK");
		} catch (Exception ex) {
		}
		return input;
	}

	/**
	 * תɱȡݵ뵽 ISO( GBK תISO8859-1).
	 *
	 * @param input
	 *            ַ
	 * @return ת, д, 򷵻ԭֵ
	 */
	public static String toISO(String input) {
		return changeEncoding(input, "GBK", "ISO8859-1");
	}

	/**
	 * תַ.
	 *
	 * @param input
	 *            ַ
	 * @param sourceEncoding
	 *            Դַ
	 * @param targetEncoding
	 *            Ŀַ
	 * @return ת, д, 򷵻ԭֵ
	 */
	public static String changeEncoding(String input, String sourceEncoding,
			String targetEncoding) {
		if (input == null || input.equals("")) {
			return input;
		}

		try {
			byte[] bytes = input.getBytes(sourceEncoding);
			return new String(bytes, targetEncoding);
		} catch (Exception ex) {
		}
		return input;
	}

	/**
	 *  '  ''; SQL :еַһǶ,ʹűʾǶĵ.
	 */

	public static String replaceSql(String input) {
		return replace(input, "'", "''");
	}

	/**
	 * Ըַ URL 
	 */
	public static String encode(String value) {
		if (isEmpty(value)) {
			return "";
		}

		try {
			value = java.net.URLEncoder.encode(value, "GB2312");
		} catch (Exception ex) {
			ex.printStackTrace();
		}

		return value;
	}

	/**
	 * Ըַ URL 
	 *
	 * @param value
	 *            ǰַ
	 * @return ַ
	 */
	public static String decode(String value) {
		if (isEmpty(value)) {
			return "";
		}

		try {
			return java.net.URLDecoder.decode(value, "GB2312");
		} catch (Exception ex) {
			ex.printStackTrace();
		}

		return value;
	}

	/**
	 * жַǷδ, Ϊ null ߳Ϊ0,  true.
	 */
	public static boolean isEmpty(String input) {
		return (input == null || input.length() == 0);
	}

	/**
	 * ַֽڳ(ֽ), ڷͶʱжǷ񳬳.
	 *
	 * @param input
	 *            ַ
	 * @return ַֽڳ( Unicode )
	 */
	public static int getBytesLength(String input) {
		if (input == null) {
			return 0;
		}

		int bytesLength = input.getBytes().length;

		//System.out.println("bytes length is:" + bytesLength);

		return bytesLength;
	}

	/**
	 * ַǷδ, , 򷵻ظĳϢ.
	 *
	 * @param input
	 *            ַ
	 * @param errorMsg
	 *            Ϣ
	 * @return մسϢ
	 */
	public static String isEmpty(String input, String errorMsg) {
		if (isEmpty(input)) {
			return errorMsg;
		}
		return "";
	}

	/**
	 * õļչ.
	 *
	 * @param fileName
	 *            Ҫļ.
	 * @return the extension portion of the file's name.
	 */
	public static String getExtension(String fileName) {
		if (fileName != null) {
			int i = fileName.lastIndexOf('.');
			if (i > 0 && i < fileName.length() - 1) {
				return fileName.substring(i + 1).toLowerCase();
			}
		}
		return "";
	}

	/**
	 * õļǰ׺.
     * @date 2005-10-18
	 *
	 * @param fileName
	 *            Ҫļ.
	 * @return the prefix portion of the file's name.
	 */
	public static String getPrefix(String fileName) {
		if (fileName != null) {
            fileName = fileName.replace('\\', '/');

            if(fileName.lastIndexOf("/") > 0) {
                fileName = fileName.substring(fileName.lastIndexOf("/") + 1, fileName.length());
            }

			int i = fileName.lastIndexOf('.');
			if (i > 0 && i < fileName.length() - 1) {
				return fileName.substring(0, i);
			}
		}
		return "";
	}

    /**
     * õļĶ·, Ŀ¼.
     * @date 2005-10-18
     *
     * @param fileName
     *            Ҫļ.
     * @return the short version of the file's name.
     */
    public static String getShortFileName(String fileName) {
        if (fileName != null) {
            String oldFileName = new String(fileName);

            fileName = fileName.replace('\\', '/');
            
            // Handle dir
            if(fileName.endsWith("/")) {
                int idx = fileName.indexOf('/');
                if(idx == -1 || idx == fileName.length() - 1) {
                    return oldFileName;
                } else {
                    return  oldFileName.substring(idx + 1, fileName.length() - 1);
                }

            }
            if(fileName.lastIndexOf("/") > 0) {
                fileName = fileName.substring(fileName.lastIndexOf("/") + 1, fileName.length());
            }

            return fileName;
        }
        return "";
    }

	/**
	 * ȡĬת,  ISO8859-1 ת GBK.
	 *
	 * @author BeanSoft
	 * @date 2005-08-01
	 *
	 * @param request
	 *            HttpServletRequest 
	 * @param fieldName
	 *            
	 * @return ȡõıֵ
	 */
	public static String getParameter(HttpServletRequest request,
			String fieldName) {
			//		// жϱǷѾָ
//		String encoding = request.getCharacterEncoding();
//
//		if("GBK".equalsIgnoreCase(encoding) || "GB2312".equalsIgnoreCase(encoding)) {
//			return request.getParameter(fieldName);
//		}
//
//		return request(request, fieldName);
		// 2005-08-01 ʱ޸
//		try {
//			request.setCharacterEncoding("UTF-8");
//		} catch (UnsupportedEncodingException e) {
//			// TODO auto generated try-catch
//			e.printStackTrace();
//		}

		return request.getParameter(fieldName);
	}

	// ------------------------------------ JSP 
	// ----------------------------------------------
	/** һ ASP Ƶķ, رֵ, ת */
	public static String request(HttpServletRequest request, String fieldName) {
		// POST Ĳб
		if (request.getMethod().equalsIgnoreCase("POST")) {
			// JSP Smart upload  request û
			//			try {
			//				if (request instanceof com.jspsmart.upload.Request) {
			//					// 2004-04-02, Fix the encoding bug on SCO open server(Unix,
			//					// os.name=OpenServer)
			//					// when running jsp smart at tomcat 3.1.1,
			//					// but on Windows and Linux no this problems
			//					if (System.getProperty("os.name").toLowerCase().indexOf(
			//							"openserver") != -1) {
			//						return toChi(request.getParameter(fieldName));
			//					} else {
			//						return request.getParameter(fieldName);
			//					}
			//				}
			//			} catch (Throwable ex) {
			//				// Throwable -- ֹδ smartupload ʱ
			//				System.err.println(ex);
			//			}
			// ļϴģʽ
			//if(isUploadMode) {
			//	return request.getParameter(fieldName);
			//}
			// For Tomcat 4.0.6
			return toChi(request.getParameter(fieldName));
		}
		// ͨ GET ʽ͵ַ(Ǳʹ java.net.URLEncoder ַı)
		// ʱʹת, Ҳʹ÷, : return
		// decode(request.getParameter(fieldName));
		// : decode()  JDK 1.3 + Tomcat 4.0
		return toChi(request.getParameter(fieldName));
	}

	/** ֵ null, 򷵻 "",  NullPointerException */
	public String request1(HttpServletRequest request, String fieldName) {
		String s = request(request, fieldName);
		if (s == null) {
			return "";
		}
		return s;
	}

	/**
	 * ֵָ,  '  ''; SQL :еַһǶţ ʹűʾǶĵš
	 */
	public String requestSql(HttpServletRequest request, String fieldName) {
		return replaceSql(request1(request, fieldName));
	}

	/**
	 *  Cookie Ƶõе Cookie ֵ, Ҫȸ _request һʼֵ;  Cookie ֵ null, 򷵻 ""
	 */
	public static String getCookieValue(HttpServletRequest request, String name) {
		Cookie[] cookies = request.getCookies();
		if (cookies == null) {
			return "";
		}
		for (int i = 0; i < cookies.length; i++) {
			Cookie cookie = cookies[i];
			if (cookie.getName().equals(name)) {
				// Ҫ Cookie еĺֽ URL , ð汾: Tomcat 4.0
				return decode(cookie.getValue());
				// Ҫ, ð汾: JSWDK 1.0.1
				//return cookie.getValue();
			}
		}
		// A cookie may not return a null value, may return a ""
		return "";
	}

	// ָ
	public String[] getParameterValues(HttpServletRequest request, String name) {
		// POST Ĳûб
		//if (request.getMethod().equalsIgnoreCase("POST")) {
		// ļϴģʽ
		//if(isUploadMode) {
		//	return request.getParameterValues(name);
		//}
		// -- For Tomcat 4.0
		//return request.getParameterValues(name);
		// -- For JSWDK 1.0.1
		/*
		 * String values[] = _request.getParameterValues(name); if(values !=
		 * null) { for(int i = 0; i < values.length; i++) { values[i] =
		 * toChi(values[i]); } } return values;
		 */
		//}
		//else {
		// ͨ GET ʽ͵ַ(Ǳʹ java.net.URLEncoder ַı)
		// ʱʹת, Ҳʹ÷, : return decode(_request.getParameter(name));
		// : decode()  JDK 1.3 + Tomcat 4.0
		String encoding = request.getCharacterEncoding();

		if("GBK".equalsIgnoreCase(encoding) || "GB2312".equalsIgnoreCase(encoding)) {
			return request.getParameterValues(name);
		}

		String values[] = request.getParameterValues(name);
		if (values != null) {
			for (int i = 0; i < values.length; i++) {
				values[i] = toChi(values[i]);
			}
		}
		return values;
		//}
	}

	/**
	 * ɾָ Web ӦóĿ¼ϴļ
	 *
	 * @param application
	 *            JSP/Servlet  ServletContext
	 * @param filePath
	 *            ļ·
	 */
	public static void deleteFile(ServletContext application, String filePath) {
		if (!isEmpty(filePath)) {
			String physicalFilePath = application.getRealPath(filePath);
			if (!isEmpty(physicalFilePath)) {
				java.io.File file = new java.io.File(physicalFilePath);
				file.delete();
			}
		}
	}

	/**
	 * ָ Web ӦóĿ¼ָ·ļ
	 *
	 * @param application
	 *            JSP/Servlet  ServletContext
	 * @param filePath
	 *            ļ·
	 */
	public static boolean createFile(ServletContext application, String filePath) {
		if (!isEmpty(filePath)) {
			String physicalFilePath = application.getRealPath(filePath);
			if (!isEmpty(physicalFilePath)) {
				java.io.File file = new java.io.File(physicalFilePath);

				try {
					// ļ
					return file.createNewFile();
				} catch (IOException e) {
					System.err.println("Unable to create file " + filePath);
				}
			}
		}

		return false;
	}

	/**
	 * ָ Web ӦóĿ¼ָ·Ŀ¼.
	 *
	 * @param application
	 *            JSP/Servlet  ServletContext
	 * @param filePath
	 *            ļ·
	 */
	public static boolean createDir(ServletContext application, String filePath) {
		if (!isEmpty(filePath)) {
			String physicalFilePath = application.getRealPath(filePath);
			if (!isEmpty(physicalFilePath)) {
				try {
					// Ŀ¼
					java.io.File dir = new java.io.File(application
							.getRealPath(filePath));
					return dir.mkdirs();
				} catch (Exception e) {
					System.err
							.println("Unable to create directory " + filePath);
				}
			}
		}

		return false;
	}

	/**
	 * ָ Web ӦóĿ¼µļǷ.
	 *
	 * @param application
	 *            JSP/Servlet  ServletContext
	 * @param filePath
	 *            ļ·
	 * @return boolean - ļǷ
	 */
	public static boolean checkFileExists(ServletContext application,
			String filePath) {
		if (!isEmpty(filePath)) {
			String physicalFilePath = application.getRealPath(filePath);
			if (!isEmpty(physicalFilePath)) {
				java.io.File file = new java.io.File(physicalFilePath);
				return file.exists();
			}
		}

		return false;
	}

    /**
     * ȡļͼ.
     * Date: 2005-10
     * @param application JSP/Servlet  ServletContext
     * @param iconDirPath ͼļе·
     * @param fileName Ҫļ
     * @return ͼļ·
     */
	public static String getFileIcon(ServletContext application,
			String iconDirPath, String fileName) {
		String ext = getExtension(fileName);
        String filePath = iconDirPath + ext + ".gif";
//        return filePath;

        if(checkFileExists(application, filePath)) {
            return filePath;
        }
		return iconDirPath + "file.gif";
	}

	/**
	 * ҳʾĽ.
	 *
	 * @param page
	 *            ǰҳ
	 * @param recordCount
	 *            н
	 * @param pageSize
	 *            һҳʾĶ
	 * @param pageCountSize
	 *            ǰҳĶ
	 * @param linkpageurl
	 *            ҳ URL ַ
	 * @return ҳַ.
	 */
	public static String paging(int page, int recordCount, int pageSize,
			int pageCountSize, String linkpageurl) {
		int PageCount = -1; //ҳ
		String LinkPageName = linkpageurl;
		String LinkText = "";
		int StartPage;
		int TempPage;
		int TempPageCount;
		TempPage = (page - 1) % pageCountSize; // 
		StartPage = page - TempPage; //  
		TempPageCount = recordCount % pageSize;
		if (TempPageCount == 0) {
			PageCount = recordCount / pageSize;
		} else {
			PageCount = (recordCount / pageSize) + 1; //ü  
		}
		String txtPrev = " [ǰ" + pageCountSize + "ҳ] ";
		String txtNext = " [" + pageCountSize + "ҳ] ";
		String txtStart = " [ҳ] ";
		String txtEnd = " [ĩҳ] ";
		//ó
		if (StartPage - 1 > 0) {
			LinkText += "<a href='" + LinkPageName + "&page=1' title='ҳ'>"
					+ txtStart + "</a>";
		} else {
			LinkText += txtStart;
		}
		// 10..
		if (StartPage - 1 > 0) {
			LinkText += "<a href='" + LinkPageName + "&page=" + (StartPage - 1)
					+ "' title='" + pageCountSize + "ҳ'>" + txtPrev + "</a>";
		} else {
			LinkText += txtPrev;
		}
		for (int i = StartPage; i < StartPage + pageCountSize; i++) {
			if (i < PageCount + 1) {
				LinkText += "<a href='" + LinkPageName + "&page=";
				LinkText += i + "' title='" + i + "ҳ'>";
				if (i == page) {
					LinkText += "<b>[" + i + "]</b>";
				} else {
					LinkText += "[" + i + "]";
				}
				LinkText += "</a>";
			}
		}
		//мҳ
		if (StartPage + pageCountSize - PageCount - 1 < 0) {
			LinkText += "<a href='" + LinkPageName + "&page="
					+ (StartPage + pageCountSize) + "' title='"
					+ pageCountSize + "ҳ'>" + txtNext + "</a>";
		} else {
			LinkText += txtNext;
		}
		//һҳ
		if (StartPage + pageCountSize <= PageCount) {
			LinkText += "<a href='" + LinkPageName + "&page=" + PageCount
					+ "' title='һҳ'>" + txtEnd + "</a>";
		} else {
			LinkText += txtEnd;
		}
		return LinkText;
	}

	/**
	 * Gets the absolute pathname of the class or resource file containing the
	 * specified class or resource name, as prescribed by the current classpath.
	 *
	 * @param resourceName
	 *            Name of the class or resource name.
	 * @return the absolute pathname of the given resource
	 */
	public static String getPath(String resourceName) {

		if (!resourceName.startsWith("/")) {
			resourceName = "/" + resourceName;
		}

		//resourceName = resourceName.replace('.', '/');

		java.net.URL classUrl = new StringUtil().getClass().getResource(
				resourceName);

		if (classUrl != null) {
			//System.out.println("\nClass '" + className +
			//"' found in \n'" + classUrl.getFile() + "'");
			//System.out.println("\nԴ '" + resourceName +
			//"' ļ \n'" + classUrl.getFile() + "' ҵ.");

			return classUrl.getFile();
		}
		//System.out.println("\nClass '" + className +
		//"' not found in \n'" +
		//System.getProperty("java.class.path") + "'");
		//System.out.println("\nԴ '" + resourceName +
		//"' û· \n'" +
		//System.getProperty("java.class.path") + "' ҵ");
		return null;
	}

	/**
	 * תΪıʾʽַ(ʽΪ yyyyMMdd HH:mm:ss).
	 */
	public static String dateToChineseString(Date date) {
		if (date == null) {
			return "";
		}

		java.text.SimpleDateFormat dateFormat = new java.text.SimpleDateFormat(
				"yyyyMMdd HH:mm:ss");

		return dateFormat.format(date);
	}

	/**
	 * תΪ 14 λַ(ʽΪyyyyMMddHHmmss).
	 */
	public static String dateTo14String(Date date) {
		if (date == null) {
			return null;
		}

		java.text.SimpleDateFormat dateFormat = new java.text.SimpleDateFormat(
				"yyyyMMddHHmmss");

		return dateFormat.format(date);
	}

	/**
	 *  14 λַ(ʽΪyyyyMMddHHmmss)תΪ.
	 */
	public static Date string14ToDate(String input) {
		if (isEmpty(input)) {
			return null;
		}

		if (input.length() != 14) {
			return null;
		}

		java.text.SimpleDateFormat dateFormat = new java.text.SimpleDateFormat(
				"yyyyMMddHHmmss");

		try {
			return dateFormat.parse(input);
		} catch (Exception ex) {
			ex.printStackTrace();
		}

		return null;
	}

	// -----------------------------------------------------------
	// ---------- ַת߷, 2004.03.27  --------
	//------------------------------------------------------------
	public static byte getByte(HttpServletRequest httpservletrequest, String s) {
		if (httpservletrequest.getParameter(s) == null
				|| httpservletrequest.getParameter(s).equals("")) {
			return 0;
		}
		return Byte.parseByte(httpservletrequest.getParameter(s));
	}

	/**
	 * Reading a parameter as integer from the http servlet request.
	 *
	 */
	public static int getInt(HttpServletRequest httpservletrequest, String s) {
		if (httpservletrequest.getParameter(s) == null
				|| httpservletrequest.getParameter(s).equals("")) {
			return 0;
		}
		return Integer.parseInt(httpservletrequest.getParameter(s));
	}

	public static long getLong(HttpServletRequest httpservletrequest, String s) {
		if (httpservletrequest.getParameter(s) == null
				|| httpservletrequest.getParameter(s).equals("")) {
			return 0L;
		}
		return Long.parseLong(httpservletrequest.getParameter(s));
	}

	public static short getShort(HttpServletRequest httpservletrequest, String s) {
		if (httpservletrequest.getParameter(s) == null
				|| httpservletrequest.getParameter(s).equals("")) {
			return 0;
		}
		return Short.parseShort(httpservletrequest.getParameter(s));
	}

	/**
	 *  TEXT ıתΪ HTML , ѱҳȷʾ.
	 *
	 * @param input
	 *            ıַ
	 * @return ת HTML 
	 */
	public static String textToHtml(String input) {
		if (isEmpty(input)) {
			return "";
		}

		input = replace(input, "<", "&#60;");
		input = replace(input, ">", "&#62;");

		input = replace(input, "\n", "<br>\n");
		input = replace(input, "\t", "&nbsp;&nbsp;&nbsp;&nbsp;");
		input = replace(input, "  ", "&nbsp;&nbsp;");

		return input;
	}

	public static String toQuoteMark(String s) {
		s = replaceString(s, "'", "&#39;");
		s = replaceString(s, "\"", "&#34;");
		s = replaceString(s, "\r\n", "\n");
		return s;
	}

	public static String replaceChar(String s, char c, char c1) {
		if (s == null) {
			return "";
		}
		return s.replace(c, c1);
	}

	public static String replaceString(String s, String s1, String s2) {
		if (s == null || s1 == null || s2 == null) {
			return "";
		}
		return s.replaceAll(s1, s2);
	}

	public static String toHtml(String s) {
		s = replaceString(s, "<", "&#60;");
		s = replaceString(s, ">", "&#62;");
		return s;
	}

	public static String toBR(String s) {
		s = replaceString(s, "\n", "<br>\n");
		s = replaceString(s, "\t", "&nbsp;&nbsp;&nbsp;&nbsp;");
		s = replaceString(s, "  ", "&nbsp;&nbsp;");
		return s;
	}

	public static String toSQL(String s) {
		s = replaceString(s, "\r\n", "\n");
		return s;
	}

	public static String replaceEnter(String s) throws NullPointerException {
		return s.replaceAll("\n", "<br>");
	}

	public static String replacebr(String s) throws NullPointerException {
		return s.replaceAll("<br>", "\n");
	}

	public static String replaceQuote(String s) throws NullPointerException {
		return s.replaceAll("'", "''");
	}

	// Test only.
	public static void main(String[] args) throws Exception {
		//System.out.println(textToHtml("1<2\r\n<b>Bold</b>"));
		//System.out.println(scriptAlert("oh!"));
		//System.out.println(scriptRedirect("http://localhost/"));
		//    System.out.println(StringUtil.getPath("/databaseconfig.properties"));
		//		java.io.File file = new java.io.File("e:\\Moblog\\abcd\\");
		//
		//		file.mkdir();
		Date time = (parseHMSStringToDate("12:23:00"));
		System.out.println(time.toLocaleString());
		Date nowTime = parseHMSStringToDate(formatDateToHMSString(new Date()));
		System.out.println(nowTime.toLocaleString());

		//		GregorianCalendar cal = new GregorianCalendar();
		//		cal.setTime(new Date());
		//		cal.add(cal.YEAR, -cal.get(cal.YEAR) + 1970);
		//		cal.add(cal.MONTH, -cal.get(cal.MONTH));
		//		cal.add(cal.DATE, -cal.get(cal.DATE) + 1);
		//
		//		System.out.println(cal.getTime().toLocaleString());
	}
}