/*
 * DummyTokenHandler.java - Ignores tokens
 * :tabSize=8:indentSize=8:noTabs=false:
 * :folding=explicit:collapseFolds=1:
 *
 * Copyright (C) 2002 Slava Pestov
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

package studio.beansoft.syntax.sample;

import javax.swing.text.Segment;

import org.gjt.sp.jedit.syntax.Token;
import org.gjt.sp.jedit.syntax.TokenHandler;
import org.gjt.sp.jedit.syntax.TokenMarker;

/**
 * A token handler that output html formated syntax highlight html code.
 *
 * @author BeanSoft
 * @version 1.0 2005/10/17 
 */
public class HtmlOutputTokenHandler implements TokenHandler {
	// The html output buffer
	private StringBuffer buff = new StringBuffer();


	//{{{ handleToken() method
	/**
	 * Called by the token marker when a syntax token has been parsed.
	 * @param seg The segment containing the text
	 * @param id The token type (one of the constants in the
	 * {@link Token} class).
	 * @param offset The start offset of the token
	 * @param length The number of characters in the token
	 * @param context The line context
	 * @since jEdit 4.2pre3
	 */
	public void handleToken(
		Segment seg,
		byte id,
		int offset,
		int length,
		TokenMarker.LineContext context) {

		String segText = new String(seg.array, offset, length);

		// Current token's text
		switch (id) {
			case Token.END :
				break;

			case Token.KEYWORD1 :
			case Token.KEYWORD2 :
			case Token.KEYWORD3 :
			case Token.KEYWORD4 :
				buff.append("<span class=reservedWord>");
				buff.append(segText).append("</span>");
				break;

			case Token.COMMENT1 :
			case Token.COMMENT2 :
			case Token.COMMENT3 :
			case Token.COMMENT4 :
				buff.append("<span class=comment>");
				buff.append(segText).append("</span>");
				break;

			case Token.LITERAL1 :
			case Token.LITERAL2 :
			case Token.LITERAL3 :
			case Token.LITERAL4 :
				buff.append("<span class=literal>");
				buff.append(segText).append("</span>");
				break;

			case Token.OPERATOR :
				buff.append("<span class=operator>");
				buff.append(segText).append("</span>");
				break;
				
			case Token.FUNCTION:
			    buff.append("<span class=function>");
			    buff.append(segText).append("</span>");
			    break;

            case Token.LABEL:
                buff.append("<span class=label>");
                buff.append(segText).append("</span>");
                break;
                
            case Token.MARKUP:
                buff.append("<span class=markup>");
                buff.append(segText).append("</span>");
                break;
                
                
			    

			default :
				buff.append(segText);
		}

	} //}}}

	/**
	 * Clear the html output buffer.
	 */
	public void reset() {
		buff.delete(0, buff.length());
	}

	/**
	 * Returns the final HTML code of the programming code.
	 * @return String
	 */
	public String getOutputText() {
		return buff.toString();
	}

	//{{{ setLineContext() method
	/**
	 * The token handler can compare this object with the object
	 * previously given for this line to see if the token type at the end
	 * of the line has changed (meaning subsequent lines might need to be
	 * retokenized).
	 * @since jEdit 4.2pre6
	 */
	public void setLineContext(TokenMarker.LineContext lineContext) {
	} //}}}
}
