/*
 * @(#)HtmlSyntaxHighlighter.java 1.00 2005-10-17
 *
 * Copyright 2005 BeanSoft Studio. All rights reserved.
 * PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package studio.beansoft.syntax.sample;

import studio.beansoft.syntax.ModeLoader;

import java.io.*;

/**
 * HtmlSyntaxHighlighter is used to generate any html syntax high light output text
 * from source code supported by jEdit.
 * 
 * Chinese documents:
 * κ jEdit ֵ֧﷨Դ HTML ﷨ļ.
 * @author BeanSoft
 * @version 1.00 2005-10-17
 */
public class HtmlSyntaxHighlighter {

	private HtmlSyntaxHighlighter() {
	}

	/**
	 * Convert any source code to html hilight output.
	 * 
	 * ıתΪ HTML ﷨.
	 * 
	 * @param string - source code to convert
	 * @param marker - anguage string(see modes/catalog file)
	 * @return String - Result html code, eg:
	 * <pre>
	<span class=comment>// Hello </span><span class=reservedWord>public</span> 
	<span class=reservedWord>class</span> Test() { <span class=reservedWord>int</span> a = 1 + 2; 
	}
	</pre>
	 */
	public static String syntaxTextToHtml(String string, String languageType) {
		HtmlOutputTokenHandler tokenHandler = new HtmlOutputTokenHandler();

		ModeLoader.parseTokens(string, languageType, tokenHandler);

		return tokenHandler.getOutputText();
	}

	public static void main(String[] args) throws IOException {
		//			ModeLoader.loadModeCatalog("modes\\catalog", false);
		// Load from resource file
		ModeLoader.loadModeCatalog("/modes/catalog", true);

		System.out.println(syntaxTextToHtml("public class Test() {}", "java"));
	}
}
