/*
 * Decompiled with CFR 0.152.
 */
package org.makumba.analyser;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.collections.map.MultiValueMap;
import org.apache.commons.collections.set.ListOrderedSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PageCache {
    private HashMap<String, LinkedHashMap<Object, Object>> caches = new HashMap();
    private HashMap<String, MultiValueMap> multiValueCaches = new HashMap();
    private HashMap<String, ListOrderedSet> setCaches = new HashMap();

    public void cache(String cacheName, Object key, Object value) {
        LinkedHashMap<Object, Object> cache = this.caches.get(cacheName);
        if (cache == null) {
            cache = new LinkedHashMap();
            this.caches.put(cacheName, cache);
        }
        cache.put(key, value);
    }

    public Object retrieve(String cacheName, Object key) {
        LinkedHashMap<Object, Object> cache = this.caches.get(cacheName);
        if (cache == null) {
            return null;
        }
        return cache.get(key);
    }

    public Map<Object, Object> retrieveCache(String cacheName) {
        return this.caches.get(cacheName);
    }

    public void cacheMultiple(String cacheName, Object key, Object value) {
        MultiValueMap cache = this.multiValueCaches.get(cacheName);
        if (cache == null) {
            cache = new MultiValueMap();
            this.multiValueCaches.put(cacheName, cache);
        }
        if (!cache.containsValue(key, value)) {
            if (value instanceof Collection) {
                cache.putAll(key, (Collection)value);
            } else {
                cache.put(key, value);
            }
        }
    }

    public Collection<Object> retrieveMultiple(String cacheName, Object key) {
        MultiValueMap cache = this.multiValueCaches.get(cacheName);
        if (cache == null) {
            return null;
        }
        return cache.getCollection(key);
    }

    public MultiValueMap retrieveMultiCache(String cacheName) {
        return this.multiValueCaches.get(cacheName);
    }

    public void cacheSetValues(String cacheName, Object[] value) {
        ListOrderedSet hashSet = this.setCaches.get(cacheName);
        if (hashSet == null) {
            hashSet = new ListOrderedSet();
            this.setCaches.put(cacheName, hashSet);
        }
        hashSet.addAll(Arrays.asList(value));
    }

    public ListOrderedSet retrieveSetValues(String cacheName) {
        return this.setCaches.get(cacheName);
    }

    public String toString() {
        HashMap cache;
        String result = "== Simple caches\n";
        for (String key : this.caches.keySet()) {
            result = result + "  == Key " + key + "\n";
            cache = this.caches.get(key);
            for (Object key2 : cache.keySet()) {
                result = result + "    - " + key2 + " => " + cache.get(key2) + "\n";
            }
        }
        result = result + "== Set caches\n";
        for (String key : this.setCaches.keySet()) {
            result = result + "  == Key " + key + "\n";
            cache = this.setCaches.get(key);
            Iterator i$ = cache.iterator();
            while (i$.hasNext()) {
                Object entry = i$.next();
                result = result + "    - " + entry + "\n";
            }
        }
        return result;
    }

    public String toString(String key) {
        String result = "== Content of cache " + key + "\n";
        HashMap cache = this.caches.get(key);
        for (Object key2 : cache.keySet()) {
            if (key2 == null) continue;
            result = result + "  key: " + key2.toString() + "\n    value: " + cache.get(key2).toString() + "\n";
        }
        return result;
    }
}

