/*
 * Decompiled with CFR 0.152.
 */
package org.makumba.db.hibernate;

import org.makumba.HibernateSFManager;
import org.makumba.Transaction;
import org.makumba.commons.SingletonReleaser;
import org.makumba.db.hibernate.HibernateCRUDOperationProvider;
import org.makumba.db.hibernate.HibernateTransaction;
import org.makumba.providers.CRUDOperationProvider;
import org.makumba.providers.Configuration;
import org.makumba.providers.DataDefinitionProvider;
import org.makumba.providers.TransactionProvider;

public class HibernateTransactionProvider
extends TransactionProvider {
    private Configuration.DataSourceType lastConnectionType = Configuration.DataSourceType.hibernate;

    public static TransactionProvider getInstance() {
        return SingletonHolder.singleton;
    }

    private HibernateTransactionProvider() {
    }

    public CRUDOperationProvider getCRUD() {
        return super.getCRUD(this);
    }

    public Transaction getConnectionTo(String name) {
        return super.getConnectionTo(name, this);
    }

    public String getQueryLanguage() {
        return super.getQueryLanguage(this);
    }

    protected Configuration.DataSourceType getLastConnectionType() {
        return this.lastConnectionType;
    }

    protected void setLastConnectionType(Configuration.DataSourceType type) {
        this.lastConnectionType = type;
    }

    protected CRUDOperationProvider getCRUDInternal() {
        return CRUDOperationProviderSingletonHolder.singleton;
    }

    protected String getQueryLanguageInternal() {
        return "hql";
    }

    protected Transaction getTransaction(String name) {
        return new HibernateTransaction(name, DataDefinitionProvider.getInstance(), this);
    }

    public Object getHibernateSessionFactory(String name) {
        return HibernateSFManager.getSF(name);
    }

    public void closeDataSource(String dataSourceName) {
    }

    private static class CRUDOperationProviderSingletonHolder
    implements org.makumba.commons.SingletonHolder {
        private static CRUDOperationProvider singleton = new HibernateCRUDOperationProvider();

        public void release() {
            singleton = null;
        }

        public CRUDOperationProviderSingletonHolder() {
            SingletonReleaser.register(this);
        }
    }

    private static class SingletonHolder
    implements org.makumba.commons.SingletonHolder {
        private static TransactionProvider singleton = new HibernateTransactionProvider();

        public void release() {
            singleton = null;
        }

        public SingletonHolder() {
            SingletonReleaser.register(this);
        }
    }
}

