/*
 * Decompiled with CFR 0.152.
 */
package org.makumba.list;

import java.util.Map;
import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.tagext.Tag;
import javax.servlet.jsp.tagext.TagSupport;
import org.apache.commons.lang.StringUtils;
import org.makumba.DataDefinition;
import org.makumba.FieldDefinition;
import org.makumba.InvalidFieldTypeException;
import org.makumba.LogicException;
import org.makumba.NoSuchFieldException;
import org.makumba.Pointer;
import org.makumba.ProgrammerError;
import org.makumba.analyser.AnalysableElement;
import org.makumba.analyser.AnalysableTag;
import org.makumba.analyser.PageCache;
import org.makumba.analyser.TagData;
import org.makumba.commons.MakumbaJspAnalyzer;
import org.makumba.commons.MultipleKey;
import org.makumba.commons.SingletonReleaser;
import org.makumba.forms.tags.CriterionTag;
import org.makumba.forms.tags.FormTagBase;
import org.makumba.forms.tags.InputTag;
import org.makumba.forms.tags.SearchFieldTag;
import org.makumba.list.engine.ComposedQuery;
import org.makumba.list.engine.QueryExecution;
import org.makumba.list.engine.valuecomputer.ValueComputer;
import org.makumba.list.tags.QueryTag;
import org.makumba.list.tags.ValueTag;
import org.makumba.providers.DataDefinitionProvider;
import org.makumba.providers.FormDataProvider;

public class ListFormDataProvider
implements FormDataProvider {
    private static final String[] dummyQuerySections = new String[]{null, null, null, null, null};

    public void onFormStartAnalyze(AnalysableTag tag, PageCache pageCache, String ptrExpr) {
        MultipleKey parentListKey;
        if (MakumbaJspAnalyzer.getQueryLanguage(pageCache).equals("hql")) {
            ptrExpr = ptrExpr + ".id";
        }
        if ((parentListKey = QueryTag.getParentListKey(tag, pageCache)) == null) {
            FormTagBase form = (FormTagBase)TagSupport.findAncestorWithClass((Tag)tag, FormTagBase.class);
            if (form == null) {
                throw new ProgrammerError("mak:addForm needs to be enclosed in a list, object or form tag");
            }
            Map<Object, Object> cache = pageCache.retrieveCache("org.makumba.tagData");
            boolean found = false;
            DataDefinitionProvider ddp = DataDefinitionProvider.getInstance();
            for (Object key : cache.keySet()) {
                TagData tagData = (TagData)cache.get(key);
                if (!(tagData.getTagObject() instanceof InputTag) || tagData.attributes.get("name") == null || !tagData.attributes.get("name").equals(ptrExpr)) continue;
                String dataType = tagData.attributes.get("dataType");
                if (StringUtils.isBlank((String)dataType)) {
                    throw new ProgrammerError("Currently, only inputs with dataType=\"..\" are supported as addForm base objects");
                }
                FieldDefinition fd = ddp.makeFieldDefinition("dummyName", dataType);
                if (fd.isPointer()) {
                    pageCache.cache("org.makumba.addFormDataType", tag.getTagKey(), new Object[]{fd.getPointedType(), ptrExpr});
                    found = true;
                    continue;
                }
                throw new ProgrammerError("Can use only 'ptr' type inputs for addForms, given expr '" + ptrExpr + "' is denoting an input of type '" + fd + "'");
            }
            if (!found) {
                throw new ProgrammerError("Did not find any input with the name '" + ptrExpr + "' to be used as base object for the addForm");
            }
        } else {
            boolean isValue = tag instanceof ValueTag;
            pageCache.cache("org.makumba.valueComputers", tag.getTagKey(), ValueComputer.getValueComputerAtAnalysis(isValue, parentListKey, ptrExpr, pageCache));
        }
    }

    public void onBasicValueStartAnalyze(AnalysableTag tag, boolean isNull, MultipleKey parentFormKey, PageCache pageCache, String ptrExpr) {
        MultipleKey parentListKey = this.getBasicValueParentListKey(tag, isNull, parentFormKey, pageCache);
        boolean isValue = tag instanceof ValueTag;
        pageCache.cache("org.makumba.valueComputers", tag.getTagKey(), ValueComputer.getValueComputerAtAnalysis(isValue, parentListKey, ptrExpr, pageCache));
    }

    private MultipleKey getBasicValueParentListKey(AnalysableTag tag, boolean isNull, MultipleKey parentFormKey, PageCache pageCache) {
        MultipleKey k = QueryTag.getParentListKey(tag, pageCache);
        if (k != null) {
            return k;
        }
        if (isNull) {
            return null;
        }
        QueryTag.cacheQuery(pageCache, parentFormKey, dummyQuerySections, null);
        return parentFormKey;
    }

    public void onNonQueryStartAnalyze(AnalysableTag tag, boolean isNull, MultipleKey parentFormKey, PageCache pageCache, String expr) {
        MultipleKey parentListKey = this.getBasicValueParentListKey(tag, isNull, parentFormKey, pageCache);
        if (MakumbaJspAnalyzer.getQueryLanguage(pageCache).equals("hql") && ValueComputer.isPointer(pageCache, parentListKey, expr) && !expr.endsWith(".id")) {
            expr = expr + ".id";
        }
        boolean isValue = tag instanceof ValueTag;
        pageCache.cache("org.makumba.valueComputers", tag.getTagKey(), ValueComputer.getValueComputerAtAnalysis(isValue, parentListKey, expr, pageCache));
    }

    public void onFormEndAnalyze(MultipleKey tagKey, PageCache pageCache) {
        ComposedQuery dummy = (ComposedQuery)pageCache.retrieve("org.makumba.query", tagKey);
        if (dummy != null) {
            dummy.analyze();
        }
    }

    public FieldDefinition onBasicValueEndAnalyze(MultipleKey tagKey, PageCache pageCache) {
        return this.getTypeOnEndAnalyze(tagKey, pageCache);
    }

    public void onFormStartTag(MultipleKey tagKey, PageCache pageCache, PageContext pageContext) throws LogicException {
        if (pageCache.retrieve("org.makumba.query", tagKey) != null) {
            QueryExecution.startListGroup(pageContext);
            QueryExecution.getFor(tagKey, pageContext, null, null).onParentIteration();
        }
    }

    public void onFormEndTag(MultipleKey tagKey, PageCache pageCache, PageContext pageContext) {
        if (pageCache.retrieve("org.makumba.query", tagKey) != null) {
            QueryExecution.endListGroup(pageContext);
        }
    }

    public FieldDefinition getTypeOnEndAnalyze(MultipleKey tagKey, PageCache pageCache) {
        if (this.retrieveBaseObjectInputInfo(tagKey, pageCache) != null) {
            DataDefinition addToPtrInput = (DataDefinition)this.retrieveBaseObjectInputInfo(tagKey, pageCache)[0];
            return addToPtrInput.getFieldDefinition(addToPtrInput.getIndexPointerFieldName());
        }
        ValueComputer vc = (ValueComputer)pageCache.retrieve("org.makumba.valueComputers", tagKey);
        vc.doEndAnalyze(pageCache);
        return vc.getType();
    }

    public DataDefinition getBasePointerType(AnalysableTag tag, PageCache pageCache, String baseObject) {
        if (this.retrieveBaseObjectInputInfo(tag.getTagKey(), pageCache) != null) {
            return (DataDefinition)this.retrieveBaseObjectInputInfo(tag.getTagKey(), pageCache)[0];
        }
        return QueryTag.getQuery(pageCache, this.getParentListKey(tag)).getLabelType(baseObject);
    }

    public String computeBasePointer(MultipleKey tagKey, PageContext pageContext) throws LogicException {
        PageCache pageCache = AnalysableElement.getPageCache(pageContext, MakumbaJspAnalyzer.getInstance());
        if (this.retrieveBaseObjectInputInfo(tagKey, pageCache) != null) {
            return "valueOf_" + this.retrieveBaseObjectInputInfo(tagKey, pageCache)[1];
        }
        Object o = ((ValueComputer)pageCache.retrieve("org.makumba.valueComputers", tagKey)).getValue(pageContext);
        if (!(o instanceof Pointer)) {
            throw new RuntimeException("Pointer expected, got instead " + o);
        }
        return ((Pointer)o).toExternalForm();
    }

    private Object[] retrieveBaseObjectInputInfo(MultipleKey tagKey, PageCache pageCache) {
        return (Object[])pageCache.retrieve("org.makumba.addFormDataType", tagKey);
    }

    public Object getValue(MultipleKey tagKey, PageContext pageContext, PageCache pageCache) throws LogicException {
        return ((ValueComputer)pageCache.retrieve("org.makumba.valueComputers", tagKey)).getValue(pageContext);
    }

    public FieldDefinition getInputTypeAtAnalysis(AnalysableTag tag, DataDefinition dd, String fieldName, PageCache pageCache) {
        if (dd == null) {
            return null;
        }
        int dot = -1;
        int dot1;
        while ((dot1 = fieldName.indexOf(".", dot + 1)) != -1) {
            String fname = fieldName.substring(dot + 1, dot1);
            FieldDefinition fd = dd.getFieldDefinition(fname);
            if (fd == null) {
                throw new NoSuchFieldException(dd, fname);
            }
            if (!(tag instanceof SearchFieldTag || tag instanceof CriterionTag || fd.getType().equals("ptr") && fd.isNotNull() || fd.getType().equals("ptrOne"))) {
                throw new InvalidFieldTypeException(fieldName + " must be linked via not null pointers, " + fd.getDataDefinition().getName() + "->" + fd.getName() + " is not");
            }
            dd = fd.getPointedType();
            dot = dot1;
        }
        return dd.getFieldDefinition(fieldName.substring(dot + 1));
    }

    public MultipleKey getParentListKey(AnalysableTag tag) {
        return QueryTag.getParentListKey(tag, null);
    }

    public static ListFormDataProvider getInstance() {
        return SingletonHolder.singleton;
    }

    private static class SingletonHolder
    implements org.makumba.commons.SingletonHolder {
        private static ListFormDataProvider singleton = new ListFormDataProvider();

        public void release() {
            singleton = null;
        }

        public SingletonHolder() {
            SingletonReleaser.register(this);
        }
    }
}

