/*
 * Decompiled with CFR 0.152.
 */
package org.makumba.list.html;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Dictionary;
import java.util.Hashtable;
import org.makumba.DataDefinition;
import org.makumba.FieldDefinition;
import org.makumba.commons.formatters.FieldFormatter;
import org.makumba.commons.formatters.RecordFormatter;
import org.makumba.commons.formatters.dateFormatter;
import org.makumba.commons.formatters.intEnumFormatter;
import org.makumba.commons.formatters.ptrFormatter;
import org.makumba.commons.formatters.timestampFormatter;
import org.makumba.list.engine.ComposedQuery;
import org.makumba.list.html.FieldViewer;
import org.makumba.list.html.binaryViewer;
import org.makumba.list.html.booleanViewer;
import org.makumba.list.html.charViewer;
import org.makumba.list.html.textViewer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RecordViewer
extends RecordFormatter {
    private static final long serialVersionUID = 1L;

    public RecordViewer(ComposedQuery q) {
        this.dd = q.getResultType();
        this.initFormatters();
        this.expr = new String[this.dd.getFieldNames().size()];
        for (int i = 0; i < this.dd.getFieldNames().size(); ++i) {
            this.expr[i] = q.getProjectionAt(i);
        }
    }

    public RecordViewer(DataDefinition ri, Hashtable<String, String> h) {
        super(ri, h, false, null);
    }

    @Override
    protected String applyParameters(FieldFormatter ff, Dictionary<String, Object> formatParams, String s) {
        if (formatParams.get("urlEncode") != null) {
            try {
                return URLEncoder.encode(s, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
        }
        return s;
    }

    @Override
    protected void initFormatters() {
        this.formatterArray = new FieldFormatter[this.dd.getFieldNames().size()];
        block9: for (int i = 0; i < this.dd.getFieldNames().size(); ++i) {
            FieldDefinition fd = this.dd.getFieldDefinition(i);
            switch (fd.getIntegerType()) {
                case 6: {
                    this.formatterArray[i] = charViewer.getInstance();
                    continue block9;
                }
                case 8: {
                    this.formatterArray[i] = textViewer.getInstance();
                    continue block9;
                }
                case 19: {
                    this.formatterArray[i] = booleanViewer.getInstance();
                    continue block9;
                }
                case 9: {
                    this.formatterArray[i] = dateFormatter.getInstance();
                    continue block9;
                }
                case 10: 
                case 11: {
                    this.formatterArray[i] = timestampFormatter.getInstance();
                    continue block9;
                }
                case 5: {
                    this.formatterArray[i] = intEnumFormatter.getInstance();
                    continue block9;
                }
                case 0: 
                case 1: 
                case 2: 
                case 3: {
                    if (fd.isFileType()) {
                        this.formatterArray[i] = binaryViewer.getInstance();
                        continue block9;
                    }
                    this.formatterArray[i] = ptrFormatter.getInstance();
                    continue block9;
                }
                default: {
                    this.formatterArray[i] = FieldViewer.getInstance();
                }
            }
        }
    }
}

