/*
 * Decompiled with CFR 0.152.
 */
package org.makumba.analyser.engine;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.jsp.tagext.Tag;
import org.makumba.analyser.ELData;
import org.makumba.analyser.ElementData;
import org.makumba.analyser.TagData;
import org.makumba.analyser.engine.SourceSyntaxPoints;
import org.makumba.analyser.engine.SyntaxPoint;
import org.makumba.analyser.interfaces.JspAnalyzer;
import org.makumba.commons.NamedResourceFactory;
import org.makumba.commons.NamedResources;
import org.makumba.commons.RuntimeWrappedException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JspParseData
implements SourceSyntaxPoints.PreprocessorClient {
    File file;
    JspAnalyzer analyzer;
    SourceSyntaxPoints syntaxPoints;
    Object holder;
    String uri;
    private boolean usingHibernate = false;
    private String root;
    private static Pattern JspSystemTagPattern;
    private static Pattern JspTagPattern;
    private static Pattern JspCommentPattern;
    private static Pattern JspScriptletPattern;
    private static Pattern JspIncludePattern;
    private static Pattern JspTagAttributePattern;
    private static Pattern JspExpressionLanguagePattern;
    private static Pattern JsfExpressionLanguagePattern;
    private static Pattern Word;
    private static Pattern TagName;
    private static Pattern MapExpression;
    private static Pattern DotExpression;
    private static String[] JspCommentPatternNames;
    private static Pattern[] JspCommentPatterns;
    static int analyzedPages;

    static String attribute(String attName) {
        return "(" + JspParseData.attribute(attName, "\"") + "|" + JspParseData.attribute(attName, "'") + ")";
    }

    static String attribute(String attName, String quote) {
        String bs = "\\";
        String q = bs + quote;
        String backslash = bs + bs;
        return bs + "s*" + attName + bs + "s*=" + bs + "s*" + q + "(" + backslash + ".|[^" + q + backslash + "])*?" + q;
    }

    public synchronized void discardParsingData() {
        this.syntaxPoints.discardPoints();
    }

    public synchronized Object getAnalysisResult(Object initStatus) {
        if (this.getSyntaxPoints() == null || !this.getSyntaxPoints().unchanged()) {
            this.getSyntaxPointArray(initStatus);
        }
        return this.holder;
    }

    @Override
    public synchronized SyntaxPoint[] getSyntaxPointArray(Object initStatus) {
        try {
            this.parse(initStatus);
            return this.syntaxPoints.getSyntaxPoints();
        }
        catch (Error e) {
            this.holder = e;
            throw e;
        }
        catch (RuntimeException re) {
            this.holder = re;
            throw re;
        }
    }

    public static JspParseData getParseData(String webappRoot, String path, JspAnalyzer an) {
        Object[] arg = new Object[]{webappRoot, an, path};
        return (JspParseData)NamedResources.getStaticCache(analyzedPages).getResource(arg);
    }

    @Override
    public SourceSyntaxPoints getSyntaxPoints() {
        return this.syntaxPoints;
    }

    public JspParseData(String path, String uri, JspAnalyzer an) {
        this.root = path;
        this.file = new File(this.root + uri);
        this.uri = uri;
        this.analyzer = an;
    }

    void parse(Object initStatus) {
        long start = new Date().getTime();
        this.holder = this.analyzer.makeStatusHolder(initStatus);
        this.syntaxPoints = new SourceSyntaxPoints(this.file, this);
        this.treatPageContent(this.syntaxPoints.getContent(), this.analyzer);
        this.holder = this.analyzer.endPage(this.holder);
        Logger.getLogger("org.makumba.jspparser.time").info("analysis of " + this.uri + " took " + (new Date().getTime() - start) + " ms");
    }

    Map<String, String> parseAttributes(String s, int origin) {
        HashMap<String, String> attributes = new HashMap<String, String>(13);
        Matcher m = JspTagAttributePattern.matcher(s);
        while (m.find()) {
            String attr = s.substring(m.start(), m.end());
            int n = attr.indexOf(61);
            String attName = attr.substring(0, n).trim();
            String attValQuoted = attr.substring(n + 1).trim();
            char chQuote = attValQuoted.charAt(0);
            if (attValQuoted.charAt(0) != attValQuoted.charAt(attValQuoted.length() - 1)) {
                throw new RuntimeException("Properly quoted string expected, found " + attValQuoted);
            }
            if (chQuote == '\"') {
                attValQuoted = attValQuoted.replaceAll("\\\\\"", "\"");
            } else if (chQuote == '\'') {
                attValQuoted = attValQuoted.replaceAll("\\\\'", "'");
            }
            attValQuoted = attValQuoted.replaceAll("(\\\\){2}", "\\\\");
            String attValue = attValQuoted.substring(1, attValQuoted.length() - 1);
            attributes.put(attName, attValue);
            if (origin != -1) {
                this.syntaxPoints.addSyntaxPoints(origin, origin + n, "JSPTagAttributeName", null);
                this.syntaxPoints.addSyntaxPoints(origin + n, origin + n + 1, "JSPTagAttributeEquals", null);
                this.syntaxPoints.addSyntaxPoints(origin + n + 1, origin + s.length(), "JSPTagAttributeValue", null);
            }
            Logger log = Logger.getLogger("org.makumba.jspparser.tags.attribute");
            log.finest("< Attribute : " + attr);
            log.finest("> AttrParse : " + attName + " = " + attValue);
        }
        return attributes;
    }

    @Override
    public void treatInclude(int position, String includeDirective, SyntaxPoint start, SyntaxPoint end, SourceSyntaxPoints host) {
        this.treatIncludeDirective(includeDirective, start, end, this.analyzer);
        Map<String, String> m1 = this.parseAttributes(includeDirective, -1);
        String fileName = m1.get("file");
        String dir = fileName.startsWith("/") ? this.root : host.file.getParent();
        host.include(new File(dir, fileName), position, includeDirective);
    }

    @Override
    public Pattern[] getCommentPatterns() {
        return JspCommentPatterns;
    }

    @Override
    public String[] getCommentPatternNames() {
        return JspCommentPatternNames;
    }

    @Override
    public Pattern getIncludePattern() {
        return JspIncludePattern;
    }

    @Override
    public String getIncludePatternName() {
        return "JspInclude";
    }

    void treatPageContent(String content, JspAnalyzer an) {
        Matcher tags = JspTagPattern.matcher(content);
        Matcher systemTags = JspSystemTagPattern.matcher(content);
        Matcher jspELExpressions = JspExpressionLanguagePattern.matcher(content);
        Matcher jsfELExpressions = JsfExpressionLanguagePattern.matcher(content);
        int tagStart = Integer.MAX_VALUE;
        if (tags.find()) {
            tagStart = tags.start();
        }
        int systemStart = Integer.MAX_VALUE;
        if (systemTags.find()) {
            systemStart = systemTags.start();
        }
        int jspELExpressionStart = Integer.MAX_VALUE;
        if (jspELExpressions.find()) {
            jspELExpressionStart = jspELExpressions.start();
        }
        do {
            if (tagStart < systemStart && tagStart < jspELExpressionStart) {
                this.treatTag(tags, content, an);
                tagStart = Integer.MAX_VALUE;
                if (!tags.find()) continue;
                tagStart = tags.start();
                continue;
            }
            if (systemStart < tagStart && systemStart < jspELExpressionStart) {
                this.treatSystemTag(systemTags, content, an);
                systemStart = Integer.MAX_VALUE;
                if (!systemTags.find()) continue;
                systemStart = systemTags.start();
                continue;
            }
            if (jspELExpressionStart >= tagStart || jspELExpressionStart >= systemStart) continue;
            this.treatELExpression(jspELExpressions, content, an, false);
            jspELExpressionStart = Integer.MAX_VALUE;
            if (!jspELExpressions.find()) continue;
            jspELExpressions.start();
        } while (tagStart != Integer.MAX_VALUE || systemStart != Integer.MAX_VALUE || jspELExpressionStart != Integer.MAX_VALUE);
    }

    void treatELExpression(Matcher m, String content, JspAnalyzer an, boolean isJsf) {
        SyntaxPoint.End end = this.syntaxPoints.addSyntaxPoints(m.start(), m.end(), "ExpressionLanguage", null);
        SyntaxPoint start = (SyntaxPoint)((SyntaxPoint)end).getOtherInfo();
        String elContent = content.substring(m.start() + 2, m.end() - 1);
        Matcher map = MapExpression.matcher(elContent);
        while (map.find()) {
            SyntaxPoint.End mapEnd = this.syntaxPoints.addSyntaxPoints(m.start() + map.start(), m.start() + map.end(), "ExpressionLanguageMap", null);
            SyntaxPoint mapStart = (SyntaxPoint)((SyntaxPoint)mapEnd).getOtherInfo();
            String mapContent = elContent.substring(map.start(), map.end());
            ELData elData = new ELData(mapContent, mapStart, mapEnd);
            an.elExpression(elData, this.holder);
        }
    }

    void treatTag(Matcher m, String content, JspAnalyzer an) {
        String tag = content.substring(m.start(), m.end());
        boolean tagEnd = tag.startsWith("</");
        boolean tagClosed = tag.endsWith("/>");
        Matcher m1 = TagName.matcher(tag);
        m1.find();
        this.syntaxPoints.addSyntaxPoints(m.start() + m1.start(), m.start() + m1.end(), "JSPTagName", null);
        String type = tagEnd ? "JspTagEnd" : (tagClosed ? "JspTagSimple" : "JspTagBegin");
        SyntaxPoint.End end = this.syntaxPoints.addSyntaxPoints(m.start(), m.end(), type, null);
        SyntaxPoint start = (SyntaxPoint)((SyntaxPoint)end).getOtherInfo();
        String tagName = tag.substring(m1.start(), m1.end());
        TagData td = new TagData(tagName, start, end, !tagEnd ? this.parseAttributes(tag, m.start()) : null);
        Logger log = Logger.getLogger("org.makumba.jspparser.tags");
        if (log.isLoggable(Level.FINE)) {
            log.fine(this.uri + ":" + start.line + ":" + start.column + ": " + (tagEnd ? "/" + tagName : td.name + " " + td.attributes));
        }
        if (tagEnd) {
            an.endTag(td, this.holder);
            return;
        }
        if (tagClosed) {
            an.simpleTag(td, this.holder);
        } else {
            an.startTag(td, this.holder);
        }
    }

    void treatSystemTag(Matcher m, String content, JspAnalyzer an) {
        Logger log;
        String tag = content.substring(m.start(), m.end());
        SyntaxPoint.End end = this.syntaxPoints.addSyntaxPoints(m.start(), m.end(), "JSPSystemTag", null);
        Matcher m1 = Word.matcher(tag);
        m1.find();
        this.syntaxPoints.addSyntaxPoints(m.start() + m1.start(), m.start() + m1.end(), "JSPSystemTagName", null);
        SyntaxPoint start = (SyntaxPoint)((SyntaxPoint)end).getOtherInfo();
        TagData td = new TagData(tag.substring(m1.start(), m1.end()), start, end, this.parseAttributes(tag, m.start()));
        if (td.name.equals("taglib") && td.attributes.get("uri") != null && td.attributes.get("uri").toString().startsWith("http://www.makumba.org/") && !td.attributes.get("uri").equals("http://www.makumba.org/presentation")) {
            this.usingHibernate = true;
        }
        if ((log = Logger.getLogger("org.makumba.jspparser.tags")).isLoggable(Level.FINE)) {
            log.fine(this.uri + ":" + start.line + ":" + start.column + ": " + td.name + " " + td.attributes);
        }
        an.systemTag(td, this.holder);
    }

    void treatIncludeDirective(String directive, SyntaxPoint start, SyntaxPoint end, JspAnalyzer an) {
        Matcher m1 = Word.matcher(directive);
        m1.find();
        TagData td = new TagData("include", start, end, this.parseAttributes(directive, -1));
        Logger log = Logger.getLogger("org.makumba.jspparser.tags");
        if (log.isLoggable(Level.FINE)) {
            log.fine(this.uri + ":" + start.line + ":" + start.column + ": " + td.name + " " + td.attributes);
        }
        an.systemTag(td, this.holder);
    }

    public static void tagDataLine(ElementData td, StringBuffer sb) {
        sb.append("\n").append(td.getSourceSyntaxPoints().getLineText(td.getStartLine())).append('\n');
        for (int i = 1; i < td.getStartColumn(); ++i) {
            sb.append(' ');
        }
        sb.append('^');
    }

    public static void fill(Tag t, Map<String, String> attributes) {
        Class<?> c = t.getClass();
        Class[] argTypes = new Class[]{String.class};
        Object[] args = new Object[1];
        Iterator<Map.Entry<String, String>> i$ = attributes.entrySet().iterator();
        while (i$.hasNext()) {
            Map.Entry<String, String> entry;
            Map.Entry<String, String> me = entry = i$.next();
            String s = me.getKey();
            String methodName = "set" + Character.toUpperCase(s.charAt(0)) + s.substring(1);
            try {
                Method m = c.getMethod(methodName, argTypes);
                args[0] = me.getValue();
                m.invoke((Object)t, args);
            }
            catch (InvocationTargetException ite) {
                Logger.getLogger("org.makumba.jspparser").warning("error invoking method " + methodName + " on object of class " + c.getName() + " with argument " + args[0]);
                throw new RuntimeWrappedException(ite.getTargetException());
            }
            catch (Throwable thr) {
                Logger.getLogger("org.makumba.jspparser").warning("error invoking method " + methodName + " on object of class " + c.getName() + " with argument " + args[0]);
                throw new RuntimeWrappedException(thr);
            }
        }
    }

    public boolean isUsingHibernate() {
        return this.usingHibernate;
    }

    @Override
    public String[] getLiteralPatternNames() {
        return null;
    }

    @Override
    public Pattern[] getLiteralPatterns() {
        return null;
    }

    static {
        JspCommentPatternNames = new String[]{"JspComment", "JspScriptlet"};
        analyzedPages = NamedResources.makeStaticCache("JSP page analyses", new NamedResourceFactory(){
            private static final long serialVersionUID = 1L;

            public Object getHashObject(Object o) {
                Object[] o1 = (Object[])o;
                return (String)o1[0] + o1[2] + o1[1].getClass().getName();
            }

            public Object makeResource(Object o, Object hashName) throws Throwable {
                Object[] o1 = (Object[])o;
                return new JspParseData((String)o1[0], (String)o1[2], (JspAnalyzer)o1[1]);
            }
        }, false);
        String attribute = JspParseData.attribute("\\w+");
        try {
            JspTagAttributePattern = Pattern.compile(attribute);
            JspSystemTagPattern = Pattern.compile("<%@\\s*\\w+(" + attribute + ")*\\s*%>");
            JspIncludePattern = Pattern.compile("<%@\\s*include" + JspParseData.attribute("file") + "\\s*%>");
            JspTagPattern = Pattern.compile("<((\\s*\\w+:\\w+(" + attribute + ")*\\s*)/?|(/\\w+:\\w+\\s*))>");
            JspCommentPattern = Pattern.compile("<%--.*?[^-]--%>", 32);
            JspScriptletPattern = Pattern.compile("<%[^@].*?%>", 32);
            JspExpressionLanguagePattern = Pattern.compile("\\$\\{[^\\}]*\\}");
            JsfExpressionLanguagePattern = Pattern.compile("\\#\\{[^\\}]*\\}");
            Pattern[] cp = new Pattern[]{JspCommentPattern, JspScriptletPattern};
            JspCommentPatterns = cp;
            MapExpression = Pattern.compile("[A-Za-z]\\w*\\[[^]]*\\]");
            Word = Pattern.compile("\\w+");
            TagName = Pattern.compile("\\w+:\\w+");
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }
}

