/*
 * Decompiled with CFR 0.152.
 */
package org.makumba.commons;

import java.io.Serializable;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.logging.Logger;
import org.makumba.commons.NameValue;
import org.makumba.commons.NamedResourceFactory;
import org.makumba.commons.RuntimeWrappedException;
import org.makumba.commons.SoftNamedResources;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NamedResources
implements Serializable {
    private static final long serialVersionUID = 1L;
    static boolean soft_static_caches;
    NamedResourceFactory f;
    String name;
    Map values = new HashMap();
    int hits;
    int misses;
    static List<NamedResources> staticCaches;
    static Vector<WeakReference<NamedResources>> allCaches;

    public static void cleanup() {
        int i;
        for (i = 0; i < staticCaches.size(); ++i) {
            staticCaches.get(i).close();
        }
        staticCaches.clear();
        for (i = 0; i < allCaches.size(); ++i) {
            allCaches.elementAt(i).clear();
        }
        allCaches.clear();
        staticCaches = new ArrayList<NamedResources>();
        allCaches = new Vector();
    }

    public static void cleanupStaticCaches() {
        for (int i = 0; i < staticCaches.size(); ++i) {
            staticCaches.get(i).close();
        }
    }

    public static void cleanCaches() {
        NamedResources.cleanStaticCache("Authorization constraints");
        NamedResources.cleanStaticCache("JSP page analyses");
        NamedResources.cleanStaticCache("MQL parsed queries (soft cache)");
        NamedResources.cleanStaticCache("Hibernate HQL parsed queries (soft cache)");
        NamedResources.cleanStaticCache("Data definitions parsed");
        NamedResources.cleanStaticCache("MDDs parsed");
        NamedResources.cleanStaticCache("Inlined queries by MqlQueryAnalysisProvider (soft cache)");
        NamedResources.cleanStaticCache("Makumba resources (soft cache)");
    }

    public static synchronized int makeStaticCache(String name, NamedResourceFactory fact, boolean soft) {
        staticCaches.add(soft ? new SoftNamedResources(name, fact) : new NamedResources(name, fact));
        return staticCaches.size() - 1;
    }

    public static synchronized int makeStaticCache(String name, NamedResourceFactory fact) {
        return NamedResources.makeStaticCache(name, fact, soft_static_caches);
    }

    public static NamedResources getStaticCache(int n) {
        return staticCaches.get(n);
    }

    public static void cleanStaticCache(int n) {
        NamedResources.staticCaches.get((int)n).values = new HashMap();
    }

    public static void cleanStaticCache(String name) {
        for (NamedResources r : staticCaches) {
            if (!r.getName().equals(name)) continue;
            r.close();
            Logger.getLogger("org.makumba.system").fine("Cleaned '" + name + "' cache.");
        }
    }

    public static Map<String, int[]> getCacheInfo() {
        HashMap<String, int[]> m = new HashMap<String, int[]>();
        for (int i = 0; i < allCaches.size(); ++i) {
            NamedResources nr = (NamedResources)allCaches.elementAt(i).get();
            if (nr == null) continue;
            int[] n = (int[])m.get(nr.getName());
            if (n == null) {
                n = new int[3];
                m.put(nr.getName(), n);
            }
            n[0] = n[0] + nr.size();
            n[1] = n[1] + nr.hits;
            n[2] = n[2] + nr.misses;
        }
        return m;
    }

    public NamedResources(String name, NamedResourceFactory f) {
        this.name = name;
        this.f = f;
        allCaches.addElement(new WeakReference<NamedResources>(this));
    }

    public boolean knowResource(Object name) {
        try {
            return this.values.get(this.f.getHashObject(name)) != null;
        }
        catch (Throwable t) {
            throw new RuntimeWrappedException(t);
        }
    }

    public Object getSupplementary() {
        return this.f.supplementary;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getResource(Object name) {
        NameValue nv = null;
        NamedResources namedResources = this;
        synchronized (namedResources) {
            Object hash = null;
            try {
                hash = this.f.getHashObject(name);
            }
            catch (RuntimeWrappedException t) {
                throw t;
            }
            catch (Throwable t) {
                throw new RuntimeWrappedException(t);
            }
            nv = this.getNameValue(name, hash);
        }
        return nv.getResource();
    }

    protected NameValue getNameValue(Object name, Object hash) {
        NameValue nv = (NameValue)this.values.get(hash);
        if (nv == null) {
            ++this.misses;
            nv = new NameValue(name, hash, this.f);
            this.values.put(hash, nv);
        } else {
            ++this.hits;
        }
        return nv;
    }

    public int size() {
        return this.values.size();
    }

    public String getName() {
        return this.name;
    }

    void closeContent() {
        Iterator i = this.values.keySet().iterator();
        while (i.hasNext()) {
            Object nvo = this.values.get(i.next());
            if (nvo instanceof Reference && (nvo = ((Reference)nvo).get()) == null || !(((NameValue)nvo).returner instanceof NameValue)) continue;
            Object o = ((NameValue)nvo).getResource();
            Method m = null;
            if (o == null) continue;
            try {
                m = o.getClass().getMethod("close", null);
            }
            catch (NoSuchMethodException e) {
                return;
            }
            try {
                m.invoke(o, (Object[])null);
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
    }

    public void close() {
        this.closeContent();
        this.values.clear();
    }

    static {
        String soft = null;
        try {
            soft = System.getProperty("makumba.soft-static-caches");
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        if (soft != null) {
            soft = soft.trim();
        }
        soft_static_caches = "true".equals(soft);
        staticCaches = new ArrayList<NamedResources>();
        allCaches = new Vector();
    }
}

