/*
 * Decompiled with CFR 0.152.
 */
package org.makumba.forms.tags;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Hashtable;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.Tag;
import org.apache.commons.lang.StringUtils;
import org.makumba.FieldDefinition;
import org.makumba.HtmlChoiceWriter;
import org.makumba.LogicException;
import org.makumba.ProgrammerError;
import org.makumba.analyser.PageCache;
import org.makumba.commons.MultipleKey;
import org.makumba.commons.tags.GenericMakumbaTag;
import org.makumba.forms.tags.CriterionTag;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MatchModeTag
extends GenericMakumbaTag {
    public static final String[] allowedTypes = new String[]{"radio", "select"};
    private static final long serialVersionUID = 1L;
    private String[][] matchModes = null;
    public static final Hashtable<String, String> knownRangeMatchModes = new Hashtable(4);
    public static final Hashtable<String, String> knownStringMatchModes;
    public static final Hashtable<String, String> knownDateMatchModes;
    public static final Hashtable<String, String> knownNumberMatchModes;
    public static final Hashtable<String, String> allMatchModes;
    private String elementSeparator;
    private String labelSeparator;
    private String defaultMode;

    public static Hashtable<String, String> getValidMatchmodes(boolean isRange, FieldDefinition fd) {
        if (isRange) {
            return knownRangeMatchModes;
        }
        if (fd.isStringType()) {
            return knownStringMatchModes;
        }
        if (fd.isNumberType()) {
            return knownNumberMatchModes;
        }
        if (fd.isDateType()) {
            return knownDateMatchModes;
        }
        return null;
    }

    public void setMatchModes(String s) {
        if (this.getCriterionTag().getMatchMode() != null) {
            throw new ProgrammerError("Cannot have a matchMode tag if the criterion tag already defines a matchMode!");
        }
        ArrayList<String> keys = new ArrayList<String>();
        ArrayList<String> values = new ArrayList<String>();
        String[] modes = s.split(",");
        for (int i = 0; i < modes.length; ++i) {
            modes[i] = modes[i].trim();
            String mode = modes[i].contains("=") ? modes[i].substring(0, modes[i].indexOf("=")).trim() : modes[i].trim();
            keys.add(mode);
            if (modes[i].contains("=")) {
                values.add(modes[i].substring(modes[i].indexOf("=") + 1).trim());
                continue;
            }
            values.add(allMatchModes.get(mode));
        }
        if (keys.size() < 2) {
            throw new ProgrammerError("matchMode tag should contain at least two modes, but only '" + s + "' was provided.");
        }
        this.matchModes = this.toMatchModeArrays(keys, values);
    }

    private String[][] toMatchModeArrays(Collection<String> keys, Collection<String> values) {
        return new String[][]{keys.toArray(new String[values.size()]), values.toArray(new String[values.size()])};
    }

    @Override
    public void setType(String s) {
        super.setType(s);
    }

    @Override
    public void doStartAnalyze(PageCache pageCache) {
        if (this.getCriterionTag() == null) {
            throw new ProgrammerError("'matchMode' tag must be enclosed in a 'criterion' tag");
        }
        FieldDefinition fd = this.getCriterionTag().getTypeFromContext(pageCache);
        if (!(this.matchModes == null || fd == null || fd.isStringType() || fd.isNumberType() || fd.isDateType())) {
            throw new ProgrammerError("'matchModes' tag is only valid for 'char', 'text', 'int', 'real' and 'date' types, field is of type '" + fd.getType() + "'!");
        }
        Hashtable<String, String> validModes = MatchModeTag.getValidMatchmodes(this.getCriterionTag().isRange(), fd);
        if (fd != null && this.matchModes != null) {
            for (int i = 0; i < this.matchModes[0].length; ++i) {
                String mode = this.matchModes[0][i];
                if (validModes.containsKey(mode)) continue;
                throw new ProgrammerError("Unknown match mode '" + mode + "'. Valid options are: " + org.makumba.commons.StringUtils.toString(validModes.keySet()));
            }
        }
        if (this.defaultMode != null && !validModes.containsKey(this.defaultMode)) {
            throw new ProgrammerError("Unknown default match mode '" + this.defaultMode + "'. Valid options are: " + org.makumba.commons.StringUtils.toString(validModes.keySet()));
        }
    }

    protected CriterionTag getCriterionTag() {
        return (CriterionTag)MatchModeTag.findAncestorWithClass((Tag)this, CriterionTag.class);
    }

    @Override
    public int doAnalyzedEndTag(PageCache pageCache) throws LogicException, JspException {
        this.getCriterionTag().setHasMatchMode(true);
        String matchInputName = this.getCriterionTag().getInputName() + this.getCriterionTag().getForm().responder.getSuffix() + "Match";
        String matchMode = this.pageContext.getRequest().getParameter(matchInputName);
        if (this.matchModes == null) {
            FieldDefinition fd = this.getCriterionTag().getTypeFromContext(pageCache);
            Hashtable<Object, Object> defaultModes = new Hashtable();
            if (this.getCriterionTag().isRange()) {
                defaultModes = knownRangeMatchModes;
            } else if (fd.isStringType()) {
                defaultModes = knownStringMatchModes;
            } else if (fd.isNumberType()) {
                defaultModes = knownNumberMatchModes;
            } else if (fd.isDateType()) {
                defaultModes = knownDateMatchModes;
            }
            this.matchModes = this.toMatchModeArrays(defaultModes.keySet(), defaultModes.values());
        }
        HtmlChoiceWriter hcw = new HtmlChoiceWriter(matchInputName);
        hcw.setValues(this.matchModes[0]);
        hcw.setLabels(this.matchModes[1]);
        hcw.setValues(Arrays.asList(this.matchModes[0]).iterator());
        hcw.setLabels(Arrays.asList(this.matchModes[1]).iterator());
        String selected = StringUtils.isNotBlank((String)matchMode) ? matchMode : (StringUtils.isNotBlank((String)this.defaultMode) ? this.defaultMode : this.matchModes[0][0]);
        hcw.setSelectedValues(selected);
        String type = (String)this.params.get("type");
        try {
            if (org.makumba.commons.StringUtils.equalsAny(type, "radio")) {
                if (this.elementSeparator != null) {
                    hcw.setOptionSeparator(this.elementSeparator);
                }
                if (this.labelSeparator != null) {
                    hcw.setTickLabelSeparator(this.labelSeparator);
                }
                this.pageContext.getOut().println(hcw.getRadioSelect());
            } else {
                this.pageContext.getOut().println(hcw.getSelect());
            }
        }
        catch (IOException e) {
            throw new JspException(e.toString());
        }
        return super.doAnalyzedEndTag(pageCache);
    }

    @Override
    public void setTagKey(PageCache pageCache) {
        this.tagKey = new MultipleKey(new Object[]{this.getCriterionTag().tagKey, this.id, this.matchModes, ((Object)((Object)this)).getClass()});
    }

    @Override
    protected void registerPossibleAttributeValues() {
        this.registerAttributeValues("type", allowedTypes);
    }

    @Override
    public boolean allowsIdenticalKey() {
        return false;
    }

    @Override
    public void setDefault(String s) {
        this.defaultMode = s;
    }

    static {
        knownRangeMatchModes.put("between", "between");
        knownRangeMatchModes.put("betweenInclusive", "between (inclusive)");
        knownStringMatchModes = new Hashtable(4);
        knownStringMatchModes.put("contains", "contains");
        knownStringMatchModes.put("equals", "equals");
        knownStringMatchModes.put("begins", "begins with");
        knownStringMatchModes.put("ends", "ends with");
        knownDateMatchModes = new Hashtable(4);
        knownDateMatchModes.put("equals", "equals");
        knownDateMatchModes.put("before", "before");
        knownDateMatchModes.put("after", "after");
        knownNumberMatchModes = new Hashtable(4);
        knownNumberMatchModes.put("equals", "equals");
        knownNumberMatchModes.put("lessThan", "less than");
        knownNumberMatchModes.put("greaterThan", "greater than");
        knownNumberMatchModes.put("equalGreaterThan", "equal or greater than");
        knownNumberMatchModes.put("equalLessThan", "equal or less than");
        allMatchModes = new Hashtable(4);
        allMatchModes.putAll(knownRangeMatchModes);
        allMatchModes.putAll(knownStringMatchModes);
        allMatchModes.putAll(knownDateMatchModes);
        allMatchModes.putAll(knownNumberMatchModes);
    }
}

