/*
 * Decompiled with CFR 0.152.
 */
package org.makumba.forms.tags;

import java.io.IOException;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.BodyContent;
import javax.servlet.jsp.tagext.BodyTag;
import javax.servlet.jsp.tagext.Tag;
import javax.servlet.jsp.tagext.TagSupport;
import org.makumba.LogicException;
import org.makumba.ProgrammerError;
import org.makumba.analyser.PageCache;
import org.makumba.commons.tags.GenericMakumbaTag;
import org.makumba.forms.tags.FormTagBase;

public class SubmitTag
extends GenericMakumbaTag
implements BodyTag {
    private static final long serialVersionUID = -5459766319927481205L;
    private static final String BUTTON = "button";
    private static final String LINK = "link";
    private BodyContent bc;
    private String form;
    private String widget;
    private boolean hasBody = false;

    public void setForm(String form) {
        this.form = form;
    }

    public void setWidget(String widget) {
        this.widget = widget;
    }

    public boolean canHaveBody() {
        return true;
    }

    public void doInitBody() throws JspException {
        this.hasBody = true;
    }

    public void setBodyContent(BodyContent b) {
        this.bc = b;
    }

    private FormTagBase getForm() {
        return (FormTagBase)TagSupport.findAncestorWithClass((Tag)this, FormTagBase.class);
    }

    public void doStartAnalyze(PageCache pageCache) {
        if (this.getForm() == null) {
            throw new ProgrammerError("mak:submit has to be inside of a form tag");
        }
        if (this.widget != null && !this.widget.equals(LINK) && !this.widget.equals(BUTTON)) {
            throw new ProgrammerError("the 'widget' attribute only takes the values 'link' and 'button'");
        }
    }

    public int doAnalyzedStartTag(PageCache pageCache) throws LogicException, JspException {
        return 2;
    }

    public int doAnalyzedEndTag(PageCache pageCache) throws LogicException, JspException {
        if (this.widget == null) {
            this.widget = BUTTON;
        }
        String text = "Submit";
        if (this.hasBody) {
            text = this.bc.getString();
        }
        try {
            if (this.widget.equals(BUTTON)) {
                this.pageContext.getOut().append((CharSequence)"<input class=\"makSubmitButton\" type=\"submit\" value=\"").append(text).append("\" />");
            } else if (this.widget.equals(LINK)) {
                this.pageContext.getOut().append((CharSequence)"<a class=\"makSubmitLink\" href=\"#\" onClick=\"").append(this.getForm().getSubmitJavascriptCall(null, this.getForm().triggerEvent != null)).append("\">").append(text).append("</a>");
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return super.doAnalyzedStartTag(pageCache);
    }
}

