/*
 * Decompiled with CFR 0.152.
 */
package org.makumba.providers;

import java.io.Serializable;
import java.net.InetAddress;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.logging.Logger;
import org.apache.commons.lang.StringUtils;
import org.makumba.ConfigurationError;
import org.makumba.commons.ClassResource;
import org.makumba.commons.CollectionUtils;
import org.makumba.providers.ConfiguredDataSource;
import org.makumba.providers.MakumbaINIConfiguration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Configuration
implements Serializable {
    public static final String PROPERTY_NOT_SET = "PROPERTY_NOT_SET";
    public static final String KEY_CLIENT_SIDE_VALIDATION = "clientSideValidation";
    public static final String KEY_RELOAD_FORM_ON_ERROR = "reloadFormOnError";
    public static final String KEY_FORM_ANNOTATION = "formAnnotation";
    public static final String KEY_DEFAULT_DATABASE_LAYER = "defaultDatabaseLayer";
    public static final String MAKUMBA_CONF = "Makumba.conf";
    private static final String MAKUMBA_CONF_DEFAULT = "Makumba.conf.default";
    public static final String PLACEHOLDER_CONTEXT_PATH = "_CONTEXT_PATH_";
    private static String defaultClientSideValidation = "live";
    private static boolean defaultReloadFormOnError = true;
    private static String defaultFormAnnotation = "after";
    private static final long serialVersionUID = 1L;
    private static final String KEY_DATADEFINITIONPROVIDER = "dataDefinitionProvider";
    private static final String KEY_QUERYFUNCTIONINLINER = "queryFunctionInliner";
    public static final String MDD_DATADEFINITIONPROVIDER = "mdd";
    public static final String RECORDINFO_DATADEFINITIONPROVIDER = "recordinfo";
    public static final String KEY_CALENDAR_EDITOR = "calendarEditor";
    public static final String KEY_CALENDAR_EDITOR_LINK = "calendarEditorLink";
    public static final String KEY_MAKUMBA_TOOLS = "path";
    public static final String KEY_MDD_VIEWER = "mddViewer";
    public static final String KEY_JAVA_VIEWER = "javaViewer";
    public static final String KEY_LOGIC_DISCOVERY = "logicDiscovery";
    public static final String KEY_CODE_GENERATOR = "codeGenerator";
    public static final String KEY_DATA_QUERY_TOOL = "dataQueryTool";
    public static final String KEY_DATA_OBJECT_VIEWER = "dataObjectViewer";
    public static final String KEY_DATA_LISTER = "dataLister";
    public static final String KEY_OBJECT_ID_CONVERTER = "objectIdConverter";
    public static final String KEY_REFERENCE_CHECKER = "referenceChecker";
    public static final String KEY_RELATION_CRAWLER = "relationCrawler";
    public static final String KEY_REPOSITORY_URL = "repositoryURL";
    public static final String KEY_REPOSITORY_LINK_TEXT = "repositoryLinkText";
    public static final String KEY_DB_ERROR_LOG = "logErrors";
    public static final String KEY_DEFAULT_LANG = "defaultLanguage";
    public static final String KEY_LANG_PARAM = "languageParameterName";
    public static final String KEY_LANG_ATTRIBUTE = "languageAttributeName";
    public static final String KEY_MAKUMBA_VALUE_EDITOR = "makumbaValueEditor";
    public static final String KEY_MAKUMBA_UNIQUENESS_VALIDATOR = "makumbaUniquenessValidator";
    public static final String KEY_MAKUMBA_AUTOCOMPLETE = "makumbaAutoComplete";
    public static final String KEY_MAKUMBA_RESOURCES = "makumbaResources";
    public static final String KEY_MAKUMBA_DOWNLOAD = "makumbaDownload";
    public static final String KEY_MAKUMBA_CACHE_CLEANER = "makumbaCacheCleaner";
    private static final Map<String, String> allGenericDeveloperToolsMap = CollectionUtils.toMap(new String[][]{{"mddViewer", "Mdd viewer"}, {"javaViewer", "Business logics viewer"}, {"dataLister", "Data browser"}, {"dataQueryTool", "Data query"}, {"objectIdConverter", "Pointer value converter"}, {"referenceChecker", "Reference checker"}, {"relationCrawler", "Relation crawler"}});
    private static Map<String, ConfiguredDataSource> configuredDataSources = new HashMap<String, ConfiguredDataSource>();
    private static MakumbaINIConfiguration defaultConfig;
    private static MakumbaINIConfiguration applicationConfig;
    private static Object loadLock;
    static Logger logger;
    private static ConfiguredDataSource defaultDataSource;
    private static Map<String, ConfiguredDataSource> resolvedConfiguredDataSources;
    private static String remoteDataSourceConfigurationPath;

    public static Map<String, String> getAllGenericDeveloperToolsMap() {
        return allGenericDeveloperToolsMap;
    }

    private static void buildConfiguredDataSources() {
        for (String section : applicationConfig.getSections()) {
            if (!section.startsWith("dataSource:")) continue;
            ConfiguredDataSource c = Configuration.buildConfiguredDataSource(section);
            configuredDataSources.put(c.toString(), c);
        }
    }

    private static ConfiguredDataSource buildConfiguredDataSource(String section) throws ConfigurationError {
        String name = null;
        String host = null;
        String path = null;
        StringTokenizer st = new StringTokenizer(section, " ");
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            int n = token.indexOf(":");
            if (n > -1) {
                String tokenName = token.substring(0, n);
                String tokenValue = token.substring(n + 1);
                if (org.makumba.commons.StringUtils.equalsAny(tokenName, "dataSource", "host", KEY_MAKUMBA_TOOLS)) {
                    if (StringUtils.isBlank((String)tokenValue)) {
                        throw new ConfigurationError("Property " + tokenName + " has no value");
                    }
                    if (tokenName.equals("dataSource")) {
                        name = tokenValue;
                        continue;
                    }
                    if (tokenName.equals("host")) {
                        host = tokenValue;
                        continue;
                    }
                    if (!tokenName.equals(KEY_MAKUMBA_TOOLS)) continue;
                    path = tokenValue;
                    continue;
                }
                throw new ConfigurationError("Invalid property '" + token + "' in dataSource section [" + section + "]. Correct syntax is [dataSource:<name> host:<host> path:<path>}]");
            }
            throw new ConfigurationError("Invalid property '" + token + "' in dataSource section [" + section + "]. Correct syntax is [dataSource:<name> host:<host> path:<path>}]");
        }
        String type = applicationConfig.getProperty(section, "databaseLayer");
        if (type.equals(PROPERTY_NOT_SET)) {
            throw new ConfigurationError("Data source section [" + section + "] misses the required property 'databaseLayer'.");
        }
        String[] globalDatabaseConfigurationProperties = new String[]{"foreignKeys", "defaultDataSource"};
        Map<String, String> globalProperties = applicationConfig.getPropertiesAsMap("dataSourceConfig");
        Hashtable<String, String> dataSourceConfiguration = new Hashtable<String, String>();
        for (String globalProperty : globalDatabaseConfigurationProperties) {
            if (globalProperties.get(globalProperty) == null) continue;
            dataSourceConfiguration.put(globalProperty, globalProperties.get(globalProperty));
        }
        try {
            dataSourceConfiguration.putAll(applicationConfig.getPropertiesAsMap(section));
        }
        catch (ConfigurationError ce) {
            throw new ConfigurationError("DataSource [" + section + "] is not configured in Makumba.conf");
        }
        ConfiguredDataSource c = new ConfiguredDataSource(host, name, path, DataSourceType.valueOf(type));
        c.setProperties(dataSourceConfiguration);
        return c;
    }

    public static void setPropery(String section, String key, String value) {
        applicationConfig.getSection(section).setProperty(key, (Object)value);
    }

    public static String getDataDefinitionProvider() {
        return applicationConfig.getProperty("dataSourceConfig", KEY_DATADEFINITIONPROVIDER);
    }

    public static String getQueryInliner() {
        return applicationConfig.getProperty("dataSourceConfig", KEY_QUERYFUNCTIONINLINER);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getDefaultDatabaseLayer() {
        Object object = loadLock;
        synchronized (object) {
            return applicationConfig.getProperty("dataSourceConfig", KEY_DEFAULT_DATABASE_LAYER);
        }
    }

    public static String getClientSideValidationDefault() {
        return defaultClientSideValidation;
    }

    public static boolean getReloadFormOnErrorDefault() {
        return defaultReloadFormOnError;
    }

    public static String getDefaultFormAnnotation() {
        return defaultFormAnnotation;
    }

    public static boolean getCalendarEditorDefault() {
        return applicationConfig.getBooleanProperty("inputStyleConfig", KEY_CALENDAR_EDITOR);
    }

    public static String getDefaultCalendarEditorLink(String contextPath) {
        return applicationConfig.getProperty("inputStyleConfig", KEY_CALENDAR_EDITOR_LINK).replaceAll(PLACEHOLDER_CONTEXT_PATH, contextPath);
    }

    public static String getRepositoryURL() {
        return applicationConfig.getProperty("makumbaToolConfig", KEY_REPOSITORY_URL);
    }

    public static String getRepositoryLinkText() {
        return applicationConfig.getProperty("makumbaToolConfig", KEY_REPOSITORY_LINK_TEXT);
    }

    public static boolean getErrorLog() {
        return applicationConfig.getBooleanProperty("makumbaToolConfig", KEY_DB_ERROR_LOG);
    }

    public static String getResourceLocation(String res) {
        return applicationConfig.getProperty("makumbaToolConfig", res + "_location");
    }

    public static String getMakumbaToolsLocation() {
        String property = applicationConfig.getProperty("makumbaToolPaths", KEY_MAKUMBA_TOOLS);
        return property.endsWith("/") ? property.substring(0, property.length() - 1) : property;
    }

    public static String getMddViewerLocation() {
        return Configuration.getCompletePath(applicationConfig.getProperty("makumbaToolPaths", KEY_MDD_VIEWER));
    }

    public static String getJavaViewerLocation() {
        return Configuration.getCompletePath(applicationConfig.getProperty("makumbaToolPaths", KEY_JAVA_VIEWER));
    }

    public static String getLogicDiscoveryViewerLocation() {
        return Configuration.getCompletePath(applicationConfig.getProperty("makumbaToolPaths", KEY_LOGIC_DISCOVERY));
    }

    public static String getDataViewerLocation() {
        return Configuration.getCompletePath(applicationConfig.getProperty("makumbaToolPaths", KEY_DATA_OBJECT_VIEWER));
    }

    public static String getDataListerLocation() {
        return Configuration.getCompletePath(applicationConfig.getProperty("makumbaToolPaths", KEY_DATA_LISTER));
    }

    public static String getDataQueryLocation() {
        return Configuration.getCompletePath(applicationConfig.getProperty("makumbaToolPaths", KEY_DATA_QUERY_TOOL));
    }

    public static String getObjectIdConverterLocation() {
        return Configuration.getCompletePath(applicationConfig.getProperty("makumbaToolPaths", KEY_OBJECT_ID_CONVERTER));
    }

    public static String getReferenceCheckerLocation() {
        return Configuration.getCompletePath(applicationConfig.getProperty("makumbaToolPaths", KEY_REFERENCE_CHECKER));
    }

    public static String getCodeGeneratorLocation() {
        return Configuration.getCompletePath(applicationConfig.getProperty("makumbaToolPaths", KEY_CODE_GENERATOR));
    }

    public static String getMakumbaValueEditorLocation() {
        return Configuration.getCompletePath(applicationConfig.getProperty("makumbaToolPaths", KEY_MAKUMBA_VALUE_EDITOR));
    }

    public static String getMakumbaRelationCrawlerLocation() {
        return Configuration.getCompletePath(applicationConfig.getProperty("makumbaToolPaths", KEY_RELATION_CRAWLER));
    }

    public static String getMakumbaUniqueLocation() {
        return Configuration.getMakumbaToolsLocation() + applicationConfig.getProperty("makumbaToolPaths", KEY_MAKUMBA_UNIQUENESS_VALIDATOR);
    }

    public static String getMakumbaAutoCompleteLocation() {
        return Configuration.getMakumbaToolsLocation() + applicationConfig.getProperty("makumbaToolPaths", KEY_MAKUMBA_AUTOCOMPLETE);
    }

    public static String getMakumbaResourcesLocation() {
        return Configuration.getCompletePath(applicationConfig.getProperty("makumbaToolPaths", KEY_MAKUMBA_RESOURCES));
    }

    public static String getMakumbaDownloadLocation() {
        return Configuration.getCompletePath(applicationConfig.getProperty("makumbaToolPaths", KEY_MAKUMBA_DOWNLOAD));
    }

    public static String getMakumbaCacheCleanerLocation() {
        return Configuration.getCompletePath(applicationConfig.getProperty("makumbaToolPaths", KEY_MAKUMBA_CACHE_CLEANER));
    }

    public static String getMakumbaToolsPathConfigProperty(String key) {
        return applicationConfig.getProperty("makumbaToolPaths", key);
    }

    public static Map<String, String> getJavaViewerSyntaxStyles() {
        return applicationConfig.getPropertiesAsMap("javaViewerSyntaxStyles", defaultConfig);
    }

    public static Map<String, String> getJspViewerSyntaxStyles() {
        return applicationConfig.getPropertiesAsMap("jspViewerSyntaxStyles", defaultConfig);
    }

    public static Map<String, String> getJspViewerSyntaxStylesTags() {
        return applicationConfig.getPropertiesAsMap("jspViewerSyntaxStylesTags", defaultConfig);
    }

    public static Map<String, Map<String, String>> getInternalCodeGeneratorTemplates() {
        return defaultConfig.getPropertiesStartingWith("codeGeneratorTemplate:");
    }

    public static Map<String, Map<String, String>> getApplicationSpecificCodeGeneratorTemplates() {
        return applicationConfig.getPropertiesStartingWith("codeGeneratorTemplate:");
    }

    public static Map<String, String> getLogicPackages() {
        return applicationConfig.getPropertiesAsMap("businessLogicPackages");
    }

    public static Map<String, String> getAuthorizationDefinitions() {
        return applicationConfig.getPropertiesAsMap("authorization");
    }

    public static String getApplicationConfigurationSource() {
        return applicationConfig != null ? applicationConfig.getSource() : null;
    }

    public static String getDefaultLanguage() {
        return applicationConfig.getProperty("internationalization", KEY_DEFAULT_LANG);
    }

    public static String getLanguageParameterName() {
        return applicationConfig.getProperty("internationalization", KEY_LANG_PARAM);
    }

    public static String getLanguageAttributeName() {
        return applicationConfig.getProperty("internationalization", KEY_LANG_ATTRIBUTE);
    }

    private static String getCompletePath(String path) {
        return StringUtils.isBlank((String)path) || path.equals(PROPERTY_NOT_SET) ? PROPERTY_NOT_SET : Configuration.getMakumbaToolsLocation() + path;
    }

    public static Map<String, String> getDataSourceConfiguration(String dataSourceName) {
        ConfiguredDataSource conf = Configuration.lookupDataSource(dataSourceName);
        return conf.getProperties();
    }

    public static DataSourceType getDataSourceType(String dataSourceName) {
        return Configuration.lookupDataSource(dataSourceName).getType();
    }

    public static String getDefaultDataSourceName() {
        return Configuration.getDefaultDataSource().getName();
    }

    public static Map<String, String> getDefaultDataSourceConfiguration() {
        return Configuration.getDefaultDataSource().getProperties();
    }

    private static ConfiguredDataSource getDefaultDataSource() {
        if (defaultDataSource == null) {
            Map<String, String> globalProperties = applicationConfig.getPropertiesAsMap("dataSourceConfig");
            String defaultDataSourceName = globalProperties.get("defaultDataSource");
            if (defaultDataSourceName != null) {
                for (String c : configuredDataSources.keySet()) {
                    if (!c.equals("dataSource:" + defaultDataSourceName) && !c.startsWith("dataSource:" + defaultDataSourceName + " ")) continue;
                    defaultDataSource = configuredDataSources.get(c);
                    return defaultDataSource;
                }
                throw new ConfigurationError("Default dataSource " + defaultDataSourceName + " not found in Makumba.conf");
            }
            int count = 0;
            String lastSection = "";
            HashMap<String, Boolean> toLookUp = new HashMap<String, Boolean>();
            for (Object e : applicationConfig.getSections()) {
                String section = (String)e;
                if (!section.startsWith("dataSource:")) continue;
                ++count;
                lastSection = section;
                if (section.indexOf(" ") > -1 && toLookUp.get(section.substring(0, section.indexOf(" "))) != null) {
                    toLookUp.put(section.substring(0, section.indexOf(" ")), true);
                    continue;
                }
                if (section.indexOf(" ") <= -1) continue;
                toLookUp.put(section.substring(0, section.indexOf(" ")), false);
            }
            if (count == 1) {
                defaultDataSource = Configuration.buildConfiguredDataSource(lastSection);
                return defaultDataSource;
            }
            if (count == 0) {
                throw new ConfigurationError("You must configure at least one dataSource for Makumba to work properly");
            }
            for (Map.Entry entry : toLookUp.entrySet()) {
                ConfiguredDataSource c;
                if (!((Boolean)entry.getValue()).booleanValue() || (c = Configuration.lookupDataSource(((String)entry.getKey()).substring("dataSource:".length()))) == null) continue;
                defaultDataSource = c;
            }
            if (defaultDataSourceName == null) {
                throw new ConfigurationError("Since there is more than one configured dataSource, Makumba needs to know which one to use. Please specify a defaultDataSource in section dataSourceConfig.");
            }
        }
        return defaultDataSource;
    }

    public static String getRemoteDataSourceConfigurationPath() {
        return remoteDataSourceConfigurationPath;
    }

    private static ConfiguredDataSource lookupDataSource(String dataSourceName) {
        ConfiguredDataSource result = resolvedConfiguredDataSources.get(dataSourceName);
        if (result == null) {
            try {
                String alternatePath;
                String host = InetAddress.getLocalHost().getCanonicalHostName();
                String path = System.getProperty("user.dir");
                URL u = ClassResource.get("/");
                String string = alternatePath = u != null ? u.toString() : null;
                if (alternatePath != null && alternatePath.startsWith("file:")) {
                    alternatePath = alternatePath.substring("file:".length());
                }
                String thisConfiguration1 = "dataSource:" + dataSourceName + " host:" + host + " path:" + path;
                String thisConfiguration2 = "dataSource:" + dataSourceName + " host:" + host + " path:" + alternatePath;
                remoteDataSourceConfigurationPath = thisConfiguration1;
                String maxKey = "";
                for (String k : configuredDataSources.keySet()) {
                    if (!thisConfiguration1.startsWith(k) || k.length() <= maxKey.length() || !k.startsWith("dataSource:" + dataSourceName + " ")) continue;
                    maxKey = k;
                    result = configuredDataSources.get(k);
                }
                if (result == null) {
                    for (String k : configuredDataSources.keySet()) {
                        if (!thisConfiguration2.startsWith(k) || k.length() <= maxKey.length() || !k.startsWith("dataSource:" + dataSourceName + " ")) continue;
                        maxKey = k;
                        result = configuredDataSources.get(k);
                    }
                    if (result == null && (result = configuredDataSources.get("dataSource:" + dataSourceName)) == null) {
                        throw new ConfigurationError("No DataSource " + dataSourceName + " configured in Makumba.conf");
                    }
                }
            }
            catch (UnknownHostException e) {
                e.printStackTrace();
            }
            logger.info("Resolved dataSource " + dataSourceName + " to " + result.toString());
            resolvedConfiguredDataSources.put(result.getName(), result);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        loadLock = new Object();
        logger = Logger.getLogger("org.makumba.config");
        try {
            URL path = ClassResource.get(MAKUMBA_CONF_DEFAULT);
            logger.info("Loading internal default configuration from " + path);
            defaultConfig = new MakumbaINIConfiguration(path);
            URL url = ClassResource.get(MAKUMBA_CONF);
            if (url != null) {
                logger.info("Loading application configuration from " + url);
                Object object = loadLock;
                synchronized (object) {
                    applicationConfig = new MakumbaINIConfiguration(url, defaultConfig);
                }
            } else {
                logger.severe("No application configuration found!");
                throw new ConfigurationError("Could not find application configuration file Makumba.conf in WEB-INF/classes!");
            }
            defaultReloadFormOnError = applicationConfig.getBooleanProperty("controllerConfig", KEY_RELOAD_FORM_ON_ERROR);
            defaultClientSideValidation = applicationConfig.getProperty("controllerConfig", KEY_CLIENT_SIDE_VALIDATION);
            defaultFormAnnotation = applicationConfig.getProperty("controllerConfig", KEY_FORM_ANNOTATION);
            Configuration.buildConfiguredDataSources();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        defaultDataSource = null;
        resolvedConfiguredDataSources = new HashMap<String, ConfiguredDataSource>();
        remoteDataSourceConfigurationPath = "";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum DataSourceType {
        makumba,
        hibernate;

    }
}

