/*
 * Decompiled with CFR 0.152.
 */
package org.makumba.providers.datadefinition.mdd;

import antlr.TokenStream;
import antlr.collections.AST;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import org.makumba.forms.html.dateEditor;
import org.makumba.providers.datadefinition.mdd.ComparisonExpressionNode;
import org.makumba.providers.datadefinition.mdd.MDDAST;
import org.makumba.providers.datadefinition.mdd.MDDExpressionBaseParser;
import org.makumba.providers.datadefinition.mdd.MDDFactory;

public class MDDExpressionParser
extends MDDExpressionBaseParser {
    private MDDFactory factory;
    private AST originalExpression;
    private String typeName;

    public MDDExpressionParser(TokenStream lexer, MDDFactory factory, String typeName, AST originalExpression) {
        super(lexer);
        this.factory = factory;
        this.typeName = typeName;
        this.originalExpression = originalExpression;
    }

    protected void assignPart(ComparisonExpressionNode ce, AST part) {
        switch (part.getType()) {
            case 42: 
            case 43: 
            case 77: {
                if (ce.getLhs() == null) {
                    ce.setLhs(part.getText());
                    ce.setLhs_date(this.handleDate(ce, part));
                    ce.setLhs_type(77);
                    break;
                }
                ce.setRhs(part.getText());
                ce.setRhs_date(this.handleDate(ce, part));
                ce.setRhs_type(77);
                break;
            }
            default: {
                if (ce.getLhs() == null) {
                    ce.setLhs(part.getText());
                    ce.setLhs_type(part.getType());
                    break;
                }
                ce.setRhs(part.getText());
                ce.setRhs_type(part.getType());
            }
        }
    }

    private Date handleDate(ComparisonExpressionNode ce, AST part) {
        GregorianCalendar c = new GregorianCalendar();
        c.set(14, 0);
        switch (part.getType()) {
            case 42: 
            case 43: {
                this.handleConstant(c, part);
                break;
            }
            case 77: {
                int level = 0;
                AST arg = part.getFirstChild();
                while (arg.getNextSibling() != null && level < 10) {
                    this.processDate(c, arg, level);
                    if (++level > 6) {
                        MDDAST argMDD = (MDDAST)arg;
                        MDDAST originalMDD = (MDDAST)this.originalExpression;
                        argMDD.setLine(originalMDD.getLine());
                        argMDD.setCol(argMDD.getColumn() + originalMDD.getColumn());
                        this.factory.doThrow(this.typeName, "date() function cannot have more than 6 arguments", (AST)argMDD);
                    }
                    arg = arg.getNextSibling();
                }
                break;
            }
        }
        return c.getTime();
    }

    private void processDate(GregorianCalendar c, AST arg, int level) {
        switch (arg.getType()) {
            case 25: 
            case 26: {
                AST lhs = arg.getFirstChild();
                AST rhs = lhs.getNextSibling();
                int lhs_val = this.getSummandValue(c, level, lhs);
                int rhs_val = this.getSummandValue(c, level, rhs);
                if (arg.getType() == 25) {
                    c.set(dateEditor.components[level], lhs_val - rhs_val);
                    break;
                }
                c.set(dateEditor.components[level], lhs_val + rhs_val);
                break;
            }
        }
    }

    private int getSummandValue(GregorianCalendar c, int level, AST lhs) {
        if (lhs.getType() == 42) {
            return c.get(dateEditor.components[level]);
        }
        if (lhs.getType() == 31 || lhs.getType() == 32) {
            return Integer.parseInt(lhs.getText());
        }
        throw new RuntimeException("expecting NOW or NUMBER but got " + lhs.getType());
    }

    private void handleConstant(Calendar c, AST constant) {
        switch (constant.getType()) {
            case 42: {
                break;
            }
            case 43: {
                c.set(11, 0);
                c.set(12, 0);
                c.set(13, 0);
            }
        }
    }
}

