/*
 * Decompiled with CFR 0.152.
 */
package org.makumba.providers.datadefinition.mdd;

import antlr.ANTLRException;
import antlr.RecognitionException;
import antlr.TokenStreamRecognitionException;
import antlr.collections.AST;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.SequenceInputStream;
import java.net.URL;
import java.util.HashMap;
import org.makumba.DataDefinition;
import org.makumba.DataDefinitionNotFoundError;
import org.makumba.DataDefinitionParseError;
import org.makumba.commons.SingletonReleaser;
import org.makumba.providers.datadefinition.mdd.DataDefinitionImpl;
import org.makumba.providers.datadefinition.mdd.MDDAST;
import org.makumba.providers.datadefinition.mdd.MDDASTFactory;
import org.makumba.providers.datadefinition.mdd.MDDAnalyzeWalker;
import org.makumba.providers.datadefinition.mdd.MDDLexer;
import org.makumba.providers.datadefinition.mdd.MDDParser;
import org.makumba.providers.datadefinition.mdd.MDDPostProcessorWalker;
import org.makumba.providers.datadefinition.mdd.MDDProvider;

public class MDDFactory {
    private static final boolean printTrees = false;
    private static MDDASTFactory astFactory = new MDDASTFactory();
    private HashMap<String, BufferedReader> errorReaders = new HashMap();

    private MDDFactory() {
    }

    public static MDDFactory getInstance() {
        return SingletonHolder.singleton;
    }

    public DataDefinition getDataDefinition(String typeName) {
        this.errorReaders = new HashMap();
        URL u = this.getDataDefinitionURL(typeName, "mdd");
        MDDParser parser = this.parse(typeName, u, false);
        return this.buildDataDefinition(typeName, u, parser, true, false);
    }

    public DataDefinition getVirtualDataDefinition(String typeName, String definition) {
        this.errorReaders = new HashMap();
        MDDParser parser = this.parse(typeName, definition);
        return this.buildDataDefinition(typeName, null, parser, false, true);
    }

    private DataDefinition buildDataDefinition(String typeName, URL u, MDDParser parser, boolean strictTypeCheck, boolean virtual) {
        MDDAnalyzeWalker analysisWalker = null;
        try {
            analysisWalker = new MDDAnalyzeWalker(typeName, u, this, parser, strictTypeCheck);
            analysisWalker.setASTFactory(astFactory);
            analysisWalker.dataDefinition(parser.getAST());
        }
        catch (ANTLRException t) {
            this.doThrow(t, parser.getAST(), typeName);
        }
        catch (DataDefinitionParseError dpe) {
            throw dpe;
        }
        catch (NullPointerException npe) {
            if (analysisWalker.error != null) {
                this.doThrow(analysisWalker.error, parser.getAST(), typeName);
            }
            throw npe;
        }
        catch (Throwable t) {
            this.doThrow(t, parser.getAST(), typeName);
        }
        this.doThrow(parser.error, parser.getAST(), typeName);
        if (analysisWalker.getAST() == null && parser.getAST() != null) {
            throw new DataDefinitionParseError("Could not parse " + typeName + ": analyser returned empty AST. Please report to developers.");
        }
        MDDPostProcessorWalker postProcessor = null;
        try {
            postProcessor = new MDDPostProcessorWalker(typeName, analysisWalker.mdd, analysisWalker.typeShorthands, this);
            postProcessor.dataDefinition(analysisWalker.getAST());
        }
        catch (ANTLRException t) {
            this.doThrow(t, parser.getAST(), typeName);
        }
        catch (DataDefinitionParseError dpe) {
            throw dpe;
        }
        catch (NullPointerException npe) {
            if (postProcessor.error != null) {
                this.doThrow(postProcessor.error, parser.getAST(), typeName);
            }
            throw npe;
        }
        catch (Throwable t) {
            this.doThrow(t, parser.getAST(), typeName);
        }
        this.doThrow(parser.error, parser.getAST(), typeName);
        if (postProcessor.getAST() == null && analysisWalker.getAST() != null) {
            throw new DataDefinitionParseError("Could not parse " + typeName + ": postprocessor returned empty AST. Please report to developers.");
        }
        DataDefinitionImpl result = new DataDefinitionImpl(postProcessor.mdd);
        if (!virtual) {
            return result;
        }
        result.build();
        return result;
    }

    protected MDDParser parse(String typeName, String text) {
        ByteArrayInputStream o = new ByteArrayInputStream(text.getBytes());
        ByteArrayInputStream o1 = new ByteArrayInputStream(text.getBytes());
        return this.parse(typeName, o, o1, false);
    }

    private MDDParser parse(String typeName, URL u, boolean included) {
        InputStream o = null;
        InputStream o1 = null;
        try {
            o = (InputStream)u.getContent();
            o1 = (InputStream)u.getContent();
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        return this.parse(typeName, o, o1, included);
    }

    private MDDParser parse(String typeName, InputStream o, InputStream o1, boolean included) {
        ByteArrayInputStream newLine1 = new ByteArrayInputStream("\n".getBytes());
        ByteArrayInputStream newLine2 = new ByteArrayInputStream("\n".getBytes());
        SequenceInputStream seq1 = new SequenceInputStream(o, newLine1);
        SequenceInputStream seq2 = new SequenceInputStream(o1, newLine2);
        InputStreamReader reader = new InputStreamReader(seq1);
        MDDLexer lexer = new MDDLexer(reader);
        BufferedReader errorReader = new BufferedReader(new InputStreamReader(seq2));
        this.errorReaders.put(typeName, errorReader);
        MDDParser parser = null;
        try {
            parser = new MDDParser(lexer, this, typeName, included);
            parser.setASTFactory(astFactory);
            parser.dataDefinition();
            parser.postProcess();
        }
        catch (ANTLRException t) {
            this.doThrow(t, parser.getAST(), typeName);
        }
        catch (DataDefinitionParseError dpe) {
            throw dpe;
        }
        catch (NullPointerException npe) {
            if (parser.error != null) {
                this.doThrow(parser.error, parser.getAST(), typeName);
            }
            throw npe;
        }
        catch (Throwable t) {
            this.doThrow(t, parser.getAST(), typeName);
        }
        this.doThrow(parser.error, parser.getAST(), typeName);
        return parser;
    }

    protected MDDParser parseIncludedDataDefinition(String includedName) {
        URL idd = this.getDataDefinitionURL(includedName, "idd");
        return this.parse(includedName, idd, true);
    }

    protected void doThrow(Throwable t, AST debugTree, String typeName) throws DataDefinitionParseError {
        RecognitionException re;
        if (t == null) {
            return;
        }
        if (t instanceof DataDefinitionParseError) {
            throw (DataDefinitionParseError)t;
        }
        String line = "";
        int column = 0;
        if (t instanceof TokenStreamRecognitionException) {
            TokenStreamRecognitionException te = (TokenStreamRecognitionException)t;
            t = te.recog;
        }
        if (t instanceof RecognitionException && (re = (RecognitionException)t).getColumn() > 0) {
            column = re.getColumn();
            line = this.getLine(re.getLine(), typeName);
        }
        throw new DataDefinitionParseError(typeName, t.getMessage(), line, column - 1);
    }

    protected void doThrow(String typeName, String message, AST ast) {
        int line = ((MDDAST)ast).getLine();
        int col = ((MDDAST)ast).getColumn() - 1;
        throw new DataDefinitionParseError(typeName, message, this.getLine(line, typeName), col);
    }

    protected String getLine(int lineNumber, String typeName) {
        String line = "";
        for (int i = 0; i < lineNumber; ++i) {
            try {
                line = this.errorReaders.get(typeName).readLine();
                continue;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return line;
    }

    private URL getDataDefinitionURL(String typeName, String extension) throws DataDefinitionNotFoundError {
        URL u = MDDProvider.findDataDefinition(typeName, extension);
        if (u == null) {
            throw new DataDefinitionNotFoundError(typeName);
        }
        return u;
    }

    private static final class SingletonHolder
    implements org.makumba.commons.SingletonHolder {
        static MDDFactory singleton = new MDDFactory();

        public void release() {
            singleton = null;
        }

        public SingletonHolder() {
            SingletonReleaser.register(this);
        }
    }
}

