/*
 * Decompiled with CFR 0.152.
 */
package org.makumba.providers.query.mql;

import antlr.SemanticException;
import antlr.collections.AST;
import org.makumba.DataDefinition;
import org.makumba.DataDefinitionNotFoundError;
import org.makumba.providers.DataDefinitionProvider;
import org.makumba.providers.query.mql.ASTUtil;
import org.makumba.providers.query.mql.MqlIdentNode;
import org.makumba.providers.query.mql.MqlNode;

public class MqlDotNode
extends MqlNode {
    private static final long serialVersionUID = 1L;
    String label;
    String field;

    void processInExpression() throws SemanticException {
        String path = ASTUtil.getPathText((AST)this);
        DataDefinition type = null;
        try {
            type = DataDefinitionProvider.getInstance().getDataDefinition(path);
        }
        catch (DataDefinitionNotFoundError e) {
            // empty catch block
        }
        if (type != null) {
            int lastDot = path.lastIndexOf(".");
            String ptrIndex = lastDot > -1 ? path.substring(lastDot + 1) : path;
            this.setMakType(type.getFieldDefinition(ptrIndex));
        } else {
            this.field = this.getFirstChild().getNextSibling().getText();
            if (this.getFirstChild() instanceof MqlDotNode) {
                MqlDotNode son = (MqlDotNode)this.getFirstChild();
                this.label = this.walker.currentContext.join(son.label, son.field, null, -1, (AST)this);
            } else if (this.getFirstChild() instanceof MqlIdentNode) {
                ((MqlIdentNode)this.getFirstChild()).resolve();
                this.label = ((MqlIdentNode)this.getFirstChild()).label;
            } else {
                throw new SemanticException("(expression).field not supported", "", this.getLine(), this.getColumn());
            }
            this.walker.currentContext.selectField(this.label, this.field, this);
        }
    }

    void processInFrom() throws SemanticException {
        if (this.getFirstChild() instanceof MqlDotNode) {
            ((MqlDotNode)this.getFirstChild()).processInFrom();
        }
        this.setText(this.getFirstChild().getText() + "." + this.getFirstChild().getNextSibling().getText());
    }
}

