/*
 * Decompiled with CFR 0.152.
 */
package org.makumba.providers.query.mql;

import antlr.RecognitionException;
import antlr.collections.AST;
import java.util.ArrayList;
import java.util.Date;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.makumba.DataDefinition;
import org.makumba.FieldDefinition;
import org.makumba.OQLParseError;
import org.makumba.commons.NameResolver;
import org.makumba.providers.DataDefinitionProvider;
import org.makumba.providers.QueryAnalysis;
import org.makumba.providers.QueryProvider;
import org.makumba.providers.query.mql.HqlParser;
import org.makumba.providers.query.mql.MqlQueryAnalysisProvider;
import org.makumba.providers.query.mql.MqlSqlGenerator;
import org.makumba.providers.query.mql.MqlSqlWalker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MqlQueryAnalysis
implements QueryAnalysis {
    public static final String MAKUMBA_PARAM = "param";
    private String query;
    protected DataDefinition insertIn;
    private List<String> parameterOrder = new ArrayList<String>();
    private DataDefinition proj;
    private boolean noFrom = false;
    private LinkedHashMap<String, DataDefinition> labels;
    private Hashtable<String, String> aliases;
    private DataDefinition paramInfo;
    private NameResolver.TextList text;
    protected Vector<String> generatedLabels = new Vector();
    public static final String regExpInSET = "in[\\s]+set[\\s]*\\(";
    public static final Pattern patternInSet = Pattern.compile("in[\\s]+set[\\s]*\\(");
    private int labelCounter = 0;

    static String formatQueryAndInsert(String query, String insertIn) {
        if (insertIn != null && insertIn.length() > 0) {
            return "###" + insertIn + "###" + query;
        }
        return query;
    }

    public MqlQueryAnalysis(String queryAndInsert, boolean optimizeJoins, boolean autoLeftJoin) {
        Date d = new Date();
        if (queryAndInsert.startsWith("###")) {
            this.insertIn = DataDefinitionProvider.getInstance().getDataDefinition(queryAndInsert.substring(3, queryAndInsert.indexOf(35, 3)));
            this.query = queryAndInsert.substring(queryAndInsert.indexOf(35, 3) + 3);
        } else {
            this.query = queryAndInsert;
        }
        this.query = MqlQueryAnalysis.preProcess(this.query);
        if (this.query.toLowerCase().indexOf("from") == -1) {
            this.noFrom = true;
            this.query = this.query + " FROM org.makumba.db.makumba.Catalog c";
        }
        HqlParser parser = null;
        try {
            parser = HqlParser.getInstance(this.query);
            parser.statement();
        }
        catch (Throwable t) {
            this.doThrow(t, parser != null ? parser.getAST() : null);
        }
        this.doThrow(parser.error, parser.getAST());
        MqlQueryAnalysisProvider.transformOQLParameters(parser.getAST(), this.parameterOrder);
        MqlQueryAnalysisProvider.transformOQL(parser.getAST());
        MqlSqlWalker mqlAnalyzer = new MqlSqlWalker(this.query, this.insertIn, optimizeJoins, autoLeftJoin, false);
        try {
            mqlAnalyzer.statement(parser.getAST());
        }
        catch (Throwable e) {
            this.doThrow(e, parser.getAST());
        }
        this.doThrow(mqlAnalyzer.error, parser.getAST());
        this.labels = mqlAnalyzer.rootContext.labels;
        this.aliases = mqlAnalyzer.rootContext.aliases;
        this.paramInfo = DataDefinitionProvider.getInstance().getVirtualDataDefinition("Parameters for " + this.query);
        this.proj = DataDefinitionProvider.getInstance().getVirtualDataDefinition("Projections for " + this.query);
        mqlAnalyzer.setProjectionTypes(this.proj);
        for (int i = 0; i < this.parameterOrder.size(); ++i) {
            FieldDefinition fd = mqlAnalyzer.paramInfoByPosition.getFieldDefinition(MAKUMBA_PARAM + i);
            if (fd == null && !mqlAnalyzer.multiTypeParams.contains(this.parameterOrder.get(i))) {
                fd = mqlAnalyzer.paramInfoByName.getFieldDefinition(this.parameterOrder.get(i));
            }
            if (fd == null) continue;
            this.paramInfo.addField(DataDefinitionProvider.getInstance().makeFieldWithName(MAKUMBA_PARAM + i, fd));
        }
        MqlSqlGenerator mg = new MqlSqlGenerator();
        try {
            mg.statement(mqlAnalyzer.getAST());
        }
        catch (Throwable e) {
            this.doThrow(e, mqlAnalyzer.getAST());
        }
        this.doThrow(mg.error, mqlAnalyzer.getAST());
        this.text = mg.text;
        long diff = new Date().getTime() - d.getTime();
        Logger.getLogger("org.makumba.db.query.compilation").fine("MQL to SQL: " + diff + " ms: " + this.query);
    }

    protected void doThrow(Throwable t, AST debugTree) {
        RecognitionException re;
        if (t == null) {
            return;
        }
        if (t instanceof RuntimeException) {
            t.printStackTrace();
            throw (RuntimeException)t;
        }
        String errorLocation = "";
        String errorLocationNumber = "";
        if (t instanceof RecognitionException && (re = (RecognitionException)t).getColumn() > 0) {
            errorLocationNumber = " column " + re.getColumn() + " of ";
            StringBuffer sb = new StringBuffer();
            sb.append("\r\n");
            for (int i = 0; i < re.getColumn(); ++i) {
                sb.append(' ');
            }
            sb.append('^');
            errorLocation = sb.toString();
        }
        throw new OQLParseError("\r\nin " + errorLocationNumber + " query:\r\n" + this.query + errorLocation + errorLocation + errorLocation, t);
    }

    @Override
    public String writeInSQLQuery(NameResolver nr) {
        String sql = this.text.toString(nr);
        if (this.noFrom) {
            return sql.substring(0, sql.toLowerCase().indexOf("from")).trim();
        }
        return sql;
    }

    @Override
    public String getQuery() {
        return this.query;
    }

    @Override
    public DataDefinition getLabelType(String labelName) {
        String s1 = this.aliases.get(labelName);
        if (s1 != null) {
            labelName = s1;
        }
        return this.labels.get(labelName);
    }

    @Override
    public Map<String, DataDefinition> getLabelTypes() {
        return this.labels;
    }

    @Override
    public DataDefinition getParameterTypes() {
        return this.paramInfo;
    }

    @Override
    public DataDefinition getProjectionType() {
        return this.proj;
    }

    private String getFrom() {
        String[] splitAtFrom = this.query.split("\\s[f|F][r|R][o|O][m|M]\\s");
        String[] splitAtWhere = splitAtFrom[1].split("\\s[w|W][h|H][e|E][r|R][e|E]\\s");
        return splitAtWhere[0];
    }

    public String getFieldOfExpr(String expr) {
        if (expr.indexOf(".") > -1) {
            return expr.substring(expr.lastIndexOf(".") + 1);
        }
        return expr;
    }

    public DataDefinition getTypeOfExprField(String expr) {
        DataDefinition result;
        if (expr.indexOf(".") == -1) {
            return this.getLabelType(expr);
        }
        int lastDot = expr.lastIndexOf(".");
        String beforeLastDot = expr.substring(0, lastDot);
        if (beforeLastDot.indexOf(".") == -1) {
            result = this.getLabelType(beforeLastDot);
        } else {
            String dummyQuery = "SELECT " + beforeLastDot + " AS projection FROM " + this.getFrom();
            result = QueryProvider.getQueryAnalzyer("OQL").getQueryAnalysis(dummyQuery).getProjectionType().getFieldDefinition("projection").getPointedType();
        }
        return result;
    }

    @Override
    public int parameterAt(int index) {
        String s = this.parameterOrder.get(index);
        if (!s.startsWith(MAKUMBA_PARAM)) {
            throw new IllegalArgumentException("parameter at " + index + " is not a $n parameter");
        }
        s = s.substring(MAKUMBA_PARAM.length());
        return Integer.parseInt(s) + 1;
    }

    @Override
    public int parameterNumber() {
        return this.parameterOrder.size();
    }

    public static String showAst(AST ast) {
        return ast.toStringTree();
    }

    static boolean isNil(AST a) {
        return a.getType() == 120 && a.getText().toUpperCase().equals("NIL");
    }

    static void setNullTest(AST a) {
        if (a.getType() == 97) {
            a.setType(77);
            a.setText("is null");
        } else {
            a.setType(76);
            a.setText("is not null");
        }
    }

    public static String preProcess(String query) {
        query = query.replaceAll("->", "__");
        Matcher m = patternInSet.matcher(query.toLowerCase());
        while (m.find()) {
            int start = m.start();
            int beginSet = m.group().indexOf("set");
            query = query.substring(0, start + beginSet) + "   " + query.substring(start + beginSet + 3);
        }
        query = query.replaceAll("IN SET", "IN    ");
        return query;
    }

    public String createLabel() {
        String l = "_x_gen_" + this.labelCounter++;
        this.generatedLabels.add(l);
        return l;
    }
}

