// $ANTLR : "OQL-translator.g" -> "OQLParser.java"$
package org.makumba.db.sql.oql; 
import antlr.TokenBuffer;
import antlr.TokenStreamException;
import antlr.TokenStreamIOException;
import antlr.ANTLRException;
import antlr.LLkParser;
import antlr.Token;
import antlr.TokenStream;
import antlr.RecognitionException;
import antlr.NoViableAltException;
import antlr.MismatchedTokenException;
import antlr.SemanticException;
import antlr.ParserSharedInputState;
import antlr.collections.impl.BitSet;
import antlr.collections.AST;
import java.util.Hashtable;
import antlr.ASTFactory;
import antlr.ASTPair;
import antlr.collections.impl.ASTArray;

public class OQLParser extends antlr.LLkParser       implements OQLLexerTokenTypes
 {

	QueryAST currentQuery=null;
	AST lastEQop=null;
	String is=null;
	int lastAdditive;
	int lastMultiplicative;
	boolean wasLeftJoin=false;
	
	QueryAST currentQuery() throws antlr.RecognitionException
	{ if(currentQuery!=null) return currentQuery; 
	  throw new antlr.RecognitionException("wrong expression, probably an operator is missing (AND, OR, +, -, *, /)");
	}

protected OQLParser(TokenBuffer tokenBuf, int k) {
  super(tokenBuf,k);
  tokenNames = _tokenNames;
  buildTokenTypeASTClassMap();
  astFactory = new ASTFactory(getTokenTypeToASTClassMap());
}

public OQLParser(TokenBuffer tokenBuf) {
  this(tokenBuf,2);
}

protected OQLParser(TokenStream lexer, int k) {
  super(lexer,k);
  tokenNames = _tokenNames;
  buildTokenTypeASTClassMap();
  astFactory = new ASTFactory(getTokenTypeToASTClassMap());
}

public OQLParser(TokenStream lexer) {
  this(lexer,2);
}

public OQLParser(ParserSharedInputState state) {
  super(state,2);
  tokenNames = _tokenNames;
  buildTokenTypeASTClassMap();
  astFactory = new ASTFactory(getTokenTypeToASTClassMap());
}

	public final void queryProgram() throws RecognitionException, TokenStreamException {
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST queryProgram_AST = null;
		
		{
		int _cnt245=0;
		_loop245:
		do {
			if ((_tokenSet_0.member(LA(1)))) {
				{
				if ((LA(1)==LITERAL_import||LA(1)==LITERAL_define||LA(1)==LITERAL_undefine)) {
					declaration();
					astFactory.addASTChild(currentAST, returnAST);
				}
				else if ((_tokenSet_1.member(LA(1)))) {
					query();
					astFactory.addASTChild(currentAST, returnAST);
				}
				else {
					throw new NoViableAltException(LT(1), getFilename());
				}
				
				}
				{
				if ((LA(1)==TOK_SEMIC)) {
					AST tmp1_AST = null;
					tmp1_AST = astFactory.create(LT(1));
					astFactory.addASTChild(currentAST, tmp1_AST);
					match(TOK_SEMIC);
				}
				else if ((_tokenSet_2.member(LA(1)))) {
				}
				else {
					throw new NoViableAltException(LT(1), getFilename());
				}
				
				}
			}
			else {
				if ( _cnt245>=1 ) { break _loop245; } else {throw new NoViableAltException(LT(1), getFilename());}
			}
			
			_cnt245++;
		} while (true);
		}
		AST tmp2_AST = null;
		tmp2_AST = astFactory.create(LT(1));
		astFactory.addASTChild(currentAST, tmp2_AST);
		match(Token.EOF_TYPE);
		queryProgram_AST = (AST)currentAST.root;
		returnAST = queryProgram_AST;
	}
	
	public final void declaration() throws RecognitionException, TokenStreamException {
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST declaration_AST = null;
		
		switch ( LA(1)) {
		case LITERAL_define:
		{
			defineQuery();
			astFactory.addASTChild(currentAST, returnAST);
			declaration_AST = (AST)currentAST.root;
			break;
		}
		case LITERAL_import:
		{
			importQuery();
			astFactory.addASTChild(currentAST, returnAST);
			declaration_AST = (AST)currentAST.root;
			break;
		}
		case LITERAL_undefine:
		{
			undefineQuery();
			astFactory.addASTChild(currentAST, returnAST);
			declaration_AST = (AST)currentAST.root;
			break;
		}
		default:
		{
			throw new NoViableAltException(LT(1), getFilename());
		}
		}
		returnAST = declaration_AST;
	}
	
	public final void query() throws RecognitionException, TokenStreamException {
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST query_AST = null;
		
		{
		if ((LA(1)==LITERAL_select)) {
			selectExpr();
			astFactory.addASTChild(currentAST, returnAST);
		}
		else if ((_tokenSet_3.member(LA(1)))) {
			expr();
			astFactory.addASTChild(currentAST, returnAST);
		}
		else {
			throw new NoViableAltException(LT(1), getFilename());
		}
		
		}
		query_AST = (AST)currentAST.root;
		returnAST = query_AST;
	}
	
	public final void defineQuery() throws RecognitionException, TokenStreamException {
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST defineQuery_AST = null;
		
		AST tmp3_AST = null;
		tmp3_AST = astFactory.create(LT(1));
		astFactory.addASTChild(currentAST, tmp3_AST);
		match(LITERAL_define);
		{
		if ((LA(1)==LITERAL_query)) {
			AST tmp4_AST = null;
			tmp4_AST = astFactory.create(LT(1));
			astFactory.addASTChild(currentAST, tmp4_AST);
			match(LITERAL_query);
		}
		else if ((LA(1)==Identifier)) {
		}
		else {
			throw new NoViableAltException(LT(1), getFilename());
		}
		
		}
		labelIdentifier();
		astFactory.addASTChild(currentAST, returnAST);
		{
		if ((LA(1)==TOK_LPAREN)) {
			AST tmp5_AST = null;
			tmp5_AST = astFactory.create(LT(1));
			astFactory.addASTChild(currentAST, tmp5_AST);
			match(TOK_LPAREN);
			type();
			astFactory.addASTChild(currentAST, returnAST);
			labelIdentifier();
			astFactory.addASTChild(currentAST, returnAST);
			{
			_loop255:
			do {
				if ((LA(1)==TOK_COMMA)) {
					AST tmp6_AST = null;
					tmp6_AST = astFactory.create(LT(1));
					astFactory.addASTChild(currentAST, tmp6_AST);
					match(TOK_COMMA);
					type();
					astFactory.addASTChild(currentAST, returnAST);
					labelIdentifier();
					astFactory.addASTChild(currentAST, returnAST);
				}
				else {
					break _loop255;
				}
				
			} while (true);
			}
			AST tmp7_AST = null;
			tmp7_AST = astFactory.create(LT(1));
			astFactory.addASTChild(currentAST, tmp7_AST);
			match(TOK_RPAREN);
		}
		else if ((LA(1)==LITERAL_as)) {
		}
		else {
			throw new NoViableAltException(LT(1), getFilename());
		}
		
		}
		AST tmp8_AST = null;
		tmp8_AST = astFactory.create(LT(1));
		astFactory.addASTChild(currentAST, tmp8_AST);
		match(LITERAL_as);
		query();
		astFactory.addASTChild(currentAST, returnAST);
		defineQuery_AST = (AST)currentAST.root;
		returnAST = defineQuery_AST;
	}
	
	public final void importQuery() throws RecognitionException, TokenStreamException {
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST importQuery_AST = null;
		
		AST tmp9_AST = null;
		tmp9_AST = astFactory.create(LT(1));
		astFactory.addASTChild(currentAST, tmp9_AST);
		match(LITERAL_import);
		labelIdentifier();
		astFactory.addASTChild(currentAST, returnAST);
		{
		_loop249:
		do {
			if ((LA(1)==TOK_DOT)) {
				AST tmp10_AST = null;
				tmp10_AST = astFactory.create(LT(1));
				astFactory.addASTChild(currentAST, tmp10_AST);
				match(TOK_DOT);
				labelIdentifier();
				astFactory.addASTChild(currentAST, returnAST);
			}
			else {
				break _loop249;
			}
			
		} while (true);
		}
		{
		if ((LA(1)==LITERAL_as)) {
			AST tmp11_AST = null;
			tmp11_AST = astFactory.create(LT(1));
			astFactory.addASTChild(currentAST, tmp11_AST);
			match(LITERAL_as);
			labelIdentifier();
			astFactory.addASTChild(currentAST, returnAST);
		}
		else if ((_tokenSet_4.member(LA(1)))) {
		}
		else {
			throw new NoViableAltException(LT(1), getFilename());
		}
		
		}
		importQuery_AST = (AST)currentAST.root;
		returnAST = importQuery_AST;
	}
	
	public final void undefineQuery() throws RecognitionException, TokenStreamException {
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST undefineQuery_AST = null;
		
		AST tmp12_AST = null;
		tmp12_AST = astFactory.create(LT(1));
		astFactory.addASTChild(currentAST, tmp12_AST);
		match(LITERAL_undefine);
		{
		if ((LA(1)==LITERAL_query)) {
			AST tmp13_AST = null;
			tmp13_AST = astFactory.create(LT(1));
			astFactory.addASTChild(currentAST, tmp13_AST);
			match(LITERAL_query);
		}
		else if ((LA(1)==Identifier)) {
		}
		else {
			throw new NoViableAltException(LT(1), getFilename());
		}
		
		}
		labelIdentifier();
		astFactory.addASTChild(currentAST, returnAST);
		undefineQuery_AST = (AST)currentAST.root;
		returnAST = undefineQuery_AST;
	}
	
	public final void labelIdentifier() throws RecognitionException, TokenStreamException {
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST labelIdentifier_AST = null;
		
		AST tmp14_AST = null;
		tmp14_AST = astFactory.create(LT(1));
		astFactory.addASTChild(currentAST, tmp14_AST);
		match(Identifier);
		labelIdentifier_AST = (AST)currentAST.root;
		returnAST = labelIdentifier_AST;
	}
	
	public final void type() throws RecognitionException, TokenStreamException {
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST type_AST = null;
		
		switch ( LA(1)) {
		case LITERAL_float:
		{
			AST tmp15_AST = null;
			tmp15_AST = astFactory.create(LT(1));
			astFactory.addASTChild(currentAST, tmp15_AST);
			match(LITERAL_float);
			type_AST = (AST)currentAST.root;
			break;
		}
		case LITERAL_double:
		{
			AST tmp16_AST = null;
			tmp16_AST = astFactory.create(LT(1));
			astFactory.addASTChild(currentAST, tmp16_AST);
			match(LITERAL_double);
			type_AST = (AST)currentAST.root;
			break;
		}
		case LITERAL_char:
		{
			AST tmp17_AST = null;
			tmp17_AST = astFactory.create(LT(1));
			astFactory.addASTChild(currentAST, tmp17_AST);
			match(LITERAL_char);
			type_AST = (AST)currentAST.root;
			break;
		}
		case LITERAL_string:
		{
			AST tmp18_AST = null;
			tmp18_AST = astFactory.create(LT(1));
			astFactory.addASTChild(currentAST, tmp18_AST);
			match(LITERAL_string);
			type_AST = (AST)currentAST.root;
			break;
		}
		case LITERAL_boolean:
		{
			AST tmp19_AST = null;
			tmp19_AST = astFactory.create(LT(1));
			astFactory.addASTChild(currentAST, tmp19_AST);
			match(LITERAL_boolean);
			type_AST = (AST)currentAST.root;
			break;
		}
		case LITERAL_octet:
		{
			AST tmp20_AST = null;
			tmp20_AST = astFactory.create(LT(1));
			astFactory.addASTChild(currentAST, tmp20_AST);
			match(LITERAL_octet);
			type_AST = (AST)currentAST.root;
			break;
		}
		case LITERAL_date:
		{
			AST tmp21_AST = null;
			tmp21_AST = astFactory.create(LT(1));
			astFactory.addASTChild(currentAST, tmp21_AST);
			match(LITERAL_date);
			type_AST = (AST)currentAST.root;
			break;
		}
		case LITERAL_time:
		{
			AST tmp22_AST = null;
			tmp22_AST = astFactory.create(LT(1));
			astFactory.addASTChild(currentAST, tmp22_AST);
			match(LITERAL_time);
			type_AST = (AST)currentAST.root;
			break;
		}
		case LITERAL_interval:
		{
			AST tmp23_AST = null;
			tmp23_AST = astFactory.create(LT(1));
			astFactory.addASTChild(currentAST, tmp23_AST);
			match(LITERAL_interval);
			type_AST = (AST)currentAST.root;
			break;
		}
		case LITERAL_timestamp:
		{
			AST tmp24_AST = null;
			tmp24_AST = astFactory.create(LT(1));
			astFactory.addASTChild(currentAST, tmp24_AST);
			match(LITERAL_timestamp);
			type_AST = (AST)currentAST.root;
			break;
		}
		case LITERAL_set:
		{
			AST tmp25_AST = null;
			tmp25_AST = astFactory.create(LT(1));
			astFactory.addASTChild(currentAST, tmp25_AST);
			match(LITERAL_set);
			AST tmp26_AST = null;
			tmp26_AST = astFactory.create(LT(1));
			astFactory.addASTChild(currentAST, tmp26_AST);
			match(TOK_LT);
			type();
			astFactory.addASTChild(currentAST, returnAST);
			AST tmp27_AST = null;
			tmp27_AST = astFactory.create(LT(1));
			astFactory.addASTChild(currentAST, tmp27_AST);
			match(TOK_GT);
			type_AST = (AST)currentAST.root;
			break;
		}
		case LITERAL_bag:
		{
			AST tmp28_AST = null;
			tmp28_AST = astFactory.create(LT(1));
			astFactory.addASTChild(currentAST, tmp28_AST);
			match(LITERAL_bag);
			AST tmp29_AST = null;
			tmp29_AST = astFactory.create(LT(1));
			astFactory.addASTChild(currentAST, tmp29_AST);
			match(TOK_LT);
			type();
			astFactory.addASTChild(currentAST, returnAST);
			AST tmp30_AST = null;
			tmp30_AST = astFactory.create(LT(1));
			astFactory.addASTChild(currentAST, tmp30_AST);
			match(TOK_GT);
			type_AST = (AST)currentAST.root;
			break;
		}
		case LITERAL_list:
		{
			AST tmp31_AST = null;
			tmp31_AST = astFactory.create(LT(1));
			astFactory.addASTChild(currentAST, tmp31_AST);
			match(LITERAL_list);
			AST tmp32_AST = null;
			tmp32_AST = astFactory.create(LT(1));
			astFactory.addASTChild(currentAST, tmp32_AST);
			match(TOK_LT);
			type();
			astFactory.addASTChild(currentAST, returnAST);
			AST tmp33_AST = null;
			tmp33_AST = astFactory.create(LT(1));
			astFactory.addASTChild(currentAST, tmp33_AST);
			match(TOK_GT);
			type_AST = (AST)currentAST.root;
			break;
		}
		case LITERAL_array:
		{
			AST tmp34_AST = null;
			tmp34_AST = astFactory.create(LT(1));
			astFactory.addASTChild(currentAST, tmp34_AST);
			match(LITERAL_array);
			AST tmp35_AST = null;
			tmp35_AST = astFactory.create(LT(1));
			astFactory.addASTChild(currentAST, tmp35_AST);
			match(TOK_LT);
			type();
			astFactory.addASTChild(currentAST, returnAST);
			AST tmp36_AST = null;
			tmp36_AST = astFactory.create(LT(1));
			astFactory.addASTChild(currentAST, tmp36_AST);
			match(TOK_GT);
			type_AST = (AST)currentAST.root;
			break;
		}
		case LITERAL_dictionary:
		{
			AST tmp37_AST = null;
			tmp37_AST = astFactory.create(LT(1));
			astFactory.addASTChild(currentAST, tmp37_AST);
			match(LITERAL_dictionary);
			AST tmp38_AST = null;
			tmp38_AST = astFactory.create(LT(1));
			astFactory.addASTChild(currentAST, tmp38_AST);
			match(TOK_LT);
			type();
			astFactory.addASTChild(currentAST, returnAST);
			AST tmp39_AST = null;
			tmp39_AST = astFactory.create(LT(1));
			astFactory.addASTChild(currentAST, tmp39_AST);
			match(TOK_COMMA);
			type();
			astFactory.addASTChild(currentAST, returnAST);
			AST tmp40_AST = null;
			tmp40_AST = astFactory.create(LT(1));
			astFactory.addASTChild(currentAST, tmp40_AST);
			match(TOK_GT);
			type_AST = (AST)currentAST.root;
			break;
		}
		case Identifier:
		{
			typeIdentifier();
			astFactory.addASTChild(currentAST, returnAST);
			type_AST = (AST)currentAST.root;
			break;
		}
		default:
			if (((LA(1) >= LITERAL_unsigned && LA(1) <= LITERAL_long)) && (_tokenSet_5.member(LA(2)))) {
				{
				if ((LA(1)==LITERAL_unsigned)) {
					AST tmp41_AST = null;
					tmp41_AST = astFactory.create(LT(1));
					astFactory.addASTChild(currentAST, tmp41_AST);
					match(LITERAL_unsigned);
				}
				else if ((LA(1)==LITERAL_short||LA(1)==LITERAL_long)) {
				}
				else {
					throw new NoViableAltException(LT(1), getFilename());
				}
				
				}
				{
				if ((LA(1)==LITERAL_short)) {
					AST tmp42_AST = null;
					tmp42_AST = astFactory.create(LT(1));
					astFactory.addASTChild(currentAST, tmp42_AST);
					match(LITERAL_short);
				}
				else if ((LA(1)==LITERAL_long)) {
					AST tmp43_AST = null;
					tmp43_AST = astFactory.create(LT(1));
					astFactory.addASTChild(currentAST, tmp43_AST);
					match(LITERAL_long);
				}
				else {
					throw new NoViableAltException(LT(1), getFilename());
				}
				
				}
				type_AST = (AST)currentAST.root;
			}
			else if ((LA(1)==LITERAL_long) && (LA(2)==LITERAL_long)) {
				AST tmp44_AST = null;
				tmp44_AST = astFactory.create(LT(1));
				astFactory.addASTChild(currentAST, tmp44_AST);
				match(LITERAL_long);
				AST tmp45_AST = null;
				tmp45_AST = astFactory.create(LT(1));
				astFactory.addASTChild(currentAST, tmp45_AST);
				match(LITERAL_long);
				type_AST = (AST)currentAST.root;
			}
		else {
			throw new NoViableAltException(LT(1), getFilename());
		}
		}
		returnAST = type_AST;
	}
	
	public final void selectExpr() throws RecognitionException, TokenStreamException {
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST selectExpr_AST = null;
		Token  s = null;
		org.makumba.db.sql.oql.QueryAST s_AST = null;
		
		s = LT(1);
		s_AST = (org.makumba.db.sql.oql.QueryAST)astFactory.create(s,"org.makumba.db.sql.oql.QueryAST");
		astFactory.makeASTRoot(currentAST, s_AST);
		match(LITERAL_select);
		s_AST.setSuperQuery(currentQuery); currentQuery=s_AST;
		{
		if ((LA(1)==LITERAL_distinct)) {
			AST tmp46_AST = null;
			tmp46_AST = astFactory.create(LT(1));
			astFactory.addASTChild(currentAST, tmp46_AST);
			match(LITERAL_distinct);
		}
		else if ((_tokenSet_6.member(LA(1)))) {
		}
		else {
			throw new NoViableAltException(LT(1), getFilename());
		}
		
		}
		projectionAttributes();
		astFactory.addASTChild(currentAST, returnAST);
		{
		if ((LA(1)==LITERAL_from)) {
			fromClause();
			astFactory.addASTChild(currentAST, returnAST);
		}
		else if ((_tokenSet_7.member(LA(1)))) {
		}
		else {
			throw new NoViableAltException(LT(1), getFilename());
		}
		
		}
		{
		if ((LA(1)==LITERAL_where)) {
			whereClause();
			astFactory.addASTChild(currentAST, returnAST);
		}
		else if ((_tokenSet_8.member(LA(1)))) {
		}
		else {
			throw new NoViableAltException(LT(1), getFilename());
		}
		
		}
		{
		if ((LA(1)==LITERAL_group)) {
			groupClause();
			astFactory.addASTChild(currentAST, returnAST);
		}
		else if ((_tokenSet_9.member(LA(1)))) {
		}
		else {
			throw new NoViableAltException(LT(1), getFilename());
		}
		
		}
		{
		if ((LA(1)==LITERAL_order)) {
			orderClause();
			astFactory.addASTChild(currentAST, returnAST);
		}
		else if ((_tokenSet_10.member(LA(1)))) {
		}
		else {
			throw new NoViableAltException(LT(1), getFilename());
		}
		
		}
		currentQuery= s_AST.getSuperQuery(); s_AST.prepare();
		selectExpr_AST = (AST)currentAST.root;
		returnAST = selectExpr_AST;
	}
	
	public final void expr() throws RecognitionException, TokenStreamException {
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST expr_AST = null;
		AST or_AST = null;
		
		orExpr();
		or_AST = (AST)returnAST;
		astFactory.addASTChild(currentAST, returnAST);
		currentQuery().addExpression(or_AST);
		expr_AST = (AST)currentAST.root;
		returnAST = expr_AST;
	}
	
	public final void projectionAttributes() throws RecognitionException, TokenStreamException {
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST projectionAttributes_AST = null;
		
		if ((LA(1)==TOK_LPAR)) {
			AST tmp47_AST = null;
			tmp47_AST = astFactory.create(LT(1));
			astFactory.addASTChild(currentAST, tmp47_AST);
			match(TOK_LPAR);
			labelIdentifier();
			astFactory.addASTChild(currentAST, returnAST);
			AST tmp48_AST = null;
			tmp48_AST = astFactory.create(LT(1));
			astFactory.addASTChild(currentAST, tmp48_AST);
			match(TOK_DOT);
			AST tmp49_AST = null;
			tmp49_AST = astFactory.create(LT(1));
			astFactory.addASTChild(currentAST, tmp49_AST);
			match(TOK_STAR);
			AST tmp50_AST = null;
			tmp50_AST = astFactory.create(LT(1));
			astFactory.addASTChild(currentAST, tmp50_AST);
			match(TOK_LRAR);
			projectionAttributes_AST = (AST)currentAST.root;
		}
		else if ((_tokenSet_3.member(LA(1)))) {
			projection();
			astFactory.addASTChild(currentAST, returnAST);
			{
			_loop280:
			do {
				if ((LA(1)==TOK_COMMA)) {
					AST tmp51_AST = null;
					tmp51_AST = astFactory.create(LT(1));
					astFactory.addASTChild(currentAST, tmp51_AST);
					match(TOK_COMMA);
					projection();
					astFactory.addASTChild(currentAST, returnAST);
				}
				else {
					break _loop280;
				}
				
			} while (true);
			}
			projectionAttributes_AST = (AST)currentAST.root;
		}
		else {
			throw new NoViableAltException(LT(1), getFilename());
		}
		
		returnAST = projectionAttributes_AST;
	}
	
	public final void fromClause() throws RecognitionException, TokenStreamException {
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST fromClause_AST = null;
		
		AST tmp52_AST = null;
		tmp52_AST = astFactory.create(LT(1));
		astFactory.addASTChild(currentAST, tmp52_AST);
		match(LITERAL_from);
		iteratorDef();
		astFactory.addASTChild(currentAST, returnAST);
		fromClause_AST = (AST)currentAST.root;
		currentQuery().setFromAST(fromClause_AST);
		{
		_loop269:
		do {
			if ((LA(1)==TOK_COMMA||LA(1)==LITERAL_left)) {
				{
				if ((LA(1)==TOK_COMMA)) {
					AST tmp53_AST = null;
					tmp53_AST = astFactory.create(LT(1));
					astFactory.addASTChild(currentAST, tmp53_AST);
					match(TOK_COMMA);
					wasLeftJoin=false;
				}
				else if ((LA(1)==LITERAL_left)) {
					AST tmp54_AST = null;
					tmp54_AST = astFactory.create(LT(1));
					astFactory.addASTChild(currentAST, tmp54_AST);
					match(LITERAL_left);
					AST tmp55_AST = null;
					tmp55_AST = astFactory.create(LT(1));
					astFactory.addASTChild(currentAST, tmp55_AST);
					match(LITERAL_join);
					wasLeftJoin=true;
				}
				else {
					throw new NoViableAltException(LT(1), getFilename());
				}
				
				}
				iteratorDef();
				astFactory.addASTChild(currentAST, returnAST);
			}
			else {
				break _loop269;
			}
			
		} while (true);
		}
		fromClause_AST = (AST)currentAST.root;
		returnAST = fromClause_AST;
	}
	
	public final void whereClause() throws RecognitionException, TokenStreamException {
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST whereClause_AST = null;
		
		AST tmp56_AST = null;
		tmp56_AST = astFactory.create(LT(1));
		astFactory.addASTChild(currentAST, tmp56_AST);
		match(LITERAL_where);
		expr();
		astFactory.addASTChild(currentAST, returnAST);
		whereClause_AST = (AST)currentAST.root;
		currentQuery().setWhereAST(whereClause_AST);
		whereClause_AST = (AST)currentAST.root;
		returnAST = whereClause_AST;
	}
	
	public final void groupClause() throws RecognitionException, TokenStreamException {
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST groupClause_AST = null;
		Token  h = null;
		AST h_AST = null;
		
		AST tmp57_AST = null;
		tmp57_AST = astFactory.create(LT(1));
		astFactory.addASTChild(currentAST, tmp57_AST);
		match(LITERAL_group);
		AST tmp58_AST = null;
		tmp58_AST = astFactory.create(LT(1));
		astFactory.addASTChild(currentAST, tmp58_AST);
		match(LITERAL_by);
		groupColumn();
		astFactory.addASTChild(currentAST, returnAST);
		{
		_loop286:
		do {
			if ((LA(1)==TOK_COMMA)) {
				AST tmp59_AST = null;
				tmp59_AST = astFactory.create(LT(1));
				astFactory.addASTChild(currentAST, tmp59_AST);
				match(TOK_COMMA);
				groupColumn();
				astFactory.addASTChild(currentAST, returnAST);
			}
			else {
				break _loop286;
			}
			
		} while (true);
		}
		{
		if ((LA(1)==LITERAL_having)) {
			h = LT(1);
			h_AST = astFactory.create(h);
			astFactory.addASTChild(currentAST, h_AST);
			match(LITERAL_having);
			h_AST.setText(" HAVING ");
			expr();
			astFactory.addASTChild(currentAST, returnAST);
		}
		else if ((_tokenSet_9.member(LA(1)))) {
		}
		else {
			throw new NoViableAltException(LT(1), getFilename());
		}
		
		}
		groupClause_AST = (AST)currentAST.root;
		currentQuery().setGroupAST(groupClause_AST);
		groupClause_AST = (AST)currentAST.root;
		returnAST = groupClause_AST;
	}
	
	public final void orderClause() throws RecognitionException, TokenStreamException {
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST orderClause_AST = null;
		
		AST tmp60_AST = null;
		tmp60_AST = astFactory.create(LT(1));
		astFactory.addASTChild(currentAST, tmp60_AST);
		match(LITERAL_order);
		AST tmp61_AST = null;
		tmp61_AST = astFactory.create(LT(1));
		astFactory.addASTChild(currentAST, tmp61_AST);
		match(LITERAL_by);
		sortCriterion();
		astFactory.addASTChild(currentAST, returnAST);
		{
		_loop291:
		do {
			if ((LA(1)==TOK_COMMA)) {
				AST tmp62_AST = null;
				tmp62_AST = astFactory.create(LT(1));
				astFactory.addASTChild(currentAST, tmp62_AST);
				match(TOK_COMMA);
				sortCriterion();
				astFactory.addASTChild(currentAST, returnAST);
			}
			else {
				break _loop291;
			}
			
		} while (true);
		}
		orderClause_AST = (AST)currentAST.root;
		currentQuery().setOrderAST(orderClause_AST);
		orderClause_AST = (AST)currentAST.root;
		returnAST = orderClause_AST;
	}
	
	public final void iteratorDef() throws RecognitionException, TokenStreamException {
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST iteratorDef_AST = null;
		AST lbl_AST = null;
		AST mi_AST = null;
		AST mi1_AST = null;
		AST lbl1_AST = null;
		
		{
		if ((LA(1)==Identifier) && (LA(2)==LITERAL_in)) {
			labelIdentifier();
			lbl_AST = (AST)returnAST;
			astFactory.addASTChild(currentAST, returnAST);
			AST tmp63_AST = null;
			tmp63_AST = astFactory.create(LT(1));
			astFactory.addASTChild(currentAST, tmp63_AST);
			match(LITERAL_in);
			makumbaIdentifier();
			mi_AST = (AST)returnAST;
			astFactory.addASTChild(currentAST, returnAST);
			currentQuery().addFrom(mi_AST.getText(), lbl_AST.getText(), wasLeftJoin);
		}
		else if ((LA(1)==Identifier) && (_tokenSet_11.member(LA(2)))) {
			makumbaIdentifier();
			mi1_AST = (AST)returnAST;
			astFactory.addASTChild(currentAST, returnAST);
			{
			if ((LA(1)==LITERAL_as)) {
				AST tmp64_AST = null;
				tmp64_AST = astFactory.create(LT(1));
				astFactory.addASTChild(currentAST, tmp64_AST);
				match(LITERAL_as);
			}
			else if ((LA(1)==Identifier)) {
			}
			else {
				throw new NoViableAltException(LT(1), getFilename());
			}
			
			}
			labelIdentifier();
			lbl1_AST = (AST)returnAST;
			astFactory.addASTChild(currentAST, returnAST);
			currentQuery().addFrom(mi1_AST.getText(), lbl1_AST.getText(), wasLeftJoin);
		}
		else {
			throw new NoViableAltException(LT(1), getFilename());
		}
		
		}
		iteratorDef_AST = (AST)currentAST.root;
		returnAST = iteratorDef_AST;
	}
	
	public final void makumbaIdentifier() throws RecognitionException, TokenStreamException {
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST makumbaIdentifier_AST = null;
		Token  id = null;
		AST id_AST = null;
		Token  id1 = null;
		AST id1_AST = null;
		
		id = LT(1);
		id_AST = astFactory.create(id);
		match(Identifier);
		String s=id.getText();
		{
		_loop276:
		do {
			if ((LA(1)==TOK_DOT||LA(1)==TOK_INDIRECT)) {
				{
				if ((LA(1)==TOK_DOT)) {
					AST tmp65_AST = null;
					tmp65_AST = astFactory.create(LT(1));
					match(TOK_DOT);
				}
				else if ((LA(1)==TOK_INDIRECT)) {
					AST tmp66_AST = null;
					tmp66_AST = astFactory.create(LT(1));
					match(TOK_INDIRECT);
				}
				else {
					throw new NoViableAltException(LT(1), getFilename());
				}
				
				}
				id1 = LT(1);
				id1_AST = astFactory.create(id1);
				match(Identifier);
				s+="."+id1.getText();
			}
			else {
				break _loop276;
			}
			
		} while (true);
		}
		makumbaIdentifier_AST = (AST)currentAST.root;
		makumbaIdentifier_AST=astFactory.create(Identifier,s);
		currentAST.root = makumbaIdentifier_AST;
		currentAST.child = makumbaIdentifier_AST!=null &&makumbaIdentifier_AST.getFirstChild()!=null ?
			makumbaIdentifier_AST.getFirstChild() : makumbaIdentifier_AST;
		currentAST.advanceChildToEnd();
		returnAST = makumbaIdentifier_AST;
	}
	
	public final void projection() throws RecognitionException, TokenStreamException {
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST projection_AST = null;
		AST e_AST = null;
		Token  a = null;
		AST a_AST = null;
		AST lb_AST = null;
		
		String label="";
		expr();
		e_AST = (AST)returnAST;
		astFactory.addASTChild(currentAST, returnAST);
		{
		if ((LA(1)==Identifier||LA(1)==LITERAL_as) && (_tokenSet_12.member(LA(2)))) {
			{
			if ((LA(1)==LITERAL_as)) {
				a = LT(1);
				a_AST = astFactory.create(a);
				astFactory.addASTChild(currentAST, a_AST);
				match(LITERAL_as);
				a_AST.setText(" AS");
			}
			else if ((LA(1)==Identifier)) {
			}
			else {
				throw new NoViableAltException(LT(1), getFilename());
			}
			
			}
			labelIdentifier();
			lb_AST = (AST)returnAST;
			astFactory.addASTChild(currentAST, returnAST);
			label=lb_AST.getText(); lb_AST.setText(" "+label);
		}
		else if ((_tokenSet_12.member(LA(1))) && (_tokenSet_13.member(LA(2)))) {
		}
		else {
			throw new NoViableAltException(LT(1), getFilename());
		}
		
		}
		projection_AST = (AST)currentAST.root;
		
			  
				currentQuery().addProjection(new Projection(projection_AST, e_AST, label));
			
		projection_AST = (AST)currentAST.root;
		returnAST = projection_AST;
	}
	
	public final void groupColumn() throws RecognitionException, TokenStreamException {
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST groupColumn_AST = null;
		
		expr();
		astFactory.addASTChild(currentAST, returnAST);
		groupColumn_AST = (AST)currentAST.root;
		returnAST = groupColumn_AST;
	}
	
	public final void sortCriterion() throws RecognitionException, TokenStreamException {
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST sortCriterion_AST = null;
		
		expr();
		astFactory.addASTChild(currentAST, returnAST);
		{
		switch ( LA(1)) {
		case LITERAL_asc:
		{
			AST tmp67_AST = null;
			tmp67_AST = astFactory.create(LT(1));
			astFactory.addASTChild(currentAST, tmp67_AST);
			match(LITERAL_asc);
			break;
		}
		case LITERAL_desc:
		{
			AST tmp68_AST = null;
			tmp68_AST = astFactory.create(LT(1));
			astFactory.addASTChild(currentAST, tmp68_AST);
			match(LITERAL_desc);
			break;
		}
		case EOF:
		case TOK_RPAREN:
		case TOK_LPAREN:
		case TOK_COMMA:
		case TOK_SEMIC:
		case TOK_PLUS:
		case TOK_MINUS:
		case TOK_DOLLAR:
		case Identifier:
		case TOK_UNSIGNED_INTEGER:
		case TOK_APPROXIMATE_NUMERIC_LITERAL:
		case TOK_EXACT_NUMERIC_LITERAL:
		case CharLiteral:
		case StringLiteral:
		case LITERAL_import:
		case LITERAL_define:
		case LITERAL_undefine:
		case LITERAL_select:
		case LITERAL_for:
		case LITERAL_exists:
		case LITERAL_abs:
		case LITERAL_not:
		case LITERAL_sum:
		case LITERAL_min:
		case LITERAL_max:
		case LITERAL_avg:
		case LITERAL_count:
		case LITERAL_is_undefined:
		case LITERAL_is_defined:
		case LITERAL_array:
		case LITERAL_set:
		case LITERAL_bag:
		case LITERAL_list:
		case LITERAL_date:
		case LITERAL_time:
		case LITERAL_timestamp:
		case LITERAL_nil:
		case LITERAL_true:
		case LITERAL_false:
		{
			break;
		}
		default:
		{
			throw new NoViableAltException(LT(1), getFilename());
		}
		}
		}
		sortCriterion_AST = (AST)currentAST.root;
		returnAST = sortCriterion_AST;
	}
	
	public final void orExpr() throws RecognitionException, TokenStreamException {
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST orExpr_AST = null;
		AST and_AST = null;
		AST and2_AST = null;
		
		andExpr();
		and_AST = (AST)returnAST;
		astFactory.addASTChild(currentAST, returnAST);
		{
		_loop297:
		do {
			if ((LA(1)==LITERAL_or)) {
				AST tmp69_AST = null;
				tmp69_AST = astFactory.create(LT(1));
				astFactory.addASTChild(currentAST, tmp69_AST);
				match(LITERAL_or);
				andExpr();
				and2_AST = (AST)returnAST;
				astFactory.addASTChild(currentAST, returnAST);
				orExpr_AST = (AST)currentAST.root;
				((OQLAST)orExpr_AST).tree= new AnalysisTree(orExpr_AST, AnalysisTree.OR, and2_AST);
			}
			else {
				break _loop297;
			}
			
		} while (true);
		}
		orExpr_AST = (AST)currentAST.root;
		returnAST = orExpr_AST;
	}
	
	public final void andExpr() throws RecognitionException, TokenStreamException {
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST andExpr_AST = null;
		AST q_AST = null;
		AST q2_AST = null;
		
		quantifierExpr();
		q_AST = (AST)returnAST;
		astFactory.addASTChild(currentAST, returnAST);
		{
		_loop300:
		do {
			if ((LA(1)==LITERAL_and)) {
				AST tmp70_AST = null;
				tmp70_AST = astFactory.create(LT(1));
				astFactory.addASTChild(currentAST, tmp70_AST);
				match(LITERAL_and);
				quantifierExpr();
				q2_AST = (AST)returnAST;
				astFactory.addASTChild(currentAST, returnAST);
				andExpr_AST = (AST)currentAST.root;
				((OQLAST)andExpr_AST).tree= new AnalysisTree(andExpr_AST, AnalysisTree.AND, q2_AST);
			}
			else {
				break _loop300;
			}
			
		} while (true);
		}
		andExpr_AST = (AST)currentAST.root;
		returnAST = andExpr_AST;
	}
	
	public final void quantifierExpr() throws RecognitionException, TokenStreamException {
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST quantifierExpr_AST = null;
		AST eq_AST = null;
		
		{
		switch ( LA(1)) {
		case TOK_LPAREN:
		case TOK_PLUS:
		case TOK_MINUS:
		case TOK_DOLLAR:
		case Identifier:
		case TOK_UNSIGNED_INTEGER:
		case TOK_APPROXIMATE_NUMERIC_LITERAL:
		case TOK_EXACT_NUMERIC_LITERAL:
		case CharLiteral:
		case StringLiteral:
		case LITERAL_abs:
		case LITERAL_not:
		case LITERAL_sum:
		case LITERAL_min:
		case LITERAL_max:
		case LITERAL_avg:
		case LITERAL_count:
		case LITERAL_is_undefined:
		case LITERAL_is_defined:
		case LITERAL_array:
		case LITERAL_set:
		case LITERAL_bag:
		case LITERAL_list:
		case LITERAL_date:
		case LITERAL_time:
		case LITERAL_timestamp:
		case LITERAL_nil:
		case LITERAL_true:
		case LITERAL_false:
		{
			equalityExpr();
			eq_AST = (AST)returnAST;
			astFactory.addASTChild(currentAST, returnAST);
			break;
		}
		case LITERAL_for:
		{
			AST tmp71_AST = null;
			tmp71_AST = astFactory.create(LT(1));
			astFactory.addASTChild(currentAST, tmp71_AST);
			match(LITERAL_for);
			AST tmp72_AST = null;
			tmp72_AST = astFactory.create(LT(1));
			astFactory.addASTChild(currentAST, tmp72_AST);
			match(LITERAL_all);
			labelIdentifier();
			astFactory.addASTChild(currentAST, returnAST);
			AST tmp73_AST = null;
			tmp73_AST = astFactory.create(LT(1));
			astFactory.addASTChild(currentAST, tmp73_AST);
			match(LITERAL_in);
			expr();
			astFactory.addASTChild(currentAST, returnAST);
			AST tmp74_AST = null;
			tmp74_AST = astFactory.create(LT(1));
			astFactory.addASTChild(currentAST, tmp74_AST);
			match(TOK_COLON);
			equalityExpr();
			astFactory.addASTChild(currentAST, returnAST);
			break;
		}
		case LITERAL_exists:
		{
			AST tmp75_AST = null;
			tmp75_AST = astFactory.create(LT(1));
			astFactory.addASTChild(currentAST, tmp75_AST);
			match(LITERAL_exists);
			labelIdentifier();
			astFactory.addASTChild(currentAST, returnAST);
			AST tmp76_AST = null;
			tmp76_AST = astFactory.create(LT(1));
			astFactory.addASTChild(currentAST, tmp76_AST);
			match(LITERAL_in);
			expr();
			astFactory.addASTChild(currentAST, returnAST);
			AST tmp77_AST = null;
			tmp77_AST = astFactory.create(LT(1));
			astFactory.addASTChild(currentAST, tmp77_AST);
			match(TOK_COLON);
			equalityExpr();
			astFactory.addASTChild(currentAST, returnAST);
			break;
		}
		default:
		{
			throw new NoViableAltException(LT(1), getFilename());
		}
		}
		}
		quantifierExpr_AST = (AST)currentAST.root;
		returnAST = quantifierExpr_AST;
	}
	
	public final void equalityExpr() throws RecognitionException, TokenStreamException {
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST equalityExpr_AST = null;
		AST rel_AST = null;
		Token  eq = null;
		AST eq_AST = null;
		Token  neq = null;
		AST neq_AST = null;
		AST rel2_AST = null;
		AST rel3_AST = null;
		
		relationalExpr();
		rel_AST = (AST)returnAST;
		astFactory.addASTChild(currentAST, returnAST);
		{
		_loop308:
		do {
			if ((LA(1)==TOK_EQ||LA(1)==TOK_NE)) {
				{
				if ((LA(1)==TOK_EQ)) {
					eq = LT(1);
					eq_AST = astFactory.create(eq);
					astFactory.addASTChild(currentAST, eq_AST);
					match(TOK_EQ);
					lastEQop= eq_AST; is=" is ";
				}
				else if ((LA(1)==TOK_NE)) {
					neq = LT(1);
					neq_AST = astFactory.create(neq);
					astFactory.addASTChild(currentAST, neq_AST);
					match(TOK_NE);
					lastEQop= neq_AST;is=" is not ";
				}
				else {
					throw new NoViableAltException(LT(1), getFilename());
				}
				
				}
				{
				if ((_tokenSet_14.member(LA(1)))) {
					relationalExpr();
					rel2_AST = (AST)returnAST;
					astFactory.addASTChild(currentAST, returnAST);
					equalityExpr_AST = (AST)currentAST.root;
					((OQLAST)equalityExpr_AST).tree= new ComparisonTree(equalityExpr_AST, AnalysisTree.SIM_COMP, rel2_AST);
				}
				else if ((LA(1)==LITERAL_all||LA(1)==LITERAL_any||LA(1)==LITERAL_some)) {
					{
					switch ( LA(1)) {
					case LITERAL_all:
					{
						AST tmp78_AST = null;
						tmp78_AST = astFactory.create(LT(1));
						astFactory.addASTChild(currentAST, tmp78_AST);
						match(LITERAL_all);
						break;
					}
					case LITERAL_any:
					{
						AST tmp79_AST = null;
						tmp79_AST = astFactory.create(LT(1));
						astFactory.addASTChild(currentAST, tmp79_AST);
						match(LITERAL_any);
						break;
					}
					case LITERAL_some:
					{
						AST tmp80_AST = null;
						tmp80_AST = astFactory.create(LT(1));
						astFactory.addASTChild(currentAST, tmp80_AST);
						match(LITERAL_some);
						break;
					}
					default:
					{
						throw new NoViableAltException(LT(1), getFilename());
					}
					}
					}
					relationalExpr();
					astFactory.addASTChild(currentAST, returnAST);
				}
				else {
					throw new NoViableAltException(LT(1), getFilename());
				}
				
				}
			}
			else if ((LA(1)==LITERAL_like)) {
				AST tmp81_AST = null;
				tmp81_AST = astFactory.create(LT(1));
				astFactory.addASTChild(currentAST, tmp81_AST);
				match(LITERAL_like);
				relationalExpr();
				rel3_AST = (AST)returnAST;
				astFactory.addASTChild(currentAST, returnAST);
				equalityExpr_AST = (AST)currentAST.root;
				((OQLAST)equalityExpr_AST).tree= new LikeTree(equalityExpr_AST, AnalysisTree.LIKE, rel3_AST);
			}
			else {
				break _loop308;
			}
			
		} while (true);
		}
		equalityExpr_AST = (AST)currentAST.root;
		returnAST = equalityExpr_AST;
	}
	
	public final void relationalExpr() throws RecognitionException, TokenStreamException {
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST relationalExpr_AST = null;
		AST add_AST = null;
		AST add2_AST = null;
		
		additiveExpr();
		add_AST = (AST)returnAST;
		astFactory.addASTChild(currentAST, returnAST);
		{
		_loop314:
		do {
			if ((_tokenSet_15.member(LA(1)))) {
				{
				switch ( LA(1)) {
				case TOK_LT:
				{
					AST tmp82_AST = null;
					tmp82_AST = astFactory.create(LT(1));
					astFactory.addASTChild(currentAST, tmp82_AST);
					match(TOK_LT);
					break;
				}
				case TOK_GT:
				{
					AST tmp83_AST = null;
					tmp83_AST = astFactory.create(LT(1));
					astFactory.addASTChild(currentAST, tmp83_AST);
					match(TOK_GT);
					break;
				}
				case TOK_LE:
				{
					AST tmp84_AST = null;
					tmp84_AST = astFactory.create(LT(1));
					astFactory.addASTChild(currentAST, tmp84_AST);
					match(TOK_LE);
					break;
				}
				case TOK_GE:
				{
					AST tmp85_AST = null;
					tmp85_AST = astFactory.create(LT(1));
					astFactory.addASTChild(currentAST, tmp85_AST);
					match(TOK_GE);
					break;
				}
				default:
				{
					throw new NoViableAltException(LT(1), getFilename());
				}
				}
				}
				{
				if ((_tokenSet_14.member(LA(1)))) {
					additiveExpr();
					add2_AST = (AST)returnAST;
					astFactory.addASTChild(currentAST, returnAST);
					relationalExpr_AST = (AST)currentAST.root;
					((OQLAST)relationalExpr_AST).tree= new ComparisonTree(relationalExpr_AST, AnalysisTree.ASIM_COMP, add2_AST);
				}
				else if ((LA(1)==LITERAL_all||LA(1)==LITERAL_any||LA(1)==LITERAL_some)) {
					{
					switch ( LA(1)) {
					case LITERAL_all:
					{
						AST tmp86_AST = null;
						tmp86_AST = astFactory.create(LT(1));
						astFactory.addASTChild(currentAST, tmp86_AST);
						match(LITERAL_all);
						break;
					}
					case LITERAL_any:
					{
						AST tmp87_AST = null;
						tmp87_AST = astFactory.create(LT(1));
						astFactory.addASTChild(currentAST, tmp87_AST);
						match(LITERAL_any);
						break;
					}
					case LITERAL_some:
					{
						AST tmp88_AST = null;
						tmp88_AST = astFactory.create(LT(1));
						astFactory.addASTChild(currentAST, tmp88_AST);
						match(LITERAL_some);
						break;
					}
					default:
					{
						throw new NoViableAltException(LT(1), getFilename());
					}
					}
					}
					additiveExpr();
					astFactory.addASTChild(currentAST, returnAST);
				}
				else {
					throw new NoViableAltException(LT(1), getFilename());
				}
				
				}
			}
			else {
				break _loop314;
			}
			
		} while (true);
		}
		relationalExpr_AST = (AST)currentAST.root;
		returnAST = relationalExpr_AST;
	}
	
	public final void additiveExpr() throws RecognitionException, TokenStreamException {
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST additiveExpr_AST = null;
		AST mul_AST = null;
		AST mul2_AST = null;
		
		multiplicativeExpr();
		mul_AST = (AST)returnAST;
		astFactory.addASTChild(currentAST, returnAST);
		{
		_loop318:
		do {
			if ((_tokenSet_16.member(LA(1))) && (_tokenSet_14.member(LA(2)))) {
				{
				switch ( LA(1)) {
				case TOK_PLUS:
				{
					AST tmp89_AST = null;
					tmp89_AST = astFactory.create(LT(1));
					astFactory.addASTChild(currentAST, tmp89_AST);
					match(TOK_PLUS);
					lastAdditive= AnalysisTree.ADD;
					break;
				}
				case TOK_MINUS:
				{
					AST tmp90_AST = null;
					tmp90_AST = astFactory.create(LT(1));
					astFactory.addASTChild(currentAST, tmp90_AST);
					match(TOK_MINUS);
					lastAdditive= AnalysisTree.ADD;
					break;
				}
				case TOK_CONCAT:
				{
					AST tmp91_AST = null;
					tmp91_AST = astFactory.create(LT(1));
					astFactory.addASTChild(currentAST, tmp91_AST);
					match(TOK_CONCAT);
					lastAdditive= AnalysisTree.CONCAT;
					break;
				}
				case LITERAL_union:
				{
					AST tmp92_AST = null;
					tmp92_AST = astFactory.create(LT(1));
					astFactory.addASTChild(currentAST, tmp92_AST);
					match(LITERAL_union);
					lastAdditive= AnalysisTree.UNION;
					break;
				}
				case LITERAL_except:
				{
					AST tmp93_AST = null;
					tmp93_AST = astFactory.create(LT(1));
					astFactory.addASTChild(currentAST, tmp93_AST);
					match(LITERAL_except);
					lastAdditive= AnalysisTree.EXCEPT;
					break;
				}
				default:
				{
					throw new NoViableAltException(LT(1), getFilename());
				}
				}
				}
				multiplicativeExpr();
				mul2_AST = (AST)returnAST;
				astFactory.addASTChild(currentAST, returnAST);
				additiveExpr_AST = (AST)currentAST.root;
				if(additiveExpr_AST!=null)((OQLAST)additiveExpr_AST).tree= new AdditiveTree(additiveExpr_AST, lastAdditive, mul2_AST);
			}
			else {
				break _loop318;
			}
			
		} while (true);
		}
		additiveExpr_AST = (AST)currentAST.root;
		returnAST = additiveExpr_AST;
	}
	
	public final void multiplicativeExpr() throws RecognitionException, TokenStreamException {
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST multiplicativeExpr_AST = null;
		AST in_AST = null;
		AST in2_AST = null;
		
		inExpr();
		in_AST = (AST)returnAST;
		astFactory.addASTChild(currentAST, returnAST);
		{
		_loop322:
		do {
			if ((_tokenSet_17.member(LA(1)))) {
				{
				switch ( LA(1)) {
				case TOK_STAR:
				{
					AST tmp94_AST = null;
					tmp94_AST = astFactory.create(LT(1));
					astFactory.addASTChild(currentAST, tmp94_AST);
					match(TOK_STAR);
					lastMultiplicative= AnalysisTree.MUL;
					break;
				}
				case TOK_SLASH:
				{
					AST tmp95_AST = null;
					tmp95_AST = astFactory.create(LT(1));
					astFactory.addASTChild(currentAST, tmp95_AST);
					match(TOK_SLASH);
					lastMultiplicative= AnalysisTree.MUL;
					break;
				}
				case LITERAL_mod:
				{
					AST tmp96_AST = null;
					tmp96_AST = astFactory.create(LT(1));
					astFactory.addASTChild(currentAST, tmp96_AST);
					match(LITERAL_mod);
					lastMultiplicative= AnalysisTree.MUL;
					break;
				}
				case LITERAL_intersect:
				{
					AST tmp97_AST = null;
					tmp97_AST = astFactory.create(LT(1));
					astFactory.addASTChild(currentAST, tmp97_AST);
					match(LITERAL_intersect);
					lastMultiplicative= AnalysisTree.INTERSECT;
					break;
				}
				default:
				{
					throw new NoViableAltException(LT(1), getFilename());
				}
				}
				}
				inExpr();
				in2_AST = (AST)returnAST;
				astFactory.addASTChild(currentAST, returnAST);
				multiplicativeExpr_AST = (AST)currentAST.root;
				if(multiplicativeExpr_AST!=null)((OQLAST)multiplicativeExpr_AST).tree= new AnalysisTree(multiplicativeExpr_AST, lastMultiplicative, in2_AST);
			}
			else {
				break _loop322;
			}
			
		} while (true);
		}
		multiplicativeExpr_AST = (AST)currentAST.root;
		returnAST = multiplicativeExpr_AST;
	}
	
	public final void inExpr() throws RecognitionException, TokenStreamException {
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST inExpr_AST = null;
		AST un_AST = null;
		AST un2_AST = null;
		
		unaryExpr();
		un_AST = (AST)returnAST;
		astFactory.addASTChild(currentAST, returnAST);
		{
		if ((LA(1)==LITERAL_in)) {
			AST tmp98_AST = null;
			tmp98_AST = astFactory.create(LT(1));
			astFactory.addASTChild(currentAST, tmp98_AST);
			match(LITERAL_in);
			unaryExpr();
			un2_AST = (AST)returnAST;
			astFactory.addASTChild(currentAST, returnAST);
			inExpr_AST = (AST)currentAST.root;
			if(inExpr_AST!=null)((OQLAST)inExpr_AST).tree= new InTree(inExpr_AST, un2_AST);
		}
		else if ((_tokenSet_18.member(LA(1)))) {
		}
		else {
			throw new NoViableAltException(LT(1), getFilename());
		}
		
		}
		inExpr_AST = (AST)currentAST.root;
		returnAST = inExpr_AST;
	}
	
	public final void unaryExpr() throws RecognitionException, TokenStreamException {
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST unaryExpr_AST = null;
		AST po_AST = null;
		
		{
		_loop328:
		do {
			if ((_tokenSet_19.member(LA(1)))) {
				{
				switch ( LA(1)) {
				case TOK_PLUS:
				{
					AST tmp99_AST = null;
					tmp99_AST = astFactory.create(LT(1));
					astFactory.addASTChild(currentAST, tmp99_AST);
					match(TOK_PLUS);
					break;
				}
				case TOK_MINUS:
				{
					AST tmp100_AST = null;
					tmp100_AST = astFactory.create(LT(1));
					astFactory.addASTChild(currentAST, tmp100_AST);
					match(TOK_MINUS);
					break;
				}
				case LITERAL_abs:
				{
					AST tmp101_AST = null;
					tmp101_AST = astFactory.create(LT(1));
					astFactory.addASTChild(currentAST, tmp101_AST);
					match(LITERAL_abs);
					break;
				}
				case LITERAL_not:
				{
					AST tmp102_AST = null;
					tmp102_AST = astFactory.create(LT(1));
					astFactory.addASTChild(currentAST, tmp102_AST);
					match(LITERAL_not);
					break;
				}
				default:
				{
					throw new NoViableAltException(LT(1), getFilename());
				}
				}
				}
			}
			else {
				break _loop328;
			}
			
		} while (true);
		}
		postfixExpr();
		po_AST = (AST)returnAST;
		astFactory.addASTChild(currentAST, returnAST);
		unaryExpr_AST = (AST)currentAST.root;
		
			  // the type of the unary expression is the same as the type of the postfix expression, so analysis is the same
			  AnalysisTree at= ((OQLAST)po_AST).tree;
			  if(at!=null)
				((OQLAST)unaryExpr_AST).tree= at;
			  else
				((OQLAST)unaryExpr_AST).tree= new AnalysisTree((OQLAST)po_AST);
			
		unaryExpr_AST = (AST)currentAST.root;
		returnAST = unaryExpr_AST;
	}
	
	public final void postfixExpr() throws RecognitionException, TokenStreamException {
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST postfixExpr_AST = null;
		AST pr_AST = null;
		
		primaryExpr();
		pr_AST = (AST)returnAST;
		astFactory.addASTChild(currentAST, returnAST);
		postfixExpr_AST = (AST)currentAST.root;
		returnAST = postfixExpr_AST;
	}
	
	public final void primaryExpr() throws RecognitionException, TokenStreamException {
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST primaryExpr_AST = null;
		AST a_AST = null;
		AST mi_AST = null;
		Token  n = null;
		AST n_AST = null;
		AST lit_AST = null;
		AST q_AST = null;
		
		{
		switch ( LA(1)) {
		case LITERAL_is_undefined:
		case LITERAL_is_defined:
		{
			undefinedExpr();
			astFactory.addASTChild(currentAST, returnAST);
			break;
		}
		case LITERAL_array:
		case LITERAL_set:
		case LITERAL_bag:
		case LITERAL_list:
		{
			collectionConstruction();
			astFactory.addASTChild(currentAST, returnAST);
			primaryExpr_AST = (AST)currentAST.root;
			((OQLAST)primaryExpr_AST).makumbaType="inSet";
			break;
		}
		case LITERAL_sum:
		case LITERAL_min:
		case LITERAL_max:
		case LITERAL_avg:
		case LITERAL_count:
		{
			aggregateExpr();
			a_AST = (AST)returnAST;
			astFactory.addASTChild(currentAST, returnAST);
			break;
		}
		case Identifier:
		{
			makumbaIdentifier();
			mi_AST = (AST)returnAST;
			primaryExpr_AST = (AST)currentAST.root;
			
					primaryExpr_AST=new IdAST();
					primaryExpr_AST.setText((mi_AST).getText()); 
					currentQuery().addExpressionIdentifier(primaryExpr_AST);
				
			currentAST.root = primaryExpr_AST;
			currentAST.child = primaryExpr_AST!=null &&primaryExpr_AST.getFirstChild()!=null ?
				primaryExpr_AST.getFirstChild() : primaryExpr_AST;
			currentAST.advanceChildToEnd();
			break;
		}
		case TOK_DOLLAR:
		{
			AST tmp103_AST = null;
			tmp103_AST = astFactory.create(LT(1));
			match(TOK_DOLLAR);
			n = LT(1);
			n_AST = astFactory.create(n);
			match(TOK_UNSIGNED_INTEGER);
			primaryExpr_AST = (AST)currentAST.root;
			
					ParamAST p= new ParamAST();
					primaryExpr_AST= p;
					p.number= Integer.parseInt((n_AST).getText());  
					currentQuery().addParameter(p);
				
			currentAST.root = primaryExpr_AST;
			currentAST.child = primaryExpr_AST!=null &&primaryExpr_AST.getFirstChild()!=null ?
				primaryExpr_AST.getFirstChild() : primaryExpr_AST;
			currentAST.advanceChildToEnd();
			break;
		}
		case TOK_UNSIGNED_INTEGER:
		case TOK_APPROXIMATE_NUMERIC_LITERAL:
		case TOK_EXACT_NUMERIC_LITERAL:
		case CharLiteral:
		case StringLiteral:
		case LITERAL_date:
		case LITERAL_time:
		case LITERAL_timestamp:
		case LITERAL_nil:
		case LITERAL_true:
		case LITERAL_false:
		{
			literal();
			lit_AST = (AST)returnAST;
			astFactory.addASTChild(currentAST, returnAST);
			break;
		}
		case TOK_LPAREN:
		{
			AST tmp104_AST = null;
			tmp104_AST = astFactory.create(LT(1));
			astFactory.addASTChild(currentAST, tmp104_AST);
			match(TOK_LPAREN);
			query();
			q_AST = (AST)returnAST;
			astFactory.addASTChild(currentAST, returnAST);
			AST tmp105_AST = null;
			tmp105_AST = astFactory.create(LT(1));
			astFactory.addASTChild(currentAST, tmp105_AST);
			match(TOK_RPAREN);
			primaryExpr_AST = (AST)currentAST.root;
			
					OQLAST q= (OQLAST)q_AST;	
					OQLAST p= (OQLAST)primaryExpr_AST;
				 	if(q.tree==null)
					  p.tree=new AnalysisTree(q);
					else
				          p.tree= q.tree;
				
			break;
		}
		default:
		{
			throw new NoViableAltException(LT(1), getFilename());
		}
		}
		}
		primaryExpr_AST = (AST)currentAST.root;
		returnAST = primaryExpr_AST;
	}
	
	public final void index() throws RecognitionException, TokenStreamException {
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST index_AST = null;
		
		expr();
		astFactory.addASTChild(currentAST, returnAST);
		{
		switch ( LA(1)) {
		case TOK_COMMA:
		{
			{
			int _cnt333=0;
			_loop333:
			do {
				if ((LA(1)==TOK_COMMA)) {
					AST tmp106_AST = null;
					tmp106_AST = astFactory.create(LT(1));
					astFactory.addASTChild(currentAST, tmp106_AST);
					match(TOK_COMMA);
					expr();
					astFactory.addASTChild(currentAST, returnAST);
				}
				else {
					if ( _cnt333>=1 ) { break _loop333; } else {throw new NoViableAltException(LT(1), getFilename());}
				}
				
				_cnt333++;
			} while (true);
			}
			break;
		}
		case TOK_COLON:
		{
			AST tmp107_AST = null;
			tmp107_AST = astFactory.create(LT(1));
			astFactory.addASTChild(currentAST, tmp107_AST);
			match(TOK_COLON);
			expr();
			astFactory.addASTChild(currentAST, returnAST);
			break;
		}
		case EOF:
		{
			break;
		}
		default:
		{
			throw new NoViableAltException(LT(1), getFilename());
		}
		}
		}
		index_AST = (AST)currentAST.root;
		returnAST = index_AST;
	}
	
	public final void undefinedExpr() throws RecognitionException, TokenStreamException {
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST undefinedExpr_AST = null;
		Token  undef = null;
		AST undef_AST = null;
		Token  def = null;
		AST def_AST = null;
		Token  rp = null;
		AST rp_AST = null;
		
		String s;
		{
		if ((LA(1)==LITERAL_is_undefined)) {
			undef = LT(1);
			undef_AST = astFactory.create(undef);
			match(LITERAL_is_undefined);
			s=" is null";
		}
		else if ((LA(1)==LITERAL_is_defined)) {
			def = LT(1);
			def_AST = astFactory.create(def);
			match(LITERAL_is_defined);
			s=" is not null";
		}
		else {
			throw new NoViableAltException(LT(1), getFilename());
		}
		
		}
		AST tmp108_AST = null;
		tmp108_AST = astFactory.create(LT(1));
		astFactory.addASTChild(currentAST, tmp108_AST);
		match(TOK_LPAREN);
		query();
		astFactory.addASTChild(currentAST, returnAST);
		rp = LT(1);
		rp_AST = astFactory.create(rp);
		astFactory.addASTChild(currentAST, rp_AST);
		match(TOK_RPAREN);
		rp_AST.setText(") "+s);
		undefinedExpr_AST = (AST)currentAST.root;
		returnAST = undefinedExpr_AST;
	}
	
	public final void collectionConstruction() throws RecognitionException, TokenStreamException {
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST collectionConstruction_AST = null;
		
		{
		if (((LA(1) >= LITERAL_array && LA(1) <= LITERAL_bag))) {
			{
			switch ( LA(1)) {
			case LITERAL_array:
			{
				AST tmp109_AST = null;
				tmp109_AST = astFactory.create(LT(1));
				astFactory.addASTChild(currentAST, tmp109_AST);
				match(LITERAL_array);
				break;
			}
			case LITERAL_set:
			{
				AST tmp110_AST = null;
				tmp110_AST = astFactory.create(LT(1));
				astFactory.addASTChild(currentAST, tmp110_AST);
				match(LITERAL_set);
				break;
			}
			case LITERAL_bag:
			{
				AST tmp111_AST = null;
				tmp111_AST = astFactory.create(LT(1));
				astFactory.addASTChild(currentAST, tmp111_AST);
				match(LITERAL_bag);
				break;
			}
			default:
			{
				throw new NoViableAltException(LT(1), getFilename());
			}
			}
			}
			AST tmp112_AST = null;
			tmp112_AST = astFactory.create(LT(1));
			astFactory.addASTChild(currentAST, tmp112_AST);
			match(TOK_LPAREN);
			{
			if ((_tokenSet_3.member(LA(1)))) {
				expr();
				astFactory.addASTChild(currentAST, returnAST);
				{
				_loop360:
				do {
					if ((LA(1)==TOK_COMMA)) {
						AST tmp113_AST = null;
						tmp113_AST = astFactory.create(LT(1));
						astFactory.addASTChild(currentAST, tmp113_AST);
						match(TOK_COMMA);
						expr();
						astFactory.addASTChild(currentAST, returnAST);
					}
					else {
						break _loop360;
					}
					
				} while (true);
				}
			}
			else if ((LA(1)==TOK_RPAREN)) {
			}
			else {
				throw new NoViableAltException(LT(1), getFilename());
			}
			
			}
			AST tmp114_AST = null;
			tmp114_AST = astFactory.create(LT(1));
			astFactory.addASTChild(currentAST, tmp114_AST);
			match(TOK_RPAREN);
		}
		else if ((LA(1)==LITERAL_list)) {
			AST tmp115_AST = null;
			tmp115_AST = astFactory.create(LT(1));
			astFactory.addASTChild(currentAST, tmp115_AST);
			match(LITERAL_list);
			AST tmp116_AST = null;
			tmp116_AST = astFactory.create(LT(1));
			astFactory.addASTChild(currentAST, tmp116_AST);
			match(TOK_LPAREN);
			{
			if ((_tokenSet_3.member(LA(1)))) {
				expr();
				astFactory.addASTChild(currentAST, returnAST);
				{
				if ((LA(1)==TOK_DOTDOT)) {
					AST tmp117_AST = null;
					tmp117_AST = astFactory.create(LT(1));
					astFactory.addASTChild(currentAST, tmp117_AST);
					match(TOK_DOTDOT);
					expr();
					astFactory.addASTChild(currentAST, returnAST);
				}
				else if ((LA(1)==TOK_RPAREN||LA(1)==TOK_COMMA)) {
					{
					_loop364:
					do {
						if ((LA(1)==TOK_COMMA)) {
							AST tmp118_AST = null;
							tmp118_AST = astFactory.create(LT(1));
							astFactory.addASTChild(currentAST, tmp118_AST);
							match(TOK_COMMA);
							expr();
							astFactory.addASTChild(currentAST, returnAST);
						}
						else {
							break _loop364;
						}
						
					} while (true);
					}
				}
				else {
					throw new NoViableAltException(LT(1), getFilename());
				}
				
				}
			}
			else if ((LA(1)==TOK_RPAREN)) {
			}
			else {
				throw new NoViableAltException(LT(1), getFilename());
			}
			
			}
			AST tmp119_AST = null;
			tmp119_AST = astFactory.create(LT(1));
			astFactory.addASTChild(currentAST, tmp119_AST);
			match(TOK_RPAREN);
		}
		else {
			throw new NoViableAltException(LT(1), getFilename());
		}
		
		}
		collectionConstruction_AST = (AST)currentAST.root;
		returnAST = collectionConstruction_AST;
	}
	
	public final void aggregateExpr() throws RecognitionException, TokenStreamException {
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST aggregateExpr_AST = null;
		Token  s = null;
		AST s_AST = null;
		Token  mn = null;
		AST mn_AST = null;
		Token  mx = null;
		AST mx_AST = null;
		Token  av = null;
		AST av_AST = null;
		Token  l = null;
		AST l_AST = null;
		AST q_AST = null;
		Token  c = null;
		AST c_AST = null;
		Token  lp = null;
		AST lp_AST = null;
		
		{
		if (((LA(1) >= LITERAL_sum && LA(1) <= LITERAL_avg))) {
			{
			switch ( LA(1)) {
			case LITERAL_sum:
			{
				s = LT(1);
				s_AST = astFactory.create(s);
				astFactory.addASTChild(currentAST, s_AST);
				match(LITERAL_sum);
				s_AST.setText("sum(");
				break;
			}
			case LITERAL_min:
			{
				mn = LT(1);
				mn_AST = astFactory.create(mn);
				astFactory.addASTChild(currentAST, mn_AST);
				match(LITERAL_min);
				mn_AST.setText("min(");
				break;
			}
			case LITERAL_max:
			{
				mx = LT(1);
				mx_AST = astFactory.create(mx);
				astFactory.addASTChild(currentAST, mx_AST);
				match(LITERAL_max);
				mx_AST.setText("max(");
				break;
			}
			case LITERAL_avg:
			{
				av = LT(1);
				av_AST = astFactory.create(av);
				astFactory.addASTChild(currentAST, av_AST);
				match(LITERAL_avg);
				av_AST.setText("avg(0.0+");
				break;
			}
			default:
			{
				throw new NoViableAltException(LT(1), getFilename());
			}
			}
			}
			l = LT(1);
			l_AST = astFactory.create(l);
			astFactory.addASTChild(currentAST, l_AST);
			match(TOK_LPAREN);
			l_AST.setText("");
			query();
			q_AST = (AST)returnAST;
			astFactory.addASTChild(currentAST, returnAST);
			AST tmp120_AST = null;
			tmp120_AST = astFactory.create(LT(1));
			astFactory.addASTChild(currentAST, tmp120_AST);
			match(TOK_RPAREN);
			aggregateExpr_AST = (AST)currentAST.root;
			
			AggregateAST ag= new AggregateAST();
			ag.setText(aggregateExpr_AST.getText());
					ag.setExpr((OQLAST)q_AST);
			aggregateExpr_AST=ag;
				
			currentAST.root = aggregateExpr_AST;
			currentAST.child = aggregateExpr_AST!=null &&aggregateExpr_AST.getFirstChild()!=null ?
				aggregateExpr_AST.getFirstChild() : aggregateExpr_AST;
			currentAST.advanceChildToEnd();
		}
		else if ((LA(1)==LITERAL_count)) {
			c = LT(1);
			c_AST = astFactory.create(c);
			astFactory.addASTChild(currentAST, c_AST);
			match(LITERAL_count);
			c_AST.setText("count(");
			lp = LT(1);
			lp_AST = astFactory.create(lp);
			astFactory.addASTChild(currentAST, lp_AST);
			match(TOK_LPAREN);
			lp_AST.setText("");
			{
			if ((_tokenSet_1.member(LA(1)))) {
				query();
				astFactory.addASTChild(currentAST, returnAST);
			}
			else if ((LA(1)==TOK_STAR)) {
				AST tmp121_AST = null;
				tmp121_AST = astFactory.create(LT(1));
				astFactory.addASTChild(currentAST, tmp121_AST);
				match(TOK_STAR);
			}
			else {
				throw new NoViableAltException(LT(1), getFilename());
			}
			
			}
			AST tmp122_AST = null;
			tmp122_AST = astFactory.create(LT(1));
			astFactory.addASTChild(currentAST, tmp122_AST);
			match(TOK_RPAREN);
			aggregateExpr_AST = (AST)currentAST.root;
			((OQLAST)aggregateExpr_AST).makumbaType="int";
		}
		else {
			throw new NoViableAltException(LT(1), getFilename());
		}
		
		}
		aggregateExpr_AST = (AST)currentAST.root;
		returnAST = aggregateExpr_AST;
	}
	
	public final void literal() throws RecognitionException, TokenStreamException {
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST literal_AST = null;
		
		switch ( LA(1)) {
		case LITERAL_nil:
		{
			objectLiteral();
			astFactory.addASTChild(currentAST, returnAST);
			literal_AST = (AST)currentAST.root;
			break;
		}
		case LITERAL_true:
		case LITERAL_false:
		{
			booleanLiteral();
			astFactory.addASTChild(currentAST, returnAST);
			literal_AST = (AST)currentAST.root;
			((OQLAST)literal_AST).makumbaType="int";
			literal_AST = (AST)currentAST.root;
			break;
		}
		case TOK_UNSIGNED_INTEGER:
		{
			longLiteral();
			astFactory.addASTChild(currentAST, returnAST);
			literal_AST = (AST)currentAST.root;
			((OQLAST)literal_AST).makumbaType="int";
			literal_AST = (AST)currentAST.root;
			break;
		}
		case TOK_APPROXIMATE_NUMERIC_LITERAL:
		case TOK_EXACT_NUMERIC_LITERAL:
		{
			doubleLiteral();
			astFactory.addASTChild(currentAST, returnAST);
			literal_AST = (AST)currentAST.root;
			((OQLAST)literal_AST).makumbaType="real";
			literal_AST = (AST)currentAST.root;
			break;
		}
		case CharLiteral:
		{
			charLiteral();
			astFactory.addASTChild(currentAST, returnAST);
			literal_AST = (AST)currentAST.root;
			((OQLAST)literal_AST).makumbaType="char";
			literal_AST = (AST)currentAST.root;
			break;
		}
		case StringLiteral:
		{
			stringLiteral();
			astFactory.addASTChild(currentAST, returnAST);
			literal_AST = (AST)currentAST.root;
			((OQLAST)literal_AST).makumbaType="char";
			literal_AST = (AST)currentAST.root;
			break;
		}
		case LITERAL_date:
		{
			dateLiteral();
			astFactory.addASTChild(currentAST, returnAST);
			literal_AST = (AST)currentAST.root;
			((OQLAST)literal_AST).makumbaType="datetime";
			literal_AST = (AST)currentAST.root;
			break;
		}
		case LITERAL_time:
		{
			timeLiteral();
			astFactory.addASTChild(currentAST, returnAST);
			literal_AST = (AST)currentAST.root;
			((OQLAST)literal_AST).makumbaType="datetime";
			literal_AST = (AST)currentAST.root;
			break;
		}
		case LITERAL_timestamp:
		{
			timestampLiteral();
			astFactory.addASTChild(currentAST, returnAST);
			literal_AST = (AST)currentAST.root;
			((OQLAST)literal_AST).makumbaType="timestamp";
			literal_AST = (AST)currentAST.root;
			break;
		}
		default:
		{
			throw new NoViableAltException(LT(1), getFilename());
		}
		}
		returnAST = literal_AST;
	}
	
	public final void argList() throws RecognitionException, TokenStreamException {
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST argList_AST = null;
		
		AST tmp123_AST = null;
		tmp123_AST = astFactory.create(LT(1));
		astFactory.addASTChild(currentAST, tmp123_AST);
		match(TOK_LPAREN);
		{
		if ((_tokenSet_3.member(LA(1)))) {
			expr();
			astFactory.addASTChild(currentAST, returnAST);
			{
			_loop339:
			do {
				if ((LA(1)==TOK_COMMA)) {
					AST tmp124_AST = null;
					tmp124_AST = astFactory.create(LT(1));
					astFactory.addASTChild(currentAST, tmp124_AST);
					match(TOK_COMMA);
					expr();
					astFactory.addASTChild(currentAST, returnAST);
				}
				else {
					break _loop339;
				}
				
			} while (true);
			}
		}
		else if ((LA(1)==TOK_RPAREN)) {
		}
		else {
			throw new NoViableAltException(LT(1), getFilename());
		}
		
		}
		AST tmp125_AST = null;
		tmp125_AST = astFactory.create(LT(1));
		astFactory.addASTChild(currentAST, tmp125_AST);
		match(TOK_RPAREN);
		argList_AST = (AST)currentAST.root;
		returnAST = argList_AST;
	}
	
	public final void conversionExpr() throws RecognitionException, TokenStreamException {
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST conversionExpr_AST = null;
		
		{
		switch ( LA(1)) {
		case LITERAL_listtoset:
		{
			AST tmp126_AST = null;
			tmp126_AST = astFactory.create(LT(1));
			astFactory.addASTChild(currentAST, tmp126_AST);
			match(LITERAL_listtoset);
			break;
		}
		case LITERAL_element:
		{
			AST tmp127_AST = null;
			tmp127_AST = astFactory.create(LT(1));
			astFactory.addASTChild(currentAST, tmp127_AST);
			match(LITERAL_element);
			break;
		}
		case LITERAL_distinct:
		{
			AST tmp128_AST = null;
			tmp128_AST = astFactory.create(LT(1));
			astFactory.addASTChild(currentAST, tmp128_AST);
			match(LITERAL_distinct);
			break;
		}
		case LITERAL_flatten:
		{
			AST tmp129_AST = null;
			tmp129_AST = astFactory.create(LT(1));
			astFactory.addASTChild(currentAST, tmp129_AST);
			match(LITERAL_flatten);
			break;
		}
		default:
		{
			throw new NoViableAltException(LT(1), getFilename());
		}
		}
		}
		AST tmp130_AST = null;
		tmp130_AST = astFactory.create(LT(1));
		astFactory.addASTChild(currentAST, tmp130_AST);
		match(TOK_LPAREN);
		query();
		astFactory.addASTChild(currentAST, returnAST);
		AST tmp131_AST = null;
		tmp131_AST = astFactory.create(LT(1));
		astFactory.addASTChild(currentAST, tmp131_AST);
		match(TOK_RPAREN);
		conversionExpr_AST = (AST)currentAST.root;
		returnAST = conversionExpr_AST;
	}
	
	public final void collectionExpr() throws RecognitionException, TokenStreamException {
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST collectionExpr_AST = null;
		
		{
		switch ( LA(1)) {
		case LITERAL_first:
		{
			AST tmp132_AST = null;
			tmp132_AST = astFactory.create(LT(1));
			astFactory.addASTChild(currentAST, tmp132_AST);
			match(LITERAL_first);
			break;
		}
		case LITERAL_last:
		{
			AST tmp133_AST = null;
			tmp133_AST = astFactory.create(LT(1));
			astFactory.addASTChild(currentAST, tmp133_AST);
			match(LITERAL_last);
			break;
		}
		case LITERAL_unique:
		{
			AST tmp134_AST = null;
			tmp134_AST = astFactory.create(LT(1));
			astFactory.addASTChild(currentAST, tmp134_AST);
			match(LITERAL_unique);
			break;
		}
		case LITERAL_exists:
		{
			AST tmp135_AST = null;
			tmp135_AST = astFactory.create(LT(1));
			astFactory.addASTChild(currentAST, tmp135_AST);
			match(LITERAL_exists);
			break;
		}
		default:
		{
			throw new NoViableAltException(LT(1), getFilename());
		}
		}
		}
		AST tmp136_AST = null;
		tmp136_AST = astFactory.create(LT(1));
		astFactory.addASTChild(currentAST, tmp136_AST);
		match(TOK_LPAREN);
		query();
		astFactory.addASTChild(currentAST, returnAST);
		AST tmp137_AST = null;
		tmp137_AST = astFactory.create(LT(1));
		astFactory.addASTChild(currentAST, tmp137_AST);
		match(TOK_RPAREN);
		collectionExpr_AST = (AST)currentAST.root;
		returnAST = collectionExpr_AST;
	}
	
	public final void objectConstruction() throws RecognitionException, TokenStreamException {
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST objectConstruction_AST = null;
		
		typeIdentifier();
		astFactory.addASTChild(currentAST, returnAST);
		AST tmp138_AST = null;
		tmp138_AST = astFactory.create(LT(1));
		astFactory.addASTChild(currentAST, tmp138_AST);
		match(TOK_LPAREN);
		fieldList();
		astFactory.addASTChild(currentAST, returnAST);
		AST tmp139_AST = null;
		tmp139_AST = astFactory.create(LT(1));
		astFactory.addASTChild(currentAST, tmp139_AST);
		match(TOK_RPAREN);
		objectConstruction_AST = (AST)currentAST.root;
		returnAST = objectConstruction_AST;
	}
	
	public final void typeIdentifier() throws RecognitionException, TokenStreamException {
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST typeIdentifier_AST = null;
		
		AST tmp140_AST = null;
		tmp140_AST = astFactory.create(LT(1));
		astFactory.addASTChild(currentAST, tmp140_AST);
		match(Identifier);
		typeIdentifier_AST = (AST)currentAST.root;
		returnAST = typeIdentifier_AST;
	}
	
	public final void fieldList() throws RecognitionException, TokenStreamException {
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST fieldList_AST = null;
		
		labelIdentifier();
		astFactory.addASTChild(currentAST, returnAST);
		AST tmp141_AST = null;
		tmp141_AST = astFactory.create(LT(1));
		astFactory.addASTChild(currentAST, tmp141_AST);
		match(TOK_COLON);
		expr();
		astFactory.addASTChild(currentAST, returnAST);
		{
		_loop354:
		do {
			if ((LA(1)==TOK_COMMA)) {
				AST tmp142_AST = null;
				tmp142_AST = astFactory.create(LT(1));
				astFactory.addASTChild(currentAST, tmp142_AST);
				match(TOK_COMMA);
				labelIdentifier();
				astFactory.addASTChild(currentAST, returnAST);
				AST tmp143_AST = null;
				tmp143_AST = astFactory.create(LT(1));
				astFactory.addASTChild(currentAST, tmp143_AST);
				match(TOK_COLON);
				expr();
				astFactory.addASTChild(currentAST, returnAST);
			}
			else {
				break _loop354;
			}
			
		} while (true);
		}
		fieldList_AST = (AST)currentAST.root;
		returnAST = fieldList_AST;
	}
	
	public final void structConstruction() throws RecognitionException, TokenStreamException {
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST structConstruction_AST = null;
		
		AST tmp144_AST = null;
		tmp144_AST = astFactory.create(LT(1));
		astFactory.addASTChild(currentAST, tmp144_AST);
		match(LITERAL_struct);
		AST tmp145_AST = null;
		tmp145_AST = astFactory.create(LT(1));
		astFactory.addASTChild(currentAST, tmp145_AST);
		match(TOK_LPAREN);
		fieldList();
		astFactory.addASTChild(currentAST, returnAST);
		AST tmp146_AST = null;
		tmp146_AST = astFactory.create(LT(1));
		astFactory.addASTChild(currentAST, tmp146_AST);
		match(TOK_RPAREN);
		structConstruction_AST = (AST)currentAST.root;
		returnAST = structConstruction_AST;
	}
	
	public final void objectLiteral() throws RecognitionException, TokenStreamException {
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST objectLiteral_AST = null;
		
		AST tmp147_AST = null;
		tmp147_AST = astFactory.create(LT(1));
		astFactory.addASTChild(currentAST, tmp147_AST);
		match(LITERAL_nil);
		objectLiteral_AST = (AST)currentAST.root;
		if(lastEQop!=null)
				lastEQop.setText(is); 
			objectLiteral_AST.setText("null"); 
			((OQLAST)objectLiteral_AST).makumbaType="nil";
			
		objectLiteral_AST = (AST)currentAST.root;
		returnAST = objectLiteral_AST;
	}
	
	public final void booleanLiteral() throws RecognitionException, TokenStreamException {
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST booleanLiteral_AST = null;
		
		{
		if ((LA(1)==LITERAL_true)) {
			AST tmp148_AST = null;
			tmp148_AST = astFactory.create(LT(1));
			astFactory.addASTChild(currentAST, tmp148_AST);
			match(LITERAL_true);
		}
		else if ((LA(1)==LITERAL_false)) {
			AST tmp149_AST = null;
			tmp149_AST = astFactory.create(LT(1));
			astFactory.addASTChild(currentAST, tmp149_AST);
			match(LITERAL_false);
		}
		else {
			throw new NoViableAltException(LT(1), getFilename());
		}
		
		}
		booleanLiteral_AST = (AST)currentAST.root;
		returnAST = booleanLiteral_AST;
	}
	
	public final void longLiteral() throws RecognitionException, TokenStreamException {
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST longLiteral_AST = null;
		
		AST tmp150_AST = null;
		tmp150_AST = astFactory.create(LT(1));
		astFactory.addASTChild(currentAST, tmp150_AST);
		match(TOK_UNSIGNED_INTEGER);
		longLiteral_AST = (AST)currentAST.root;
		returnAST = longLiteral_AST;
	}
	
	public final void doubleLiteral() throws RecognitionException, TokenStreamException {
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST doubleLiteral_AST = null;
		
		{
		if ((LA(1)==TOK_APPROXIMATE_NUMERIC_LITERAL)) {
			AST tmp151_AST = null;
			tmp151_AST = astFactory.create(LT(1));
			astFactory.addASTChild(currentAST, tmp151_AST);
			match(TOK_APPROXIMATE_NUMERIC_LITERAL);
		}
		else if ((LA(1)==TOK_EXACT_NUMERIC_LITERAL)) {
			AST tmp152_AST = null;
			tmp152_AST = astFactory.create(LT(1));
			astFactory.addASTChild(currentAST, tmp152_AST);
			match(TOK_EXACT_NUMERIC_LITERAL);
		}
		else {
			throw new NoViableAltException(LT(1), getFilename());
		}
		
		}
		doubleLiteral_AST = (AST)currentAST.root;
		returnAST = doubleLiteral_AST;
	}
	
	public final void charLiteral() throws RecognitionException, TokenStreamException {
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST charLiteral_AST = null;
		
		AST tmp153_AST = null;
		tmp153_AST = astFactory.create(LT(1));
		astFactory.addASTChild(currentAST, tmp153_AST);
		match(CharLiteral);
		charLiteral_AST = (AST)currentAST.root;
		returnAST = charLiteral_AST;
	}
	
	public final void stringLiteral() throws RecognitionException, TokenStreamException {
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST stringLiteral_AST = null;
		
		AST tmp154_AST = null;
		tmp154_AST = astFactory.create(LT(1));
		astFactory.addASTChild(currentAST, tmp154_AST);
		match(StringLiteral);
		stringLiteral_AST = (AST)currentAST.root;
		returnAST = stringLiteral_AST;
	}
	
	public final void dateLiteral() throws RecognitionException, TokenStreamException {
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST dateLiteral_AST = null;
		Token  sl = null;
		AST sl_AST = null;
		
		match(LITERAL_date);
		sl = LT(1);
		sl_AST = astFactory.create(sl);
		match(StringLiteral);
		dateLiteral_AST = (AST)currentAST.root;
		
			   dateLiteral_AST=(sl_AST);
			   sl_AST.setText(sl_AST.getText().replace('\"', '\''));
			
		currentAST.root = dateLiteral_AST;
		currentAST.child = dateLiteral_AST!=null &&dateLiteral_AST.getFirstChild()!=null ?
			dateLiteral_AST.getFirstChild() : dateLiteral_AST;
		currentAST.advanceChildToEnd();
		returnAST = dateLiteral_AST;
	}
	
	public final void timeLiteral() throws RecognitionException, TokenStreamException {
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST timeLiteral_AST = null;
		
		AST tmp156_AST = null;
		tmp156_AST = astFactory.create(LT(1));
		astFactory.addASTChild(currentAST, tmp156_AST);
		match(LITERAL_time);
		AST tmp157_AST = null;
		tmp157_AST = astFactory.create(LT(1));
		astFactory.addASTChild(currentAST, tmp157_AST);
		match(StringLiteral);
		timeLiteral_AST = (AST)currentAST.root;
		returnAST = timeLiteral_AST;
	}
	
	public final void timestampLiteral() throws RecognitionException, TokenStreamException {
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST timestampLiteral_AST = null;
		
		AST tmp158_AST = null;
		tmp158_AST = astFactory.create(LT(1));
		astFactory.addASTChild(currentAST, tmp158_AST);
		match(LITERAL_timestamp);
		AST tmp159_AST = null;
		tmp159_AST = astFactory.create(LT(1));
		astFactory.addASTChild(currentAST, tmp159_AST);
		match(StringLiteral);
		timestampLiteral_AST = (AST)currentAST.root;
		returnAST = timestampLiteral_AST;
	}
	
	
	public static final String[] _tokenNames = {
		"<0>",
		"EOF",
		"<2>",
		"NULL_TREE_LOOKAHEAD",
		"right parenthesis",
		"left parenthesis",
		"comma",
		"semicolon",
		"TOK_DOTDOT",
		"TOK_COLON",
		"dot",
		"dot",
		"operator",
		"comparison operator",
		"operator",
		"operator",
		"operator",
		"operator",
		"comparison operator",
		"comparison operator",
		"comparison operator",
		"comparison operator",
		"comparison operator",
		"left bracket",
		"right bracket",
		"TOK_DOLLAR",
		"NameFirstCharacter",
		"NameCharacter",
		"Identifier",
		"TOK_UNSIGNED_INTEGER",
		"TOK_APPROXIMATE_NUMERIC_LITERAL",
		"numeric value",
		"character string",
		"character string",
		"WhiteSpace",
		"NewLine",
		"CommentLine",
		"MultiLineComment",
		"\"import\"",
		"\"as\"",
		"\"define\"",
		"\"query\"",
		"\"undefine\"",
		"\"select\"",
		"\"distinct\"",
		"\"from\"",
		"\"left\"",
		"\"join\"",
		"\"in\"",
		"\"where\"",
		"TOK_LPAR",
		"TOK_LRAR",
		"\"group\"",
		"\"by\"",
		"\"having\"",
		"\"order\"",
		"\"asc\"",
		"\"desc\"",
		"\"or\"",
		"\"and\"",
		"\"for\"",
		"\"all\"",
		"\"exists\"",
		"\"any\"",
		"\"some\"",
		"\"like\"",
		"\"union\"",
		"\"except\"",
		"\"mod\"",
		"\"intersect\"",
		"\"abs\"",
		"\"not\"",
		"\"listtoset\"",
		"\"element\"",
		"\"flatten\"",
		"\"first\"",
		"\"last\"",
		"\"unique\"",
		"\"sum\"",
		"\"min\"",
		"\"max\"",
		"\"avg\"",
		"\"count\"",
		"\"is_undefined\"",
		"\"is_defined\"",
		"\"struct\"",
		"\"array\"",
		"\"set\"",
		"\"bag\"",
		"\"list\"",
		"\"unsigned\"",
		"\"short\"",
		"\"long\"",
		"\"float\"",
		"\"double\"",
		"\"char\"",
		"\"string\"",
		"\"boolean\"",
		"\"octet\"",
		"\"date\"",
		"\"time\"",
		"\"interval\"",
		"\"timestamp\"",
		"\"dictionary\"",
		"\"nil\"",
		"\"true\"",
		"\"false\""
	};
	
	protected void buildTokenTypeASTClassMap() {
		tokenTypeToASTClassMap=null;
	};
	
	private static final long[] mk_tokenSet_0() {
		long[] data = { 5764622108508340256L, 8074603512000L, 0L, 0L};
		return data;
	}
	public static final BitSet _tokenSet_0 = new BitSet(mk_tokenSet_0());
	private static final long[] mk_tokenSet_1() {
		long[] data = { 5764616336072294432L, 8074603512000L, 0L, 0L};
		return data;
	}
	public static final BitSet _tokenSet_1 = new BitSet(mk_tokenSet_1());
	private static final long[] mk_tokenSet_2() {
		long[] data = { 5764622108508340258L, 8074603512000L, 0L, 0L};
		return data;
	}
	public static final BitSet _tokenSet_2 = new BitSet(mk_tokenSet_2());
	private static final long[] mk_tokenSet_3() {
		long[] data = { 5764607539979272224L, 8074603512000L, 0L, 0L};
		return data;
	}
	public static final BitSet _tokenSet_3 = new BitSet(mk_tokenSet_3());
	private static final long[] mk_tokenSet_4() {
		long[] data = { 5764622108508340386L, 8074603512000L, 0L, 0L};
		return data;
	}
	public static final BitSet _tokenSet_4 = new BitSet(mk_tokenSet_4());
	private static final long[] mk_tokenSet_5() {
		long[] data = { 272629824L, 402653184L, 0L, 0L};
		return data;
	}
	public static final BitSet _tokenSet_5 = new BitSet(mk_tokenSet_5());
	private static final long[] mk_tokenSet_6() {
		long[] data = { 5765733439886114848L, 8074603512000L, 0L, 0L};
		return data;
	}
	public static final BitSet _tokenSet_6 = new BitSet(mk_tokenSet_6());
	private static final long[] mk_tokenSet_7() {
		long[] data = { 5805717455108096178L, 8074603512000L, 0L, 0L};
		return data;
	}
	public static final BitSet _tokenSet_7 = new BitSet(mk_tokenSet_7());
	private static final long[] mk_tokenSet_8() {
		long[] data = { 5805154505154674866L, 8074603512000L, 0L, 0L};
		return data;
	}
	public static final BitSet _tokenSet_8 = new BitSet(mk_tokenSet_8());
	private static final long[] mk_tokenSet_9() {
		long[] data = { 5800650905527304370L, 8074603512000L, 0L, 0L};
		return data;
	}
	public static final BitSet _tokenSet_9 = new BitSet(mk_tokenSet_9());
	private static final long[] mk_tokenSet_10() {
		long[] data = { 5764622108508340402L, 8074603512000L, 0L, 0L};
		return data;
	}
	public static final BitSet _tokenSet_10 = new BitSet(mk_tokenSet_10());
	private static final long[] mk_tokenSet_11() {
		long[] data = { 550024252416L, 0L};
		return data;
	}
	public static final BitSet _tokenSet_11 = new BitSet(mk_tokenSet_11());
	private static final long[] mk_tokenSet_12() {
		long[] data = { 5805752639480185074L, 8074603512000L, 0L, 0L};
		return data;
	}
	public static final BitSet _tokenSet_12 = new BitSet(mk_tokenSet_12());
	private static final long[] mk_tokenSet_13() {
		long[] data = { 9220908872884027378L, 8074603512062L, 0L, 0L};
		return data;
	}
	public static final BitSet _tokenSet_13 = new BitSet(mk_tokenSet_13());
	private static final long[] mk_tokenSet_14() {
		long[] data = { 16945037344L, 8074603512000L, 0L, 0L};
		return data;
	}
	public static final BitSet _tokenSet_14 = new BitSet(mk_tokenSet_14());
	private static final long[] mk_tokenSet_15() {
		long[] data = { 7077888L, 0L};
		return data;
	}
	public static final BitSet _tokenSet_15 = new BitSet(mk_tokenSet_15());
	private static final long[] mk_tokenSet_16() {
		long[] data = { 53248L, 12L, 0L, 0L};
		return data;
	}
	public static final BitSet _tokenSet_16 = new BitSet(mk_tokenSet_16());
	private static final long[] mk_tokenSet_17() {
		long[] data = { 196608L, 48L, 0L, 0L};
		return data;
	}
	public static final BitSet _tokenSet_17 = new BitSet(mk_tokenSet_17());
	private static final long[] mk_tokenSet_18() {
		long[] data = { 6904631498322736114L, 8074603512062L, 0L, 0L};
		return data;
	}
	public static final BitSet _tokenSet_18 = new BitSet(mk_tokenSet_18());
	private static final long[] mk_tokenSet_19() {
		long[] data = { 49152L, 192L, 0L, 0L};
		return data;
	}
	public static final BitSet _tokenSet_19 = new BitSet(mk_tokenSet_19());
	
	}
